/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.error;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.atmp.ImageBuilder;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.eggs.PSystemWelcome;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColorSimple;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.GraphicPosition;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockRaw;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.version.Version;

public abstract class PSystemError
extends PlainDiagram {
    private static boolean disableTimeBasedErrorDecorations = false;
    protected List<StringLocated> trace;
    protected ErrorUml singleError;

    public static void disableTimeBasedErrorDecorations() {
        disableTimeBasedErrorDecorations = true;
    }

    public PSystemError(UmlSource source) {
        super(source);
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return super.createImageBuilder(fileFormatOption).blackBackcolor().randomPixel().status(400);
    }

    protected final StringLocated getLastLine() {
        return this.trace.get(this.trace.size() - 1);
    }

    public final LineLocation getLineLocation() {
        return this.getLastLine().getLocation();
    }

    public final Collection<ErrorUml> getErrorsUml() {
        return Collections.singleton(this.singleError);
    }

    public final ErrorUml getFirstError() {
        return this.singleError;
    }

    @Override
    public final String getWarningOrError() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDescription());
        sb.append('\n');
        for (CharSequence t2 : this.getTitle().getDisplay()) {
            sb.append(t2);
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    private TextBlock getGraphicalFormatted() {
        FontConfiguration fc0 = GraphicStrings.sansSerif14(HColors.BLACK).bold();
        FontConfiguration fc1 = GraphicStrings.sansSerif14(HColors.MY_GREEN).bold();
        FontConfiguration fc2 = GraphicStrings.sansSerif14(HColors.RED).bold();
        FontConfiguration fc4 = GraphicStrings.sansSerif12(HColors.MY_GREEN).bold().italic();
        List<String> fullBody = this.getTextFullBody();
        TextBlock result0 = TextBlockUtils.addBackcolor(TextBlockUtils.withMargin(new TextBlockRaw(this.getTextFromStack(), fc0), 1.0, 1.0, 1.0, 4.0), HColors.MY_GREEN);
        TextBlockRaw result1 = new TextBlockRaw(this.allButLast(fullBody), fc1);
        TextBlockRaw result2 = new TextBlockRaw(this.onlyLast(fullBody), fc1.wave(HColors.RED));
        TextBlockRaw result3 = new TextBlockRaw(this.getTextError(), fc2);
        TextBlock result4 = TextBlockUtils.withMargin(new TextBlockRaw(this.header(), fc4), 0.0, 2.0, 0.0, 8.0);
        TextBlock result = result0;
        result = TextBlockUtils.mergeTB(result, result1, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, result2, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, result3, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result4, result, HorizontalAlignment.LEFT);
        result = TextBlockUtils.withMargin(result, 5.0, 5.0);
        return TextBlockUtils.addBackcolor(result, HColors.BLACK);
    }

    private List<String> header() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("PlantUML " + Version.versionString());
        GraphvizCrash.checkOldVersionWarning(result);
        return result;
    }

    public List<String> getPureAsciiFormatted() {
        List<String> result = this.getTextFromStack();
        result.addAll(this.getTextFullBody());
        result.add("^^^^^");
        result.addAll(this.getTextError());
        return result;
    }

    private List<String> getTextFromStack() {
        LineLocation lineLocation = this.getLineLocation();
        ArrayList<String> result = new ArrayList<String>();
        if (lineLocation != null) {
            this.append(result, lineLocation);
            while (lineLocation.getParent() != null) {
                lineLocation = lineLocation.getParent();
                this.append(result, lineLocation);
            }
        }
        return result;
    }

    protected List<String> getTextFullBody() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(" ");
        int traceSize = this.trace.size();
        if (traceSize > 40) {
            for (StringLocated stringLocated : this.trace.subList(0, 5)) {
                this.addToResult(result, stringLocated);
            }
            result.add("...");
            int skipped = traceSize - 5 - 20;
            result.add("... ( skipping " + skipped + " lines )");
            result.add("...");
            for (StringLocated s3 : this.trace.subList(traceSize - 20, traceSize)) {
                this.addToResult(result, s3);
            }
        } else {
            for (StringLocated stringLocated : this.trace) {
                this.addToResult(result, stringLocated);
            }
        }
        return result;
    }

    private void addToResult(List<String> result, StringLocated s2) {
        String tmp = s2.getString();
        if (tmp.length() > 120) {
            tmp = tmp.substring(0, 120) + " ...";
        }
        result.add(tmp);
    }

    private List<String> getTextError() {
        return Arrays.asList(" " + this.singleError.getError());
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT || fileFormat.getFileFormat() == FileFormat.UTXT) {
            UGraphicTxt ugt = new UGraphicTxt();
            UmlCharArea area = ugt.getCharArea();
            area.drawStringsLRSimple(this.getPureAsciiFormatted(), 0, 0);
            area.print(SecurityUtils.createPrintStream(os));
            return new ImageDataSimple(1, 1);
        }
        return super.exportDiagramNow(os, num, fileFormat);
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        TextBlock result = this.getGraphicalFormatted();
        TextBlock udrawable = this.getSource().getTotalLineCountLessThan5() ? this.addWelcome(result) : result;
        int min2 = (int)(System.currentTimeMillis() / 60000L) % 60;
        if (!disableTimeBasedErrorDecorations) {
            if (min2 == 1 || min2 == 8 || min2 == 13 || min2 == 55) {
                udrawable = this.addMessagePatreon(udrawable);
            } else if (min2 == 15) {
                udrawable = this.addMessageLiberapay(udrawable);
            } else if (min2 == 30 || min2 == 39 || min2 == 48) {
                udrawable = this.addMessageDedication(udrawable);
            } else if (this.getSource().containsIgnoreCase("arecibo")) {
                udrawable = this.addMessageArecibo(udrawable);
            }
        }
        return udrawable;
    }

    private void append(List<String> result, LineLocation lineLocation) {
        if (lineLocation.getDescription() != null) {
            result.add("[From " + lineLocation.getDescription() + " (line " + (lineLocation.getPosition() + 1) + ") ]");
        }
    }

    @Override
    public final DiagramDescription getDescription() {
        return new DiagramDescription("(Error)");
    }

    private List<String> allButLast(List<String> full) {
        return full.subList(0, full.size() - 1);
    }

    private List<String> onlyLast(List<String> full) {
        return full.subList(full.size() - 1, full.size());
    }

    private TextBlock getWelcome() throws IOException {
        return new PSystemWelcome(this.getSource(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT).getGraphicStrings();
    }

    private TextBlock addWelcome(TextBlock result) throws IOException {
        TextBlock welcome = this.getWelcome();
        return TextBlockUtils.mergeTB(welcome, result, HorizontalAlignment.LEFT);
    }

    private TextBlock addMessageLiberapay(TextBlock source) throws IOException {
        if (LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            return source;
        }
        TextBlock message = this.getMessageLiberapay();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, message, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessagePatreon(TextBlock source) throws IOException {
        if (LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            return source;
        }
        TextBlock message = this.getMessagePatreon();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, message, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessageDedication(TextBlock source) throws IOException {
        if (LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            return source;
        }
        TextBlock message = this.getMessageDedication();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessageAdopt(TextBlock source) throws IOException {
        if (LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            return source;
        }
        TextBlock message = this.getMessageAdopt();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessageArecibo(TextBlock source) throws IOException {
        UImage message = new UImage(new PixelImage(PSystemVersion.getArecibo(), AffineTransformType.TYPE_BILINEAR));
        TextBlock result = TextBlockUtils.mergeLR(source, TextBlockUtils.fromUImage(message), VerticalAlignment.TOP);
        return result;
    }

    private TextBlock getMessageDedication() {
        TextBlock result;
        HColorSimple backColor = (HColorSimple)HColorSet.instance().getColorOrWhite("#eae2c9");
        BufferedImage qrcode = this.smaller(FlashCodeFactory.getFlashCodeUtils().exportFlashcode("https://plantuml.com/dedication", Color.BLACK, backColor.getAwtColor()));
        Display disp = Display.create("<b>Add your own dedication into PlantUML", " ", "For just $5 per month!", "Details on <i>[[https://plantuml.com/dedication]]");
        UFont font = UFont.sansSerif(14);
        FontConfiguration fc = FontConfiguration.create(font, HColors.BLACK, HColors.BLACK, null);
        TextBlock text = TextBlockUtils.withMargin(disp.create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty()), 10.0, 0.0);
        if (qrcode == null) {
            result = text;
        } else {
            UImage qr = new UImage(new PixelImage(qrcode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(3.0);
            result = TextBlockUtils.mergeLR(text, TextBlockUtils.fromUImage(qr), VerticalAlignment.CENTER);
        }
        return TextBlockUtils.addBackcolor(result, backColor);
    }

    private TextBlock getMessageAdopt() {
        TextBlock text;
        HColor backColor = HColorSet.instance().getColorOrWhite("#eff4d2");
        Display disp = Display.create("<b>Adopt-a-Word and put your message here!", " ", "Details on <i>[[https://plantuml.com/adopt]]", " ");
        UFont font = UFont.sansSerif(14);
        FontConfiguration fc = FontConfiguration.create(font, HColors.BLACK, HColors.BLACK, null);
        TextBlock result = text = TextBlockUtils.withMargin(disp.create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty()), 10.0, 0.0);
        return TextBlockUtils.addBackcolor(result, backColor);
    }

    private TextBlock getMessagePatreon() {
        double imHeight;
        double imWidth;
        final UImage message = new UImage(new PixelImage(PSystemVersion.getTime01(), AffineTransformType.TYPE_BILINEAR));
        Color back = new Color(message.getImage(1.0).getRGB(0, 0));
        final HColor backColor = HColors.simple(back);
        final BufferedImage qrcode = this.smaller(FlashCodeFactory.getFlashCodeUtils().exportFlashcode("https://plantuml.com/patreon", Color.BLACK, Color.WHITE));
        int scale = 2;
        if (qrcode == null) {
            imWidth = message.getWidth();
            imHeight = message.getHeight();
        } else {
            imWidth = message.getWidth() + qrcode.getWidth() * 2 + 20;
            imHeight = Math.max(message.getHeight(), qrcode.getHeight() * 2 + 10);
        }
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                if (qrcode == null) {
                    ug.apply(new UTranslate(1.0, 1.0)).draw(message);
                } else {
                    UImage qr = new UImage(new PixelImage(qrcode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(2.0);
                    ug.apply(new UTranslate(1.0, (imHeight - (double)message.getHeight()) / 2.0)).draw(message);
                    ug.apply(new UTranslate(1 + message.getWidth(), (imHeight - (double)qr.getHeight()) / 2.0)).draw(qr);
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return MinMax.fromMax(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public HColor getBackcolor() {
                return backColor;
            }
        };
    }

    private TextBlock getMessageLiberapay() {
        double imHeight;
        double imWidth;
        final UImage message = new UImage(new PixelImage(PSystemVersion.getTime15(), AffineTransformType.TYPE_BILINEAR));
        Color back = new Color(message.getImage(1.0).getRGB(0, 0));
        final HColor backColor = HColors.simple(back);
        final BufferedImage qrcode = this.smaller(FlashCodeFactory.getFlashCodeUtils().exportFlashcode("https://plantuml.com/lp", Color.BLACK, Color.WHITE));
        int scale = 2;
        if (qrcode == null) {
            imWidth = message.getWidth();
            imHeight = message.getHeight();
        } else {
            imWidth = message.getWidth() + qrcode.getWidth() * 2 + 20;
            imHeight = Math.max(message.getHeight(), qrcode.getHeight() * 2 + 10);
        }
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                if (qrcode == null) {
                    ug.apply(new UTranslate(1.0, 1.0)).draw(message);
                } else {
                    UImage qr = new UImage(new PixelImage(qrcode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(2.0);
                    ug.apply(new UTranslate(1.0, (imHeight - (double)message.getHeight()) / 2.0)).draw(message);
                    ug.apply(new UTranslate(1 + message.getWidth(), (imHeight - (double)qr.getHeight()) / 2.0)).draw(qr);
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return MinMax.fromMax(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public HColor getBackcolor() {
                return backColor;
            }
        };
    }

    public int score() {
        int result = this.trace.size() * 10 + this.singleError.score();
        return result;
    }

    private BufferedImage smaller(BufferedImage im) {
        if (im == null) {
            return null;
        }
        boolean nb = true;
        return im.getSubimage(1, 1, im.getWidth() - 2, im.getHeight() - 2);
    }
}

