/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.ConstantPool;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.AttributeBootstrapMethods;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.attribute.BootstrapMethod;
import org.jd.core.v1.model.classfile.constant.Constant;
import org.jd.core.v1.model.classfile.constant.ConstantClass;
import org.jd.core.v1.model.classfile.constant.ConstantDouble;
import org.jd.core.v1.model.classfile.constant.ConstantFloat;
import org.jd.core.v1.model.classfile.constant.ConstantInteger;
import org.jd.core.v1.model.classfile.constant.ConstantLong;
import org.jd.core.v1.model.classfile.constant.ConstantMemberRef;
import org.jd.core.v1.model.classfile.constant.ConstantMethodHandle;
import org.jd.core.v1.model.classfile.constant.ConstantMethodType;
import org.jd.core.v1.model.classfile.constant.ConstantNameAndType;
import org.jd.core.v1.model.classfile.constant.ConstantString;
import org.jd.core.v1.model.classfile.constant.ConstantUtf8;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AbstractNopDeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameters;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.InstanceOfExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LengthExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileClassDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileCmpExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileMonitorEnterStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileMonitorExitStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.PrimitiveLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.NewArrayMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.StringConcatenationUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeParametersToTypeArgumentsBinder;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.util.DefaultList;
import org.jd.core.v1.util.DefaultStack;

public class ByteCodeParser {
    private static final JsrReturnAddressExpression JSR_RETURN_ADDRESS_EXPRESSION = new JsrReturnAddressExpression();
    private MemberVisitor memberVisitor = new MemberVisitor();
    private SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    private TypeMaker typeMaker;
    private LocalVariableMaker localVariableMaker;
    private String internalTypeName;
    private TypeParametersToTypeArgumentsBinder typeParametersToTypeArgumentsBinder;
    private AttributeBootstrapMethods attributeBootstrapMethods;
    private ClassFileBodyDeclaration bodyDeclaration;
    private Map<String, BaseType> typeBounds;
    private Type returnedType;

    public ByteCodeParser(TypeMaker typeMaker, LocalVariableMaker localVariableMaker, ClassFile classFile, ClassFileBodyDeclaration bodyDeclaration, ClassFileConstructorOrMethodDeclaration comd) {
        this.typeMaker = typeMaker;
        this.localVariableMaker = localVariableMaker;
        this.internalTypeName = classFile.getInternalTypeName();
        this.typeParametersToTypeArgumentsBinder = new TypeParametersToTypeArgumentsBinder(typeMaker, this.internalTypeName, comd);
        this.attributeBootstrapMethods = (AttributeBootstrapMethods)classFile.getAttribute("BootstrapMethods");
        this.bodyDeclaration = bodyDeclaration;
        this.returnedType = comd.getReturnedType();
        this.typeBounds = comd.getTypeBounds();
    }

    public void parse(BasicBlock basicBlock, Statements statements, DefaultStack<Expression> stack) {
        ControlFlowGraph cfg = basicBlock.getControlFlowGraph();
        int fromOffset = basicBlock.getFromOffset();
        int toOffset = basicBlock.getToOffset();
        Method method = cfg.getMethod();
        ConstantPool constants = method.getConstants();
        byte[] code = ((AttributeCode)method.getAttribute("Code")).getCode();
        boolean syntheticFlag = (method.getAccessFlags() & 0x1000) != 0;
        block146: for (int offset = fromOffset; offset < toOffset; ++offset) {
            int opcode = code[offset] & 0xFF;
            int lineNumber = syntheticFlag ? 0 : cfg.getLineNumber(offset);
            switch (opcode) {
                case 0: {
                    continue block146;
                }
                case 1: {
                    stack.push(new NullExpression(lineNumber, ObjectType.TYPE_UNDEFINED_OBJECT));
                    continue block146;
                }
                case 2: {
                    stack.push(new IntegerConstantExpression(lineNumber, PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE, -1));
                    continue block146;
                }
                case 3: 
                case 4: {
                    stack.push(new IntegerConstantExpression(lineNumber, PrimitiveType.MAYBE_BOOLEAN_TYPE, opcode - 3));
                    continue block146;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stack.push(new IntegerConstantExpression(lineNumber, PrimitiveType.MAYBE_BYTE_TYPE, opcode - 3));
                    continue block146;
                }
                case 9: 
                case 10: {
                    stack.push(new LongConstantExpression(lineNumber, opcode - 9));
                    continue block146;
                }
                case 11: 
                case 12: 
                case 13: {
                    stack.push(new FloatConstantExpression(lineNumber, opcode - 11));
                    continue block146;
                }
                case 14: 
                case 15: {
                    stack.push(new DoubleConstantExpression(lineNumber, opcode - 14));
                    continue block146;
                }
                case 16: {
                    short value = (short)(code[++offset] & 0xFF);
                    stack.push(new IntegerConstantExpression(lineNumber, PrimitiveTypeUtil.getPrimitiveTypeFromValue(value), value));
                    continue block146;
                }
                case 17: {
                    short value = (short)((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    stack.push(new IntegerConstantExpression(lineNumber, PrimitiveTypeUtil.getPrimitiveTypeFromValue(value), value));
                    continue block146;
                }
                case 18: {
                    this.parseLDC(stack, constants, lineNumber, (Constant)constants.getConstant(code[++offset] & 0xFF));
                    continue block146;
                }
                case 19: 
                case 20: {
                    this.parseLDC(stack, constants, lineNumber, (Constant)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF));
                    continue block146;
                }
                case 21: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(code[++offset] & 0xFF, offset);
                    ByteCodeParser.parseILOAD(statements, stack, lineNumber, localVariable);
                    continue block146;
                }
                case 22: 
                case 23: 
                case 24: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(code[++offset] & 0xFF, offset);
                    stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable));
                    continue block146;
                }
                case 25: {
                    int i = code[++offset] & 0xFF;
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(i, offset);
                    if (i == 0 && (method.getAccessFlags() & 8) == 0) {
                        stack.push(new ThisExpression(lineNumber, localVariable.getType()));
                        continue block146;
                    }
                    stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable));
                    continue block146;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 26, offset);
                    ByteCodeParser.parseILOAD(statements, stack, lineNumber, localVariable);
                    continue block146;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 30, offset);
                    stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable));
                    continue block146;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 34, offset);
                    stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable));
                    continue block146;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 38, offset);
                    stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable));
                    continue block146;
                }
                case 42: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(0, offset);
                    if ((method.getAccessFlags() & 8) == 0) {
                        stack.push(new ThisExpression(lineNumber, localVariable.getType()));
                        continue block146;
                    }
                    stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable));
                    continue block146;
                }
                case 43: 
                case 44: 
                case 45: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 42, offset);
                    stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable));
                    continue block146;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    stack.push(new ArrayExpression(lineNumber, arrayRef, indexRef));
                    continue block146;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    Expression valueRef = stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(code[++offset] & 0xFF, offset + 2, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, localVariable, valueRef);
                    continue block146;
                }
                case 58: {
                    Expression valueRef = stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(code[++offset] & 0xFF, offset + 1, valueRef);
                    this.parseASTORE(statements, stack, lineNumber, localVariable, valueRef);
                    continue block146;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    Expression valueRef = stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 59, offset + 1, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, localVariable, valueRef);
                    continue block146;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    Expression valueRef = stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 63, offset + 1, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, localVariable, valueRef);
                    continue block146;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    Expression valueRef = stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 67, offset + 1, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, localVariable, valueRef);
                    continue block146;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    Expression valueRef = stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 71, offset + 1, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, localVariable, valueRef);
                    continue block146;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    Expression valueRef = stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 75, offset + 1, valueRef);
                    this.parseASTORE(statements, stack, lineNumber, localVariable, valueRef);
                    continue block146;
                }
                case 79: {
                    Expression valueRef = stack.pop();
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    Type type1 = arrayRef.getType();
                    statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, type1.createType(type1.getDimension() - 1), new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block146;
                }
                case 80: {
                    Expression valueRef = stack.pop();
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block146;
                }
                case 81: {
                    Expression valueRef = stack.pop();
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_FLOAT, new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block146;
                }
                case 82: {
                    Expression valueRef = stack.pop();
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block146;
                }
                case 83: {
                    Expression valueRef = stack.pop();
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    Type type1 = arrayRef.getType();
                    Type type2 = type1.createType(type1.getDimension() > 0 ? type1.getDimension() - 1 : 0);
                    this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(type2, valueRef);
                    statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, type2, new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block146;
                }
                case 84: {
                    Expression valueRef = stack.pop();
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BYTE, new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block146;
                }
                case 85: {
                    Expression valueRef = stack.pop();
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_CHAR, new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block146;
                }
                case 86: {
                    Expression valueRef = stack.pop();
                    Expression indexRef = stack.pop();
                    Expression arrayRef = stack.pop();
                    statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_SHORT, new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block146;
                }
                case 87: 
                case 88: {
                    Expression expression1 = stack.pop();
                    Class<?> clazz = expression1.getClass();
                    if (clazz == ClassFileLocalVariableReferenceExpression.class || clazz == FieldReferenceExpression.class) continue block146;
                    this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(ObjectType.TYPE_OBJECT, expression1);
                    statements.add(new ExpressionStatement(expression1));
                    continue block146;
                }
                case 89: {
                    Expression expression1 = stack.pop();
                    stack.push(expression1);
                    stack.push(expression1);
                    continue block146;
                }
                case 90: {
                    Expression expression1 = stack.pop();
                    Expression expression2 = stack.pop();
                    stack.push(expression1);
                    stack.push(expression2);
                    stack.push(expression1);
                    continue block146;
                }
                case 91: {
                    Expression expression1 = stack.pop();
                    Expression expression2 = stack.pop();
                    Type type2 = expression2.getType();
                    if (PrimitiveType.TYPE_LONG.equals(type2) || PrimitiveType.TYPE_DOUBLE.equals(type2)) {
                        stack.push(expression1);
                        stack.push(expression2);
                        stack.push(expression1);
                        continue block146;
                    }
                    Expression expression3 = stack.pop();
                    stack.push(expression1);
                    stack.push(expression3);
                    stack.push(expression2);
                    stack.push(expression1);
                    continue block146;
                }
                case 92: {
                    Expression expression1 = stack.pop();
                    Type type1 = expression1.getType();
                    if (PrimitiveType.TYPE_LONG.equals(type1) || PrimitiveType.TYPE_DOUBLE.equals(type1)) {
                        stack.push(expression1);
                        stack.push(expression1);
                        continue block146;
                    }
                    Expression expression2 = stack.pop();
                    stack.push(expression2);
                    stack.push(expression1);
                    stack.push(expression2);
                    stack.push(expression1);
                    continue block146;
                }
                case 93: {
                    Expression expression1 = stack.pop();
                    Expression expression2 = stack.pop();
                    Type type1 = expression1.getType();
                    if (PrimitiveType.TYPE_LONG.equals(type1) || PrimitiveType.TYPE_DOUBLE.equals(type1)) {
                        stack.push(expression1);
                        stack.push(expression2);
                        stack.push(expression1);
                        continue block146;
                    }
                    Expression expression3 = stack.pop();
                    stack.push(expression2);
                    stack.push(expression1);
                    stack.push(expression3);
                    stack.push(expression2);
                    stack.push(expression1);
                    continue block146;
                }
                case 94: {
                    Expression expression3;
                    Type type2;
                    Expression expression1 = stack.pop();
                    Expression expression2 = stack.pop();
                    Type type1 = expression1.getType();
                    if (PrimitiveType.TYPE_LONG.equals(type1) || PrimitiveType.TYPE_DOUBLE.equals(type1)) {
                        type2 = expression2.getType();
                        if (PrimitiveType.TYPE_LONG.equals(type2) || PrimitiveType.TYPE_DOUBLE.equals(type2)) {
                            stack.push(expression1);
                            stack.push(expression2);
                            stack.push(expression1);
                            continue block146;
                        }
                        expression3 = stack.pop();
                        stack.push(expression1);
                        stack.push(expression3);
                        stack.push(expression2);
                        stack.push(expression1);
                        continue block146;
                    }
                    expression3 = stack.pop();
                    Type type3 = expression3.getType();
                    if (PrimitiveType.TYPE_LONG.equals(type3) || PrimitiveType.TYPE_DOUBLE.equals(type3)) {
                        stack.push(expression2);
                        stack.push(expression1);
                        stack.push(expression3);
                        stack.push(expression2);
                        stack.push(expression1);
                        continue block146;
                    }
                    Expression expression4 = stack.pop();
                    stack.push(expression2);
                    stack.push(expression1);
                    stack.push(expression4);
                    stack.push(expression3);
                    stack.push(expression2);
                    stack.push(expression1);
                    continue block146;
                }
                case 95: {
                    Expression expression1 = stack.pop();
                    Expression expression2 = stack.pop();
                    stack.push(expression1);
                    stack.push(expression2);
                    continue block146;
                }
                case 96: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerBinaryOperatorExpression(lineNumber, expression1, "+", expression2, 6));
                    continue block146;
                }
                case 97: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "+", expression2, 6));
                    continue block146;
                }
                case 98: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_FLOAT, expression1, "+", expression2, 6));
                    continue block146;
                }
                case 99: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, expression1, "+", expression2, 6));
                    continue block146;
                }
                case 100: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerBinaryOperatorExpression(lineNumber, expression1, "-", expression2, 6));
                    continue block146;
                }
                case 101: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "-", expression2, 6));
                    continue block146;
                }
                case 102: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_FLOAT, expression1, "-", expression2, 6));
                    continue block146;
                }
                case 103: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, expression1, "-", expression2, 6));
                    continue block146;
                }
                case 104: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerBinaryOperatorExpression(lineNumber, expression1, "*", expression2, 5));
                    continue block146;
                }
                case 105: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "*", expression2, 5));
                    continue block146;
                }
                case 106: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_FLOAT, expression1, "*", expression2, 5));
                    continue block146;
                }
                case 107: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, expression1, "*", expression2, 5));
                    continue block146;
                }
                case 108: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerBinaryOperatorExpression(lineNumber, expression1, "/", expression2, 5));
                    continue block146;
                }
                case 109: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "/", expression2, 5));
                    continue block146;
                }
                case 110: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_FLOAT, expression1, "/", expression2, 5));
                    continue block146;
                }
                case 111: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, expression1, "/", expression2, 5));
                    continue block146;
                }
                case 112: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerBinaryOperatorExpression(lineNumber, expression1, "%", expression2, 5));
                    continue block146;
                }
                case 113: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "%", expression2, 5));
                    continue block146;
                }
                case 114: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_FLOAT, expression1, "%", expression2, 5));
                    continue block146;
                }
                case 115: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, expression1, "%", expression2, 5));
                    continue block146;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    stack.push(this.newPreArithmeticOperatorExpression(lineNumber, "-", stack.pop()));
                    continue block146;
                }
                case 120: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerBinaryOperatorExpression(lineNumber, expression1, "<<", expression2, 7));
                    continue block146;
                }
                case 121: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "<<", expression2, 7));
                    continue block146;
                }
                case 122: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_INT, expression1, ">>", expression2, 7));
                    continue block146;
                }
                case 123: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, ">>", expression2, 7));
                    continue block146;
                }
                case 124: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerBinaryOperatorExpression(lineNumber, expression1, ">>>", expression2, 7));
                    continue block146;
                }
                case 125: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, ">>>", expression2, 7));
                    continue block146;
                }
                case 126: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerOrBooleanBinaryOperatorExpression(lineNumber, expression1, "&", expression2, 10));
                    continue block146;
                }
                case 127: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "&", expression2, 10));
                    continue block146;
                }
                case 128: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerOrBooleanBinaryOperatorExpression(lineNumber, expression1, "|", expression2, 12));
                    continue block146;
                }
                case 129: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "|", expression2, 12));
                    continue block146;
                }
                case 130: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerOrBooleanBinaryOperatorExpression(lineNumber, expression1, "^", expression2, 11));
                    continue block146;
                }
                case 131: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, expression1, "^", expression2, 11));
                    continue block146;
                }
                case 132: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(code[++offset] & 0xFF, offset);
                    this.parseIINC(statements, stack, lineNumber, localVariable, (byte)(code[++offset] & 0xFF));
                    continue block146;
                }
                case 133: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_LONG, stack.pop(), false));
                    continue block146;
                }
                case 134: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_FLOAT, stack.pop(), false));
                    continue block146;
                }
                case 135: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, stack.pop(), false));
                    continue block146;
                }
                case 136: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_INT, stack.pop()));
                    continue block146;
                }
                case 137: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_FLOAT, stack.pop()));
                    continue block146;
                }
                case 138: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, stack.pop(), false));
                    continue block146;
                }
                case 139: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_INT, stack.pop()));
                    continue block146;
                }
                case 140: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_LONG, stack.pop()));
                    continue block146;
                }
                case 141: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, stack.pop(), false));
                    continue block146;
                }
                case 142: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_INT, stack.pop()));
                    continue block146;
                }
                case 143: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_LONG, stack.pop()));
                    continue block146;
                }
                case 144: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_FLOAT, stack.pop()));
                    continue block146;
                }
                case 145: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_BYTE, stack.pop()));
                    continue block146;
                }
                case 146: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_CHAR, stack.pop()));
                    continue block146;
                }
                case 147: {
                    stack.push(new CastExpression(lineNumber, PrimitiveType.TYPE_SHORT, stack.pop()));
                    continue block146;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(new ClassFileCmpExpression(lineNumber, expression1, expression2));
                    continue block146;
                }
                case 153: {
                    this.parseIF(stack, lineNumber, basicBlock, "!=", "==", 8);
                    offset += 2;
                    continue block146;
                }
                case 154: {
                    this.parseIF(stack, lineNumber, basicBlock, "==", "!=", 8);
                    offset += 2;
                    continue block146;
                }
                case 155: {
                    this.parseIF(stack, lineNumber, basicBlock, ">=", "<", 7);
                    offset += 2;
                    continue block146;
                }
                case 156: {
                    this.parseIF(stack, lineNumber, basicBlock, "<", ">=", 7);
                    offset += 2;
                    continue block146;
                }
                case 157: {
                    this.parseIF(stack, lineNumber, basicBlock, "<=", ">", 7);
                    offset += 2;
                    continue block146;
                }
                case 158: {
                    this.parseIF(stack, lineNumber, basicBlock, ">", "<=", 7);
                    offset += 2;
                    continue block146;
                }
                case 159: 
                case 165: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerOrBooleanComparisonOperatorExpression(lineNumber, expression1, basicBlock.mustInverseCondition() ? "!=" : "==", expression2, 9));
                    offset += 2;
                    continue block146;
                }
                case 160: 
                case 166: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerOrBooleanComparisonOperatorExpression(lineNumber, expression1, basicBlock.mustInverseCondition() ? "==" : "!=", expression2, 9));
                    offset += 2;
                    continue block146;
                }
                case 161: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerComparisonOperatorExpression(lineNumber, expression1, basicBlock.mustInverseCondition() ? ">=" : "<", expression2, 8));
                    offset += 2;
                    continue block146;
                }
                case 162: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerComparisonOperatorExpression(lineNumber, expression1, basicBlock.mustInverseCondition() ? "<" : ">=", expression2, 8));
                    offset += 2;
                    continue block146;
                }
                case 163: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerComparisonOperatorExpression(lineNumber, expression1, basicBlock.mustInverseCondition() ? "<=" : ">", expression2, 8));
                    offset += 2;
                    continue block146;
                }
                case 164: {
                    Expression expression2 = stack.pop();
                    Expression expression1 = stack.pop();
                    stack.push(this.newIntegerComparisonOperatorExpression(lineNumber, expression1, basicBlock.mustInverseCondition() ? ">" : "<=", expression2, 8));
                    offset += 2;
                    continue block146;
                }
                case 168: {
                    stack.push(JSR_RETURN_ADDRESS_EXPRESSION);
                }
                case 167: {
                    offset += 2;
                    continue block146;
                }
                case 169: {
                    ++offset;
                    continue block146;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    statements.add(new SwitchStatement(stack.pop(), new DefaultList<SwitchStatement.Block>(high - low + 2)));
                    continue block146;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    statements.add(new SwitchStatement(stack.pop(), new DefaultList<SwitchStatement.Block>(count + 1)));
                    continue block146;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.parseXRETURN(statements, stack, lineNumber);
                    continue block146;
                }
                case 177: {
                    statements.add(ReturnStatement.RETURN);
                    continue block146;
                }
                case 178: {
                    this.parseGetStatic(stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    continue block146;
                }
                case 179: {
                    this.parsePutStatic(statements, stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    continue block146;
                }
                case 180: {
                    this.parseGetField(stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    continue block146;
                }
                case 181: {
                    this.parsePutField(statements, stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    continue block146;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Expression expression1;
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
                    ObjectType ot = this.typeMaker.makeFromDescriptorOrInternalTypeName(typeName);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(ot.getInternalName(), name, descriptor);
                    BaseExpression parameters = this.extractParametersFromStack(statements, stack, methodTypes.parameterTypes);
                    if (opcode == 184) {
                        expression1 = this.typeParametersToTypeArgumentsBinder.newMethodInvocationExpression(lineNumber, new ObjectTypeReferenceExpression(lineNumber, ot), ot, name, descriptor, methodTypes, parameters);
                        if (PrimitiveType.TYPE_VOID.equals(methodTypes.returnedType)) {
                            this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(ObjectType.TYPE_OBJECT, expression1);
                            statements.add(new ExpressionStatement(expression1));
                            continue block146;
                        }
                        stack.push(expression1);
                        continue block146;
                    }
                    expression1 = stack.pop();
                    if (expression1.getClass() == ClassFileLocalVariableReferenceExpression.class) {
                        ((ClassFileLocalVariableReferenceExpression)expression1).getLocalVariable().typeOnLeft(this.typeBounds, ot);
                    }
                    if (opcode == 185) {
                        offset += 2;
                    }
                    if (PrimitiveType.TYPE_VOID.equals(methodTypes.returnedType)) {
                        if (opcode == 183 && "<init>".equals(name)) {
                            if (expression1.getClass() == ClassFileNewExpression.class) {
                                this.typeParametersToTypeArgumentsBinder.updateNewExpression((ClassFileNewExpression)expression1, descriptor, methodTypes, parameters);
                                continue block146;
                            }
                            if (ot.getDescriptor().equals(expression1.getType().getDescriptor())) {
                                statements.add(new ExpressionStatement(this.typeParametersToTypeArgumentsBinder.newConstructorInvocationExpression(lineNumber, ot, descriptor, methodTypes, parameters)));
                                continue block146;
                            }
                            statements.add(new ExpressionStatement(this.typeParametersToTypeArgumentsBinder.newSuperConstructorInvocationExpression(lineNumber, ot, descriptor, methodTypes, parameters)));
                            continue block146;
                        }
                        expression1 = this.typeParametersToTypeArgumentsBinder.newMethodInvocationExpression(lineNumber, this.getMethodInstanceReference(expression1, ot, name, descriptor), ot, name, descriptor, methodTypes, parameters);
                        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(ObjectType.TYPE_OBJECT, expression1);
                        statements.add(new ExpressionStatement(expression1));
                        continue block146;
                    }
                    if (opcode == 182 && "toString".equals(name) && "()Ljava/lang/String;".equals(descriptor) && ("java/lang/StringBuilder".equals(typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex())) || "java/lang/StringBuffer".equals(typeName))) {
                        stack.push(StringConcatenationUtil.create(expression1, lineNumber, typeName));
                        continue block146;
                    }
                    stack.push(this.typeParametersToTypeArgumentsBinder.newMethodInvocationExpression(lineNumber, this.getMethodInstanceReference(expression1, ot, name, descriptor), ot, name, descriptor, methodTypes, parameters));
                    continue block146;
                }
                case 186: {
                    this.parseInvokeDynamic(statements, stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    offset += 2;
                    continue block146;
                }
                case 187: {
                    String typeName = constants.getConstantTypeName((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    stack.push(this.newNewExpression(lineNumber, typeName));
                    continue block146;
                }
                case 188: {
                    Type type1 = PrimitiveTypeUtil.getPrimitiveTypeFromTag(code[++offset] & 0xFF).createType(1);
                    stack.push(new NewArray(lineNumber, type1, stack.pop()));
                    continue block146;
                }
                case 189: {
                    Type type1;
                    String typeName = constants.getConstantTypeName((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    if (typeName.charAt(0) == '[') {
                        type1 = this.typeMaker.makeFromDescriptor(typeName);
                        type1 = type1.createType(type1.getDimension() + 1);
                    } else {
                        type1 = this.typeMaker.makeFromInternalTypeName(typeName).createType(1);
                    }
                    stack.push(new NewArray(lineNumber, type1, stack.pop()));
                    continue block146;
                }
                case 190: {
                    stack.push(new LengthExpression(lineNumber, stack.pop()));
                    continue block146;
                }
                case 191: {
                    statements.add(new ThrowStatement(stack.pop()));
                    continue block146;
                }
                case 192: {
                    String typeName = constants.getConstantTypeName((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    Type type1 = this.typeMaker.makeFromDescriptorOrInternalTypeName(typeName);
                    Expression expression1 = stack.peek();
                    if (type1.isObject() && expression1.getType().isObject() && this.typeMaker.isRawTypeAssignable((ObjectType)type1, (ObjectType)expression1.getType())) continue block146;
                    if (expression1.getClass() == CastExpression.class) {
                        ((CastExpression)expression1).setType(type1);
                        continue block146;
                    }
                    this.searchFirstLineNumberVisitor.init();
                    expression1.accept(this.searchFirstLineNumberVisitor);
                    stack.push(new CastExpression(this.searchFirstLineNumberVisitor.getLineNumber(), type1, stack.pop()));
                    continue block146;
                }
                case 193: {
                    String typeName = constants.getConstantTypeName((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    Type type1 = this.typeMaker.makeFromDescriptorOrInternalTypeName(typeName);
                    if (type1 == null) {
                        type1 = PrimitiveTypeUtil.getPrimitiveTypeFromDescriptor(typeName);
                    }
                    stack.push(new InstanceOfExpression(lineNumber, stack.pop(), type1));
                    continue block146;
                }
                case 194: {
                    statements.add(new ClassFileMonitorEnterStatement(stack.pop()));
                    continue block146;
                }
                case 195: {
                    statements.add(new ClassFileMonitorExitStatement(stack.pop()));
                    continue block146;
                }
                case 196: {
                    int count;
                    Expression valueRef;
                    AbstractLocalVariable localVariable;
                    opcode = code[++offset] & 0xFF;
                    int i = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (opcode == 132) {
                        count = (short)((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                        this.parseIINC(statements, stack, lineNumber, this.localVariableMaker.getLocalVariable(i, offset), count);
                        continue block146;
                    }
                    switch (opcode) {
                        case 21: {
                            localVariable = this.localVariableMaker.getLocalVariable(i, offset + 4);
                            ByteCodeParser.parseILOAD(statements, stack, lineNumber, localVariable);
                            continue block146;
                        }
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, this.localVariableMaker.getLocalVariable(i, offset)));
                            continue block146;
                        }
                        case 54: {
                            valueRef = stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, localVariable.getType(), new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable), "=", valueRef, 16)));
                            continue block146;
                        }
                        case 55: {
                            valueRef = stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_LONG, new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable), "=", valueRef, 16)));
                            continue block146;
                        }
                        case 56: {
                            valueRef = stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_FLOAT, new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable), "=", valueRef, 16)));
                            continue block146;
                        }
                        case 57: {
                            valueRef = stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable), "=", valueRef, 16)));
                            continue block146;
                        }
                        case 58: {
                            valueRef = stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            this.parseASTORE(statements, stack, lineNumber, localVariable, valueRef);
                            continue block146;
                        }
                    }
                    continue block146;
                }
                case 197: {
                    String typeName = constants.getConstantTypeName((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    Type type1 = this.typeMaker.makeFromDescriptor(typeName);
                    int i = code[++offset] & 0xFF;
                    Expressions dimensions = new Expressions(i);
                    while (i-- > 0) {
                        dimensions.add(stack.pop());
                    }
                    Collections.reverse(dimensions);
                    stack.push(new NewArray(lineNumber, type1, dimensions));
                    continue block146;
                }
                case 198: {
                    Expression expression1 = stack.pop();
                    this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(ObjectType.TYPE_OBJECT, expression1);
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, expression1, basicBlock.mustInverseCondition() ? "!=" : "==", new NullExpression(expression1.getLineNumber(), expression1.getType()), 9));
                    ByteCodeParser.checkStack(stack, code, offset += 2);
                    continue block146;
                }
                case 199: {
                    Expression expression1 = stack.pop();
                    this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(ObjectType.TYPE_OBJECT, expression1);
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, expression1, basicBlock.mustInverseCondition() ? "==" : "!=", new NullExpression(expression1.getLineNumber(), expression1.getType()), 9));
                    ByteCodeParser.checkStack(stack, code, offset += 2);
                    continue block146;
                }
                case 201: {
                    stack.push(JSR_RETURN_ADDRESS_EXPRESSION);
                }
                case 200: {
                    offset += 4;
                }
            }
        }
    }

    private BaseExpression extractParametersFromStack(Statements statements, DefaultStack<Expression> stack, BaseType parameterTypes) {
        int count;
        if (parameterTypes == null) {
            return null;
        }
        switch (parameterTypes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Expression parameter = stack.pop();
                if (parameter.getClass() == NewArray.class) {
                    parameter = NewArrayMaker.make(statements, (NewArray)parameter);
                }
                return ByteCodeParser.checkIfLastStatementIsAMultiAssignment(statements, parameter);
            }
        }
        Expressions parameters = new Expressions(parameterTypes.size());
        for (int i = count = parameterTypes.size() - 1; i >= 0; --i) {
            Expression parameter = stack.pop();
            if (parameter.getClass() == NewArray.class) {
                parameter = NewArrayMaker.make(statements, (NewArray)parameter);
            }
            parameters.add(ByteCodeParser.checkIfLastStatementIsAMultiAssignment(statements, parameter));
        }
        Collections.reverse(parameters);
        return parameters;
    }

    private static Expression checkIfLastStatementIsAMultiAssignment(Statements statements, Expression parameter) {
        BinaryOperatorExpression boe;
        Expression expression;
        Statement lastStatement;
        if (!statements.isEmpty() && (lastStatement = (Statement)statements.getLast()).getClass() == ExpressionStatement.class && (expression = ((ExpressionStatement)lastStatement).getExpression()).getClass() == BinaryOperatorExpression.class && ByteCodeParser.getLastRightExpression(boe = (BinaryOperatorExpression)expression) == parameter) {
            statements.removeLast();
            return expression;
        }
        return parameter;
    }

    private AbstractLocalVariable getLocalVariableInAssignment(int index, int offset, Expression value) {
        Class<?> valueClass = value.getClass();
        Type valueType = value.getType();
        if (valueClass == NullExpression.class) {
            return this.localVariableMaker.getLocalVariableInNullAssignment(index, offset, valueType);
        }
        if (valueClass == ClassFileLocalVariableReferenceExpression.class) {
            return this.localVariableMaker.getLocalVariableInAssignment(this.typeBounds, index, offset, ((ClassFileLocalVariableReferenceExpression)value).getLocalVariable());
        }
        if (valueClass == ClassFileMethodInvocationExpression.class) {
            if (valueType.isObject()) {
                valueType = ((ObjectType)valueType).createType(null);
            } else if (valueType.isGeneric()) {
                valueType = ObjectType.TYPE_UNDEFINED_OBJECT;
            }
            return this.localVariableMaker.getLocalVariableInAssignment(this.typeBounds, index, offset, valueType);
        }
        return this.localVariableMaker.getLocalVariableInAssignment(this.typeBounds, index, offset, valueType);
    }

    private void parseLDC(DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, Constant constant) {
        switch (constant.getTag()) {
            case 3: {
                int i = ((ConstantInteger)constant).getValue();
                stack.push(new IntegerConstantExpression(lineNumber, PrimitiveTypeUtil.getPrimitiveTypeFromValue(i), i));
                break;
            }
            case 4: {
                float f = ((ConstantFloat)constant).getValue();
                if (f == Float.MIN_VALUE) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_FLOAT, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "MIN_VALUE", "F"));
                    break;
                }
                if (f == Float.MAX_VALUE) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_FLOAT, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "MAX_VALUE", "F"));
                    break;
                }
                if (f == Float.NEGATIVE_INFINITY) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_FLOAT, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "NEGATIVE_INFINITY", "F"));
                    break;
                }
                if (f == Float.POSITIVE_INFINITY) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_FLOAT, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "POSITIVE_INFINITY", "F"));
                    break;
                }
                if (Float.isNaN(f)) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_FLOAT, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "NaN", "F"));
                    break;
                }
                stack.push(new FloatConstantExpression(lineNumber, f));
                break;
            }
            case 7: {
                int typeNameIndex = ((ConstantClass)constant).getNameIndex();
                String typeName = ((ConstantUtf8)constants.getConstant(typeNameIndex)).getValue();
                Type type = this.typeMaker.makeFromDescriptorOrInternalTypeName(typeName);
                if (type == null) {
                    type = PrimitiveTypeUtil.getPrimitiveTypeFromDescriptor(typeName);
                }
                stack.push(new TypeReferenceDotClassExpression(lineNumber, type));
                break;
            }
            case 5: {
                long l = ((ConstantLong)constant).getValue();
                if (l == Long.MIN_VALUE) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_LONG, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_LONG), "java/lang/Long", "MIN_VALUE", "J"));
                    break;
                }
                if (l == Long.MAX_VALUE) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_LONG, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_LONG), "java/lang/Long", "MAX_VALUE", "J"));
                    break;
                }
                stack.push(new LongConstantExpression(lineNumber, l));
                break;
            }
            case 6: {
                double d = ((ConstantDouble)constant).getValue();
                if (d == Double.MIN_VALUE) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "MIN_VALUE", "D"));
                    break;
                }
                if (d == Double.MAX_VALUE) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "MAX_VALUE", "D"));
                    break;
                }
                if (d == Double.NEGATIVE_INFINITY) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "NEGATIVE_INFINITY", "D"));
                    break;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "POSITIVE_INFINITY", "D"));
                    break;
                }
                if (Double.isNaN(d)) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "NaN", "D"));
                    break;
                }
                if (d == Math.E) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_MATH), "java/lang/Math", "E", "D"));
                    break;
                }
                if (d == Math.PI) {
                    stack.push(new FieldReferenceExpression(lineNumber, PrimitiveType.TYPE_DOUBLE, new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_MATH), "java/lang/Math", "PI", "D"));
                    break;
                }
                stack.push(new DoubleConstantExpression(lineNumber, d));
                break;
            }
            case 8: {
                int stringIndex = ((ConstantString)constant).getStringIndex();
                stack.push(new StringConstantExpression(lineNumber, constants.getConstantUtf8(stringIndex)));
            }
        }
    }

    private static void parseILOAD(Statements statements, DefaultStack<Expression> stack, int lineNumber, AbstractLocalVariable localVariable) {
        ClassFileLocalVariableReferenceExpression cflvre;
        PreOperatorExpression poe;
        Expression expression;
        Statement statement;
        if (!statements.isEmpty() && (statement = (Statement)statements.getLast()).getClass() == ExpressionStatement.class && (expression = ((ExpressionStatement)statement).getExpression()).getLineNumber() == lineNumber && expression.getClass() == PreOperatorExpression.class && (poe = (PreOperatorExpression)expression).getExpression().getClass() == ClassFileLocalVariableReferenceExpression.class && (cflvre = (ClassFileLocalVariableReferenceExpression)poe.getExpression()).getLocalVariable() == localVariable) {
            statements.removeLast();
            stack.push(poe);
            return;
        }
        stack.push(new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable));
    }

    private void parseSTORE(Statements statements, DefaultStack<Expression> stack, int lineNumber, AbstractLocalVariable localVariable, Expression valueRef) {
        ClassFileLocalVariableReferenceExpression lvr;
        BinaryOperatorExpression boe;
        ClassFileLocalVariableReferenceExpression vre = new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable);
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(vre.getType(), valueRef);
        if (valueRef.getLineNumber() == lineNumber && valueRef.getClass() == BinaryOperatorExpression.class && (boe = (BinaryOperatorExpression)valueRef).getLeftExpression().getClass() == ClassFileLocalVariableReferenceExpression.class && (lvr = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable() == localVariable) {
            Expression expression;
            switch (boe.getOperator()) {
                case "*": {
                    expression = ByteCodeParser.createAssignment(boe, "*=");
                    break;
                }
                case "/": {
                    expression = ByteCodeParser.createAssignment(boe, "/=");
                    break;
                }
                case "%": {
                    expression = ByteCodeParser.createAssignment(boe, "%=");
                    break;
                }
                case "<<": {
                    expression = ByteCodeParser.createAssignment(boe, "<<=");
                    break;
                }
                case ">>": {
                    expression = ByteCodeParser.createAssignment(boe, ">>=");
                    break;
                }
                case ">>>": {
                    expression = ByteCodeParser.createAssignment(boe, ">>>=");
                    break;
                }
                case "&": {
                    expression = ByteCodeParser.createAssignment(boe, "&=");
                    break;
                }
                case "^": {
                    expression = ByteCodeParser.createAssignment(boe, "^=");
                    break;
                }
                case "|": {
                    expression = ByteCodeParser.createAssignment(boe, "|=");
                    break;
                }
                case "=": {
                    expression = boe;
                    break;
                }
                case "+": {
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsLocalVariableReference(stack, localVariable)) {
                            stack.pop();
                            stack.push(valueRef);
                            expression = this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "++");
                            break;
                        }
                        expression = this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "++", boe.getLeftExpression());
                        break;
                    }
                    if (ByteCodeParser.isNegativeOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsLocalVariableReference(stack, localVariable)) {
                            stack.pop();
                            stack.push(valueRef);
                            expression = this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "--");
                            break;
                        }
                        expression = this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "--", boe.getLeftExpression());
                        break;
                    }
                    expression = ByteCodeParser.createAssignment(boe, "+=");
                    break;
                }
                case "-": {
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsLocalVariableReference(stack, localVariable)) {
                            stack.pop();
                            stack.push(valueRef);
                            expression = this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "--");
                            break;
                        }
                        expression = this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "--", boe.getLeftExpression());
                        break;
                    }
                    if (ByteCodeParser.isNegativeOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsLocalVariableReference(stack, localVariable)) {
                            stack.pop();
                            stack.push(valueRef);
                            expression = this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "++");
                            break;
                        }
                        expression = this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "++", boe.getLeftExpression());
                        break;
                    }
                    expression = ByteCodeParser.createAssignment(boe, "-=");
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected value expression");
                }
            }
            if (!stack.isEmpty() && stack.peek() == valueRef) {
                stack.replace(valueRef, expression);
            } else {
                statements.add(new ExpressionStatement(expression));
            }
            return;
        }
        this.createAssignment(statements, stack, lineNumber, vre, valueRef);
    }

    private static boolean stackContainsLocalVariableReference(DefaultStack<Expression> stack, AbstractLocalVariable localVariable) {
        if (stack.isEmpty()) {
            return false;
        }
        Expression expression = stack.peek();
        if (expression.getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return false;
        }
        ClassFileLocalVariableReferenceExpression lvr = (ClassFileLocalVariableReferenceExpression)expression;
        return lvr.getLocalVariable() == localVariable;
    }

    private void parsePUT(Statements statements, DefaultStack<Expression> stack, int lineNumber, FieldReferenceExpression fr, Expression valueRef) {
        FieldReferenceExpression boefr;
        BinaryOperatorExpression boe;
        if (valueRef.getClass() == NewArray.class) {
            valueRef = NewArrayMaker.make(statements, (NewArray)valueRef);
        }
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(fr.getType(), valueRef);
        if (valueRef.getLineNumber() == lineNumber && valueRef.getClass() == BinaryOperatorExpression.class && (boe = (BinaryOperatorExpression)valueRef).getLeftExpression().getClass() == FieldReferenceExpression.class && (boefr = (FieldReferenceExpression)boe.getLeftExpression()).getName().equals(fr.getName()) && boefr.getExpression().getType().equals(fr.getExpression().getType())) {
            Expression expression;
            switch (boe.getOperator()) {
                case "*": {
                    expression = ByteCodeParser.createAssignment(boe, "*=");
                    break;
                }
                case "/": {
                    expression = ByteCodeParser.createAssignment(boe, "/=");
                    break;
                }
                case "%": {
                    expression = ByteCodeParser.createAssignment(boe, "%=");
                    break;
                }
                case "<<": {
                    expression = ByteCodeParser.createAssignment(boe, "<<=");
                    break;
                }
                case ">>": {
                    expression = ByteCodeParser.createAssignment(boe, ">>=");
                    break;
                }
                case ">>>": {
                    expression = ByteCodeParser.createAssignment(boe, ">>>=");
                    break;
                }
                case "&": {
                    expression = ByteCodeParser.createAssignment(boe, "&=");
                    break;
                }
                case "^": {
                    expression = ByteCodeParser.createAssignment(boe, "^=");
                    break;
                }
                case "|": {
                    expression = ByteCodeParser.createAssignment(boe, "|=");
                    break;
                }
                case "=": {
                    expression = boe;
                    break;
                }
                case "+": {
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsFieldReference(stack, fr)) {
                            stack.pop();
                            stack.push(valueRef);
                            expression = this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "++");
                            break;
                        }
                        expression = this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "++", boe.getLeftExpression());
                        break;
                    }
                    if (ByteCodeParser.isNegativeOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsFieldReference(stack, fr)) {
                            stack.pop();
                            stack.push(valueRef);
                            expression = this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "--");
                            break;
                        }
                        expression = this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "--", boe.getLeftExpression());
                        break;
                    }
                    expression = ByteCodeParser.createAssignment(boe, "+=");
                    break;
                }
                case "-": {
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsFieldReference(stack, fr)) {
                            stack.pop();
                            stack.push(valueRef);
                            expression = this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "--");
                            break;
                        }
                        expression = this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "--", boe.getLeftExpression());
                        break;
                    }
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsFieldReference(stack, fr)) {
                            stack.pop();
                            stack.push(valueRef);
                            expression = this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "++");
                            break;
                        }
                        expression = this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "++", boe.getLeftExpression());
                        break;
                    }
                    expression = ByteCodeParser.createAssignment(boe, "-=");
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected value expression");
                }
            }
            if (!stack.isEmpty() && stack.peek() == valueRef) {
                stack.replace(valueRef, expression);
            } else {
                statements.add(new ExpressionStatement(expression));
            }
            return;
        }
        this.createAssignment(statements, stack, lineNumber, fr, valueRef);
    }

    private void parseInvokeDynamic(Statements statements, DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        MethodInvocationExpression mie;
        Expression expression;
        Statement last;
        if (!statements.isEmpty() && (last = (Statement)statements.getLast()).getClass() == ExpressionStatement.class && (expression = ((ExpressionStatement)last).getExpression()).getClass() == ClassFileMethodInvocationExpression.class && (mie = (MethodInvocationExpression)expression).getName().equals("getClass") && mie.getDescriptor().equals("()Ljava/lang/Class;") && mie.getInternalTypeName().equals("java/lang/Object")) {
            statements.removeLast();
        }
        ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant(index);
        ConstantNameAndType indyCnat = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String indyMethodName = constants.getConstantUtf8(indyCnat.getNameIndex());
        String indyDescriptor = constants.getConstantUtf8(indyCnat.getDescriptorIndex());
        TypeMaker.MethodTypes indyMethodTypes = this.typeMaker.makeMethodTypes(indyDescriptor);
        BaseExpression indyParameters = this.extractParametersFromStack(statements, stack, indyMethodTypes.parameterTypes);
        BootstrapMethod bootstrapMethod = this.attributeBootstrapMethods.getBootstrapMethods()[constantMemberRef.getClassIndex()];
        int[] bootstrapArguments = bootstrapMethod.getBootstrapArguments();
        if ("makeConcatWithConstants".equals(indyMethodName)) {
            String recipe = constants.getConstantString(bootstrapArguments[0]);
            stack.push(StringConcatenationUtil.create(recipe, indyParameters));
            return;
        }
        if ("makeConcat".equals(indyMethodName)) {
            stack.push(StringConcatenationUtil.create(indyParameters));
            return;
        }
        ConstantMethodType cmt0 = (ConstantMethodType)constants.getConstant(bootstrapArguments[0]);
        String descriptor0 = constants.getConstantUtf8(cmt0.getDescriptorIndex());
        TypeMaker.MethodTypes methodTypes0 = this.typeMaker.makeMethodTypes(descriptor0);
        int parameterCount = methodTypes0.parameterTypes == null ? 0 : methodTypes0.parameterTypes.size();
        ConstantMethodHandle constantMethodHandle1 = (ConstantMethodHandle)constants.getConstant(bootstrapArguments[1]);
        ConstantMemberRef cmr1 = (ConstantMemberRef)constants.getConstant(constantMethodHandle1.getReferenceIndex());
        String typeName = constants.getConstantTypeName(cmr1.getClassIndex());
        ConstantNameAndType cnat1 = (ConstantNameAndType)constants.getConstant(cmr1.getNameAndTypeIndex());
        String name1 = constants.getConstantUtf8(cnat1.getNameIndex());
        String descriptor1 = constants.getConstantUtf8(cnat1.getDescriptorIndex());
        if (typeName.equals(this.internalTypeName)) {
            for (ClassFileConstructorOrMethodDeclaration methodDeclaration : this.bodyDeclaration.getMethodDeclarations()) {
                if ((methodDeclaration.getFlags() & 0x1002) != 4098 || !methodDeclaration.getMethod().getName().equals(name1) || !methodDeclaration.getMethod().getDescriptor().equals(descriptor1)) continue;
                ClassFileMethodDeclaration cfmd = (ClassFileMethodDeclaration)methodDeclaration;
                stack.push(new LambdaIdentifiersExpression(lineNumber, indyMethodTypes.returnedType, indyMethodTypes.returnedType, ByteCodeParser.prepareLambdaParameters(cfmd.getFormalParameters(), parameterCount), ByteCodeParser.prepareLambdaStatements(cfmd.getStatements())));
                return;
            }
        }
        if (indyParameters == null) {
            ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
            if (name1.equals("<init>")) {
                stack.push(new ConstructorReferenceExpression(lineNumber, indyMethodTypes.returnedType, ot, descriptor1));
            } else {
                stack.push(new MethodReferenceExpression(lineNumber, indyMethodTypes.returnedType, new ObjectTypeReferenceExpression(lineNumber, ot), typeName, name1, descriptor1));
            }
            return;
        }
        stack.push(new MethodReferenceExpression(lineNumber, indyMethodTypes.returnedType, (Expression)indyParameters, typeName, name1, descriptor1));
    }

    private static List<String> prepareLambdaParameters(BaseFormalParameter formalParameters, int parameterCount) {
        if (formalParameters == null || parameterCount == 0) {
            return null;
        }
        LambdaParameterNamesVisitor lambdaParameterNamesVisitor = new LambdaParameterNamesVisitor();
        formalParameters.accept(lambdaParameterNamesVisitor);
        List<String> names = lambdaParameterNamesVisitor.getNames();
        assert (names.size() >= parameterCount);
        if (names.size() == parameterCount) {
            return names;
        }
        return names.subList(names.size() - parameterCount, names.size());
    }

    private static BaseStatement prepareLambdaStatements(BaseStatement baseStatement) {
        if (baseStatement != null && baseStatement.isList() && baseStatement.size() == 1) {
            Statement statement = (Statement)baseStatement.getFirst();
            if (statement.getClass() == ReturnExpressionStatement.class) {
                return new LambdaExpressionStatement(((ReturnExpressionStatement)statement).getExpression());
            }
            if (statement.getClass() == ExpressionStatement.class) {
                return new LambdaExpressionStatement(((ExpressionStatement)statement).getExpression());
            }
        }
        return baseStatement;
    }

    private static boolean stackContainsFieldReference(DefaultStack<Expression> stack, FieldReferenceExpression fr) {
        if (stack.isEmpty()) {
            return false;
        }
        Expression expression = stack.peek();
        if (expression.getClass() != FieldReferenceExpression.class) {
            return false;
        }
        FieldReferenceExpression stackfr = (FieldReferenceExpression)expression;
        return stackfr.getName().equals(fr.getName()) && stackfr.getExpression().getType().equals(fr.getExpression().getType());
    }

    private static Expression createAssignment(BinaryOperatorExpression boe, String operator) {
        boe.setOperator(operator);
        boe.setPriority(16);
        return boe;
    }

    private static boolean isPositiveOne(Expression expression) {
        if (expression.getClass() == IntegerConstantExpression.class && ((IntegerConstantExpression)expression).getValue() == 1) {
            return true;
        }
        if (expression.getClass() == LongConstantExpression.class && ((LongConstantExpression)expression).getValue() == 1L) {
            return true;
        }
        if (expression.getClass() == FloatConstantExpression.class && ((FloatConstantExpression)expression).getValue() == 1.0f) {
            return true;
        }
        return expression.getClass() == DoubleConstantExpression.class && ((DoubleConstantExpression)expression).getValue() == 1.0;
    }

    private static boolean isNegativeOne(Expression expression) {
        if (expression.getClass() == IntegerConstantExpression.class && ((IntegerConstantExpression)expression).getValue() == -1) {
            return true;
        }
        if (expression.getClass() == LongConstantExpression.class && ((LongConstantExpression)expression).getValue() == -1L) {
            return true;
        }
        if (expression.getClass() == FloatConstantExpression.class && ((FloatConstantExpression)expression).getValue() == -1.0f) {
            return true;
        }
        return expression.getClass() == DoubleConstantExpression.class && ((DoubleConstantExpression)expression).getValue() == -1.0;
    }

    private void parseASTORE(Statements statements, DefaultStack<Expression> stack, int lineNumber, AbstractLocalVariable localVariable, Expression valueRef) {
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(localVariable.getType(), valueRef);
        localVariable.typeOnRight(this.typeBounds, valueRef.getType());
        ClassFileLocalVariableReferenceExpression vre = new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable);
        Expression oldValueRef = valueRef;
        if (valueRef.getClass() == NewArray.class) {
            valueRef = NewArrayMaker.make(statements, (NewArray)valueRef);
        }
        if (oldValueRef != valueRef) {
            stack.replace(oldValueRef, valueRef);
        }
        this.createAssignment(statements, stack, lineNumber, vre, valueRef);
    }

    private void createAssignment(Statements statements, DefaultStack<Expression> stack, int lineNumber, Expression leftExpression, Expression rightExpression) {
        Statement lastStatement;
        if (!stack.isEmpty() && stack.peek() == rightExpression) {
            stack.push(new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", stack.pop(), 16));
            return;
        }
        if (!statements.isEmpty() && (lastStatement = (Statement)statements.getLast()).getClass() == ExpressionStatement.class) {
            PostOperatorExpression poe;
            ExpressionStatement lastES = (ExpressionStatement)lastStatement;
            Expression lastExpression = lastES.getExpression();
            Class<?> lastExpressionClass = lastExpression.getClass();
            if (lastExpressionClass == BinaryOperatorExpression.class) {
                Class<?> leftExpressionClass;
                BinaryOperatorExpression boe = (BinaryOperatorExpression)lastExpression;
                if (ByteCodeParser.getLastRightExpression(boe) == rightExpression) {
                    lastES.setExpression(new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", boe, 16));
                    return;
                }
                if (lineNumber > 0 && boe.getLineNumber() == lineNumber && (leftExpressionClass = boe.getLeftExpression().getClass()) == rightExpression.getClass()) {
                    if (leftExpressionClass == ClassFileLocalVariableReferenceExpression.class) {
                        ClassFileLocalVariableReferenceExpression lvr1 = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
                        ClassFileLocalVariableReferenceExpression lvr2 = (ClassFileLocalVariableReferenceExpression)rightExpression;
                        if (lvr1.getLocalVariable() == lvr2.getLocalVariable()) {
                            lastES.setExpression(new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", boe, 16));
                            return;
                        }
                    } else if (leftExpressionClass == FieldReferenceExpression.class) {
                        FieldReferenceExpression fr1 = (FieldReferenceExpression)boe.getLeftExpression();
                        FieldReferenceExpression fr2 = (FieldReferenceExpression)rightExpression;
                        if (fr1.getName().equals(fr2.getName()) && fr1.getExpression().getType().equals(fr2.getExpression().getType())) {
                            lastES.setExpression(new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", boe, 16));
                            return;
                        }
                    }
                }
            } else if (lastExpressionClass == PreOperatorExpression.class) {
                PreOperatorExpression poe2 = (PreOperatorExpression)lastExpression;
                Class<?> clazz = poe2.getExpression().getClass();
                if (clazz == rightExpression.getClass()) {
                    if (clazz == ClassFileLocalVariableReferenceExpression.class) {
                        ClassFileLocalVariableReferenceExpression lvr1 = (ClassFileLocalVariableReferenceExpression)poe2.getExpression();
                        ClassFileLocalVariableReferenceExpression lvr2 = (ClassFileLocalVariableReferenceExpression)rightExpression;
                        if (lvr1.getLocalVariable() == lvr2.getLocalVariable()) {
                            rightExpression = this.newPreArithmeticOperatorExpression(poe2.getLineNumber(), poe2.getOperator(), poe2.getExpression());
                            statements.removeLast();
                        }
                    } else if (clazz == FieldReferenceExpression.class) {
                        FieldReferenceExpression fr1 = (FieldReferenceExpression)poe2.getExpression();
                        FieldReferenceExpression fr2 = (FieldReferenceExpression)rightExpression;
                        if (fr1.getName().equals(fr2.getName()) && fr1.getExpression().getType().equals(fr2.getExpression().getType())) {
                            rightExpression = this.newPreArithmeticOperatorExpression(poe2.getLineNumber(), poe2.getOperator(), poe2.getExpression());
                            statements.removeLast();
                        }
                    }
                }
            } else if (lastExpressionClass == PostOperatorExpression.class && (poe = (PostOperatorExpression)lastExpression).getExpression() == rightExpression) {
                rightExpression = poe;
                statements.removeLast();
            }
        }
        statements.add(new ExpressionStatement(new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", rightExpression, 16)));
    }

    private void parseIINC(Statements statements, DefaultStack<Expression> stack, int lineNumber, AbstractLocalVariable localVariable, int count) {
        ClassFileLocalVariableReferenceExpression exp;
        Expression expression;
        if (!stack.isEmpty() && (expression = stack.peek()).getLineNumber() == lineNumber && expression.getClass() == ClassFileLocalVariableReferenceExpression.class && (exp = (ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() == localVariable) {
            stack.pop();
            if (count == 1) {
                stack.push(this.newPostArithmeticOperatorExpression(lineNumber, expression, "++"));
            } else if (count == -1) {
                stack.push(this.newPostArithmeticOperatorExpression(lineNumber, expression, "--"));
            } else assert (false);
            return;
        }
        expression = new ClassFileLocalVariableReferenceExpression(lineNumber, localVariable);
        if (count == 1) {
            expression = this.newPreArithmeticOperatorExpression(lineNumber, "++", expression);
        } else if (count == -1) {
            expression = this.newPreArithmeticOperatorExpression(lineNumber, "--", expression);
        } else if (count >= 0) {
            expression = new BinaryOperatorExpression(lineNumber, expression.getType(), expression, "+=", new IntegerConstantExpression(lineNumber, expression.getType(), count), 16);
        } else if (count < 0) {
            expression = new BinaryOperatorExpression(lineNumber, expression.getType(), expression, "-=", new IntegerConstantExpression(lineNumber, expression.getType(), -count), 16);
        } else {
            assert (false);
            expression = null;
        }
        statements.add(new ExpressionStatement(expression));
    }

    private void parseIF(DefaultStack<Expression> stack, int lineNumber, BasicBlock basicBlock, String operator1, String operator2, int priority) {
        Expression expression = stack.pop();
        if (expression.getClass() == ClassFileCmpExpression.class) {
            ClassFileCmpExpression cmp = (ClassFileCmpExpression)expression;
            this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(cmp.getLeftExpression().getType(), cmp.getLeftExpression());
            this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(cmp.getRightExpression().getType(), cmp.getRightExpression());
            stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, cmp.getLeftExpression(), basicBlock.mustInverseCondition() ? operator1 : operator2, cmp.getRightExpression(), priority));
        } else if (expression.getType().isPrimitive()) {
            PrimitiveType pt = (PrimitiveType)expression.getType();
            this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(pt, expression);
            switch (pt.getJavaPrimitiveFlags()) {
                case 1: {
                    if (basicBlock.mustInverseCondition() ^ "==".equals(operator1)) {
                        stack.push(expression);
                        break;
                    }
                    stack.push(new PreOperatorExpression(lineNumber, "!", expression));
                    break;
                }
                case 4: {
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, new FloatConstantExpression(lineNumber, 0.0f), 9));
                    break;
                }
                case 8: {
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, new DoubleConstantExpression(lineNumber, 0.0), 9));
                    break;
                }
                case 128: {
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, new LongConstantExpression(lineNumber, 0L), 9));
                    break;
                }
                default: {
                    stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, new IntegerConstantExpression(lineNumber, pt, 0), 9));
                    break;
                }
            }
        } else {
            stack.push(new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, new NullExpression(lineNumber, expression.getType()), 9));
        }
    }

    private void parseXRETURN(Statements statements, DefaultStack<Expression> stack, int lineNumber) {
        BinaryOperatorExpression boe;
        Expression expression;
        Statement lastStatement;
        Expression valueRef = stack.pop();
        if (valueRef.getClass() == NewArray.class) {
            valueRef = NewArrayMaker.make(statements, (NewArray)valueRef);
        }
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(this.returnedType, valueRef);
        if (lineNumber > valueRef.getLineNumber()) {
            lineNumber = valueRef.getLineNumber();
        }
        if (!statements.isEmpty() && valueRef.getClass() == ClassFileLocalVariableReferenceExpression.class && (lastStatement = (Statement)statements.getLast()).getClass() == ExpressionStatement.class && lineNumber <= (expression = ((ExpressionStatement)lastStatement).getExpression()).getLineNumber() && expression.getClass() == BinaryOperatorExpression.class && (boe = (BinaryOperatorExpression)expression).getOperator().equals("=") && boe.getLeftExpression().getClass() == ClassFileLocalVariableReferenceExpression.class) {
            ClassFileLocalVariableReferenceExpression vre1 = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
            ClassFileLocalVariableReferenceExpression vre2 = (ClassFileLocalVariableReferenceExpression)valueRef;
            if (vre1.getLocalVariable() == vre2.getLocalVariable()) {
                this.localVariableMaker.removeLocalVariable(vre1.getLocalVariable());
                statements.removeLast();
                statements.add(new ReturnExpressionStatement(lineNumber, boe.getRightExpression()));
                return;
            }
        }
        statements.add(new ReturnExpressionStatement(lineNumber, valueRef));
    }

    private void parseGetStatic(DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant(index);
        String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
        if (name.equals("TYPE") && typeName.startsWith("java/lang/")) {
            switch (typeName) {
                case "java/lang/Boolean": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN));
                    return;
                }
                case "java/lang/Character": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_CHAR));
                    return;
                }
                case "java/lang/Float": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_FLOAT));
                    return;
                }
                case "java/lang/Double": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_DOUBLE));
                    return;
                }
                case "java/lang/Byte": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_BYTE));
                    return;
                }
                case "java/lang/Short": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_SHORT));
                    return;
                }
                case "java/lang/Integer": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_INT));
                    return;
                }
                case "java/lang/Long": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_LONG));
                    return;
                }
                case "java/lang/Void": {
                    stack.push(new TypeReferenceDotClassExpression(lineNumber, PrimitiveType.TYPE_VOID));
                    return;
                }
            }
        }
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
        String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
        Type type = this.typeMaker.makeFieldType(ot.getInternalName(), name, descriptor);
        ObjectTypeReferenceExpression objectRef = new ObjectTypeReferenceExpression(lineNumber, ot, !this.internalTypeName.equals(typeName) || this.localVariableMaker.containsName(name));
        stack.push(this.typeParametersToTypeArgumentsBinder.newFieldReferenceExpression(lineNumber, type, objectRef, ot, name, descriptor));
    }

    private void parsePutStatic(Statements statements, DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant(index);
        String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
        String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
        Type type = this.typeMaker.makeFieldType(ot.getInternalName(), name, descriptor);
        Expression valueRef = stack.pop();
        ObjectTypeReferenceExpression objectRef = new ObjectTypeReferenceExpression(lineNumber, ot, !this.internalTypeName.equals(typeName) || this.localVariableMaker.containsName(name));
        FieldReferenceExpression fieldRef = this.typeParametersToTypeArgumentsBinder.newFieldReferenceExpression(lineNumber, type, objectRef, ot, name, descriptor);
        this.parsePUT(statements, stack, lineNumber, fieldRef, valueRef);
    }

    private void parseGetField(DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant(index);
        String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
        String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
        Type type = this.typeMaker.makeFieldType(ot.getInternalName(), name, descriptor);
        Expression objectRef = stack.pop();
        stack.push(this.typeParametersToTypeArgumentsBinder.newFieldReferenceExpression(lineNumber, type, this.getFieldInstanceReference(objectRef, ot, name), ot, name, descriptor));
    }

    private void parsePutField(Statements statements, DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant(index);
        String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
        String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
        Type type = this.typeMaker.makeFieldType(ot.getInternalName(), name, descriptor);
        Expression valueRef = stack.pop();
        Expression objectRef = stack.pop();
        FieldReferenceExpression fieldRef = this.typeParametersToTypeArgumentsBinder.newFieldReferenceExpression(lineNumber, type, this.getFieldInstanceReference(objectRef, ot, name), ot, name, descriptor);
        this.parsePUT(statements, stack, lineNumber, fieldRef, valueRef);
    }

    private static Expression getLastRightExpression(BinaryOperatorExpression boe) {
        while (boe.getOperator().equals("=")) {
            if (boe.getRightExpression().getClass() != BinaryOperatorExpression.class) {
                return boe.getRightExpression();
            }
            boe = (BinaryOperatorExpression)boe.getRightExpression();
        }
        return boe;
    }

    private Expression newNewExpression(int lineNumber, String internalTypeName) {
        ObjectType objectType = this.typeMaker.makeFromInternalTypeName(internalTypeName);
        if (objectType.getQualifiedName() == null && objectType.getName() == null) {
            ClassFileTypeDeclaration typeDeclaration = this.bodyDeclaration.getInnerTypeDeclaration(internalTypeName);
            if (typeDeclaration == null) {
                return new ClassFileNewExpression(lineNumber, ObjectType.TYPE_OBJECT);
            }
            if (typeDeclaration.getClass() == ClassFileClassDeclaration.class) {
                ClassFileClassDeclaration declaration = (ClassFileClassDeclaration)typeDeclaration;
                BodyDeclaration bodyDeclaration = this.internalTypeName.equals(internalTypeName) ? null : declaration.getBodyDeclaration();
                if (declaration.getInterfaces() != null) {
                    return new ClassFileNewExpression(lineNumber, (ObjectType)declaration.getInterfaces(), bodyDeclaration);
                }
                if (declaration.getSuperType() != null) {
                    return new ClassFileNewExpression(lineNumber, declaration.getSuperType(), bodyDeclaration);
                }
                return new ClassFileNewExpression(lineNumber, ObjectType.TYPE_OBJECT, bodyDeclaration);
            }
        }
        return new ClassFileNewExpression(lineNumber, objectType);
    }

    private Expression newIntegerBinaryOperatorExpression(int lineNumber, Expression leftExpression, String operator, Expression rightExpression, int priority) {
        Class<?> leftClass = leftExpression.getClass();
        Class<?> rightClass = rightExpression.getClass();
        if (leftClass == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable leftVariable = ((ClassFileLocalVariableReferenceExpression)leftExpression).getLocalVariable();
            leftVariable.typeOnLeft(this.typeBounds, PrimitiveType.MAYBE_BYTE_TYPE);
        }
        if (rightClass == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
            rightVariable.typeOnLeft(this.typeBounds, PrimitiveType.MAYBE_BYTE_TYPE);
        }
        return new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_INT, leftExpression, operator, rightExpression, priority);
    }

    private Expression newIntegerOrBooleanBinaryOperatorExpression(int lineNumber, Expression leftExpression, String operator, Expression rightExpression, int priority) {
        Class<?> leftClass = leftExpression.getClass();
        Class<?> rightClass = rightExpression.getClass();
        PrimitiveType type = PrimitiveType.TYPE_INT;
        if (leftClass == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable leftVariable = ((ClassFileLocalVariableReferenceExpression)leftExpression).getLocalVariable();
            if (rightClass == ClassFileLocalVariableReferenceExpression.class) {
                AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
                if (leftVariable.isAssignableFrom(this.typeBounds, PrimitiveType.TYPE_BOOLEAN) || rightVariable.isAssignableFrom(this.typeBounds, PrimitiveType.TYPE_BOOLEAN)) {
                    leftVariable.variableOnRight(this.typeBounds, rightVariable);
                    rightVariable.variableOnLeft(this.typeBounds, leftVariable);
                    if (leftVariable.getType() == PrimitiveType.TYPE_BOOLEAN || rightVariable.getType() == PrimitiveType.TYPE_BOOLEAN) {
                        type = PrimitiveType.TYPE_BOOLEAN;
                    }
                }
            } else if (rightExpression.getType() == PrimitiveType.TYPE_BOOLEAN) {
                type = PrimitiveType.TYPE_BOOLEAN;
                leftVariable.typeOnRight(this.typeBounds, type);
            }
        } else if (rightClass == ClassFileLocalVariableReferenceExpression.class && leftExpression.getType() == PrimitiveType.TYPE_BOOLEAN) {
            AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
            type = PrimitiveType.TYPE_BOOLEAN;
            rightVariable.typeOnRight(this.typeBounds, type);
        }
        return new BinaryOperatorExpression(lineNumber, type, leftExpression, operator, rightExpression, priority);
    }

    private Expression newIntegerOrBooleanComparisonOperatorExpression(int lineNumber, Expression leftExpression, String operator, Expression rightExpression, int priority) {
        Class<?> leftClass = leftExpression.getClass();
        Class<?> rightClass = rightExpression.getClass();
        if (leftClass == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable leftVariable = ((ClassFileLocalVariableReferenceExpression)leftExpression).getLocalVariable();
            if (rightClass == ClassFileLocalVariableReferenceExpression.class) {
                AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
                if (leftVariable.isAssignableFrom(this.typeBounds, PrimitiveType.TYPE_BOOLEAN) || rightVariable.isAssignableFrom(this.typeBounds, PrimitiveType.TYPE_BOOLEAN)) {
                    leftVariable.variableOnRight(this.typeBounds, rightVariable);
                    rightVariable.variableOnLeft(this.typeBounds, leftVariable);
                }
            } else if (rightExpression.getType() == PrimitiveType.TYPE_BOOLEAN) {
                leftVariable.typeOnRight(this.typeBounds, PrimitiveType.TYPE_BOOLEAN);
            }
        } else if (rightClass == ClassFileLocalVariableReferenceExpression.class && leftExpression.getType() == PrimitiveType.TYPE_BOOLEAN) {
            AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
            rightVariable.typeOnRight(this.typeBounds, PrimitiveType.TYPE_BOOLEAN);
        }
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(leftExpression.getType(), rightExpression);
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(rightExpression.getType(), leftExpression);
        return new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, leftExpression, operator, rightExpression, priority);
    }

    private Expression newIntegerComparisonOperatorExpression(int lineNumber, Expression leftExpression, String operator, Expression rightExpression, int priority) {
        Class<?> leftClass = leftExpression.getClass();
        Class<?> rightClass = rightExpression.getClass();
        if (leftClass == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable leftVariable = ((ClassFileLocalVariableReferenceExpression)leftExpression).getLocalVariable();
            leftVariable.typeOnLeft(this.typeBounds, PrimitiveType.MAYBE_BYTE_TYPE);
        }
        if (rightClass == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
            rightVariable.typeOnLeft(this.typeBounds, PrimitiveType.MAYBE_BYTE_TYPE);
        }
        return new BinaryOperatorExpression(lineNumber, PrimitiveType.TYPE_BOOLEAN, leftExpression, operator, rightExpression, priority);
    }

    private Expression newPreArithmeticOperatorExpression(int lineNumber, String operator, Expression expression) {
        this.reduceIntegerLocalVariableType(expression);
        return new PreOperatorExpression(lineNumber, operator, expression);
    }

    private Expression newPostArithmeticOperatorExpression(int lineNumber, Expression expression, String operator) {
        this.reduceIntegerLocalVariableType(expression);
        return new PostOperatorExpression(lineNumber, expression, operator);
    }

    private void reduceIntegerLocalVariableType(Expression expression) {
        PrimitiveLocalVariable plv;
        ClassFileLocalVariableReferenceExpression lvre;
        if (expression.getClass() == ClassFileLocalVariableReferenceExpression.class && (lvre = (ClassFileLocalVariableReferenceExpression)expression).getLocalVariable().getClass() == PrimitiveLocalVariable.class && (plv = (PrimitiveLocalVariable)lvre.getLocalVariable()).isAssignableFrom(this.typeBounds, PrimitiveType.MAYBE_BOOLEAN_TYPE)) {
            plv.typeOnRight(this.typeBounds, PrimitiveType.MAYBE_BYTE_TYPE);
        }
    }

    private Expression getFieldInstanceReference(Expression expression, ObjectType ot, String name) {
        if (this.bodyDeclaration.getFieldDeclarations() != null && expression.getClass() == ThisExpression.class) {
            String internalName = ((ObjectType)expression.getType()).getInternalName();
            if (!ot.getInternalName().equals(internalName)) {
                this.memberVisitor.init(name, null);
                for (ClassFileFieldDeclaration field : this.bodyDeclaration.getFieldDeclarations()) {
                    field.getFieldDeclarators().accept(this.memberVisitor);
                    if (!this.memberVisitor.found()) continue;
                    return new SuperExpression(expression.getLineNumber(), expression.getType());
                }
            }
        }
        return expression;
    }

    private Expression getMethodInstanceReference(Expression expression, ObjectType ot, String name, String descriptor) {
        if (this.bodyDeclaration.getMethodDeclarations() != null && expression.getClass() == ThisExpression.class) {
            String internalName = ((ObjectType)expression.getType()).getInternalName();
            if (!ot.getInternalName().equals(internalName)) {
                this.memberVisitor.init(name, descriptor);
                for (ClassFileConstructorOrMethodDeclaration member : this.bodyDeclaration.getMethodDeclarations()) {
                    member.accept(this.memberVisitor);
                    if (!this.memberVisitor.found()) continue;
                    return new SuperExpression(expression.getLineNumber(), expression.getType());
                }
            }
        }
        return expression;
    }

    private static void checkStack(DefaultStack<Expression> stack, byte[] code, int offset) {
        int opcode;
        if (stack.size() > 1 && offset < code.length && ((opcode = code[offset + 1] & 0xFF) == 87 || opcode == 176)) {
            Expression condition = stack.pop();
            stack.push(stack.peek());
            stack.push(condition);
        }
    }

    public static boolean isAssertCondition(String internalTypeName, BasicBlock basicBlock) {
        ConstantMemberRef constantMemberRef;
        ConstantNameAndType constantNameAndType;
        int toOffset;
        ControlFlowGraph cfg = basicBlock.getControlFlowGraph();
        int offset = basicBlock.getFromOffset();
        if (offset + 3 > (toOffset = basicBlock.getToOffset())) {
            return false;
        }
        Method method = cfg.getMethod();
        byte[] code = ((AttributeCode)method.getAttribute("Code")).getCode();
        int opcode = code[offset] & 0xFF;
        if (opcode != 178) {
            return false;
        }
        ConstantPool constants = method.getConstants();
        String name = constants.getConstantUtf8((constantNameAndType = (ConstantNameAndType)constants.getConstant((constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF)).getNameAndTypeIndex())).getNameIndex());
        if (!"$assertionsDisabled".equals(name)) {
            return false;
        }
        String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
        if (!"Z".equals(descriptor)) {
            return false;
        }
        String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
        return internalTypeName.equals(typeName);
    }

    public static int getExceptionLocalVariableIndex(BasicBlock basicBlock) {
        int toOffset;
        ControlFlowGraph cfg = basicBlock.getControlFlowGraph();
        int offset = basicBlock.getFromOffset();
        if (offset + 1 > (toOffset = basicBlock.getToOffset())) {
            assert (false);
            return -1;
        }
        Method method = cfg.getMethod();
        byte[] code = ((AttributeCode)method.getAttribute("Code")).getCode();
        int opcode = code[offset] & 0xFF;
        switch (opcode) {
            case 58: {
                return code[++offset] & 0xFF;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return opcode - 75;
            }
            case 87: 
            case 88: {
                return -1;
            }
        }
        assert (false);
        return -1;
    }

    public static int searchNextOpcode(BasicBlock basicBlock, int maxOffset) {
        byte[] code = ((AttributeCode)basicBlock.getControlFlowGraph().getMethod().getAttribute("Code")).getCode();
        int offset = basicBlock.getFromOffset();
        int toOffset = basicBlock.getToOffset();
        if (toOffset > maxOffset) {
            toOffset = maxOffset;
        }
        while (offset < toOffset) {
            int opcode = code[offset] & 0xFF;
            switch (opcode) {
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: 
                case 188: {
                    ++offset;
                    break;
                }
                case 17: 
                case 19: 
                case 20: 
                case 132: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    offset += 2;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 198: 
                case 199: {
                    int deltaOffset = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (deltaOffset <= 0) break;
                    offset += deltaOffset - 2 - 1;
                    break;
                }
                case 200: {
                    int deltaOffset = (code[++offset] & 0xFF) << 24 | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (deltaOffset <= 0) break;
                    offset += deltaOffset - 4 - 1;
                    break;
                }
                case 168: {
                    offset += 2;
                    break;
                }
                case 197: {
                    offset += 3;
                    break;
                }
                case 185: 
                case 186: {
                    offset += 4;
                    break;
                }
                case 201: {
                    offset += 4;
                    break;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    break;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    break;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    if (opcode == 132) {
                        offset += 4;
                        break;
                    }
                    offset += 2;
                }
            }
            ++offset;
        }
        if (offset <= maxOffset) {
            return code[offset] & 0xFF;
        }
        return 0;
    }

    public static int getLastOpcode(BasicBlock basicBlock) {
        int toOffset;
        byte[] code = ((AttributeCode)basicBlock.getControlFlowGraph().getMethod().getAttribute("Code")).getCode();
        int offset = basicBlock.getFromOffset();
        if (offset >= (toOffset = basicBlock.getToOffset())) {
            return 0;
        }
        int lastOffset = offset;
        while (offset < toOffset) {
            int opcode = code[offset] & 0xFF;
            lastOffset = offset++;
            switch (opcode) {
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: 
                case 188: {
                    break;
                }
                case 17: 
                case 19: 
                case 20: 
                case 132: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    offset += 2;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 198: 
                case 199: {
                    int deltaOffset = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (deltaOffset <= 0) break;
                    offset += deltaOffset - 2 - 1;
                    break;
                }
                case 200: {
                    int deltaOffset = (code[++offset] & 0xFF) << 24 | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (deltaOffset <= 0) break;
                    offset += deltaOffset - 4 - 1;
                    break;
                }
                case 168: {
                    offset += 2;
                    break;
                }
                case 197: {
                    offset += 3;
                    break;
                }
                case 185: 
                case 186: {
                    offset += 4;
                    break;
                }
                case 201: {
                    offset += 4;
                    break;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    break;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    break;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    if (opcode == 132) {
                        offset += 4;
                        break;
                    }
                    offset += 2;
                }
            }
            ++offset;
        }
        return code[lastOffset] & 0xFF;
    }

    public static int evalStackDepth(BasicBlock bb) {
        Method method = bb.getControlFlowGraph().getMethod();
        ConstantPool constants = method.getConstants();
        AttributeCode attributeCode = (AttributeCode)method.getAttribute("Code");
        byte[] code = attributeCode.getCode();
        return ByteCodeParser.evalStackDepth(constants, code, bb);
    }

    public static int evalStackDepth(ConstantPool constants, byte[] code, BasicBlock bb) {
        int depth = 0;
        int toOffset = bb.getToOffset();
        block28: for (int offset = bb.getFromOffset(); offset < toOffset; ++offset) {
            int opcode = code[offset] & 0xFF;
            switch (opcode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 89: 
                case 90: 
                case 91: {
                    ++depth;
                    continue block28;
                }
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    ++offset;
                    ++depth;
                    continue block28;
                }
                case 17: 
                case 19: 
                case 20: 
                case 168: 
                case 178: 
                case 187: {
                    offset += 2;
                    ++depth;
                    continue block28;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 87: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 194: 
                case 195: {
                    --depth;
                    continue block28;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 179: 
                case 198: 
                case 199: {
                    offset += 2;
                    --depth;
                    continue block28;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    ++offset;
                    --depth;
                    continue block28;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    depth -= 3;
                    continue block28;
                }
                case 92: 
                case 93: 
                case 94: {
                    depth += 2;
                    continue block28;
                }
                case 132: 
                case 167: 
                case 180: 
                case 189: 
                case 192: 
                case 193: {
                    offset += 2;
                    continue block28;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 181: {
                    offset += 2;
                    depth -= 2;
                    continue block28;
                }
                case 88: {
                    depth -= 2;
                    continue block28;
                }
                case 169: 
                case 188: {
                    ++offset;
                    continue block28;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    --depth;
                    continue block28;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    --depth;
                    continue block28;
                }
                case 182: 
                case 183: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    depth -= 1 + ByteCodeParser.countMethodParameters(descriptor);
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block28;
                    ++depth;
                    continue block28;
                }
                case 184: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    depth -= ByteCodeParser.countMethodParameters(descriptor);
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block28;
                    ++depth;
                    continue block28;
                }
                case 185: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    depth -= 1 + ByteCodeParser.countMethodParameters(descriptor);
                    offset += 2;
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block28;
                    ++depth;
                    continue block28;
                }
                case 186: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    depth -= ByteCodeParser.countMethodParameters(descriptor);
                    offset += 2;
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block28;
                    ++depth;
                    continue block28;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    if (opcode == 132) {
                        offset += 4;
                        continue block28;
                    }
                    offset += 2;
                    switch (opcode) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            ++depth;
                            continue block28;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: {
                            --depth;
                            continue block28;
                        }
                    }
                    continue block28;
                }
                case 197: {
                    depth += 1 - (code[offset += 3] & 0xFF);
                    continue block28;
                }
                case 201: {
                    offset += 4;
                    ++depth;
                }
                case 200: {
                    offset += 4;
                }
            }
        }
        return depth;
    }

    private static int countMethodParameters(String descriptor) {
        int count = 0;
        int i = 2;
        char c = descriptor.charAt(1);
        assert (descriptor.length() > 2 && descriptor.charAt(0) == '(');
        while (c != ')') {
            while (c == '[') {
                c = descriptor.charAt(i++);
            }
            if (c == 'L') {
                while ((c = descriptor.charAt(i++)) != ';') {
                }
            }
            c = descriptor.charAt(i++);
            ++count;
        }
        return count;
    }

    private static class JsrReturnAddressExpression
    extends NullExpression {
        public JsrReturnAddressExpression() {
            super(PrimitiveType.TYPE_VOID);
        }

        @Override
        public String toString() {
            return "JsrReturnAddressExpression{}";
        }
    }

    private static class LambdaParameterNamesVisitor
    extends AbstractNopDeclarationVisitor {
        protected DefaultList<String> names = new DefaultList();

        private LambdaParameterNamesVisitor() {
        }

        public void reset() {
            this.names = new DefaultList();
        }

        public List<String> getNames() {
            return this.names;
        }

        @Override
        public void visit(FormalParameter declaration) {
            this.names.add(declaration.getName());
        }

        @Override
        public void visit(FormalParameters declarations) {
            Iterator iterator = declarations.iterator();
            while (iterator.hasNext()) {
                ((FormalParameter)iterator.next()).accept(this);
            }
        }
    }

    private static class MemberVisitor
    extends AbstractJavaSyntaxVisitor {
        protected String name;
        protected String descriptor;
        protected boolean found;

        private MemberVisitor() {
        }

        public void init(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
            this.found = false;
        }

        public boolean found() {
            return this.found;
        }

        @Override
        public void visit(FieldDeclarator declaration) {
            this.found |= declaration.getName().equals(this.name);
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.found |= declaration.getName().equals(this.name) && declaration.getDescriptor().equals(this.descriptor);
        }
    }
}

