win32 {
    VERSION_CALC_SCRIPT = $$PWD/../scripts/win32/calc_version.bat
    VERSION_CALC = $$system($$VERSION_CALC_SCRIPT 2>NUL, lines)
} else {
    VERSION_CALC_SCRIPT = $$PWD/../scripts/linux/calc_version.sh
    VERSION_CALC = $$system($$VERSION_CALC_SCRIPT 2>/dev/null, lines)
}

# Parse the results if we got them
!isEmpty(VERSION_CALC) {
    VERSION_PARTS = $$split(VERSION_CALC, " ")
    SQLITESTUDIO_VERSION_STRING = $$member(VERSION_PARTS, 0)
    SQLITESTUDIO_VERSION_INT = $$member(VERSION_PARTS, 1)

    VERSION_PARTS = $$split(SQLITESTUDIO_VERSION_STRING, ".")
    SQLITESTUDIO_VERSION_MAJOR = $$member(VERSION_PARTS, 0)
    SQLITESTUDIO_VERSION_MINOR = $$member(VERSION_PARTS, 1)
    SQLITESTUDIO_VERSION_PATCH = $$member(VERSION_PARTS, 2)
}

isEmpty(SQLITESTUDIO_VERSION_STRING) {
    error("Could not calculate version components. Please check that the build environment supports batch/shell scripts.")
}

message("SQLiteStudio version: $$SQLITESTUDIO_VERSION_STRING ($$SQLITESTUDIO_VERSION_INT)")

VERSION = $$SQLITESTUDIO_VERSION_STRING

# Make variables available to other .pro files
export(SQLITESTUDIO_VERSION_INT)
export(SQLITESTUDIO_VERSION_MAJOR)
export(SQLITESTUDIO_VERSION_MINOR)
export(SQLITESTUDIO_VERSION_PATCH)
export(SQLITESTUDIO_VERSION_STRING)

# Add as DEFINES so they're available in C++ code if needed
DEFINES += SQLITESTUDIO_VERSION_INT=$$SQLITESTUDIO_VERSION_INT
DEFINES += SQLITESTUDIO_VERSION_MAJOR=$$SQLITESTUDIO_VERSION_MAJOR
DEFINES += SQLITESTUDIO_VERSION_MINOR=$$SQLITESTUDIO_VERSION_MINOR
DEFINES += SQLITESTUDIO_VERSION_PATCH=$$SQLITESTUDIO_VERSION_PATCH
# Triple-backslash escaping produces a quoted string literal in C++:
# e.g., #define SQLITESTUDIO_VERSION_STRING "4.0.0"
DEFINES += SQLITESTUDIO_VERSION_STRING=\\\"$$SQLITESTUDIO_VERSION_STRING\\\"

