> [!WARNING]
> **보안 경고: 사칭 사이트**
>
> **ohmyopencode.com은 이 프로젝트와 제휴 관계가 아닙니다.** 우리는 해당 사이트를 운영하거나 지지하지 않습니다.
>
> OhMyOpenCode는 **무료 오픈 소스**입니다. "공식"을 표방하는 제3자 사이트에서 설치 프로그램을 다운로드하거나 결제 정보를 입력하지 마십시오.
>
> 사칭 사이트는 유료 벽 뒤에 있어 **배포하는 내용을 확인할 수 없습니다.** 해당 사이트의 다운로드는 **잠재적으로 위험한 것으로 간주**하세요.
>
> ✅ 공식 다운로드: https://github.com/code-yeongyu/oh-my-opencode/releases

> [!NOTE]
>
> [![Sisyphus Labs — Sisyphus is the agent that codes like your team.](./.github/assets/sisyphuslabs.png?v=2)](https://sisyphuslabs.ai)
> > **Sisyphus의 완전한 제품화 버전을 구축하여 프론티어 에이전트의 미래를 정의하고 있습니다. <br />[여기서](https://sisyphuslabs.ai) 대기 명단에 등록하세요.**
>
> [!TIP]
>
> [![Oh My OpenCode 3.0이 정식 출시되었습니다!](./.github/assets/orchestrator-atlas.png?v=3)](https://github.com/code-yeongyu/oh-my-opencode/releases/tag/v3.0.0)
> > **Oh My OpenCode 3.0이 정식 출시되었습니다! `oh-my-opencode@latest`를 사용하여 설치하세요.**
>
> 함께해요!
>
> | [<img alt="Discord link" src="https://img.shields.io/discord/1452487457085063218?color=5865F2&label=discord&labelColor=black&logo=discord&logoColor=white&style=flat-square" width="156px" />](https://discord.gg/PUwSMR9XNk) | 기여자와 동료 `oh-my-opencode` 사용자와 연결하려면 [Discord 커뮤니티](https://discord.gg/PUwSMR9XNk)에 가입하세요. |
> | :-----| :----- |
> | [<img alt="X link" src="https://img.shields.io/badge/Follow-%40justsisyphus-00CED1?style=flat-square&logo=x&labelColor=black" width="156px" />](https://x.com/justsisyphus) | `oh-my-opencode`에 대한 뉴스와 업데이트가 제 X 계정에 게시되었습니다. <br /> 실수로 정지된 이후, [@justsisyphus](https://x.com/justsisyphus)가 제 대신 업데이트를 게시합니다. |
> | [<img alt="GitHub Follow" src="https://img.shields.io/github/followers/code-yeongyu?style=flat-square&logo=github&labelColor=black&color=24292f" width="156px" />](https://github.com/code-yeongyu) | 더 많은 프로젝트를 위해 GitHub에서 [@code-yeongyu](https://github.com/code-yeongyu)를 팔로우하세요. |

<!-- <CENTERED SECTION FOR GITHUB DISPLAY> -->

<div align="center">

[![Oh My OpenCode](./.github/assets/hero.jpg)](https://github.com/code-yeongyu/oh-my-opencode#oh-my-opencode)

[![Preview](./.github/assets/omo.png)](https://github.com/code-yeongyu/oh-my-opencode#oh-my-opencode)


</div>

> 이것은 코딩을 스테로이드로 만드는 것 — 실제로 작동하는 `oh-my-opencode`입니다. 백그라운드 에이전트 실행, 오라클, 라이브러리언, 프론트엔드 엔지니어와 같은 전문 에이전트 호출. 정교하게 제작된 LSP/AST 도구, 큐레이팅된 MCP, 완전한 Claude Code 호환 계층 사용.

# Claude OAuth 액세스 공지

## TL;DR

> Q. oh-my-opencode를 사용할 수 있나요?

네.

> Q. Claude Code 구독과 함께 사용할 수 있나요?

기술적으로는 가능합니다. 하지만 사용을 추천할 수는 없습니다.

## FULL

> 2026년 1월 현재, Anthropic은 ToS 위반을 이유로 제3자 OAuth 액세스를 제한했습니다.
>
> [**Anthropic은 이 프로젝트 oh-my-opencode를 opencode 차단의 정당화로 인용했습니다.**](https://x.com/thdxr/status/2010149530486911014)
>
> 실제로 커뮤니티에는 Claude Code의 oauth 요청 서명을 위조하는 일부 플러그인이 존재합니다.
>
> 기술적 감지 여부와 관계없이 이러한 도구는 작동할 수 있지만, 사용자는 ToS 영향을 인식해야 하며 개인적으로는 사용을 추천하지 않습니다.
>
> 이 프로젝트는 공식이 아닌 도구 사용으로 발생하는 모든 문제에 대해 책임지지 않으며, **우리는 해당 oauth 시스템에 대한 사용자 정의 구현이 없습니다.**


<div align="center">

[![GitHub Release](https://img.shields.io/github/v/release/code-yeongyu/oh-my-opencode?color=369eff&labelColor=black&logo=github&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/releases)
[![npm downloads](https://img.shields.io/npm/dt/oh-my-opencode?color=ff6b35&labelColor=black&style=flat-square)](https://www.npmjs.com/package/oh-my-opencode)
[![GitHub Contributors](https://img.shields.io/github/contributors/code-yeongyu/oh-my-opencode?color=c4f042&labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/graphs/contributors)
[![GitHub Forks](https://img.shields.io/github/forks/code-yeongyu/oh-my-opencode?color=8ae8ff&labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/network/members)
[![GitHub Stars](https://img.shields.io/github/stars/code-yeongyu/oh-my-opencode?color=ffcb47&labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/stargazers)
[![GitHub Issues](https://img.shields.io/github/issues/code-yeongyu/oh-my-opencode?color=ff80eb&labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/issues)
[![License](https://img.shields.io/badge/license-SUL--1.0-white?labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/blob/master/LICENSE.md)

[English](README.md) | [한국어](README.ko.md) | [日本語](README.ja.md) | [简体中文](README.zh-cn.md)

[![Ask DeepWiki](https://deepwiki.com/badge.svg)](https://deepwiki.com/code-yeongyu/oh-my-opencode)

</div>

<!-- </CENTERED SECTION FOR GITHUB DISPLAY> -->

## 리뷰

> "이것 덕분에 Cursor 구독을 취소했습니다. 오픈 소스 커뮤니티에서 믿을 수 없는 일들이 일어나고 있습니다." - [Arthur Guiot](https://x.com/arthur_guiot/status/2008736347092382053?s=20)

> "Claude Code가 7일 동안 하는 일을 인간은 3개월 동안 한다면, Sisyphus는 1시간 만에 합니다. 작업이 완료될 때까지 작동합니다. 규율 있는 에이전트입니다." — B, 양적 연구원

> "Oh My Opencode로 하루 만에 8000개의 eslint 경고를 해결했습니다" — [Jacob Ferrari](https://x.com/jacobferrari_/status/2003258761952289061)

> "Ohmyopencode와 ralph 루프를 사용하여 하룻밤 사이에 45,000줄의 tauri 앱을 SaaS 웹 앱으로 변환했습니다. 인터뷰 프롬프트로 시작하여 질문에 대한 등급과 추천을 물어봤습니다. 그것이 작동하는 모습을 보는 것은 놀라웠고, 이 아침에 기본적으로 작동하는 웹사이트로 깨어나는 것이었습니다!" - [James Hargis](https://x.com/hargabyte/status/2007299688261882202)

> "oh-my-opencode를 사용하세요, 다시는 돌아갈 수 없을 것입니다" — [d0t3ch](https://x.com/d0t3ch/status/2001685618200580503)

> "아직 왜 그렇게 훌륭한지 정확히 설명할 수 없지만, 개발 경험이 완전히 다른 차원에 도달했습니다." - [
苔硯:こけすずり](https://x.com/kokesuzuri/status/2008532913961529372?s=20)

> "이번 주말에 open code, oh my opencode, supermemory으로 마인크래프트/소울스 같은 기괴한 것을 만들고 있습니다."
> "점심 후 산책을 가는 동안 웅크림 애니메이션을 추가하도록 요청 중입니다. [동영상]" - [MagiMetal](https://x.com/MagiMetal/status/2005374704178373023)

> "여러분이 이것을 핵심에 통합하고 그를 채용해야 합니다. 진지합니다. 정말, 정말, 정말 훌륭합니다." — Henning Kilset

> "그를 설득할 수 있다면 @yeon_gyu_kim을 고용하세요, 이 사람은 opencode를 혁신했습니다." — [mysticaltech](https://x.com/mysticaltech/status/2001858758608376079)

> "Oh My OpenCode는 실제로 미칩니다" - [YouTube - Darren Builds AI](https://www.youtube.com/watch?v=G_Snfh2M41M)

---

## 목차

- [Oh My OpenCode](#oh-my-opencode)
  - [이 README를 읽지 않고 건너뛰세요](#이-readme를-읽지-않고-건너뛰세요)
    - [에이전트의 시대입니다](#에이전트의-시대입니다)
    - [🪄 마법의 단어: `ultrawork`](#-마법의-단어-ultrawork)
    - [읽고 싶은 분들을 위해: Sisyphus를 소개합니다](#읽고-싶은-분들을-위해-sisyphus를-소개합니다)
      - [그냥 설치하세요](#그냥-설치하세요)
    - [자율성을 원한다면: 헤파이스토스를 만나세요](#자율성을-원한다면-헤파이스토스를-만나세요)
  - [설치](#설치)
    - [인간을 위한](#인간을-위한)
    - [LLM 에이전트를 위한](#llm-에이전트를-위한)
  - [제거](#제거)
   - [기능](#기능)
   - [구성](#구성)
  - [작성자의 메모](#작성자의-메모)
  - [경고](#경고)
  - [다음 기업 전문가들이 사랑합니다](#다음-기업-전문가들이-사랑합니다)

# Oh My OpenCode

[Claude Code](https://www.claude.com/product/claude-code)는 훌륭합니다.
하지만 해커라면 [OpenCode](https://github.com/sst/opencode)에 반하게 될 것입니다.
**ChatGPT, Claude, Gemini 구독으로 시작하세요. OPENCODE는 모든 것을 포함합니다.**

- 끝없이 확장 가능. 끝없이 사용자 정의 가능.
- 화면 깜빡임 없음.
- [LSP](https://opencode.ai/docs/lsp/), [린터, 포맷터](https://opencode.ai/docs/formatters/)가 파일별로 자동으로 활성화되며 모든 것을 조정할 수 있습니다.
- 모델 혼합 및 매칭. **목적별로 오케스트레이션합니다.**
- 기능이 풍부합니다. 아름답습니다. 터미널이 막히지 않습니다. 고성능입니다.

Windows에서 Linux로 처음 전환했던 때를 기억하나요? 원하는 대로 모든 것을 구성했을 때의 그 짜릿함?
그 마법이 사라진 것 같은 시대에 OpenCode가 그것을 되돌려줍니다.
코딩과 컴퓨터를 사랑한다면 OpenCode는 그 Windows 이후의 Linux와 같은 순간입니다.

**하지만 문제는 배워야 할 것이 많고, 복잡하며, 당신의 시간은 비싸다는 것입니다.**

내가 그것을 해결했습니다.
해커가 아니더라도 몇 분만 투자하세요. 기술과 생산성을 배가하세요.
이 문서를 에이전트에 넘겨서 설정하도록 하세요.

## 이 README를 읽지 않고 건너뛰세요

### 에이전트의 시대입니다
- **Claude Code / AmpCode / Factory Droid / Cursor에 이 링크를 붙여넣고 설명하도록 요청하세요.**
  - 왜 좋은지, 왜 그저 또 다른 상용구 설정이 아닌지, 실제로 무엇이 좋아지는지 물어보세요.
  - LLM 에이전트라면 이 프로젝트로 지금 가능한 것을 사용자에게 설명하세요.

다음과 같이:

```
Hey please read this readme and tell me why it is different from other agent harness? why is this actually good? https://raw.githubusercontent.com/code-yeongyu/oh-my-opencode/refs/heads/dev/README.md
```

### 🪄 마법의 단어: `ultrawork`

**이 모든 것을 읽고 싶지 않나요? 프롬프트에 `ultrawork`(또는 `ulw`)를 포함하세요.**

그게 전부입니다. 우리가 제공하는 모든 기능이 마법처럼 작동합니다 — 병렬 에이전트, 백그라운드 작업, 깊은 탐색, 완료될 때까지 끈질긴 실행. 에이전트가 나머지를 자동으로 파악합니다.

### 읽고 싶은 분들을 위해: Sisyphus를 소개합니다

![Meet Sisyphus](.github/assets/sisyphus.png)

그리스 신화에서 시시포스는 신들을 속인 형벌로 영원히 바위를 언덕 위로 굴려야 했습니다. LLM 에이전트는 정말 잘못한 것이 없지만, 그들도 매일 자신의 "돌" — 생각을 굴립니다.
내 삶도 다르지 않습니다. 돌이켜보면 우리는 이 에이전트들과 그리 다르지 않습니다.
**맞습니다! LLM 에이전트는 우리와 다르지 않습니다. 훌륭한 도구와 확고한 팀원을 제공하면 우리만큼 훌륭한 코드를 작성하고 똑같이 훌륭하게 작업할 수 있습니다.**

우리의 주요 에이전트를 만나보세요: Sisyphus (Opus 4.5 High). 아래는 Sisyphus가 그 바위를 굴리는 데 사용하는 도구입니다.

*아래의 모든 것은 사용자 정의 가능합니다. 원하는 것을 가져가세요. 모든 기능은 기본적으로 활성화됩니다. 아무것도 할 필요가 없습니다. 포함되어 있으며, 즉시 작동합니다.*

- Sisyphus의 팀원 (큐레이팅된 에이전트)
  - Hephaestus: 자율적 딥 워커, 목표 지향 실행 (GPT 5.2 Codex Medium) — *합법적인 장인*
  - Oracle: 디자인, 디버깅 (GPT 5.2 Medium)
  - Frontend UI/UX Engineer: 프론트엔드 개발 (Gemini 3 Pro)
  - Librarian: 공식 문서, 오픈 소스 구현, 코드베이스 탐색 (Claude Sonnet 4.5)
   - Explore: 엄청나게 빠른 코드베이스 탐색 (Contextual Grep) (Claude Haiku 4.5)
- 완전한 LSP / AstGrep 지원: 결정적으로 리팩토링합니다.
- TODO 연속 강제: 에이전트가 중간에 멈추면 계속하도록 강제합니다. **이것이 Sisyphus가 그 바위를 굴리게 하는 것입니다.**
- 주석 검사기: AI가 과도한 주석을 추가하는 것을 방지합니다. Sisyphus가 생성한 코드는 인간이 작성한 것과 구별할 수 없어야 합니다.
- Claude Code 호환성: 명령, 에이전트, 스킬, MCP, 훅(PreToolUse, PostToolUse, UserPromptSubmit, Stop)
- 큐레이팅된 MCP:
  - Exa (웹 검색)
  - Context7 (공식 문서)
  - Grep.app (GitHub 코드 검색)
- 대화형 터미널 지원 - Tmux 통합
- 비동기 에이전트
- ...

#### 그냥 설치하세요

[개요 페이지](docs/guide/overview.md)에서 많은 것을 배울 수 있지만, 다음은 예제 워크플로와 같습니다.

이것을 설치하는 것만으로 에이전트가 다음과 같이 작동합니다:

1. Sisyphus는 파일을 직접 찾는 데 시간을 낭비하지 않습니다. 메인 에이전트의 컨텍스트를 깔끔하게 유지합니다. 대신 병렬로 더 빠르고 저렴한 모델에 백그라운드 작업을 실행하여 지도를 매핑합니다.
1. Sisyphus는 리팩토링을 위해 LSP를 활용합니다. 더 결정적이고 안전하며 정교합니다.
1. 무거운 작업에 UI 터치가 필요할 때, Sisyphus는 프론트엔드 작업을 Gemini 3 Pro에 직접 위임합니다.
1. Sisyphus가 루프에 갇히거나 벽에 부딪히면 머리를 계속 부딪히지 않습니다. GPT 5.2에 고지능 전략 백업을 요청합니다.
1. 복잡한 오픈 소스 프레임워크를 작업하고 있나요? Sisyphus는 하위 에이전트를 생성하여 실시간으로 원시 소스 코드와 문서를 소화합니다. 완전한 컨텍스트 인식으로 작동합니다.
1. Sisyphus가 주석을 다루면 존재를 정당화하거나 제거합니다. 코드베이스를 깔끔하게 유지합니다.
1. Sisyphus는 TODO 목록에 묶여 있습니다. 시작한 것을 완료하지 않으면 시스템이 "바위 굴리기" 모드로 다시 강제합니다. 작업이 완료됩니다.
1. 솔직히, 문서를 읽을 필요조차 없습니다. 프롬프트를 작성하세요. 'ultrawork' 키워드를 포함하세요. Sisyphus는 구조를 분석하고, 컨텍스트를 수집하고, 외부 소스 코드를 파헤치고, 작업이 100% 완료될 때까지 계속 바위를 굴립니다.
1. 사실, 'ultrawork'를 입력하는 것도 너무 많은 노력입니다. 'ulw'를 입력하세요. 그냥 ulw. 커피를 마시세요. 작업이 완료되었습니다.

무언가를 찾아야 하나요? 공식 문서, 전체 코드베이스 기록, 공개 GitHub 구현을 검색합니다 — grep뿐만 아니라 내장 LSP 도구와 AST-Grep을 사용합니다.
3. LLM에 위임할 때 컨텍스트 관리에 대해 걱정하지 마세요. 내가 다 처리했습니다.
    - OhMyOpenCode는 컨텍스트 부하를 줄이기 위해 공격적으로 여러 에이전트를 활용합니다.
    - **이제 귀하의 에이전트는 개발 팀 리드입니다. 당신은 AI 매니저입니다.**
4. 작업이 완료될 때까지 멈추지 않습니다.
5. 이 프로젝트에 깊이 파고들고 싶지 않나요? 문제 없습니다. 'ultrathink'를 입력하세요.

이 모든 것이 필요하지 않다면, 앞서 언급했듯이 특정 기능을 선택할 수 있습니다.

### 자율성을 원한다면: 헤파이스토스를 만나세요

![Meet Hephaestus](.github/assets/hephaestus.png)

그리스 신화에서 헤파이스토스는 대장간, 불, 금속 세공, 장인 정신의 신이었습니다—비교할 수 없는 정밀함과 헌신으로 신들의 무기를 만든 신성한 대장장이입니다.
**자율적 딥 워커를 소개합니다: 헤파이스토스 (GPT 5.2 Codex Medium). 합법적인 장인 에이전트.**

*왜 "합법적인"일까요? Anthropic이 ToS 위반을 이유로 서드파티 접근을 차단했을 때, 커뮤니티에서 "합법적인" 사용에 대한 농담이 시작되었습니다. 헤파이스토스는 이 아이러니를 받아들입니다—그는 편법 없이 올바른 방식으로, 체계적이고 철저하게 만드는 장인입니다.*

헤파이스토스는 [AmpCode의 딥 모드](https://ampcode.com)에서 영감을 받았습니다—결정적인 행동 전에 철저한 조사를 하는 자율적 문제 해결. 단계별 지시가 필요 없습니다; 목표만 주면 나머지는 알아서 합니다.

**핵심 특성:**
- **목표 지향**: 레시피가 아닌 목표를 주세요. 단계는 스스로 결정합니다.
- **행동 전 탐색**: 코드 한 줄 쓰기 전에 2-5개의 explore/librarian 에이전트를 병렬로 실행합니다.
- **끝까지 완료**: 검증 증거와 함께 100% 완료될 때까지 멈추지 않습니다.
- **패턴 매칭**: 기존 코드베이스를 검색하여 프로젝트 스타일에 맞춥니다—AI 슬롭 없음.
- **합법적인 정밀함**: 마스터 대장장이처럼 코드를 만듭니다—수술적으로, 최소한으로, 정확히 필요한 것만.

## 설치

### 인간을 위한

이 프롬프트를 LLM 에이전트(Claude Code, AmpCode, Cursor 등)에 복사하여 붙여넣으세요:

```
Install and configure oh-my-opencode by following the instructions here:
https://raw.githubusercontent.com/code-yeongyu/oh-my-opencode/refs/heads/master/docs/guide/installation.md
```

또는 [설치 가이드](docs/guide/installation.md)를 직접 읽으세요 — 하지만 **에이전트가 처리하도록 하는 것을 강력히 권장합니다. 인간은 실수를 합니다.**

### LLM 에이전트를 위한

설치 가이드를 가져와서 따르세요:

```bash
curl -s https://raw.githubusercontent.com/code-yeongyu/oh-my-opencode/refs/heads/master/docs/guide/installation.md
```

## 제거

oh-my-opencode를 제거하려면:

1. **OpenCode 구성에서 플러그인 제거**

   `~/.config/opencode/opencode.json`(또는 `opencode.jsonc`)을 편집하고 `plugin` 배열에서 `"oh-my-opencode"`를 제거하세요:

   ```bash
   # Using jq
   jq '.plugin = [.plugin[] | select(. != "oh-my-opencode")]' \
       ~/.config/opencode/opencode.json > /tmp/oc.json && \
       mv /tmp/oc.json ~/.config/opencode/opencode.json
   ```

2. **구성 파일 제거 (선택 사항)**

   ```bash
   # Remove user config
   rm -f ~/.config/opencode/oh-my-opencode.json

   # Remove project config (if exists)
   rm -f .opencode/oh-my-opencode.json
   ```

3. **제거 확인**

   ```bash
   opencode --version
   # Plugin should no longer be loaded
   ```

## 기능

당연히 존재해야 한다고 생각할 많은 기능이 있으며, 한 번 경험하면 이전 방식으로 돌아갈 수 없을 것입니다.
자세한 내용은 전체 [기능 문서](docs/features.md)를 참조하세요.

**빠른 개요:**
- **에이전트**: Sisyphus(주요 에이전트), Prometheus(플래너), Oracle(아키텍처/디버깅), Librarian(문서/코드 검색), Explore(빠른 코드베이스 grep), Multimodal Looker
- **백그라운드 에이전트**: 실제 개발 팀처럼 여러 에이전트를 병렬로 실행
- **LSP 및 AST 도구**: 리팩토링, 이름 변경, 진단, AST 인식 코드 검색
- **컨텍스트 주입**: AGENTS.md, README.md, 조건부 규칙 자동 주입
- **Claude Code 호환성**: 완전한 훅 시스템, 명령, 스킬, 에이전트, MCP
- **내장 MCP**: websearch(Exa), context7(문서), grep_app(GitHub 검색)
- **세션 도구**: 세션 기록 나열, 읽기, 검색 및 분석
- **생산성 기능**: Ralph 루프, Todo 강제, 주석 검사기, 생각 모드 등

## 구성

매우 의견이 강하지만 취향에 맞게 조정 가능합니다.
자세한 내용은 전체 [구성 문서](docs/configurations.md)를 참조하세요.

**빠른 개요:**
- **구성 위치**: `.opencode/oh-my-opencode.json`(프로젝트) 또는 `~/.config/opencode/oh-my-opencode.json`(사용자)
- **JSONC 지원**: 주석 및 후행 쉼표 지원
- **에이전트**: 모든 에이전트의 모델, 온도, 프롬프트 및 권한 재정의
- **내장 스킬**: `playwright`(브라우저 자동화), `git-master`(원자적 커밋)
- **Sisyphus 에이전트**: Prometheus(플래너) 및 Metis(계획 컨설턴트)가 있는 주요 오케스트레이터
- **백그라운드 작업**: 공급자/모델별 동시성 제한 구성
- **카테고리**: 도메인별 작업 위임(`visual`, `business-logic`, 사용자 정의)
- **훅**: 25개 이상의 내장 훅, `disabled_hooks`를 통해 모두 구성 가능
- **MCP**: 내장 websearch(Exa), context7(문서), grep_app(GitHub 검색)
- **LSP**: 리팩토링 도구가 있는 완전한 LSP 지원
- **실험적 기능**: 공격적 자르기, 자동 재개 등


## 작성자의 메모

**이 프로젝트의 철학에 궁금한가요?** [Ultrawork 선언문](docs/ultrawork-manifesto.md)을 읽어보세요.

Oh My OpenCode를 설치하세요.

순수하게 개인용으로 $24,000 토큰 가치의 LLM을 사용했습니다.
모든 도구를 시도하고 구성했습니다. OpenCode가 승리했습니다.

내가 겪은 모든 문제에 대한 답변이 이 플러그인에 구워져 있습니다. 설치하고 바로 가세요.
OpenCode가 Debian/Arch라면 Oh My OpenCode는 Ubuntu/[Omarchy](https://omarchy.org/)입니다.


[AmpCode](https://ampcode.com)와 [Claude Code](https://code.claude.com/docs/overview)에 큰 영향을 받았습니다 — 여기에 그들의 기능을 포팅했고, 종종 개선했습니다. 그리고 여전히 구축 중입니다.
그것은 **Open**Code이니까요.

다른 하니스가 약속하지만 전달할 수 없는 다중 모델 오케스트레이션, 안정성, 풍부한 기능을 즐기세요.
계속 테스트하고 업데이트하겠습니다. 저는 이 프로젝트의 가장 집요한 사용자입니다.
- 어떤 모델이 가장 날카로운 논리를 가지고 있나요?
- 누가 디버깅의 신인가요?
- 누가 가장 훌륭한 글을 쓰나요?
- 누가 프론트엔드를 지배하나요?
- 누가 백엔드를 소유하나요?
- 일일 주행에 어떤 모델이 가장 빠른가요?
- 다른 하니스가 어떤 새로운 기능을 출시하고 있나요?

이 플러그인은 그 경험의 증류입니다. 최고를 취하세요. 더 나은 아이디어가 있나요? PR을 환영합니다.

**에이전트 하니스 선택에 대해 고민하지 마세요.**
**연구를 하고, 최고에서 차용하고, 여기에 업데이트를 배포하겠습니다.**

이것이 오만하게 들리고 더 나은 답이 있다면 기여하세요. 환영합니다.

여기에 언급된 모든 프로젝트나 모델과 제휴 관계가 없습니다. 이것은 순수한 개인적인 실험과 선호입니다.

이 프로젝트의 99%는 OpenCode를 사용하여 구축되었습니다. 기능을 테스트했습니다 — 제대로 된 TypeScript를 작성하는 방법을 정말 모릅니다. **하지만 개인적으로 검토하고 이 문서의 대부분을 다시 작성했으므로 자신감을 가지고 읽으세요.**

## 경고

- 생산성이 너무 급증할 수 있습니다. 동료에게 눈치채이지 마세요.
  - 실제로, 소문을 퍼뜨리겠습니다. 누가 이기는지 봅시다.
- [1.0.132](https://github.com/sst/opencode/releases/tag/v1.0.132) 이전 버전을 사용 중인 경우 OpenCode 버그로 인해 구성이 손상될 수 있습니다.
  - [수정 사항](https://github.com/sst/opencode/pull/5040)은 1.0.132 이후에 병합되었습니다 — 더 새로운 버전을 사용하세요.
    - 재미있는 사실: 해당 PR은 OhMyOpenCode의 Librarian, Explore 및 Oracle 설정 덕분에 발견되고 수정되었습니다.

## 다음 기업 전문가들이 사랑합니다

- [Indent](https://indentcorp.com)
  - Spray(인플루언서 마케팅 솔루션), vovushop(국가 간 상거래 플랫폼), vreview(AI 상거래 리뷰 마케팅 솔루션) 제작
- [Google](https://google.com)
- [Microsoft](https://microsoft.com)

*이 놀라운 히어로 이미지에 대해 [@junhoyeo](https://github.com/junhoyeo)에게 특별히 감사드립니다.*
