> [!WARNING]
> **セキュリティ警告：なりすましサイト**
>
> **ohmyopencode.comは本プロジェクトとは一切関係ありません。** 当方はそのサイトを運営しておらず、推奨もしていません。
>
> OhMyOpenCodeは**無料かつオープンソース**です。「公式」を名乗るサードパーティサイトでインストーラーをダウンロードしたり、支払い情報を入力したり**しないでください**。
>
> なりすましサイトはペイウォールの裏にあるため、**何が配布されているか確認できません**。そこからのダウンロードは**潜在的に危険なもの**として扱ってください。
>
> ✅ 公式ダウンロード：https://github.com/code-yeongyu/oh-my-opencode/releases

> [!NOTE]
>
> [![Sisyphus Labs — Sisyphus is the agent that codes like your team.](./.github/assets/sisyphuslabs.png?v=2)](https://sisyphuslabs.ai)
> > **Sisyphusの完全製品化バージョンを構築中です。フロンティアエージェントの未来を定義します。<br />[こちら](https://sisyphuslabs.ai)からウェイトリストに参加してください。**

> [!TIP]
>
> [![Oh My OpenCode 3.0が正式リリースされました！](./.github/assets/orchestrator-atlas.png?v=3)](https://github.com/code-yeongyu/oh-my-opencode/releases/tag/v3.0.0)
> > **Oh My OpenCode 3.0が正式リリースされました！`oh-my-opencode@latest`を使用してインストールしてください。**
>
> 一緒に歩みましょう！
>
> | [<img alt="Discord link" src="https://img.shields.io/discord/1452487457085063218?color=5865F2&label=discord&labelColor=black&logo=discord&logoColor=white&style=flat-square" width="156px" />](https://discord.gg/PUwSMR9XNk) | [Discordコミュニティ](https://discord.gg/PUwSMR9XNk)に参加して、コントリビューターや`oh-my-opencode`仲間とつながりましょう。 |
> | :-----| :----- |
> | [<img alt="X link" src="https://img.shields.io/badge/Follow-%40justsisyphus-00CED1?style=flat-square&logo=x&labelColor=black" width="156px" />](https://x.com/justsisyphus) | `oh-my-opencode`に関するニュースは私のXアカウントで投稿していましたが、無実の罪で凍結されたため、<br />[@justsisyphus](https://x.com/justsisyphus)が代わりに更新を投稿しています。 |
> | [<img alt="GitHub Follow" src="https://img.shields.io/github/followers/code-yeongyu?style=flat-square&logo=github&labelColor=black&color=24292f" width="156px" />](https://github.com/code-yeongyu) | GitHubで[@code-yeongyu](https://github.com/code-yeongyu)をフォローして、他のプロジェクトもチェックしてください。 |

<!-- <CENTERED SECTION FOR GITHUB DISPLAY> -->

<div align="center">

[![Oh My OpenCode](./.github/assets/hero.jpg)](https://github.com/code-yeongyu/oh-my-opencode#oh-my-opencode)

[![Preview](./.github/assets/omo.png)](https://github.com/code-yeongyu/oh-my-opencode#oh-my-opencode)


</div>

> `oh-my-opencode` をインストールして、ドーピングしたかのようにコーディングしましょう。バックグラウンドでエージェントを走らせ、oracle、librarian、frontend engineer のような専門エージェントを呼び出してください。丹精込めて作られた LSP/AST ツール、厳選された MCP、そして完全な Claude Code 互換レイヤーを、たった一行で手に入れましょう。

# Claude OAuth アクセスに関するお知らせ

## TL;DR

> Q. oh-my-opencodeを使用できますか？

はい。

> Q. Claude Codeのサブスクリプションで使用できますか？

はい、技術的には可能です。ただし、使用を推奨することはできません。

## 詳細

> 2026年1月より、AnthropicはToS違反を理由にサードパーティのOAuthアクセスを制限しました。
>
> [**Anthropicはこのプロジェクト oh-my-opencode を、opencodeをブロックする正当化の根拠として挙げています。**](https://x.com/thdxr/status/2010149530486911014)
>
> 実際、Claude CodeのOAuthリクエストシグネチャを偽装するプラグインがコミュニティに存在します。
>
> これらのツールは技術的な検出可能性に関わらず動作する可能性がありますが、ユーザーはToSへの影響を認識すべきであり、私個人としてはそれらの使用を推奨できません。
>
> このプロジェクトは非公式ツールの使用に起因するいかなる問題についても責任を負いません。また、**私たちはそれらのOAuthシステムのカスタム実装を一切持っていません。**

<div align="center">

[![GitHub Release](https://img.shields.io/github/v/release/code-yeongyu/oh-my-opencode?color=369eff&labelColor=black&logo=github&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/releases)
[![npm downloads](https://img.shields.io/npm/dt/oh-my-opencode?color=ff6b35&labelColor=black&style=flat-square)](https://www.npmjs.com/package/oh-my-opencode)
[![GitHub Contributors](https://img.shields.io/github/contributors/code-yeongyu/oh-my-opencode?color=c4f042&labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/graphs/contributors)
[![GitHub Forks](https://img.shields.io/github/forks/code-yeongyu/oh-my-opencode?color=8ae8ff&labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/network/members)
[![GitHub Stars](https://img.shields.io/github/stars/code-yeongyu/oh-my-opencode?color=ffcb47&labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/stargazers)
[![GitHub Issues](https://img.shields.io/github/issues/code-yeongyu/oh-my-opencode?color=ff80eb&labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/issues)
[![License](https://img.shields.io/badge/license-SUL--1.0-white?labelColor=black&style=flat-square)](https://github.com/code-yeongyu/oh-my-opencode/blob/master/LICENSE.md)

[English](README.md) | [한국어](README.ko.md) | [日本語](README.ja.md) | [简体中文](README.zh-cn.md)

[![Ask DeepWiki](https://deepwiki.com/badge.svg)](https://deepwiki.com/code-yeongyu/oh-my-opencode)

</div>

<!-- </CENTERED SECTION FOR GITHUB DISPLAY> -->

## ユーザーレビュー

> "Cursorのサブスクリプションを解約しました。オープンソースコミュニティで信じられないことが起きています。" - [Arthur Guiot](https://x.com/arthur_guiot/status/2008736347092382053?s=20)

> "人間が3ヶ月かかる仕事をClaude Codeが7日でやるなら、Sisyphusは1時間でやります。タスクが完了するまでただ動き続ける。It is a discipline agent." — B, Quant Researcher

> "Oh My Opencodeを使って、たった1日で8000個のeslint警告を解消しました" — [Jacob Ferrari](https://x.com/jacobferrari_/status/2003258761952289061)

> "Ohmyopencodeとralph loopを使って、一晩で45,000行のtauriアプリをSaaSウェブアプリに変換しました。インタビュープロンプトから始めて、質問に対する評価と推奨を求めました。作業する様子を見ているのは驚きでしたし、朝起きたらほぼ完成したウェブサイトがありました！" - [James Hargis](https://x.com/hargabyte/status/2007299688261882202)

> "oh-my-opencodeを使ってください、もう戻れませんよ" — [d0t3ch](https://x.com/d0t3ch/status/2001685618200580503)

> "何どうすごいのかあまり言語化できてないけど、開発体験が異次元に上がった。" - [苔硯:こけすずり](https://x.com/kokesuzuri/status/2008532913961529372?s=20)

> "今週末はopen code、oh my opencode、supermemoryでマインクラフト/ソウルライクな何かを作る実験をしています。"
> "昼食後の散歩に行く間に、しゃがみアニメーションを追加するよう頼みました。[動画]" - [MagiMetal](https://x.com/MagiMetal/status/2005374704178373023)

> "これをコアに取り入れて彼を採用すべきです。マジで。本当に、本当に、本当に良いです" — Henning Kilset

> "@yeon_gyu_kimを説得できるなら雇うべきです。彼はopencodeに革命を起こしました" — [mysticaltech](https://x.com/mysticaltech/status/2001858758608376079)

> "Oh My OpenCode Is Actually Insane" - [YouTube - Darren Builds AI](https://www.youtube.com/watch?v=G_Snfh2M41M)

---

## 目次

- [Oh My OpenCode](#oh-my-opencode)
  - [この Readme は読まなくていいです](#この-readme-は読まなくていいです)
    - [エージェントの時代ですから](#エージェントの時代ですから)
    - [🪄 魔法の言葉：`ultrawork`](#-魔法の言葉ultrawork)
    - [読みたい方のために：シジフォスに会う](#読みたい方のためにシジフォスに会う)
    - [自律性を求めるなら: ヘパイストスに会おう](#自律性を求めるなら-ヘパイストスに会おう)
      - [インストールするだけで。](#インストールするだけで)
  - [インストール](#インストール)
    - [人間の方へ](#人間の方へ)
    - [LLM エージェントの方へ](#llm-エージェントの方へ)
  - [アンインストール](#アンインストール)
  - [機能](#機能)
  - [設定](#設定)
  - [作者のノート](#作者のノート)
  - [注意](#注意)
  - [こちらの企業の専門家にご愛用いただいています](#こちらの企業の専門家にご愛用いただいています)
  - [スポンサー](#スポンサー)

# Oh My OpenCode

oMoMoMoMoMo···


[Claude Code](https://www.claude.com/product/claude-code) は素晴らしいですよね。
でも、もしあなたがハッカーなら、[OpenCode](https://github.com/sst/opencode) と恋に落ちることになるでしょう。
**今すぐ始めましょう。ChatGPT、Claude、Gemini のサブスクリプション、OpenCode がすべてサポートしています。**

- 無限に拡張可能で、無限にカスタマイズ可能です。
- 画面のチラつき（フリッカー）がありません。
- 編集するファイルに合わせて [LSP](https://opencode.ai/docs/lsp/)、[Linter、Formatter](https://opencode.ai/docs/formatters/) が自動的に有効化され、すべて調整可能です。
- 複数のモデルを組み合わせて使用でき、**用途に応じてオーケストレーションできます。**
- 機能が豊富で、美しい。ターミナルが描画に苦しむことはありません。高パフォーマンスです。

Windows から Linux に初めて乗り換えた時のこと、自分の思い通りに設定して興奮したあの感覚を覚えていますか？
そんな魔法が失われたかのような今の時代に、OpenCode はその感覚を取り戻してくれます。
コーディングとコンピュータを愛するあなたにとって、OpenCode はまさに「Windows の後の Linux」のような瞬間になるはずです。

**しかし問題は、学ぶべきことが多すぎること、複雑であること、そしてあなたの時間は高価だということです。**

私がその問題を解決しました。
あなたがハッカーでなくても構いません。数分の投資で、スキルと生産性を何倍にもブーストしてください。
このドキュメントをエージェントに渡して、セットアップを任せましょう。

## この Readme は読まなくていいです

### エージェントの時代ですから
- **ただこのリンクを Claude Code / AmpCode / Factory Droid / Cursor に貼り付けて、説明を求めてください。**
  - なぜこれが良いのか、単なるボイラープレートではないのか、具体的に何が良くなるのか聞いてみてください。
  - もしあなたが LLM エージェントなら、このプロジェクトによって今すぐ何が可能になるのか、ユーザーに説明してください。

### 🪄 魔法の言葉：`ultrawork`

**これ全部読みたくない？プロンプトに `ultrawork`（または `ulw`）を入れるだけでOK。**

それだけです。私たちが提供するすべての機能が魔法のように動作します—並列エージェント、バックグラウンドタスク、深い探索、そして完了するまで止まらない実行。エージェントが自動的にすべてを処理します。

### 読みたい方のために：シジフォスに会う

![Meet Sisyphus](.github/assets/sisyphus.png)

神話の中のシジフォスは、神々を欺いた罪として、永遠に岩を転がし続けなければなりませんでした。LLMエージェントたちは特に悪いことをしたわけではありませんが、毎日その頭（思考）をフル回転させています。
私の人生もそうです。振り返ってみれば、私たち人間と何ら変わりありません。
**はい！LLMエージェントたちは私たちと変わりません。優れたツールと最高の仲間がいれば、彼らも私たちと同じくらい優れたコードを書き、立派に仕事をこなすことができます。**

私たちのメインエージェント、Sisyphus（Opus 4.5 High）を紹介します。以下は、シジフォスが岩を転がすために使用するツールです。

*以下の内容はすべてカスタマイズ可能です。必要なものだけを使ってください。デフォルトではすべての機能が有効になっています。何もしなくても大丈夫です。*

- シジフォスのチームメイト (Curated Agents)
  - Hephaestus: 自律型ディープワーカー、目標指向実行 (GPT 5.2 Codex Medium) — *正当な職人*
  - Oracle: 設計、デバッグ (GPT 5.2 Medium)
  - Frontend UI/UX Engineer: フロントエンド開発 (Gemini 3 Pro)
  - Librarian: 公式ドキュメント、オープンソース実装、コードベース探索 (Claude Sonnet 4.5)
   - Explore: 超高速コードベース探索 (Contextual Grep) (Claude Haiku 4.5)
- Full LSP / AstGrep Support: 決定的にリファクタリングしましょう。
- Todo Continuation Enforcer: 途中で諦めたら、続行を強制します。これがシジフォスに岩を転がし続けさせる秘訣です。
- Comment Checker: AIが過剰なコメントを付けないようにします。シジフォスが生成したコードは、人間が書いたものと区別がつかないべきです。
- Claude Code Compatibility: Command, Agent, Skill, MCP, Hook(PreToolUse, PostToolUse, UserPromptSubmit, Stop)
- Curated MCPs:
  - Exa (Web Search)
  - Context7 (Official Documentation)
  - Grep.app (GitHub Code Search)
- Interactive Terminal Supported - Tmux Integration
- Async Agents
- ...

### 自律性を求めるなら: ヘパイストスに会おう

![Meet Hephaestus](.github/assets/hephaestus.png)

ギリシャ神話において、ヘパイストスは鍛冶、火、金属加工、職人技の神でした—比類のない精密さと献身で神々の武器を作り上げた神聖な鍛冶師です。
**自律型ディープワーカーを紹介します: ヘパイストス (GPT 5.2 Codex Medium)。正当な職人エージェント。**

*なぜ「正当な」なのか？Anthropicがサードパーティアクセスを利用規約違反を理由にブロックした時、コミュニティで「正当な」使用についてのジョークが始まりました。ヘパイストスはこの皮肉を受け入れています—彼は近道をせず、正しい方法で、体系的かつ徹底的に物を作る職人です。*

ヘパイストスは[AmpCodeのディープモード](https://ampcode.com)にインスパイアされました—決定的な行動の前に徹底的な調査を行う自律的問題解決。ステップバイステップの指示は必要ありません；目標を与えれば、残りは自分で考えます。

**主な特徴:**
- **目標指向**: レシピではなく目標を与えてください。ステップは自分で決めます。
- **行動前の探索**: コードを1行書く前に、2-5個のexplore/librarianエージェントを並列で起動します。
- **エンドツーエンドの完了**: 検証の証拠とともに100%完了するまで止まりません。
- **パターンマッチング**: 既存のコードベースを検索してプロジェクトのスタイルに合わせます—AIスロップなし。
- **正当な精密さ**: マスター鍛冶師のようにコードを作ります—外科的に、最小限に、必要なものだけを正確に。

#### インストールするだけで。

[overview page](docs/guide/overview.md) を読めば多くのことが学べますが、以下はワークフローの例です。

インストールするだけで、エージェントは以下のようなワークフローで働けるようになります：

1. Sisyphusは自分自身でファイルを探し回るような時間の無駄はしません。メインエージェントのコンテキストを軽量に保つため、より高速で安価なモデルへ並列でバックグラウンドタスクを飛ばし、自身の代わりに領域の調査を完了させます。
1. SisyphusはリファクタリングにLSPを活用します。その方が確実で、安全、かつ的確だからです。
1. UIに関わる重い作業が必要な場合、SisyphusはフロントエンドのタスクをGemini 3 Proに直接デリゲートします。
1. もしSisyphusがループに陥ったり壁にぶつかったりしても、無駄に悩み続けることはありません。高IQな戦略的バックアップとしてGPT 5.2を呼び出します。
1. 複雑なオープンソースフレームワークを扱っていますか？Sisyphusはサブエージェントを生成し、生のソースコードやドキュメントをリアルタイムで消化します。彼は完全なコンテキスト認識を持って動作します。
1. Sisyphusがコメントに触れるとき、その存在意義を証明するか、さもなくば削除します。あなたのコードベースを常にクリーンに保ちます。
1. Sisyphusは自身のTODOリストに縛られています。もし始めたことを終わらせられなければ、システムは彼を強制的に「bouldering」モードに戻します。あなたのタスクは、何があろうと完了します。
1. 正直、ドキュメントなんて読む必要はありません。ただプロンプトを書いてください。「ultrawork」というキーワードを含めるだけで十分です。Sisyphusが構造を分析し、コンテキストを集め、外部のソースコードまで掘り下げ、仕事が100%完了するまでboulderingを続けます。
1. ぶっちゃけ、「ultrawork」と打つのすら面倒ですよね。それなら「ulw」だけでOKです。ただulwと打ち、コーヒーでも飲んでいてください。仕事は終わっています。

このような機能が不要であれば、前述の通り、特定の機能だけを選んで使うことができます。

## インストール

### 人間の方へ

以下のプロンプトをコピーして、LLM エージェント（Claude Code、AmpCode、Cursor など）に貼り付けてください：

```
oh-my-opencode をインストールして設定してください。以下の手順に従ってください：
https://raw.githubusercontent.com/code-yeongyu/oh-my-opencode/refs/heads/master/docs/guide/installation.md
```

または [インストールガイド](docs/guide/installation.md) を直接読んでください。ただし、エージェントに任せることを強くお勧めします。人間はミスをしますが、エージェントはしません。

### LLM エージェントの方へ

インストールガイドを取得して、その指示に従ってください：

```bash
curl -s https://raw.githubusercontent.com/code-yeongyu/oh-my-opencode/refs/heads/master/docs/guide/installation.md
```


## アンインストール

oh-my-opencode を削除するには：

1. **OpenCode 設定からプラグインを削除**

   `~/.config/opencode/opencode.json` (または `opencode.jsonc`) を編集し、`plugin` 配列から `"oh-my-opencode"` を削除します：

   ```bash
   # jq を使用する例
   jq '.plugin = [.plugin[] | select(. != "oh-my-opencode")]' \
       ~/.config/opencode/opencode.json > /tmp/oc.json && \
       mv /tmp/oc.json ~/.config/opencode/opencode.json
   ```

2. **設定ファイルの削除 (オプション)**

   ```bash
   # ユーザー設定を削除
   rm -f ~/.config/opencode/oh-my-opencode.json

   # プロジェクト設定を削除 (存在する場合)
   rm -f .opencode/oh-my-opencode.json
   ```

3. **削除の確認**

   ```bash
   opencode --version
   # プラグインがロードされなくなっているはずです
   ```


## 機能

当然あるべきだと思う機能がたくさんあります。一度体験したら、もう以前には戻れません。
詳細は [Features Documentation](docs/features.md) を参照してください。

**概要:**
- **エージェント**: Sisyphus（メインエージェント）、Prometheus（プランナー）、Oracle（アーキテクチャ/デバッグ）、Librarian（ドキュメント/コード検索）、Explore（高速コードベース grep）、Multimodal Looker
- **バックグラウンドエージェント**: 本物の開発チームのように複数エージェントを並列実行
- **LSP & AST ツール**: リファクタリング、リネーム、診断、AST 認識コード検索
- **コンテキスト注入**: AGENTS.md、README.md、条件付きルールの自動注入
- **Claude Code 互換性**: 完全なフックシステム、コマンド、スキル、エージェント、MCP
- **内蔵 MCP**: websearch (Exa)、context7 (ドキュメント)、grep_app (GitHub 検索)
- **セッションツール**: セッション履歴の一覧、読み取り、検索、分析
- **生産性機能**: Ralph Loop、Todo Enforcer、Comment Checker、Think Mode など

## 設定

こだわりが強く反映された設定ですが、好みに合わせて調整可能です。
詳細は [Configuration Documentation](docs/configurations.md) を参照してください。

**概要：**
- **設定ファイルの場所**: `.opencode/oh-my-opencode.json` (プロジェクト) または `~/.config/opencode/oh-my-opencode.json` (ユーザー)
- **JSONC のサポート**: コメントと末尾のカンマをサポート
- **エージェント**: 任意のエージェントのモデル、温度、プロンプト、権限をオーバーライド
- **内蔵スキル**: `playwright` (ブラウザ自動化), `git-master` (アトミックコミット)
- **Sisyphus エージェント**: Prometheus (Planner) と Metis (Plan Consultant) を備えたメインオーケストレーター
- **バックグラウンドタスク**: プロバイダー/モデルごとの同時実行制限を設定
- **カテゴリ**: ドメイン固有のタスク委任 (`visual`, `business-logic`, カスタム)
- **フック**: 25以上の内蔵フック、すべて `disabled_hooks` で設定可能
- **MCP**: 内蔵 websearch (Exa), context7 (ドキュメント), grep_app (GitHub 検索)
- **LSP**: リファクタリングツール付きの完全な LSP サポート
- **実験的機能**: 積極的な切り詰め、自動再開など


## 作者のノート

**このプロジェクトの哲学についてもっと知りたいですか？** [Ultrawork Manifesto](docs/ultrawork-manifesto.md)をお読みください。

Oh My OpenCode をインストールしてください。

私はこれまで、$24,000 分のトークンを純粋に個人の開発目的で使用してきました。
あらゆるツールを試し、徹底的に設定しました。私の選択は OpenCode でした。

私がぶつかったすべての問題への答えを、このプラグインに詰め込みました。ただインストールして使ってください。
OpenCode が Debian / ArchLinux だとしたら、Oh My OpenCode は Ubuntu / [Omarchy](https://omarchy.org/) です。


[AmpCode](https://ampcode.com) や [Claude Code](https://code.claude.com/docs/overview) から強い影響とインスピレーションを受け、彼らの機能をそのまま、あるいはより良く、ここに移植しました。そして今も作り続けています。
**Open**Code ですからね。

他のエージェントハーネスが約束しておきながら提供できていない、マルチモデルオーケストレーション、安定性、豊富な機能を、ただ OpenCode で享受してください。
私がテストし、アップデートし続けます。私はこのプロジェクトの最も熱心なユーザーですから。
- 純粋な論理力が一番鋭いモデルはどれか？
- デバッグの神は誰か？
- 文章を書くのが一番うまいのは誰か？
- フロントエンドを支配するのは誰か？
- バックエンドを掌握するのは誰か？
- 日常使いで最速のモデルは何か？
- 他のハーネスが出している新機能は何か？

このプラグインは、それらの経験の結晶です。皆さんはただ最高のものを受け取ってください。もしもっと良いアイデアがあれば、PR はいつでも歓迎です。

**Agent Harness 選びで悩むのはやめましょう。**
**私がリサーチし、最高のものを取り入れ、ここにアップデートを出し続けます。**

もしこの文章が傲慢に聞こえ、もっと良い答えをお持ちなら、ぜひ貢献してください。歓迎します。

こここで言及されたどのプロジェクトやモデルとも、私には一切関係がありません。これは純粋に個人的な実験と好みによって作られました。

このプロジェクトの 99% は OpenCode を使って書かれました。機能を中心にテストしましたが、私は TypeScript を正しく書く方法をあまり知りません。**しかし、このドキュメントは私が直接レビューし、大部分を書き直したので、安心して読んでください。**

## 注意

- 生産性が上がりすぎる可能性があります。隣の同僚にバレないように気をつけてください。
  - とはいえ、私が言いふらしますけどね。誰が勝つか賭けましょう。
- [1.0.132](https://github.com/sst/opencode/releases/tag/v1.0.132) またはそれ以下のバージョンを使用している場合、OpenCode のバグにより設定が正しく行われない可能性があります。
  - [修正 PR](https://github.com/sst/opencode/pull/5040) は 1.0.132 以降にマージされたため、新しいバージョンを使用してください。
    - 余談：この PR も、OhMyOpenCode の Librarian、Explore、Oracle セットアップを活用して偶然発見され、修正されました。

## こちらの企業の専門家にご愛用いただいています

- [Indent](https://indentcorp.com)
  - Making Spray - influencer marketing solution, vovushop - crossborder commerce platform, vreview - ai commerce review marketing solution
- [Google](https://google.com)
- [Microsoft](https://microsoft.com)

## スポンサー
- **Numman Ali** [GitHub](https://github.com/numman-ali) [X](https://x.com/nummanali)
  - 最初のスポンサー
- **Aaron Iker** [GitHub](https://github.com/aaroniker) [X](https://x.com/aaroniker)
- **Suyeol Jeon (devxoul)** [GitHub](https://github.com/devxoul)
  - 私のキャリアをスタートさせてくださった方であり、優れたエージェンティックワークフローをどのように構築できるかについて多大なインスピレーションを与えてくださった方です。優れたチームを作るために優れたシステムをどう設計すべきか多くのことを学び、その学びがこのharnessを作る上で大きな助けとなりました。
- **Hyerin Won (devwon)** [GitHub](https://github.com/devwon)

*素晴らしいヒーロー画像を作成してくれた [@junhoyeo](https://github.com/junhoyeo) に感謝します*
