# Copyright 2018- The Pixie Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0

if ! platform_family?('mac_os_x')
  return
end

# Use the current user but the wheel group when creating
# resources on macOS. This avoids the need to run as sudo.
default['owner'] = node['current_user']
default['group'] = 'wheel'

default['bazelisk']['download_path'] =
  "https://github.com/bazelbuild/bazelisk/releases/download/v1.27.0/bazelisk-darwin-amd64"
default['bazelisk']['sha256'] =
  '8fcd7ba828f673ba4b1529425e01e15ac42599ef566c17f320d8cbfe7b96a167'

default['codecov']['download_path'] =
  'https://uploader.codecov.io/v0.2.3/macos/codecov'
default['codecov']['sha256'] =
  '8d3709d957c7115610e764621569728be102d213fee15bc1d1aa9d465eb2c258'

default['golang']['download_path'] =
  'https://go.dev/dl/go1.24.6.darwin-amd64.tar.gz'
default['golang']['sha256'] =
  '4a8d7a32052f223e71faab424a69430455b27b3fff5f4e651f9d97c3e51a8746'

default['golangci-lint']['download_path'] =
  'https://github.com/golangci/golangci-lint/releases/download/v2.3.1/golangci-lint-2.3.1-darwin-amd64.tar.gz'
default['golangci-lint']['sha256'] =
  '2f4412ffa77cb58ab3a7d065e1fff01ab714bb2b6fa06ad16ed793b6fc8d534d'

default['nodejs']['download_path'] =
  'https://nodejs.org/dist/v18.16.0/node-v18.16.0-darwin-x64.tar.gz'
default['nodejs']['sha256'] =
  'cd520da6e2e89fab881c66a3e9aff02cb0d61d68104b1d6a571dd71bef920870'

default['prototool']['download_path'] =
  'https://github.com/uber/prototool/releases/download/v1.10.0/prototool-Darwin-x86_64'
default['prototool']['sha256'] =
  '5ca2a19f1cb04bc5059bb07e14d565231246e623f7523fafe9389b463addf645'

default['shellcheck']['download_path'] =
  'https://github.com/koalaman/shellcheck/releases/download/v0.9.0/shellcheck-v0.9.0.darwin.x86_64.tar.xz'
default['shellcheck']['sha256'] =
  '7d3730694707605d6e60cec4efcb79a0632d61babc035aa16cda1b897536acf5'
