# Coding style

* Code is automatically formatted using linters and checked during CI builds. Static
  checkers also validate other coding style requirements for our most commonly used
  languages (C++, Go, Typescript, Python, Shell).

* We expect all production code to be written in either C++ or Go, with the UI written
  in Typescript.

## C++ Style

C++ code uses [Google C++ style guidelines](https://google.github.io/styleguide/cppguide.html), with
some deviations. Refer to [C++ Style](cc_style.md).

## Go Style

Go style is automatically enforced by linters. Refer to [Go Style](go_style.md).

## Typescript style

Typescript code uses [Google Typescript style guidelines](https://google.github.io/styleguide/tsguide.html),
with some deviations. Refer to [Typescript Style](typescript_style.md).

## Naming guide

Pixie uses inclusive naming in our source code and all our assets. Refer to
[Inclusive Naming Guide](inclusive_naming_guide.md).
