/* tslint:disable */
/* eslint-disable */
import { GraphQLResolveInfo } from 'graphql';
/**
 * This file is auto-generated by graphql-schema-typescript
 * Please note that any changes in this file may be overwritten
 */
 

/*******************************
 *                             *
 *          TYPE DEFS          *
 *                             *
 *******************************/
export interface GQLQuery {
  noop: boolean;
  verifyInviteToken: boolean;
  user: GQLUserInfo;
  org: GQLOrgInfo;
  userSettings: GQLUserSettings;
  userAttributes: GQLUserAttributes;
  orgUsers: Array<GQLUserInfo>;
  cluster: GQLClusterInfo;
  clusterByName: GQLClusterInfo;
  clusters: Array<GQLClusterInfo>;
  autocomplete: GQLAutocompleteResult;
  autocompleteField: GQLAutocompleteFieldResult;
  liveViews: Array<GQLLiveViewMetadata>;
  liveViewContents: GQLLiveViewContents;
  scripts: Array<GQLScriptMetadata>;
  scriptContents: GQLScriptContents;
  deploymentKeys: Array<GQLDeploymentKeyMetadata>;
  deploymentKey: GQLDeploymentKey;
  apiKeys: Array<GQLAPIKeyMetadata>;
  apiKey: GQLAPIKey;
  plugins: Array<GQLPlugin>;
  retentionPluginInfo: GQLPluginInfo;
  orgRetentionPluginConfig: Array<GQLPluginConfig>;
  retentionPluginConfig: GQLRetentionPluginConfig;
  retentionScripts: Array<GQLRetentionScript>;
  retentionScript: GQLDetailedRetentionScript;
}

export interface GQLMutation {
  noop: boolean;
  
  /**
   * 
   * @deprecated Clusters are now created via px deploy
   */
  CreateCluster?: GQLClusterInfo;
  CreateDeploymentKey: GQLDeploymentKey;
  DeleteDeploymentKey: boolean;
  CreateAPIKey: GQLAPIKey;
  DeleteAPIKey: boolean;
  UpdateUserSettings: GQLUserSettings;
  SetUserAttributes: GQLUserAttributes;
  DeleteUser: boolean;
  InviteUser: GQLUserInvite;
  UpdateUserPermissions: GQLUserInfo;
  CreateOrg: string;
  UpdateOrgSettings: GQLOrgInfo;
  CreateInviteToken: string;
  RevokeAllInviteTokens: boolean;
  RemoveUserFromOrg: boolean;
  UpdateRetentionPluginConfig: boolean;
  UpdateRetentionScript: boolean;
  CreateRetentionScript: string;
  DeleteRetentionScript: boolean;
}

export interface GQLUserInfo {
  id: string;
  name: string;
  email: string;
  picture: string;
  orgName: string;
  orgID: string;
  isApproved: boolean;
}

export interface GQLIDEPath {
  IDEName: string;
  path: string;
}

export interface GQLOrgInfo {
  id: string;
  name: string;
  domainName: string;
  enableApprovals: boolean;
  idePaths: Array<GQLIDEPath>;
}

export interface GQLUserSettings {
  analyticsOptout: boolean;
  id: string;
}

export interface GQLUserAttributes {
  tourSeen: boolean;
  id: string;
}

export interface GQLEditableUserAttributes {
  tourSeen?: boolean;
}

export interface GQLEditableUserSettings {
  analyticsOptout?: boolean;
}

export interface GQLAPIKeyMetadata {
  id: string;
  createdAtMs: number;
  desc: string;
}

export interface GQLAPIKey {
  id: string;
  key: string;
  createdAtMs: number;
  desc: string;
}

export interface GQLDeploymentKeyMetadata {
  id: string;
  createdAtMs: number;
  desc: string;
}

export interface GQLDeploymentKey {
  id: string;
  key: string;
  createdAtMs: number;
  desc: string;
}

export enum GQLAutocompleteEntityState {
  AES_UNKNOWN = 'AES_UNKNOWN',
  AES_PENDING = 'AES_PENDING',
  AES_RUNNING = 'AES_RUNNING',
  AES_FAILED = 'AES_FAILED',
  AES_TERMINATED = 'AES_TERMINATED'
}

export enum GQLAutocompleteActionType {
  AAT_UNKNOWN = 'AAT_UNKNOWN',
  AAT_EDIT = 'AAT_EDIT',
  AAT_SELECT = 'AAT_SELECT'
}

export enum GQLAutocompleteEntityKind {
  AEK_UNKNOWN = 'AEK_UNKNOWN',
  AEK_POD = 'AEK_POD',
  AEK_SVC = 'AEK_SVC',
  AEK_SCRIPT = 'AEK_SCRIPT',
  AEK_NAMESPACE = 'AEK_NAMESPACE',
  AEK_NODE = 'AEK_NODE'
}

export interface GQLAutocompleteSuggestion {
  kind?: GQLAutocompleteEntityKind;
  name?: string;
  description?: string;
  matchedIndexes?: Array<number | null>;
  state?: GQLAutocompleteEntityState;
}

export interface GQLTabSuggestion {
  tabIndex?: number;
  executableAfterSelect?: boolean;
  suggestions?: Array<GQLAutocompleteSuggestion | null>;
}

export interface GQLAutocompleteResult {
  formattedInput?: string;
  isExecutable?: boolean;
  tabSuggestions?: Array<GQLTabSuggestion | null>;
}

export interface GQLAutocompleteFieldResult {
  suggestions: Array<GQLAutocompleteSuggestion | null>;
  hasAdditionalMatches: boolean;
}

export interface GQLContainerStatus {
  name: string;
  createdAtMs: number;
  state: string;
  message: string;
  reason: string;
  restartCount: number;
}

export interface GQLK8sEvent {
  message: string;
  firstTimeMs: number;
  lastTimeMs: number;
}

export interface GQLPodStatus {
  name: string;
  createdAtMs: number;
  status: string;
  message: string;
  reason: string;
  containers: Array<GQLContainerStatus>;
  events: Array<GQLK8sEvent>;
  restartCount: number;
}

export enum GQLClusterStatus {
  CS_UNKNOWN = 'CS_UNKNOWN',
  CS_HEALTHY = 'CS_HEALTHY',
  CS_UNHEALTHY = 'CS_UNHEALTHY',
  CS_DISCONNECTED = 'CS_DISCONNECTED',
  CS_UPDATING = 'CS_UPDATING',
  CS_CONNECTED = 'CS_CONNECTED',
  CS_UPDATE_FAILED = 'CS_UPDATE_FAILED',
  CS_DEGRADED = 'CS_DEGRADED'
}

export interface GQLClusterInfo {
  id: string;
  status: GQLClusterStatus;
  lastHeartbeatMs: number;
  vizierVersion: string;
  operatorVersion: string;
  clusterVersion: string;
  clusterName: string;
  prettyClusterName: string;
  clusterUID: string;
  controlPlanePodStatuses: Array<GQLPodStatus>;
  unhealthyDataPlanePodStatuses: Array<GQLPodStatus>;
  numNodes: number;
  numInstrumentedNodes: number;
  statusMessage: string;
  previousStatus?: GQLClusterStatus;
  previousStatusTimeMs?: number;
}

export interface GQLUserInvite {
  email: string;
  inviteLink: string;
}

export interface GQLLiveViewMetadata {
  id: string;
  name: string;
  desc: string;
}

export interface GQLLiveViewContents {
  metadata: GQLLiveViewMetadata;
  pxlContents: string;
  visJSON: string;
}

export interface GQLScriptMetadata {
  id: string;
  name: string;
  desc: string;
  hasLiveView: boolean;
}

export interface GQLScriptContents {
  metadata: GQLScriptMetadata;
  contents: string;
}

export interface GQLEditableUserPermissions {
  isApproved?: boolean;
}

export interface GQLEditableOrgSettings {
  enableApprovals?: boolean;
}

export interface GQLPlugin {
  name: string;
  id: string;
  description: string;
  logo?: string;
  latestVersion: string;
  supportsRetention: boolean;
  retentionEnabled: boolean;
  enabledVersion?: string;
}

export enum GQLPluginKind {
  PK_UNKNOWN = 'PK_UNKNOWN',
  PK_RETENTION = 'PK_RETENTION'
}

export interface GQLPluginConfig {
  name: string;
  value: string;
}

export interface GQLPluginInfo {
  configs: Array<GQLPluginConfigSchema>;
  allowCustomExportURL: boolean;
  allowInsecureTLS: boolean;
  defaultExportURL: string;
}

export interface GQLPluginConfigSchema {
  name: string;
  description: string;
}

export interface GQLEditablePluginConfig {
  name: string;
  value: string;
}

export interface GQLEditablePluginConfigs {
  configs: Array<GQLEditablePluginConfig>;
  customExportURL?: string;
  insecureTLS?: boolean;
}

export interface GQLRetentionPluginConfig {
  configs: Array<GQLPluginConfig>;
  customExportURL?: string;
  insecureTLS?: boolean;
}

export interface GQLRetentionScript {
  id: string;
  name: string;
  description: string;
  frequencyS: number;
  enabled: boolean;
  clusters: Array<string>;
  pluginID: string;
  isPreset: boolean;
}

export interface GQLDetailedRetentionScript {
  id: string;
  name: string;
  description: string;
  frequencyS: number;
  enabled: boolean;
  clusters: Array<string>;
  contents: string;
  pluginID: string;
  customExportURL?: string;
  isPreset: boolean;
}

export interface GQLEditableRetentionScript {
  name?: string;
  description?: string;
  frequencyS?: number;
  enabled?: boolean;
  clusters?: Array<string>;
  contents?: string;
  pluginID?: string;
  customExportURL?: string;
}

/*********************************
 *                               *
 *         TYPE RESOLVERS        *
 *                               *
 *********************************/
/**
 * This interface define the shape of your resolver
 * Note that this type is designed to be compatible with graphql-tools resolvers
 * However, you can still use other generated interfaces to make your resolver type-safed
 */
export interface GQLResolver {
  Query?: GQLQueryTypeResolver;
  Mutation?: GQLMutationTypeResolver;
  UserInfo?: GQLUserInfoTypeResolver;
  IDEPath?: GQLIDEPathTypeResolver;
  OrgInfo?: GQLOrgInfoTypeResolver;
  UserSettings?: GQLUserSettingsTypeResolver;
  UserAttributes?: GQLUserAttributesTypeResolver;
  APIKeyMetadata?: GQLAPIKeyMetadataTypeResolver;
  APIKey?: GQLAPIKeyTypeResolver;
  DeploymentKeyMetadata?: GQLDeploymentKeyMetadataTypeResolver;
  DeploymentKey?: GQLDeploymentKeyTypeResolver;
  AutocompleteSuggestion?: GQLAutocompleteSuggestionTypeResolver;
  TabSuggestion?: GQLTabSuggestionTypeResolver;
  AutocompleteResult?: GQLAutocompleteResultTypeResolver;
  AutocompleteFieldResult?: GQLAutocompleteFieldResultTypeResolver;
  ContainerStatus?: GQLContainerStatusTypeResolver;
  K8sEvent?: GQLK8sEventTypeResolver;
  PodStatus?: GQLPodStatusTypeResolver;
  ClusterInfo?: GQLClusterInfoTypeResolver;
  UserInvite?: GQLUserInviteTypeResolver;
  LiveViewMetadata?: GQLLiveViewMetadataTypeResolver;
  LiveViewContents?: GQLLiveViewContentsTypeResolver;
  ScriptMetadata?: GQLScriptMetadataTypeResolver;
  ScriptContents?: GQLScriptContentsTypeResolver;
  Plugin?: GQLPluginTypeResolver;
  PluginConfig?: GQLPluginConfigTypeResolver;
  PluginInfo?: GQLPluginInfoTypeResolver;
  PluginConfigSchema?: GQLPluginConfigSchemaTypeResolver;
  RetentionPluginConfig?: GQLRetentionPluginConfigTypeResolver;
  RetentionScript?: GQLRetentionScriptTypeResolver;
  DetailedRetentionScript?: GQLDetailedRetentionScriptTypeResolver;
}
export interface GQLQueryTypeResolver<TParent = any> {
  noop?: QueryToNoopResolver<TParent>;
  verifyInviteToken?: QueryToVerifyInviteTokenResolver<TParent>;
  user?: QueryToUserResolver<TParent>;
  org?: QueryToOrgResolver<TParent>;
  userSettings?: QueryToUserSettingsResolver<TParent>;
  userAttributes?: QueryToUserAttributesResolver<TParent>;
  orgUsers?: QueryToOrgUsersResolver<TParent>;
  cluster?: QueryToClusterResolver<TParent>;
  clusterByName?: QueryToClusterByNameResolver<TParent>;
  clusters?: QueryToClustersResolver<TParent>;
  autocomplete?: QueryToAutocompleteResolver<TParent>;
  autocompleteField?: QueryToAutocompleteFieldResolver<TParent>;
  liveViews?: QueryToLiveViewsResolver<TParent>;
  liveViewContents?: QueryToLiveViewContentsResolver<TParent>;
  scripts?: QueryToScriptsResolver<TParent>;
  scriptContents?: QueryToScriptContentsResolver<TParent>;
  deploymentKeys?: QueryToDeploymentKeysResolver<TParent>;
  deploymentKey?: QueryToDeploymentKeyResolver<TParent>;
  apiKeys?: QueryToApiKeysResolver<TParent>;
  apiKey?: QueryToApiKeyResolver<TParent>;
  plugins?: QueryToPluginsResolver<TParent>;
  retentionPluginInfo?: QueryToRetentionPluginInfoResolver<TParent>;
  orgRetentionPluginConfig?: QueryToOrgRetentionPluginConfigResolver<TParent>;
  retentionPluginConfig?: QueryToRetentionPluginConfigResolver<TParent>;
  retentionScripts?: QueryToRetentionScriptsResolver<TParent>;
  retentionScript?: QueryToRetentionScriptResolver<TParent>;
}

export interface QueryToNoopResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToVerifyInviteTokenArgs {
  inviteToken: string;
}
export interface QueryToVerifyInviteTokenResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToVerifyInviteTokenArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToUserResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToOrgResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToUserSettingsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToUserAttributesResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToOrgUsersResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToClusterArgs {
  id: string;
}
export interface QueryToClusterResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToClusterArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToClusterByNameArgs {
  name: string;
}
export interface QueryToClusterByNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToClusterByNameArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToClustersResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToAutocompleteArgs {
  input?: string;
  cursorPos?: number;
  action?: GQLAutocompleteActionType;
  clusterUID?: string;
}
export interface QueryToAutocompleteResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToAutocompleteArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToAutocompleteFieldArgs {
  input?: string;
  fieldType?: GQLAutocompleteEntityKind;
  requiredArgTypes?: Array<GQLAutocompleteEntityKind | null>;
  clusterUID?: string;
}
export interface QueryToAutocompleteFieldResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToAutocompleteFieldArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToLiveViewsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToLiveViewContentsArgs {
  id: string;
}
export interface QueryToLiveViewContentsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToLiveViewContentsArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToScriptsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToScriptContentsArgs {
  id: string;
}
export interface QueryToScriptContentsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToScriptContentsArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToDeploymentKeysResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToDeploymentKeyArgs {
  id: string;
}
export interface QueryToDeploymentKeyResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToDeploymentKeyArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToApiKeysResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToApiKeyArgs {
  id: string;
}
export interface QueryToApiKeyResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToApiKeyArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToPluginsArgs {
  kind?: GQLPluginKind;
}
export interface QueryToPluginsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToPluginsArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToRetentionPluginInfoArgs {
  id: string;
  pluginVersion: string;
}
export interface QueryToRetentionPluginInfoResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToRetentionPluginInfoArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToOrgRetentionPluginConfigArgs {
  id: string;
}
export interface QueryToOrgRetentionPluginConfigResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToOrgRetentionPluginConfigArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToRetentionPluginConfigArgs {
  id: string;
}
export interface QueryToRetentionPluginConfigResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToRetentionPluginConfigArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToRetentionScriptsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface QueryToRetentionScriptArgs {
  id: string;
}
export interface QueryToRetentionScriptResolver<TParent = any, TResult = any> {
  (parent: TParent, args: QueryToRetentionScriptArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLMutationTypeResolver<TParent = any> {
  noop?: MutationToNoopResolver<TParent>;
  CreateCluster?: MutationToCreateClusterResolver<TParent>;
  CreateDeploymentKey?: MutationToCreateDeploymentKeyResolver<TParent>;
  DeleteDeploymentKey?: MutationToDeleteDeploymentKeyResolver<TParent>;
  CreateAPIKey?: MutationToCreateAPIKeyResolver<TParent>;
  DeleteAPIKey?: MutationToDeleteAPIKeyResolver<TParent>;
  UpdateUserSettings?: MutationToUpdateUserSettingsResolver<TParent>;
  SetUserAttributes?: MutationToSetUserAttributesResolver<TParent>;
  DeleteUser?: MutationToDeleteUserResolver<TParent>;
  InviteUser?: MutationToInviteUserResolver<TParent>;
  UpdateUserPermissions?: MutationToUpdateUserPermissionsResolver<TParent>;
  CreateOrg?: MutationToCreateOrgResolver<TParent>;
  UpdateOrgSettings?: MutationToUpdateOrgSettingsResolver<TParent>;
  CreateInviteToken?: MutationToCreateInviteTokenResolver<TParent>;
  RevokeAllInviteTokens?: MutationToRevokeAllInviteTokensResolver<TParent>;
  RemoveUserFromOrg?: MutationToRemoveUserFromOrgResolver<TParent>;
  UpdateRetentionPluginConfig?: MutationToUpdateRetentionPluginConfigResolver<TParent>;
  UpdateRetentionScript?: MutationToUpdateRetentionScriptResolver<TParent>;
  CreateRetentionScript?: MutationToCreateRetentionScriptResolver<TParent>;
  DeleteRetentionScript?: MutationToDeleteRetentionScriptResolver<TParent>;
}

export interface MutationToNoopResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToCreateClusterResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToCreateDeploymentKeyResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToDeleteDeploymentKeyArgs {
  id: string;
}
export interface MutationToDeleteDeploymentKeyResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToDeleteDeploymentKeyArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToCreateAPIKeyResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToDeleteAPIKeyArgs {
  id: string;
}
export interface MutationToDeleteAPIKeyResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToDeleteAPIKeyArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToUpdateUserSettingsArgs {
  settings: GQLEditableUserSettings;
}
export interface MutationToUpdateUserSettingsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToUpdateUserSettingsArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToSetUserAttributesArgs {
  attributes: GQLEditableUserAttributes;
}
export interface MutationToSetUserAttributesResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToSetUserAttributesArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToDeleteUserResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToInviteUserArgs {
  email: string;
  firstName: string;
  lastName: string;
}
export interface MutationToInviteUserResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToInviteUserArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToUpdateUserPermissionsArgs {
  userID: string;
  userPermissions: GQLEditableUserPermissions;
}
export interface MutationToUpdateUserPermissionsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToUpdateUserPermissionsArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToCreateOrgArgs {
  orgName: string;
}
export interface MutationToCreateOrgResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToCreateOrgArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToUpdateOrgSettingsArgs {
  orgID: string;
  orgSettings: GQLEditableOrgSettings;
}
export interface MutationToUpdateOrgSettingsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToUpdateOrgSettingsArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToCreateInviteTokenArgs {
  orgID: string;
}
export interface MutationToCreateInviteTokenResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToCreateInviteTokenArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToRevokeAllInviteTokensArgs {
  orgID: string;
}
export interface MutationToRevokeAllInviteTokensResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToRevokeAllInviteTokensArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToRemoveUserFromOrgArgs {
  userID: string;
}
export interface MutationToRemoveUserFromOrgResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToRemoveUserFromOrgArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToUpdateRetentionPluginConfigArgs {
  id: string;
  enabled?: boolean;
  enabledVersion?: string;
  configs: GQLEditablePluginConfigs;
}
export interface MutationToUpdateRetentionPluginConfigResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToUpdateRetentionPluginConfigArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToUpdateRetentionScriptArgs {
  id: string;
  script?: GQLEditableRetentionScript;
}
export interface MutationToUpdateRetentionScriptResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToUpdateRetentionScriptArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToCreateRetentionScriptArgs {
  script?: GQLEditableRetentionScript;
}
export interface MutationToCreateRetentionScriptResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToCreateRetentionScriptArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface MutationToDeleteRetentionScriptArgs {
  id: string;
}
export interface MutationToDeleteRetentionScriptResolver<TParent = any, TResult = any> {
  (parent: TParent, args: MutationToDeleteRetentionScriptArgs, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLUserInfoTypeResolver<TParent = any> {
  id?: UserInfoToIdResolver<TParent>;
  name?: UserInfoToNameResolver<TParent>;
  email?: UserInfoToEmailResolver<TParent>;
  picture?: UserInfoToPictureResolver<TParent>;
  orgName?: UserInfoToOrgNameResolver<TParent>;
  orgID?: UserInfoToOrgIDResolver<TParent>;
  isApproved?: UserInfoToIsApprovedResolver<TParent>;
}

export interface UserInfoToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserInfoToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserInfoToEmailResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserInfoToPictureResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserInfoToOrgNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserInfoToOrgIDResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserInfoToIsApprovedResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLIDEPathTypeResolver<TParent = any> {
  IDEName?: IDEPathToIDENameResolver<TParent>;
  path?: IDEPathToPathResolver<TParent>;
}

export interface IDEPathToIDENameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface IDEPathToPathResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLOrgInfoTypeResolver<TParent = any> {
  id?: OrgInfoToIdResolver<TParent>;
  name?: OrgInfoToNameResolver<TParent>;
  domainName?: OrgInfoToDomainNameResolver<TParent>;
  enableApprovals?: OrgInfoToEnableApprovalsResolver<TParent>;
  idePaths?: OrgInfoToIdePathsResolver<TParent>;
}

export interface OrgInfoToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface OrgInfoToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface OrgInfoToDomainNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface OrgInfoToEnableApprovalsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface OrgInfoToIdePathsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLUserSettingsTypeResolver<TParent = any> {
  analyticsOptout?: UserSettingsToAnalyticsOptoutResolver<TParent>;
  id?: UserSettingsToIdResolver<TParent>;
}

export interface UserSettingsToAnalyticsOptoutResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserSettingsToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLUserAttributesTypeResolver<TParent = any> {
  tourSeen?: UserAttributesToTourSeenResolver<TParent>;
  id?: UserAttributesToIdResolver<TParent>;
}

export interface UserAttributesToTourSeenResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserAttributesToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLAPIKeyMetadataTypeResolver<TParent = any> {
  id?: APIKeyMetadataToIdResolver<TParent>;
  createdAtMs?: APIKeyMetadataToCreatedAtMsResolver<TParent>;
  desc?: APIKeyMetadataToDescResolver<TParent>;
}

export interface APIKeyMetadataToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface APIKeyMetadataToCreatedAtMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface APIKeyMetadataToDescResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLAPIKeyTypeResolver<TParent = any> {
  id?: APIKeyToIdResolver<TParent>;
  key?: APIKeyToKeyResolver<TParent>;
  createdAtMs?: APIKeyToCreatedAtMsResolver<TParent>;
  desc?: APIKeyToDescResolver<TParent>;
}

export interface APIKeyToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface APIKeyToKeyResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface APIKeyToCreatedAtMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface APIKeyToDescResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLDeploymentKeyMetadataTypeResolver<TParent = any> {
  id?: DeploymentKeyMetadataToIdResolver<TParent>;
  createdAtMs?: DeploymentKeyMetadataToCreatedAtMsResolver<TParent>;
  desc?: DeploymentKeyMetadataToDescResolver<TParent>;
}

export interface DeploymentKeyMetadataToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DeploymentKeyMetadataToCreatedAtMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DeploymentKeyMetadataToDescResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLDeploymentKeyTypeResolver<TParent = any> {
  id?: DeploymentKeyToIdResolver<TParent>;
  key?: DeploymentKeyToKeyResolver<TParent>;
  createdAtMs?: DeploymentKeyToCreatedAtMsResolver<TParent>;
  desc?: DeploymentKeyToDescResolver<TParent>;
}

export interface DeploymentKeyToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DeploymentKeyToKeyResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DeploymentKeyToCreatedAtMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DeploymentKeyToDescResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLAutocompleteSuggestionTypeResolver<TParent = any> {
  kind?: AutocompleteSuggestionToKindResolver<TParent>;
  name?: AutocompleteSuggestionToNameResolver<TParent>;
  description?: AutocompleteSuggestionToDescriptionResolver<TParent>;
  matchedIndexes?: AutocompleteSuggestionToMatchedIndexesResolver<TParent>;
  state?: AutocompleteSuggestionToStateResolver<TParent>;
}

export interface AutocompleteSuggestionToKindResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface AutocompleteSuggestionToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface AutocompleteSuggestionToDescriptionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface AutocompleteSuggestionToMatchedIndexesResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface AutocompleteSuggestionToStateResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLTabSuggestionTypeResolver<TParent = any> {
  tabIndex?: TabSuggestionToTabIndexResolver<TParent>;
  executableAfterSelect?: TabSuggestionToExecutableAfterSelectResolver<TParent>;
  suggestions?: TabSuggestionToSuggestionsResolver<TParent>;
}

export interface TabSuggestionToTabIndexResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface TabSuggestionToExecutableAfterSelectResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface TabSuggestionToSuggestionsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLAutocompleteResultTypeResolver<TParent = any> {
  formattedInput?: AutocompleteResultToFormattedInputResolver<TParent>;
  isExecutable?: AutocompleteResultToIsExecutableResolver<TParent>;
  tabSuggestions?: AutocompleteResultToTabSuggestionsResolver<TParent>;
}

export interface AutocompleteResultToFormattedInputResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface AutocompleteResultToIsExecutableResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface AutocompleteResultToTabSuggestionsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLAutocompleteFieldResultTypeResolver<TParent = any> {
  suggestions?: AutocompleteFieldResultToSuggestionsResolver<TParent>;
  hasAdditionalMatches?: AutocompleteFieldResultToHasAdditionalMatchesResolver<TParent>;
}

export interface AutocompleteFieldResultToSuggestionsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface AutocompleteFieldResultToHasAdditionalMatchesResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLContainerStatusTypeResolver<TParent = any> {
  name?: ContainerStatusToNameResolver<TParent>;
  createdAtMs?: ContainerStatusToCreatedAtMsResolver<TParent>;
  state?: ContainerStatusToStateResolver<TParent>;
  message?: ContainerStatusToMessageResolver<TParent>;
  reason?: ContainerStatusToReasonResolver<TParent>;
  restartCount?: ContainerStatusToRestartCountResolver<TParent>;
}

export interface ContainerStatusToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ContainerStatusToCreatedAtMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ContainerStatusToStateResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ContainerStatusToMessageResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ContainerStatusToReasonResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ContainerStatusToRestartCountResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLK8sEventTypeResolver<TParent = any> {
  message?: K8sEventToMessageResolver<TParent>;
  firstTimeMs?: K8sEventToFirstTimeMsResolver<TParent>;
  lastTimeMs?: K8sEventToLastTimeMsResolver<TParent>;
}

export interface K8sEventToMessageResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface K8sEventToFirstTimeMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface K8sEventToLastTimeMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLPodStatusTypeResolver<TParent = any> {
  name?: PodStatusToNameResolver<TParent>;
  createdAtMs?: PodStatusToCreatedAtMsResolver<TParent>;
  status?: PodStatusToStatusResolver<TParent>;
  message?: PodStatusToMessageResolver<TParent>;
  reason?: PodStatusToReasonResolver<TParent>;
  containers?: PodStatusToContainersResolver<TParent>;
  events?: PodStatusToEventsResolver<TParent>;
  restartCount?: PodStatusToRestartCountResolver<TParent>;
}

export interface PodStatusToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PodStatusToCreatedAtMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PodStatusToStatusResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PodStatusToMessageResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PodStatusToReasonResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PodStatusToContainersResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PodStatusToEventsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PodStatusToRestartCountResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLClusterInfoTypeResolver<TParent = any> {
  id?: ClusterInfoToIdResolver<TParent>;
  status?: ClusterInfoToStatusResolver<TParent>;
  lastHeartbeatMs?: ClusterInfoToLastHeartbeatMsResolver<TParent>;
  vizierVersion?: ClusterInfoToVizierVersionResolver<TParent>;
  operatorVersion?: ClusterInfoToOperatorVersionResolver<TParent>;
  clusterVersion?: ClusterInfoToClusterVersionResolver<TParent>;
  clusterName?: ClusterInfoToClusterNameResolver<TParent>;
  prettyClusterName?: ClusterInfoToPrettyClusterNameResolver<TParent>;
  clusterUID?: ClusterInfoToClusterUIDResolver<TParent>;
  controlPlanePodStatuses?: ClusterInfoToControlPlanePodStatusesResolver<TParent>;
  unhealthyDataPlanePodStatuses?: ClusterInfoToUnhealthyDataPlanePodStatusesResolver<TParent>;
  numNodes?: ClusterInfoToNumNodesResolver<TParent>;
  numInstrumentedNodes?: ClusterInfoToNumInstrumentedNodesResolver<TParent>;
  statusMessage?: ClusterInfoToStatusMessageResolver<TParent>;
  previousStatus?: ClusterInfoToPreviousStatusResolver<TParent>;
  previousStatusTimeMs?: ClusterInfoToPreviousStatusTimeMsResolver<TParent>;
}

export interface ClusterInfoToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToStatusResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToLastHeartbeatMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToVizierVersionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToOperatorVersionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToClusterVersionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToClusterNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToPrettyClusterNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToClusterUIDResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToControlPlanePodStatusesResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToUnhealthyDataPlanePodStatusesResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToNumNodesResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToNumInstrumentedNodesResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToStatusMessageResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToPreviousStatusResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ClusterInfoToPreviousStatusTimeMsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLUserInviteTypeResolver<TParent = any> {
  email?: UserInviteToEmailResolver<TParent>;
  inviteLink?: UserInviteToInviteLinkResolver<TParent>;
}

export interface UserInviteToEmailResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface UserInviteToInviteLinkResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLLiveViewMetadataTypeResolver<TParent = any> {
  id?: LiveViewMetadataToIdResolver<TParent>;
  name?: LiveViewMetadataToNameResolver<TParent>;
  desc?: LiveViewMetadataToDescResolver<TParent>;
}

export interface LiveViewMetadataToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface LiveViewMetadataToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface LiveViewMetadataToDescResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLLiveViewContentsTypeResolver<TParent = any> {
  metadata?: LiveViewContentsToMetadataResolver<TParent>;
  pxlContents?: LiveViewContentsToPxlContentsResolver<TParent>;
  visJSON?: LiveViewContentsToVisJSONResolver<TParent>;
}

export interface LiveViewContentsToMetadataResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface LiveViewContentsToPxlContentsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface LiveViewContentsToVisJSONResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLScriptMetadataTypeResolver<TParent = any> {
  id?: ScriptMetadataToIdResolver<TParent>;
  name?: ScriptMetadataToNameResolver<TParent>;
  desc?: ScriptMetadataToDescResolver<TParent>;
  hasLiveView?: ScriptMetadataToHasLiveViewResolver<TParent>;
}

export interface ScriptMetadataToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ScriptMetadataToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ScriptMetadataToDescResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ScriptMetadataToHasLiveViewResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLScriptContentsTypeResolver<TParent = any> {
  metadata?: ScriptContentsToMetadataResolver<TParent>;
  contents?: ScriptContentsToContentsResolver<TParent>;
}

export interface ScriptContentsToMetadataResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface ScriptContentsToContentsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLPluginTypeResolver<TParent = any> {
  name?: PluginToNameResolver<TParent>;
  id?: PluginToIdResolver<TParent>;
  description?: PluginToDescriptionResolver<TParent>;
  logo?: PluginToLogoResolver<TParent>;
  latestVersion?: PluginToLatestVersionResolver<TParent>;
  supportsRetention?: PluginToSupportsRetentionResolver<TParent>;
  retentionEnabled?: PluginToRetentionEnabledResolver<TParent>;
  enabledVersion?: PluginToEnabledVersionResolver<TParent>;
}

export interface PluginToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginToDescriptionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginToLogoResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginToLatestVersionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginToSupportsRetentionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginToRetentionEnabledResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginToEnabledVersionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLPluginConfigTypeResolver<TParent = any> {
  name?: PluginConfigToNameResolver<TParent>;
  value?: PluginConfigToValueResolver<TParent>;
}

export interface PluginConfigToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginConfigToValueResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLPluginInfoTypeResolver<TParent = any> {
  configs?: PluginInfoToConfigsResolver<TParent>;
  allowCustomExportURL?: PluginInfoToAllowCustomExportURLResolver<TParent>;
  allowInsecureTLS?: PluginInfoToAllowInsecureTLSResolver<TParent>;
  defaultExportURL?: PluginInfoToDefaultExportURLResolver<TParent>;
}

export interface PluginInfoToConfigsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginInfoToAllowCustomExportURLResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginInfoToAllowInsecureTLSResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginInfoToDefaultExportURLResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLPluginConfigSchemaTypeResolver<TParent = any> {
  name?: PluginConfigSchemaToNameResolver<TParent>;
  description?: PluginConfigSchemaToDescriptionResolver<TParent>;
}

export interface PluginConfigSchemaToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface PluginConfigSchemaToDescriptionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLRetentionPluginConfigTypeResolver<TParent = any> {
  configs?: RetentionPluginConfigToConfigsResolver<TParent>;
  customExportURL?: RetentionPluginConfigToCustomExportURLResolver<TParent>;
  insecureTLS?: RetentionPluginConfigToInsecureTLSResolver<TParent>;
}

export interface RetentionPluginConfigToConfigsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionPluginConfigToCustomExportURLResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionPluginConfigToInsecureTLSResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLRetentionScriptTypeResolver<TParent = any> {
  id?: RetentionScriptToIdResolver<TParent>;
  name?: RetentionScriptToNameResolver<TParent>;
  description?: RetentionScriptToDescriptionResolver<TParent>;
  frequencyS?: RetentionScriptToFrequencySResolver<TParent>;
  enabled?: RetentionScriptToEnabledResolver<TParent>;
  clusters?: RetentionScriptToClustersResolver<TParent>;
  pluginID?: RetentionScriptToPluginIDResolver<TParent>;
  isPreset?: RetentionScriptToIsPresetResolver<TParent>;
}

export interface RetentionScriptToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionScriptToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionScriptToDescriptionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionScriptToFrequencySResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionScriptToEnabledResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionScriptToClustersResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionScriptToPluginIDResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface RetentionScriptToIsPresetResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface GQLDetailedRetentionScriptTypeResolver<TParent = any> {
  id?: DetailedRetentionScriptToIdResolver<TParent>;
  name?: DetailedRetentionScriptToNameResolver<TParent>;
  description?: DetailedRetentionScriptToDescriptionResolver<TParent>;
  frequencyS?: DetailedRetentionScriptToFrequencySResolver<TParent>;
  enabled?: DetailedRetentionScriptToEnabledResolver<TParent>;
  clusters?: DetailedRetentionScriptToClustersResolver<TParent>;
  contents?: DetailedRetentionScriptToContentsResolver<TParent>;
  pluginID?: DetailedRetentionScriptToPluginIDResolver<TParent>;
  customExportURL?: DetailedRetentionScriptToCustomExportURLResolver<TParent>;
  isPreset?: DetailedRetentionScriptToIsPresetResolver<TParent>;
}

export interface DetailedRetentionScriptToIdResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToNameResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToDescriptionResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToFrequencySResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToEnabledResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToClustersResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToContentsResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToPluginIDResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToCustomExportURLResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}

export interface DetailedRetentionScriptToIsPresetResolver<TParent = any, TResult = any> {
  (parent: TParent, args: {}, context: any, info: GraphQLResolveInfo): TResult;
}
