/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import * as React from 'react';

import { SvgIcon, SvgIconProps } from '@mui/material';

// eslint-disable-next-line react-memo/require-memo,react/display-name
export const DataDisksIcon: React.FC<SvgIconProps> = (props) => (
  <SvgIcon {...props} viewBox='0 0 15 18'>
    <path d={`
      M7.49919 6.59251C11.6409 6.59251 14.9984 5.11673 14.9984 3.29625C14.9984 1.47578 11.6409 0 7.49919 0C3.3575 0 0
      1.47578 0 3.29625C0 5.11673 3.3575 6.59251 7.49919 6.59251Z
    `} />
    <path d={`
      M7.49935 7.62846C4.25179 7.62846 1.38825 6.78389 0.000161662 5.41089V7.15756C0.000161662 8.97803 3.35766 10.4538
      7.49935 10.4538C11.641 10.4538 14.9985 8.97803 14.9985 7.15756V5.41089C13.6105
      6.78389 10.7469 7.62846 7.49935 7.62846Z
    `} />
    <path d={`
      M7.50041 15.1746C4.25285 15.1746 1.38931 14.3301 0.00122562 12.9571L0.00123276 14.7037C0.00123276 16.5242
      3.35873 18 7.50041 18C11.6421 18 14.9996 16.5242 14.9996 14.7037L14.9996 12.9571C13.6115 14.3301 10.748
      15.1746 7.50041 15.1746Z
    `} />
    <path d={`
      M7.49935 7.62846C4.25179 7.62846 1.38825 6.78389 0.000161662 5.41089V7.15756C0.000161662 8.97803 3.35766 10.4538
      7.49935 10.4538C11.641 10.4538 14.9985 8.97803 14.9985 7.15756V5.41089C13.6105 6.78389 10.7469 7.62846
      7.49935 7.62846Z
    `} />
    <path d={`
      M7.49935 7.62846C4.25179 7.62846 1.38825 6.78389 0.000161662 5.41089V7.15756C0.000161662 8.97803 3.35766
      10.4538 7.49935 10.4538C11.641 10.4538 14.9985 8.97803 14.9985 7.15756V5.41089C13.6105 6.78389 10.7469
      7.62846 7.49935 7.62846Z
    `} />
    <path d={`
      M7.49937 11.353C4.25168 11.353 1.38805 10.5083 2.16292e-05 9.13524L0.00017571 10.8821C0.00017571 12.7025
      3.35768 14.1783 7.49937 14.1783C11.6411 14.1783 14.9986 12.7025 14.9986 10.8821L14.9985 9.13543C13.6104
      10.5084 10.7469 11.353 7.49937 11.353Z
    `} />
  </SvgIcon>
);
