/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import * as React from 'react';

import { ThemeProvider, createTheme } from '@mui/material/styles';
import { render } from '@testing-library/react';

import { FixedSizeDrawer } from './drawer';

describe('<FixedSizeDrawer/>', () => {
  it('renders correctly when closed', async () => {
    const otherContent = <div>Other content. Some text goes here.</div>;

    const { container } = render(
      <ThemeProvider theme={createTheme()}>
        <FixedSizeDrawer
          drawerDirection='left'
          drawerSize='50px'
          open={false}
          // eslint-disable-next-line react-memo/require-usememo
          otherContent={otherContent}
          overlay={false}
        >
          <div>Drawer contents</div>
        </FixedSizeDrawer>
      </ThemeProvider>,
    );
    expect(container).toMatchSnapshot();
  });
});
