/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import React from 'react';

// eslint-disable-next-line react-memo/require-memo,react/display-name
export const PixienautOctopusSvg: React.FC<React.SVGProps<SVGSVGElement>> = (props) => (
  /* eslint-disable max-len,react/no-unknown-property */
  <svg {...props} width='3681' height='1684' viewBox='0 0 3681 1684' fill='none' xmlns='http://www.w3.org/2000/svg'>
    <path
      d='M255.23 1413.48C255.23 1413.48 375.911 1507.73 471.019 1497.44C566.699 1487.09 623.566 1429.79 603.898 1377.1C584.23 1324.4 492.114 1378.5 459.752 1354.9C427.39 1331.27 413.834 1311.11 413.834 1311.11L255.23 1413.48Z'
      fill='url(#paint0_linear)'
    />
    <mask id='mask0' mask-type='alpha' maskUnits='userSpaceOnUse' x='255' y='1311' width='353' height='188'>
      <path
        d='M255.23 1413.48C255.23 1413.48 375.911 1507.73 471.019 1497.44C566.698 1487.09 623.566 1429.79 603.898 1377.1C584.23 1324.4 492.114 1378.5 459.752 1354.9C427.39 1331.27 413.834 1311.11 413.834 1311.11L255.23 1413.48Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask0)'>
      <circle cx='626.293' cy='1389.72' r='54.889' fill='url(#paint1_linear)' />
      <path
        d='M470.072 1326.6C470.072 1326.6 443.975 1390.55 393.501 1428.25C343.026 1465.95 300.31 1472.59 300.31 1472.59L229.993 1430.31L412.668 1308.5L470.072 1326.6Z'
        fill='url(#paint2_linear)'
      />
    </g>
    <path
      d='M482.145 1247.69C482.145 1247.69 472.018 1331.47 357.176 1392.55C242.337 1453.63 239.014 1447.82 215.167 1488.74C191.32 1529.64 198.129 1581.1 141.94 1579.93C93.9918 1578.93 27.6639 1468.59 70.5897 1366.51C106.054 1282.2 222.098 1243.62 222.098 1243.62L482.145 1247.69Z'
      fill='url(#paint3_linear)'
    />
    <mask id='mask1' mask-type='alpha' maskUnits='userSpaceOnUse' x='56' y='1243' width='427' height='337'>
      <path
        d='M482.145 1247.69C482.145 1247.69 472.018 1331.47 357.176 1392.55C242.337 1453.63 239.014 1447.82 215.167 1488.74C191.32 1529.64 198.129 1581.1 141.94 1579.93C93.9918 1578.93 27.6639 1468.59 70.5897 1366.51C106.054 1282.2 222.098 1243.62 222.098 1243.62L482.145 1247.69Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask1)'>
      <circle cx='70.1337' cy='1337.33' r='50.5873' fill='url(#paint4_linear)' />
      <path
        d='M344.282 1239.12C344.282 1239.12 180.509 1332.26 144.875 1419.61C109.24 1506.97 144.248 1582.42 144.248 1582.42L295.789 1654.61L541.814 1210.17L344.282 1239.12Z'
        fill='url(#paint5_linear)'
      />
      <circle cx='137.907' cy='1584.31' r='39.7382' fill='url(#paint6_linear)' />
    </g>
    <path
      d='M472.8 1085.82C472.8 1085.82 539.785 1044.04 615.072 1070.34C690.361 1096.64 708.734 1175.28 678.956 1200.4C649.177 1225.52 609.421 1184.3 563.899 1182.11C518.377 1179.92 483.354 1206.11 483.354 1206.11L472.8 1085.82Z'
      fill='url(#paint7_linear)'
    />
    <mask id='mask2' mask-type='alpha' maskUnits='userSpaceOnUse' x='472' y='1061' width='221' height='148'>
      <path
        d='M472.8 1085.82C472.8 1085.82 539.785 1044.04 615.072 1070.34C690.361 1096.64 708.734 1175.28 678.956 1200.4C649.177 1225.52 609.421 1184.3 563.899 1182.11C518.377 1179.92 483.354 1206.11 483.354 1206.11L472.8 1085.82Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask2)'>
      <path
        d='M456.922 1143.36C456.922 1143.36 542.2 1114.39 607.616 1141.81C673.032 1169.23 696.792 1209.88 696.792 1209.88L649.92 1265L463.719 1232.97L456.922 1143.36Z'
        fill='url(#paint8_linear)'
      />
      <ellipse cx='707.385' cy='1200.89' rx='59.4836' ry='59.4836' fill='url(#paint9_linear)' />
    </g>
    <path
      d='M173.296 1047.7C164.912 1126.08 165.622 1200.05 183.583 1268.57C255.655 1318.13 369.311 1311.74 471.533 1279.41C530.407 1205.41 521.608 1126.59 483.029 1021.06C388.552 1086.57 287.374 1086.99 173.296 1047.7Z'
      fill='url(#paint10_linear)'
    />
    <circle cx='352.869' cy='1199.17' r='77.0108' fill='url(#paint11_linear)' />
    <mask id='mask3' mask-type='alpha' maskUnits='userSpaceOnUse' x='275' y='1122' width='155' height='155'>
      <circle cx='352.869' cy='1199.17' r='77.0108' fill='white' />
    </mask>
    <g mask='url(#mask3)'>
      <path
        opacity='0.969457'
        d='M325.679 1112.4L332.914 1116.37C323.945 1132.72 319.515 1149.73 319.016 1169.06L318.972 1171.83L310.721 1171.78C310.855 1150.91 315.204 1132.44 324.396 1114.8L325.679 1112.4Z'
        fill='url(#paint12_linear)'
      />
      <path
        opacity='0.969457'
        d='M362.68 1119.74L370.617 1121.99C365.892 1138.63 358.636 1153.9 347.923 1170.74L345.874 1173.92L338.968 1169.41C349.717 1152.96 357.011 1138.35 361.809 1122.69L362.68 1119.74Z'
        fill='url(#paint13_linear)'
      />
      <path
        opacity='0.969457'
        d='M397.111 1135.38L404.437 1139.18C391.57 1164.02 379.475 1180.06 362.21 1192.34L360.34 1193.65L355.693 1186.83C372.049 1175.68 383.541 1161.06 395.795 1137.9L397.111 1135.38Z'
        fill='url(#paint14_linear)'
      />
      <path
        opacity='0.969457'
        d='M425.458 1180.13L430.986 1186.26C414.795 1200.87 391.851 1212.1 371.002 1215.35L368.777 1215.67L367.718 1207.48C386.731 1205.02 408.303 1194.93 423.765 1181.62L425.458 1180.13Z'
        fill='url(#paint15_linear)'
      />
      <path
        opacity='0.969457'
        d='M426.45 1233.71L430.439 1240.93C415.561 1249.15 395.392 1252.3 370.426 1252.28L367.523 1252.27L367.608 1244.02C391.673 1244.26 411.089 1241.58 424.883 1234.54L426.45 1233.71Z'
        fill='url(#paint16_linear)'
      />
    </g>
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M172.469 1210.49C174.97 1230.25 178.617 1249.61 183.583 1268.56C219.9 1293.53 266.775 1304.3 317.426 1304.7C378.641 1282.38 415.185 1242.12 389.333 1198.97C366.134 1160.25 328.617 1175.07 284.655 1192.43C261.222 1201.69 235.959 1211.67 210.055 1214.65C195.807 1216.29 183.432 1214.51 172.469 1210.49Z'
      fill='black'
      fillOpacity='0.261009'
    />
    <path
      d='M467 1067.21C467 1062.52 470.802 1058.72 475.492 1058.72H549.498C576.56 1058.72 598.498 1080.65 598.498 1107.72V1226.41C598.498 1253.47 576.56 1275.41 549.498 1275.41H475.492C470.802 1275.41 467 1271.61 467 1266.92V1067.21Z'
      fill='url(#paint17_linear)'
    />
    <rect opacity='0.559129' x='487.809' y='1094' width='28' height='154' rx='14' fill='url(#paint18_linear)' />
    <rect x='563.809' y='1087' width='45' height='69' rx='5.66157' fill='url(#paint19_linear)' />
    <ellipse cx='321.142' cy='846.088' rx='251.595' ry='249.394' fill='url(#paint20_linear)' />
    <mask id='mask4' mask-type='alpha' maskUnits='userSpaceOnUse' x='69' y='596' width='504' height='500'>
      <ellipse cx='321.142' cy='846.088' rx='251.595' ry='249.394' fill='white' />
    </mask>
    <g mask='url(#mask4)'>
      <path
        d='M100.241 664.967C100.241 664.967 163.453 713.732 234.945 688.886C306.435 664.039 356.482 643.484 423.705 683.557C488.378 722.108 510.926 724.51 539.993 682.506C565.826 645.172 309.213 527.032 309.213 527.032L100.241 664.967Z'
        fill='url(#paint21_linear)'
      />
      <path
        d='M52.5572 788.662C52.5572 788.662 177.153 660.724 308.668 744.535C431.391 822.743 335.653 1068.67 249.364 1101.75C163.073 1134.83 50.0937 1018.06 41.3993 920.546C32.7049 823.026 52.5572 788.662 52.5572 788.662Z'
        fill='url(#paint22_linear)'
      />
      <path
        d='M324.892 848.969C333.552 905.821 324.86 941.431 298.279 983.565C293.821 990.631 284.479 992.745 277.414 988.288C270.348 983.83 268.233 974.488 272.691 967.422C295.563 931.169 302.488 902.796 294.983 853.525C293.725 845.265 299.401 837.55 307.66 836.292C315.919 835.034 323.634 840.71 324.892 848.969Z'
        fill='white'
        fillOpacity='0.326978'
      />
      <path
        d='M235.991 750.526C260.695 754.933 282.209 767.487 300.302 786.882C306.001 792.991 305.668 802.563 299.559 808.262C293.45 813.961 283.878 813.628 278.179 807.519C264.357 792.702 248.599 783.507 230.678 780.31C222.453 778.843 216.975 770.986 218.442 762.762C219.909 754.537 227.766 749.059 235.991 750.526Z'
        fill='white'
        fillOpacity='0.326978'
      />
      <path
        d='M582.665 762.287C543.348 990.259 477.958 1006.27 397.134 1081.06L644.412 980.502L582.665 762.287Z'
        fill='black'
        fillOpacity='0.123853'
      />
    </g>
    <path
      d='M412.36 797.203C403.945 809.825 412.762 896.911 429.856 899.386C446.948 901.86 482.364 885.514 486.761 869.573C491.158 853.633 481.059 812.055 468.626 799.286C456.192 786.516 420.774 784.58 412.36 797.203Z'
      fill='url(#paint23_linear)'
    />
    <path
      d='M450.707 790.348C457.98 792.073 464.544 795.099 468.628 799.293C481.06 812.062 491.16 853.64 486.763 869.581C483.894 879.982 467.816 890.557 452.241 895.962C438.598 879.366 432.339 808.5 439.866 797.21C441.878 794.191 445.434 792.006 449.851 790.601L450.707 790.348Z'
      fill='url(#paint24_linear)'
    />
    <ellipse cx='371.026' cy='1024.98' rx='9.474' ry='9.35923' fill='url(#paint25_linear)' />
    <ellipse cx='399.635' cy='1014.65' rx='9.474' ry='9.35923' fill='url(#paint26_linear)' />
    <ellipse cx='427.612' cy='1003.39' rx='9.474' ry='9.35923' fill='url(#paint27_linear)' />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M482.042 1004.51C495.688 995.245 509.42 996.146 518.908 1007.02C528.396 1017.89 528.986 1034.55 516.4 1043.89C399.63 1130.53 274.221 1138.13 154.419 1090.86C136.754 1083.89 134.937 1063.43 143.208 1051.61C151.479 1039.78 162.976 1038.11 179.595 1045.17C275.984 1086.13 376.866 1075.93 482.042 1004.51Z'
      fill='url(#paint28_linear)'
    />
    <mask id='mask5' mask-type='alpha' maskUnits='userSpaceOnUse' x='135' y='996' width='396' height='133'>
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M482.042 1004.51C495.688 995.245 509.42 996.146 518.908 1007.02C528.396 1017.89 528.986 1034.55 516.4 1043.89C399.63 1130.53 274.221 1138.13 154.419 1090.86C136.754 1083.89 134.937 1063.43 143.208 1051.61C151.479 1039.78 162.976 1038.11 179.595 1045.17C275.984 1086.13 376.866 1075.93 482.042 1004.51Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask5)'>
      <path
        opacity='0.969457'
        d='M449.523 1006.78C468.915 1023.09 480.88 1048.11 480.164 1072.36L480.078 1074.33L471.84 1073.85C473.091 1052.31 462.814 1029.56 445.738 1014.42L444.214 1013.1L449.523 1006.78Z'
        fill='url(#paint29_linear)'
      />
      <path
        opacity='0.969457'
        d='M481.615 988.586C501.006 1004.89 512.971 1029.91 512.255 1054.16L512.169 1056.13L503.932 1055.65C505.182 1034.11 494.906 1011.36 477.83 996.218L476.305 994.902L481.615 988.586Z'
        fill='url(#paint30_linear)'
      />
      <path
        opacity='0.969457'
        d='M415.447 1017.69C434.474 1039.16 445.884 1062.59 443.401 1083.76L443.162 1085.52L435.008 1084.26C437.807 1066.19 427.944 1044.83 410.803 1024.92L409.272 1023.16L415.447 1017.69Z'
        fill='url(#paint31_linear)'
      />
      <path
        opacity='0.969457'
        d='M383.635 1032.11C396.043 1048.17 403.659 1076.27 403.833 1100.83L403.826 1103.19L395.576 1103.09C395.864 1080.46 389.098 1053.86 378.208 1038.64L377.106 1037.16L383.635 1032.11Z'
        fill='url(#paint32_linear)'
      />
      <path
        opacity='0.969457'
        d='M337.061 1044.57L345.303 1044.2L345.619 1050.7C347.01 1077.16 349.365 1095.75 354.255 1113.52L354.854 1115.65L346.924 1117.93C341.208 1098.06 338.667 1077.76 337.217 1047.92L337.061 1044.57Z'
        fill='url(#paint33_linear)'
      />
      <path
        opacity='0.969457'
        d='M295.955 1051.9L304.103 1053.2C300.345 1076.78 300.596 1098.6 305.447 1118.49L306.172 1121.31L298.203 1123.45C292.588 1102.55 291.899 1079.75 295.445 1055.25L295.955 1051.9Z'
        fill='url(#paint34_linear)'
      />
      <path
        opacity='0.969457'
        d='M252.72 1053L260.334 1056.18C252.865 1074.06 249.73 1096.82 251.442 1117.96L251.706 1120.83L243.498 1121.67C241.21 1099.39 244.098 1075.13 251.701 1055.53L252.72 1053Z'
        fill='url(#paint35_linear)'
      />
      <path
        opacity='0.969457'
        d='M209.873 1040.1L217.013 1044.23C205.965 1063.3 201.556 1084.8 203.56 1107.81L203.809 1110.38L195.605 1111.26C192.951 1086.5 197.186 1063.17 208.578 1042.39L209.873 1040.1Z'
        fill='url(#paint36_linear)'
      />
      <path
        opacity='0.969457'
        d='M175.486 1026.75L181.98 1031.84C168.385 1049.19 161.028 1069.86 159.809 1092.93L159.699 1095.5L151.452 1095.23C152.27 1070.35 159.711 1047.83 173.883 1028.85L175.486 1026.75Z'
        fill='url(#paint37_linear)'
      />
    </g>
    <path
      d='M40.7183 1107.41C-31.33 1154.91 84.1962 1294.5 201.018 1295.35C317.841 1296.2 423.21 1237.18 383.836 1171.47C348.271 1112.11 279.06 1178.57 204.558 1187.15C113.669 1197.61 99.0166 1068.98 40.7183 1107.41Z'
      fill='url(#paint38_linear)'
    />
    <mask id='mask6' mask-type='alpha' maskUnits='userSpaceOnUse' x='18' y='1100' width='375' height='196'>
      <path
        d='M40.7183 1107.41C-31.33 1154.91 84.1962 1294.5 201.018 1295.35C317.841 1296.2 423.21 1237.18 383.836 1171.47C348.271 1112.11 279.06 1178.57 204.558 1187.15C113.669 1197.61 99.0166 1068.98 40.7183 1107.41Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask6)'>
      <path
        d='M36.0601 1108.75C36.0601 1108.75 112.909 1244.72 210.316 1236.77C307.721 1228.8 396.885 1142.55 396.885 1142.55L411.152 1275.41L137.908 1389.72L-20.9263 1226.32V1120.26L36.0601 1108.75Z'
        fill='url(#paint39_linear)'
      />
      <circle cx='38.6366' cy='1103.7' r='39.5126' fill='url(#paint40_linear)' />
    </g>
    <path
      d='M2316.12 866.062C2316.12 866.062 2161.86 897.751 1982.53 1070.01C1803.2 1242.27 1670.86 1509.04 1390.93 1300.35C1218.61 1171.86 998.161 1241.42 994.766 1286.38C990.708 1340.1 1144.85 1308.02 1247.61 1392.97C1390.04 1510.72 1470.28 1644.84 1753.49 1629.34C2002.26 1615.73 2114.8 1362.06 2248.88 1267.06C2345.07 1198.92 2415.57 1157.15 2415.57 1157.15L2316.12 866.062Z'
      fill='url(#paint41_linear)'
    />
    <path
      d='M2300.86 1052.27L2393.69 1170.53L2378.91 1179.8C2349.04 1198.7 2303.03 1228.7 2248.88 1267.06C2114.81 1362.06 2002.26 1615.73 1753.5 1629.34C1470.28 1644.84 1390.04 1510.72 1247.61 1392.97C1148.85 1311.33 1002.64 1337.77 995 1292.28L1001.93 1291.57C1079.98 1283.94 1178.82 1286.27 1252.02 1328.98C1392.85 1411.15 1576.88 1593.17 1802.11 1455.63C2027.37 1318.09 2300.86 1052.27 2300.86 1052.27Z'
      fill='url(#paint42_linear)'
    />
    <path
      opacity='0.151065'
      d='M1709.34 1337.88L2009.12 1512.37C1940.46 1574.33 1859.3 1623.55 1753.49 1629.34C1719.65 1631.19 1688.71 1630.91 1660.21 1628.77C1594.58 1561.6 1540.55 1467.04 1540.13 1372.56C1603.52 1384.74 1658.56 1369.17 1709.34 1337.88Z'
      fill='url(#paint43_linear)'
    />
    <path
      d='M1617.2 1560.35C1616.65 1569.02 1619.48 1569.75 1626.74 1571.83C1630.74 1572.97 1636.3 1574.54 1638.47 1569.69C1644.43 1556.43 1625.47 1551.49 1617.86 1559.76L1617.2 1560.35Z'
      fill='#15678F'
    />
    <path
      d='M1490.79 1516.73C1491.17 1520.41 1493.01 1524.57 1496.25 1526.61C1501.63 1530.01 1509.59 1528.05 1510.85 1521.06C1511.09 1519.76 1510.91 1518.33 1510.54 1517.07C1508.02 1508.76 1503.08 1512.02 1497.38 1513.88C1495.18 1514.61 1492.43 1513.51 1491.11 1516L1490.79 1516.73Z'
      fill='#15678F'
    />
    <path
      d='M1380.6 1450.31C1384.13 1453.97 1392.88 1455.04 1392.64 1447.74C1392.34 1438.89 1382.68 1440.08 1378.11 1444.32C1378.11 1444.32 1379.18 1448.87 1380.6 1450.31Z'
      fill='#15678F'
    />
    <path
      d='M1257.38 1371.97C1257.57 1373.64 1257.78 1375.36 1258.6 1376.82C1259.08 1377.67 1259.71 1378.62 1260.52 1379.2C1263.28 1381.12 1266.75 1379.24 1266.83 1375.91C1266.92 1372.03 1261.01 1368.08 1257.71 1370.59L1257.38 1371.97Z'
      fill='#15678F'
    />
    <path
      d='M1125.13 1319.76C1122.97 1312.46 1112.04 1310.6 1112.55 1319.78C1112.74 1323.16 1120.48 1328.21 1123.61 1326.47C1124.66 1325.87 1124.95 1323.56 1125.31 1322.51L1125.13 1319.76Z'
      fill='#15678F'
    />
    <path
      opacity='0.227028'
      d='M2214.42 869.217C2214.42 869.217 2116.67 1143.7 2009.81 1208.49C1902.96 1273.28 1806.89 1265 1806.89 1265L1974.76 1361.28L2199.25 1164.89L2214.42 869.217Z'
      fill='url(#paint44_linear)'
    />
    <path
      d='M2311.35 1321.58C2311.35 1321.58 2401.28 1674.04 2654.42 1631.31C2907.57 1588.57 2971.52 1376.43 3023.58 1232.58C3073.23 1095.4 3182.81 1008.98 3251.69 981.476C3301.45 961.602 3316.61 926.343 3223.65 931.009C3130.71 935.675 2947.12 1034.37 2879.73 1171.18C2802.36 1328.17 2612.84 1179.74 2586.65 1152C2552 1115.29 2311.35 1321.58 2311.35 1321.58Z'
      fill='url(#paint45_linear)'
    />
    <path
      d='M3282.79 963.282C3276.25 969.362 3266.26 975.404 3254.01 980.526L3251.69 981.475C3182.81 1008.98 3073.23 1095.4 3023.59 1232.58L3018.86 1245.7C2967.52 1389 2899.98 1589.85 2654.42 1631.3C2468.2 1662.75 2370.3 1480.3 2331.56 1381.65L2376.49 1301.54L2379.87 1306.26C2405.33 1341.42 2570.36 1560.55 2717.48 1545.35C2877.38 1528.83 2972.46 1171.6 3060.07 1072.28C3117.1 1007.64 3215.57 977.544 3277.39 964.413L3282.79 963.282Z'
      fill='url(#paint46_linear)'
    />
    <path
      opacity='0.476446'
      d='M2376.49 1301.53L2379.87 1306.26L2382.71 1310.16C2393.15 1324.34 2416.13 1354.43 2447.18 1388.53C2458.31 1495.31 2485.46 1545.49 2552.01 1626.59C2431.01 1592.36 2362.46 1460.35 2331.56 1381.65L2376.49 1301.53Z'
      fill='url(#paint47_linear)'
    />
    <path
      opacity='0.227028'
      d='M3023.69 1013.86C3085.1 1004.64 3128.13 1017.46 3172.45 1028.72C3139.54 1054.36 3105.58 1088.44 3076.45 1130.51L2912.89 1122.9L2913.51 1117.15C2943.65 1077.56 2982.55 1042.55 3023.69 1013.86Z'
      fill='url(#paint48_linear)'
    />
    <path
      d='M2651.62 1376.81C2651.62 1376.81 2978.8 1720.31 3160.74 1491.09C3342.7 1261.88 3367.93 1040.92 3453.11 1014.08C3538.28 987.243 3582.22 1018.84 3595.64 987.323C3607.06 960.484 3510.06 883.758 3398.03 924.026C3208.19 992.267 3169.53 1371.21 2941.72 1229.21C2871.61 1185.52 2651.62 1376.81 2651.62 1376.81Z'
      fill='url(#paint49_linear)'
    />
    <path
      d='M3422.44 1010.43C3475.57 985.892 3532.1 991.208 3574.26 1002.03C3551.26 1004.93 3512.06 995.509 3453.11 1014.08C3367.93 1040.92 3342.7 1261.89 3160.74 1491.1C2978.8 1720.31 2651.62 1376.81 2651.62 1376.81L2660.36 1369.39C2675.18 1356.97 2707.34 1330.7 2745.4 1303.77L2749.38 1308.94C2794.08 1366.44 2895.97 1480.39 3001.87 1480.97C3143.53 1481.74 3319.87 1057.79 3422.44 1010.43Z'
      fill='url(#paint50_linear)'
    />
    <path
      opacity='0.227028'
      d='M3328.45 1208.96L3323.72 1219.14C3302.59 1264.43 3277.72 1314.69 3246.13 1367.38L3152 1196.21C3180 1164.37 3205.75 1124.3 3232.72 1084.43C3281.17 1110.04 3312.65 1161.99 3328.45 1208.96Z'
      fill='url(#paint51_linear)'
    />
    <path
      d='M3334.03 1123.46C3331.7 1125.15 3329.48 1127.16 3327.84 1129.55C3326.93 1130.9 3326.14 1132.4 3325.82 1134.01C3324.83 1138.7 3328.95 1142.07 3333.3 1140.12C3337.87 1138.08 3337.64 1134.15 3339.34 1130.24C3340.68 1127.17 3341.93 1123.33 3337.26 1122.9L3334.03 1123.46Z'
      fill='#15678F'
    />
    <path
      d='M3386.95 1056.83C3385.15 1057.35 3383.45 1057.99 3381.81 1058.92C3380.92 1059.42 3379.99 1060.06 3379.28 1060.81C3376.84 1063.36 3378.31 1066.77 3381.51 1067.59C3387.61 1069.12 3396.21 1063.46 3389.27 1057.98L3386.95 1056.83Z'
      fill='#15678F'
    />
    <path
      d='M2973.91 1520.68C2978.11 1520.13 2982.66 1520.68 2983.92 1515.55C2986.08 1506.83 2976.29 1499.19 2968.19 1500.97C2962.81 1502.16 2960.59 1506.02 2958 1510.47C2958 1510.47 2965.34 1521.81 2973.91 1520.68Z'
      fill='#15678F'
    />
    <path
      d='M3082.17 1499.22C3080.03 1489.42 3065 1496.03 3064.01 1505.93C3064.01 1505.93 3084.33 1509.11 3082.17 1499.22Z'
      fill='#15678F'
    />
    <path
      d='M1089.99 1071.77C1132.75 1111.13 1278.3 1132.17 1345.57 1084.62C1566.63 928.367 1560.02 1046.74 1553.59 1174.84C1525.43 1736.61 2108.71 1698.19 2246.66 1528.24C2295.87 1467.61 2389.45 1351.45 2389.45 1351.45C2389.45 1351.45 2437.73 1518.73 2591.1 1588.5C2743.53 1657.84 2888.12 1523.4 2924.96 1486.42C2979.26 1431.93 3062.92 1377.06 3175.56 1519.54C3288.21 1662.05 3462.14 1602.81 3508.6 1519.07C3555.06 1435.33 3551.06 1365.23 3552.15 1325.32C3553.24 1285.41 3502.09 1233.76 3457.92 1306.99C3399.49 1403.95 3346.54 1407.73 3312.37 1317C3282.33 1237.28 3225.5 1055.5 3053.54 1049.48C2872.43 1043.14 2831.7 1182.52 2765.85 1181.95C2699.49 1181.38 2666.44 1049.52 2772.13 1003.62C2877.83 957.723 3343.87 839.704 3393.02 682.589C3448.5 505.211 3463.58 23.8359 3201.72 3.78581C2939.84 -16.2623 2373.85 33.9569 2283.76 383.654C2193.67 733.351 2211.17 1107.57 2048.32 1259.52C1936.86 1363.56 1774.72 1252.24 1763.51 1092.3C1751.18 916.25 1696.31 757.962 1560.17 762.895C1419.95 767.976 1371.58 882.097 1272.02 970.011C1188.31 1043.93 1131.23 1023.62 1109.33 1027.1C1087.43 1030.57 1073.86 1056.92 1089.99 1071.77Z'
      fill='url(#paint52_linear)'
    />
    <mask id='mask7' mask-type='alpha' maskUnits='userSpaceOnUse' x='1082' y='0' width='2471' height='1640'>
      <path
        d='M1089.99 1071.77C1132.75 1111.13 1278.3 1132.17 1345.57 1084.62C1566.63 928.367 1560.02 1046.74 1553.59 1174.84C1525.43 1736.61 2108.71 1698.19 2246.66 1528.24C2295.87 1467.61 2389.45 1351.45 2389.45 1351.45C2389.45 1351.45 2437.73 1518.73 2591.1 1588.5C2743.53 1657.84 2888.12 1523.4 2924.96 1486.42C2979.26 1431.93 3062.92 1377.06 3175.56 1519.54C3288.21 1662.05 3462.14 1602.81 3508.6 1519.07C3555.06 1435.33 3551.06 1365.23 3552.15 1325.32C3553.24 1285.41 3502.09 1233.76 3457.92 1306.99C3399.49 1403.95 3346.54 1407.73 3312.37 1317.01C3282.33 1237.28 3225.5 1055.5 3053.54 1049.48C2872.43 1043.14 2831.7 1182.52 2765.85 1181.95C2699.49 1181.38 2666.44 1049.52 2772.13 1003.62C2877.83 957.723 3343.87 839.704 3393.02 682.589C3448.5 505.211 3463.58 23.8359 3201.72 3.78581C2939.84 -16.2623 2373.85 33.957 2283.76 383.654C2193.67 733.351 2211.17 1107.57 2048.32 1259.52C1936.86 1363.56 1774.72 1252.24 1763.51 1092.3C1751.18 916.25 1696.31 757.962 1560.17 762.895C1419.95 767.976 1371.58 882.097 1272.02 970.011C1188.31 1043.93 1131.23 1023.62 1109.33 1027.1C1087.43 1030.57 1073.86 1056.92 1089.99 1071.77Z'
        fill='white'
      />
    </mask>
    <g mask='url(#mask7)'>
      <path
        d='M3440.85 440.169C3412.23 420.176 3363.87 412.307 3334.31 434.64C3308.06 454.465 3288.84 512.029 3318.31 537.313C3321.15 539.751 3324.66 541.529 3328.2 542.721C3342.64 547.6 3360.19 545.42 3373.87 551.838C3392.25 560.46 3398.6 590.383 3423.06 585.908C3487.21 574.172 3473.32 477.859 3439.12 444.138L3440.85 440.169Z'
        fill='#52EFFF'
      />
      <path
        d='M3223.03 111.493C3205.27 195.762 3305.59 233.422 3364.39 182.568C3402.17 149.913 3419.35 38.6302 3330.41 65.0568C3330.41 65.0568 3233.62 61.335 3223.03 111.493Z'
        fill='#52EFFF'
      />
      <path
        d='M2664.12 24.1227C2578.96 69.5041 2647.48 142.999 2723.39 113.928C2803.62 83.2006 2757.72 -5.51225 2677.9 14.71L2664.12 24.1227Z'
        fill='#52EFFF'
      />
      <path
        d='M2926.29 502.496C2924.23 515.559 2929 533.318 2945.12 534.181C2955.15 534.717 2972.47 524.916 2968.93 512.551C2963.88 495.026 2927.31 496.01 2926.29 502.496Z'
        fill='#52EFFF'
      />
      <path
        d='M2304.66 490.069C2328.21 478.288 2366.08 504.345 2346 529.944C2343.39 533.258 2339.92 535.567 2336.14 537.38C2333.18 538.814 2329.89 540.138 2326.59 540.591C2301.44 544.046 2318.62 519.47 2309 510.61C2301.44 503.652 2304.66 490.069 2304.66 490.069Z'
        fill='#52EFFF'
      />
      <path
        d='M2771.95 1011.49C2722.46 958.146 2674.26 1013.8 2712.13 1065.21C2732.93 1093.44 2785.56 1045.11 2768.47 1012.92L2771.95 1011.49Z'
        fill='#52EFFF'
      />
      <path
        opacity='0.147112'
        d='M3514.21 152.067C3514.21 152.067 3438.59 620.136 2984.23 775.783C2529.86 931.43 2704.35 1131.79 2704.35 1131.79L3552.16 742.315L3514.21 152.067Z'
        fill='url(#paint53_linear)'
      />
      <path
        opacity='0.227028'
        d='M3324.06 1354.44C3324.06 1354.44 3378.22 1440.09 3403.13 1432.38C3428.03 1424.66 3441.43 1313.16 3441.43 1313.16L3324.06 1354.44Z'
        fill='url(#paint54_linear)'
      />
    </g>
    <path
      d='M2386.74 1356.45L2417.17 1181.95L2419.16 1185.94C2439.75 1226.65 2616.34 1562.23 2783.46 1439.66C2912.93 1344.68 3038.99 1173.63 3185.85 1347.89C3340.53 1531.41 3436.39 1553.73 3494.9 1374.54L3514.61 1314.34C3518.94 1301.15 3523.08 1288.56 3527.03 1276.58C3542.44 1286.79 3552.65 1307.25 3552.16 1325.31L3552.03 1331.44C3551.33 1372.18 3552.76 1439.46 3508.6 1519.07C3462.14 1602.8 3288.21 1662.05 3175.56 1519.54C3064.04 1378.48 2980.93 1430.85 2926.6 1484.78L2921.36 1490C2879.43 1531.28 2738.96 1655.75 2591.09 1588.5C2454.6 1526.4 2401.34 1387.07 2391.27 1357.17L2389.44 1351.45L2386.74 1356.45Z'
      fill='url(#paint55_linear)'
    />
    <path
      opacity='0.476446'
      d='M2412.86 1079.94C2413.63 1226.05 2433.5 1355.73 2469.94 1494.95C2408.68 1424.04 2389.45 1351.46 2389.45 1351.46L2359.66 1388.4L2333.47 1354.44L2412.86 1079.94Z'
      fill='url(#paint56_linear)'
    />
    <path
      opacity='0.147112'
      d='M2450.86 800.431C2450.86 800.431 2442.92 793.233 2450.86 782.424C2481.63 740.566 2564.27 650.441 2566.85 655.133C2644.27 795.843 2516.65 922.373 2450.86 800.431Z'
      fill='url(#paint57_linear)'
    />
    <path
      d='M1575.17 958.12C1681.77 1038.98 1628.42 1389.8 1789.78 1473.11C1906.63 1533.43 2117.8 1626.22 2321.34 1236.34C2524.89 846.47 2363.81 1159.21 2363.81 1159.21L2406.21 1031.94C2406.21 1031.94 2421.74 1114.64 2415.57 1189.17C2410.73 1247.59 2399.1 1307.26 2380.66 1368.18C2380.37 1368.06 2380.15 1368.18 2379.99 1368.52C2187.01 1796.24 1519.93 1753.11 1553.59 1174.85L1554.46 1159.54C1561.13 1037.74 1557.78 934.621 1345.57 1084.63C1278.3 1132.18 1132.75 1111.13 1090 1071.78C1088.29 1070.2 1086.91 1068.5 1085.85 1066.72L1091.81 1068.08C1146.83 1080.42 1211.95 1087.05 1257.38 1066.27C1351.07 1023.4 1468.58 877.265 1575.17 958.12Z'
      fill='url(#paint58_linear)'
    />
    <path
      d='M2450.41 792.213C2450.41 792.213 2443.48 785.647 2450.41 775.785C2477.27 737.598 2554.2 645.34 2556.45 649.621C2624.02 777.99 2507.84 903.462 2450.41 792.213Z'
      fill='url(#paint59_linear)'
    />
    <path
      d='M2512.91 747.696C2517.3 742.458 2525.11 741.771 2530.35 746.163C2535.35 750.355 2536.2 757.658 2532.45 762.869L2531.88 763.599L2498.13 803.863C2493.73 809.102 2485.93 809.788 2480.69 805.396C2475.69 801.205 2474.84 793.901 2478.59 788.69L2479.16 787.96L2512.91 747.696Z'
      fill='#15678F'
    />
    <path
      opacity='0.227028'
      d='M2388.65 816.619C2393.58 899.715 2470.45 913.759 2542.21 885.911C2486.53 887.025 2433.96 871.467 2388.65 816.619Z'
      fill='url(#paint60_linear)'
    />
    <path
      opacity='0.227028'
      d='M2791.87 1175.41C2701.42 1208.21 2637 1174.26 2598.33 1074.32C2654.13 1146.3 2718.08 1182.47 2791.87 1175.41Z'
      fill='url(#paint61_linear)'
    />
    <path
      d='M1319.29 1048.72C1309.62 1054.38 1323.57 1056.39 1327.63 1055.81C1335.47 1054.69 1330.36 1048.26 1324.88 1048.52C1324.88 1048.52 1320.88 1047.79 1319.29 1048.72Z'
      fill='#15678F'
    />
    <path
      d='M1514.19 958.016C1512.17 961.229 1509.62 966.202 1512.8 969.603C1514.05 970.931 1519.55 972.538 1519.31 969.13C1519.08 965.844 1516.33 962.527 1515.63 959.174L1514.19 958.016Z'
      fill='#15678F'
    />
    <path
      d='M1583.9 1059.52C1579.07 1062.3 1575.51 1071.99 1582.87 1074.32C1592.41 1077.32 1591.48 1064.4 1588.33 1059.98C1588.33 1059.98 1585.54 1058.56 1583.9 1059.52Z'
      fill='#15678F'
    />
    <path
      d='M1606 1225.16C1604.44 1225.22 1602.91 1225.46 1601.41 1225.91C1593.02 1228.48 1602.02 1230.96 1603.65 1236.04C1605.23 1240.93 1602.79 1251.26 1610.93 1251.28C1618.94 1251.28 1623.29 1241.74 1621.2 1234.97C1619.2 1228.62 1606 1225.16 1606 1225.16Z'
      fill='#15678F'
    />
    <path
      d='M1647.65 1428.68C1650.5 1434.78 1651.17 1442.51 1657.86 1445.86C1672.25 1453.06 1673.77 1434.6 1666.25 1426.68C1663.68 1423.97 1660.47 1421.9 1657.35 1419.9C1657.35 1419.9 1643.89 1420.67 1647.65 1428.68Z'
      fill='#15678F'
    />
    <path
      d='M1809.64 1538.11C1802.6 1546.69 1810.87 1546.95 1813.94 1554.27C1815.58 1558.15 1815.26 1567.37 1821.99 1566.18C1830.28 1564.72 1832.6 1552.49 1829.33 1546.04C1825.67 1538.78 1810.4 1537.2 1809.64 1538.11Z'
      fill='#15678F'
    />
    <path
      d='M2017.09 1559.52C2015.53 1560.21 2014.04 1561.22 2012.84 1562.42C2005.58 1569.59 2013.25 1574.42 2016.2 1581.14C2018.22 1585.77 2018 1595.25 2025.9 1593.23C2044.24 1588.5 2036.46 1557.73 2018.34 1558.98L2017.09 1559.52Z'
      fill='#15678F'
    />
    <path
      d='M2205.63 1460.18C2204.6 1460.91 2203.43 1461.84 2202.56 1462.75C2201.55 1463.82 2200.8 1464.81 2200.07 1466.05C2196.58 1472.03 2205.15 1474.35 2208.61 1477.93C2212.73 1482.18 2211.05 1491.22 2219.85 1488.57C2228.04 1486.12 2231.72 1475.1 2228.3 1467.7C2224.9 1460.36 2216.53 1456.14 2208.69 1458.02C2208.69 1458.02 2207.25 1459.03 2205.63 1460.18Z'
      fill='#15678F'
    />
    <path
      d='M2322.61 1275.79C2321.34 1276.44 2320.03 1277.33 2319.02 1278.34C2309.86 1287.46 2318.41 1288.37 2324.98 1294.74C2329.73 1299.33 2332.14 1306.08 2339.94 1305.57C2348.61 1305.01 2354.11 1295.4 2351.08 1287.62C2348.15 1280.06 2340.97 1275.97 2333.37 1274.68C2333.37 1274.68 2324.86 1274.62 2322.61 1275.79Z'
      fill='#15678F'
    />
    <path
      d='M2469.13 1398.37C2471.33 1406.5 2473.33 1420.69 2485.42 1414.18C2503.07 1404.64 2490.66 1371.26 2470.83 1377.06C2470.83 1377.06 2466.84 1389.9 2469.13 1398.37Z'
      fill='#15678F'
    />
    <path
      d='M2569.18 1482.83C2566.7 1491.34 2583.52 1513.76 2591.12 1502.26C2598.02 1491.82 2584.08 1471.79 2572.26 1480.26L2569.18 1482.83Z'
      fill='#15678F'
    />
    <path
      d='M2677.39 1516.15C2677.35 1517.16 2677.39 1518.2 2677.59 1519.21C2678.71 1524.97 2686.31 1523.92 2690.51 1525.45C2693.71 1526.63 2699.08 1531.76 2702.44 1527.96C2702.97 1527.37 2703.37 1526.63 2703.71 1525.92C2705.88 1521.27 2702.14 1516.25 2698.56 1513.61C2692.59 1509.24 2683.17 1509.5 2678 1514.98L2677.39 1516.15Z'
      fill='#15678F'
    />
    <path
      d='M2851.97 1472.75C2845.44 1475.31 2841.66 1485.04 2849.87 1488.48C2858.9 1492.24 2862.69 1480.77 2860.02 1474.38C2860.02 1474.38 2854.09 1471.92 2851.97 1472.75Z'
      fill='#15678F'
    />
    <path
      d='M2968.65 1361.21C2968.02 1361.59 2967.41 1362 2966.83 1362.46C2960.94 1367.03 2967.21 1368.61 2969.05 1373.68C2970.33 1377.22 2969.27 1382.31 2974.49 1382.46C2980.86 1382.66 2985.27 1374.37 2983.1 1368.77C2981.24 1363.92 2975.84 1361.23 2971.07 1360.36C2971.07 1360.36 2970.2 1360.28 2968.65 1361.21Z'
      fill='#15678F'
    />
    <path
      d='M3093.81 1352.09C3092.93 1354.43 3092.42 1356.92 3092.45 1359.44C3092.73 1382.15 3124.02 1365.04 3111.49 1349.54C3109.57 1347.16 3095.25 1348.23 3093.81 1352.09Z'
      fill='#15678F'
    />
    <path
      d='M3188.51 1440.45C3186.11 1444.69 3190.21 1454.03 3194.38 1455.83C3198.04 1457.41 3203.49 1454.6 3202.93 1450.27C3202.64 1447.87 3200.62 1446.15 3200.16 1443.78C3199.75 1441.54 3200.32 1439.33 3198.82 1437.37C3198.82 1437.37 3190.23 1437.41 3188.51 1440.45Z'
      fill='#15678F'
    />
    <path
      d='M3299.37 1518.85C3298.18 1519.27 3297.21 1519.82 3296.22 1520.58C3290.7 1524.65 3297.85 1527.03 3299.39 1530.86C3300.58 1533.87 3299.13 1538.17 3302.54 1540.05C3304.87 1541.33 3307.44 1539.99 3309.16 1538.26C3312.27 1535.14 3312.23 1529.99 3310.33 1526.21C3308.85 1523.25 3300.81 1518.34 3299.37 1518.85Z'
      fill='#15678F'
    />
    <path
      d='M3407.78 1531.03C3406.15 1532.05 3403.22 1534.47 3403.13 1536.68C3402.97 1540.66 3409.52 1540.96 3412.09 1540.05C3420.1 1537.28 3417.31 1529.76 3409.85 1530.27L3407.78 1531.03Z'
      fill='#15678F'
    />
    <path
      d='M3131.71 1036.57C3130.51 1036.75 3128.49 1037 3127.22 1037.39C3126.05 1037.75 3124.95 1038.23 3123.94 1038.92C3115.86 1044.46 3137 1047.92 3132.58 1039.08L3131.71 1036.57Z'
      fill='#15678F'
    />
    <path
      d='M3194.82 997.53C3193.93 997.743 3192.98 998.093 3192.15 998.515C3191.47 998.857 3190.82 999.2 3190.27 999.738C3188.45 1001.57 3189.63 1003.76 3191.93 1004.06C3194.5 1004.4 3196.62 1002.01 3196.76 999.579L3194.82 997.53Z'
      fill='#15678F'
    />
    <path
      opacity='0.227028'
      d='M0.80957 1666.74L3680.83 1639.23V1683.24H0.80957V1666.74Z'
      fill='url(#paint62_linear)'
    />
    <defs>
      <linearGradient
        id='paint0_linear'
        x1='660.697'
        y1='1269.95'
        x2='154.819'
        y2='1234.97'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint1_linear'
        x1='544.498'
        y1='1424.98'
        x2='691.421'
        y2='1489.7'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#165B7A' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint2_linear'
        x1='204.082'
        y1='1738.92'
        x2='336.638'
        y2='1482.78'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#2BB6C4' />
        <stop offset='0.85' stopColor='#259EB1' />
        <stop offset='1' stopColor='#2290A1' />
      </linearGradient>
      <linearGradient
        id='paint3_linear'
        x1='546.005'
        y1='1169.64'
        x2='-66.006'
        y2='1141.23'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint4_linear'
        x1='55.9575'
        y1='1315.57'
        x2='-2.98064'
        y2='1292.14'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint5_linear'
        x1='277.484'
        y1='1336.79'
        x2='32.3568'
        y2='1246.25'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint6_linear'
        x1='78.6887'
        y1='1609.84'
        x2='185.057'
        y2='1656.69'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#165B7A' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint7_linear'
        x1='725.503'
        y1='1029.35'
        x2='409.665'
        y2='1012.01'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint8_linear'
        x1='543.247'
        y1='1168.47'
        x2='435.294'
        y2='1092.22'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint9_linear'
        x1='618.743'
        y1='1239.11'
        x2='777.965'
        y2='1309.25'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#165B7A' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint10_linear'
        x1='565.731'
        y1='958.674'
        x2='68.2779'
        y2='936.422'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint11_linear'
        x1='506.577'
        y1='1307.28'
        x2='485.738'
        y2='1041.54'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint12_linear'
        x1='302.478'
        y1='1076.07'
        x2='297.042'
        y2='1187.96'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint13_linear'
        x1='327.213'
        y1='1086.61'
        x2='324.04'
        y2='1188.77'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint14_linear'
        x1='337.588'
        y1='1099.76'
        x2='335.205'
        y2='1209.66'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint15_linear'
        x1='344.22'
        y1='1158.41'
        x2='343.536'
        y2='1225.46'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint16_linear'
        x1='344.155'
        y1='1222.35'
        x2='343.968'
        y2='1257.41'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint17_linear'
        x1='664.919'
        y1='1024.61'
        x2='466.107'
        y2='999.421'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#77CEFF' />
        <stop offset='1' stopColor='#20B0FF' />
      </linearGradient>
      <linearGradient
        id='paint18_linear'
        x1='451.074'
        y1='1226.12'
        x2='499.791'
        y2='1235.12'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#00A5FF' />
        <stop offset='1' stopColor='#0F38CD' />
      </linearGradient>
      <linearGradient
        id='paint19_linear'
        x1='544.051'
        y1='1036.33'
        x2='544.051'
        y2='1139.2'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#00A5FF' />
        <stop offset='1' stopColor='#0F38CD' />
      </linearGradient>
      <linearGradient
        id='paint20_linear'
        x1='69.5464'
        y1='596.694'
        x2='69.5464'
        y2='1095.48'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#52EFFF' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint21_linear'
        x1='16.6642'
        y1='1051.27'
        x2='223.306'
        y2='649.823'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#34D7E8' />
        <stop offset='0.85' stopColor='#259EB1' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint22_linear'
        x1='-41.1587'
        y1='1037.5'
        x2='419.987'
        y2='1207.65'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#165B7A' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint23_linear'
        x1='394.243'
        y1='1101.08'
        x2='525.675'
        y2='1024.75'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#34D7E8' />
        <stop offset='0.85' stopColor='#259EB1' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint24_linear'
        x1='378.862'
        y1='1006.18'
        x2='525.763'
        y2='1015.55'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#B1F5FF' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint25_linear'
        x1='365.614'
        y1='1021.89'
        x2='360.812'
        y2='1039.5'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint26_linear'
        x1='394.224'
        y1='1011.56'
        x2='389.421'
        y2='1029.17'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint27_linear'
        x1='422.201'
        y1='1000.3'
        x2='417.398'
        y2='1017.91'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint28_linear'
        x1='725.055'
        y1='1120.33'
        x2='710.62'
        y2='927.676'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint29_linear'
        x1='429.436'
        y1='965.566'
        x2='431.319'
        y2='1095.76'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint30_linear'
        x1='461.527'
        y1='947.367'
        x2='463.41'
        y2='1077.57'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint31_linear'
        x1='395.058'
        y1='976.403'
        x2='396.715'
        y2='1106.86'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint32_linear'
        x1='365.843'
        y1='988.939'
        x2='365.405'
        y2='1124.68'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint33_linear'
        x1='331.133'
        y1='998.658'
        x2='317.19'
        y2='1136.61'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint34_linear'
        x1='284.357'
        y1='1008.69'
        x2='277.684'
        y2='1142.89'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint35_linear'
        x1='240.079'
        y1='1010.37'
        x2='225.412'
        y2='1139.27'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint36_linear'
        x1='203.935'
        y1='994.268'
        x2='171.014'
        y2='1126.57'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint37_linear'
        x1='175.983'
        y1='980.543'
        x2='124.97'
        y2='1106.97'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#021F24' />
      </linearGradient>
      <linearGradient
        id='paint38_linear'
        x1='448.361'
        y1='1057.3'
        x2='-87.9804'
        y2='1019.59'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint39_linear'
        x1='134.572'
        y1='1188.8'
        x2='-77.6134'
        y2='1059.09'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#25A0B3' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint40_linear'
        x1='-20.2452'
        y1='1129.09'
        x2='85.5198'
        y2='1175.68'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#165B7A' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint41_linear'
        x1='983.368'
        y1='860.555'
        x2='1110.64'
        y2='1606.57'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#0B6E7E' />
      </linearGradient>
      <linearGradient
        id='paint42_linear'
        x1='1317.46'
        y1='1228.3'
        x2='1317.46'
        y2='1556.82'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#52EFFF' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint43_linear'
        x1='1567.64'
        y1='1182.44'
        x2='1381.15'
        y2='1588.26'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint44_linear'
        x1='1830.79'
        y1='607.888'
        x2='1420.46'
        y2='1069.42'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint45_linear'
        x1='2448.9'
        y1='939.98'
        x2='2636.41'
        y2='1426.25'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#0B6E7E' />
      </linearGradient>
      <linearGradient
        id='paint46_linear'
        x1='1729.48'
        y1='704.996'
        x2='1766.39'
        y2='1556.79'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#52EFFF' />
        <stop offset='1' stopColor='#1A8494' />
      </linearGradient>
      <linearGradient
        id='paint47_linear'
        x1='2344.49'
        y1='1128.9'
        x2='2072.47'
        y2='1379.45'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint48_linear'
        x1='2928.11'
        y1='947.081'
        x2='2866.82'
        y2='1127.44'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint49_linear'
        x1='2767.22'
        y1='924.965'
        x2='2942.88'
        y2='1407.03'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#0B6E7E' />
      </linearGradient>
      <linearGradient
        id='paint50_linear'
        x1='2404.29'
        y1='1224.52'
        x2='2565.55'
        y2='1786.52'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#52EFFF' />
        <stop offset='1' stopColor='#1A8494' />
      </linearGradient>
      <linearGradient
        id='paint51_linear'
        x1='3162.35'
        y1='934.156'
        x2='2928.01'
        y2='1132.62'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint52_linear'
        x1='709.466'
        y1='-304.185'
        x2='709.466'
        y2='1798.25'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset='1' stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint53_linear'
        x1='2708.5'
        y1='-368.252'
        x2='1904.86'
        y2='630.16'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint54_linear'
        x1='3330.95'
        y1='1249.51'
        x2='3234.26'
        y2='1378.09'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint55_linear'
        x1='2289.76'
        y1='1111.93'
        x2='2231.07'
        y2='1498.25'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#52EFFF' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint56_linear'
        x1='2341.63'
        y1='843.439'
        x2='2076.08'
        y2='960.777'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint57_linear'
        x1='2455.76'
        y1='551.6'
        x2='2292.35'
        y2='715.451'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint58_linear'
        x1='1085.84'
        y1='934.153'
        x2='1085.84'
        y2='1654.17'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#52EFFF' />
        <stop offset='1' stopColor='#25A0B3' />
      </linearGradient>
      <linearGradient
        id='paint59_linear'
        x1='2300.96'
        y1='1028.93'
        x2='2671.49'
        y2='1063'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#B1F5FF' />
        <stop offset='1' stopColor='#34D7E8' />
      </linearGradient>
      <linearGradient
        id='paint60_linear'
        x1='2397.66'
        y1='772.904'
        x2='2350.45'
        y2='892.504'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint61_linear'
        x1='2609.69'
        y1='1014.2'
        x2='2540.63'
        y2='1174.55'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset='1' stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint62_linear'
        x1='216.672'
        y1='1615.86'
        x2='216.022'
        y2='1689.76'
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='white' />
        <stop offset='1' stopColor='#F1F1F1' />
      </linearGradient>
    </defs>
  </svg>
  /* eslint-enable max-len */
);
