<!-- The text in this file is automatically generated by the update_readme.py script. -->
# PXL Scripts Overview

Pixie open sources all of its scripts, which serve as examples of scripting in the PxL language.
To learn more about PxL, take a look at the [reference docs](https://docs.px.dev/reference/pxl) or [tutorials](https://docs.px.dev/tutorials/pxl-scripts/write-pxl-scripts/).

To update this README, run `make update_readme` in this directory.
- bpftrace/[capable](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/capable): Traces calls to the kernel cap_capable() function, which does security capability checks.
- bpftrace/[dc_snoop](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/dc_snoop): Traces directory entry cache (dcache) lookups.
- bpftrace/[exec_snoop](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/exec_snoop): Tracing system exec events.
- bpftrace/[md_flush](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/md_flush): Traces flushes at the md driver level, and prints details.
- bpftrace/[nap_time](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/nap_time): Tracing application sleeps via the nanosleep(2) syscall.
- bpftrace/[oom_kill](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/oom_kill): Traces the Linux out-of-memory (OOM) killer and shows basic details on one line per OOM kill.
- bpftrace/[socket_size](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/socket_size): Shows info and size stats for socket I/O requests.
- bpftrace/[sync_snoop](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/sync_snoop): Tracing file system sync events.
- bpftrace/[tcp_drops](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/tcp_drops): Shows TCP drop counts in the cluster.
- bpftrace/[tcp_retransmits](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/bpftrace/tcp_retransmits): Shows TCP retransmission counts in the cluster.
- px/[agent_status](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/agent_status): This script gets the status of all the pixie agents (PEMs/Collectors) running.
- px/[agent_status_diagnostics](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/agent_status_diagnostics): This script performs diagnostics on the agents' (PEMs/Collectors) status
- px/[amqp_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/amqp_data): Shows a sample of amqp messages in the cluster.
- px/[cluster](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/cluster): This view lists the namespaces and the node that are available on the current cluster.
- px/[collect_agent_heaps](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/collect_agent_heaps): Script useful for debugging kelvin and PEM memory footprint.
- px/[cql_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/cql_data): Shows a sample of CQL (Cassandra) requests in the cluster.
- px/[cql_flow_graph](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/cql_flow_graph): Graph of Cassandra messages in the cluster, with latency stats.
- px/[cql_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/cql_stats): This live view calculates the latency, error rate, and throughput of a pod's CQL (Cassandra) requests.
- px/[differential_flamegraph](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/differential_flamegraph): This live view shows a differential CPU flame graph. This is helpful in identifying what code paths have changed between deployments, different container instances, etc.
- px/[dns_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/dns_data): Show a sample of DNS traffic in the cluster.
- px/[dns_flow_graph](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/dns_flow_graph): Overview of DNS requests in the cluster, with latency stats.
- px/[dns_query_summary](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/dns_query_summary): Overview of DNS queries from pods in a namespace, grouped by the name being resolved and the rates of success.
- px/[funcs](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/funcs): Gets a list all of the funcs available in Pixie.
- px/[http_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/http_data): Shows most recent HTTP messages in the cluster.
- px/[http_data_filtered](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/http_data_filtered): Show a sample of HTTP requests in the Cluster filtered by service, pod, request path & response status code.
- px/[http_post_requests](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/http_post_requests): Show a sample of HTTP requests in the Cluster that have method POST.
- px/[http_request_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/http_request_stats): HTTP request statistics aggregated by Service
- px/[http_trace_id](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/http_trace_id): Shows HTTP requests with trace IDs in the cluster. Allows configuring which header contains the trace ID and filtering requests by trace ID.
- px/[inbound_conns](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/inbound_conns): Shows a list of connections originating from endpoints outside the k8s cluster.
- px/[ip](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/ip): This view displays a summary of the traffic from the cluster to the input IP address.
- px/[jvm_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/jvm_data): JVM stats for Java processes running on the cluster
- px/[jvm_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/jvm_stats): Returns the JVM Stats per Pod. You can filter this by node.
- px/[kafka_consumer_rebalancing](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/kafka_consumer_rebalancing): Visualizes the most recent Kafka consumer rebalancing events, with delay.
- px/[kafka_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/kafka_data): Shows a sample of Kafka messages in the cluster.
- px/[kafka_overview](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/kafka_overview): Overview of the Kafka cluster.
- px/[kafka_producer_consumer_latency](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/kafka_producer_consumer_latency): Shows the producer-consumer latency for a given topic. Values above 0 indicate that the consumer is falling behind the producer.
- px/[largest_http_request](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/largest_http_request): Calculates the largest HTTP Request according to the passed in filter value.
- px/[mongodb_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/mongodb_data): Shows the most recent MongoDB messages in the cluster.
- px/[most_http_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/most_http_data): Finds the endpoint on a specific Pod that passes the most HTTP Data. Optionally, you can uncomment a line to see a table summarizing data per service, endpoint pair.
- px/[mux_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/mux_data): Shows most recent Mux traffic in the cluster.
- px/[mysql_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/mysql_data): Shows most recent MySQL messages in the cluster.
- px/[mysql_flow_graph](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/mysql_flow_graph): Graph of MySQL messages in the cluster, with latency stats.
- px/[mysql_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/mysql_stats): This live view calculates the latency, error rate, and throughput of a pod's MySQL requests.
- px/[namespace](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/namespace): This view gives a top-level summary of the pods and services in a given namespace, as well as a service map.
- px/[namespaces](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/namespaces): This view lists the namespaces on the current cluster and their pod and service counts. It also lists the high-level resource consumption by namespace.
- px/[nats_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/nats_data): Shows most recent NATS messages in the cluster.
- px/[net_flow_graph](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/net_flow_graph): The mapping of all outgoing connections for the specified k8s pods in the namespace.
- px/[network_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/network_stats): Get network stats time series
- px/[node](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/node): This view summarizes the process and network stats for a given input node in a cluster. It computes CPU, memory consumption, as well as network traffic statistics. It also displays a list of pods that were on that node during the time window.
- px/[nodes](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/nodes): This view summarizes the process and network stats for each node in a cluster. It computes CPU, memory consumption, as well as network traffic statistics, per node. It also displays a list of pods that were on each node during the time window.
- px/[outbound_conns](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/outbound_conns): Shows a list of connections that are to endpoints outside the k8s cluster.
- px/[perf_flamegraph](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/perf_flamegraph): Shows stack trace samples that indicate where applications are spending their time.
- px/[pgsql_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pgsql_data): Shows most recent PGSQL (Postgres) messages in the cluster.
- px/[pgsql_flow_graph](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pgsql_flow_graph): Graph of PostgreSQL messages in the cluster, with latency stats.
- px/[pgsql_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pgsql_stats): This live view calculates the latency, error rate, and throughput of a pod's PostgreSQL requests.
- px/[pid_memory_usage](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pid_memory_usage): Get the Virtual memory usage and average memory for all processes in the k8s cluster.
- px/[pixie_quality_metrics](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pixie_quality_metrics): Metrics that sample Pixie's collector data.
- px/[pod](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pod): Overview of a specific Pod monitored by Pixie with its high level application metrics (latency, error-rate & rps) and resource usage (cpu, writes, reads).
- px/[pod_edge_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pod_edge_stats): Gets pod latency, error rate and throughput according to another service. Edit the requestor filter to the name of the incoming service you want to filter by. Visualize these in three separate time series charts.
- px/[pod_lifetime_resource](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pod_lifetime_resource): Total resource usage of a pod over it's lifetime.
- px/[pod_memory_usage](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pod_memory_usage): Get the Virtual memory usage and average memory for all processes in the k8s cluster.
- px/[pods](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/pods): List of Pods monitored by Pixie in a given Namespace with their high level application metrics (latency, error-rate & rps) and resource usage (cpu, writes, reads).
- px/[redis_data](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/redis_data): Shows a sample of Redis messages in the cluster.
- px/[redis_flow_graph](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/redis_flow_graph): Graph of Redis messages in the cluster, with latency stats.
- px/[redis_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/redis_stats): This live view calculates the latency, error rate, and throughput of a pod's Redis requests.
- px/[schemas](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/schemas): Get all the table schemas available in the system
- px/[service](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/service): This script gets an overview of an individual service, summarizing its request statistics.
- px/[service_edge_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/service_edge_stats): Gets service latency, error rate and throughput according to another service. Edit the requestor filter to the name of the incoming service you want to filter by. Visualize these in three separate time series charts.
- px/[service_resource_usage](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/service_resource_usage): Get the average pod CPU, pod memory, HTTP throughput and latency by service.
- px/[service_stats](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/service_stats): Gets service latency, error rate and throughput. Visualize them in three separate time series charts.
- px/[services](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/services): This script gets an overview of the services in a namespace, summarizing their request statistics.
- px/[slow_http_requests](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/slow_http_requests): This view shows a sample of slow requests by service.
- px/[sql_queries](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/sql_queries): This live view calculates the latency, error rate, and throughput of each distinct normalized SQL Query. Only supports Postgres or MySQL.
- px/[sql_query](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/sql_query): This live view calculates the latency, error rate, and throughput of each distinct parameter set for a given normalized SQL query. Only supports PostgresSQL or MySQL.
- px/[stirling_errors](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/stirling_errors): Shows errors in different Stirling components and deployment statuses of eBPF probes.
- px/[tracepoint_status](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/tracepoint_status): Returns information about tracepoints running on the cluster.
- px/[upids](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/px/upids): Shows a list of UPIDs running in a given namespace.
- pxbeta/[pii_cluster_egress](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/pxbeta/pii_cluster_egress): This view displays a summary of traffic containing PII from the cluster to external endpoints.
- pxbeta/[service_endpoint](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/pxbeta/service_endpoint): This script gets an overview of an individual endpoint for an individual service, summarizing its request statistics.
- pxbeta/[service_endpoints](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/pxbeta/service_endpoints): This script gets an overview of the endpoints for a service, summarizing their request statistics.
- pxbeta/[vfs_snoop](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/pxbeta/vfs_snoop): Traces file writes and deletions.
- sotw/[dns_external_fqdn_list](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/sotw/dns_external_fqdn_list): Lists external, fully qualified domain names (FQDNs) from all DNS traffic on the cluster for a specified amount of time.
- sotw/[dns_queries_filtered](https://github.com/pixie-io/pixie/tree/main/src/pxl_scripts/sotw/dns_queries_filtered): Lists all DNS queries filtered by a specific query name.
