// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "px.dev/pixie/src/operator/apis/px.dev/v1alpha1"
)

// FakeViziers implements VizierInterface
type FakeViziers struct {
	Fake *FakePxV1alpha1
	ns   string
}

var viziersResource = schema.GroupVersionResource{Group: "px.dev", Version: "v1alpha1", Resource: "viziers"}

var viziersKind = schema.GroupVersionKind{Group: "px.dev", Version: "v1alpha1", Kind: "Vizier"}

// Get takes name of the vizier, and returns the corresponding vizier object, and an error if there is any.
func (c *FakeViziers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Vizier, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(viziersResource, c.ns, name), &v1alpha1.Vizier{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Vizier), err
}

// List takes label and field selectors, and returns the list of Viziers that match those selectors.
func (c *FakeViziers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VizierList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(viziersResource, viziersKind, c.ns, opts), &v1alpha1.VizierList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.VizierList{ListMeta: obj.(*v1alpha1.VizierList).ListMeta}
	for _, item := range obj.(*v1alpha1.VizierList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested viziers.
func (c *FakeViziers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(viziersResource, c.ns, opts))

}

// Create takes the representation of a vizier and creates it.  Returns the server's representation of the vizier, and an error, if there is any.
func (c *FakeViziers) Create(ctx context.Context, vizier *v1alpha1.Vizier, opts v1.CreateOptions) (result *v1alpha1.Vizier, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(viziersResource, c.ns, vizier), &v1alpha1.Vizier{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Vizier), err
}

// Update takes the representation of a vizier and updates it. Returns the server's representation of the vizier, and an error, if there is any.
func (c *FakeViziers) Update(ctx context.Context, vizier *v1alpha1.Vizier, opts v1.UpdateOptions) (result *v1alpha1.Vizier, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(viziersResource, c.ns, vizier), &v1alpha1.Vizier{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Vizier), err
}

// Delete takes name of the vizier and deletes it. Returns an error if one occurs.
func (c *FakeViziers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(viziersResource, c.ns, name), &v1alpha1.Vizier{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeViziers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(viziersResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.VizierList{})
	return err
}

// Patch applies the patch and returns the patched vizier.
func (c *FakeViziers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Vizier, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(viziersResource, c.ns, name, pt, data, subresources...), &v1alpha1.Vizier{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Vizier), err
}
