/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <chrono>
#include <functional>
#include <memory>

#include "src/common/event/dispatcher.h"

namespace px {
namespace event {

/**
 * API is the interface for event system.
 */
class API {
 public:
  virtual ~API() = default;

  /**
   * Allocate a new dispatcher.
   * @return unique_ptr to dispatcher.
   */
  virtual DispatcherUPtr AllocateDispatcher(std::string_view name) = 0;

  /**
   * @return a reference to the TimeSource
   */
  virtual const TimeSource& TimeSourceRef() const = 0;
};

using APIUPtr = std::unique_ptr<API>;

}  // namespace event
}  // namespace px
