// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: src/cloud/project_manager/projectmanagerpb/service.proto

package projectmanagerpb

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	uuidpb "px.dev/pixie/src/api/proto/uuidpb"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ProjectInfo struct {
	ProjectName string       `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	OrgID       *uuidpb.UUID `protobuf:"bytes,2,opt,name=org_id,json=orgId,proto3" json:"org_id,omitempty"`
}

func (m *ProjectInfo) Reset()      { *m = ProjectInfo{} }
func (*ProjectInfo) ProtoMessage() {}
func (*ProjectInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c9d981df0c32c1d, []int{0}
}
func (m *ProjectInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProjectInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProjectInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProjectInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProjectInfo.Merge(m, src)
}
func (m *ProjectInfo) XXX_Size() int {
	return m.Size()
}
func (m *ProjectInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProjectInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProjectInfo proto.InternalMessageInfo

func (m *ProjectInfo) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *ProjectInfo) GetOrgID() *uuidpb.UUID {
	if m != nil {
		return m.OrgID
	}
	return nil
}

type GetProjectByNameRequest struct {
	ProjectName string       `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	OrgID       *uuidpb.UUID `protobuf:"bytes,2,opt,name=org_id,json=orgId,proto3" json:"org_id,omitempty"`
}

func (m *GetProjectByNameRequest) Reset()      { *m = GetProjectByNameRequest{} }
func (*GetProjectByNameRequest) ProtoMessage() {}
func (*GetProjectByNameRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c9d981df0c32c1d, []int{1}
}
func (m *GetProjectByNameRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetProjectByNameRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetProjectByNameRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetProjectByNameRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProjectByNameRequest.Merge(m, src)
}
func (m *GetProjectByNameRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetProjectByNameRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProjectByNameRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProjectByNameRequest proto.InternalMessageInfo

func (m *GetProjectByNameRequest) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *GetProjectByNameRequest) GetOrgID() *uuidpb.UUID {
	if m != nil {
		return m.OrgID
	}
	return nil
}

type IsProjectAvailableRequest struct {
	ProjectName string       `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	OrgID       *uuidpb.UUID `protobuf:"bytes,2,opt,name=org_id,json=orgId,proto3" json:"org_id,omitempty"`
}

func (m *IsProjectAvailableRequest) Reset()      { *m = IsProjectAvailableRequest{} }
func (*IsProjectAvailableRequest) ProtoMessage() {}
func (*IsProjectAvailableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c9d981df0c32c1d, []int{2}
}
func (m *IsProjectAvailableRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsProjectAvailableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsProjectAvailableRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsProjectAvailableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsProjectAvailableRequest.Merge(m, src)
}
func (m *IsProjectAvailableRequest) XXX_Size() int {
	return m.Size()
}
func (m *IsProjectAvailableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsProjectAvailableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsProjectAvailableRequest proto.InternalMessageInfo

func (m *IsProjectAvailableRequest) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *IsProjectAvailableRequest) GetOrgID() *uuidpb.UUID {
	if m != nil {
		return m.OrgID
	}
	return nil
}

type IsProjectAvailableResponse struct {
	Available bool `protobuf:"varint,1,opt,name=available,proto3" json:"available,omitempty"`
}

func (m *IsProjectAvailableResponse) Reset()      { *m = IsProjectAvailableResponse{} }
func (*IsProjectAvailableResponse) ProtoMessage() {}
func (*IsProjectAvailableResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c9d981df0c32c1d, []int{3}
}
func (m *IsProjectAvailableResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsProjectAvailableResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsProjectAvailableResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsProjectAvailableResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsProjectAvailableResponse.Merge(m, src)
}
func (m *IsProjectAvailableResponse) XXX_Size() int {
	return m.Size()
}
func (m *IsProjectAvailableResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_IsProjectAvailableResponse.DiscardUnknown(m)
}

var xxx_messageInfo_IsProjectAvailableResponse proto.InternalMessageInfo

func (m *IsProjectAvailableResponse) GetAvailable() bool {
	if m != nil {
		return m.Available
	}
	return false
}

type RegisterProjectRequest struct {
	ProjectName string       `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	OrgID       *uuidpb.UUID `protobuf:"bytes,2,opt,name=org_id,json=orgId,proto3" json:"org_id,omitempty"`
}

func (m *RegisterProjectRequest) Reset()      { *m = RegisterProjectRequest{} }
func (*RegisterProjectRequest) ProtoMessage() {}
func (*RegisterProjectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c9d981df0c32c1d, []int{4}
}
func (m *RegisterProjectRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegisterProjectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegisterProjectRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegisterProjectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterProjectRequest.Merge(m, src)
}
func (m *RegisterProjectRequest) XXX_Size() int {
	return m.Size()
}
func (m *RegisterProjectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterProjectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterProjectRequest proto.InternalMessageInfo

func (m *RegisterProjectRequest) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *RegisterProjectRequest) GetOrgID() *uuidpb.UUID {
	if m != nil {
		return m.OrgID
	}
	return nil
}

type RegisterProjectResponse struct {
	ProjectRegistered bool `protobuf:"varint,1,opt,name=project_registered,json=projectRegistered,proto3" json:"project_registered,omitempty"`
}

func (m *RegisterProjectResponse) Reset()      { *m = RegisterProjectResponse{} }
func (*RegisterProjectResponse) ProtoMessage() {}
func (*RegisterProjectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c9d981df0c32c1d, []int{5}
}
func (m *RegisterProjectResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegisterProjectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegisterProjectResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegisterProjectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterProjectResponse.Merge(m, src)
}
func (m *RegisterProjectResponse) XXX_Size() int {
	return m.Size()
}
func (m *RegisterProjectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterProjectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterProjectResponse proto.InternalMessageInfo

func (m *RegisterProjectResponse) GetProjectRegistered() bool {
	if m != nil {
		return m.ProjectRegistered
	}
	return false
}

func init() {
	proto.RegisterType((*ProjectInfo)(nil), "px.services.ProjectInfo")
	proto.RegisterType((*GetProjectByNameRequest)(nil), "px.services.GetProjectByNameRequest")
	proto.RegisterType((*IsProjectAvailableRequest)(nil), "px.services.IsProjectAvailableRequest")
	proto.RegisterType((*IsProjectAvailableResponse)(nil), "px.services.IsProjectAvailableResponse")
	proto.RegisterType((*RegisterProjectRequest)(nil), "px.services.RegisterProjectRequest")
	proto.RegisterType((*RegisterProjectResponse)(nil), "px.services.RegisterProjectResponse")
}

func init() {
	proto.RegisterFile("src/cloud/project_manager/projectmanagerpb/service.proto", fileDescriptor_2c9d981df0c32c1d)
}

var fileDescriptor_2c9d981df0c32c1d = []byte{
	// 455 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x94, 0x4f, 0x6f, 0xd3, 0x30,
	0x18, 0xc6, 0xe3, 0x49, 0x9b, 0xa8, 0x83, 0xb4, 0x61, 0x01, 0x2b, 0x11, 0xf2, 0x46, 0x41, 0xb0,
	0x0b, 0x89, 0x18, 0x17, 0x84, 0xc4, 0x81, 0x6a, 0x1a, 0xe4, 0x00, 0x43, 0x41, 0xbb, 0x20, 0xa4,
	0xc9, 0x49, 0x8c, 0x15, 0xd4, 0xc6, 0x9e, 0x9d, 0x4c, 0xe5, 0xc6, 0x47, 0xe0, 0x63, 0xf0, 0x51,
	0x38, 0xf6, 0xd8, 0x13, 0xa2, 0xee, 0x85, 0x1b, 0xfd, 0x08, 0xa8, 0xb1, 0xa3, 0xfe, 0x87, 0x53,
	0x4f, 0x89, 0x5f, 0x3f, 0x7e, 0x7e, 0x6f, 0xde, 0xbc, 0xaf, 0xe1, 0x33, 0x25, 0x93, 0x20, 0xe9,
	0xf0, 0x32, 0x0d, 0x84, 0xe4, 0x9f, 0x69, 0x52, 0x5c, 0x74, 0x49, 0x4e, 0x18, 0x95, 0xf5, 0xda,
	0x2e, 0x45, 0x1c, 0x28, 0x2a, 0xaf, 0xb2, 0x84, 0xfa, 0x42, 0xf2, 0x82, 0x23, 0x57, 0xf4, 0x7c,
	0x1b, 0x51, 0xde, 0x4d, 0xc6, 0x19, 0xaf, 0xe2, 0xc1, 0xe4, 0xcd, 0x48, 0xbc, 0x83, 0x89, 0x39,
	0x11, 0x59, 0x60, 0x76, 0xca, 0x32, 0x4b, 0x45, 0x5c, 0x3d, 0x8c, 0xa0, 0x95, 0x40, 0xf7, 0x9d,
	0xa1, 0x84, 0xf9, 0x27, 0x8e, 0xee, 0xc1, 0xeb, 0x75, 0x12, 0x39, 0xe9, 0xd2, 0x26, 0x38, 0x04,
	0x47, 0x8d, 0xc8, 0xb5, 0xb1, 0xb7, 0xa4, 0x4b, 0xd1, 0x13, 0xb8, 0xc3, 0x25, 0xbb, 0xc8, 0xd2,
	0xe6, 0xd6, 0x21, 0x38, 0x72, 0x8f, 0x77, 0x7d, 0xd1, 0xf3, 0x8d, 0xb1, 0x7f, 0x7e, 0x1e, 0x9e,
	0xb4, 0x1b, 0xfa, 0xe7, 0xc1, 0xf6, 0x99, 0x64, 0xe1, 0x49, 0xb4, 0xcd, 0x25, 0x0b, 0xd3, 0x16,
	0x87, 0xfb, 0xaf, 0x68, 0x61, 0x39, 0xed, 0x2f, 0x13, 0x9b, 0x88, 0x5e, 0x96, 0x54, 0x15, 0x1b,
	0x02, 0x5e, 0xc2, 0x3b, 0xa1, 0xb2, 0xbc, 0x97, 0x57, 0x24, 0xeb, 0x90, 0xb8, 0xb3, 0x61, 0xe4,
	0x73, 0xe8, 0xad, 0x42, 0x2a, 0xc1, 0x73, 0x45, 0xd1, 0x5d, 0xd8, 0x20, 0x75, 0xb0, 0x02, 0x5e,
	0x8b, 0xa6, 0x81, 0x56, 0x0e, 0x6f, 0x47, 0x94, 0x65, 0xaa, 0xa0, 0xd2, 0x3a, 0x6c, 0x36, 0xd7,
	0xd7, 0x70, 0x7f, 0x89, 0x67, 0x13, 0x7d, 0x0c, 0x51, 0x0d, 0x94, 0x56, 0x42, 0x53, 0x9b, 0xf1,
	0x0d, 0x51, 0x8b, 0xeb, 0x8d, 0xe3, 0x3f, 0x5b, 0xf0, 0x96, 0xb5, 0x78, 0x63, 0xba, 0xf4, 0xbd,
	0x69, 0x48, 0x44, 0x21, 0x5a, 0xae, 0x07, 0x7a, 0xe8, 0xcf, 0xf4, 0xac, 0xbf, 0xf6, 0x1f, 0x79,
	0x8f, 0xfe, 0xab, 0xb3, 0xf9, 0x7e, 0x84, 0xbb, 0x0b, 0x9f, 0x82, 0xee, 0xcf, 0x9d, 0x5d, 0x5d,
	0x58, 0xef, 0xc1, 0xbf, 0x45, 0xd6, 0xfd, 0x05, 0xdc, 0x9b, 0x36, 0xee, 0x29, 0x97, 0x67, 0x92,
	0xa1, 0xc5, 0xfa, 0x7a, 0xcd, 0x39, 0xab, 0xd9, 0x69, 0x8a, 0x66, 0x8f, 0x9b, 0xbe, 0x47, 0xf3,
	0xe0, 0x35, 0x63, 0xb1, 0xde, 0xb3, 0x7d, 0xda, 0x1f, 0x62, 0x67, 0x30, 0xc4, 0xce, 0x78, 0x88,
	0xc1, 0x57, 0x8d, 0xc1, 0x77, 0x8d, 0xc1, 0x0f, 0x8d, 0x41, 0x5f, 0x63, 0xf0, 0x4b, 0x63, 0xf0,
	0x5b, 0x63, 0x67, 0xac, 0x31, 0xf8, 0x36, 0xc2, 0x4e, 0x7f, 0x84, 0x9d, 0xc1, 0x08, 0x3b, 0x1f,
	0xf6, 0x16, 0xaf, 0x92, 0x78, 0xa7, 0x9a, 0xff, 0xa7, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x34,
	0x2a, 0x3d, 0xe0, 0x7f, 0x04, 0x00, 0x00,
}

func (this *ProjectInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ProjectInfo)
	if !ok {
		that2, ok := that.(ProjectInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ProjectName != that1.ProjectName {
		return false
	}
	if !this.OrgID.Equal(that1.OrgID) {
		return false
	}
	return true
}
func (this *GetProjectByNameRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetProjectByNameRequest)
	if !ok {
		that2, ok := that.(GetProjectByNameRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ProjectName != that1.ProjectName {
		return false
	}
	if !this.OrgID.Equal(that1.OrgID) {
		return false
	}
	return true
}
func (this *IsProjectAvailableRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IsProjectAvailableRequest)
	if !ok {
		that2, ok := that.(IsProjectAvailableRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ProjectName != that1.ProjectName {
		return false
	}
	if !this.OrgID.Equal(that1.OrgID) {
		return false
	}
	return true
}
func (this *IsProjectAvailableResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IsProjectAvailableResponse)
	if !ok {
		that2, ok := that.(IsProjectAvailableResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Available != that1.Available {
		return false
	}
	return true
}
func (this *RegisterProjectRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RegisterProjectRequest)
	if !ok {
		that2, ok := that.(RegisterProjectRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ProjectName != that1.ProjectName {
		return false
	}
	if !this.OrgID.Equal(that1.OrgID) {
		return false
	}
	return true
}
func (this *RegisterProjectResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RegisterProjectResponse)
	if !ok {
		that2, ok := that.(RegisterProjectResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ProjectRegistered != that1.ProjectRegistered {
		return false
	}
	return true
}
func (this *ProjectInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&projectmanagerpb.ProjectInfo{")
	s = append(s, "ProjectName: "+fmt.Sprintf("%#v", this.ProjectName)+",\n")
	if this.OrgID != nil {
		s = append(s, "OrgID: "+fmt.Sprintf("%#v", this.OrgID)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetProjectByNameRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&projectmanagerpb.GetProjectByNameRequest{")
	s = append(s, "ProjectName: "+fmt.Sprintf("%#v", this.ProjectName)+",\n")
	if this.OrgID != nil {
		s = append(s, "OrgID: "+fmt.Sprintf("%#v", this.OrgID)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IsProjectAvailableRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&projectmanagerpb.IsProjectAvailableRequest{")
	s = append(s, "ProjectName: "+fmt.Sprintf("%#v", this.ProjectName)+",\n")
	if this.OrgID != nil {
		s = append(s, "OrgID: "+fmt.Sprintf("%#v", this.OrgID)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IsProjectAvailableResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&projectmanagerpb.IsProjectAvailableResponse{")
	s = append(s, "Available: "+fmt.Sprintf("%#v", this.Available)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RegisterProjectRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&projectmanagerpb.RegisterProjectRequest{")
	s = append(s, "ProjectName: "+fmt.Sprintf("%#v", this.ProjectName)+",\n")
	if this.OrgID != nil {
		s = append(s, "OrgID: "+fmt.Sprintf("%#v", this.OrgID)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RegisterProjectResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&projectmanagerpb.RegisterProjectResponse{")
	s = append(s, "ProjectRegistered: "+fmt.Sprintf("%#v", this.ProjectRegistered)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringService(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ProjectManagerServiceClient is the client API for ProjectManagerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProjectManagerServiceClient interface {
	IsProjectAvailable(ctx context.Context, in *IsProjectAvailableRequest, opts ...grpc.CallOption) (*IsProjectAvailableResponse, error)
	RegisterProject(ctx context.Context, in *RegisterProjectRequest, opts ...grpc.CallOption) (*RegisterProjectResponse, error)
	GetProjectForOrg(ctx context.Context, in *uuidpb.UUID, opts ...grpc.CallOption) (*ProjectInfo, error)
	GetProjectByName(ctx context.Context, in *GetProjectByNameRequest, opts ...grpc.CallOption) (*ProjectInfo, error)
}

type projectManagerServiceClient struct {
	cc *grpc.ClientConn
}

func NewProjectManagerServiceClient(cc *grpc.ClientConn) ProjectManagerServiceClient {
	return &projectManagerServiceClient{cc}
}

func (c *projectManagerServiceClient) IsProjectAvailable(ctx context.Context, in *IsProjectAvailableRequest, opts ...grpc.CallOption) (*IsProjectAvailableResponse, error) {
	out := new(IsProjectAvailableResponse)
	err := c.cc.Invoke(ctx, "/px.services.ProjectManagerService/IsProjectAvailable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectManagerServiceClient) RegisterProject(ctx context.Context, in *RegisterProjectRequest, opts ...grpc.CallOption) (*RegisterProjectResponse, error) {
	out := new(RegisterProjectResponse)
	err := c.cc.Invoke(ctx, "/px.services.ProjectManagerService/RegisterProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectManagerServiceClient) GetProjectForOrg(ctx context.Context, in *uuidpb.UUID, opts ...grpc.CallOption) (*ProjectInfo, error) {
	out := new(ProjectInfo)
	err := c.cc.Invoke(ctx, "/px.services.ProjectManagerService/GetProjectForOrg", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectManagerServiceClient) GetProjectByName(ctx context.Context, in *GetProjectByNameRequest, opts ...grpc.CallOption) (*ProjectInfo, error) {
	out := new(ProjectInfo)
	err := c.cc.Invoke(ctx, "/px.services.ProjectManagerService/GetProjectByName", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProjectManagerServiceServer is the server API for ProjectManagerService service.
type ProjectManagerServiceServer interface {
	IsProjectAvailable(context.Context, *IsProjectAvailableRequest) (*IsProjectAvailableResponse, error)
	RegisterProject(context.Context, *RegisterProjectRequest) (*RegisterProjectResponse, error)
	GetProjectForOrg(context.Context, *uuidpb.UUID) (*ProjectInfo, error)
	GetProjectByName(context.Context, *GetProjectByNameRequest) (*ProjectInfo, error)
}

// UnimplementedProjectManagerServiceServer can be embedded to have forward compatible implementations.
type UnimplementedProjectManagerServiceServer struct {
}

func (*UnimplementedProjectManagerServiceServer) IsProjectAvailable(ctx context.Context, req *IsProjectAvailableRequest) (*IsProjectAvailableResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsProjectAvailable not implemented")
}
func (*UnimplementedProjectManagerServiceServer) RegisterProject(ctx context.Context, req *RegisterProjectRequest) (*RegisterProjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterProject not implemented")
}
func (*UnimplementedProjectManagerServiceServer) GetProjectForOrg(ctx context.Context, req *uuidpb.UUID) (*ProjectInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProjectForOrg not implemented")
}
func (*UnimplementedProjectManagerServiceServer) GetProjectByName(ctx context.Context, req *GetProjectByNameRequest) (*ProjectInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProjectByName not implemented")
}

func RegisterProjectManagerServiceServer(s *grpc.Server, srv ProjectManagerServiceServer) {
	s.RegisterService(&_ProjectManagerService_serviceDesc, srv)
}

func _ProjectManagerService_IsProjectAvailable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsProjectAvailableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectManagerServiceServer).IsProjectAvailable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/px.services.ProjectManagerService/IsProjectAvailable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectManagerServiceServer).IsProjectAvailable(ctx, req.(*IsProjectAvailableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectManagerService_RegisterProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectManagerServiceServer).RegisterProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/px.services.ProjectManagerService/RegisterProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectManagerServiceServer).RegisterProject(ctx, req.(*RegisterProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectManagerService_GetProjectForOrg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(uuidpb.UUID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectManagerServiceServer).GetProjectForOrg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/px.services.ProjectManagerService/GetProjectForOrg",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectManagerServiceServer).GetProjectForOrg(ctx, req.(*uuidpb.UUID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectManagerService_GetProjectByName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectByNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectManagerServiceServer).GetProjectByName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/px.services.ProjectManagerService/GetProjectByName",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectManagerServiceServer).GetProjectByName(ctx, req.(*GetProjectByNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProjectManagerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "px.services.ProjectManagerService",
	HandlerType: (*ProjectManagerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "IsProjectAvailable",
			Handler:    _ProjectManagerService_IsProjectAvailable_Handler,
		},
		{
			MethodName: "RegisterProject",
			Handler:    _ProjectManagerService_RegisterProject_Handler,
		},
		{
			MethodName: "GetProjectForOrg",
			Handler:    _ProjectManagerService_GetProjectForOrg_Handler,
		},
		{
			MethodName: "GetProjectByName",
			Handler:    _ProjectManagerService_GetProjectByName_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "src/cloud/project_manager/projectmanagerpb/service.proto",
}

func (m *ProjectInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProjectInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProjectInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.OrgID != nil {
		{
			size, err := m.OrgID.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectName) > 0 {
		i -= len(m.ProjectName)
		copy(dAtA[i:], m.ProjectName)
		i = encodeVarintService(dAtA, i, uint64(len(m.ProjectName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetProjectByNameRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetProjectByNameRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetProjectByNameRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.OrgID != nil {
		{
			size, err := m.OrgID.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectName) > 0 {
		i -= len(m.ProjectName)
		copy(dAtA[i:], m.ProjectName)
		i = encodeVarintService(dAtA, i, uint64(len(m.ProjectName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IsProjectAvailableRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsProjectAvailableRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IsProjectAvailableRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.OrgID != nil {
		{
			size, err := m.OrgID.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectName) > 0 {
		i -= len(m.ProjectName)
		copy(dAtA[i:], m.ProjectName)
		i = encodeVarintService(dAtA, i, uint64(len(m.ProjectName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IsProjectAvailableResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsProjectAvailableResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IsProjectAvailableResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Available {
		i--
		if m.Available {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RegisterProjectRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegisterProjectRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegisterProjectRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.OrgID != nil {
		{
			size, err := m.OrgID.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectName) > 0 {
		i -= len(m.ProjectName)
		copy(dAtA[i:], m.ProjectName)
		i = encodeVarintService(dAtA, i, uint64(len(m.ProjectName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RegisterProjectResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegisterProjectResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegisterProjectResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ProjectRegistered {
		i--
		if m.ProjectRegistered {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintService(dAtA []byte, offset int, v uint64) int {
	offset -= sovService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ProjectInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectName)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.OrgID != nil {
		l = m.OrgID.Size()
		n += 1 + l + sovService(uint64(l))
	}
	return n
}

func (m *GetProjectByNameRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectName)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.OrgID != nil {
		l = m.OrgID.Size()
		n += 1 + l + sovService(uint64(l))
	}
	return n
}

func (m *IsProjectAvailableRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectName)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.OrgID != nil {
		l = m.OrgID.Size()
		n += 1 + l + sovService(uint64(l))
	}
	return n
}

func (m *IsProjectAvailableResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Available {
		n += 2
	}
	return n
}

func (m *RegisterProjectRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectName)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.OrgID != nil {
		l = m.OrgID.Size()
		n += 1 + l + sovService(uint64(l))
	}
	return n
}

func (m *RegisterProjectResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProjectRegistered {
		n += 2
	}
	return n
}

func sovService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozService(x uint64) (n int) {
	return sovService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ProjectInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProjectInfo{`,
		`ProjectName:` + fmt.Sprintf("%v", this.ProjectName) + `,`,
		`OrgID:` + strings.Replace(fmt.Sprintf("%v", this.OrgID), "UUID", "uuidpb.UUID", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetProjectByNameRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetProjectByNameRequest{`,
		`ProjectName:` + fmt.Sprintf("%v", this.ProjectName) + `,`,
		`OrgID:` + strings.Replace(fmt.Sprintf("%v", this.OrgID), "UUID", "uuidpb.UUID", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IsProjectAvailableRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IsProjectAvailableRequest{`,
		`ProjectName:` + fmt.Sprintf("%v", this.ProjectName) + `,`,
		`OrgID:` + strings.Replace(fmt.Sprintf("%v", this.OrgID), "UUID", "uuidpb.UUID", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IsProjectAvailableResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IsProjectAvailableResponse{`,
		`Available:` + fmt.Sprintf("%v", this.Available) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RegisterProjectRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RegisterProjectRequest{`,
		`ProjectName:` + fmt.Sprintf("%v", this.ProjectName) + `,`,
		`OrgID:` + strings.Replace(fmt.Sprintf("%v", this.OrgID), "UUID", "uuidpb.UUID", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RegisterProjectResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RegisterProjectResponse{`,
		`ProjectRegistered:` + fmt.Sprintf("%v", this.ProjectRegistered) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ProjectInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProjectInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProjectInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrgID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OrgID == nil {
				m.OrgID = &uuidpb.UUID{}
			}
			if err := m.OrgID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetProjectByNameRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetProjectByNameRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetProjectByNameRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrgID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OrgID == nil {
				m.OrgID = &uuidpb.UUID{}
			}
			if err := m.OrgID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsProjectAvailableRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsProjectAvailableRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsProjectAvailableRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrgID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OrgID == nil {
				m.OrgID = &uuidpb.UUID{}
			}
			if err := m.OrgID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsProjectAvailableResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsProjectAvailableResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsProjectAvailableResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Available = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegisterProjectRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegisterProjectRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegisterProjectRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrgID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OrgID == nil {
				m.OrgID = &uuidpb.UUID{}
			}
			if err := m.OrgID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegisterProjectResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegisterProjectResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegisterProjectResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectRegistered", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProjectRegistered = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupService = fmt.Errorf("proto: unexpected end of group")
)
