// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: src/carnot/queryresultspb/query_results.proto

package queryresultspb

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	math_bits "math/bits"
	uuidpb "px.dev/pixie/src/api/proto/uuidpb"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type QueryTimingInfo struct {
	ExecutionTimeNs   int64 `protobuf:"varint,1,opt,name=execution_time_ns,json=executionTimeNs,proto3" json:"execution_time_ns,omitempty"`
	CompilationTimeNs int64 `protobuf:"varint,2,opt,name=compilation_time_ns,json=compilationTimeNs,proto3" json:"compilation_time_ns,omitempty"`
}

func (m *QueryTimingInfo) Reset()      { *m = QueryTimingInfo{} }
func (*QueryTimingInfo) ProtoMessage() {}
func (*QueryTimingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ab3e12aa52e3568, []int{0}
}
func (m *QueryTimingInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryTimingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryTimingInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryTimingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTimingInfo.Merge(m, src)
}
func (m *QueryTimingInfo) XXX_Size() int {
	return m.Size()
}
func (m *QueryTimingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTimingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTimingInfo proto.InternalMessageInfo

func (m *QueryTimingInfo) GetExecutionTimeNs() int64 {
	if m != nil {
		return m.ExecutionTimeNs
	}
	return 0
}

func (m *QueryTimingInfo) GetCompilationTimeNs() int64 {
	if m != nil {
		return m.CompilationTimeNs
	}
	return 0
}

type QueryExecutionStats struct {
	Timing           *QueryTimingInfo `protobuf:"bytes,1,opt,name=timing,proto3" json:"timing,omitempty"`
	BytesProcessed   int64            `protobuf:"varint,2,opt,name=bytes_processed,json=bytesProcessed,proto3" json:"bytes_processed,omitempty"`
	RecordsProcessed int64            `protobuf:"varint,3,opt,name=records_processed,json=recordsProcessed,proto3" json:"records_processed,omitempty"`
}

func (m *QueryExecutionStats) Reset()      { *m = QueryExecutionStats{} }
func (*QueryExecutionStats) ProtoMessage() {}
func (*QueryExecutionStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ab3e12aa52e3568, []int{1}
}
func (m *QueryExecutionStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryExecutionStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryExecutionStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryExecutionStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryExecutionStats.Merge(m, src)
}
func (m *QueryExecutionStats) XXX_Size() int {
	return m.Size()
}
func (m *QueryExecutionStats) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryExecutionStats.DiscardUnknown(m)
}

var xxx_messageInfo_QueryExecutionStats proto.InternalMessageInfo

func (m *QueryExecutionStats) GetTiming() *QueryTimingInfo {
	if m != nil {
		return m.Timing
	}
	return nil
}

func (m *QueryExecutionStats) GetBytesProcessed() int64 {
	if m != nil {
		return m.BytesProcessed
	}
	return 0
}

func (m *QueryExecutionStats) GetRecordsProcessed() int64 {
	if m != nil {
		return m.RecordsProcessed
	}
	return 0
}

type OperatorExecutionStats struct {
	PlanFragmentId       int64              `protobuf:"varint,1,opt,name=plan_fragment_id,json=planFragmentId,proto3" json:"plan_fragment_id,omitempty"`
	NodeId               int64              `protobuf:"varint,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	BytesOutput          int64              `protobuf:"varint,3,opt,name=bytes_output,json=bytesOutput,proto3" json:"bytes_output,omitempty"`
	RecordsOutput        int64              `protobuf:"varint,4,opt,name=records_output,json=recordsOutput,proto3" json:"records_output,omitempty"`
	TotalExecutionTimeNs int64              `protobuf:"varint,5,opt,name=total_execution_time_ns,json=totalExecutionTimeNs,proto3" json:"total_execution_time_ns,omitempty"`
	SelfExecutionTimeNs  int64              `protobuf:"varint,6,opt,name=self_execution_time_ns,json=selfExecutionTimeNs,proto3" json:"self_execution_time_ns,omitempty"`
	OperatorStats        *types.Any         `protobuf:"bytes,7,opt,name=operator_stats,json=operatorStats,proto3" json:"operator_stats,omitempty"`
	ExtraMetrics         map[string]float64 `protobuf:"bytes,8,rep,name=extra_metrics,json=extraMetrics,proto3" json:"extra_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	ExtraInfo            map[string]string  `protobuf:"bytes,9,rep,name=extra_info,json=extraInfo,proto3" json:"extra_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *OperatorExecutionStats) Reset()      { *m = OperatorExecutionStats{} }
func (*OperatorExecutionStats) ProtoMessage() {}
func (*OperatorExecutionStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ab3e12aa52e3568, []int{2}
}
func (m *OperatorExecutionStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OperatorExecutionStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OperatorExecutionStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OperatorExecutionStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperatorExecutionStats.Merge(m, src)
}
func (m *OperatorExecutionStats) XXX_Size() int {
	return m.Size()
}
func (m *OperatorExecutionStats) XXX_DiscardUnknown() {
	xxx_messageInfo_OperatorExecutionStats.DiscardUnknown(m)
}

var xxx_messageInfo_OperatorExecutionStats proto.InternalMessageInfo

func (m *OperatorExecutionStats) GetPlanFragmentId() int64 {
	if m != nil {
		return m.PlanFragmentId
	}
	return 0
}

func (m *OperatorExecutionStats) GetNodeId() int64 {
	if m != nil {
		return m.NodeId
	}
	return 0
}

func (m *OperatorExecutionStats) GetBytesOutput() int64 {
	if m != nil {
		return m.BytesOutput
	}
	return 0
}

func (m *OperatorExecutionStats) GetRecordsOutput() int64 {
	if m != nil {
		return m.RecordsOutput
	}
	return 0
}

func (m *OperatorExecutionStats) GetTotalExecutionTimeNs() int64 {
	if m != nil {
		return m.TotalExecutionTimeNs
	}
	return 0
}

func (m *OperatorExecutionStats) GetSelfExecutionTimeNs() int64 {
	if m != nil {
		return m.SelfExecutionTimeNs
	}
	return 0
}

func (m *OperatorExecutionStats) GetOperatorStats() *types.Any {
	if m != nil {
		return m.OperatorStats
	}
	return nil
}

func (m *OperatorExecutionStats) GetExtraMetrics() map[string]float64 {
	if m != nil {
		return m.ExtraMetrics
	}
	return nil
}

func (m *OperatorExecutionStats) GetExtraInfo() map[string]string {
	if m != nil {
		return m.ExtraInfo
	}
	return nil
}

type AgentExecutionStats struct {
	AgentID                *uuidpb.UUID              `protobuf:"bytes,1,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	OperatorExecutionStats []*OperatorExecutionStats `protobuf:"bytes,2,rep,name=operator_execution_stats,json=operatorExecutionStats,proto3" json:"operator_execution_stats,omitempty"`
	ExecutionTimeNs        int64                     `protobuf:"varint,3,opt,name=execution_time_ns,json=executionTimeNs,proto3" json:"execution_time_ns,omitempty"`
	BytesProcessed         int64                     `protobuf:"varint,4,opt,name=bytes_processed,json=bytesProcessed,proto3" json:"bytes_processed,omitempty"`
	RecordsProcessed       int64                     `protobuf:"varint,5,opt,name=records_processed,json=recordsProcessed,proto3" json:"records_processed,omitempty"`
}

func (m *AgentExecutionStats) Reset()      { *m = AgentExecutionStats{} }
func (*AgentExecutionStats) ProtoMessage() {}
func (*AgentExecutionStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ab3e12aa52e3568, []int{3}
}
func (m *AgentExecutionStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AgentExecutionStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AgentExecutionStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AgentExecutionStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgentExecutionStats.Merge(m, src)
}
func (m *AgentExecutionStats) XXX_Size() int {
	return m.Size()
}
func (m *AgentExecutionStats) XXX_DiscardUnknown() {
	xxx_messageInfo_AgentExecutionStats.DiscardUnknown(m)
}

var xxx_messageInfo_AgentExecutionStats proto.InternalMessageInfo

func (m *AgentExecutionStats) GetAgentID() *uuidpb.UUID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *AgentExecutionStats) GetOperatorExecutionStats() []*OperatorExecutionStats {
	if m != nil {
		return m.OperatorExecutionStats
	}
	return nil
}

func (m *AgentExecutionStats) GetExecutionTimeNs() int64 {
	if m != nil {
		return m.ExecutionTimeNs
	}
	return 0
}

func (m *AgentExecutionStats) GetBytesProcessed() int64 {
	if m != nil {
		return m.BytesProcessed
	}
	return 0
}

func (m *AgentExecutionStats) GetRecordsProcessed() int64 {
	if m != nil {
		return m.RecordsProcessed
	}
	return 0
}

func init() {
	proto.RegisterType((*QueryTimingInfo)(nil), "px.carnot.queryresultspb.QueryTimingInfo")
	proto.RegisterType((*QueryExecutionStats)(nil), "px.carnot.queryresultspb.QueryExecutionStats")
	proto.RegisterType((*OperatorExecutionStats)(nil), "px.carnot.queryresultspb.OperatorExecutionStats")
	proto.RegisterMapType((map[string]string)(nil), "px.carnot.queryresultspb.OperatorExecutionStats.ExtraInfoEntry")
	proto.RegisterMapType((map[string]float64)(nil), "px.carnot.queryresultspb.OperatorExecutionStats.ExtraMetricsEntry")
	proto.RegisterType((*AgentExecutionStats)(nil), "px.carnot.queryresultspb.AgentExecutionStats")
}

func init() {
	proto.RegisterFile("src/carnot/queryresultspb/query_results.proto", fileDescriptor_9ab3e12aa52e3568)
}

var fileDescriptor_9ab3e12aa52e3568 = []byte{
	// 695 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0xcd, 0x6e, 0xd3, 0x4a,
	0x14, 0xc7, 0xe3, 0xa4, 0x49, 0x9a, 0x93, 0x36, 0x69, 0x9c, 0xa8, 0xcd, 0xcd, 0x62, 0xda, 0x1b,
	0xe9, 0xea, 0xf6, 0x5e, 0x84, 0x83, 0x5a, 0x21, 0x10, 0x20, 0x55, 0xad, 0x1a, 0xa4, 0x2c, 0xa0,
	0x60, 0xda, 0x0d, 0x0b, 0x2c, 0xc7, 0x9e, 0x58, 0x06, 0x7b, 0xc6, 0x8c, 0xc7, 0xa8, 0xd9, 0xf1,
	0x08, 0xac, 0x78, 0x06, 0x56, 0x3c, 0x01, 0x0f, 0xc0, 0xb2, 0xcb, 0xae, 0x10, 0x75, 0x37, 0x2c,
	0xfb, 0x08, 0xc8, 0x33, 0x4e, 0x49, 0x52, 0x57, 0x7c, 0xac, 0xec, 0x73, 0xce, 0xef, 0xcc, 0xf9,
	0xfb, 0x9c, 0x33, 0x86, 0x9b, 0x21, 0xb3, 0x7a, 0x96, 0xc9, 0x08, 0xe5, 0xbd, 0xd7, 0x11, 0x66,
	0x63, 0x86, 0xc3, 0xc8, 0xe3, 0x61, 0x30, 0x94, 0xa6, 0x91, 0xda, 0x5a, 0xc0, 0x28, 0xa7, 0x6a,
	0x3b, 0x38, 0xd6, 0x24, 0xad, 0xcd, 0xd2, 0x9d, 0x96, 0x43, 0x1d, 0x2a, 0xa0, 0x5e, 0xf2, 0x26,
	0xf9, 0xce, 0x5f, 0x0e, 0xa5, 0x8e, 0x87, 0x7b, 0xc2, 0x1a, 0x46, 0xa3, 0x9e, 0x49, 0xc6, 0x69,
	0x68, 0x3d, 0xa9, 0x6c, 0x06, 0xae, 0x8c, 0xf5, 0xa2, 0xc8, 0xb5, 0x83, 0xa1, 0x78, 0x48, 0xa0,
	0xeb, 0x43, 0xfd, 0x69, 0x52, 0xe3, 0xd0, 0xf5, 0x5d, 0xe2, 0x0c, 0xc8, 0x88, 0xaa, 0xff, 0x43,
	0x03, 0x1f, 0x63, 0x2b, 0xe2, 0x2e, 0x25, 0x06, 0x77, 0x7d, 0x6c, 0x90, 0xb0, 0xad, 0x6c, 0x28,
	0x9b, 0x05, 0xbd, 0x7e, 0x19, 0x38, 0x74, 0x7d, 0xfc, 0x38, 0x54, 0x35, 0x68, 0x5a, 0xd4, 0x0f,
	0x5c, 0xcf, 0x9c, 0xa1, 0xf3, 0x82, 0x6e, 0x4c, 0x85, 0x24, 0xdf, 0xfd, 0xa8, 0x40, 0x53, 0xd4,
	0xeb, 0x4f, 0x0e, 0x7a, 0xc6, 0x4d, 0x1e, 0xaa, 0xbb, 0x50, 0xe2, 0x42, 0x81, 0x28, 0x54, 0xdd,
	0xfa, 0x4f, 0xbb, 0xae, 0x07, 0xda, 0x9c, 0x5c, 0x3d, 0x4d, 0x54, 0xff, 0x85, 0xfa, 0x70, 0xcc,
	0x71, 0x68, 0x04, 0x8c, 0x5a, 0x38, 0x0c, 0xb1, 0x9d, 0xca, 0xa8, 0x09, 0xf7, 0x93, 0x89, 0x57,
	0xbd, 0x01, 0x0d, 0x86, 0x2d, 0xca, 0xec, 0x69, 0xb4, 0x20, 0xd0, 0x95, 0x34, 0x70, 0x09, 0x77,
	0xdf, 0x17, 0x61, 0xf5, 0x20, 0xc0, 0xcc, 0xe4, 0x94, 0xcd, 0x69, 0xde, 0x84, 0x95, 0xc0, 0x33,
	0x89, 0x31, 0x62, 0xa6, 0xe3, 0x63, 0xc2, 0x0d, 0xd7, 0x4e, 0xdb, 0x54, 0x4b, 0xfc, 0x0f, 0x53,
	0xf7, 0xc0, 0x56, 0xd7, 0xa0, 0x4c, 0xa8, 0x8d, 0x13, 0x40, 0x4a, 0x2a, 0x25, 0xe6, 0xc0, 0x56,
	0xff, 0x86, 0x25, 0xa9, 0x99, 0x46, 0x3c, 0x88, 0x78, 0xaa, 0xa2, 0x2a, 0x7c, 0x07, 0xc2, 0xa5,
	0xfe, 0x03, 0xb5, 0x89, 0xda, 0x14, 0x5a, 0x10, 0xd0, 0x72, 0xea, 0x4d, 0xb1, 0xdb, 0xb0, 0xc6,
	0x29, 0x37, 0x3d, 0xe3, 0xea, 0xe8, 0x8a, 0x82, 0x6f, 0x89, 0x70, 0x7f, 0x6e, 0x7e, 0xdb, 0xb0,
	0x1a, 0x62, 0x6f, 0x94, 0x91, 0x55, 0x12, 0x59, 0xcd, 0x24, 0x3a, 0x9f, 0x74, 0x1f, 0x6a, 0x34,
	0x6d, 0x89, 0x11, 0x26, 0xad, 0x68, 0x97, 0xc5, 0xd0, 0x5a, 0x9a, 0x5c, 0x44, 0x6d, 0xb2, 0x88,
	0xda, 0x2e, 0x19, 0xeb, 0xcb, 0x13, 0x56, 0x76, 0xcd, 0x81, 0x65, 0x7c, 0xcc, 0x99, 0x69, 0xf8,
	0x98, 0x33, 0xd7, 0x0a, 0xdb, 0x8b, 0x1b, 0x85, 0xcd, 0xea, 0xd6, 0xde, 0xf5, 0x03, 0xcf, 0x6e,
	0xbf, 0xd6, 0x4f, 0x4e, 0x79, 0x24, 0x0f, 0xe9, 0x13, 0xce, 0xc6, 0xfa, 0x12, 0x9e, 0x72, 0xa9,
	0x2f, 0x00, 0x64, 0x21, 0x97, 0x8c, 0x68, 0xbb, 0x22, 0xaa, 0xec, 0xfc, 0x59, 0x95, 0x64, 0xcf,
	0x64, 0x89, 0x0a, 0x9e, 0xd8, 0x9d, 0x1d, 0x68, 0x5c, 0x91, 0xa0, 0xae, 0x40, 0xe1, 0x15, 0x1e,
	0x8b, 0x35, 0xa8, 0xe8, 0xc9, 0xab, 0xda, 0x82, 0xe2, 0x1b, 0xd3, 0x8b, 0xb0, 0x98, 0xbc, 0xa2,
	0x4b, 0xe3, 0x5e, 0xfe, 0xae, 0xd2, 0x79, 0x00, 0xb5, 0xd9, 0xd3, 0x7f, 0x96, 0x5d, 0x99, 0xca,
	0xee, 0x7e, 0xca, 0x43, 0x73, 0xd7, 0xc1, 0x84, 0xcf, 0x6d, 0xe5, 0x1d, 0x58, 0x34, 0x9d, 0xa9,
	0x6d, 0xac, 0x6e, 0xd5, 0x93, 0x8f, 0x96, 0x37, 0x5f, 0x3b, 0x3a, 0x1a, 0xec, 0xef, 0x55, 0xe3,
	0x2f, 0xeb, 0x65, 0x91, 0x3b, 0xd8, 0xd7, 0xcb, 0x82, 0x1e, 0xd8, 0xea, 0x4b, 0x68, 0x5f, 0x4e,
	0xf5, 0xc7, 0x3a, 0xc8, 0xf9, 0xe6, 0x45, 0xf7, 0x6e, 0xfd, 0x6e, 0xf7, 0xf4, 0x55, 0x9a, 0x7d,
	0x75, 0x32, 0x7f, 0x31, 0x85, 0xec, 0x5f, 0x4c, 0xc6, 0xbd, 0x5e, 0xf8, 0xf5, 0x7b, 0x5d, 0xcc,
	0xbe, 0xd7, 0x7b, 0xfb, 0x27, 0x67, 0x28, 0x77, 0x7a, 0x86, 0x72, 0x17, 0x67, 0x48, 0x79, 0x1b,
	0x23, 0xe5, 0x43, 0x8c, 0x94, 0xcf, 0x31, 0x52, 0x4e, 0x62, 0xa4, 0x7c, 0x8d, 0x91, 0xf2, 0x2d,
	0x46, 0xb9, 0x8b, 0x18, 0x29, 0xef, 0xce, 0x51, 0xee, 0xe4, 0x1c, 0xe5, 0x4e, 0xcf, 0x51, 0xee,
	0x79, 0x6d, 0xf6, 0xb3, 0x87, 0x25, 0xb1, 0xe9, 0xdb, 0xdf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x99,
	0x72, 0x0a, 0x50, 0xe1, 0x05, 0x00, 0x00,
}

func (this *QueryTimingInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryTimingInfo)
	if !ok {
		that2, ok := that.(QueryTimingInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ExecutionTimeNs != that1.ExecutionTimeNs {
		return false
	}
	if this.CompilationTimeNs != that1.CompilationTimeNs {
		return false
	}
	return true
}
func (this *QueryExecutionStats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryExecutionStats)
	if !ok {
		that2, ok := that.(QueryExecutionStats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Timing.Equal(that1.Timing) {
		return false
	}
	if this.BytesProcessed != that1.BytesProcessed {
		return false
	}
	if this.RecordsProcessed != that1.RecordsProcessed {
		return false
	}
	return true
}
func (this *OperatorExecutionStats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OperatorExecutionStats)
	if !ok {
		that2, ok := that.(OperatorExecutionStats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PlanFragmentId != that1.PlanFragmentId {
		return false
	}
	if this.NodeId != that1.NodeId {
		return false
	}
	if this.BytesOutput != that1.BytesOutput {
		return false
	}
	if this.RecordsOutput != that1.RecordsOutput {
		return false
	}
	if this.TotalExecutionTimeNs != that1.TotalExecutionTimeNs {
		return false
	}
	if this.SelfExecutionTimeNs != that1.SelfExecutionTimeNs {
		return false
	}
	if !this.OperatorStats.Equal(that1.OperatorStats) {
		return false
	}
	if len(this.ExtraMetrics) != len(that1.ExtraMetrics) {
		return false
	}
	for i := range this.ExtraMetrics {
		if this.ExtraMetrics[i] != that1.ExtraMetrics[i] {
			return false
		}
	}
	if len(this.ExtraInfo) != len(that1.ExtraInfo) {
		return false
	}
	for i := range this.ExtraInfo {
		if this.ExtraInfo[i] != that1.ExtraInfo[i] {
			return false
		}
	}
	return true
}
func (this *AgentExecutionStats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AgentExecutionStats)
	if !ok {
		that2, ok := that.(AgentExecutionStats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if len(this.OperatorExecutionStats) != len(that1.OperatorExecutionStats) {
		return false
	}
	for i := range this.OperatorExecutionStats {
		if !this.OperatorExecutionStats[i].Equal(that1.OperatorExecutionStats[i]) {
			return false
		}
	}
	if this.ExecutionTimeNs != that1.ExecutionTimeNs {
		return false
	}
	if this.BytesProcessed != that1.BytesProcessed {
		return false
	}
	if this.RecordsProcessed != that1.RecordsProcessed {
		return false
	}
	return true
}
func (this *QueryTimingInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&queryresultspb.QueryTimingInfo{")
	s = append(s, "ExecutionTimeNs: "+fmt.Sprintf("%#v", this.ExecutionTimeNs)+",\n")
	s = append(s, "CompilationTimeNs: "+fmt.Sprintf("%#v", this.CompilationTimeNs)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryExecutionStats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&queryresultspb.QueryExecutionStats{")
	if this.Timing != nil {
		s = append(s, "Timing: "+fmt.Sprintf("%#v", this.Timing)+",\n")
	}
	s = append(s, "BytesProcessed: "+fmt.Sprintf("%#v", this.BytesProcessed)+",\n")
	s = append(s, "RecordsProcessed: "+fmt.Sprintf("%#v", this.RecordsProcessed)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OperatorExecutionStats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&queryresultspb.OperatorExecutionStats{")
	s = append(s, "PlanFragmentId: "+fmt.Sprintf("%#v", this.PlanFragmentId)+",\n")
	s = append(s, "NodeId: "+fmt.Sprintf("%#v", this.NodeId)+",\n")
	s = append(s, "BytesOutput: "+fmt.Sprintf("%#v", this.BytesOutput)+",\n")
	s = append(s, "RecordsOutput: "+fmt.Sprintf("%#v", this.RecordsOutput)+",\n")
	s = append(s, "TotalExecutionTimeNs: "+fmt.Sprintf("%#v", this.TotalExecutionTimeNs)+",\n")
	s = append(s, "SelfExecutionTimeNs: "+fmt.Sprintf("%#v", this.SelfExecutionTimeNs)+",\n")
	if this.OperatorStats != nil {
		s = append(s, "OperatorStats: "+fmt.Sprintf("%#v", this.OperatorStats)+",\n")
	}
	keysForExtraMetrics := make([]string, 0, len(this.ExtraMetrics))
	for k, _ := range this.ExtraMetrics {
		keysForExtraMetrics = append(keysForExtraMetrics, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForExtraMetrics)
	mapStringForExtraMetrics := "map[string]float64{"
	for _, k := range keysForExtraMetrics {
		mapStringForExtraMetrics += fmt.Sprintf("%#v: %#v,", k, this.ExtraMetrics[k])
	}
	mapStringForExtraMetrics += "}"
	if this.ExtraMetrics != nil {
		s = append(s, "ExtraMetrics: "+mapStringForExtraMetrics+",\n")
	}
	keysForExtraInfo := make([]string, 0, len(this.ExtraInfo))
	for k, _ := range this.ExtraInfo {
		keysForExtraInfo = append(keysForExtraInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForExtraInfo)
	mapStringForExtraInfo := "map[string]string{"
	for _, k := range keysForExtraInfo {
		mapStringForExtraInfo += fmt.Sprintf("%#v: %#v,", k, this.ExtraInfo[k])
	}
	mapStringForExtraInfo += "}"
	if this.ExtraInfo != nil {
		s = append(s, "ExtraInfo: "+mapStringForExtraInfo+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AgentExecutionStats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&queryresultspb.AgentExecutionStats{")
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	if this.OperatorExecutionStats != nil {
		s = append(s, "OperatorExecutionStats: "+fmt.Sprintf("%#v", this.OperatorExecutionStats)+",\n")
	}
	s = append(s, "ExecutionTimeNs: "+fmt.Sprintf("%#v", this.ExecutionTimeNs)+",\n")
	s = append(s, "BytesProcessed: "+fmt.Sprintf("%#v", this.BytesProcessed)+",\n")
	s = append(s, "RecordsProcessed: "+fmt.Sprintf("%#v", this.RecordsProcessed)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringQueryResults(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *QueryTimingInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryTimingInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryTimingInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CompilationTimeNs != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.CompilationTimeNs))
		i--
		dAtA[i] = 0x10
	}
	if m.ExecutionTimeNs != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.ExecutionTimeNs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryExecutionStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryExecutionStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryExecutionStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RecordsProcessed != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.RecordsProcessed))
		i--
		dAtA[i] = 0x18
	}
	if m.BytesProcessed != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.BytesProcessed))
		i--
		dAtA[i] = 0x10
	}
	if m.Timing != nil {
		{
			size, err := m.Timing.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQueryResults(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OperatorExecutionStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperatorExecutionStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OperatorExecutionStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ExtraInfo) > 0 {
		for k := range m.ExtraInfo {
			v := m.ExtraInfo[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintQueryResults(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintQueryResults(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintQueryResults(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.ExtraMetrics) > 0 {
		for k := range m.ExtraMetrics {
			v := m.ExtraMetrics[k]
			baseI := i
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i--
			dAtA[i] = 0x11
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintQueryResults(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintQueryResults(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.OperatorStats != nil {
		{
			size, err := m.OperatorStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQueryResults(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.SelfExecutionTimeNs != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.SelfExecutionTimeNs))
		i--
		dAtA[i] = 0x30
	}
	if m.TotalExecutionTimeNs != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.TotalExecutionTimeNs))
		i--
		dAtA[i] = 0x28
	}
	if m.RecordsOutput != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.RecordsOutput))
		i--
		dAtA[i] = 0x20
	}
	if m.BytesOutput != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.BytesOutput))
		i--
		dAtA[i] = 0x18
	}
	if m.NodeId != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.NodeId))
		i--
		dAtA[i] = 0x10
	}
	if m.PlanFragmentId != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.PlanFragmentId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AgentExecutionStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AgentExecutionStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AgentExecutionStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RecordsProcessed != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.RecordsProcessed))
		i--
		dAtA[i] = 0x28
	}
	if m.BytesProcessed != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.BytesProcessed))
		i--
		dAtA[i] = 0x20
	}
	if m.ExecutionTimeNs != 0 {
		i = encodeVarintQueryResults(dAtA, i, uint64(m.ExecutionTimeNs))
		i--
		dAtA[i] = 0x18
	}
	if len(m.OperatorExecutionStats) > 0 {
		for iNdEx := len(m.OperatorExecutionStats) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.OperatorExecutionStats[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQueryResults(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.AgentID != nil {
		{
			size, err := m.AgentID.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQueryResults(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintQueryResults(dAtA []byte, offset int, v uint64) int {
	offset -= sovQueryResults(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QueryTimingInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExecutionTimeNs != 0 {
		n += 1 + sovQueryResults(uint64(m.ExecutionTimeNs))
	}
	if m.CompilationTimeNs != 0 {
		n += 1 + sovQueryResults(uint64(m.CompilationTimeNs))
	}
	return n
}

func (m *QueryExecutionStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timing != nil {
		l = m.Timing.Size()
		n += 1 + l + sovQueryResults(uint64(l))
	}
	if m.BytesProcessed != 0 {
		n += 1 + sovQueryResults(uint64(m.BytesProcessed))
	}
	if m.RecordsProcessed != 0 {
		n += 1 + sovQueryResults(uint64(m.RecordsProcessed))
	}
	return n
}

func (m *OperatorExecutionStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PlanFragmentId != 0 {
		n += 1 + sovQueryResults(uint64(m.PlanFragmentId))
	}
	if m.NodeId != 0 {
		n += 1 + sovQueryResults(uint64(m.NodeId))
	}
	if m.BytesOutput != 0 {
		n += 1 + sovQueryResults(uint64(m.BytesOutput))
	}
	if m.RecordsOutput != 0 {
		n += 1 + sovQueryResults(uint64(m.RecordsOutput))
	}
	if m.TotalExecutionTimeNs != 0 {
		n += 1 + sovQueryResults(uint64(m.TotalExecutionTimeNs))
	}
	if m.SelfExecutionTimeNs != 0 {
		n += 1 + sovQueryResults(uint64(m.SelfExecutionTimeNs))
	}
	if m.OperatorStats != nil {
		l = m.OperatorStats.Size()
		n += 1 + l + sovQueryResults(uint64(l))
	}
	if len(m.ExtraMetrics) > 0 {
		for k, v := range m.ExtraMetrics {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovQueryResults(uint64(len(k))) + 1 + 8
			n += mapEntrySize + 1 + sovQueryResults(uint64(mapEntrySize))
		}
	}
	if len(m.ExtraInfo) > 0 {
		for k, v := range m.ExtraInfo {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovQueryResults(uint64(len(k))) + 1 + len(v) + sovQueryResults(uint64(len(v)))
			n += mapEntrySize + 1 + sovQueryResults(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *AgentExecutionStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AgentID != nil {
		l = m.AgentID.Size()
		n += 1 + l + sovQueryResults(uint64(l))
	}
	if len(m.OperatorExecutionStats) > 0 {
		for _, e := range m.OperatorExecutionStats {
			l = e.Size()
			n += 1 + l + sovQueryResults(uint64(l))
		}
	}
	if m.ExecutionTimeNs != 0 {
		n += 1 + sovQueryResults(uint64(m.ExecutionTimeNs))
	}
	if m.BytesProcessed != 0 {
		n += 1 + sovQueryResults(uint64(m.BytesProcessed))
	}
	if m.RecordsProcessed != 0 {
		n += 1 + sovQueryResults(uint64(m.RecordsProcessed))
	}
	return n
}

func sovQueryResults(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozQueryResults(x uint64) (n int) {
	return sovQueryResults(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QueryTimingInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryTimingInfo{`,
		`ExecutionTimeNs:` + fmt.Sprintf("%v", this.ExecutionTimeNs) + `,`,
		`CompilationTimeNs:` + fmt.Sprintf("%v", this.CompilationTimeNs) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryExecutionStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryExecutionStats{`,
		`Timing:` + strings.Replace(this.Timing.String(), "QueryTimingInfo", "QueryTimingInfo", 1) + `,`,
		`BytesProcessed:` + fmt.Sprintf("%v", this.BytesProcessed) + `,`,
		`RecordsProcessed:` + fmt.Sprintf("%v", this.RecordsProcessed) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OperatorExecutionStats) String() string {
	if this == nil {
		return "nil"
	}
	keysForExtraMetrics := make([]string, 0, len(this.ExtraMetrics))
	for k, _ := range this.ExtraMetrics {
		keysForExtraMetrics = append(keysForExtraMetrics, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForExtraMetrics)
	mapStringForExtraMetrics := "map[string]float64{"
	for _, k := range keysForExtraMetrics {
		mapStringForExtraMetrics += fmt.Sprintf("%v: %v,", k, this.ExtraMetrics[k])
	}
	mapStringForExtraMetrics += "}"
	keysForExtraInfo := make([]string, 0, len(this.ExtraInfo))
	for k, _ := range this.ExtraInfo {
		keysForExtraInfo = append(keysForExtraInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForExtraInfo)
	mapStringForExtraInfo := "map[string]string{"
	for _, k := range keysForExtraInfo {
		mapStringForExtraInfo += fmt.Sprintf("%v: %v,", k, this.ExtraInfo[k])
	}
	mapStringForExtraInfo += "}"
	s := strings.Join([]string{`&OperatorExecutionStats{`,
		`PlanFragmentId:` + fmt.Sprintf("%v", this.PlanFragmentId) + `,`,
		`NodeId:` + fmt.Sprintf("%v", this.NodeId) + `,`,
		`BytesOutput:` + fmt.Sprintf("%v", this.BytesOutput) + `,`,
		`RecordsOutput:` + fmt.Sprintf("%v", this.RecordsOutput) + `,`,
		`TotalExecutionTimeNs:` + fmt.Sprintf("%v", this.TotalExecutionTimeNs) + `,`,
		`SelfExecutionTimeNs:` + fmt.Sprintf("%v", this.SelfExecutionTimeNs) + `,`,
		`OperatorStats:` + strings.Replace(fmt.Sprintf("%v", this.OperatorStats), "Any", "types.Any", 1) + `,`,
		`ExtraMetrics:` + mapStringForExtraMetrics + `,`,
		`ExtraInfo:` + mapStringForExtraInfo + `,`,
		`}`,
	}, "")
	return s
}
func (this *AgentExecutionStats) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForOperatorExecutionStats := "[]*OperatorExecutionStats{"
	for _, f := range this.OperatorExecutionStats {
		repeatedStringForOperatorExecutionStats += strings.Replace(f.String(), "OperatorExecutionStats", "OperatorExecutionStats", 1) + ","
	}
	repeatedStringForOperatorExecutionStats += "}"
	s := strings.Join([]string{`&AgentExecutionStats{`,
		`AgentID:` + strings.Replace(fmt.Sprintf("%v", this.AgentID), "UUID", "uuidpb.UUID", 1) + `,`,
		`OperatorExecutionStats:` + repeatedStringForOperatorExecutionStats + `,`,
		`ExecutionTimeNs:` + fmt.Sprintf("%v", this.ExecutionTimeNs) + `,`,
		`BytesProcessed:` + fmt.Sprintf("%v", this.BytesProcessed) + `,`,
		`RecordsProcessed:` + fmt.Sprintf("%v", this.RecordsProcessed) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringQueryResults(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QueryTimingInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueryResults
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryTimingInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryTimingInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionTimeNs", wireType)
			}
			m.ExecutionTimeNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExecutionTimeNs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompilationTimeNs", wireType)
			}
			m.CompilationTimeNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompilationTimeNs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQueryResults(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQueryResults
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryExecutionStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueryResults
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryExecutionStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryExecutionStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timing == nil {
				m.Timing = &QueryTimingInfo{}
			}
			if err := m.Timing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesProcessed", wireType)
			}
			m.BytesProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordsProcessed", wireType)
			}
			m.RecordsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RecordsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQueryResults(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQueryResults
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OperatorExecutionStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueryResults
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OperatorExecutionStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OperatorExecutionStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlanFragmentId", wireType)
			}
			m.PlanFragmentId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PlanFragmentId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			m.NodeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesOutput", wireType)
			}
			m.BytesOutput = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesOutput |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordsOutput", wireType)
			}
			m.RecordsOutput = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RecordsOutput |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalExecutionTimeNs", wireType)
			}
			m.TotalExecutionTimeNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalExecutionTimeNs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SelfExecutionTimeNs", wireType)
			}
			m.SelfExecutionTimeNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SelfExecutionTimeNs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperatorStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OperatorStats == nil {
				m.OperatorStats = &types.Any{}
			}
			if err := m.OperatorStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExtraMetrics == nil {
				m.ExtraMetrics = make(map[string]float64)
			}
			var mapkey string
			var mapvalue float64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQueryResults
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQueryResults
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthQueryResults
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthQueryResults
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapvaluetemp uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					mapvaluetemp = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					mapvalue = math.Float64frombits(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipQueryResults(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthQueryResults
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExtraMetrics[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExtraInfo == nil {
				m.ExtraInfo = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQueryResults
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQueryResults
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthQueryResults
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthQueryResults
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQueryResults
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthQueryResults
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthQueryResults
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipQueryResults(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthQueryResults
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExtraInfo[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQueryResults(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQueryResults
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AgentExecutionStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueryResults
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AgentExecutionStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AgentExecutionStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentID == nil {
				m.AgentID = &uuidpb.UUID{}
			}
			if err := m.AgentID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperatorExecutionStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OperatorExecutionStats = append(m.OperatorExecutionStats, &OperatorExecutionStats{})
			if err := m.OperatorExecutionStats[len(m.OperatorExecutionStats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionTimeNs", wireType)
			}
			m.ExecutionTimeNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExecutionTimeNs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesProcessed", wireType)
			}
			m.BytesProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordsProcessed", wireType)
			}
			m.RecordsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RecordsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQueryResults(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQueryResults
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQueryResults(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQueryResults
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQueryResults
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthQueryResults
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupQueryResults
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthQueryResults
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthQueryResults        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQueryResults          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupQueryResults = fmt.Errorf("proto: unexpected end of group")
)
