// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: src/carnot/planpb/plan.proto

package planpb

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	math_bits "math/bits"
	uuidpb "px.dev/pixie/src/api/proto/uuidpb"
	typespb "px.dev/pixie/src/shared/types/typespb"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type OperatorType int32

const (
	OPERATOR_TYPE_UNKNOWN     OperatorType = 0
	MEMORY_SOURCE_OPERATOR    OperatorType = 1000
	GRPC_SOURCE_OPERATOR      OperatorType = 1100
	UDTF_SOURCE_OPERATOR      OperatorType = 1200
	EMPTY_SOURCE_OPERATOR     OperatorType = 1300
	MAP_OPERATOR              OperatorType = 2000
	AGGREGATE_OPERATOR        OperatorType = 2100
	FILTER_OPERATOR           OperatorType = 2200
	LIMIT_OPERATOR            OperatorType = 2300
	UNION_OPERATOR            OperatorType = 2400
	JOIN_OPERATOR             OperatorType = 2500
	MEMORY_SINK_OPERATOR      OperatorType = 9000
	GRPC_SINK_OPERATOR        OperatorType = 9100
	OTEL_EXPORT_SINK_OPERATOR OperatorType = 9200
)

var OperatorType_name = map[int32]string{
	0:    "OPERATOR_TYPE_UNKNOWN",
	1000: "MEMORY_SOURCE_OPERATOR",
	1100: "GRPC_SOURCE_OPERATOR",
	1200: "UDTF_SOURCE_OPERATOR",
	1300: "EMPTY_SOURCE_OPERATOR",
	2000: "MAP_OPERATOR",
	2100: "AGGREGATE_OPERATOR",
	2200: "FILTER_OPERATOR",
	2300: "LIMIT_OPERATOR",
	2400: "UNION_OPERATOR",
	2500: "JOIN_OPERATOR",
	9000: "MEMORY_SINK_OPERATOR",
	9100: "GRPC_SINK_OPERATOR",
	9200: "OTEL_EXPORT_SINK_OPERATOR",
}

var OperatorType_value = map[string]int32{
	"OPERATOR_TYPE_UNKNOWN":     0,
	"MEMORY_SOURCE_OPERATOR":    1000,
	"GRPC_SOURCE_OPERATOR":      1100,
	"UDTF_SOURCE_OPERATOR":      1200,
	"EMPTY_SOURCE_OPERATOR":     1300,
	"MAP_OPERATOR":              2000,
	"AGGREGATE_OPERATOR":        2100,
	"FILTER_OPERATOR":           2200,
	"LIMIT_OPERATOR":            2300,
	"UNION_OPERATOR":            2400,
	"JOIN_OPERATOR":             2500,
	"MEMORY_SINK_OPERATOR":      9000,
	"GRPC_SINK_OPERATOR":        9100,
	"OTEL_EXPORT_SINK_OPERATOR": 9200,
}

func (OperatorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{0}
}

type JoinOperator_JoinType int32

const (
	INNER      JoinOperator_JoinType = 0
	LEFT_OUTER JoinOperator_JoinType = 1
	FULL_OUTER JoinOperator_JoinType = 3
)

var JoinOperator_JoinType_name = map[int32]string{
	0: "INNER",
	1: "LEFT_OUTER",
	3: "FULL_OUTER",
}

var JoinOperator_JoinType_value = map[string]int32{
	"INNER":      0,
	"LEFT_OUTER": 1,
	"FULL_OUTER": 3,
}

func (JoinOperator_JoinType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{15, 0}
}

type PlanOptions struct {
	Explain               bool  `protobuf:"varint,2,opt,name=explain,proto3" json:"explain,omitempty"`
	Analyze               bool  `protobuf:"varint,3,opt,name=analyze,proto3" json:"analyze,omitempty"`
	MaxOutputRowsPerTable int64 `protobuf:"varint,4,opt,name=max_output_rows_per_table,json=maxOutputRowsPerTable,proto3" json:"max_output_rows_per_table,omitempty"`
}

func (m *PlanOptions) Reset()      { *m = PlanOptions{} }
func (*PlanOptions) ProtoMessage() {}
func (*PlanOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{0}
}
func (m *PlanOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PlanOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PlanOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PlanOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlanOptions.Merge(m, src)
}
func (m *PlanOptions) XXX_Size() int {
	return m.Size()
}
func (m *PlanOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_PlanOptions.DiscardUnknown(m)
}

var xxx_messageInfo_PlanOptions proto.InternalMessageInfo

func (m *PlanOptions) GetExplain() bool {
	if m != nil {
		return m.Explain
	}
	return false
}

func (m *PlanOptions) GetAnalyze() bool {
	if m != nil {
		return m.Analyze
	}
	return false
}

func (m *PlanOptions) GetMaxOutputRowsPerTable() int64 {
	if m != nil {
		return m.MaxOutputRowsPerTable
	}
	return 0
}

type Plan struct {
	Dag                         *DAG                               `protobuf:"bytes,1,opt,name=dag,proto3" json:"dag,omitempty"`
	Nodes                       []*PlanFragment                    `protobuf:"bytes,2,rep,name=nodes,proto3" json:"nodes,omitempty"`
	PlanOptions                 *PlanOptions                       `protobuf:"bytes,4,opt,name=plan_options,json=planOptions,proto3" json:"plan_options,omitempty"`
	IncomingAgentIDs            []*uuidpb.UUID                     `protobuf:"bytes,5,rep,name=incoming_agent_ids,json=incomingAgentIds,proto3" json:"incoming_agent_ids,omitempty"`
	ExecutionStatusDestinations []*Plan_ExecutionStatusDestination `protobuf:"bytes,6,rep,name=execution_status_destinations,json=executionStatusDestinations,proto3" json:"execution_status_destinations,omitempty"`
}

func (m *Plan) Reset()      { *m = Plan{} }
func (*Plan) ProtoMessage() {}
func (*Plan) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{1}
}
func (m *Plan) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Plan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Plan.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Plan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Plan.Merge(m, src)
}
func (m *Plan) XXX_Size() int {
	return m.Size()
}
func (m *Plan) XXX_DiscardUnknown() {
	xxx_messageInfo_Plan.DiscardUnknown(m)
}

var xxx_messageInfo_Plan proto.InternalMessageInfo

func (m *Plan) GetDag() *DAG {
	if m != nil {
		return m.Dag
	}
	return nil
}

func (m *Plan) GetNodes() []*PlanFragment {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *Plan) GetPlanOptions() *PlanOptions {
	if m != nil {
		return m.PlanOptions
	}
	return nil
}

func (m *Plan) GetIncomingAgentIDs() []*uuidpb.UUID {
	if m != nil {
		return m.IncomingAgentIDs
	}
	return nil
}

func (m *Plan) GetExecutionStatusDestinations() []*Plan_ExecutionStatusDestination {
	if m != nil {
		return m.ExecutionStatusDestinations
	}
	return nil
}

type Plan_ExecutionStatusDestination struct {
	GrpcAddress   string `protobuf:"bytes,1,opt,name=grpc_address,json=grpcAddress,proto3" json:"grpc_address,omitempty"`
	SslTargetname string `protobuf:"bytes,2,opt,name=ssl_targetname,json=sslTargetname,proto3" json:"ssl_targetname,omitempty"`
}

func (m *Plan_ExecutionStatusDestination) Reset()      { *m = Plan_ExecutionStatusDestination{} }
func (*Plan_ExecutionStatusDestination) ProtoMessage() {}
func (*Plan_ExecutionStatusDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{1, 0}
}
func (m *Plan_ExecutionStatusDestination) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Plan_ExecutionStatusDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Plan_ExecutionStatusDestination.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Plan_ExecutionStatusDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Plan_ExecutionStatusDestination.Merge(m, src)
}
func (m *Plan_ExecutionStatusDestination) XXX_Size() int {
	return m.Size()
}
func (m *Plan_ExecutionStatusDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_Plan_ExecutionStatusDestination.DiscardUnknown(m)
}

var xxx_messageInfo_Plan_ExecutionStatusDestination proto.InternalMessageInfo

func (m *Plan_ExecutionStatusDestination) GetGrpcAddress() string {
	if m != nil {
		return m.GrpcAddress
	}
	return ""
}

func (m *Plan_ExecutionStatusDestination) GetSslTargetname() string {
	if m != nil {
		return m.SslTargetname
	}
	return ""
}

type PlanFragment struct {
	Id    uint64      `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Dag   *DAG        `protobuf:"bytes,2,opt,name=dag,proto3" json:"dag,omitempty"`
	Nodes []*PlanNode `protobuf:"bytes,3,rep,name=nodes,proto3" json:"nodes,omitempty"`
}

func (m *PlanFragment) Reset()      { *m = PlanFragment{} }
func (*PlanFragment) ProtoMessage() {}
func (*PlanFragment) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{2}
}
func (m *PlanFragment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PlanFragment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PlanFragment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PlanFragment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlanFragment.Merge(m, src)
}
func (m *PlanFragment) XXX_Size() int {
	return m.Size()
}
func (m *PlanFragment) XXX_DiscardUnknown() {
	xxx_messageInfo_PlanFragment.DiscardUnknown(m)
}

var xxx_messageInfo_PlanFragment proto.InternalMessageInfo

func (m *PlanFragment) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *PlanFragment) GetDag() *DAG {
	if m != nil {
		return m.Dag
	}
	return nil
}

func (m *PlanFragment) GetNodes() []*PlanNode {
	if m != nil {
		return m.Nodes
	}
	return nil
}

type DAG struct {
	Nodes []*DAG_DAGNode `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
}

func (m *DAG) Reset()      { *m = DAG{} }
func (*DAG) ProtoMessage() {}
func (*DAG) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{3}
}
func (m *DAG) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DAG) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DAG.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DAG) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DAG.Merge(m, src)
}
func (m *DAG) XXX_Size() int {
	return m.Size()
}
func (m *DAG) XXX_DiscardUnknown() {
	xxx_messageInfo_DAG.DiscardUnknown(m)
}

var xxx_messageInfo_DAG proto.InternalMessageInfo

func (m *DAG) GetNodes() []*DAG_DAGNode {
	if m != nil {
		return m.Nodes
	}
	return nil
}

type DAG_DAGNode struct {
	Id             uint64   `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	SortedParents  []uint64 `protobuf:"varint,4,rep,packed,name=sorted_parents,json=sortedParents,proto3" json:"sorted_parents,omitempty"`
	SortedChildren []uint64 `protobuf:"varint,3,rep,packed,name=sorted_children,json=sortedChildren,proto3" json:"sorted_children,omitempty"`
}

func (m *DAG_DAGNode) Reset()      { *m = DAG_DAGNode{} }
func (*DAG_DAGNode) ProtoMessage() {}
func (*DAG_DAGNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{3, 0}
}
func (m *DAG_DAGNode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DAG_DAGNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DAG_DAGNode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DAG_DAGNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DAG_DAGNode.Merge(m, src)
}
func (m *DAG_DAGNode) XXX_Size() int {
	return m.Size()
}
func (m *DAG_DAGNode) XXX_DiscardUnknown() {
	xxx_messageInfo_DAG_DAGNode.DiscardUnknown(m)
}

var xxx_messageInfo_DAG_DAGNode proto.InternalMessageInfo

func (m *DAG_DAGNode) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *DAG_DAGNode) GetSortedParents() []uint64 {
	if m != nil {
		return m.SortedParents
	}
	return nil
}

func (m *DAG_DAGNode) GetSortedChildren() []uint64 {
	if m != nil {
		return m.SortedChildren
	}
	return nil
}

type PlanNode struct {
	Id uint64    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Op *Operator `protobuf:"bytes,2,opt,name=op,proto3" json:"op,omitempty"`
}

func (m *PlanNode) Reset()      { *m = PlanNode{} }
func (*PlanNode) ProtoMessage() {}
func (*PlanNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{4}
}
func (m *PlanNode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PlanNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PlanNode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PlanNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlanNode.Merge(m, src)
}
func (m *PlanNode) XXX_Size() int {
	return m.Size()
}
func (m *PlanNode) XXX_DiscardUnknown() {
	xxx_messageInfo_PlanNode.DiscardUnknown(m)
}

var xxx_messageInfo_PlanNode proto.InternalMessageInfo

func (m *PlanNode) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *PlanNode) GetOp() *Operator {
	if m != nil {
		return m.Op
	}
	return nil
}

type Operator struct {
	OpType OperatorType `protobuf:"varint,1,opt,name=op_type,json=opType,proto3,enum=px.carnot.planpb.OperatorType" json:"op_type,omitempty"`
	// Types that are valid to be assigned to Op:
	//
	//	*Operator_MemSourceOp
	//	*Operator_MapOp
	//	*Operator_AggOp
	//	*Operator_MemSinkOp
	//	*Operator_FilterOp
	//	*Operator_LimitOp
	//	*Operator_UnionOp
	//	*Operator_GRPCSourceOp
	//	*Operator_GRPCSinkOp
	//	*Operator_JoinOp
	//	*Operator_UdtfSourceOp
	//	*Operator_EmptySourceOp
	//	*Operator_OTelSinkOp
	Op isOperator_Op `protobuf_oneof:"op"`
}

func (m *Operator) Reset()      { *m = Operator{} }
func (*Operator) ProtoMessage() {}
func (*Operator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{5}
}
func (m *Operator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Operator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Operator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Operator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operator.Merge(m, src)
}
func (m *Operator) XXX_Size() int {
	return m.Size()
}
func (m *Operator) XXX_DiscardUnknown() {
	xxx_messageInfo_Operator.DiscardUnknown(m)
}

var xxx_messageInfo_Operator proto.InternalMessageInfo

type isOperator_Op interface {
	isOperator_Op()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Operator_MemSourceOp struct {
	MemSourceOp *MemorySourceOperator `protobuf:"bytes,2,opt,name=mem_source_op,json=memSourceOp,proto3,oneof" json:"mem_source_op,omitempty"`
}
type Operator_MapOp struct {
	MapOp *MapOperator `protobuf:"bytes,3,opt,name=map_op,json=mapOp,proto3,oneof" json:"map_op,omitempty"`
}
type Operator_AggOp struct {
	AggOp *AggregateOperator `protobuf:"bytes,4,opt,name=agg_op,json=aggOp,proto3,oneof" json:"agg_op,omitempty"`
}
type Operator_MemSinkOp struct {
	MemSinkOp *MemorySinkOperator `protobuf:"bytes,5,opt,name=mem_sink_op,json=memSinkOp,proto3,oneof" json:"mem_sink_op,omitempty"`
}
type Operator_FilterOp struct {
	FilterOp *FilterOperator `protobuf:"bytes,6,opt,name=filter_op,json=filterOp,proto3,oneof" json:"filter_op,omitempty"`
}
type Operator_LimitOp struct {
	LimitOp *LimitOperator `protobuf:"bytes,7,opt,name=limit_op,json=limitOp,proto3,oneof" json:"limit_op,omitempty"`
}
type Operator_UnionOp struct {
	UnionOp *UnionOperator `protobuf:"bytes,8,opt,name=union_op,json=unionOp,proto3,oneof" json:"union_op,omitempty"`
}
type Operator_GRPCSourceOp struct {
	GRPCSourceOp *GRPCSourceOperator `protobuf:"bytes,9,opt,name=grpc_source_op,json=grpcSourceOp,proto3,oneof" json:"grpc_source_op,omitempty"`
}
type Operator_GRPCSinkOp struct {
	GRPCSinkOp *GRPCSinkOperator `protobuf:"bytes,1000,opt,name=grpc_sink_op,json=grpcSinkOp,proto3,oneof" json:"grpc_sink_op,omitempty"`
}
type Operator_JoinOp struct {
	JoinOp *JoinOperator `protobuf:"bytes,11,opt,name=join_op,json=joinOp,proto3,oneof" json:"join_op,omitempty"`
}
type Operator_UdtfSourceOp struct {
	UdtfSourceOp *UDTFSourceOperator `protobuf:"bytes,12,opt,name=udtf_source_op,json=udtfSourceOp,proto3,oneof" json:"udtf_source_op,omitempty"`
}
type Operator_EmptySourceOp struct {
	EmptySourceOp *EmptySourceOperator `protobuf:"bytes,13,opt,name=empty_source_op,json=emptySourceOp,proto3,oneof" json:"empty_source_op,omitempty"`
}
type Operator_OTelSinkOp struct {
	OTelSinkOp *OTelExportSinkOperator `protobuf:"bytes,14,opt,name=otel_sink_op,json=otelSinkOp,proto3,oneof" json:"otel_sink_op,omitempty"`
}

func (*Operator_MemSourceOp) isOperator_Op()   {}
func (*Operator_MapOp) isOperator_Op()         {}
func (*Operator_AggOp) isOperator_Op()         {}
func (*Operator_MemSinkOp) isOperator_Op()     {}
func (*Operator_FilterOp) isOperator_Op()      {}
func (*Operator_LimitOp) isOperator_Op()       {}
func (*Operator_UnionOp) isOperator_Op()       {}
func (*Operator_GRPCSourceOp) isOperator_Op()  {}
func (*Operator_GRPCSinkOp) isOperator_Op()    {}
func (*Operator_JoinOp) isOperator_Op()        {}
func (*Operator_UdtfSourceOp) isOperator_Op()  {}
func (*Operator_EmptySourceOp) isOperator_Op() {}
func (*Operator_OTelSinkOp) isOperator_Op()    {}

func (m *Operator) GetOp() isOperator_Op {
	if m != nil {
		return m.Op
	}
	return nil
}

func (m *Operator) GetOpType() OperatorType {
	if m != nil {
		return m.OpType
	}
	return OPERATOR_TYPE_UNKNOWN
}

func (m *Operator) GetMemSourceOp() *MemorySourceOperator {
	if x, ok := m.GetOp().(*Operator_MemSourceOp); ok {
		return x.MemSourceOp
	}
	return nil
}

func (m *Operator) GetMapOp() *MapOperator {
	if x, ok := m.GetOp().(*Operator_MapOp); ok {
		return x.MapOp
	}
	return nil
}

func (m *Operator) GetAggOp() *AggregateOperator {
	if x, ok := m.GetOp().(*Operator_AggOp); ok {
		return x.AggOp
	}
	return nil
}

func (m *Operator) GetMemSinkOp() *MemorySinkOperator {
	if x, ok := m.GetOp().(*Operator_MemSinkOp); ok {
		return x.MemSinkOp
	}
	return nil
}

func (m *Operator) GetFilterOp() *FilterOperator {
	if x, ok := m.GetOp().(*Operator_FilterOp); ok {
		return x.FilterOp
	}
	return nil
}

func (m *Operator) GetLimitOp() *LimitOperator {
	if x, ok := m.GetOp().(*Operator_LimitOp); ok {
		return x.LimitOp
	}
	return nil
}

func (m *Operator) GetUnionOp() *UnionOperator {
	if x, ok := m.GetOp().(*Operator_UnionOp); ok {
		return x.UnionOp
	}
	return nil
}

func (m *Operator) GetGRPCSourceOp() *GRPCSourceOperator {
	if x, ok := m.GetOp().(*Operator_GRPCSourceOp); ok {
		return x.GRPCSourceOp
	}
	return nil
}

func (m *Operator) GetGRPCSinkOp() *GRPCSinkOperator {
	if x, ok := m.GetOp().(*Operator_GRPCSinkOp); ok {
		return x.GRPCSinkOp
	}
	return nil
}

func (m *Operator) GetJoinOp() *JoinOperator {
	if x, ok := m.GetOp().(*Operator_JoinOp); ok {
		return x.JoinOp
	}
	return nil
}

func (m *Operator) GetUdtfSourceOp() *UDTFSourceOperator {
	if x, ok := m.GetOp().(*Operator_UdtfSourceOp); ok {
		return x.UdtfSourceOp
	}
	return nil
}

func (m *Operator) GetEmptySourceOp() *EmptySourceOperator {
	if x, ok := m.GetOp().(*Operator_EmptySourceOp); ok {
		return x.EmptySourceOp
	}
	return nil
}

func (m *Operator) GetOTelSinkOp() *OTelExportSinkOperator {
	if x, ok := m.GetOp().(*Operator_OTelSinkOp); ok {
		return x.OTelSinkOp
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Operator) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Operator_MemSourceOp)(nil),
		(*Operator_MapOp)(nil),
		(*Operator_AggOp)(nil),
		(*Operator_MemSinkOp)(nil),
		(*Operator_FilterOp)(nil),
		(*Operator_LimitOp)(nil),
		(*Operator_UnionOp)(nil),
		(*Operator_GRPCSourceOp)(nil),
		(*Operator_GRPCSinkOp)(nil),
		(*Operator_JoinOp)(nil),
		(*Operator_UdtfSourceOp)(nil),
		(*Operator_EmptySourceOp)(nil),
		(*Operator_OTelSinkOp)(nil),
	}
}

type MemorySourceOperator struct {
	Name        string             `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ColumnIdxs  []int64            `protobuf:"varint,2,rep,packed,name=column_idxs,json=columnIdxs,proto3" json:"column_idxs,omitempty"`
	ColumnNames []string           `protobuf:"bytes,3,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
	ColumnTypes []typespb.DataType `protobuf:"varint,4,rep,packed,name=column_types,json=columnTypes,proto3,enum=px.types.DataType" json:"column_types,omitempty"`
	StartTime   *types.Int64Value  `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	StopTime    *types.Int64Value  `protobuf:"bytes,6,opt,name=stop_time,json=stopTime,proto3" json:"stop_time,omitempty"`
	Tablet      string             `protobuf:"bytes,7,opt,name=tablet,proto3" json:"tablet,omitempty"`
	Streaming   bool               `protobuf:"varint,8,opt,name=streaming,proto3" json:"streaming,omitempty"`
}

func (m *MemorySourceOperator) Reset()      { *m = MemorySourceOperator{} }
func (*MemorySourceOperator) ProtoMessage() {}
func (*MemorySourceOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{6}
}
func (m *MemorySourceOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemorySourceOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemorySourceOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemorySourceOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemorySourceOperator.Merge(m, src)
}
func (m *MemorySourceOperator) XXX_Size() int {
	return m.Size()
}
func (m *MemorySourceOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_MemorySourceOperator.DiscardUnknown(m)
}

var xxx_messageInfo_MemorySourceOperator proto.InternalMessageInfo

func (m *MemorySourceOperator) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MemorySourceOperator) GetColumnIdxs() []int64 {
	if m != nil {
		return m.ColumnIdxs
	}
	return nil
}

func (m *MemorySourceOperator) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

func (m *MemorySourceOperator) GetColumnTypes() []typespb.DataType {
	if m != nil {
		return m.ColumnTypes
	}
	return nil
}

func (m *MemorySourceOperator) GetStartTime() *types.Int64Value {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *MemorySourceOperator) GetStopTime() *types.Int64Value {
	if m != nil {
		return m.StopTime
	}
	return nil
}

func (m *MemorySourceOperator) GetTablet() string {
	if m != nil {
		return m.Tablet
	}
	return ""
}

func (m *MemorySourceOperator) GetStreaming() bool {
	if m != nil {
		return m.Streaming
	}
	return false
}

type MemorySinkOperator struct {
	Name                string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ColumnTypes         []typespb.DataType     `protobuf:"varint,2,rep,packed,name=column_types,json=columnTypes,proto3,enum=px.types.DataType" json:"column_types,omitempty"`
	ColumnNames         []string               `protobuf:"bytes,3,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
	ColumnSemanticTypes []typespb.SemanticType `protobuf:"varint,4,rep,packed,name=column_semantic_types,json=columnSemanticTypes,proto3,enum=px.types.SemanticType" json:"column_semantic_types,omitempty"`
}

func (m *MemorySinkOperator) Reset()      { *m = MemorySinkOperator{} }
func (*MemorySinkOperator) ProtoMessage() {}
func (*MemorySinkOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{7}
}
func (m *MemorySinkOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemorySinkOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemorySinkOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemorySinkOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemorySinkOperator.Merge(m, src)
}
func (m *MemorySinkOperator) XXX_Size() int {
	return m.Size()
}
func (m *MemorySinkOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_MemorySinkOperator.DiscardUnknown(m)
}

var xxx_messageInfo_MemorySinkOperator proto.InternalMessageInfo

func (m *MemorySinkOperator) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MemorySinkOperator) GetColumnTypes() []typespb.DataType {
	if m != nil {
		return m.ColumnTypes
	}
	return nil
}

func (m *MemorySinkOperator) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

func (m *MemorySinkOperator) GetColumnSemanticTypes() []typespb.SemanticType {
	if m != nil {
		return m.ColumnSemanticTypes
	}
	return nil
}

type GRPCSourceOperator struct {
	ColumnTypes []typespb.DataType `protobuf:"varint,1,rep,packed,name=column_types,json=columnTypes,proto3,enum=px.types.DataType" json:"column_types,omitempty"`
	ColumnNames []string           `protobuf:"bytes,2,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
}

func (m *GRPCSourceOperator) Reset()      { *m = GRPCSourceOperator{} }
func (*GRPCSourceOperator) ProtoMessage() {}
func (*GRPCSourceOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{8}
}
func (m *GRPCSourceOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GRPCSourceOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GRPCSourceOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GRPCSourceOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GRPCSourceOperator.Merge(m, src)
}
func (m *GRPCSourceOperator) XXX_Size() int {
	return m.Size()
}
func (m *GRPCSourceOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_GRPCSourceOperator.DiscardUnknown(m)
}

var xxx_messageInfo_GRPCSourceOperator proto.InternalMessageInfo

func (m *GRPCSourceOperator) GetColumnTypes() []typespb.DataType {
	if m != nil {
		return m.ColumnTypes
	}
	return nil
}

func (m *GRPCSourceOperator) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

type GRPCSinkOperator struct {
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Types that are valid to be assigned to Destination:
	//
	//	*GRPCSinkOperator_GRPCSourceID
	//	*GRPCSinkOperator_OutputTable
	Destination       isGRPCSinkOperator_Destination          `protobuf_oneof:"destination"`
	ConnectionOptions *GRPCSinkOperator_GRPCConnectionOptions `protobuf:"bytes,5,opt,name=connection_options,json=connectionOptions,proto3" json:"connection_options,omitempty"`
}

func (m *GRPCSinkOperator) Reset()      { *m = GRPCSinkOperator{} }
func (*GRPCSinkOperator) ProtoMessage() {}
func (*GRPCSinkOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{9}
}
func (m *GRPCSinkOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GRPCSinkOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GRPCSinkOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GRPCSinkOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GRPCSinkOperator.Merge(m, src)
}
func (m *GRPCSinkOperator) XXX_Size() int {
	return m.Size()
}
func (m *GRPCSinkOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_GRPCSinkOperator.DiscardUnknown(m)
}

var xxx_messageInfo_GRPCSinkOperator proto.InternalMessageInfo

type isGRPCSinkOperator_Destination interface {
	isGRPCSinkOperator_Destination()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type GRPCSinkOperator_GRPCSourceID struct {
	GRPCSourceID uint64 `protobuf:"varint,3,opt,name=grpc_source_id,json=grpcSourceId,proto3,oneof" json:"grpc_source_id,omitempty"`
}
type GRPCSinkOperator_OutputTable struct {
	OutputTable *GRPCSinkOperator_ResultTable `protobuf:"bytes,4,opt,name=output_table,json=outputTable,proto3,oneof" json:"output_table,omitempty"`
}

func (*GRPCSinkOperator_GRPCSourceID) isGRPCSinkOperator_Destination() {}
func (*GRPCSinkOperator_OutputTable) isGRPCSinkOperator_Destination()  {}

func (m *GRPCSinkOperator) GetDestination() isGRPCSinkOperator_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *GRPCSinkOperator) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *GRPCSinkOperator) GetGRPCSourceID() uint64 {
	if x, ok := m.GetDestination().(*GRPCSinkOperator_GRPCSourceID); ok {
		return x.GRPCSourceID
	}
	return 0
}

func (m *GRPCSinkOperator) GetOutputTable() *GRPCSinkOperator_ResultTable {
	if x, ok := m.GetDestination().(*GRPCSinkOperator_OutputTable); ok {
		return x.OutputTable
	}
	return nil
}

func (m *GRPCSinkOperator) GetConnectionOptions() *GRPCSinkOperator_GRPCConnectionOptions {
	if m != nil {
		return m.ConnectionOptions
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GRPCSinkOperator) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GRPCSinkOperator_GRPCSourceID)(nil),
		(*GRPCSinkOperator_OutputTable)(nil),
	}
}

type GRPCSinkOperator_ResultTable struct {
	TableName           string                 `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	ColumnTypes         []typespb.DataType     `protobuf:"varint,2,rep,packed,name=column_types,json=columnTypes,proto3,enum=px.types.DataType" json:"column_types,omitempty"`
	ColumnNames         []string               `protobuf:"bytes,3,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
	ColumnSemanticTypes []typespb.SemanticType `protobuf:"varint,4,rep,packed,name=column_semantic_types,json=columnSemanticTypes,proto3,enum=px.types.SemanticType" json:"column_semantic_types,omitempty"`
}

func (m *GRPCSinkOperator_ResultTable) Reset()      { *m = GRPCSinkOperator_ResultTable{} }
func (*GRPCSinkOperator_ResultTable) ProtoMessage() {}
func (*GRPCSinkOperator_ResultTable) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{9, 0}
}
func (m *GRPCSinkOperator_ResultTable) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GRPCSinkOperator_ResultTable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GRPCSinkOperator_ResultTable.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GRPCSinkOperator_ResultTable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GRPCSinkOperator_ResultTable.Merge(m, src)
}
func (m *GRPCSinkOperator_ResultTable) XXX_Size() int {
	return m.Size()
}
func (m *GRPCSinkOperator_ResultTable) XXX_DiscardUnknown() {
	xxx_messageInfo_GRPCSinkOperator_ResultTable.DiscardUnknown(m)
}

var xxx_messageInfo_GRPCSinkOperator_ResultTable proto.InternalMessageInfo

func (m *GRPCSinkOperator_ResultTable) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *GRPCSinkOperator_ResultTable) GetColumnTypes() []typespb.DataType {
	if m != nil {
		return m.ColumnTypes
	}
	return nil
}

func (m *GRPCSinkOperator_ResultTable) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

func (m *GRPCSinkOperator_ResultTable) GetColumnSemanticTypes() []typespb.SemanticType {
	if m != nil {
		return m.ColumnSemanticTypes
	}
	return nil
}

type GRPCSinkOperator_GRPCConnectionOptions struct {
	SslTargetname string `protobuf:"bytes,1,opt,name=ssl_targetname,json=sslTargetname,proto3" json:"ssl_targetname,omitempty"`
}

func (m *GRPCSinkOperator_GRPCConnectionOptions) Reset() {
	*m = GRPCSinkOperator_GRPCConnectionOptions{}
}
func (*GRPCSinkOperator_GRPCConnectionOptions) ProtoMessage() {}
func (*GRPCSinkOperator_GRPCConnectionOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{9, 1}
}
func (m *GRPCSinkOperator_GRPCConnectionOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GRPCSinkOperator_GRPCConnectionOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GRPCSinkOperator_GRPCConnectionOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GRPCSinkOperator_GRPCConnectionOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GRPCSinkOperator_GRPCConnectionOptions.Merge(m, src)
}
func (m *GRPCSinkOperator_GRPCConnectionOptions) XXX_Size() int {
	return m.Size()
}
func (m *GRPCSinkOperator_GRPCConnectionOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_GRPCSinkOperator_GRPCConnectionOptions.DiscardUnknown(m)
}

var xxx_messageInfo_GRPCSinkOperator_GRPCConnectionOptions proto.InternalMessageInfo

func (m *GRPCSinkOperator_GRPCConnectionOptions) GetSslTargetname() string {
	if m != nil {
		return m.SslTargetname
	}
	return ""
}

type MapOperator struct {
	Expressions []*ScalarExpression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
	ColumnNames []string            `protobuf:"bytes,2,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
}

func (m *MapOperator) Reset()      { *m = MapOperator{} }
func (*MapOperator) ProtoMessage() {}
func (*MapOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{10}
}
func (m *MapOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MapOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MapOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MapOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MapOperator.Merge(m, src)
}
func (m *MapOperator) XXX_Size() int {
	return m.Size()
}
func (m *MapOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_MapOperator.DiscardUnknown(m)
}

var xxx_messageInfo_MapOperator proto.InternalMessageInfo

func (m *MapOperator) GetExpressions() []*ScalarExpression {
	if m != nil {
		return m.Expressions
	}
	return nil
}

func (m *MapOperator) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

type AggregateOperator struct {
	Values          []*AggregateExpression `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	Groups          []*Column              `protobuf:"bytes,2,rep,name=groups,proto3" json:"groups,omitempty"`
	GroupNames      []string               `protobuf:"bytes,3,rep,name=group_names,json=groupNames,proto3" json:"group_names,omitempty"`
	ValueNames      []string               `protobuf:"bytes,4,rep,name=value_names,json=valueNames,proto3" json:"value_names,omitempty"`
	Windowed        bool                   `protobuf:"varint,5,opt,name=windowed,proto3" json:"windowed,omitempty"`
	PartialAgg      bool                   `protobuf:"varint,6,opt,name=partial_agg,json=partialAgg,proto3" json:"partial_agg,omitempty"`
	FinalizeResults bool                   `protobuf:"varint,7,opt,name=finalize_results,json=finalizeResults,proto3" json:"finalize_results,omitempty"`
}

func (m *AggregateOperator) Reset()      { *m = AggregateOperator{} }
func (*AggregateOperator) ProtoMessage() {}
func (*AggregateOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{11}
}
func (m *AggregateOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AggregateOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AggregateOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AggregateOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AggregateOperator.Merge(m, src)
}
func (m *AggregateOperator) XXX_Size() int {
	return m.Size()
}
func (m *AggregateOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_AggregateOperator.DiscardUnknown(m)
}

var xxx_messageInfo_AggregateOperator proto.InternalMessageInfo

func (m *AggregateOperator) GetValues() []*AggregateExpression {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *AggregateOperator) GetGroups() []*Column {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *AggregateOperator) GetGroupNames() []string {
	if m != nil {
		return m.GroupNames
	}
	return nil
}

func (m *AggregateOperator) GetValueNames() []string {
	if m != nil {
		return m.ValueNames
	}
	return nil
}

func (m *AggregateOperator) GetWindowed() bool {
	if m != nil {
		return m.Windowed
	}
	return false
}

func (m *AggregateOperator) GetPartialAgg() bool {
	if m != nil {
		return m.PartialAgg
	}
	return false
}

func (m *AggregateOperator) GetFinalizeResults() bool {
	if m != nil {
		return m.FinalizeResults
	}
	return false
}

type FilterOperator struct {
	Expression *ScalarExpression `protobuf:"bytes,1,opt,name=expression,proto3" json:"expression,omitempty"`
	Columns    []*Column         `protobuf:"bytes,2,rep,name=columns,proto3" json:"columns,omitempty"`
}

func (m *FilterOperator) Reset()      { *m = FilterOperator{} }
func (*FilterOperator) ProtoMessage() {}
func (*FilterOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{12}
}
func (m *FilterOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FilterOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FilterOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FilterOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FilterOperator.Merge(m, src)
}
func (m *FilterOperator) XXX_Size() int {
	return m.Size()
}
func (m *FilterOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_FilterOperator.DiscardUnknown(m)
}

var xxx_messageInfo_FilterOperator proto.InternalMessageInfo

func (m *FilterOperator) GetExpression() *ScalarExpression {
	if m != nil {
		return m.Expression
	}
	return nil
}

func (m *FilterOperator) GetColumns() []*Column {
	if m != nil {
		return m.Columns
	}
	return nil
}

type LimitOperator struct {
	Limit         int64     `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	Columns       []*Column `protobuf:"bytes,2,rep,name=columns,proto3" json:"columns,omitempty"`
	AbortableSrcs []uint64  `protobuf:"varint,3,rep,packed,name=abortable_srcs,json=abortableSrcs,proto3" json:"abortable_srcs,omitempty"`
}

func (m *LimitOperator) Reset()      { *m = LimitOperator{} }
func (*LimitOperator) ProtoMessage() {}
func (*LimitOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{13}
}
func (m *LimitOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LimitOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LimitOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LimitOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LimitOperator.Merge(m, src)
}
func (m *LimitOperator) XXX_Size() int {
	return m.Size()
}
func (m *LimitOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_LimitOperator.DiscardUnknown(m)
}

var xxx_messageInfo_LimitOperator proto.InternalMessageInfo

func (m *LimitOperator) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *LimitOperator) GetColumns() []*Column {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *LimitOperator) GetAbortableSrcs() []uint64 {
	if m != nil {
		return m.AbortableSrcs
	}
	return nil
}

type UnionOperator struct {
	ColumnNames    []string                       `protobuf:"bytes,1,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
	ColumnMappings []*UnionOperator_ColumnMapping `protobuf:"bytes,2,rep,name=column_mappings,json=columnMappings,proto3" json:"column_mappings,omitempty"`
	RowsPerBatch   uint64                         `protobuf:"varint,3,opt,name=rows_per_batch,json=rowsPerBatch,proto3" json:"rows_per_batch,omitempty"`
}

func (m *UnionOperator) Reset()      { *m = UnionOperator{} }
func (*UnionOperator) ProtoMessage() {}
func (*UnionOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{14}
}
func (m *UnionOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UnionOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UnionOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UnionOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnionOperator.Merge(m, src)
}
func (m *UnionOperator) XXX_Size() int {
	return m.Size()
}
func (m *UnionOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_UnionOperator.DiscardUnknown(m)
}

var xxx_messageInfo_UnionOperator proto.InternalMessageInfo

func (m *UnionOperator) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

func (m *UnionOperator) GetColumnMappings() []*UnionOperator_ColumnMapping {
	if m != nil {
		return m.ColumnMappings
	}
	return nil
}

func (m *UnionOperator) GetRowsPerBatch() uint64 {
	if m != nil {
		return m.RowsPerBatch
	}
	return 0
}

type UnionOperator_ColumnMapping struct {
	ColumnIndexes []int64 `protobuf:"varint,1,rep,packed,name=column_indexes,json=columnIndexes,proto3" json:"column_indexes,omitempty"`
}

func (m *UnionOperator_ColumnMapping) Reset()      { *m = UnionOperator_ColumnMapping{} }
func (*UnionOperator_ColumnMapping) ProtoMessage() {}
func (*UnionOperator_ColumnMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{14, 0}
}
func (m *UnionOperator_ColumnMapping) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UnionOperator_ColumnMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UnionOperator_ColumnMapping.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UnionOperator_ColumnMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnionOperator_ColumnMapping.Merge(m, src)
}
func (m *UnionOperator_ColumnMapping) XXX_Size() int {
	return m.Size()
}
func (m *UnionOperator_ColumnMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_UnionOperator_ColumnMapping.DiscardUnknown(m)
}

var xxx_messageInfo_UnionOperator_ColumnMapping proto.InternalMessageInfo

func (m *UnionOperator_ColumnMapping) GetColumnIndexes() []int64 {
	if m != nil {
		return m.ColumnIndexes
	}
	return nil
}

type JoinOperator struct {
	Type               JoinOperator_JoinType             `protobuf:"varint,1,opt,name=type,proto3,enum=px.carnot.planpb.JoinOperator_JoinType" json:"type,omitempty"`
	EqualityConditions []*JoinOperator_EqualityCondition `protobuf:"bytes,2,rep,name=equality_conditions,json=equalityConditions,proto3" json:"equality_conditions,omitempty"`
	OutputColumns      []*JoinOperator_ParentColumn      `protobuf:"bytes,3,rep,name=output_columns,json=outputColumns,proto3" json:"output_columns,omitempty"`
	ColumnNames        []string                          `protobuf:"bytes,4,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
	RowsPerBatch       uint64                            `protobuf:"varint,5,opt,name=rows_per_batch,json=rowsPerBatch,proto3" json:"rows_per_batch,omitempty"`
}

func (m *JoinOperator) Reset()      { *m = JoinOperator{} }
func (*JoinOperator) ProtoMessage() {}
func (*JoinOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{15}
}
func (m *JoinOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JoinOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JoinOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JoinOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JoinOperator.Merge(m, src)
}
func (m *JoinOperator) XXX_Size() int {
	return m.Size()
}
func (m *JoinOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_JoinOperator.DiscardUnknown(m)
}

var xxx_messageInfo_JoinOperator proto.InternalMessageInfo

func (m *JoinOperator) GetType() JoinOperator_JoinType {
	if m != nil {
		return m.Type
	}
	return INNER
}

func (m *JoinOperator) GetEqualityConditions() []*JoinOperator_EqualityCondition {
	if m != nil {
		return m.EqualityConditions
	}
	return nil
}

func (m *JoinOperator) GetOutputColumns() []*JoinOperator_ParentColumn {
	if m != nil {
		return m.OutputColumns
	}
	return nil
}

func (m *JoinOperator) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

func (m *JoinOperator) GetRowsPerBatch() uint64 {
	if m != nil {
		return m.RowsPerBatch
	}
	return 0
}

type JoinOperator_EqualityCondition struct {
	LeftColumnIndex  uint64 `protobuf:"varint,1,opt,name=left_column_index,json=leftColumnIndex,proto3" json:"left_column_index,omitempty"`
	RightColumnIndex uint64 `protobuf:"varint,2,opt,name=right_column_index,json=rightColumnIndex,proto3" json:"right_column_index,omitempty"`
}

func (m *JoinOperator_EqualityCondition) Reset()      { *m = JoinOperator_EqualityCondition{} }
func (*JoinOperator_EqualityCondition) ProtoMessage() {}
func (*JoinOperator_EqualityCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{15, 0}
}
func (m *JoinOperator_EqualityCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JoinOperator_EqualityCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JoinOperator_EqualityCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JoinOperator_EqualityCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JoinOperator_EqualityCondition.Merge(m, src)
}
func (m *JoinOperator_EqualityCondition) XXX_Size() int {
	return m.Size()
}
func (m *JoinOperator_EqualityCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_JoinOperator_EqualityCondition.DiscardUnknown(m)
}

var xxx_messageInfo_JoinOperator_EqualityCondition proto.InternalMessageInfo

func (m *JoinOperator_EqualityCondition) GetLeftColumnIndex() uint64 {
	if m != nil {
		return m.LeftColumnIndex
	}
	return 0
}

func (m *JoinOperator_EqualityCondition) GetRightColumnIndex() uint64 {
	if m != nil {
		return m.RightColumnIndex
	}
	return 0
}

type JoinOperator_ParentColumn struct {
	ParentIndex uint64 `protobuf:"varint,1,opt,name=parent_index,json=parentIndex,proto3" json:"parent_index,omitempty"`
	ColumnIndex uint64 `protobuf:"varint,2,opt,name=column_index,json=columnIndex,proto3" json:"column_index,omitempty"`
}

func (m *JoinOperator_ParentColumn) Reset()      { *m = JoinOperator_ParentColumn{} }
func (*JoinOperator_ParentColumn) ProtoMessage() {}
func (*JoinOperator_ParentColumn) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{15, 1}
}
func (m *JoinOperator_ParentColumn) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JoinOperator_ParentColumn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JoinOperator_ParentColumn.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JoinOperator_ParentColumn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JoinOperator_ParentColumn.Merge(m, src)
}
func (m *JoinOperator_ParentColumn) XXX_Size() int {
	return m.Size()
}
func (m *JoinOperator_ParentColumn) XXX_DiscardUnknown() {
	xxx_messageInfo_JoinOperator_ParentColumn.DiscardUnknown(m)
}

var xxx_messageInfo_JoinOperator_ParentColumn proto.InternalMessageInfo

func (m *JoinOperator_ParentColumn) GetParentIndex() uint64 {
	if m != nil {
		return m.ParentIndex
	}
	return 0
}

func (m *JoinOperator_ParentColumn) GetColumnIndex() uint64 {
	if m != nil {
		return m.ColumnIndex
	}
	return 0
}

type UDTFSourceOperator struct {
	Name      string         `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ArgValues []*ScalarValue `protobuf:"bytes,2,rep,name=arg_values,json=argValues,proto3" json:"arg_values,omitempty"`
}

func (m *UDTFSourceOperator) Reset()      { *m = UDTFSourceOperator{} }
func (*UDTFSourceOperator) ProtoMessage() {}
func (*UDTFSourceOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{16}
}
func (m *UDTFSourceOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UDTFSourceOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UDTFSourceOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UDTFSourceOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UDTFSourceOperator.Merge(m, src)
}
func (m *UDTFSourceOperator) XXX_Size() int {
	return m.Size()
}
func (m *UDTFSourceOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_UDTFSourceOperator.DiscardUnknown(m)
}

var xxx_messageInfo_UDTFSourceOperator proto.InternalMessageInfo

func (m *UDTFSourceOperator) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UDTFSourceOperator) GetArgValues() []*ScalarValue {
	if m != nil {
		return m.ArgValues
	}
	return nil
}

type EmptySourceOperator struct {
	ColumnNames []string           `protobuf:"bytes,1,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
	ColumnTypes []typespb.DataType `protobuf:"varint,2,rep,packed,name=column_types,json=columnTypes,proto3,enum=px.types.DataType" json:"column_types,omitempty"`
}

func (m *EmptySourceOperator) Reset()      { *m = EmptySourceOperator{} }
func (*EmptySourceOperator) ProtoMessage() {}
func (*EmptySourceOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{17}
}
func (m *EmptySourceOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EmptySourceOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EmptySourceOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EmptySourceOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmptySourceOperator.Merge(m, src)
}
func (m *EmptySourceOperator) XXX_Size() int {
	return m.Size()
}
func (m *EmptySourceOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_EmptySourceOperator.DiscardUnknown(m)
}

var xxx_messageInfo_EmptySourceOperator proto.InternalMessageInfo

func (m *EmptySourceOperator) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

func (m *EmptySourceOperator) GetColumnTypes() []typespb.DataType {
	if m != nil {
		return m.ColumnTypes
	}
	return nil
}

type OTelLog struct {
	Attributes              []*OTelAttribute `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes,omitempty"`
	TimeColumnIndex         int64            `protobuf:"varint,2,opt,name=time_column_index,json=timeColumnIndex,proto3" json:"time_column_index,omitempty"`
	ObservedTimeColumnIndex int64            `protobuf:"varint,3,opt,name=observed_time_column_index,json=observedTimeColumnIndex,proto3" json:"observed_time_column_index,omitempty"`
	SeverityNumber          int64            `protobuf:"varint,4,opt,name=severity_number,json=severityNumber,proto3" json:"severity_number,omitempty"`
	SeverityText            string           `protobuf:"bytes,5,opt,name=severity_text,json=severityText,proto3" json:"severity_text,omitempty"`
	BodyColumnIndex         int64            `protobuf:"varint,6,opt,name=body_column_index,json=bodyColumnIndex,proto3" json:"body_column_index,omitempty"`
}

func (m *OTelLog) Reset()      { *m = OTelLog{} }
func (*OTelLog) ProtoMessage() {}
func (*OTelLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{18}
}
func (m *OTelLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelLog.Merge(m, src)
}
func (m *OTelLog) XXX_Size() int {
	return m.Size()
}
func (m *OTelLog) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelLog.DiscardUnknown(m)
}

var xxx_messageInfo_OTelLog proto.InternalMessageInfo

func (m *OTelLog) GetAttributes() []*OTelAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *OTelLog) GetTimeColumnIndex() int64 {
	if m != nil {
		return m.TimeColumnIndex
	}
	return 0
}

func (m *OTelLog) GetObservedTimeColumnIndex() int64 {
	if m != nil {
		return m.ObservedTimeColumnIndex
	}
	return 0
}

func (m *OTelLog) GetSeverityNumber() int64 {
	if m != nil {
		return m.SeverityNumber
	}
	return 0
}

func (m *OTelLog) GetSeverityText() string {
	if m != nil {
		return m.SeverityText
	}
	return ""
}

func (m *OTelLog) GetBodyColumnIndex() int64 {
	if m != nil {
		return m.BodyColumnIndex
	}
	return 0
}

type OTelSpan struct {
	// Types that are valid to be assigned to Name:
	//
	//	*OTelSpan_NameString
	//	*OTelSpan_NameColumnIndex
	Name                 isOTelSpan_Name  `protobuf_oneof:"name"`
	Attributes           []*OTelAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	TraceIDColumn        int64            `protobuf:"varint,4,opt,name=trace_id_column_index,json=traceIdColumnIndex,proto3" json:"trace_id_column_index,omitempty"`
	SpanIDColumn         int64            `protobuf:"varint,5,opt,name=span_id_column_index,json=spanIdColumnIndex,proto3" json:"span_id_column_index,omitempty"`
	ParentSpanIDColumn   int64            `protobuf:"varint,6,opt,name=parent_span_id_column_index,json=parentSpanIdColumnIndex,proto3" json:"parent_span_id_column_index,omitempty"`
	StartTimeColumnIndex int64            `protobuf:"varint,7,opt,name=start_time_column_index,json=startTimeColumnIndex,proto3" json:"start_time_column_index,omitempty"`
	EndTimeColumnIndex   int64            `protobuf:"varint,8,opt,name=end_time_column_index,json=endTimeColumnIndex,proto3" json:"end_time_column_index,omitempty"`
	KindValue            int64            `protobuf:"varint,9,opt,name=kind_value,json=kindValue,proto3" json:"kind_value,omitempty"`
}

func (m *OTelSpan) Reset()      { *m = OTelSpan{} }
func (*OTelSpan) ProtoMessage() {}
func (*OTelSpan) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{19}
}
func (m *OTelSpan) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelSpan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelSpan.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelSpan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelSpan.Merge(m, src)
}
func (m *OTelSpan) XXX_Size() int {
	return m.Size()
}
func (m *OTelSpan) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelSpan.DiscardUnknown(m)
}

var xxx_messageInfo_OTelSpan proto.InternalMessageInfo

type isOTelSpan_Name interface {
	isOTelSpan_Name()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type OTelSpan_NameString struct {
	NameString string `protobuf:"bytes,1,opt,name=name_string,json=nameString,proto3,oneof" json:"name_string,omitempty"`
}
type OTelSpan_NameColumnIndex struct {
	NameColumnIndex int64 `protobuf:"varint,2,opt,name=name_column_index,json=nameColumnIndex,proto3,oneof" json:"name_column_index,omitempty"`
}

func (*OTelSpan_NameString) isOTelSpan_Name()      {}
func (*OTelSpan_NameColumnIndex) isOTelSpan_Name() {}

func (m *OTelSpan) GetName() isOTelSpan_Name {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *OTelSpan) GetNameString() string {
	if x, ok := m.GetName().(*OTelSpan_NameString); ok {
		return x.NameString
	}
	return ""
}

func (m *OTelSpan) GetNameColumnIndex() int64 {
	if x, ok := m.GetName().(*OTelSpan_NameColumnIndex); ok {
		return x.NameColumnIndex
	}
	return 0
}

func (m *OTelSpan) GetAttributes() []*OTelAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *OTelSpan) GetTraceIDColumn() int64 {
	if m != nil {
		return m.TraceIDColumn
	}
	return 0
}

func (m *OTelSpan) GetSpanIDColumn() int64 {
	if m != nil {
		return m.SpanIDColumn
	}
	return 0
}

func (m *OTelSpan) GetParentSpanIDColumn() int64 {
	if m != nil {
		return m.ParentSpanIDColumn
	}
	return 0
}

func (m *OTelSpan) GetStartTimeColumnIndex() int64 {
	if m != nil {
		return m.StartTimeColumnIndex
	}
	return 0
}

func (m *OTelSpan) GetEndTimeColumnIndex() int64 {
	if m != nil {
		return m.EndTimeColumnIndex
	}
	return 0
}

func (m *OTelSpan) GetKindValue() int64 {
	if m != nil {
		return m.KindValue
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OTelSpan) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OTelSpan_NameString)(nil),
		(*OTelSpan_NameColumnIndex)(nil),
	}
}

type OTelMetricGauge struct {
	// Types that are valid to be assigned to ValueColumn:
	//
	//	*OTelMetricGauge_FloatColumnIndex
	//	*OTelMetricGauge_IntColumnIndex
	ValueColumn isOTelMetricGauge_ValueColumn `protobuf_oneof:"value_column"`
}

func (m *OTelMetricGauge) Reset()      { *m = OTelMetricGauge{} }
func (*OTelMetricGauge) ProtoMessage() {}
func (*OTelMetricGauge) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{20}
}
func (m *OTelMetricGauge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelMetricGauge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelMetricGauge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelMetricGauge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelMetricGauge.Merge(m, src)
}
func (m *OTelMetricGauge) XXX_Size() int {
	return m.Size()
}
func (m *OTelMetricGauge) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelMetricGauge.DiscardUnknown(m)
}

var xxx_messageInfo_OTelMetricGauge proto.InternalMessageInfo

type isOTelMetricGauge_ValueColumn interface {
	isOTelMetricGauge_ValueColumn()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type OTelMetricGauge_FloatColumnIndex struct {
	FloatColumnIndex int64 `protobuf:"varint,1,opt,name=float_column_index,json=floatColumnIndex,proto3,oneof" json:"float_column_index,omitempty"`
}
type OTelMetricGauge_IntColumnIndex struct {
	IntColumnIndex int64 `protobuf:"varint,2,opt,name=int_column_index,json=intColumnIndex,proto3,oneof" json:"int_column_index,omitempty"`
}

func (*OTelMetricGauge_FloatColumnIndex) isOTelMetricGauge_ValueColumn() {}
func (*OTelMetricGauge_IntColumnIndex) isOTelMetricGauge_ValueColumn()   {}

func (m *OTelMetricGauge) GetValueColumn() isOTelMetricGauge_ValueColumn {
	if m != nil {
		return m.ValueColumn
	}
	return nil
}

func (m *OTelMetricGauge) GetFloatColumnIndex() int64 {
	if x, ok := m.GetValueColumn().(*OTelMetricGauge_FloatColumnIndex); ok {
		return x.FloatColumnIndex
	}
	return 0
}

func (m *OTelMetricGauge) GetIntColumnIndex() int64 {
	if x, ok := m.GetValueColumn().(*OTelMetricGauge_IntColumnIndex); ok {
		return x.IntColumnIndex
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OTelMetricGauge) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OTelMetricGauge_FloatColumnIndex)(nil),
		(*OTelMetricGauge_IntColumnIndex)(nil),
	}
}

type OTelMetricSummary struct {
	CountColumnIndex int64                                `protobuf:"varint,1,opt,name=count_column_index,json=countColumnIndex,proto3" json:"count_column_index,omitempty"`
	SumColumnIndex   int64                                `protobuf:"varint,2,opt,name=sum_column_index,json=sumColumnIndex,proto3" json:"sum_column_index,omitempty"`
	QuantileValues   []*OTelMetricSummary_ValueAtQuantile `protobuf:"bytes,3,rep,name=quantile_values,json=quantileValues,proto3" json:"quantile_values,omitempty"`
}

func (m *OTelMetricSummary) Reset()      { *m = OTelMetricSummary{} }
func (*OTelMetricSummary) ProtoMessage() {}
func (*OTelMetricSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{21}
}
func (m *OTelMetricSummary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelMetricSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelMetricSummary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelMetricSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelMetricSummary.Merge(m, src)
}
func (m *OTelMetricSummary) XXX_Size() int {
	return m.Size()
}
func (m *OTelMetricSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelMetricSummary.DiscardUnknown(m)
}

var xxx_messageInfo_OTelMetricSummary proto.InternalMessageInfo

func (m *OTelMetricSummary) GetCountColumnIndex() int64 {
	if m != nil {
		return m.CountColumnIndex
	}
	return 0
}

func (m *OTelMetricSummary) GetSumColumnIndex() int64 {
	if m != nil {
		return m.SumColumnIndex
	}
	return 0
}

func (m *OTelMetricSummary) GetQuantileValues() []*OTelMetricSummary_ValueAtQuantile {
	if m != nil {
		return m.QuantileValues
	}
	return nil
}

type OTelMetricSummary_ValueAtQuantile struct {
	Quantile         float64 `protobuf:"fixed64,1,opt,name=quantile,proto3" json:"quantile,omitempty"`
	ValueColumnIndex int64   `protobuf:"varint,2,opt,name=value_column_index,json=valueColumnIndex,proto3" json:"value_column_index,omitempty"`
}

func (m *OTelMetricSummary_ValueAtQuantile) Reset()      { *m = OTelMetricSummary_ValueAtQuantile{} }
func (*OTelMetricSummary_ValueAtQuantile) ProtoMessage() {}
func (*OTelMetricSummary_ValueAtQuantile) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{21, 0}
}
func (m *OTelMetricSummary_ValueAtQuantile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelMetricSummary_ValueAtQuantile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelMetricSummary_ValueAtQuantile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelMetricSummary_ValueAtQuantile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelMetricSummary_ValueAtQuantile.Merge(m, src)
}
func (m *OTelMetricSummary_ValueAtQuantile) XXX_Size() int {
	return m.Size()
}
func (m *OTelMetricSummary_ValueAtQuantile) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelMetricSummary_ValueAtQuantile.DiscardUnknown(m)
}

var xxx_messageInfo_OTelMetricSummary_ValueAtQuantile proto.InternalMessageInfo

func (m *OTelMetricSummary_ValueAtQuantile) GetQuantile() float64 {
	if m != nil {
		return m.Quantile
	}
	return 0
}

func (m *OTelMetricSummary_ValueAtQuantile) GetValueColumnIndex() int64 {
	if m != nil {
		return m.ValueColumnIndex
	}
	return 0
}

type OTelAttribute struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to Value:
	//
	//	*OTelAttribute_Column_
	//	*OTelAttribute_StringValue
	Value isOTelAttribute_Value `protobuf_oneof:"value"`
}

func (m *OTelAttribute) Reset()      { *m = OTelAttribute{} }
func (*OTelAttribute) ProtoMessage() {}
func (*OTelAttribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{22}
}
func (m *OTelAttribute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelAttribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelAttribute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelAttribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelAttribute.Merge(m, src)
}
func (m *OTelAttribute) XXX_Size() int {
	return m.Size()
}
func (m *OTelAttribute) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelAttribute.DiscardUnknown(m)
}

var xxx_messageInfo_OTelAttribute proto.InternalMessageInfo

type isOTelAttribute_Value interface {
	isOTelAttribute_Value()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type OTelAttribute_Column_ struct {
	Column *OTelAttribute_Column `protobuf:"bytes,2,opt,name=column,proto3,oneof" json:"column,omitempty"`
}
type OTelAttribute_StringValue struct {
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof" json:"string_value,omitempty"`
}

func (*OTelAttribute_Column_) isOTelAttribute_Value()     {}
func (*OTelAttribute_StringValue) isOTelAttribute_Value() {}

func (m *OTelAttribute) GetValue() isOTelAttribute_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *OTelAttribute) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *OTelAttribute) GetColumn() *OTelAttribute_Column {
	if x, ok := m.GetValue().(*OTelAttribute_Column_); ok {
		return x.Column
	}
	return nil
}

func (m *OTelAttribute) GetStringValue() string {
	if x, ok := m.GetValue().(*OTelAttribute_StringValue); ok {
		return x.StringValue
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OTelAttribute) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OTelAttribute_Column_)(nil),
		(*OTelAttribute_StringValue)(nil),
	}
}

type OTelAttribute_Column struct {
	ColumnType            typespb.DataType `protobuf:"varint,1,opt,name=column_type,json=columnType,proto3,enum=px.types.DataType" json:"column_type,omitempty"`
	ColumnIndex           int64            `protobuf:"varint,2,opt,name=column_index,json=columnIndex,proto3" json:"column_index,omitempty"`
	CanBeJsonEncodedArray bool             `protobuf:"varint,3,opt,name=can_be_json_encoded_array,json=canBeJsonEncodedArray,proto3" json:"can_be_json_encoded_array,omitempty"`
}

func (m *OTelAttribute_Column) Reset()      { *m = OTelAttribute_Column{} }
func (*OTelAttribute_Column) ProtoMessage() {}
func (*OTelAttribute_Column) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{22, 0}
}
func (m *OTelAttribute_Column) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelAttribute_Column) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelAttribute_Column.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelAttribute_Column) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelAttribute_Column.Merge(m, src)
}
func (m *OTelAttribute_Column) XXX_Size() int {
	return m.Size()
}
func (m *OTelAttribute_Column) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelAttribute_Column.DiscardUnknown(m)
}

var xxx_messageInfo_OTelAttribute_Column proto.InternalMessageInfo

func (m *OTelAttribute_Column) GetColumnType() typespb.DataType {
	if m != nil {
		return m.ColumnType
	}
	return typespb.DATA_TYPE_UNKNOWN
}

func (m *OTelAttribute_Column) GetColumnIndex() int64 {
	if m != nil {
		return m.ColumnIndex
	}
	return 0
}

func (m *OTelAttribute_Column) GetCanBeJsonEncodedArray() bool {
	if m != nil {
		return m.CanBeJsonEncodedArray
	}
	return false
}

type OTelMetric struct {
	Name            string           `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Description     string           `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	Unit            string           `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	Attributes      []*OTelAttribute `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes,omitempty"`
	TimeColumnIndex int64            `protobuf:"varint,5,opt,name=time_column_index,json=timeColumnIndex,proto3" json:"time_column_index,omitempty"`
	// Types that are valid to be assigned to Data:
	//
	//	*OTelMetric_Gauge
	//	*OTelMetric_Summary
	Data isOTelMetric_Data `protobuf_oneof:"data"`
}

func (m *OTelMetric) Reset()      { *m = OTelMetric{} }
func (*OTelMetric) ProtoMessage() {}
func (*OTelMetric) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{23}
}
func (m *OTelMetric) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelMetric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelMetric.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelMetric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelMetric.Merge(m, src)
}
func (m *OTelMetric) XXX_Size() int {
	return m.Size()
}
func (m *OTelMetric) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelMetric.DiscardUnknown(m)
}

var xxx_messageInfo_OTelMetric proto.InternalMessageInfo

type isOTelMetric_Data interface {
	isOTelMetric_Data()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type OTelMetric_Gauge struct {
	Gauge *OTelMetricGauge `protobuf:"bytes,101,opt,name=gauge,proto3,oneof" json:"gauge,omitempty"`
}
type OTelMetric_Summary struct {
	Summary *OTelMetricSummary `protobuf:"bytes,102,opt,name=summary,proto3,oneof" json:"summary,omitempty"`
}

func (*OTelMetric_Gauge) isOTelMetric_Data()   {}
func (*OTelMetric_Summary) isOTelMetric_Data() {}

func (m *OTelMetric) GetData() isOTelMetric_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *OTelMetric) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *OTelMetric) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *OTelMetric) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

func (m *OTelMetric) GetAttributes() []*OTelAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *OTelMetric) GetTimeColumnIndex() int64 {
	if m != nil {
		return m.TimeColumnIndex
	}
	return 0
}

func (m *OTelMetric) GetGauge() *OTelMetricGauge {
	if x, ok := m.GetData().(*OTelMetric_Gauge); ok {
		return x.Gauge
	}
	return nil
}

func (m *OTelMetric) GetSummary() *OTelMetricSummary {
	if x, ok := m.GetData().(*OTelMetric_Summary); ok {
		return x.Summary
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OTelMetric) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OTelMetric_Gauge)(nil),
		(*OTelMetric_Summary)(nil),
	}
}

type OTelEndpointConfig struct {
	URL      string            `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	Headers  map[string]string `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Insecure bool              `protobuf:"varint,3,opt,name=insecure,proto3" json:"insecure,omitempty"`
	Timeout  int64             `protobuf:"varint,4,opt,name=timeout,proto3" json:"timeout,omitempty"`
}

func (m *OTelEndpointConfig) Reset()      { *m = OTelEndpointConfig{} }
func (*OTelEndpointConfig) ProtoMessage() {}
func (*OTelEndpointConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{24}
}
func (m *OTelEndpointConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelEndpointConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelEndpointConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelEndpointConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelEndpointConfig.Merge(m, src)
}
func (m *OTelEndpointConfig) XXX_Size() int {
	return m.Size()
}
func (m *OTelEndpointConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelEndpointConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OTelEndpointConfig proto.InternalMessageInfo

func (m *OTelEndpointConfig) GetURL() string {
	if m != nil {
		return m.URL
	}
	return ""
}

func (m *OTelEndpointConfig) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *OTelEndpointConfig) GetInsecure() bool {
	if m != nil {
		return m.Insecure
	}
	return false
}

func (m *OTelEndpointConfig) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

type OTelResource struct {
	Attributes []*OTelAttribute `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes,omitempty"`
}

func (m *OTelResource) Reset()      { *m = OTelResource{} }
func (*OTelResource) ProtoMessage() {}
func (*OTelResource) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{25}
}
func (m *OTelResource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelResource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelResource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelResource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelResource.Merge(m, src)
}
func (m *OTelResource) XXX_Size() int {
	return m.Size()
}
func (m *OTelResource) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelResource.DiscardUnknown(m)
}

var xxx_messageInfo_OTelResource proto.InternalMessageInfo

func (m *OTelResource) GetAttributes() []*OTelAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

type OTelExportSinkOperator struct {
	EndpointConfig *OTelEndpointConfig `protobuf:"bytes,1,opt,name=endpoint_config,json=endpointConfig,proto3" json:"endpoint_config,omitempty"`
	Resource       *OTelResource       `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	Metrics        []*OTelMetric       `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	Spans          []*OTelSpan         `protobuf:"bytes,4,rep,name=spans,proto3" json:"spans,omitempty"`
	Logs           []*OTelLog          `protobuf:"bytes,5,rep,name=logs,proto3" json:"logs,omitempty"`
}

func (m *OTelExportSinkOperator) Reset()      { *m = OTelExportSinkOperator{} }
func (*OTelExportSinkOperator) ProtoMessage() {}
func (*OTelExportSinkOperator) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{26}
}
func (m *OTelExportSinkOperator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OTelExportSinkOperator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OTelExportSinkOperator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OTelExportSinkOperator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OTelExportSinkOperator.Merge(m, src)
}
func (m *OTelExportSinkOperator) XXX_Size() int {
	return m.Size()
}
func (m *OTelExportSinkOperator) XXX_DiscardUnknown() {
	xxx_messageInfo_OTelExportSinkOperator.DiscardUnknown(m)
}

var xxx_messageInfo_OTelExportSinkOperator proto.InternalMessageInfo

func (m *OTelExportSinkOperator) GetEndpointConfig() *OTelEndpointConfig {
	if m != nil {
		return m.EndpointConfig
	}
	return nil
}

func (m *OTelExportSinkOperator) GetResource() *OTelResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *OTelExportSinkOperator) GetMetrics() []*OTelMetric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *OTelExportSinkOperator) GetSpans() []*OTelSpan {
	if m != nil {
		return m.Spans
	}
	return nil
}

func (m *OTelExportSinkOperator) GetLogs() []*OTelLog {
	if m != nil {
		return m.Logs
	}
	return nil
}

type ScalarExpression struct {
	// Types that are valid to be assigned to Value:
	//
	//	*ScalarExpression_Constant
	//	*ScalarExpression_Column
	//	*ScalarExpression_Func
	Value isScalarExpression_Value `protobuf_oneof:"value"`
}

func (m *ScalarExpression) Reset()      { *m = ScalarExpression{} }
func (*ScalarExpression) ProtoMessage() {}
func (*ScalarExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{27}
}
func (m *ScalarExpression) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScalarExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScalarExpression.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScalarExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalarExpression.Merge(m, src)
}
func (m *ScalarExpression) XXX_Size() int {
	return m.Size()
}
func (m *ScalarExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalarExpression.DiscardUnknown(m)
}

var xxx_messageInfo_ScalarExpression proto.InternalMessageInfo

type isScalarExpression_Value interface {
	isScalarExpression_Value()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type ScalarExpression_Constant struct {
	Constant *ScalarValue `protobuf:"bytes,1,opt,name=constant,proto3,oneof" json:"constant,omitempty"`
}
type ScalarExpression_Column struct {
	Column *Column `protobuf:"bytes,2,opt,name=column,proto3,oneof" json:"column,omitempty"`
}
type ScalarExpression_Func struct {
	Func *ScalarFunc `protobuf:"bytes,3,opt,name=func,proto3,oneof" json:"func,omitempty"`
}

func (*ScalarExpression_Constant) isScalarExpression_Value() {}
func (*ScalarExpression_Column) isScalarExpression_Value()   {}
func (*ScalarExpression_Func) isScalarExpression_Value()     {}

func (m *ScalarExpression) GetValue() isScalarExpression_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ScalarExpression) GetConstant() *ScalarValue {
	if x, ok := m.GetValue().(*ScalarExpression_Constant); ok {
		return x.Constant
	}
	return nil
}

func (m *ScalarExpression) GetColumn() *Column {
	if x, ok := m.GetValue().(*ScalarExpression_Column); ok {
		return x.Column
	}
	return nil
}

func (m *ScalarExpression) GetFunc() *ScalarFunc {
	if x, ok := m.GetValue().(*ScalarExpression_Func); ok {
		return x.Func
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScalarExpression) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScalarExpression_Constant)(nil),
		(*ScalarExpression_Column)(nil),
		(*ScalarExpression_Func)(nil),
	}
}

type ScalarValue struct {
	DataType typespb.DataType `protobuf:"varint,1,opt,name=data_type,json=dataType,proto3,enum=px.types.DataType" json:"data_type,omitempty"`
	// Types that are valid to be assigned to Value:
	//
	//	*ScalarValue_BoolValue
	//	*ScalarValue_Int64Value
	//	*ScalarValue_Float64Value
	//	*ScalarValue_StringValue
	//	*ScalarValue_Time64NsValue
	//	*ScalarValue_Uint128Value
	Value isScalarValue_Value `protobuf_oneof:"value"`
}

func (m *ScalarValue) Reset()      { *m = ScalarValue{} }
func (*ScalarValue) ProtoMessage() {}
func (*ScalarValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{28}
}
func (m *ScalarValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScalarValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScalarValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScalarValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalarValue.Merge(m, src)
}
func (m *ScalarValue) XXX_Size() int {
	return m.Size()
}
func (m *ScalarValue) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalarValue.DiscardUnknown(m)
}

var xxx_messageInfo_ScalarValue proto.InternalMessageInfo

type isScalarValue_Value interface {
	isScalarValue_Value()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type ScalarValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3,oneof" json:"bool_value,omitempty"`
}
type ScalarValue_Int64Value struct {
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof" json:"int64_value,omitempty"`
}
type ScalarValue_Float64Value struct {
	Float64Value float64 `protobuf:"fixed64,4,opt,name=float64_value,json=float64Value,proto3,oneof" json:"float64_value,omitempty"`
}
type ScalarValue_StringValue struct {
	StringValue string `protobuf:"bytes,5,opt,name=string_value,json=stringValue,proto3,oneof" json:"string_value,omitempty"`
}
type ScalarValue_Time64NsValue struct {
	Time64NsValue int64 `protobuf:"varint,6,opt,name=time64_ns_value,json=time64NsValue,proto3,oneof" json:"time64_ns_value,omitempty"`
}
type ScalarValue_Uint128Value struct {
	Uint128Value *typespb.UInt128 `protobuf:"bytes,7,opt,name=uint128_value,json=uint128Value,proto3,oneof" json:"uint128_value,omitempty"`
}

func (*ScalarValue_BoolValue) isScalarValue_Value()     {}
func (*ScalarValue_Int64Value) isScalarValue_Value()    {}
func (*ScalarValue_Float64Value) isScalarValue_Value()  {}
func (*ScalarValue_StringValue) isScalarValue_Value()   {}
func (*ScalarValue_Time64NsValue) isScalarValue_Value() {}
func (*ScalarValue_Uint128Value) isScalarValue_Value()  {}

func (m *ScalarValue) GetValue() isScalarValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ScalarValue) GetDataType() typespb.DataType {
	if m != nil {
		return m.DataType
	}
	return typespb.DATA_TYPE_UNKNOWN
}

func (m *ScalarValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*ScalarValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *ScalarValue) GetInt64Value() int64 {
	if x, ok := m.GetValue().(*ScalarValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *ScalarValue) GetFloat64Value() float64 {
	if x, ok := m.GetValue().(*ScalarValue_Float64Value); ok {
		return x.Float64Value
	}
	return 0
}

func (m *ScalarValue) GetStringValue() string {
	if x, ok := m.GetValue().(*ScalarValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *ScalarValue) GetTime64NsValue() int64 {
	if x, ok := m.GetValue().(*ScalarValue_Time64NsValue); ok {
		return x.Time64NsValue
	}
	return 0
}

func (m *ScalarValue) GetUint128Value() *typespb.UInt128 {
	if x, ok := m.GetValue().(*ScalarValue_Uint128Value); ok {
		return x.Uint128Value
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScalarValue) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScalarValue_BoolValue)(nil),
		(*ScalarValue_Int64Value)(nil),
		(*ScalarValue_Float64Value)(nil),
		(*ScalarValue_StringValue)(nil),
		(*ScalarValue_Time64NsValue)(nil),
		(*ScalarValue_Uint128Value)(nil),
	}
}

type ScalarFunc struct {
	Name          string              `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	InitArgs      []*ScalarValue      `protobuf:"bytes,2,rep,name=init_args,json=initArgs,proto3" json:"init_args,omitempty"`
	Args          []*ScalarExpression `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	Id            int64               `protobuf:"varint,4,opt,name=id,proto3" json:"id,omitempty"`
	ArgsDataTypes []typespb.DataType  `protobuf:"varint,5,rep,packed,name=args_data_types,json=argsDataTypes,proto3,enum=px.types.DataType" json:"args_data_types,omitempty"`
}

func (m *ScalarFunc) Reset()      { *m = ScalarFunc{} }
func (*ScalarFunc) ProtoMessage() {}
func (*ScalarFunc) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{29}
}
func (m *ScalarFunc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScalarFunc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScalarFunc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScalarFunc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalarFunc.Merge(m, src)
}
func (m *ScalarFunc) XXX_Size() int {
	return m.Size()
}
func (m *ScalarFunc) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalarFunc.DiscardUnknown(m)
}

var xxx_messageInfo_ScalarFunc proto.InternalMessageInfo

func (m *ScalarFunc) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ScalarFunc) GetInitArgs() []*ScalarValue {
	if m != nil {
		return m.InitArgs
	}
	return nil
}

func (m *ScalarFunc) GetArgs() []*ScalarExpression {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *ScalarFunc) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ScalarFunc) GetArgsDataTypes() []typespb.DataType {
	if m != nil {
		return m.ArgsDataTypes
	}
	return nil
}

type AggregateExpression struct {
	Name          string                     `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	InitArgs      []*ScalarValue             `protobuf:"bytes,4,rep,name=init_args,json=initArgs,proto3" json:"init_args,omitempty"`
	Args          []*AggregateExpression_Arg `protobuf:"bytes,5,rep,name=args,proto3" json:"args,omitempty"`
	Id            int64                      `protobuf:"varint,6,opt,name=id,proto3" json:"id,omitempty"`
	ArgsDataTypes []typespb.DataType         `protobuf:"varint,7,rep,packed,name=args_data_types,json=argsDataTypes,proto3,enum=px.types.DataType" json:"args_data_types,omitempty"`
}

func (m *AggregateExpression) Reset()      { *m = AggregateExpression{} }
func (*AggregateExpression) ProtoMessage() {}
func (*AggregateExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{30}
}
func (m *AggregateExpression) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AggregateExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AggregateExpression.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AggregateExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AggregateExpression.Merge(m, src)
}
func (m *AggregateExpression) XXX_Size() int {
	return m.Size()
}
func (m *AggregateExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_AggregateExpression.DiscardUnknown(m)
}

var xxx_messageInfo_AggregateExpression proto.InternalMessageInfo

func (m *AggregateExpression) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AggregateExpression) GetInitArgs() []*ScalarValue {
	if m != nil {
		return m.InitArgs
	}
	return nil
}

func (m *AggregateExpression) GetArgs() []*AggregateExpression_Arg {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *AggregateExpression) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *AggregateExpression) GetArgsDataTypes() []typespb.DataType {
	if m != nil {
		return m.ArgsDataTypes
	}
	return nil
}

type AggregateExpression_Arg struct {
	// Types that are valid to be assigned to Value:
	//
	//	*AggregateExpression_Arg_Constant
	//	*AggregateExpression_Arg_Column
	Value isAggregateExpression_Arg_Value `protobuf_oneof:"value"`
}

func (m *AggregateExpression_Arg) Reset()      { *m = AggregateExpression_Arg{} }
func (*AggregateExpression_Arg) ProtoMessage() {}
func (*AggregateExpression_Arg) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{30, 0}
}
func (m *AggregateExpression_Arg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AggregateExpression_Arg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AggregateExpression_Arg.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AggregateExpression_Arg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AggregateExpression_Arg.Merge(m, src)
}
func (m *AggregateExpression_Arg) XXX_Size() int {
	return m.Size()
}
func (m *AggregateExpression_Arg) XXX_DiscardUnknown() {
	xxx_messageInfo_AggregateExpression_Arg.DiscardUnknown(m)
}

var xxx_messageInfo_AggregateExpression_Arg proto.InternalMessageInfo

type isAggregateExpression_Arg_Value interface {
	isAggregateExpression_Arg_Value()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type AggregateExpression_Arg_Constant struct {
	Constant *ScalarValue `protobuf:"bytes,1,opt,name=constant,proto3,oneof" json:"constant,omitempty"`
}
type AggregateExpression_Arg_Column struct {
	Column *Column `protobuf:"bytes,2,opt,name=column,proto3,oneof" json:"column,omitempty"`
}

func (*AggregateExpression_Arg_Constant) isAggregateExpression_Arg_Value() {}
func (*AggregateExpression_Arg_Column) isAggregateExpression_Arg_Value()   {}

func (m *AggregateExpression_Arg) GetValue() isAggregateExpression_Arg_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *AggregateExpression_Arg) GetConstant() *ScalarValue {
	if x, ok := m.GetValue().(*AggregateExpression_Arg_Constant); ok {
		return x.Constant
	}
	return nil
}

func (m *AggregateExpression_Arg) GetColumn() *Column {
	if x, ok := m.GetValue().(*AggregateExpression_Arg_Column); ok {
		return x.Column
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AggregateExpression_Arg) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AggregateExpression_Arg_Constant)(nil),
		(*AggregateExpression_Arg_Column)(nil),
	}
}

type Column struct {
	Node  uint64 `protobuf:"varint,1,opt,name=node,proto3" json:"node,omitempty"`
	Index uint64 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (m *Column) Reset()      { *m = Column{} }
func (*Column) ProtoMessage() {}
func (*Column) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5dcfc8666ec3f33, []int{31}
}
func (m *Column) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Column) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Column.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Column) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Column.Merge(m, src)
}
func (m *Column) XXX_Size() int {
	return m.Size()
}
func (m *Column) XXX_DiscardUnknown() {
	xxx_messageInfo_Column.DiscardUnknown(m)
}

var xxx_messageInfo_Column proto.InternalMessageInfo

func (m *Column) GetNode() uint64 {
	if m != nil {
		return m.Node
	}
	return 0
}

func (m *Column) GetIndex() uint64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func init() {
	proto.RegisterEnum("px.carnot.planpb.OperatorType", OperatorType_name, OperatorType_value)
	proto.RegisterEnum("px.carnot.planpb.JoinOperator_JoinType", JoinOperator_JoinType_name, JoinOperator_JoinType_value)
	proto.RegisterType((*PlanOptions)(nil), "px.carnot.planpb.PlanOptions")
	proto.RegisterType((*Plan)(nil), "px.carnot.planpb.Plan")
	proto.RegisterType((*Plan_ExecutionStatusDestination)(nil), "px.carnot.planpb.Plan.ExecutionStatusDestination")
	proto.RegisterType((*PlanFragment)(nil), "px.carnot.planpb.PlanFragment")
	proto.RegisterType((*DAG)(nil), "px.carnot.planpb.DAG")
	proto.RegisterType((*DAG_DAGNode)(nil), "px.carnot.planpb.DAG.DAGNode")
	proto.RegisterType((*PlanNode)(nil), "px.carnot.planpb.PlanNode")
	proto.RegisterType((*Operator)(nil), "px.carnot.planpb.Operator")
	proto.RegisterType((*MemorySourceOperator)(nil), "px.carnot.planpb.MemorySourceOperator")
	proto.RegisterType((*MemorySinkOperator)(nil), "px.carnot.planpb.MemorySinkOperator")
	proto.RegisterType((*GRPCSourceOperator)(nil), "px.carnot.planpb.GRPCSourceOperator")
	proto.RegisterType((*GRPCSinkOperator)(nil), "px.carnot.planpb.GRPCSinkOperator")
	proto.RegisterType((*GRPCSinkOperator_ResultTable)(nil), "px.carnot.planpb.GRPCSinkOperator.ResultTable")
	proto.RegisterType((*GRPCSinkOperator_GRPCConnectionOptions)(nil), "px.carnot.planpb.GRPCSinkOperator.GRPCConnectionOptions")
	proto.RegisterType((*MapOperator)(nil), "px.carnot.planpb.MapOperator")
	proto.RegisterType((*AggregateOperator)(nil), "px.carnot.planpb.AggregateOperator")
	proto.RegisterType((*FilterOperator)(nil), "px.carnot.planpb.FilterOperator")
	proto.RegisterType((*LimitOperator)(nil), "px.carnot.planpb.LimitOperator")
	proto.RegisterType((*UnionOperator)(nil), "px.carnot.planpb.UnionOperator")
	proto.RegisterType((*UnionOperator_ColumnMapping)(nil), "px.carnot.planpb.UnionOperator.ColumnMapping")
	proto.RegisterType((*JoinOperator)(nil), "px.carnot.planpb.JoinOperator")
	proto.RegisterType((*JoinOperator_EqualityCondition)(nil), "px.carnot.planpb.JoinOperator.EqualityCondition")
	proto.RegisterType((*JoinOperator_ParentColumn)(nil), "px.carnot.planpb.JoinOperator.ParentColumn")
	proto.RegisterType((*UDTFSourceOperator)(nil), "px.carnot.planpb.UDTFSourceOperator")
	proto.RegisterType((*EmptySourceOperator)(nil), "px.carnot.planpb.EmptySourceOperator")
	proto.RegisterType((*OTelLog)(nil), "px.carnot.planpb.OTelLog")
	proto.RegisterType((*OTelSpan)(nil), "px.carnot.planpb.OTelSpan")
	proto.RegisterType((*OTelMetricGauge)(nil), "px.carnot.planpb.OTelMetricGauge")
	proto.RegisterType((*OTelMetricSummary)(nil), "px.carnot.planpb.OTelMetricSummary")
	proto.RegisterType((*OTelMetricSummary_ValueAtQuantile)(nil), "px.carnot.planpb.OTelMetricSummary.ValueAtQuantile")
	proto.RegisterType((*OTelAttribute)(nil), "px.carnot.planpb.OTelAttribute")
	proto.RegisterType((*OTelAttribute_Column)(nil), "px.carnot.planpb.OTelAttribute.Column")
	proto.RegisterType((*OTelMetric)(nil), "px.carnot.planpb.OTelMetric")
	proto.RegisterType((*OTelEndpointConfig)(nil), "px.carnot.planpb.OTelEndpointConfig")
	proto.RegisterMapType((map[string]string)(nil), "px.carnot.planpb.OTelEndpointConfig.HeadersEntry")
	proto.RegisterType((*OTelResource)(nil), "px.carnot.planpb.OTelResource")
	proto.RegisterType((*OTelExportSinkOperator)(nil), "px.carnot.planpb.OTelExportSinkOperator")
	proto.RegisterType((*ScalarExpression)(nil), "px.carnot.planpb.ScalarExpression")
	proto.RegisterType((*ScalarValue)(nil), "px.carnot.planpb.ScalarValue")
	proto.RegisterType((*ScalarFunc)(nil), "px.carnot.planpb.ScalarFunc")
	proto.RegisterType((*AggregateExpression)(nil), "px.carnot.planpb.AggregateExpression")
	proto.RegisterType((*AggregateExpression_Arg)(nil), "px.carnot.planpb.AggregateExpression.Arg")
	proto.RegisterType((*Column)(nil), "px.carnot.planpb.Column")
}

func init() { proto.RegisterFile("src/carnot/planpb/plan.proto", fileDescriptor_e5dcfc8666ec3f33) }

var fileDescriptor_e5dcfc8666ec3f33 = []byte{
	// 3294 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x39, 0x4b, 0x6c, 0x1b, 0xc7,
	0xd9, 0x5c, 0x92, 0xe2, 0xe3, 0xe3, 0x53, 0x63, 0xc9, 0x96, 0x69, 0x9b, 0x72, 0x18, 0xfb, 0xb7,
	0xe2, 0x3f, 0xa1, 0x6c, 0xd9, 0xf1, 0xef, 0x38, 0xce, 0x9f, 0x50, 0x12, 0x25, 0x51, 0x91, 0x44,
	0x75, 0x44, 0x25, 0x4d, 0x1b, 0x74, 0xb1, 0xe2, 0x8e, 0xd6, 0x1b, 0x93, 0xbb, 0x9b, 0x7d, 0xd8,
	0x52, 0x80, 0xa2, 0x29, 0x7a, 0xe9, 0x21, 0x87, 0x1e, 0x7a, 0x28, 0x7a, 0x6f, 0x91, 0x4b, 0x8b,
	0x1c, 0x7a, 0xec, 0xa1, 0x05, 0x0a, 0xa4, 0x87, 0x22, 0x70, 0x7b, 0xca, 0xc9, 0x88, 0x95, 0x8b,
	0x0f, 0x45, 0x91, 0xde, 0x7b, 0x28, 0xe6, 0xb1, 0xe4, 0x52, 0xbb, 0xb2, 0x94, 0xb4, 0x28, 0xd0,
	0x83, 0xc4, 0x9d, 0xef, 0x35, 0xdf, 0x7b, 0xbe, 0xd9, 0x85, 0xf3, 0x8e, 0xdd, 0x9d, 0xed, 0x2a,
	0xb6, 0x61, 0xba, 0xb3, 0x56, 0x4f, 0x31, 0xac, 0x1d, 0xf6, 0x53, 0xb7, 0x6c, 0xd3, 0x35, 0x51,
	0xd9, 0xda, 0xab, 0x73, 0x64, 0x9d, 0x23, 0x2b, 0x13, 0x9a, 0xa9, 0x99, 0x0c, 0x39, 0x4b, 0x9f,
	0x38, 0x5d, 0xa5, 0xaa, 0x99, 0xa6, 0xd6, 0x23, 0xb3, 0x6c, 0xb5, 0xe3, 0xed, 0xce, 0x3e, 0xb4,
	0x15, 0xcb, 0x22, 0xb6, 0x23, 0xf0, 0xd3, 0x74, 0x17, 0xc5, 0xd2, 0x39, 0xc1, 0xac, 0xe7, 0xe9,
	0xaa, 0xb5, 0xc3, 0x7e, 0x04, 0xc1, 0x25, 0x4a, 0xe0, 0xdc, 0x53, 0x6c, 0xa2, 0xce, 0xba, 0xfb,
	0x16, 0x71, 0xf8, 0x7f, 0x6b, 0x87, 0xff, 0x72, 0xaa, 0xda, 0x0f, 0x25, 0xc8, 0x6d, 0xf6, 0x14,
	0xa3, 0x6d, 0xb9, 0xba, 0x69, 0x38, 0x68, 0x0a, 0xd2, 0x64, 0xcf, 0xea, 0x29, 0xba, 0x31, 0x15,
	0xbf, 0x28, 0xcd, 0x64, 0xb0, 0xbf, 0xa4, 0x18, 0xc5, 0x50, 0x7a, 0xfb, 0x1f, 0x90, 0xa9, 0x04,
	0xc7, 0x88, 0x25, 0xba, 0x0d, 0x67, 0xfb, 0xca, 0x9e, 0x6c, 0x7a, 0xae, 0xe5, 0xb9, 0xb2, 0x6d,
	0x3e, 0x74, 0x64, 0x8b, 0xd8, 0xb2, 0xab, 0xec, 0xf4, 0xc8, 0x54, 0xf2, 0xa2, 0x34, 0x93, 0xc0,
	0x93, 0x7d, 0x65, 0xaf, 0xcd, 0xf0, 0xd8, 0x7c, 0xe8, 0x6c, 0x12, 0xbb, 0x43, 0x91, 0xab, 0xc9,
	0x8c, 0x54, 0x8e, 0xd7, 0x9e, 0x24, 0x20, 0x49, 0x75, 0x40, 0x57, 0x20, 0xa1, 0x2a, 0xda, 0x94,
	0x74, 0x51, 0x9a, 0xc9, 0xcd, 0x4d, 0xd6, 0x0f, 0x7b, 0xaa, 0xbe, 0xd8, 0x58, 0xc6, 0x94, 0x02,
	0xdd, 0x84, 0x31, 0xc3, 0x54, 0x89, 0x33, 0x15, 0xbf, 0x98, 0x98, 0xc9, 0xcd, 0x55, 0xc3, 0xa4,
	0x54, 0xde, 0x92, 0xad, 0x68, 0x7d, 0x62, 0xb8, 0x98, 0x13, 0xa3, 0x37, 0x20, 0x4f, 0xb1, 0xb2,
	0xc9, 0x6d, 0x65, 0xaa, 0xe5, 0xe6, 0x2e, 0x44, 0x33, 0x0b, 0x87, 0xe0, 0x9c, 0x15, 0xf0, 0xce,
	0x16, 0x20, 0xdd, 0xe8, 0x9a, 0x7d, 0xdd, 0xd0, 0x64, 0x45, 0x23, 0x86, 0x2b, 0xeb, 0xaa, 0x33,
	0x35, 0xc6, 0x94, 0x28, 0x51, 0x39, 0x3c, 0x0c, 0xf5, 0xed, 0xed, 0xd6, 0xe2, 0xfc, 0xc4, 0xc1,
	0xe3, 0xe9, 0x72, 0x4b, 0x90, 0x37, 0x28, 0x75, 0x6b, 0xd1, 0xc1, 0x65, 0x7d, 0x04, 0xa2, 0x3a,
	0xc8, 0x83, 0x0b, 0x64, 0x8f, 0x74, 0x3d, 0xba, 0x85, 0xec, 0xb8, 0x8a, 0xeb, 0x39, 0xb2, 0x4a,
	0x1c, 0x57, 0x37, 0x14, 0xae, 0x67, 0x8a, 0xc9, 0xbf, 0x1e, 0xad, 0x67, 0xbd, 0xe9, 0xf3, 0x6e,
	0x31, 0xd6, 0xc5, 0x21, 0x27, 0x3e, 0x47, 0x8e, 0xc4, 0x39, 0x95, 0x5d, 0xa8, 0x1c, 0xcd, 0x8a,
	0x9e, 0x83, 0xbc, 0x66, 0x5b, 0x5d, 0x59, 0x51, 0x55, 0x9b, 0x38, 0x0e, 0x8b, 0x49, 0x16, 0xe7,
	0x28, 0xac, 0xc1, 0x41, 0xe8, 0x32, 0x14, 0x1d, 0xa7, 0x27, 0xbb, 0x8a, 0xad, 0x11, 0xd7, 0x50,
	0xfa, 0x84, 0x65, 0x4c, 0x16, 0x17, 0x1c, 0xa7, 0xd7, 0x19, 0x00, 0x57, 0x93, 0x99, 0x44, 0x39,
	0x59, 0xdb, 0x87, 0x7c, 0x30, 0x24, 0xa8, 0x08, 0x71, 0x5d, 0x65, 0x52, 0x93, 0x38, 0xae, 0xab,
	0x7e, 0xe8, 0xe3, 0xc7, 0x86, 0xfe, 0x9a, 0x1f, 0xfa, 0x04, 0xf3, 0x4a, 0x25, 0xda, 0x2b, 0x1b,
	0xa6, 0x4a, 0x44, 0xd8, 0x6b, 0xbf, 0x90, 0x20, 0xb1, 0xd8, 0x58, 0x46, 0x37, 0x7c, 0x4e, 0x89,
	0x71, 0x5e, 0x88, 0xdc, 0x84, 0xfe, 0x05, 0x98, 0x2b, 0x3a, 0xa4, 0x05, 0x24, 0xa4, 0x32, 0xb5,
	0xdf, 0xb4, 0x5d, 0xa2, 0xca, 0x96, 0x62, 0x13, 0xc3, 0xa5, 0x09, 0x95, 0x98, 0x49, 0xe2, 0x02,
	0x87, 0x6e, 0x72, 0x20, 0xba, 0x02, 0x25, 0x41, 0xd6, 0xbd, 0xa7, 0xf7, 0x54, 0x9b, 0x18, 0x4c,
	0xf5, 0x24, 0x16, 0xdc, 0x0b, 0x02, 0x5a, 0x5b, 0x82, 0x8c, 0xaf, 0x7a, 0x68, 0xaf, 0xab, 0x10,
	0x37, 0x2d, 0xe1, 0x9d, 0x08, 0x93, 0xdb, 0x16, 0xb1, 0x15, 0xd7, 0xb4, 0x71, 0xdc, 0xb4, 0x6a,
	0x3f, 0xca, 0x40, 0xc6, 0x07, 0xa0, 0xff, 0x83, 0xb4, 0x69, 0xc9, 0xb4, 0xe2, 0x99, 0xb4, 0x62,
	0x54, 0xad, 0xf8, 0xc4, 0x9d, 0x7d, 0x8b, 0xe0, 0x94, 0x69, 0xd1, 0x5f, 0xb4, 0x06, 0x85, 0x3e,
	0xe9, 0xcb, 0x8e, 0xe9, 0xd9, 0x5d, 0x22, 0x0f, 0x36, 0xff, 0x9f, 0x30, 0xfb, 0x3a, 0xe9, 0x9b,
	0xf6, 0xfe, 0x16, 0x23, 0xf4, 0x45, 0xad, 0xc4, 0x70, 0xae, 0x4f, 0xfa, 0x3e, 0x10, 0xdd, 0x82,
	0x54, 0x5f, 0xb1, 0xa8, 0x98, 0xc4, 0x51, 0x45, 0xb7, 0xae, 0x58, 0x01, 0xee, 0xb1, 0x3e, 0x5d,
	0xa2, 0xbb, 0x90, 0x52, 0x34, 0x8d, 0xf2, 0xf1, 0x62, 0x7d, 0x3e, 0xcc, 0xd7, 0xd0, 0x34, 0x9b,
	0x68, 0x8a, 0x1b, 0xdc, 0x7b, 0x4c, 0xd1, 0xb4, 0xb6, 0x85, 0x96, 0x20, 0xc7, 0x6c, 0xd0, 0x8d,
	0xfb, 0x54, 0xc4, 0x18, 0x13, 0x71, 0xe9, 0x48, 0x0b, 0x74, 0xe3, 0x7e, 0x40, 0x46, 0x96, 0xea,
	0xcf, 0x40, 0xe8, 0x75, 0xc8, 0xee, 0xea, 0x3d, 0x97, 0xd8, 0x54, 0x4a, 0x8a, 0x49, 0xb9, 0x18,
	0x96, 0xb2, 0xc4, 0x48, 0x02, 0x12, 0x32, 0xbb, 0x02, 0x82, 0xee, 0x42, 0xa6, 0xa7, 0xf7, 0x75,
	0x97, 0xf2, 0xa7, 0x19, 0xff, 0x74, 0x98, 0x7f, 0x8d, 0x52, 0x04, 0xd8, 0xd3, 0x3d, 0x0e, 0xa0,
	0xdc, 0x9e, 0x41, 0x9b, 0x83, 0x69, 0x4d, 0x65, 0x8e, 0xe2, 0xde, 0xa6, 0x14, 0x41, 0x6e, 0x8f,
	0x03, 0xd0, 0xf7, 0xa0, 0xc8, 0x2a, 0x79, 0x18, 0xc9, 0xec, 0x51, 0x7e, 0x58, 0xc6, 0x9b, 0x0b,
	0xa3, 0x71, 0x9c, 0x2f, 0x1f, 0x3c, 0x9e, 0xce, 0x07, 0xe1, 0x2b, 0x31, 0xcc, 0x3a, 0xc3, 0x20,
	0xb4, 0x6f, 0x8b, 0x4e, 0xe1, 0x7b, 0xf9, 0x29, 0x37, 0xb0, 0x76, 0x84, 0xf8, 0x80, 0x93, 0xe7,
	0x8b, 0x07, 0x8f, 0xa7, 0x61, 0x08, 0x5d, 0x89, 0x61, 0x60, 0xa2, 0xb9, 0xd7, 0x5f, 0x81, 0xf4,
	0x7b, 0xa6, 0xce, 0xac, 0xce, 0x31, 0x91, 0x11, 0xa9, 0xbb, 0x6a, 0xea, 0x41, 0xa3, 0x53, 0xef,
	0xb1, 0x35, 0x5a, 0x83, 0xa2, 0xa7, 0xba, 0xbb, 0x01, 0x9b, 0xf3, 0x47, 0xd9, 0xbc, 0xbd, 0xd8,
	0x59, 0x0a, 0xe5, 0x6e, 0x9e, 0x72, 0x0f, 0x2c, 0x6c, 0x43, 0x89, 0xf4, 0x2d, 0x77, 0x3f, 0x20,
	0xae, 0xc0, 0xc4, 0x5d, 0x0e, 0x8b, 0x6b, 0x52, 0xc2, 0x90, 0xbc, 0x02, 0x09, 0x82, 0xd1, 0xbb,
	0x90, 0x37, 0x5d, 0xd2, 0x1b, 0xb8, 0xac, 0xc8, 0xa4, 0xcd, 0x44, 0x54, 0x66, 0x87, 0xf4, 0x9a,
	0x7b, 0x96, 0x69, 0xbb, 0x61, 0xbf, 0x51, 0xdc, 0xd0, 0x6f, 0x54, 0x1e, 0x5f, 0xcd, 0x27, 0x69,
	0xaf, 0xa8, 0xfd, 0x39, 0x0e, 0x13, 0x51, 0x95, 0x89, 0x10, 0x24, 0x59, 0xb3, 0xe6, 0x1d, 0x9d,
	0x3d, 0xa3, 0x69, 0xc8, 0x75, 0xcd, 0x9e, 0xd7, 0x37, 0x64, 0x5d, 0xdd, 0xe3, 0xa7, 0x6a, 0x02,
	0x03, 0x07, 0xb5, 0xd4, 0x3d, 0x87, 0x1e, 0x07, 0x82, 0x80, 0xd2, 0xf3, 0xe6, 0x9b, 0xc5, 0x82,
	0x69, 0x83, 0x82, 0xd0, 0xcb, 0x03, 0x12, 0x36, 0x5f, 0xb0, 0x66, 0x58, 0x9c, 0x43, 0xd4, 0x28,
	0x3e, 0x70, 0x2c, 0x2a, 0xae, 0xc2, 0x5a, 0x8c, 0x60, 0xa3, 0xcf, 0x0e, 0xba, 0x03, 0xe0, 0xb8,
	0x8a, 0xed, 0xca, 0xae, 0xde, 0x27, 0xa2, 0x44, 0xcf, 0xd5, 0xf9, 0xf0, 0x53, 0xf7, 0x87, 0x9f,
	0x7a, 0xcb, 0x70, 0x6f, 0xdd, 0x7c, 0x4b, 0xe9, 0x79, 0x04, 0x67, 0x19, 0x79, 0x47, 0xef, 0xd3,
	0xc1, 0x23, 0xeb, 0xb8, 0xb4, 0xbd, 0x51, 0xd6, 0xd4, 0xf1, 0xac, 0x19, 0x4a, 0xcd, 0x38, 0x4f,
	0x43, 0x8a, 0x8d, 0x27, 0x2e, 0x2b, 0xc7, 0x2c, 0x16, 0x2b, 0x74, 0x9e, 0x4a, 0xb4, 0x89, 0x42,
	0x0f, 0x68, 0x56, 0x6b, 0x19, 0x3c, 0x04, 0xd4, 0x3e, 0x93, 0x00, 0x85, 0x7b, 0x45, 0xa4, 0x47,
	0x0f, 0x7b, 0x23, 0x7e, 0x32, 0x6f, 0x9c, 0xc0, 0xcf, 0xab, 0x30, 0x29, 0x48, 0x1c, 0xd2, 0x57,
	0x0c, 0x57, 0xef, 0x8e, 0x38, 0xfc, 0xf4, 0x70, 0x8b, 0x2d, 0x81, 0x67, 0xdb, 0x9c, 0xe2, 0x4c,
	0x41, 0x98, 0x53, 0x33, 0x00, 0x85, 0x6b, 0x3e, 0xa4, 0xbb, 0xf4, 0xcd, 0x74, 0x8f, 0x87, 0x74,
	0xaf, 0x7d, 0x96, 0x84, 0xf2, 0xe1, 0x2e, 0xc0, 0x06, 0xcb, 0x91, 0x29, 0xc3, 0x5f, 0xa2, 0xdb,
	0xa3, 0xad, 0x4b, 0x57, 0xd9, 0xe9, 0x91, 0x3c, 0xdc, 0x94, 0x5a, 0x8b, 0xa3, 0x4d, 0xa9, 0xa5,
	0xa2, 0x2d, 0xc8, 0x8b, 0x71, 0x74, 0x38, 0x85, 0xe6, 0xe6, 0xea, 0xc7, 0xf7, 0xa4, 0x3a, 0x26,
	0x8e, 0xd7, 0x73, 0xd9, 0x78, 0x4a, 0x0f, 0x31, 0x2e, 0x85, 0x2d, 0x91, 0x06, 0xa8, 0x6b, 0x1a,
	0x06, 0xe9, 0xba, 0xbc, 0x19, 0xf3, 0xe9, 0x8c, 0xa7, 0xec, 0xed, 0x13, 0x88, 0xa6, 0x80, 0x85,
	0x81, 0x00, 0x7f, 0xc0, 0x1c, 0xef, 0x1e, 0x06, 0x55, 0xfe, 0x22, 0x41, 0x2e, 0xa0, 0x07, 0xba,
	0x00, 0xc0, 0xcc, 0x90, 0x03, 0x69, 0x96, 0x65, 0x90, 0x8d, 0xff, 0x9a, 0x5c, 0xab, 0xfc, 0x3f,
	0x4c, 0x46, 0x3a, 0x20, 0x62, 0x8e, 0x94, 0x22, 0xe6, 0xc8, 0xf9, 0x02, 0xe4, 0x02, 0x53, 0xf1,
	0x6a, 0x32, 0x13, 0x2f, 0x27, 0x6a, 0x0f, 0x20, 0x17, 0x98, 0x1b, 0xd0, 0x22, 0xe4, 0xc8, 0x9e,
	0x45, 0x73, 0x87, 0x85, 0x86, 0x0f, 0x7a, 0x11, 0x27, 0xd1, 0x56, 0x57, 0xe9, 0x29, 0x76, 0x73,
	0x40, 0x8a, 0x83, 0x6c, 0x27, 0x49, 0xe4, 0x5f, 0xc7, 0x61, 0x3c, 0x34, 0x78, 0xa0, 0xd7, 0x20,
	0xf5, 0x80, 0x36, 0x1a, 0x7f, 0xe7, 0xcb, 0xcf, 0x98, 0x56, 0x02, 0x9b, 0x0b, 0x26, 0x74, 0x0d,
	0x52, 0x9a, 0x6d, 0x7a, 0x96, 0x7f, 0xad, 0x99, 0x0a, 0xb3, 0x2f, 0x30, 0x1d, 0xb0, 0xa0, 0xa3,
	0x7d, 0x9b, 0x3d, 0x8d, 0x44, 0x10, 0x18, 0x88, 0x07, 0x70, 0x1a, 0x72, 0x4c, 0xb8, 0x20, 0x48,
	0x72, 0x02, 0x06, 0xe2, 0x04, 0x15, 0xc8, 0x3c, 0xd4, 0x0d, 0xd5, 0x7c, 0x48, 0x54, 0x96, 0xc9,
	0x19, 0x3c, 0x58, 0x53, 0x66, 0x4b, 0xb1, 0x5d, 0x5d, 0xe9, 0xc9, 0x8a, 0xa6, 0xb1, 0x06, 0x9b,
	0xc1, 0x20, 0x40, 0x0d, 0x4d, 0x43, 0x2f, 0x40, 0x79, 0x57, 0x37, 0x94, 0x9e, 0xfe, 0x01, 0x91,
	0x6d, 0x96, 0xaf, 0x0e, 0xeb, 0xa7, 0x19, 0x5c, 0xf2, 0xe1, 0x3c, 0x8d, 0x9d, 0xda, 0x8f, 0x25,
	0x28, 0x8e, 0x0e, 0x48, 0x68, 0x1e, 0x60, 0xe8, 0x75, 0x71, 0xe9, 0x3b, 0x49, 0xac, 0x02, 0x5c,
	0x68, 0x0e, 0xd2, 0x3c, 0x2c, 0xc7, 0xfb, 0xcc, 0x27, 0xac, 0x7d, 0x28, 0x41, 0x61, 0x64, 0xd6,
	0x42, 0x13, 0x30, 0xc6, 0x66, 0x2d, 0xa6, 0x44, 0x02, 0xf3, 0xc5, 0x37, 0x91, 0x4d, 0x73, 0x59,
	0xd9, 0x31, 0x6d, 0x5e, 0xad, 0x8e, 0xdd, 0x75, 0xc4, 0xac, 0x5f, 0x18, 0x40, 0xb7, 0xec, 0xae,
	0x53, 0x7b, 0x2a, 0x41, 0x61, 0x64, 0x60, 0x0b, 0xe5, 0x9c, 0x14, 0x2e, 0xc6, 0xb7, 0xa0, 0x24,
	0x48, 0xfa, 0x8a, 0x65, 0xe9, 0x86, 0xe6, 0xeb, 0xf5, 0xd2, 0x31, 0xd3, 0xa0, 0xd0, 0x72, 0x9d,
	0x73, 0xe1, 0x62, 0x37, 0xb8, 0x74, 0xd0, 0x25, 0x28, 0x0e, 0xee, 0xec, 0x3b, 0x8a, 0xdb, 0xbd,
	0xc7, 0xbb, 0x2c, 0xce, 0xdb, 0xfc, 0xaa, 0x3e, 0x4f, 0x61, 0x95, 0x5b, 0x50, 0x18, 0x11, 0x43,
	0x4d, 0xf5, 0x67, 0x06, 0x43, 0x25, 0x7b, 0x42, 0xe7, 0x04, 0x2e, 0x88, 0xb1, 0x81, 0x03, 0x6b,
	0x9f, 0x26, 0x21, 0x1f, 0x9c, 0xd2, 0xd0, 0xab, 0x90, 0x0c, 0x5c, 0x47, 0xae, 0x3c, 0x7b, 0xa6,
	0x63, 0x0b, 0xd6, 0x53, 0x18, 0x13, 0x52, 0xe0, 0x14, 0x79, 0xdf, 0x53, 0x7a, 0xba, 0xbb, 0x2f,
	0x77, 0x4d, 0x43, 0xd5, 0x79, 0x0f, 0xe6, 0x7e, 0xb8, 0x76, 0x8c, 0xac, 0xa6, 0xe0, 0x5c, 0xf0,
	0x19, 0x31, 0x22, 0x87, 0x41, 0x0e, 0xc2, 0x50, 0x14, 0x47, 0x87, 0x1f, 0x7d, 0x7e, 0xd3, 0xfc,
	0xdf, 0x63, 0xa4, 0xf3, 0xfb, 0x9e, 0x48, 0x88, 0x02, 0x17, 0xb1, 0x20, 0xd2, 0xe2, 0x70, 0x74,
	0x93, 0xe1, 0xe8, 0x86, 0xa3, 0x30, 0x16, 0x11, 0x85, 0x3e, 0x8c, 0x87, 0xac, 0x40, 0x57, 0x61,
	0xbc, 0x47, 0x76, 0x7d, 0x7d, 0x79, 0x38, 0xc4, 0xdd, 0xb1, 0x44, 0x11, 0x0b, 0xc3, 0x80, 0xa0,
	0x17, 0x01, 0xd9, 0xba, 0x76, 0xef, 0x10, 0x71, 0x9c, 0x11, 0x97, 0x19, 0x26, 0x40, 0x5d, 0xe9,
	0x40, 0x3e, 0x68, 0x16, 0xb5, 0x83, 0xdf, 0x75, 0x47, 0x36, 0xc9, 0x71, 0x18, 0xdf, 0x60, 0x68,
	0x6a, 0x50, 0x74, 0x2e, 0x90, 0x14, 0xb5, 0x97, 0x21, 0xe3, 0x87, 0x15, 0x65, 0x61, 0xac, 0xb5,
	0xb1, 0xd1, 0xc4, 0xe5, 0x18, 0x2a, 0x02, 0xac, 0x35, 0x97, 0x3a, 0x72, 0x7b, 0xbb, 0xd3, 0xc4,
	0x65, 0x89, 0xae, 0x97, 0xb6, 0xd7, 0xd6, 0xc4, 0x3a, 0x51, 0xdb, 0x05, 0x14, 0x1e, 0xd6, 0x23,
	0x87, 0xaf, 0xbb, 0x00, 0x8a, 0xad, 0xc9, 0xa2, 0x17, 0xc7, 0x8f, 0xba, 0xee, 0xf3, 0xce, 0x22,
	0xa6, 0x4a, 0xc5, 0xd6, 0xd8, 0x93, 0x53, 0x33, 0xe1, 0x54, 0xc4, 0x14, 0x7f, 0x92, 0x0a, 0xfd,
	0x66, 0x07, 0x71, 0xed, 0x57, 0x71, 0x48, 0xd3, 0x69, 0x7e, 0xcd, 0xd4, 0xd0, 0xeb, 0x00, 0x8a,
	0xeb, 0xda, 0xfa, 0x8e, 0xe7, 0x0e, 0x8e, 0x91, 0xe9, 0xe8, 0x8b, 0x41, 0xc3, 0xa7, 0xc3, 0x01,
	0x16, 0x9a, 0x0c, 0x74, 0x1c, 0x0e, 0xc7, 0x37, 0x81, 0x4b, 0x14, 0x11, 0x4c, 0x86, 0x57, 0xa1,
	0x62, 0xee, 0x38, 0xc4, 0x7e, 0x40, 0x54, 0x39, 0xcc, 0x94, 0x60, 0x4c, 0x67, 0x7c, 0x8a, 0xce,
	0x21, 0xe6, 0x2b, 0x50, 0x72, 0xc8, 0x03, 0x62, 0xd3, 0x52, 0x34, 0xbc, 0xfe, 0x0e, 0xb1, 0xc5,
	0xbb, 0xbe, 0xa2, 0x0f, 0xde, 0x60, 0x50, 0xf4, 0x3c, 0x14, 0x06, 0x84, 0x2e, 0xd9, 0x73, 0x59,
	0x62, 0x67, 0x71, 0xde, 0x07, 0x76, 0xc8, 0x9e, 0x4b, 0xd5, 0xde, 0x31, 0xd5, 0xfd, 0x51, 0x0d,
	0x52, 0x5c, 0x6d, 0x8a, 0x08, 0xec, 0x5c, 0xfb, 0x28, 0x09, 0x19, 0x76, 0xfb, 0xb1, 0x14, 0x9a,
	0x92, 0x39, 0x1a, 0x0f, 0xd9, 0x71, 0x6d, 0x3a, 0xb3, 0xb3, 0x34, 0xa0, 0x17, 0x22, 0x0a, 0xdc,
	0x62, 0x30, 0xf4, 0x22, 0x8c, 0x33, 0x92, 0xb0, 0x4b, 0x56, 0x62, 0xb8, 0x44, 0x51, 0x41, 0xbb,
	0x46, 0x23, 0x90, 0xf8, 0xfa, 0x11, 0x58, 0x84, 0x49, 0xd7, 0x56, 0xd8, 0xbc, 0x3a, 0xba, 0x25,
	0x73, 0xcf, 0xfc, 0xf8, 0xc1, 0xe3, 0xe9, 0x42, 0x87, 0x12, 0xb4, 0x16, 0x45, 0xb7, 0x40, 0x8c,
	0xbe, 0xa5, 0x06, 0xd5, 0x68, 0xc0, 0x84, 0x63, 0x29, 0x46, 0x48, 0xc8, 0x18, 0x13, 0xc2, 0x26,
	0x60, 0x6a, 0xff, 0x40, 0xc6, 0x38, 0xa5, 0x1e, 0x15, 0xd1, 0x81, 0x73, 0xa2, 0x5a, 0x23, 0x25,
	0x31, 0xef, 0xce, 0x9f, 0x3e, 0x78, 0x3c, 0x8d, 0x78, 0x91, 0x8f, 0xc8, 0x3b, 0x63, 0x0d, 0x61,
	0x23, 0x52, 0x5f, 0x86, 0x33, 0xc3, 0x0b, 0xdb, 0xa8, 0xc4, 0x34, 0x8b, 0xd7, 0xc4, 0xe0, 0x82,
	0x16, 0x64, 0xbb, 0x0e, 0x93, 0xc4, 0x88, 0x4a, 0xb3, 0x0c, 0x63, 0x42, 0xc4, 0x08, 0x65, 0xd8,
	0x05, 0x80, 0xfb, 0xba, 0xa1, 0xf2, 0x3a, 0x66, 0x6f, 0x2d, 0x12, 0x38, 0x4b, 0x21, 0xac, 0x50,
	0xe7, 0x53, 0xbc, 0xf2, 0x6b, 0xdf, 0x87, 0x12, 0x0d, 0xc6, 0x3a, 0x71, 0x6d, 0xbd, 0xbb, 0xac,
	0x78, 0x1a, 0x41, 0x75, 0x40, 0xbb, 0x3d, 0x53, 0x89, 0x68, 0x89, 0x34, 0xe4, 0x65, 0x86, 0x0b,
	0xee, 0x74, 0x15, 0xca, 0xba, 0xe1, 0x46, 0x27, 0x48, 0x51, 0x37, 0x82, 0xb4, 0xf3, 0x45, 0xc8,
	0xf3, 0x91, 0x8a, 0x53, 0xd7, 0x7e, 0x19, 0x87, 0xf1, 0xe1, 0xfe, 0x5b, 0x5e, 0xbf, 0xaf, 0xd8,
	0xfb, 0xb4, 0xcf, 0x76, 0x4d, 0xcf, 0x88, 0xd2, 0x00, 0x97, 0x19, 0x26, 0xb8, 0xff, 0x0c, 0x94,
	0x1d, 0xaf, 0x1f, 0x55, 0xb3, 0x45, 0xc7, 0xeb, 0x07, 0x29, 0xdf, 0x85, 0xd2, 0xfb, 0x1e, 0x9d,
	0xaa, 0x7b, 0xc4, 0xef, 0x6f, 0x3c, 0x45, 0x6f, 0x44, 0xa7, 0xe8, 0x88, 0x56, 0x75, 0xe6, 0xb8,
	0x86, 0xfb, 0x2d, 0x21, 0x01, 0x17, 0x7d, 0x59, 0xbc, 0xf5, 0x55, 0xbe, 0x0b, 0xa5, 0x43, 0x24,
	0x74, 0x40, 0xf4, 0x89, 0x98, 0xfa, 0x12, 0x1e, 0xac, 0xa9, 0x91, 0x41, 0x57, 0x8c, 0x28, 0x5e,
	0x66, 0x98, 0x60, 0xd9, 0x7e, 0x12, 0x87, 0xc2, 0x48, 0xd5, 0x44, 0xf6, 0xee, 0x37, 0x20, 0xc5,
	0xa5, 0x1d, 0xfd, 0xc2, 0x71, 0x44, 0x88, 0x18, 0x6e, 0x56, 0x62, 0x58, 0xf0, 0xa1, 0xe7, 0x21,
	0xcf, 0x9b, 0x81, 0x48, 0x9c, 0x84, 0x68, 0x09, 0x39, 0x0e, 0x65, 0x06, 0x56, 0x7e, 0x2e, 0x41,
	0x4a, 0x1c, 0x6a, 0x37, 0x06, 0x2f, 0x3f, 0x02, 0x73, 0x49, 0x54, 0xd3, 0x86, 0x61, 0xd3, 0x8e,
	0x3c, 0xe6, 0x12, 0x23, 0xc7, 0x1c, 0xba, 0x0d, 0x67, 0xbb, 0x8a, 0x21, 0xef, 0x10, 0xf9, 0x3d,
	0xc7, 0x34, 0x64, 0x62, 0x74, 0x4d, 0x95, 0xa8, 0xb2, 0x62, 0xdb, 0xca, 0xbe, 0xf8, 0x84, 0x32,
	0xd9, 0x55, 0x8c, 0x79, 0xb2, 0xea, 0x98, 0x46, 0x93, 0x63, 0x1b, 0x14, 0x39, 0x9f, 0x86, 0x31,
	0xa6, 0x7a, 0xed, 0xd3, 0x38, 0xc0, 0x30, 0x8a, 0x91, 0xfe, 0xba, 0xc8, 0xae, 0x45, 0x5d, 0x5b,
	0x67, 0xb7, 0x29, 0xf1, 0x0a, 0x3e, 0x08, 0xa2, 0x5c, 0x9e, 0xa1, 0xbb, 0xdc, 0x0f, 0x98, 0x3d,
	0x1f, 0x6a, 0x72, 0xc9, 0x7f, 0xd3, 0x31, 0x33, 0x16, 0x7d, 0xcc, 0xbc, 0x02, 0x63, 0x1a, 0x2d,
	0xcb, 0x29, 0xc2, 0x22, 0xfa, 0xdc, 0xb3, 0x32, 0x95, 0xd5, 0xef, 0x4a, 0x0c, 0x73, 0x0e, 0xf4,
	0x3a, 0xa4, 0x1d, 0x9e, 0xbb, 0x53, 0xbb, 0x47, 0xbd, 0x00, 0x0e, 0xa5, 0xf9, 0x4a, 0x0c, 0xfb,
	0x5c, 0xb4, 0x49, 0xa8, 0x8a, 0xab, 0xd4, 0xfe, 0x26, 0x01, 0x62, 0x6f, 0xd3, 0x0c, 0xd5, 0x32,
	0x59, 0x45, 0x1b, 0xbb, 0xba, 0x86, 0xce, 0x42, 0xc2, 0xb3, 0x7b, 0xdc, 0xa1, 0xf3, 0xe9, 0x83,
	0xc7, 0xd3, 0x89, 0x6d, 0xbc, 0x86, 0x29, 0x0c, 0xbd, 0x09, 0xe9, 0x7b, 0x44, 0x51, 0x89, 0xed,
	0x4f, 0x10, 0xd7, 0x8f, 0x78, 0x3f, 0x37, 0x22, 0xb1, 0xbe, 0xc2, 0x79, 0x9a, 0x86, 0x6b, 0xef,
	0x63, 0x5f, 0x02, 0xad, 0x22, 0xdd, 0x70, 0x48, 0xd7, 0xb3, 0xfd, 0xaf, 0x67, 0x83, 0x35, 0x9a,
	0x82, 0x34, 0xf5, 0x98, 0xe9, 0xb9, 0xe2, 0x00, 0xf5, 0x97, 0x95, 0x3b, 0x90, 0x0f, 0x8a, 0x43,
	0x65, 0x48, 0xdc, 0x27, 0xfb, 0x22, 0xfc, 0xf4, 0x91, 0xde, 0x5c, 0x78, 0x92, 0xf3, 0xb8, 0xf3,
	0xc5, 0x9d, 0xf8, 0x6d, 0xa9, 0xd6, 0x86, 0x3c, 0xd5, 0x0e, 0x13, 0xfe, 0xf2, 0xe4, 0x5f, 0x1e,
	0x2c, 0x6a, 0xbf, 0x8d, 0xc3, 0xe9, 0xe8, 0xf7, 0x91, 0x68, 0x1d, 0x4a, 0x44, 0x78, 0x81, 0x4e,
	0xe5, 0xbb, 0xba, 0xff, 0x0d, 0xef, 0xd2, 0x49, 0x5c, 0x86, 0x8b, 0x64, 0x34, 0x28, 0x77, 0x20,
	0x63, 0x0b, 0xb5, 0x45, 0x13, 0xa8, 0x46, 0xcb, 0xf1, 0x8d, 0xc3, 0x03, 0x7a, 0x74, 0x0b, 0xd2,
	0x7d, 0x96, 0x0b, 0x7e, 0x5f, 0x3c, 0xff, 0xac, 0x84, 0xc1, 0x3e, 0x31, 0xba, 0x06, 0x63, 0xf4,
	0x90, 0xf4, 0x6b, 0xa1, 0x12, 0xcd, 0x45, 0x4f, 0x43, 0xcc, 0x09, 0xd1, 0x4b, 0x90, 0xec, 0x99,
	0x9a, 0xff, 0xf5, 0xef, 0x6c, 0x34, 0xc3, 0x9a, 0xa9, 0x61, 0x46, 0x56, 0xfb, 0x9d, 0x04, 0xe5,
	0xc3, 0x57, 0x59, 0xf4, 0x2a, 0x64, 0xba, 0xa6, 0xe1, 0xb8, 0x8a, 0xe1, 0x0a, 0x8f, 0x3d, 0x7b,
	0x4c, 0x5d, 0x89, 0xe1, 0x01, 0x03, 0x9a, 0x3b, 0xd4, 0x29, 0x8f, 0xbc, 0x9e, 0x06, 0x7a, 0xe3,
	0x1c, 0x24, 0x77, 0x3d, 0xa3, 0x2b, 0xbe, 0xc2, 0x9c, 0x3f, 0x6a, 0xb3, 0x25, 0xcf, 0xe8, 0xae,
	0xc4, 0x30, 0xa3, 0x1d, 0x76, 0xa3, 0xdf, 0xc7, 0x21, 0x17, 0x50, 0x06, 0xcd, 0x42, 0x96, 0xd6,
	0xd6, 0x71, 0x6d, 0x33, 0xa3, 0x8a, 0x27, 0x34, 0x0d, 0xb0, 0x63, 0x9a, 0x3d, 0x79, 0x98, 0xb2,
	0x99, 0x95, 0x18, 0xce, 0x52, 0x18, 0x97, 0xf8, 0x1c, 0xe4, 0x74, 0xc3, 0xbd, 0x75, 0x33, 0xd0,
	0xb9, 0xe9, 0x11, 0x0c, 0xfa, 0xe0, 0x1d, 0x2e, 0xba, 0x0c, 0x05, 0x76, 0x7c, 0x0f, 0x88, 0x68,
	0xcd, 0x48, 0x2b, 0x31, 0x9c, 0x17, 0x60, 0x4e, 0x76, 0xf8, 0x10, 0x18, 0x8b, 0x38, 0x04, 0xd0,
	0x0c, 0xb0, 0x5e, 0x75, 0xeb, 0xa6, 0x6c, 0x38, 0x82, 0x2e, 0x25, 0xb6, 0x2c, 0x70, 0xc4, 0x86,
	0xc3, 0x29, 0x6f, 0x43, 0xc1, 0xd3, 0x0d, 0xf7, 0xfa, 0xdc, 0x6d, 0x41, 0xc7, 0x3f, 0x72, 0x8c,
	0x0f, 0xcd, 0xdd, 0x6e, 0x31, 0x34, 0xfb, 0x78, 0xc0, 0x29, 0xf9, 0x94, 0xe2, 0x7b, 0x6f, 0x35,
	0x99, 0xc9, 0x94, 0xb3, 0xb5, 0x2f, 0x24, 0x80, 0xa1, 0x8f, 0x23, 0x3b, 0xfa, 0x1d, 0xc8, 0xea,
	0x86, 0xee, 0xca, 0x8a, 0xad, 0x9d, 0xf0, 0xf2, 0x92, 0xa1, 0xf4, 0x0d, 0x5b, 0x73, 0xd0, 0x2d,
	0x48, 0x32, 0xb6, 0xc4, 0x89, 0xdf, 0x7c, 0x31, 0x7a, 0xf1, 0xbd, 0x91, 0xb7, 0x9f, 0xb8, 0xae,
	0xa2, 0x3b, 0x50, 0xa2, 0x70, 0x79, 0x10, 0x5f, 0x9e, 0xe7, 0xd1, 0x01, 0x2e, 0x50, 0x52, 0x7f,
	0xe5, 0xd4, 0xfe, 0x1e, 0x87, 0x53, 0x11, 0xaf, 0xb9, 0x06, 0xb6, 0x26, 0x8e, 0xb2, 0x35, 0xf9,
	0xf5, 0x6c, 0x7d, 0x4d, 0xd8, 0xca, 0x0b, 0xf0, 0x85, 0x13, 0xbd, 0x6b, 0xab, 0x37, 0x6c, 0x6d,
	0xc4, 0xe4, 0xd4, 0xb3, 0x4c, 0x4e, 0x9f, 0xd0, 0xe4, 0xca, 0x0f, 0x20, 0xd1, 0xb0, 0xb5, 0xff,
	0x78, 0x39, 0x0f, 0x4b, 0x73, 0x6e, 0x30, 0xcd, 0x50, 0x2f, 0x9b, 0x2a, 0x11, 0x57, 0x73, 0xf6,
	0x4c, 0x4f, 0x89, 0xe0, 0x65, 0x9c, 0x2f, 0xae, 0xfe, 0x35, 0x0e, 0xf9, 0xe0, 0xa7, 0x5f, 0x74,
	0x16, 0x26, 0xdb, 0x9b, 0x4d, 0xdc, 0xe8, 0xb4, 0xb1, 0xdc, 0x79, 0x67, 0xb3, 0x29, 0x6f, 0x6f,
	0xbc, 0xb9, 0xd1, 0x7e, 0x7b, 0xa3, 0x1c, 0x43, 0xe7, 0xe0, 0xf4, 0x7a, 0x73, 0xbd, 0x8d, 0xdf,
	0x91, 0xb7, 0xda, 0xdb, 0x78, 0xa1, 0x29, 0xfb, 0x84, 0xe5, 0xa7, 0x69, 0x74, 0x16, 0x26, 0x96,
	0xf1, 0xe6, 0x42, 0x08, 0xf5, 0xa7, 0x0c, 0x45, 0xd1, 0x3b, 0x7b, 0x08, 0xf5, 0x49, 0x16, 0x55,
	0x60, 0xb2, 0xb9, 0xbe, 0xd9, 0x09, 0x4b, 0xfc, 0x29, 0xa0, 0x71, 0xc8, 0xaf, 0x37, 0x36, 0x87,
	0xa0, 0x47, 0x25, 0x74, 0x06, 0x50, 0x63, 0x79, 0x19, 0x37, 0x97, 0x1b, 0x9d, 0x00, 0xed, 0x6f,
	0xca, 0x68, 0x02, 0x4a, 0x4b, 0xad, 0xb5, 0x4e, 0x13, 0x0f, 0xa1, 0x3f, 0x1b, 0x47, 0xa7, 0xa0,
	0xb8, 0xd6, 0x5a, 0x6f, 0x75, 0x86, 0xc0, 0x7f, 0x30, 0xe0, 0xf6, 0x46, 0xab, 0xbd, 0x31, 0x04,
	0x7e, 0x81, 0x10, 0x82, 0xc2, 0x6a, 0xbb, 0x15, 0x80, 0xfd, 0xe1, 0x14, 0x55, 0xdb, 0x37, 0xb7,
	0xb5, 0xf1, 0xe6, 0x10, 0xf5, 0xf1, 0x12, 0xd5, 0x83, 0x1b, 0x3b, 0x82, 0xf8, 0x68, 0x19, 0x55,
	0xe1, 0x6c, 0xbb, 0xd3, 0x5c, 0x93, 0x9b, 0xdf, 0xde, 0x6c, 0xe3, 0xce, 0x21, 0xfc, 0x57, 0xcb,
	0xf3, 0x77, 0x1f, 0x3d, 0xa9, 0xc6, 0x3e, 0x7f, 0x52, 0x8d, 0x7d, 0xf5, 0xa4, 0x2a, 0x7d, 0x78,
	0x50, 0x95, 0x3e, 0x3e, 0xa8, 0x4a, 0x7f, 0x3c, 0xa8, 0x4a, 0x8f, 0x0e, 0xaa, 0xd2, 0x17, 0x07,
	0x55, 0xe9, 0xe9, 0x41, 0x35, 0xf6, 0xd5, 0x41, 0x55, 0xfa, 0xc9, 0x97, 0xd5, 0xd8, 0xa3, 0x2f,
	0xab, 0xb1, 0xcf, 0xbf, 0xac, 0xc6, 0xbe, 0x93, 0xe2, 0xa1, 0xdf, 0x49, 0xb1, 0xef, 0x59, 0x37,
	0xfe, 0x19, 0x00, 0x00, 0xff, 0xff, 0xd2, 0xa5, 0x24, 0xbc, 0x5d, 0x24, 0x00, 0x00,
}

func (x OperatorType) String() string {
	s, ok := OperatorType_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x JoinOperator_JoinType) String() string {
	s, ok := JoinOperator_JoinType_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *PlanOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PlanOptions)
	if !ok {
		that2, ok := that.(PlanOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Explain != that1.Explain {
		return false
	}
	if this.Analyze != that1.Analyze {
		return false
	}
	if this.MaxOutputRowsPerTable != that1.MaxOutputRowsPerTable {
		return false
	}
	return true
}
func (this *Plan) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Plan)
	if !ok {
		that2, ok := that.(Plan)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Dag.Equal(that1.Dag) {
		return false
	}
	if len(this.Nodes) != len(that1.Nodes) {
		return false
	}
	for i := range this.Nodes {
		if !this.Nodes[i].Equal(that1.Nodes[i]) {
			return false
		}
	}
	if !this.PlanOptions.Equal(that1.PlanOptions) {
		return false
	}
	if len(this.IncomingAgentIDs) != len(that1.IncomingAgentIDs) {
		return false
	}
	for i := range this.IncomingAgentIDs {
		if !this.IncomingAgentIDs[i].Equal(that1.IncomingAgentIDs[i]) {
			return false
		}
	}
	if len(this.ExecutionStatusDestinations) != len(that1.ExecutionStatusDestinations) {
		return false
	}
	for i := range this.ExecutionStatusDestinations {
		if !this.ExecutionStatusDestinations[i].Equal(that1.ExecutionStatusDestinations[i]) {
			return false
		}
	}
	return true
}
func (this *Plan_ExecutionStatusDestination) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Plan_ExecutionStatusDestination)
	if !ok {
		that2, ok := that.(Plan_ExecutionStatusDestination)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.GrpcAddress != that1.GrpcAddress {
		return false
	}
	if this.SslTargetname != that1.SslTargetname {
		return false
	}
	return true
}
func (this *PlanFragment) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PlanFragment)
	if !ok {
		that2, ok := that.(PlanFragment)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if !this.Dag.Equal(that1.Dag) {
		return false
	}
	if len(this.Nodes) != len(that1.Nodes) {
		return false
	}
	for i := range this.Nodes {
		if !this.Nodes[i].Equal(that1.Nodes[i]) {
			return false
		}
	}
	return true
}
func (this *DAG) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DAG)
	if !ok {
		that2, ok := that.(DAG)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Nodes) != len(that1.Nodes) {
		return false
	}
	for i := range this.Nodes {
		if !this.Nodes[i].Equal(that1.Nodes[i]) {
			return false
		}
	}
	return true
}
func (this *DAG_DAGNode) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DAG_DAGNode)
	if !ok {
		that2, ok := that.(DAG_DAGNode)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if len(this.SortedParents) != len(that1.SortedParents) {
		return false
	}
	for i := range this.SortedParents {
		if this.SortedParents[i] != that1.SortedParents[i] {
			return false
		}
	}
	if len(this.SortedChildren) != len(that1.SortedChildren) {
		return false
	}
	for i := range this.SortedChildren {
		if this.SortedChildren[i] != that1.SortedChildren[i] {
			return false
		}
	}
	return true
}
func (this *PlanNode) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PlanNode)
	if !ok {
		that2, ok := that.(PlanNode)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if !this.Op.Equal(that1.Op) {
		return false
	}
	return true
}
func (this *Operator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator)
	if !ok {
		that2, ok := that.(Operator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.OpType != that1.OpType {
		return false
	}
	if that1.Op == nil {
		if this.Op != nil {
			return false
		}
	} else if this.Op == nil {
		return false
	} else if !this.Op.Equal(that1.Op) {
		return false
	}
	return true
}
func (this *Operator_MemSourceOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_MemSourceOp)
	if !ok {
		that2, ok := that.(Operator_MemSourceOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MemSourceOp.Equal(that1.MemSourceOp) {
		return false
	}
	return true
}
func (this *Operator_MapOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_MapOp)
	if !ok {
		that2, ok := that.(Operator_MapOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MapOp.Equal(that1.MapOp) {
		return false
	}
	return true
}
func (this *Operator_AggOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_AggOp)
	if !ok {
		that2, ok := that.(Operator_AggOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.AggOp.Equal(that1.AggOp) {
		return false
	}
	return true
}
func (this *Operator_MemSinkOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_MemSinkOp)
	if !ok {
		that2, ok := that.(Operator_MemSinkOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MemSinkOp.Equal(that1.MemSinkOp) {
		return false
	}
	return true
}
func (this *Operator_FilterOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_FilterOp)
	if !ok {
		that2, ok := that.(Operator_FilterOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.FilterOp.Equal(that1.FilterOp) {
		return false
	}
	return true
}
func (this *Operator_LimitOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_LimitOp)
	if !ok {
		that2, ok := that.(Operator_LimitOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LimitOp.Equal(that1.LimitOp) {
		return false
	}
	return true
}
func (this *Operator_UnionOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_UnionOp)
	if !ok {
		that2, ok := that.(Operator_UnionOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.UnionOp.Equal(that1.UnionOp) {
		return false
	}
	return true
}
func (this *Operator_GRPCSourceOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_GRPCSourceOp)
	if !ok {
		that2, ok := that.(Operator_GRPCSourceOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.GRPCSourceOp.Equal(that1.GRPCSourceOp) {
		return false
	}
	return true
}
func (this *Operator_GRPCSinkOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_GRPCSinkOp)
	if !ok {
		that2, ok := that.(Operator_GRPCSinkOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.GRPCSinkOp.Equal(that1.GRPCSinkOp) {
		return false
	}
	return true
}
func (this *Operator_JoinOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_JoinOp)
	if !ok {
		that2, ok := that.(Operator_JoinOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.JoinOp.Equal(that1.JoinOp) {
		return false
	}
	return true
}
func (this *Operator_UdtfSourceOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_UdtfSourceOp)
	if !ok {
		that2, ok := that.(Operator_UdtfSourceOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.UdtfSourceOp.Equal(that1.UdtfSourceOp) {
		return false
	}
	return true
}
func (this *Operator_EmptySourceOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_EmptySourceOp)
	if !ok {
		that2, ok := that.(Operator_EmptySourceOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EmptySourceOp.Equal(that1.EmptySourceOp) {
		return false
	}
	return true
}
func (this *Operator_OTelSinkOp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Operator_OTelSinkOp)
	if !ok {
		that2, ok := that.(Operator_OTelSinkOp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.OTelSinkOp.Equal(that1.OTelSinkOp) {
		return false
	}
	return true
}
func (this *MemorySourceOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MemorySourceOperator)
	if !ok {
		that2, ok := that.(MemorySourceOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.ColumnIdxs) != len(that1.ColumnIdxs) {
		return false
	}
	for i := range this.ColumnIdxs {
		if this.ColumnIdxs[i] != that1.ColumnIdxs[i] {
			return false
		}
	}
	if len(this.ColumnNames) != len(that1.ColumnNames) {
		return false
	}
	for i := range this.ColumnNames {
		if this.ColumnNames[i] != that1.ColumnNames[i] {
			return false
		}
	}
	if len(this.ColumnTypes) != len(that1.ColumnTypes) {
		return false
	}
	for i := range this.ColumnTypes {
		if this.ColumnTypes[i] != that1.ColumnTypes[i] {
			return false
		}
	}
	if !this.StartTime.Equal(that1.StartTime) {
		return false
	}
	if !this.StopTime.Equal(that1.StopTime) {
		return false
	}
	if this.Tablet != that1.Tablet {
		return false
	}
	if this.Streaming != that1.Streaming {
		return false
	}
	return true
}
func (this *MemorySinkOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MemorySinkOperator)
	if !ok {
		that2, ok := that.(MemorySinkOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.ColumnTypes) != len(that1.ColumnTypes) {
		return false
	}
	for i := range this.ColumnTypes {
		if this.ColumnTypes[i] != that1.ColumnTypes[i] {
			return false
		}
	}
	if len(this.ColumnNames) != len(that1.ColumnNames) {
		return false
	}
	for i := range this.ColumnNames {
		if this.ColumnNames[i] != that1.ColumnNames[i] {
			return false
		}
	}
	if len(this.ColumnSemanticTypes) != len(that1.ColumnSemanticTypes) {
		return false
	}
	for i := range this.ColumnSemanticTypes {
		if this.ColumnSemanticTypes[i] != that1.ColumnSemanticTypes[i] {
			return false
		}
	}
	return true
}
func (this *GRPCSourceOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GRPCSourceOperator)
	if !ok {
		that2, ok := that.(GRPCSourceOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ColumnTypes) != len(that1.ColumnTypes) {
		return false
	}
	for i := range this.ColumnTypes {
		if this.ColumnTypes[i] != that1.ColumnTypes[i] {
			return false
		}
	}
	if len(this.ColumnNames) != len(that1.ColumnNames) {
		return false
	}
	for i := range this.ColumnNames {
		if this.ColumnNames[i] != that1.ColumnNames[i] {
			return false
		}
	}
	return true
}
func (this *GRPCSinkOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GRPCSinkOperator)
	if !ok {
		that2, ok := that.(GRPCSinkOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	if that1.Destination == nil {
		if this.Destination != nil {
			return false
		}
	} else if this.Destination == nil {
		return false
	} else if !this.Destination.Equal(that1.Destination) {
		return false
	}
	if !this.ConnectionOptions.Equal(that1.ConnectionOptions) {
		return false
	}
	return true
}
func (this *GRPCSinkOperator_GRPCSourceID) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GRPCSinkOperator_GRPCSourceID)
	if !ok {
		that2, ok := that.(GRPCSinkOperator_GRPCSourceID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.GRPCSourceID != that1.GRPCSourceID {
		return false
	}
	return true
}
func (this *GRPCSinkOperator_OutputTable) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GRPCSinkOperator_OutputTable)
	if !ok {
		that2, ok := that.(GRPCSinkOperator_OutputTable)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.OutputTable.Equal(that1.OutputTable) {
		return false
	}
	return true
}
func (this *GRPCSinkOperator_ResultTable) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GRPCSinkOperator_ResultTable)
	if !ok {
		that2, ok := that.(GRPCSinkOperator_ResultTable)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TableName != that1.TableName {
		return false
	}
	if len(this.ColumnTypes) != len(that1.ColumnTypes) {
		return false
	}
	for i := range this.ColumnTypes {
		if this.ColumnTypes[i] != that1.ColumnTypes[i] {
			return false
		}
	}
	if len(this.ColumnNames) != len(that1.ColumnNames) {
		return false
	}
	for i := range this.ColumnNames {
		if this.ColumnNames[i] != that1.ColumnNames[i] {
			return false
		}
	}
	if len(this.ColumnSemanticTypes) != len(that1.ColumnSemanticTypes) {
		return false
	}
	for i := range this.ColumnSemanticTypes {
		if this.ColumnSemanticTypes[i] != that1.ColumnSemanticTypes[i] {
			return false
		}
	}
	return true
}
func (this *GRPCSinkOperator_GRPCConnectionOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GRPCSinkOperator_GRPCConnectionOptions)
	if !ok {
		that2, ok := that.(GRPCSinkOperator_GRPCConnectionOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SslTargetname != that1.SslTargetname {
		return false
	}
	return true
}
func (this *MapOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MapOperator)
	if !ok {
		that2, ok := that.(MapOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Expressions) != len(that1.Expressions) {
		return false
	}
	for i := range this.Expressions {
		if !this.Expressions[i].Equal(that1.Expressions[i]) {
			return false
		}
	}
	if len(this.ColumnNames) != len(that1.ColumnNames) {
		return false
	}
	for i := range this.ColumnNames {
		if this.ColumnNames[i] != that1.ColumnNames[i] {
			return false
		}
	}
	return true
}
func (this *AggregateOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AggregateOperator)
	if !ok {
		that2, ok := that.(AggregateOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if !this.Values[i].Equal(that1.Values[i]) {
			return false
		}
	}
	if len(this.Groups) != len(that1.Groups) {
		return false
	}
	for i := range this.Groups {
		if !this.Groups[i].Equal(that1.Groups[i]) {
			return false
		}
	}
	if len(this.GroupNames) != len(that1.GroupNames) {
		return false
	}
	for i := range this.GroupNames {
		if this.GroupNames[i] != that1.GroupNames[i] {
			return false
		}
	}
	if len(this.ValueNames) != len(that1.ValueNames) {
		return false
	}
	for i := range this.ValueNames {
		if this.ValueNames[i] != that1.ValueNames[i] {
			return false
		}
	}
	if this.Windowed != that1.Windowed {
		return false
	}
	if this.PartialAgg != that1.PartialAgg {
		return false
	}
	if this.FinalizeResults != that1.FinalizeResults {
		return false
	}
	return true
}
func (this *FilterOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FilterOperator)
	if !ok {
		that2, ok := that.(FilterOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Expression.Equal(that1.Expression) {
		return false
	}
	if len(this.Columns) != len(that1.Columns) {
		return false
	}
	for i := range this.Columns {
		if !this.Columns[i].Equal(that1.Columns[i]) {
			return false
		}
	}
	return true
}
func (this *LimitOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LimitOperator)
	if !ok {
		that2, ok := that.(LimitOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Limit != that1.Limit {
		return false
	}
	if len(this.Columns) != len(that1.Columns) {
		return false
	}
	for i := range this.Columns {
		if !this.Columns[i].Equal(that1.Columns[i]) {
			return false
		}
	}
	if len(this.AbortableSrcs) != len(that1.AbortableSrcs) {
		return false
	}
	for i := range this.AbortableSrcs {
		if this.AbortableSrcs[i] != that1.AbortableSrcs[i] {
			return false
		}
	}
	return true
}
func (this *UnionOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UnionOperator)
	if !ok {
		that2, ok := that.(UnionOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ColumnNames) != len(that1.ColumnNames) {
		return false
	}
	for i := range this.ColumnNames {
		if this.ColumnNames[i] != that1.ColumnNames[i] {
			return false
		}
	}
	if len(this.ColumnMappings) != len(that1.ColumnMappings) {
		return false
	}
	for i := range this.ColumnMappings {
		if !this.ColumnMappings[i].Equal(that1.ColumnMappings[i]) {
			return false
		}
	}
	if this.RowsPerBatch != that1.RowsPerBatch {
		return false
	}
	return true
}
func (this *UnionOperator_ColumnMapping) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UnionOperator_ColumnMapping)
	if !ok {
		that2, ok := that.(UnionOperator_ColumnMapping)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ColumnIndexes) != len(that1.ColumnIndexes) {
		return false
	}
	for i := range this.ColumnIndexes {
		if this.ColumnIndexes[i] != that1.ColumnIndexes[i] {
			return false
		}
	}
	return true
}
func (this *JoinOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JoinOperator)
	if !ok {
		that2, ok := that.(JoinOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if len(this.EqualityConditions) != len(that1.EqualityConditions) {
		return false
	}
	for i := range this.EqualityConditions {
		if !this.EqualityConditions[i].Equal(that1.EqualityConditions[i]) {
			return false
		}
	}
	if len(this.OutputColumns) != len(that1.OutputColumns) {
		return false
	}
	for i := range this.OutputColumns {
		if !this.OutputColumns[i].Equal(that1.OutputColumns[i]) {
			return false
		}
	}
	if len(this.ColumnNames) != len(that1.ColumnNames) {
		return false
	}
	for i := range this.ColumnNames {
		if this.ColumnNames[i] != that1.ColumnNames[i] {
			return false
		}
	}
	if this.RowsPerBatch != that1.RowsPerBatch {
		return false
	}
	return true
}
func (this *JoinOperator_EqualityCondition) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JoinOperator_EqualityCondition)
	if !ok {
		that2, ok := that.(JoinOperator_EqualityCondition)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.LeftColumnIndex != that1.LeftColumnIndex {
		return false
	}
	if this.RightColumnIndex != that1.RightColumnIndex {
		return false
	}
	return true
}
func (this *JoinOperator_ParentColumn) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JoinOperator_ParentColumn)
	if !ok {
		that2, ok := that.(JoinOperator_ParentColumn)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ParentIndex != that1.ParentIndex {
		return false
	}
	if this.ColumnIndex != that1.ColumnIndex {
		return false
	}
	return true
}
func (this *UDTFSourceOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UDTFSourceOperator)
	if !ok {
		that2, ok := that.(UDTFSourceOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.ArgValues) != len(that1.ArgValues) {
		return false
	}
	for i := range this.ArgValues {
		if !this.ArgValues[i].Equal(that1.ArgValues[i]) {
			return false
		}
	}
	return true
}
func (this *EmptySourceOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EmptySourceOperator)
	if !ok {
		that2, ok := that.(EmptySourceOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ColumnNames) != len(that1.ColumnNames) {
		return false
	}
	for i := range this.ColumnNames {
		if this.ColumnNames[i] != that1.ColumnNames[i] {
			return false
		}
	}
	if len(this.ColumnTypes) != len(that1.ColumnTypes) {
		return false
	}
	for i := range this.ColumnTypes {
		if this.ColumnTypes[i] != that1.ColumnTypes[i] {
			return false
		}
	}
	return true
}
func (this *OTelLog) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelLog)
	if !ok {
		that2, ok := that.(OTelLog)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	if this.TimeColumnIndex != that1.TimeColumnIndex {
		return false
	}
	if this.ObservedTimeColumnIndex != that1.ObservedTimeColumnIndex {
		return false
	}
	if this.SeverityNumber != that1.SeverityNumber {
		return false
	}
	if this.SeverityText != that1.SeverityText {
		return false
	}
	if this.BodyColumnIndex != that1.BodyColumnIndex {
		return false
	}
	return true
}
func (this *OTelSpan) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelSpan)
	if !ok {
		that2, ok := that.(OTelSpan)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Name == nil {
		if this.Name != nil {
			return false
		}
	} else if this.Name == nil {
		return false
	} else if !this.Name.Equal(that1.Name) {
		return false
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	if this.TraceIDColumn != that1.TraceIDColumn {
		return false
	}
	if this.SpanIDColumn != that1.SpanIDColumn {
		return false
	}
	if this.ParentSpanIDColumn != that1.ParentSpanIDColumn {
		return false
	}
	if this.StartTimeColumnIndex != that1.StartTimeColumnIndex {
		return false
	}
	if this.EndTimeColumnIndex != that1.EndTimeColumnIndex {
		return false
	}
	if this.KindValue != that1.KindValue {
		return false
	}
	return true
}
func (this *OTelSpan_NameString) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelSpan_NameString)
	if !ok {
		that2, ok := that.(OTelSpan_NameString)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NameString != that1.NameString {
		return false
	}
	return true
}
func (this *OTelSpan_NameColumnIndex) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelSpan_NameColumnIndex)
	if !ok {
		that2, ok := that.(OTelSpan_NameColumnIndex)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NameColumnIndex != that1.NameColumnIndex {
		return false
	}
	return true
}
func (this *OTelMetricGauge) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelMetricGauge)
	if !ok {
		that2, ok := that.(OTelMetricGauge)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.ValueColumn == nil {
		if this.ValueColumn != nil {
			return false
		}
	} else if this.ValueColumn == nil {
		return false
	} else if !this.ValueColumn.Equal(that1.ValueColumn) {
		return false
	}
	return true
}
func (this *OTelMetricGauge_FloatColumnIndex) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelMetricGauge_FloatColumnIndex)
	if !ok {
		that2, ok := that.(OTelMetricGauge_FloatColumnIndex)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.FloatColumnIndex != that1.FloatColumnIndex {
		return false
	}
	return true
}
func (this *OTelMetricGauge_IntColumnIndex) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelMetricGauge_IntColumnIndex)
	if !ok {
		that2, ok := that.(OTelMetricGauge_IntColumnIndex)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.IntColumnIndex != that1.IntColumnIndex {
		return false
	}
	return true
}
func (this *OTelMetricSummary) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelMetricSummary)
	if !ok {
		that2, ok := that.(OTelMetricSummary)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CountColumnIndex != that1.CountColumnIndex {
		return false
	}
	if this.SumColumnIndex != that1.SumColumnIndex {
		return false
	}
	if len(this.QuantileValues) != len(that1.QuantileValues) {
		return false
	}
	for i := range this.QuantileValues {
		if !this.QuantileValues[i].Equal(that1.QuantileValues[i]) {
			return false
		}
	}
	return true
}
func (this *OTelMetricSummary_ValueAtQuantile) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelMetricSummary_ValueAtQuantile)
	if !ok {
		that2, ok := that.(OTelMetricSummary_ValueAtQuantile)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Quantile != that1.Quantile {
		return false
	}
	if this.ValueColumnIndex != that1.ValueColumnIndex {
		return false
	}
	return true
}
func (this *OTelAttribute) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelAttribute)
	if !ok {
		that2, ok := that.(OTelAttribute)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.Value == nil {
		if this.Value != nil {
			return false
		}
	} else if this.Value == nil {
		return false
	} else if !this.Value.Equal(that1.Value) {
		return false
	}
	return true
}
func (this *OTelAttribute_Column_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelAttribute_Column_)
	if !ok {
		that2, ok := that.(OTelAttribute_Column_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Column.Equal(that1.Column) {
		return false
	}
	return true
}
func (this *OTelAttribute_StringValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelAttribute_StringValue)
	if !ok {
		that2, ok := that.(OTelAttribute_StringValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StringValue != that1.StringValue {
		return false
	}
	return true
}
func (this *OTelAttribute_Column) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelAttribute_Column)
	if !ok {
		that2, ok := that.(OTelAttribute_Column)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ColumnType != that1.ColumnType {
		return false
	}
	if this.ColumnIndex != that1.ColumnIndex {
		return false
	}
	if this.CanBeJsonEncodedArray != that1.CanBeJsonEncodedArray {
		return false
	}
	return true
}
func (this *OTelMetric) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelMetric)
	if !ok {
		that2, ok := that.(OTelMetric)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Description != that1.Description {
		return false
	}
	if this.Unit != that1.Unit {
		return false
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	if this.TimeColumnIndex != that1.TimeColumnIndex {
		return false
	}
	if that1.Data == nil {
		if this.Data != nil {
			return false
		}
	} else if this.Data == nil {
		return false
	} else if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (this *OTelMetric_Gauge) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelMetric_Gauge)
	if !ok {
		that2, ok := that.(OTelMetric_Gauge)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Gauge.Equal(that1.Gauge) {
		return false
	}
	return true
}
func (this *OTelMetric_Summary) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelMetric_Summary)
	if !ok {
		that2, ok := that.(OTelMetric_Summary)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Summary.Equal(that1.Summary) {
		return false
	}
	return true
}
func (this *OTelEndpointConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelEndpointConfig)
	if !ok {
		that2, ok := that.(OTelEndpointConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.URL != that1.URL {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if this.Headers[i] != that1.Headers[i] {
			return false
		}
	}
	if this.Insecure != that1.Insecure {
		return false
	}
	if this.Timeout != that1.Timeout {
		return false
	}
	return true
}
func (this *OTelResource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelResource)
	if !ok {
		that2, ok := that.(OTelResource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	return true
}
func (this *OTelExportSinkOperator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OTelExportSinkOperator)
	if !ok {
		that2, ok := that.(OTelExportSinkOperator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EndpointConfig.Equal(that1.EndpointConfig) {
		return false
	}
	if !this.Resource.Equal(that1.Resource) {
		return false
	}
	if len(this.Metrics) != len(that1.Metrics) {
		return false
	}
	for i := range this.Metrics {
		if !this.Metrics[i].Equal(that1.Metrics[i]) {
			return false
		}
	}
	if len(this.Spans) != len(that1.Spans) {
		return false
	}
	for i := range this.Spans {
		if !this.Spans[i].Equal(that1.Spans[i]) {
			return false
		}
	}
	if len(this.Logs) != len(that1.Logs) {
		return false
	}
	for i := range this.Logs {
		if !this.Logs[i].Equal(that1.Logs[i]) {
			return false
		}
	}
	return true
}
func (this *ScalarExpression) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarExpression)
	if !ok {
		that2, ok := that.(ScalarExpression)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Value == nil {
		if this.Value != nil {
			return false
		}
	} else if this.Value == nil {
		return false
	} else if !this.Value.Equal(that1.Value) {
		return false
	}
	return true
}
func (this *ScalarExpression_Constant) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarExpression_Constant)
	if !ok {
		that2, ok := that.(ScalarExpression_Constant)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Constant.Equal(that1.Constant) {
		return false
	}
	return true
}
func (this *ScalarExpression_Column) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarExpression_Column)
	if !ok {
		that2, ok := that.(ScalarExpression_Column)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Column.Equal(that1.Column) {
		return false
	}
	return true
}
func (this *ScalarExpression_Func) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarExpression_Func)
	if !ok {
		that2, ok := that.(ScalarExpression_Func)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Func.Equal(that1.Func) {
		return false
	}
	return true
}
func (this *ScalarValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarValue)
	if !ok {
		that2, ok := that.(ScalarValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.DataType != that1.DataType {
		return false
	}
	if that1.Value == nil {
		if this.Value != nil {
			return false
		}
	} else if this.Value == nil {
		return false
	} else if !this.Value.Equal(that1.Value) {
		return false
	}
	return true
}
func (this *ScalarValue_BoolValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarValue_BoolValue)
	if !ok {
		that2, ok := that.(ScalarValue_BoolValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BoolValue != that1.BoolValue {
		return false
	}
	return true
}
func (this *ScalarValue_Int64Value) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarValue_Int64Value)
	if !ok {
		that2, ok := that.(ScalarValue_Int64Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Int64Value != that1.Int64Value {
		return false
	}
	return true
}
func (this *ScalarValue_Float64Value) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarValue_Float64Value)
	if !ok {
		that2, ok := that.(ScalarValue_Float64Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Float64Value != that1.Float64Value {
		return false
	}
	return true
}
func (this *ScalarValue_StringValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarValue_StringValue)
	if !ok {
		that2, ok := that.(ScalarValue_StringValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StringValue != that1.StringValue {
		return false
	}
	return true
}
func (this *ScalarValue_Time64NsValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarValue_Time64NsValue)
	if !ok {
		that2, ok := that.(ScalarValue_Time64NsValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Time64NsValue != that1.Time64NsValue {
		return false
	}
	return true
}
func (this *ScalarValue_Uint128Value) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarValue_Uint128Value)
	if !ok {
		that2, ok := that.(ScalarValue_Uint128Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Uint128Value.Equal(that1.Uint128Value) {
		return false
	}
	return true
}
func (this *ScalarFunc) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScalarFunc)
	if !ok {
		that2, ok := that.(ScalarFunc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.InitArgs) != len(that1.InitArgs) {
		return false
	}
	for i := range this.InitArgs {
		if !this.InitArgs[i].Equal(that1.InitArgs[i]) {
			return false
		}
	}
	if len(this.Args) != len(that1.Args) {
		return false
	}
	for i := range this.Args {
		if !this.Args[i].Equal(that1.Args[i]) {
			return false
		}
	}
	if this.Id != that1.Id {
		return false
	}
	if len(this.ArgsDataTypes) != len(that1.ArgsDataTypes) {
		return false
	}
	for i := range this.ArgsDataTypes {
		if this.ArgsDataTypes[i] != that1.ArgsDataTypes[i] {
			return false
		}
	}
	return true
}
func (this *AggregateExpression) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AggregateExpression)
	if !ok {
		that2, ok := that.(AggregateExpression)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.InitArgs) != len(that1.InitArgs) {
		return false
	}
	for i := range this.InitArgs {
		if !this.InitArgs[i].Equal(that1.InitArgs[i]) {
			return false
		}
	}
	if len(this.Args) != len(that1.Args) {
		return false
	}
	for i := range this.Args {
		if !this.Args[i].Equal(that1.Args[i]) {
			return false
		}
	}
	if this.Id != that1.Id {
		return false
	}
	if len(this.ArgsDataTypes) != len(that1.ArgsDataTypes) {
		return false
	}
	for i := range this.ArgsDataTypes {
		if this.ArgsDataTypes[i] != that1.ArgsDataTypes[i] {
			return false
		}
	}
	return true
}
func (this *AggregateExpression_Arg) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AggregateExpression_Arg)
	if !ok {
		that2, ok := that.(AggregateExpression_Arg)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Value == nil {
		if this.Value != nil {
			return false
		}
	} else if this.Value == nil {
		return false
	} else if !this.Value.Equal(that1.Value) {
		return false
	}
	return true
}
func (this *AggregateExpression_Arg_Constant) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AggregateExpression_Arg_Constant)
	if !ok {
		that2, ok := that.(AggregateExpression_Arg_Constant)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Constant.Equal(that1.Constant) {
		return false
	}
	return true
}
func (this *AggregateExpression_Arg_Column) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AggregateExpression_Arg_Column)
	if !ok {
		that2, ok := that.(AggregateExpression_Arg_Column)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Column.Equal(that1.Column) {
		return false
	}
	return true
}
func (this *Column) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Column)
	if !ok {
		that2, ok := that.(Column)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Node != that1.Node {
		return false
	}
	if this.Index != that1.Index {
		return false
	}
	return true
}
func (this *PlanOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.PlanOptions{")
	s = append(s, "Explain: "+fmt.Sprintf("%#v", this.Explain)+",\n")
	s = append(s, "Analyze: "+fmt.Sprintf("%#v", this.Analyze)+",\n")
	s = append(s, "MaxOutputRowsPerTable: "+fmt.Sprintf("%#v", this.MaxOutputRowsPerTable)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Plan) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&planpb.Plan{")
	if this.Dag != nil {
		s = append(s, "Dag: "+fmt.Sprintf("%#v", this.Dag)+",\n")
	}
	if this.Nodes != nil {
		s = append(s, "Nodes: "+fmt.Sprintf("%#v", this.Nodes)+",\n")
	}
	if this.PlanOptions != nil {
		s = append(s, "PlanOptions: "+fmt.Sprintf("%#v", this.PlanOptions)+",\n")
	}
	if this.IncomingAgentIDs != nil {
		s = append(s, "IncomingAgentIDs: "+fmt.Sprintf("%#v", this.IncomingAgentIDs)+",\n")
	}
	if this.ExecutionStatusDestinations != nil {
		s = append(s, "ExecutionStatusDestinations: "+fmt.Sprintf("%#v", this.ExecutionStatusDestinations)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Plan_ExecutionStatusDestination) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.Plan_ExecutionStatusDestination{")
	s = append(s, "GrpcAddress: "+fmt.Sprintf("%#v", this.GrpcAddress)+",\n")
	s = append(s, "SslTargetname: "+fmt.Sprintf("%#v", this.SslTargetname)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PlanFragment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.PlanFragment{")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	if this.Dag != nil {
		s = append(s, "Dag: "+fmt.Sprintf("%#v", this.Dag)+",\n")
	}
	if this.Nodes != nil {
		s = append(s, "Nodes: "+fmt.Sprintf("%#v", this.Nodes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DAG) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&planpb.DAG{")
	if this.Nodes != nil {
		s = append(s, "Nodes: "+fmt.Sprintf("%#v", this.Nodes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DAG_DAGNode) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.DAG_DAGNode{")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	s = append(s, "SortedParents: "+fmt.Sprintf("%#v", this.SortedParents)+",\n")
	s = append(s, "SortedChildren: "+fmt.Sprintf("%#v", this.SortedChildren)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PlanNode) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.PlanNode{")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	if this.Op != nil {
		s = append(s, "Op: "+fmt.Sprintf("%#v", this.Op)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Operator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 18)
	s = append(s, "&planpb.Operator{")
	s = append(s, "OpType: "+fmt.Sprintf("%#v", this.OpType)+",\n")
	if this.Op != nil {
		s = append(s, "Op: "+fmt.Sprintf("%#v", this.Op)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Operator_MemSourceOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_MemSourceOp{` +
		`MemSourceOp:` + fmt.Sprintf("%#v", this.MemSourceOp) + `}`}, ", ")
	return s
}
func (this *Operator_MapOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_MapOp{` +
		`MapOp:` + fmt.Sprintf("%#v", this.MapOp) + `}`}, ", ")
	return s
}
func (this *Operator_AggOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_AggOp{` +
		`AggOp:` + fmt.Sprintf("%#v", this.AggOp) + `}`}, ", ")
	return s
}
func (this *Operator_MemSinkOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_MemSinkOp{` +
		`MemSinkOp:` + fmt.Sprintf("%#v", this.MemSinkOp) + `}`}, ", ")
	return s
}
func (this *Operator_FilterOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_FilterOp{` +
		`FilterOp:` + fmt.Sprintf("%#v", this.FilterOp) + `}`}, ", ")
	return s
}
func (this *Operator_LimitOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_LimitOp{` +
		`LimitOp:` + fmt.Sprintf("%#v", this.LimitOp) + `}`}, ", ")
	return s
}
func (this *Operator_UnionOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_UnionOp{` +
		`UnionOp:` + fmt.Sprintf("%#v", this.UnionOp) + `}`}, ", ")
	return s
}
func (this *Operator_GRPCSourceOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_GRPCSourceOp{` +
		`GRPCSourceOp:` + fmt.Sprintf("%#v", this.GRPCSourceOp) + `}`}, ", ")
	return s
}
func (this *Operator_GRPCSinkOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_GRPCSinkOp{` +
		`GRPCSinkOp:` + fmt.Sprintf("%#v", this.GRPCSinkOp) + `}`}, ", ")
	return s
}
func (this *Operator_JoinOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_JoinOp{` +
		`JoinOp:` + fmt.Sprintf("%#v", this.JoinOp) + `}`}, ", ")
	return s
}
func (this *Operator_UdtfSourceOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_UdtfSourceOp{` +
		`UdtfSourceOp:` + fmt.Sprintf("%#v", this.UdtfSourceOp) + `}`}, ", ")
	return s
}
func (this *Operator_EmptySourceOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_EmptySourceOp{` +
		`EmptySourceOp:` + fmt.Sprintf("%#v", this.EmptySourceOp) + `}`}, ", ")
	return s
}
func (this *Operator_OTelSinkOp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.Operator_OTelSinkOp{` +
		`OTelSinkOp:` + fmt.Sprintf("%#v", this.OTelSinkOp) + `}`}, ", ")
	return s
}
func (this *MemorySourceOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&planpb.MemorySourceOperator{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "ColumnIdxs: "+fmt.Sprintf("%#v", this.ColumnIdxs)+",\n")
	s = append(s, "ColumnNames: "+fmt.Sprintf("%#v", this.ColumnNames)+",\n")
	s = append(s, "ColumnTypes: "+fmt.Sprintf("%#v", this.ColumnTypes)+",\n")
	if this.StartTime != nil {
		s = append(s, "StartTime: "+fmt.Sprintf("%#v", this.StartTime)+",\n")
	}
	if this.StopTime != nil {
		s = append(s, "StopTime: "+fmt.Sprintf("%#v", this.StopTime)+",\n")
	}
	s = append(s, "Tablet: "+fmt.Sprintf("%#v", this.Tablet)+",\n")
	s = append(s, "Streaming: "+fmt.Sprintf("%#v", this.Streaming)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MemorySinkOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&planpb.MemorySinkOperator{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "ColumnTypes: "+fmt.Sprintf("%#v", this.ColumnTypes)+",\n")
	s = append(s, "ColumnNames: "+fmt.Sprintf("%#v", this.ColumnNames)+",\n")
	s = append(s, "ColumnSemanticTypes: "+fmt.Sprintf("%#v", this.ColumnSemanticTypes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GRPCSourceOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.GRPCSourceOperator{")
	s = append(s, "ColumnTypes: "+fmt.Sprintf("%#v", this.ColumnTypes)+",\n")
	s = append(s, "ColumnNames: "+fmt.Sprintf("%#v", this.ColumnNames)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GRPCSinkOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&planpb.GRPCSinkOperator{")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	if this.Destination != nil {
		s = append(s, "Destination: "+fmt.Sprintf("%#v", this.Destination)+",\n")
	}
	if this.ConnectionOptions != nil {
		s = append(s, "ConnectionOptions: "+fmt.Sprintf("%#v", this.ConnectionOptions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GRPCSinkOperator_GRPCSourceID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.GRPCSinkOperator_GRPCSourceID{` +
		`GRPCSourceID:` + fmt.Sprintf("%#v", this.GRPCSourceID) + `}`}, ", ")
	return s
}
func (this *GRPCSinkOperator_OutputTable) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.GRPCSinkOperator_OutputTable{` +
		`OutputTable:` + fmt.Sprintf("%#v", this.OutputTable) + `}`}, ", ")
	return s
}
func (this *GRPCSinkOperator_ResultTable) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&planpb.GRPCSinkOperator_ResultTable{")
	s = append(s, "TableName: "+fmt.Sprintf("%#v", this.TableName)+",\n")
	s = append(s, "ColumnTypes: "+fmt.Sprintf("%#v", this.ColumnTypes)+",\n")
	s = append(s, "ColumnNames: "+fmt.Sprintf("%#v", this.ColumnNames)+",\n")
	s = append(s, "ColumnSemanticTypes: "+fmt.Sprintf("%#v", this.ColumnSemanticTypes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GRPCSinkOperator_GRPCConnectionOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&planpb.GRPCSinkOperator_GRPCConnectionOptions{")
	s = append(s, "SslTargetname: "+fmt.Sprintf("%#v", this.SslTargetname)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MapOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.MapOperator{")
	if this.Expressions != nil {
		s = append(s, "Expressions: "+fmt.Sprintf("%#v", this.Expressions)+",\n")
	}
	s = append(s, "ColumnNames: "+fmt.Sprintf("%#v", this.ColumnNames)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AggregateOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&planpb.AggregateOperator{")
	if this.Values != nil {
		s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	}
	if this.Groups != nil {
		s = append(s, "Groups: "+fmt.Sprintf("%#v", this.Groups)+",\n")
	}
	s = append(s, "GroupNames: "+fmt.Sprintf("%#v", this.GroupNames)+",\n")
	s = append(s, "ValueNames: "+fmt.Sprintf("%#v", this.ValueNames)+",\n")
	s = append(s, "Windowed: "+fmt.Sprintf("%#v", this.Windowed)+",\n")
	s = append(s, "PartialAgg: "+fmt.Sprintf("%#v", this.PartialAgg)+",\n")
	s = append(s, "FinalizeResults: "+fmt.Sprintf("%#v", this.FinalizeResults)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FilterOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.FilterOperator{")
	if this.Expression != nil {
		s = append(s, "Expression: "+fmt.Sprintf("%#v", this.Expression)+",\n")
	}
	if this.Columns != nil {
		s = append(s, "Columns: "+fmt.Sprintf("%#v", this.Columns)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LimitOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.LimitOperator{")
	s = append(s, "Limit: "+fmt.Sprintf("%#v", this.Limit)+",\n")
	if this.Columns != nil {
		s = append(s, "Columns: "+fmt.Sprintf("%#v", this.Columns)+",\n")
	}
	s = append(s, "AbortableSrcs: "+fmt.Sprintf("%#v", this.AbortableSrcs)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UnionOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.UnionOperator{")
	s = append(s, "ColumnNames: "+fmt.Sprintf("%#v", this.ColumnNames)+",\n")
	if this.ColumnMappings != nil {
		s = append(s, "ColumnMappings: "+fmt.Sprintf("%#v", this.ColumnMappings)+",\n")
	}
	s = append(s, "RowsPerBatch: "+fmt.Sprintf("%#v", this.RowsPerBatch)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UnionOperator_ColumnMapping) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&planpb.UnionOperator_ColumnMapping{")
	s = append(s, "ColumnIndexes: "+fmt.Sprintf("%#v", this.ColumnIndexes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *JoinOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&planpb.JoinOperator{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.EqualityConditions != nil {
		s = append(s, "EqualityConditions: "+fmt.Sprintf("%#v", this.EqualityConditions)+",\n")
	}
	if this.OutputColumns != nil {
		s = append(s, "OutputColumns: "+fmt.Sprintf("%#v", this.OutputColumns)+",\n")
	}
	s = append(s, "ColumnNames: "+fmt.Sprintf("%#v", this.ColumnNames)+",\n")
	s = append(s, "RowsPerBatch: "+fmt.Sprintf("%#v", this.RowsPerBatch)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *JoinOperator_EqualityCondition) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.JoinOperator_EqualityCondition{")
	s = append(s, "LeftColumnIndex: "+fmt.Sprintf("%#v", this.LeftColumnIndex)+",\n")
	s = append(s, "RightColumnIndex: "+fmt.Sprintf("%#v", this.RightColumnIndex)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *JoinOperator_ParentColumn) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.JoinOperator_ParentColumn{")
	s = append(s, "ParentIndex: "+fmt.Sprintf("%#v", this.ParentIndex)+",\n")
	s = append(s, "ColumnIndex: "+fmt.Sprintf("%#v", this.ColumnIndex)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UDTFSourceOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.UDTFSourceOperator{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.ArgValues != nil {
		s = append(s, "ArgValues: "+fmt.Sprintf("%#v", this.ArgValues)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *EmptySourceOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.EmptySourceOperator{")
	s = append(s, "ColumnNames: "+fmt.Sprintf("%#v", this.ColumnNames)+",\n")
	s = append(s, "ColumnTypes: "+fmt.Sprintf("%#v", this.ColumnTypes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelLog) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&planpb.OTelLog{")
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	s = append(s, "TimeColumnIndex: "+fmt.Sprintf("%#v", this.TimeColumnIndex)+",\n")
	s = append(s, "ObservedTimeColumnIndex: "+fmt.Sprintf("%#v", this.ObservedTimeColumnIndex)+",\n")
	s = append(s, "SeverityNumber: "+fmt.Sprintf("%#v", this.SeverityNumber)+",\n")
	s = append(s, "SeverityText: "+fmt.Sprintf("%#v", this.SeverityText)+",\n")
	s = append(s, "BodyColumnIndex: "+fmt.Sprintf("%#v", this.BodyColumnIndex)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelSpan) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&planpb.OTelSpan{")
	if this.Name != nil {
		s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	}
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	s = append(s, "TraceIDColumn: "+fmt.Sprintf("%#v", this.TraceIDColumn)+",\n")
	s = append(s, "SpanIDColumn: "+fmt.Sprintf("%#v", this.SpanIDColumn)+",\n")
	s = append(s, "ParentSpanIDColumn: "+fmt.Sprintf("%#v", this.ParentSpanIDColumn)+",\n")
	s = append(s, "StartTimeColumnIndex: "+fmt.Sprintf("%#v", this.StartTimeColumnIndex)+",\n")
	s = append(s, "EndTimeColumnIndex: "+fmt.Sprintf("%#v", this.EndTimeColumnIndex)+",\n")
	s = append(s, "KindValue: "+fmt.Sprintf("%#v", this.KindValue)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelSpan_NameString) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.OTelSpan_NameString{` +
		`NameString:` + fmt.Sprintf("%#v", this.NameString) + `}`}, ", ")
	return s
}
func (this *OTelSpan_NameColumnIndex) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.OTelSpan_NameColumnIndex{` +
		`NameColumnIndex:` + fmt.Sprintf("%#v", this.NameColumnIndex) + `}`}, ", ")
	return s
}
func (this *OTelMetricGauge) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.OTelMetricGauge{")
	if this.ValueColumn != nil {
		s = append(s, "ValueColumn: "+fmt.Sprintf("%#v", this.ValueColumn)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelMetricGauge_FloatColumnIndex) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.OTelMetricGauge_FloatColumnIndex{` +
		`FloatColumnIndex:` + fmt.Sprintf("%#v", this.FloatColumnIndex) + `}`}, ", ")
	return s
}
func (this *OTelMetricGauge_IntColumnIndex) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.OTelMetricGauge_IntColumnIndex{` +
		`IntColumnIndex:` + fmt.Sprintf("%#v", this.IntColumnIndex) + `}`}, ", ")
	return s
}
func (this *OTelMetricSummary) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.OTelMetricSummary{")
	s = append(s, "CountColumnIndex: "+fmt.Sprintf("%#v", this.CountColumnIndex)+",\n")
	s = append(s, "SumColumnIndex: "+fmt.Sprintf("%#v", this.SumColumnIndex)+",\n")
	if this.QuantileValues != nil {
		s = append(s, "QuantileValues: "+fmt.Sprintf("%#v", this.QuantileValues)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelMetricSummary_ValueAtQuantile) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.OTelMetricSummary_ValueAtQuantile{")
	s = append(s, "Quantile: "+fmt.Sprintf("%#v", this.Quantile)+",\n")
	s = append(s, "ValueColumnIndex: "+fmt.Sprintf("%#v", this.ValueColumnIndex)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelAttribute) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.OTelAttribute{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Value != nil {
		s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelAttribute_Column_) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.OTelAttribute_Column_{` +
		`Column:` + fmt.Sprintf("%#v", this.Column) + `}`}, ", ")
	return s
}
func (this *OTelAttribute_StringValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.OTelAttribute_StringValue{` +
		`StringValue:` + fmt.Sprintf("%#v", this.StringValue) + `}`}, ", ")
	return s
}
func (this *OTelAttribute_Column) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.OTelAttribute_Column{")
	s = append(s, "ColumnType: "+fmt.Sprintf("%#v", this.ColumnType)+",\n")
	s = append(s, "ColumnIndex: "+fmt.Sprintf("%#v", this.ColumnIndex)+",\n")
	s = append(s, "CanBeJsonEncodedArray: "+fmt.Sprintf("%#v", this.CanBeJsonEncodedArray)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelMetric) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&planpb.OTelMetric{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	s = append(s, "Unit: "+fmt.Sprintf("%#v", this.Unit)+",\n")
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	s = append(s, "TimeColumnIndex: "+fmt.Sprintf("%#v", this.TimeColumnIndex)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelMetric_Gauge) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.OTelMetric_Gauge{` +
		`Gauge:` + fmt.Sprintf("%#v", this.Gauge) + `}`}, ", ")
	return s
}
func (this *OTelMetric_Summary) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.OTelMetric_Summary{` +
		`Summary:` + fmt.Sprintf("%#v", this.Summary) + `}`}, ", ")
	return s
}
func (this *OTelEndpointConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&planpb.OTelEndpointConfig{")
	s = append(s, "URL: "+fmt.Sprintf("%#v", this.URL)+",\n")
	keysForHeaders := make([]string, 0, len(this.Headers))
	for k, _ := range this.Headers {
		keysForHeaders = append(keysForHeaders, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForHeaders)
	mapStringForHeaders := "map[string]string{"
	for _, k := range keysForHeaders {
		mapStringForHeaders += fmt.Sprintf("%#v: %#v,", k, this.Headers[k])
	}
	mapStringForHeaders += "}"
	if this.Headers != nil {
		s = append(s, "Headers: "+mapStringForHeaders+",\n")
	}
	s = append(s, "Insecure: "+fmt.Sprintf("%#v", this.Insecure)+",\n")
	s = append(s, "Timeout: "+fmt.Sprintf("%#v", this.Timeout)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelResource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&planpb.OTelResource{")
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OTelExportSinkOperator) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&planpb.OTelExportSinkOperator{")
	if this.EndpointConfig != nil {
		s = append(s, "EndpointConfig: "+fmt.Sprintf("%#v", this.EndpointConfig)+",\n")
	}
	if this.Resource != nil {
		s = append(s, "Resource: "+fmt.Sprintf("%#v", this.Resource)+",\n")
	}
	if this.Metrics != nil {
		s = append(s, "Metrics: "+fmt.Sprintf("%#v", this.Metrics)+",\n")
	}
	if this.Spans != nil {
		s = append(s, "Spans: "+fmt.Sprintf("%#v", this.Spans)+",\n")
	}
	if this.Logs != nil {
		s = append(s, "Logs: "+fmt.Sprintf("%#v", this.Logs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScalarExpression) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&planpb.ScalarExpression{")
	if this.Value != nil {
		s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScalarExpression_Constant) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarExpression_Constant{` +
		`Constant:` + fmt.Sprintf("%#v", this.Constant) + `}`}, ", ")
	return s
}
func (this *ScalarExpression_Column) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarExpression_Column{` +
		`Column:` + fmt.Sprintf("%#v", this.Column) + `}`}, ", ")
	return s
}
func (this *ScalarExpression_Func) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarExpression_Func{` +
		`Func:` + fmt.Sprintf("%#v", this.Func) + `}`}, ", ")
	return s
}
func (this *ScalarValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&planpb.ScalarValue{")
	s = append(s, "DataType: "+fmt.Sprintf("%#v", this.DataType)+",\n")
	if this.Value != nil {
		s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ScalarValue_BoolValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarValue_BoolValue{` +
		`BoolValue:` + fmt.Sprintf("%#v", this.BoolValue) + `}`}, ", ")
	return s
}
func (this *ScalarValue_Int64Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarValue_Int64Value{` +
		`Int64Value:` + fmt.Sprintf("%#v", this.Int64Value) + `}`}, ", ")
	return s
}
func (this *ScalarValue_Float64Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarValue_Float64Value{` +
		`Float64Value:` + fmt.Sprintf("%#v", this.Float64Value) + `}`}, ", ")
	return s
}
func (this *ScalarValue_StringValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarValue_StringValue{` +
		`StringValue:` + fmt.Sprintf("%#v", this.StringValue) + `}`}, ", ")
	return s
}
func (this *ScalarValue_Time64NsValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarValue_Time64NsValue{` +
		`Time64NsValue:` + fmt.Sprintf("%#v", this.Time64NsValue) + `}`}, ", ")
	return s
}
func (this *ScalarValue_Uint128Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.ScalarValue_Uint128Value{` +
		`Uint128Value:` + fmt.Sprintf("%#v", this.Uint128Value) + `}`}, ", ")
	return s
}
func (this *ScalarFunc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&planpb.ScalarFunc{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.InitArgs != nil {
		s = append(s, "InitArgs: "+fmt.Sprintf("%#v", this.InitArgs)+",\n")
	}
	if this.Args != nil {
		s = append(s, "Args: "+fmt.Sprintf("%#v", this.Args)+",\n")
	}
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	s = append(s, "ArgsDataTypes: "+fmt.Sprintf("%#v", this.ArgsDataTypes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AggregateExpression) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&planpb.AggregateExpression{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.InitArgs != nil {
		s = append(s, "InitArgs: "+fmt.Sprintf("%#v", this.InitArgs)+",\n")
	}
	if this.Args != nil {
		s = append(s, "Args: "+fmt.Sprintf("%#v", this.Args)+",\n")
	}
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	s = append(s, "ArgsDataTypes: "+fmt.Sprintf("%#v", this.ArgsDataTypes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AggregateExpression_Arg) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.AggregateExpression_Arg{")
	if this.Value != nil {
		s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AggregateExpression_Arg_Constant) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.AggregateExpression_Arg_Constant{` +
		`Constant:` + fmt.Sprintf("%#v", this.Constant) + `}`}, ", ")
	return s
}
func (this *AggregateExpression_Arg_Column) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&planpb.AggregateExpression_Arg_Column{` +
		`Column:` + fmt.Sprintf("%#v", this.Column) + `}`}, ", ")
	return s
}
func (this *Column) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&planpb.Column{")
	s = append(s, "Node: "+fmt.Sprintf("%#v", this.Node)+",\n")
	s = append(s, "Index: "+fmt.Sprintf("%#v", this.Index)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringPlan(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PlanOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlanOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PlanOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxOutputRowsPerTable != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.MaxOutputRowsPerTable))
		i--
		dAtA[i] = 0x20
	}
	if m.Analyze {
		i--
		if m.Analyze {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Explain {
		i--
		if m.Explain {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	return len(dAtA) - i, nil
}

func (m *Plan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Plan) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Plan) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ExecutionStatusDestinations) > 0 {
		for iNdEx := len(m.ExecutionStatusDestinations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ExecutionStatusDestinations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.IncomingAgentIDs) > 0 {
		for iNdEx := len(m.IncomingAgentIDs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IncomingAgentIDs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.PlanOptions != nil {
		{
			size, err := m.PlanOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Nodes) > 0 {
		for iNdEx := len(m.Nodes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Nodes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Dag != nil {
		{
			size, err := m.Dag.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Plan_ExecutionStatusDestination) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Plan_ExecutionStatusDestination) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Plan_ExecutionStatusDestination) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SslTargetname) > 0 {
		i -= len(m.SslTargetname)
		copy(dAtA[i:], m.SslTargetname)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.SslTargetname)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.GrpcAddress) > 0 {
		i -= len(m.GrpcAddress)
		copy(dAtA[i:], m.GrpcAddress)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.GrpcAddress)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PlanFragment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlanFragment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PlanFragment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for iNdEx := len(m.Nodes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Nodes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Dag != nil {
		{
			size, err := m.Dag.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Id != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DAG) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DAG) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DAG) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for iNdEx := len(m.Nodes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Nodes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DAG_DAGNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DAG_DAGNode) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DAG_DAGNode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SortedParents) > 0 {
		dAtA5 := make([]byte, len(m.SortedParents)*10)
		var j4 int
		for _, num := range m.SortedParents {
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		i -= j4
		copy(dAtA[i:], dAtA5[:j4])
		i = encodeVarintPlan(dAtA, i, uint64(j4))
		i--
		dAtA[i] = 0x22
	}
	if len(m.SortedChildren) > 0 {
		dAtA7 := make([]byte, len(m.SortedChildren)*10)
		var j6 int
		for _, num := range m.SortedChildren {
			for num >= 1<<7 {
				dAtA7[j6] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j6++
			}
			dAtA7[j6] = uint8(num)
			j6++
		}
		i -= j6
		copy(dAtA[i:], dAtA7[:j6])
		i = encodeVarintPlan(dAtA, i, uint64(j6))
		i--
		dAtA[i] = 0x1a
	}
	if m.Id != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PlanNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlanNode) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PlanNode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Op != nil {
		{
			size, err := m.Op.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Id != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Operator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Operator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Op != nil {
		{
			size := m.Op.Size()
			i -= size
			if _, err := m.Op.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.OpType != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.OpType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Operator_MemSourceOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_MemSourceOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MemSourceOp != nil {
		{
			size, err := m.MemSourceOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Operator_MapOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_MapOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MapOp != nil {
		{
			size, err := m.MapOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Operator_AggOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_AggOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.AggOp != nil {
		{
			size, err := m.AggOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Operator_MemSinkOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_MemSinkOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MemSinkOp != nil {
		{
			size, err := m.MemSinkOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *Operator_FilterOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_FilterOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.FilterOp != nil {
		{
			size, err := m.FilterOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Operator_LimitOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_LimitOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.LimitOp != nil {
		{
			size, err := m.LimitOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Operator_UnionOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_UnionOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.UnionOp != nil {
		{
			size, err := m.UnionOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *Operator_GRPCSourceOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_GRPCSourceOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.GRPCSourceOp != nil {
		{
			size, err := m.GRPCSourceOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *Operator_JoinOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_JoinOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.JoinOp != nil {
		{
			size, err := m.JoinOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *Operator_UdtfSourceOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_UdtfSourceOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.UdtfSourceOp != nil {
		{
			size, err := m.UdtfSourceOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	return len(dAtA) - i, nil
}
func (m *Operator_EmptySourceOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_EmptySourceOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.EmptySourceOp != nil {
		{
			size, err := m.EmptySourceOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	return len(dAtA) - i, nil
}
func (m *Operator_OTelSinkOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_OTelSinkOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.OTelSinkOp != nil {
		{
			size, err := m.OTelSinkOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	return len(dAtA) - i, nil
}
func (m *Operator_GRPCSinkOp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Operator_GRPCSinkOp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.GRPCSinkOp != nil {
		{
			size, err := m.GRPCSinkOp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3e
		i--
		dAtA[i] = 0xc2
	}
	return len(dAtA) - i, nil
}
func (m *MemorySourceOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemorySourceOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemorySourceOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Streaming {
		i--
		if m.Streaming {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if len(m.Tablet) > 0 {
		i -= len(m.Tablet)
		copy(dAtA[i:], m.Tablet)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Tablet)))
		i--
		dAtA[i] = 0x3a
	}
	if m.StopTime != nil {
		{
			size, err := m.StopTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.StartTime != nil {
		{
			size, err := m.StartTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ColumnTypes) > 0 {
		dAtA25 := make([]byte, len(m.ColumnTypes)*10)
		var j24 int
		for _, num := range m.ColumnTypes {
			for num >= 1<<7 {
				dAtA25[j24] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j24++
			}
			dAtA25[j24] = uint8(num)
			j24++
		}
		i -= j24
		copy(dAtA[i:], dAtA25[:j24])
		i = encodeVarintPlan(dAtA, i, uint64(j24))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ColumnNames) > 0 {
		for iNdEx := len(m.ColumnNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ColumnNames[iNdEx])
			copy(dAtA[i:], m.ColumnNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ColumnNames[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ColumnIdxs) > 0 {
		dAtA27 := make([]byte, len(m.ColumnIdxs)*10)
		var j26 int
		for _, num1 := range m.ColumnIdxs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA27[j26] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j26++
			}
			dAtA27[j26] = uint8(num)
			j26++
		}
		i -= j26
		copy(dAtA[i:], dAtA27[:j26])
		i = encodeVarintPlan(dAtA, i, uint64(j26))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MemorySinkOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemorySinkOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemorySinkOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ColumnSemanticTypes) > 0 {
		dAtA29 := make([]byte, len(m.ColumnSemanticTypes)*10)
		var j28 int
		for _, num := range m.ColumnSemanticTypes {
			for num >= 1<<7 {
				dAtA29[j28] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j28++
			}
			dAtA29[j28] = uint8(num)
			j28++
		}
		i -= j28
		copy(dAtA[i:], dAtA29[:j28])
		i = encodeVarintPlan(dAtA, i, uint64(j28))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ColumnNames) > 0 {
		for iNdEx := len(m.ColumnNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ColumnNames[iNdEx])
			copy(dAtA[i:], m.ColumnNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ColumnNames[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ColumnTypes) > 0 {
		dAtA31 := make([]byte, len(m.ColumnTypes)*10)
		var j30 int
		for _, num := range m.ColumnTypes {
			for num >= 1<<7 {
				dAtA31[j30] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j30++
			}
			dAtA31[j30] = uint8(num)
			j30++
		}
		i -= j30
		copy(dAtA[i:], dAtA31[:j30])
		i = encodeVarintPlan(dAtA, i, uint64(j30))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GRPCSourceOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GRPCSourceOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GRPCSourceOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ColumnNames) > 0 {
		for iNdEx := len(m.ColumnNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ColumnNames[iNdEx])
			copy(dAtA[i:], m.ColumnNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ColumnNames[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ColumnTypes) > 0 {
		dAtA33 := make([]byte, len(m.ColumnTypes)*10)
		var j32 int
		for _, num := range m.ColumnTypes {
			for num >= 1<<7 {
				dAtA33[j32] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j32++
			}
			dAtA33[j32] = uint8(num)
			j32++
		}
		i -= j32
		copy(dAtA[i:], dAtA33[:j32])
		i = encodeVarintPlan(dAtA, i, uint64(j32))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GRPCSinkOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GRPCSinkOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GRPCSinkOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ConnectionOptions != nil {
		{
			size, err := m.ConnectionOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Destination != nil {
		{
			size := m.Destination.Size()
			i -= size
			if _, err := m.Destination.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GRPCSinkOperator_GRPCSourceID) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GRPCSinkOperator_GRPCSourceID) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintPlan(dAtA, i, uint64(m.GRPCSourceID))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *GRPCSinkOperator_OutputTable) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GRPCSinkOperator_OutputTable) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.OutputTable != nil {
		{
			size, err := m.OutputTable.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *GRPCSinkOperator_ResultTable) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GRPCSinkOperator_ResultTable) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GRPCSinkOperator_ResultTable) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ColumnSemanticTypes) > 0 {
		dAtA37 := make([]byte, len(m.ColumnSemanticTypes)*10)
		var j36 int
		for _, num := range m.ColumnSemanticTypes {
			for num >= 1<<7 {
				dAtA37[j36] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j36++
			}
			dAtA37[j36] = uint8(num)
			j36++
		}
		i -= j36
		copy(dAtA[i:], dAtA37[:j36])
		i = encodeVarintPlan(dAtA, i, uint64(j36))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ColumnNames) > 0 {
		for iNdEx := len(m.ColumnNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ColumnNames[iNdEx])
			copy(dAtA[i:], m.ColumnNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ColumnNames[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ColumnTypes) > 0 {
		dAtA39 := make([]byte, len(m.ColumnTypes)*10)
		var j38 int
		for _, num := range m.ColumnTypes {
			for num >= 1<<7 {
				dAtA39[j38] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j38++
			}
			dAtA39[j38] = uint8(num)
			j38++
		}
		i -= j38
		copy(dAtA[i:], dAtA39[:j38])
		i = encodeVarintPlan(dAtA, i, uint64(j38))
		i--
		dAtA[i] = 0x12
	}
	if len(m.TableName) > 0 {
		i -= len(m.TableName)
		copy(dAtA[i:], m.TableName)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.TableName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GRPCSinkOperator_GRPCConnectionOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GRPCSinkOperator_GRPCConnectionOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GRPCSinkOperator_GRPCConnectionOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SslTargetname) > 0 {
		i -= len(m.SslTargetname)
		copy(dAtA[i:], m.SslTargetname)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.SslTargetname)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MapOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MapOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MapOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ColumnNames) > 0 {
		for iNdEx := len(m.ColumnNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ColumnNames[iNdEx])
			copy(dAtA[i:], m.ColumnNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ColumnNames[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Expressions) > 0 {
		for iNdEx := len(m.Expressions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Expressions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AggregateOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregateOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AggregateOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FinalizeResults {
		i--
		if m.FinalizeResults {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.PartialAgg {
		i--
		if m.PartialAgg {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.Windowed {
		i--
		if m.Windowed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.ValueNames) > 0 {
		for iNdEx := len(m.ValueNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ValueNames[iNdEx])
			copy(dAtA[i:], m.ValueNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ValueNames[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.GroupNames) > 0 {
		for iNdEx := len(m.GroupNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.GroupNames[iNdEx])
			copy(dAtA[i:], m.GroupNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.GroupNames[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Groups) > 0 {
		for iNdEx := len(m.Groups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Groups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Values[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *FilterOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FilterOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FilterOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Columns) > 0 {
		for iNdEx := len(m.Columns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Columns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Expression != nil {
		{
			size, err := m.Expression.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LimitOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LimitOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LimitOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AbortableSrcs) > 0 {
		dAtA42 := make([]byte, len(m.AbortableSrcs)*10)
		var j41 int
		for _, num := range m.AbortableSrcs {
			for num >= 1<<7 {
				dAtA42[j41] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j41++
			}
			dAtA42[j41] = uint8(num)
			j41++
		}
		i -= j41
		copy(dAtA[i:], dAtA42[:j41])
		i = encodeVarintPlan(dAtA, i, uint64(j41))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Columns) > 0 {
		for iNdEx := len(m.Columns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Columns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Limit != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *UnionOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnionOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UnionOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RowsPerBatch != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.RowsPerBatch))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ColumnMappings) > 0 {
		for iNdEx := len(m.ColumnMappings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ColumnMappings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ColumnNames) > 0 {
		for iNdEx := len(m.ColumnNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ColumnNames[iNdEx])
			copy(dAtA[i:], m.ColumnNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ColumnNames[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *UnionOperator_ColumnMapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnionOperator_ColumnMapping) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UnionOperator_ColumnMapping) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ColumnIndexes) > 0 {
		dAtA44 := make([]byte, len(m.ColumnIndexes)*10)
		var j43 int
		for _, num1 := range m.ColumnIndexes {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA44[j43] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j43++
			}
			dAtA44[j43] = uint8(num)
			j43++
		}
		i -= j43
		copy(dAtA[i:], dAtA44[:j43])
		i = encodeVarintPlan(dAtA, i, uint64(j43))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *JoinOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JoinOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JoinOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RowsPerBatch != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.RowsPerBatch))
		i--
		dAtA[i] = 0x28
	}
	if len(m.ColumnNames) > 0 {
		for iNdEx := len(m.ColumnNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ColumnNames[iNdEx])
			copy(dAtA[i:], m.ColumnNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ColumnNames[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.OutputColumns) > 0 {
		for iNdEx := len(m.OutputColumns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.OutputColumns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.EqualityConditions) > 0 {
		for iNdEx := len(m.EqualityConditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EqualityConditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Type != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *JoinOperator_EqualityCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JoinOperator_EqualityCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JoinOperator_EqualityCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RightColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.RightColumnIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.LeftColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.LeftColumnIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *JoinOperator_ParentColumn) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JoinOperator_ParentColumn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JoinOperator_ParentColumn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.ColumnIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.ParentIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.ParentIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *UDTFSourceOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UDTFSourceOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UDTFSourceOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ArgValues) > 0 {
		for iNdEx := len(m.ArgValues) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ArgValues[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EmptySourceOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EmptySourceOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EmptySourceOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ColumnTypes) > 0 {
		dAtA46 := make([]byte, len(m.ColumnTypes)*10)
		var j45 int
		for _, num := range m.ColumnTypes {
			for num >= 1<<7 {
				dAtA46[j45] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j45++
			}
			dAtA46[j45] = uint8(num)
			j45++
		}
		i -= j45
		copy(dAtA[i:], dAtA46[:j45])
		i = encodeVarintPlan(dAtA, i, uint64(j45))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ColumnNames) > 0 {
		for iNdEx := len(m.ColumnNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ColumnNames[iNdEx])
			copy(dAtA[i:], m.ColumnNames[iNdEx])
			i = encodeVarintPlan(dAtA, i, uint64(len(m.ColumnNames[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *OTelLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.BodyColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.BodyColumnIndex))
		i--
		dAtA[i] = 0x30
	}
	if len(m.SeverityText) > 0 {
		i -= len(m.SeverityText)
		copy(dAtA[i:], m.SeverityText)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.SeverityText)))
		i--
		dAtA[i] = 0x2a
	}
	if m.SeverityNumber != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.SeverityNumber))
		i--
		dAtA[i] = 0x20
	}
	if m.ObservedTimeColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.ObservedTimeColumnIndex))
		i--
		dAtA[i] = 0x18
	}
	if m.TimeColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.TimeColumnIndex))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *OTelSpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelSpan) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelSpan) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.KindValue != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.KindValue))
		i--
		dAtA[i] = 0x48
	}
	if m.EndTimeColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.EndTimeColumnIndex))
		i--
		dAtA[i] = 0x40
	}
	if m.StartTimeColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.StartTimeColumnIndex))
		i--
		dAtA[i] = 0x38
	}
	if m.ParentSpanIDColumn != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.ParentSpanIDColumn))
		i--
		dAtA[i] = 0x30
	}
	if m.SpanIDColumn != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.SpanIDColumn))
		i--
		dAtA[i] = 0x28
	}
	if m.TraceIDColumn != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.TraceIDColumn))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Name != nil {
		{
			size := m.Name.Size()
			i -= size
			if _, err := m.Name.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *OTelSpan_NameString) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelSpan_NameString) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.NameString)
	copy(dAtA[i:], m.NameString)
	i = encodeVarintPlan(dAtA, i, uint64(len(m.NameString)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *OTelSpan_NameColumnIndex) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelSpan_NameColumnIndex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintPlan(dAtA, i, uint64(m.NameColumnIndex))
	i--
	dAtA[i] = 0x10
	return len(dAtA) - i, nil
}
func (m *OTelMetricGauge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelMetricGauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelMetricGauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ValueColumn != nil {
		{
			size := m.ValueColumn.Size()
			i -= size
			if _, err := m.ValueColumn.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *OTelMetricGauge_FloatColumnIndex) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelMetricGauge_FloatColumnIndex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintPlan(dAtA, i, uint64(m.FloatColumnIndex))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *OTelMetricGauge_IntColumnIndex) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelMetricGauge_IntColumnIndex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintPlan(dAtA, i, uint64(m.IntColumnIndex))
	i--
	dAtA[i] = 0x10
	return len(dAtA) - i, nil
}
func (m *OTelMetricSummary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelMetricSummary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelMetricSummary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.QuantileValues) > 0 {
		for iNdEx := len(m.QuantileValues) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.QuantileValues[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.SumColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.SumColumnIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.CountColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.CountColumnIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OTelMetricSummary_ValueAtQuantile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelMetricSummary_ValueAtQuantile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelMetricSummary_ValueAtQuantile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ValueColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.ValueColumnIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.Quantile != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Quantile))))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func (m *OTelAttribute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelAttribute) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelAttribute) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OTelAttribute_Column_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelAttribute_Column_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Column != nil {
		{
			size, err := m.Column.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *OTelAttribute_StringValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelAttribute_StringValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.StringValue)
	copy(dAtA[i:], m.StringValue)
	i = encodeVarintPlan(dAtA, i, uint64(len(m.StringValue)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *OTelAttribute_Column) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelAttribute_Column) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelAttribute_Column) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CanBeJsonEncodedArray {
		i--
		if m.CanBeJsonEncodedArray {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.ColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.ColumnIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.ColumnType != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.ColumnType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OTelMetric) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelMetric) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelMetric) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		{
			size := m.Data.Size()
			i -= size
			if _, err := m.Data.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.TimeColumnIndex != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.TimeColumnIndex))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Unit) > 0 {
		i -= len(m.Unit)
		copy(dAtA[i:], m.Unit)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Unit)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OTelMetric_Gauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelMetric_Gauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Gauge != nil {
		{
			size, err := m.Gauge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	return len(dAtA) - i, nil
}
func (m *OTelMetric_Summary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelMetric_Summary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Summary != nil {
		{
			size, err := m.Summary.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb2
	}
	return len(dAtA) - i, nil
}
func (m *OTelEndpointConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelEndpointConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelEndpointConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Timeout != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x20
	}
	if m.Insecure {
		i--
		if m.Insecure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Headers) > 0 {
		for k := range m.Headers {
			v := m.Headers[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintPlan(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintPlan(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintPlan(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.URL) > 0 {
		i -= len(m.URL)
		copy(dAtA[i:], m.URL)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.URL)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OTelResource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelResource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelResource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *OTelExportSinkOperator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OTelExportSinkOperator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OTelExportSinkOperator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Logs) > 0 {
		for iNdEx := len(m.Logs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Logs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Spans) > 0 {
		for iNdEx := len(m.Spans) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Spans[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Metrics) > 0 {
		for iNdEx := len(m.Metrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.EndpointConfig != nil {
		{
			size, err := m.EndpointConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScalarExpression) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScalarExpression) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarExpression) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *ScalarExpression_Constant) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarExpression_Constant) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Constant != nil {
		{
			size, err := m.Constant.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *ScalarExpression_Column) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarExpression_Column) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Column != nil {
		{
			size, err := m.Column.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *ScalarExpression_Func) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarExpression_Func) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Func != nil {
		{
			size, err := m.Func.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *ScalarValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScalarValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.DataType != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.DataType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ScalarValue_BoolValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarValue_BoolValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.BoolValue {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x10
	return len(dAtA) - i, nil
}
func (m *ScalarValue_Int64Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarValue_Int64Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintPlan(dAtA, i, uint64(m.Int64Value))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *ScalarValue_Float64Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarValue_Float64Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Float64Value))))
	i--
	dAtA[i] = 0x21
	return len(dAtA) - i, nil
}
func (m *ScalarValue_StringValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarValue_StringValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.StringValue)
	copy(dAtA[i:], m.StringValue)
	i = encodeVarintPlan(dAtA, i, uint64(len(m.StringValue)))
	i--
	dAtA[i] = 0x2a
	return len(dAtA) - i, nil
}
func (m *ScalarValue_Time64NsValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarValue_Time64NsValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintPlan(dAtA, i, uint64(m.Time64NsValue))
	i--
	dAtA[i] = 0x30
	return len(dAtA) - i, nil
}
func (m *ScalarValue_Uint128Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarValue_Uint128Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Uint128Value != nil {
		{
			size, err := m.Uint128Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *ScalarFunc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScalarFunc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScalarFunc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ArgsDataTypes) > 0 {
		dAtA57 := make([]byte, len(m.ArgsDataTypes)*10)
		var j56 int
		for _, num := range m.ArgsDataTypes {
			for num >= 1<<7 {
				dAtA57[j56] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j56++
			}
			dAtA57[j56] = uint8(num)
			j56++
		}
		i -= j56
		copy(dAtA[i:], dAtA57[:j56])
		i = encodeVarintPlan(dAtA, i, uint64(j56))
		i--
		dAtA[i] = 0x2a
	}
	if m.Id != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Args[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.InitArgs) > 0 {
		for iNdEx := len(m.InitArgs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.InitArgs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AggregateExpression) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregateExpression) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AggregateExpression) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ArgsDataTypes) > 0 {
		dAtA59 := make([]byte, len(m.ArgsDataTypes)*10)
		var j58 int
		for _, num := range m.ArgsDataTypes {
			for num >= 1<<7 {
				dAtA59[j58] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j58++
			}
			dAtA59[j58] = uint8(num)
			j58++
		}
		i -= j58
		copy(dAtA[i:], dAtA59[:j58])
		i = encodeVarintPlan(dAtA, i, uint64(j58))
		i--
		dAtA[i] = 0x3a
	}
	if m.Id != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Args[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.InitArgs) > 0 {
		for iNdEx := len(m.InitArgs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.InitArgs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlan(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlan(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}

func (m *AggregateExpression_Arg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregateExpression_Arg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AggregateExpression_Arg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *AggregateExpression_Arg_Constant) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AggregateExpression_Arg_Constant) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Constant != nil {
		{
			size, err := m.Constant.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *AggregateExpression_Arg_Column) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AggregateExpression_Arg_Column) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Column != nil {
		{
			size, err := m.Column.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlan(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Column) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Column) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Column) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Index != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x10
	}
	if m.Node != 0 {
		i = encodeVarintPlan(dAtA, i, uint64(m.Node))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPlan(dAtA []byte, offset int, v uint64) int {
	offset -= sovPlan(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PlanOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Explain {
		n += 2
	}
	if m.Analyze {
		n += 2
	}
	if m.MaxOutputRowsPerTable != 0 {
		n += 1 + sovPlan(uint64(m.MaxOutputRowsPerTable))
	}
	return n
}

func (m *Plan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Dag != nil {
		l = m.Dag.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.PlanOptions != nil {
		l = m.PlanOptions.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.IncomingAgentIDs) > 0 {
		for _, e := range m.IncomingAgentIDs {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ExecutionStatusDestinations) > 0 {
		for _, e := range m.ExecutionStatusDestinations {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *Plan_ExecutionStatusDestination) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GrpcAddress)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	l = len(m.SslTargetname)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}

func (m *PlanFragment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovPlan(uint64(m.Id))
	}
	if m.Dag != nil {
		l = m.Dag.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *DAG) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *DAG_DAGNode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovPlan(uint64(m.Id))
	}
	if len(m.SortedChildren) > 0 {
		l = 0
		for _, e := range m.SortedChildren {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	if len(m.SortedParents) > 0 {
		l = 0
		for _, e := range m.SortedParents {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	return n
}

func (m *PlanNode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovPlan(uint64(m.Id))
	}
	if m.Op != nil {
		l = m.Op.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}

func (m *Operator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OpType != 0 {
		n += 1 + sovPlan(uint64(m.OpType))
	}
	if m.Op != nil {
		n += m.Op.Size()
	}
	return n
}

func (m *Operator_MemSourceOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MemSourceOp != nil {
		l = m.MemSourceOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_MapOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MapOp != nil {
		l = m.MapOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_AggOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AggOp != nil {
		l = m.AggOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_MemSinkOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MemSinkOp != nil {
		l = m.MemSinkOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_FilterOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FilterOp != nil {
		l = m.FilterOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_LimitOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LimitOp != nil {
		l = m.LimitOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_UnionOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UnionOp != nil {
		l = m.UnionOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_GRPCSourceOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GRPCSourceOp != nil {
		l = m.GRPCSourceOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_JoinOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.JoinOp != nil {
		l = m.JoinOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_UdtfSourceOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UdtfSourceOp != nil {
		l = m.UdtfSourceOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_EmptySourceOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EmptySourceOp != nil {
		l = m.EmptySourceOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_OTelSinkOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OTelSinkOp != nil {
		l = m.OTelSinkOp.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Operator_GRPCSinkOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GRPCSinkOp != nil {
		l = m.GRPCSinkOp.Size()
		n += 2 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *MemorySourceOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.ColumnIdxs) > 0 {
		l = 0
		for _, e := range m.ColumnIdxs {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ColumnTypes) > 0 {
		l = 0
		for _, e := range m.ColumnTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	if m.StartTime != nil {
		l = m.StartTime.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	if m.StopTime != nil {
		l = m.StopTime.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	l = len(m.Tablet)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if m.Streaming {
		n += 2
	}
	return n
}

func (m *MemorySinkOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.ColumnTypes) > 0 {
		l = 0
		for _, e := range m.ColumnTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ColumnSemanticTypes) > 0 {
		l = 0
		for _, e := range m.ColumnSemanticTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	return n
}

func (m *GRPCSourceOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ColumnTypes) > 0 {
		l = 0
		for _, e := range m.ColumnTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *GRPCSinkOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if m.Destination != nil {
		n += m.Destination.Size()
	}
	if m.ConnectionOptions != nil {
		l = m.ConnectionOptions.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}

func (m *GRPCSinkOperator_GRPCSourceID) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovPlan(uint64(m.GRPCSourceID))
	return n
}
func (m *GRPCSinkOperator_OutputTable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OutputTable != nil {
		l = m.OutputTable.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *GRPCSinkOperator_ResultTable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TableName)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.ColumnTypes) > 0 {
		l = 0
		for _, e := range m.ColumnTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ColumnSemanticTypes) > 0 {
		l = 0
		for _, e := range m.ColumnSemanticTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	return n
}

func (m *GRPCSinkOperator_GRPCConnectionOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SslTargetname)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}

func (m *MapOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Expressions) > 0 {
		for _, e := range m.Expressions {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *AggregateOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, e := range m.Values {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.Groups) > 0 {
		for _, e := range m.Groups {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.GroupNames) > 0 {
		for _, s := range m.GroupNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ValueNames) > 0 {
		for _, s := range m.ValueNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.Windowed {
		n += 2
	}
	if m.PartialAgg {
		n += 2
	}
	if m.FinalizeResults {
		n += 2
	}
	return n
}

func (m *FilterOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Expression != nil {
		l = m.Expression.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *LimitOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Limit != 0 {
		n += 1 + sovPlan(uint64(m.Limit))
	}
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.AbortableSrcs) > 0 {
		l = 0
		for _, e := range m.AbortableSrcs {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	return n
}

func (m *UnionOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ColumnMappings) > 0 {
		for _, e := range m.ColumnMappings {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.RowsPerBatch != 0 {
		n += 1 + sovPlan(uint64(m.RowsPerBatch))
	}
	return n
}

func (m *UnionOperator_ColumnMapping) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ColumnIndexes) > 0 {
		l = 0
		for _, e := range m.ColumnIndexes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	return n
}

func (m *JoinOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovPlan(uint64(m.Type))
	}
	if len(m.EqualityConditions) > 0 {
		for _, e := range m.EqualityConditions {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.OutputColumns) > 0 {
		for _, e := range m.OutputColumns {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.RowsPerBatch != 0 {
		n += 1 + sovPlan(uint64(m.RowsPerBatch))
	}
	return n
}

func (m *JoinOperator_EqualityCondition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LeftColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.LeftColumnIndex))
	}
	if m.RightColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.RightColumnIndex))
	}
	return n
}

func (m *JoinOperator_ParentColumn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ParentIndex != 0 {
		n += 1 + sovPlan(uint64(m.ParentIndex))
	}
	if m.ColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.ColumnIndex))
	}
	return n
}

func (m *UDTFSourceOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.ArgValues) > 0 {
		for _, e := range m.ArgValues {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *EmptySourceOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.ColumnTypes) > 0 {
		l = 0
		for _, e := range m.ColumnTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	return n
}

func (m *OTelLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.TimeColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.TimeColumnIndex))
	}
	if m.ObservedTimeColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.ObservedTimeColumnIndex))
	}
	if m.SeverityNumber != 0 {
		n += 1 + sovPlan(uint64(m.SeverityNumber))
	}
	l = len(m.SeverityText)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if m.BodyColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.BodyColumnIndex))
	}
	return n
}

func (m *OTelSpan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		n += m.Name.Size()
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.TraceIDColumn != 0 {
		n += 1 + sovPlan(uint64(m.TraceIDColumn))
	}
	if m.SpanIDColumn != 0 {
		n += 1 + sovPlan(uint64(m.SpanIDColumn))
	}
	if m.ParentSpanIDColumn != 0 {
		n += 1 + sovPlan(uint64(m.ParentSpanIDColumn))
	}
	if m.StartTimeColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.StartTimeColumnIndex))
	}
	if m.EndTimeColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.EndTimeColumnIndex))
	}
	if m.KindValue != 0 {
		n += 1 + sovPlan(uint64(m.KindValue))
	}
	return n
}

func (m *OTelSpan_NameString) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NameString)
	n += 1 + l + sovPlan(uint64(l))
	return n
}
func (m *OTelSpan_NameColumnIndex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovPlan(uint64(m.NameColumnIndex))
	return n
}
func (m *OTelMetricGauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ValueColumn != nil {
		n += m.ValueColumn.Size()
	}
	return n
}

func (m *OTelMetricGauge_FloatColumnIndex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovPlan(uint64(m.FloatColumnIndex))
	return n
}
func (m *OTelMetricGauge_IntColumnIndex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovPlan(uint64(m.IntColumnIndex))
	return n
}
func (m *OTelMetricSummary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CountColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.CountColumnIndex))
	}
	if m.SumColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.SumColumnIndex))
	}
	if len(m.QuantileValues) > 0 {
		for _, e := range m.QuantileValues {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *OTelMetricSummary_ValueAtQuantile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Quantile != 0 {
		n += 9
	}
	if m.ValueColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.ValueColumnIndex))
	}
	return n
}

func (m *OTelAttribute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *OTelAttribute_Column_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Column != nil {
		l = m.Column.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *OTelAttribute_StringValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StringValue)
	n += 1 + l + sovPlan(uint64(l))
	return n
}
func (m *OTelAttribute_Column) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ColumnType != 0 {
		n += 1 + sovPlan(uint64(m.ColumnType))
	}
	if m.ColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.ColumnIndex))
	}
	if m.CanBeJsonEncodedArray {
		n += 2
	}
	return n
}

func (m *OTelMetric) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	l = len(m.Unit)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.TimeColumnIndex != 0 {
		n += 1 + sovPlan(uint64(m.TimeColumnIndex))
	}
	if m.Data != nil {
		n += m.Data.Size()
	}
	return n
}

func (m *OTelMetric_Gauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Gauge != nil {
		l = m.Gauge.Size()
		n += 2 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *OTelMetric_Summary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Summary != nil {
		l = m.Summary.Size()
		n += 2 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *OTelEndpointConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.URL)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.Headers) > 0 {
		for k, v := range m.Headers {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovPlan(uint64(len(k))) + 1 + len(v) + sovPlan(uint64(len(v)))
			n += mapEntrySize + 1 + sovPlan(uint64(mapEntrySize))
		}
	}
	if m.Insecure {
		n += 2
	}
	if m.Timeout != 0 {
		n += 1 + sovPlan(uint64(m.Timeout))
	}
	return n
}

func (m *OTelResource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *OTelExportSinkOperator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EndpointConfig != nil {
		l = m.EndpointConfig.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.Logs) > 0 {
		for _, e := range m.Logs {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	return n
}

func (m *ScalarExpression) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *ScalarExpression_Constant) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Constant != nil {
		l = m.Constant.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *ScalarExpression_Column) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Column != nil {
		l = m.Column.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *ScalarExpression_Func) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Func != nil {
		l = m.Func.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *ScalarValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DataType != 0 {
		n += 1 + sovPlan(uint64(m.DataType))
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *ScalarValue_BoolValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *ScalarValue_Int64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovPlan(uint64(m.Int64Value))
	return n
}
func (m *ScalarValue_Float64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *ScalarValue_StringValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StringValue)
	n += 1 + l + sovPlan(uint64(l))
	return n
}
func (m *ScalarValue_Time64NsValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovPlan(uint64(m.Time64NsValue))
	return n
}
func (m *ScalarValue_Uint128Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Uint128Value != nil {
		l = m.Uint128Value.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *ScalarFunc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.InitArgs) > 0 {
		for _, e := range m.InitArgs {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.Id != 0 {
		n += 1 + sovPlan(uint64(m.Id))
	}
	if len(m.ArgsDataTypes) > 0 {
		l = 0
		for _, e := range m.ArgsDataTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	return n
}

func (m *AggregateExpression) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlan(uint64(l))
	}
	if len(m.InitArgs) > 0 {
		for _, e := range m.InitArgs {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, e := range m.Args {
			l = e.Size()
			n += 1 + l + sovPlan(uint64(l))
		}
	}
	if m.Id != 0 {
		n += 1 + sovPlan(uint64(m.Id))
	}
	if len(m.ArgsDataTypes) > 0 {
		l = 0
		for _, e := range m.ArgsDataTypes {
			l += sovPlan(uint64(e))
		}
		n += 1 + sovPlan(uint64(l)) + l
	}
	return n
}

func (m *AggregateExpression_Arg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *AggregateExpression_Arg_Constant) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Constant != nil {
		l = m.Constant.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *AggregateExpression_Arg_Column) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Column != nil {
		l = m.Column.Size()
		n += 1 + l + sovPlan(uint64(l))
	}
	return n
}
func (m *Column) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Node != 0 {
		n += 1 + sovPlan(uint64(m.Node))
	}
	if m.Index != 0 {
		n += 1 + sovPlan(uint64(m.Index))
	}
	return n
}

func sovPlan(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPlan(x uint64) (n int) {
	return sovPlan(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PlanOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PlanOptions{`,
		`Explain:` + fmt.Sprintf("%v", this.Explain) + `,`,
		`Analyze:` + fmt.Sprintf("%v", this.Analyze) + `,`,
		`MaxOutputRowsPerTable:` + fmt.Sprintf("%v", this.MaxOutputRowsPerTable) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Plan) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForNodes := "[]*PlanFragment{"
	for _, f := range this.Nodes {
		repeatedStringForNodes += strings.Replace(f.String(), "PlanFragment", "PlanFragment", 1) + ","
	}
	repeatedStringForNodes += "}"
	repeatedStringForIncomingAgentIDs := "[]*UUID{"
	for _, f := range this.IncomingAgentIDs {
		repeatedStringForIncomingAgentIDs += strings.Replace(fmt.Sprintf("%v", f), "UUID", "uuidpb.UUID", 1) + ","
	}
	repeatedStringForIncomingAgentIDs += "}"
	repeatedStringForExecutionStatusDestinations := "[]*Plan_ExecutionStatusDestination{"
	for _, f := range this.ExecutionStatusDestinations {
		repeatedStringForExecutionStatusDestinations += strings.Replace(fmt.Sprintf("%v", f), "Plan_ExecutionStatusDestination", "Plan_ExecutionStatusDestination", 1) + ","
	}
	repeatedStringForExecutionStatusDestinations += "}"
	s := strings.Join([]string{`&Plan{`,
		`Dag:` + strings.Replace(this.Dag.String(), "DAG", "DAG", 1) + `,`,
		`Nodes:` + repeatedStringForNodes + `,`,
		`PlanOptions:` + strings.Replace(this.PlanOptions.String(), "PlanOptions", "PlanOptions", 1) + `,`,
		`IncomingAgentIDs:` + repeatedStringForIncomingAgentIDs + `,`,
		`ExecutionStatusDestinations:` + repeatedStringForExecutionStatusDestinations + `,`,
		`}`,
	}, "")
	return s
}
func (this *Plan_ExecutionStatusDestination) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Plan_ExecutionStatusDestination{`,
		`GrpcAddress:` + fmt.Sprintf("%v", this.GrpcAddress) + `,`,
		`SslTargetname:` + fmt.Sprintf("%v", this.SslTargetname) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PlanFragment) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForNodes := "[]*PlanNode{"
	for _, f := range this.Nodes {
		repeatedStringForNodes += strings.Replace(f.String(), "PlanNode", "PlanNode", 1) + ","
	}
	repeatedStringForNodes += "}"
	s := strings.Join([]string{`&PlanFragment{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Dag:` + strings.Replace(this.Dag.String(), "DAG", "DAG", 1) + `,`,
		`Nodes:` + repeatedStringForNodes + `,`,
		`}`,
	}, "")
	return s
}
func (this *DAG) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForNodes := "[]*DAG_DAGNode{"
	for _, f := range this.Nodes {
		repeatedStringForNodes += strings.Replace(fmt.Sprintf("%v", f), "DAG_DAGNode", "DAG_DAGNode", 1) + ","
	}
	repeatedStringForNodes += "}"
	s := strings.Join([]string{`&DAG{`,
		`Nodes:` + repeatedStringForNodes + `,`,
		`}`,
	}, "")
	return s
}
func (this *DAG_DAGNode) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DAG_DAGNode{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`SortedChildren:` + fmt.Sprintf("%v", this.SortedChildren) + `,`,
		`SortedParents:` + fmt.Sprintf("%v", this.SortedParents) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PlanNode) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PlanNode{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Op:` + strings.Replace(this.Op.String(), "Operator", "Operator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator{`,
		`OpType:` + fmt.Sprintf("%v", this.OpType) + `,`,
		`Op:` + fmt.Sprintf("%v", this.Op) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_MemSourceOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_MemSourceOp{`,
		`MemSourceOp:` + strings.Replace(fmt.Sprintf("%v", this.MemSourceOp), "MemorySourceOperator", "MemorySourceOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_MapOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_MapOp{`,
		`MapOp:` + strings.Replace(fmt.Sprintf("%v", this.MapOp), "MapOperator", "MapOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_AggOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_AggOp{`,
		`AggOp:` + strings.Replace(fmt.Sprintf("%v", this.AggOp), "AggregateOperator", "AggregateOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_MemSinkOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_MemSinkOp{`,
		`MemSinkOp:` + strings.Replace(fmt.Sprintf("%v", this.MemSinkOp), "MemorySinkOperator", "MemorySinkOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_FilterOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_FilterOp{`,
		`FilterOp:` + strings.Replace(fmt.Sprintf("%v", this.FilterOp), "FilterOperator", "FilterOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_LimitOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_LimitOp{`,
		`LimitOp:` + strings.Replace(fmt.Sprintf("%v", this.LimitOp), "LimitOperator", "LimitOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_UnionOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_UnionOp{`,
		`UnionOp:` + strings.Replace(fmt.Sprintf("%v", this.UnionOp), "UnionOperator", "UnionOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_GRPCSourceOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_GRPCSourceOp{`,
		`GRPCSourceOp:` + strings.Replace(fmt.Sprintf("%v", this.GRPCSourceOp), "GRPCSourceOperator", "GRPCSourceOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_JoinOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_JoinOp{`,
		`JoinOp:` + strings.Replace(fmt.Sprintf("%v", this.JoinOp), "JoinOperator", "JoinOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_UdtfSourceOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_UdtfSourceOp{`,
		`UdtfSourceOp:` + strings.Replace(fmt.Sprintf("%v", this.UdtfSourceOp), "UDTFSourceOperator", "UDTFSourceOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_EmptySourceOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_EmptySourceOp{`,
		`EmptySourceOp:` + strings.Replace(fmt.Sprintf("%v", this.EmptySourceOp), "EmptySourceOperator", "EmptySourceOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_OTelSinkOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_OTelSinkOp{`,
		`OTelSinkOp:` + strings.Replace(fmt.Sprintf("%v", this.OTelSinkOp), "OTelExportSinkOperator", "OTelExportSinkOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Operator_GRPCSinkOp) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Operator_GRPCSinkOp{`,
		`GRPCSinkOp:` + strings.Replace(fmt.Sprintf("%v", this.GRPCSinkOp), "GRPCSinkOperator", "GRPCSinkOperator", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemorySourceOperator) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MemorySourceOperator{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`ColumnIdxs:` + fmt.Sprintf("%v", this.ColumnIdxs) + `,`,
		`ColumnNames:` + fmt.Sprintf("%v", this.ColumnNames) + `,`,
		`ColumnTypes:` + fmt.Sprintf("%v", this.ColumnTypes) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "Int64Value", "types.Int64Value", 1) + `,`,
		`StopTime:` + strings.Replace(fmt.Sprintf("%v", this.StopTime), "Int64Value", "types.Int64Value", 1) + `,`,
		`Tablet:` + fmt.Sprintf("%v", this.Tablet) + `,`,
		`Streaming:` + fmt.Sprintf("%v", this.Streaming) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemorySinkOperator) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MemorySinkOperator{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`ColumnTypes:` + fmt.Sprintf("%v", this.ColumnTypes) + `,`,
		`ColumnNames:` + fmt.Sprintf("%v", this.ColumnNames) + `,`,
		`ColumnSemanticTypes:` + fmt.Sprintf("%v", this.ColumnSemanticTypes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GRPCSourceOperator) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GRPCSourceOperator{`,
		`ColumnTypes:` + fmt.Sprintf("%v", this.ColumnTypes) + `,`,
		`ColumnNames:` + fmt.Sprintf("%v", this.ColumnNames) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GRPCSinkOperator) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GRPCSinkOperator{`,
		`Address:` + fmt.Sprintf("%v", this.Address) + `,`,
		`Destination:` + fmt.Sprintf("%v", this.Destination) + `,`,
		`ConnectionOptions:` + strings.Replace(fmt.Sprintf("%v", this.ConnectionOptions), "GRPCSinkOperator_GRPCConnectionOptions", "GRPCSinkOperator_GRPCConnectionOptions", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GRPCSinkOperator_GRPCSourceID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GRPCSinkOperator_GRPCSourceID{`,
		`GRPCSourceID:` + fmt.Sprintf("%v", this.GRPCSourceID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GRPCSinkOperator_OutputTable) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GRPCSinkOperator_OutputTable{`,
		`OutputTable:` + strings.Replace(fmt.Sprintf("%v", this.OutputTable), "GRPCSinkOperator_ResultTable", "GRPCSinkOperator_ResultTable", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GRPCSinkOperator_ResultTable) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GRPCSinkOperator_ResultTable{`,
		`TableName:` + fmt.Sprintf("%v", this.TableName) + `,`,
		`ColumnTypes:` + fmt.Sprintf("%v", this.ColumnTypes) + `,`,
		`ColumnNames:` + fmt.Sprintf("%v", this.ColumnNames) + `,`,
		`ColumnSemanticTypes:` + fmt.Sprintf("%v", this.ColumnSemanticTypes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GRPCSinkOperator_GRPCConnectionOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GRPCSinkOperator_GRPCConnectionOptions{`,
		`SslTargetname:` + fmt.Sprintf("%v", this.SslTargetname) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MapOperator) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForExpressions := "[]*ScalarExpression{"
	for _, f := range this.Expressions {
		repeatedStringForExpressions += strings.Replace(f.String(), "ScalarExpression", "ScalarExpression", 1) + ","
	}
	repeatedStringForExpressions += "}"
	s := strings.Join([]string{`&MapOperator{`,
		`Expressions:` + repeatedStringForExpressions + `,`,
		`ColumnNames:` + fmt.Sprintf("%v", this.ColumnNames) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AggregateOperator) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForValues := "[]*AggregateExpression{"
	for _, f := range this.Values {
		repeatedStringForValues += strings.Replace(f.String(), "AggregateExpression", "AggregateExpression", 1) + ","
	}
	repeatedStringForValues += "}"
	repeatedStringForGroups := "[]*Column{"
	for _, f := range this.Groups {
		repeatedStringForGroups += strings.Replace(f.String(), "Column", "Column", 1) + ","
	}
	repeatedStringForGroups += "}"
	s := strings.Join([]string{`&AggregateOperator{`,
		`Values:` + repeatedStringForValues + `,`,
		`Groups:` + repeatedStringForGroups + `,`,
		`GroupNames:` + fmt.Sprintf("%v", this.GroupNames) + `,`,
		`ValueNames:` + fmt.Sprintf("%v", this.ValueNames) + `,`,
		`Windowed:` + fmt.Sprintf("%v", this.Windowed) + `,`,
		`PartialAgg:` + fmt.Sprintf("%v", this.PartialAgg) + `,`,
		`FinalizeResults:` + fmt.Sprintf("%v", this.FinalizeResults) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FilterOperator) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForColumns := "[]*Column{"
	for _, f := range this.Columns {
		repeatedStringForColumns += strings.Replace(f.String(), "Column", "Column", 1) + ","
	}
	repeatedStringForColumns += "}"
	s := strings.Join([]string{`&FilterOperator{`,
		`Expression:` + strings.Replace(this.Expression.String(), "ScalarExpression", "ScalarExpression", 1) + `,`,
		`Columns:` + repeatedStringForColumns + `,`,
		`}`,
	}, "")
	return s
}
func (this *LimitOperator) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForColumns := "[]*Column{"
	for _, f := range this.Columns {
		repeatedStringForColumns += strings.Replace(f.String(), "Column", "Column", 1) + ","
	}
	repeatedStringForColumns += "}"
	s := strings.Join([]string{`&LimitOperator{`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`Columns:` + repeatedStringForColumns + `,`,
		`AbortableSrcs:` + fmt.Sprintf("%v", this.AbortableSrcs) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UnionOperator) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForColumnMappings := "[]*UnionOperator_ColumnMapping{"
	for _, f := range this.ColumnMappings {
		repeatedStringForColumnMappings += strings.Replace(fmt.Sprintf("%v", f), "UnionOperator_ColumnMapping", "UnionOperator_ColumnMapping", 1) + ","
	}
	repeatedStringForColumnMappings += "}"
	s := strings.Join([]string{`&UnionOperator{`,
		`ColumnNames:` + fmt.Sprintf("%v", this.ColumnNames) + `,`,
		`ColumnMappings:` + repeatedStringForColumnMappings + `,`,
		`RowsPerBatch:` + fmt.Sprintf("%v", this.RowsPerBatch) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UnionOperator_ColumnMapping) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UnionOperator_ColumnMapping{`,
		`ColumnIndexes:` + fmt.Sprintf("%v", this.ColumnIndexes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinOperator) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForEqualityConditions := "[]*JoinOperator_EqualityCondition{"
	for _, f := range this.EqualityConditions {
		repeatedStringForEqualityConditions += strings.Replace(fmt.Sprintf("%v", f), "JoinOperator_EqualityCondition", "JoinOperator_EqualityCondition", 1) + ","
	}
	repeatedStringForEqualityConditions += "}"
	repeatedStringForOutputColumns := "[]*JoinOperator_ParentColumn{"
	for _, f := range this.OutputColumns {
		repeatedStringForOutputColumns += strings.Replace(fmt.Sprintf("%v", f), "JoinOperator_ParentColumn", "JoinOperator_ParentColumn", 1) + ","
	}
	repeatedStringForOutputColumns += "}"
	s := strings.Join([]string{`&JoinOperator{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`EqualityConditions:` + repeatedStringForEqualityConditions + `,`,
		`OutputColumns:` + repeatedStringForOutputColumns + `,`,
		`ColumnNames:` + fmt.Sprintf("%v", this.ColumnNames) + `,`,
		`RowsPerBatch:` + fmt.Sprintf("%v", this.RowsPerBatch) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinOperator_EqualityCondition) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JoinOperator_EqualityCondition{`,
		`LeftColumnIndex:` + fmt.Sprintf("%v", this.LeftColumnIndex) + `,`,
		`RightColumnIndex:` + fmt.Sprintf("%v", this.RightColumnIndex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinOperator_ParentColumn) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JoinOperator_ParentColumn{`,
		`ParentIndex:` + fmt.Sprintf("%v", this.ParentIndex) + `,`,
		`ColumnIndex:` + fmt.Sprintf("%v", this.ColumnIndex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UDTFSourceOperator) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForArgValues := "[]*ScalarValue{"
	for _, f := range this.ArgValues {
		repeatedStringForArgValues += strings.Replace(f.String(), "ScalarValue", "ScalarValue", 1) + ","
	}
	repeatedStringForArgValues += "}"
	s := strings.Join([]string{`&UDTFSourceOperator{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`ArgValues:` + repeatedStringForArgValues + `,`,
		`}`,
	}, "")
	return s
}
func (this *EmptySourceOperator) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EmptySourceOperator{`,
		`ColumnNames:` + fmt.Sprintf("%v", this.ColumnNames) + `,`,
		`ColumnTypes:` + fmt.Sprintf("%v", this.ColumnTypes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelLog) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAttributes := "[]*OTelAttribute{"
	for _, f := range this.Attributes {
		repeatedStringForAttributes += strings.Replace(f.String(), "OTelAttribute", "OTelAttribute", 1) + ","
	}
	repeatedStringForAttributes += "}"
	s := strings.Join([]string{`&OTelLog{`,
		`Attributes:` + repeatedStringForAttributes + `,`,
		`TimeColumnIndex:` + fmt.Sprintf("%v", this.TimeColumnIndex) + `,`,
		`ObservedTimeColumnIndex:` + fmt.Sprintf("%v", this.ObservedTimeColumnIndex) + `,`,
		`SeverityNumber:` + fmt.Sprintf("%v", this.SeverityNumber) + `,`,
		`SeverityText:` + fmt.Sprintf("%v", this.SeverityText) + `,`,
		`BodyColumnIndex:` + fmt.Sprintf("%v", this.BodyColumnIndex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelSpan) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAttributes := "[]*OTelAttribute{"
	for _, f := range this.Attributes {
		repeatedStringForAttributes += strings.Replace(f.String(), "OTelAttribute", "OTelAttribute", 1) + ","
	}
	repeatedStringForAttributes += "}"
	s := strings.Join([]string{`&OTelSpan{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Attributes:` + repeatedStringForAttributes + `,`,
		`TraceIDColumn:` + fmt.Sprintf("%v", this.TraceIDColumn) + `,`,
		`SpanIDColumn:` + fmt.Sprintf("%v", this.SpanIDColumn) + `,`,
		`ParentSpanIDColumn:` + fmt.Sprintf("%v", this.ParentSpanIDColumn) + `,`,
		`StartTimeColumnIndex:` + fmt.Sprintf("%v", this.StartTimeColumnIndex) + `,`,
		`EndTimeColumnIndex:` + fmt.Sprintf("%v", this.EndTimeColumnIndex) + `,`,
		`KindValue:` + fmt.Sprintf("%v", this.KindValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelSpan_NameString) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelSpan_NameString{`,
		`NameString:` + fmt.Sprintf("%v", this.NameString) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelSpan_NameColumnIndex) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelSpan_NameColumnIndex{`,
		`NameColumnIndex:` + fmt.Sprintf("%v", this.NameColumnIndex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelMetricGauge) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelMetricGauge{`,
		`ValueColumn:` + fmt.Sprintf("%v", this.ValueColumn) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelMetricGauge_FloatColumnIndex) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelMetricGauge_FloatColumnIndex{`,
		`FloatColumnIndex:` + fmt.Sprintf("%v", this.FloatColumnIndex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelMetricGauge_IntColumnIndex) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelMetricGauge_IntColumnIndex{`,
		`IntColumnIndex:` + fmt.Sprintf("%v", this.IntColumnIndex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelMetricSummary) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForQuantileValues := "[]*OTelMetricSummary_ValueAtQuantile{"
	for _, f := range this.QuantileValues {
		repeatedStringForQuantileValues += strings.Replace(fmt.Sprintf("%v", f), "OTelMetricSummary_ValueAtQuantile", "OTelMetricSummary_ValueAtQuantile", 1) + ","
	}
	repeatedStringForQuantileValues += "}"
	s := strings.Join([]string{`&OTelMetricSummary{`,
		`CountColumnIndex:` + fmt.Sprintf("%v", this.CountColumnIndex) + `,`,
		`SumColumnIndex:` + fmt.Sprintf("%v", this.SumColumnIndex) + `,`,
		`QuantileValues:` + repeatedStringForQuantileValues + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelMetricSummary_ValueAtQuantile) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelMetricSummary_ValueAtQuantile{`,
		`Quantile:` + fmt.Sprintf("%v", this.Quantile) + `,`,
		`ValueColumnIndex:` + fmt.Sprintf("%v", this.ValueColumnIndex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelAttribute) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelAttribute{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelAttribute_Column_) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelAttribute_Column_{`,
		`Column:` + strings.Replace(fmt.Sprintf("%v", this.Column), "OTelAttribute_Column", "OTelAttribute_Column", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelAttribute_StringValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelAttribute_StringValue{`,
		`StringValue:` + fmt.Sprintf("%v", this.StringValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelAttribute_Column) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelAttribute_Column{`,
		`ColumnType:` + fmt.Sprintf("%v", this.ColumnType) + `,`,
		`ColumnIndex:` + fmt.Sprintf("%v", this.ColumnIndex) + `,`,
		`CanBeJsonEncodedArray:` + fmt.Sprintf("%v", this.CanBeJsonEncodedArray) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelMetric) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAttributes := "[]*OTelAttribute{"
	for _, f := range this.Attributes {
		repeatedStringForAttributes += strings.Replace(f.String(), "OTelAttribute", "OTelAttribute", 1) + ","
	}
	repeatedStringForAttributes += "}"
	s := strings.Join([]string{`&OTelMetric{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Description:` + fmt.Sprintf("%v", this.Description) + `,`,
		`Unit:` + fmt.Sprintf("%v", this.Unit) + `,`,
		`Attributes:` + repeatedStringForAttributes + `,`,
		`TimeColumnIndex:` + fmt.Sprintf("%v", this.TimeColumnIndex) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelMetric_Gauge) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelMetric_Gauge{`,
		`Gauge:` + strings.Replace(fmt.Sprintf("%v", this.Gauge), "OTelMetricGauge", "OTelMetricGauge", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelMetric_Summary) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OTelMetric_Summary{`,
		`Summary:` + strings.Replace(fmt.Sprintf("%v", this.Summary), "OTelMetricSummary", "OTelMetricSummary", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelEndpointConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForHeaders := make([]string, 0, len(this.Headers))
	for k, _ := range this.Headers {
		keysForHeaders = append(keysForHeaders, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForHeaders)
	mapStringForHeaders := "map[string]string{"
	for _, k := range keysForHeaders {
		mapStringForHeaders += fmt.Sprintf("%v: %v,", k, this.Headers[k])
	}
	mapStringForHeaders += "}"
	s := strings.Join([]string{`&OTelEndpointConfig{`,
		`URL:` + fmt.Sprintf("%v", this.URL) + `,`,
		`Headers:` + mapStringForHeaders + `,`,
		`Insecure:` + fmt.Sprintf("%v", this.Insecure) + `,`,
		`Timeout:` + fmt.Sprintf("%v", this.Timeout) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelResource) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAttributes := "[]*OTelAttribute{"
	for _, f := range this.Attributes {
		repeatedStringForAttributes += strings.Replace(f.String(), "OTelAttribute", "OTelAttribute", 1) + ","
	}
	repeatedStringForAttributes += "}"
	s := strings.Join([]string{`&OTelResource{`,
		`Attributes:` + repeatedStringForAttributes + `,`,
		`}`,
	}, "")
	return s
}
func (this *OTelExportSinkOperator) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMetrics := "[]*OTelMetric{"
	for _, f := range this.Metrics {
		repeatedStringForMetrics += strings.Replace(f.String(), "OTelMetric", "OTelMetric", 1) + ","
	}
	repeatedStringForMetrics += "}"
	repeatedStringForSpans := "[]*OTelSpan{"
	for _, f := range this.Spans {
		repeatedStringForSpans += strings.Replace(f.String(), "OTelSpan", "OTelSpan", 1) + ","
	}
	repeatedStringForSpans += "}"
	repeatedStringForLogs := "[]*OTelLog{"
	for _, f := range this.Logs {
		repeatedStringForLogs += strings.Replace(f.String(), "OTelLog", "OTelLog", 1) + ","
	}
	repeatedStringForLogs += "}"
	s := strings.Join([]string{`&OTelExportSinkOperator{`,
		`EndpointConfig:` + strings.Replace(this.EndpointConfig.String(), "OTelEndpointConfig", "OTelEndpointConfig", 1) + `,`,
		`Resource:` + strings.Replace(this.Resource.String(), "OTelResource", "OTelResource", 1) + `,`,
		`Metrics:` + repeatedStringForMetrics + `,`,
		`Spans:` + repeatedStringForSpans + `,`,
		`Logs:` + repeatedStringForLogs + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarExpression) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarExpression{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarExpression_Constant) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarExpression_Constant{`,
		`Constant:` + strings.Replace(fmt.Sprintf("%v", this.Constant), "ScalarValue", "ScalarValue", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarExpression_Column) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarExpression_Column{`,
		`Column:` + strings.Replace(fmt.Sprintf("%v", this.Column), "Column", "Column", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarExpression_Func) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarExpression_Func{`,
		`Func:` + strings.Replace(fmt.Sprintf("%v", this.Func), "ScalarFunc", "ScalarFunc", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarValue{`,
		`DataType:` + fmt.Sprintf("%v", this.DataType) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarValue_BoolValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarValue_BoolValue{`,
		`BoolValue:` + fmt.Sprintf("%v", this.BoolValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarValue_Int64Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarValue_Int64Value{`,
		`Int64Value:` + fmt.Sprintf("%v", this.Int64Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarValue_Float64Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarValue_Float64Value{`,
		`Float64Value:` + fmt.Sprintf("%v", this.Float64Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarValue_StringValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarValue_StringValue{`,
		`StringValue:` + fmt.Sprintf("%v", this.StringValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarValue_Time64NsValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarValue_Time64NsValue{`,
		`Time64NsValue:` + fmt.Sprintf("%v", this.Time64NsValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarValue_Uint128Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ScalarValue_Uint128Value{`,
		`Uint128Value:` + strings.Replace(fmt.Sprintf("%v", this.Uint128Value), "UInt128", "typespb.UInt128", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ScalarFunc) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInitArgs := "[]*ScalarValue{"
	for _, f := range this.InitArgs {
		repeatedStringForInitArgs += strings.Replace(f.String(), "ScalarValue", "ScalarValue", 1) + ","
	}
	repeatedStringForInitArgs += "}"
	repeatedStringForArgs := "[]*ScalarExpression{"
	for _, f := range this.Args {
		repeatedStringForArgs += strings.Replace(f.String(), "ScalarExpression", "ScalarExpression", 1) + ","
	}
	repeatedStringForArgs += "}"
	s := strings.Join([]string{`&ScalarFunc{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`InitArgs:` + repeatedStringForInitArgs + `,`,
		`Args:` + repeatedStringForArgs + `,`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`ArgsDataTypes:` + fmt.Sprintf("%v", this.ArgsDataTypes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AggregateExpression) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInitArgs := "[]*ScalarValue{"
	for _, f := range this.InitArgs {
		repeatedStringForInitArgs += strings.Replace(f.String(), "ScalarValue", "ScalarValue", 1) + ","
	}
	repeatedStringForInitArgs += "}"
	repeatedStringForArgs := "[]*AggregateExpression_Arg{"
	for _, f := range this.Args {
		repeatedStringForArgs += strings.Replace(fmt.Sprintf("%v", f), "AggregateExpression_Arg", "AggregateExpression_Arg", 1) + ","
	}
	repeatedStringForArgs += "}"
	s := strings.Join([]string{`&AggregateExpression{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`InitArgs:` + repeatedStringForInitArgs + `,`,
		`Args:` + repeatedStringForArgs + `,`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`ArgsDataTypes:` + fmt.Sprintf("%v", this.ArgsDataTypes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AggregateExpression_Arg) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AggregateExpression_Arg{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AggregateExpression_Arg_Constant) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AggregateExpression_Arg_Constant{`,
		`Constant:` + strings.Replace(fmt.Sprintf("%v", this.Constant), "ScalarValue", "ScalarValue", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AggregateExpression_Arg_Column) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AggregateExpression_Arg_Column{`,
		`Column:` + strings.Replace(fmt.Sprintf("%v", this.Column), "Column", "Column", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Column) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Column{`,
		`Node:` + fmt.Sprintf("%v", this.Node) + `,`,
		`Index:` + fmt.Sprintf("%v", this.Index) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringPlan(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PlanOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlanOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlanOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Explain", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Explain = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Analyze", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Analyze = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxOutputRowsPerTable", wireType)
			}
			m.MaxOutputRowsPerTable = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxOutputRowsPerTable |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Plan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Plan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Plan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dag", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dag == nil {
				m.Dag = &DAG{}
			}
			if err := m.Dag.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, &PlanFragment{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlanOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PlanOptions == nil {
				m.PlanOptions = &PlanOptions{}
			}
			if err := m.PlanOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncomingAgentIDs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncomingAgentIDs = append(m.IncomingAgentIDs, &uuidpb.UUID{})
			if err := m.IncomingAgentIDs[len(m.IncomingAgentIDs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionStatusDestinations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecutionStatusDestinations = append(m.ExecutionStatusDestinations, &Plan_ExecutionStatusDestination{})
			if err := m.ExecutionStatusDestinations[len(m.ExecutionStatusDestinations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Plan_ExecutionStatusDestination) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecutionStatusDestination: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecutionStatusDestination: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrpcAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GrpcAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SslTargetname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SslTargetname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlanFragment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlanFragment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlanFragment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dag", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dag == nil {
				m.Dag = &DAG{}
			}
			if err := m.Dag.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, &PlanNode{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DAG) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DAG: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DAG: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, &DAG_DAGNode{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DAG_DAGNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DAGNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DAGNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SortedChildren = append(m.SortedChildren, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.SortedChildren) == 0 {
					m.SortedChildren = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SortedChildren = append(m.SortedChildren, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SortedChildren", wireType)
			}
		case 4:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SortedParents = append(m.SortedParents, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.SortedParents) == 0 {
					m.SortedParents = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SortedParents = append(m.SortedParents, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SortedParents", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlanNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlanNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlanNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Op == nil {
				m.Op = &Operator{}
			}
			if err := m.Op.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Operator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Operator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Operator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpType", wireType)
			}
			m.OpType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OpType |= OperatorType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemSourceOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MemorySourceOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_MemSourceOp{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MapOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MapOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_MapOp{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AggregateOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_AggOp{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemSinkOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MemorySinkOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_MemSinkOp{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FilterOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_FilterOp{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LimitOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LimitOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_LimitOp{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnionOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &UnionOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_UnionOp{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GRPCSourceOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GRPCSourceOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_GRPCSourceOp{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JoinOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &JoinOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_JoinOp{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UdtfSourceOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &UDTFSourceOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_UdtfSourceOp{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmptySourceOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EmptySourceOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_EmptySourceOp{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OTelSinkOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OTelExportSinkOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_OTelSinkOp{v}
			iNdEx = postIndex
		case 1000:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GRPCSinkOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GRPCSinkOperator{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Op = &Operator_GRPCSinkOp{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemorySourceOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemorySourceOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemorySourceOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnIdxs = append(m.ColumnIdxs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.ColumnIdxs) == 0 {
					m.ColumnIdxs = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnIdxs = append(m.ColumnIdxs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnIdxs", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType == 0 {
				var v typespb.DataType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.DataType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnTypes = append(m.ColumnTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ColumnTypes) == 0 {
					m.ColumnTypes = make([]typespb.DataType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.DataType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.DataType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnTypes = append(m.ColumnTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnTypes", wireType)
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = &types.Int64Value{}
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StopTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StopTime == nil {
				m.StopTime = &types.Int64Value{}
			}
			if err := m.StopTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tablet", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tablet = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Streaming", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Streaming = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemorySinkOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemorySinkOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemorySinkOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v typespb.DataType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.DataType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnTypes = append(m.ColumnTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ColumnTypes) == 0 {
					m.ColumnTypes = make([]typespb.DataType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.DataType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.DataType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnTypes = append(m.ColumnTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnTypes", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType == 0 {
				var v typespb.SemanticType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.SemanticType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnSemanticTypes = append(m.ColumnSemanticTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ColumnSemanticTypes) == 0 {
					m.ColumnSemanticTypes = make([]typespb.SemanticType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.SemanticType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.SemanticType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnSemanticTypes = append(m.ColumnSemanticTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnSemanticTypes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GRPCSourceOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GRPCSourceOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GRPCSourceOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v typespb.DataType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.DataType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnTypes = append(m.ColumnTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ColumnTypes) == 0 {
					m.ColumnTypes = make([]typespb.DataType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.DataType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.DataType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnTypes = append(m.ColumnTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnTypes", wireType)
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GRPCSinkOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GRPCSinkOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GRPCSinkOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GRPCSourceID", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Destination = &GRPCSinkOperator_GRPCSourceID{v}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GRPCSinkOperator_ResultTable{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Destination = &GRPCSinkOperator_OutputTable{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectionOptions == nil {
				m.ConnectionOptions = &GRPCSinkOperator_GRPCConnectionOptions{}
			}
			if err := m.ConnectionOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GRPCSinkOperator_ResultTable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResultTable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResultTable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TableName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v typespb.DataType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.DataType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnTypes = append(m.ColumnTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ColumnTypes) == 0 {
					m.ColumnTypes = make([]typespb.DataType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.DataType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.DataType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnTypes = append(m.ColumnTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnTypes", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType == 0 {
				var v typespb.SemanticType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.SemanticType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnSemanticTypes = append(m.ColumnSemanticTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ColumnSemanticTypes) == 0 {
					m.ColumnSemanticTypes = make([]typespb.SemanticType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.SemanticType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.SemanticType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnSemanticTypes = append(m.ColumnSemanticTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnSemanticTypes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GRPCSinkOperator_GRPCConnectionOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GRPCConnectionOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GRPCConnectionOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SslTargetname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SslTargetname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MapOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MapOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MapOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expressions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Expressions = append(m.Expressions, &ScalarExpression{})
			if err := m.Expressions[len(m.Expressions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AggregateOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AggregateOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AggregateOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, &AggregateExpression{})
			if err := m.Values[len(m.Values)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &Column{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupNames = append(m.GroupNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValueNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValueNames = append(m.ValueNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Windowed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Windowed = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialAgg", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PartialAgg = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinalizeResults", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FinalizeResults = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FilterOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expression", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expression == nil {
				m.Expression = &ScalarExpression{}
			}
			if err := m.Expression.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, &Column{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LimitOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LimitOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LimitOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, &Column{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AbortableSrcs = append(m.AbortableSrcs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.AbortableSrcs) == 0 {
					m.AbortableSrcs = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AbortableSrcs = append(m.AbortableSrcs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AbortableSrcs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnionOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnionOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnionOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnMappings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnMappings = append(m.ColumnMappings, &UnionOperator_ColumnMapping{})
			if err := m.ColumnMappings[len(m.ColumnMappings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowsPerBatch", wireType)
			}
			m.RowsPerBatch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RowsPerBatch |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnionOperator_ColumnMapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ColumnMapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ColumnMapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnIndexes = append(m.ColumnIndexes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.ColumnIndexes) == 0 {
					m.ColumnIndexes = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnIndexes = append(m.ColumnIndexes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnIndexes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= JoinOperator_JoinType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EqualityConditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EqualityConditions = append(m.EqualityConditions, &JoinOperator_EqualityCondition{})
			if err := m.EqualityConditions[len(m.EqualityConditions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputColumns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutputColumns = append(m.OutputColumns, &JoinOperator_ParentColumn{})
			if err := m.OutputColumns[len(m.OutputColumns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowsPerBatch", wireType)
			}
			m.RowsPerBatch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RowsPerBatch |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinOperator_EqualityCondition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EqualityCondition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EqualityCondition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftColumnIndex", wireType)
			}
			m.LeftColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeftColumnIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightColumnIndex", wireType)
			}
			m.RightColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RightColumnIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinOperator_ParentColumn) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ParentColumn: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ParentColumn: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentIndex", wireType)
			}
			m.ParentIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnIndex", wireType)
			}
			m.ColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ColumnIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UDTFSourceOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UDTFSourceOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UDTFSourceOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ArgValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ArgValues = append(m.ArgValues, &ScalarValue{})
			if err := m.ArgValues[len(m.ArgValues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EmptySourceOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EmptySourceOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EmptySourceOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v typespb.DataType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.DataType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnTypes = append(m.ColumnTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ColumnTypes) == 0 {
					m.ColumnTypes = make([]typespb.DataType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.DataType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.DataType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnTypes = append(m.ColumnTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnTypes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &OTelAttribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeColumnIndex", wireType)
			}
			m.TimeColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedTimeColumnIndex", wireType)
			}
			m.ObservedTimeColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ObservedTimeColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityNumber", wireType)
			}
			m.SeverityNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeverityNumber |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityText", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SeverityText = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BodyColumnIndex", wireType)
			}
			m.BodyColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BodyColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelSpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelSpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelSpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NameString", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = &OTelSpan_NameString{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NameColumnIndex", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Name = &OTelSpan_NameColumnIndex{v}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &OTelAttribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceIDColumn", wireType)
			}
			m.TraceIDColumn = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TraceIDColumn |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanIDColumn", wireType)
			}
			m.SpanIDColumn = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SpanIDColumn |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanIDColumn", wireType)
			}
			m.ParentSpanIDColumn = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentSpanIDColumn |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeColumnIndex", wireType)
			}
			m.StartTimeColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTimeColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTimeColumnIndex", wireType)
			}
			m.EndTimeColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndTimeColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KindValue", wireType)
			}
			m.KindValue = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KindValue |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelMetricGauge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelMetricGauge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelMetricGauge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FloatColumnIndex", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ValueColumn = &OTelMetricGauge_FloatColumnIndex{v}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntColumnIndex", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ValueColumn = &OTelMetricGauge_IntColumnIndex{v}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelMetricSummary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelMetricSummary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelMetricSummary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CountColumnIndex", wireType)
			}
			m.CountColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CountColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SumColumnIndex", wireType)
			}
			m.SumColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SumColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuantileValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QuantileValues = append(m.QuantileValues, &OTelMetricSummary_ValueAtQuantile{})
			if err := m.QuantileValues[len(m.QuantileValues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelMetricSummary_ValueAtQuantile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueAtQuantile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueAtQuantile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quantile", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Quantile = float64(math.Float64frombits(v))
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValueColumnIndex", wireType)
			}
			m.ValueColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValueColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelAttribute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelAttribute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelAttribute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OTelAttribute_Column{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &OTelAttribute_Column_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &OTelAttribute_StringValue{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelAttribute_Column) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Column: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Column: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnType", wireType)
			}
			m.ColumnType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ColumnType |= typespb.DataType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnIndex", wireType)
			}
			m.ColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CanBeJsonEncodedArray", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CanBeJsonEncodedArray = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelMetric) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelMetric: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelMetric: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &OTelAttribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeColumnIndex", wireType)
			}
			m.TimeColumnIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeColumnIndex |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gauge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OTelMetricGauge{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &OTelMetric_Gauge{v}
			iNdEx = postIndex
		case 102:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Summary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OTelMetricSummary{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &OTelMetric_Summary{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelEndpointConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelEndpointConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelEndpointConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Headers == nil {
				m.Headers = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthPlan
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthPlan
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthPlan
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthPlan
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipPlan(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthPlan
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Headers[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Insecure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Insecure = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelResource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelResource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelResource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &OTelAttribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OTelExportSinkOperator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OTelExportSinkOperator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OTelExportSinkOperator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndpointConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndpointConfig == nil {
				m.EndpointConfig = &OTelEndpointConfig{}
			}
			if err := m.EndpointConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resource == nil {
				m.Resource = &OTelResource{}
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, &OTelMetric{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, &OTelSpan{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logs = append(m.Logs, &OTelLog{})
			if err := m.Logs[len(m.Logs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScalarExpression) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScalarExpression: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScalarExpression: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constant", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScalarValue{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ScalarExpression_Constant{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Column{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ScalarExpression_Column{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Func", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScalarFunc{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ScalarExpression_Func{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScalarValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScalarValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScalarValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataType", wireType)
			}
			m.DataType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DataType |= typespb.DataType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Value = &ScalarValue_BoolValue{b}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Value", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &ScalarValue_Int64Value{v}
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Float64Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &ScalarValue_Float64Value{float64(math.Float64frombits(v))}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &ScalarValue_StringValue{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time64NsValue", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &ScalarValue_Time64NsValue{v}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uint128Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &typespb.UInt128{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ScalarValue_Uint128Value{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScalarFunc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScalarFunc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScalarFunc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitArgs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InitArgs = append(m.InitArgs, &ScalarValue{})
			if err := m.InitArgs[len(m.InitArgs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &ScalarExpression{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 0 {
				var v typespb.DataType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.DataType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ArgsDataTypes = append(m.ArgsDataTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ArgsDataTypes) == 0 {
					m.ArgsDataTypes = make([]typespb.DataType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.DataType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.DataType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ArgsDataTypes = append(m.ArgsDataTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ArgsDataTypes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AggregateExpression) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AggregateExpression: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AggregateExpression: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitArgs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InitArgs = append(m.InitArgs, &ScalarValue{})
			if err := m.InitArgs[len(m.InitArgs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, &AggregateExpression_Arg{})
			if err := m.Args[len(m.Args)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType == 0 {
				var v typespb.DataType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= typespb.DataType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ArgsDataTypes = append(m.ArgsDataTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPlan
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPlan
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.ArgsDataTypes) == 0 {
					m.ArgsDataTypes = make([]typespb.DataType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v typespb.DataType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= typespb.DataType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ArgsDataTypes = append(m.ArgsDataTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ArgsDataTypes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AggregateExpression_Arg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Arg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Arg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constant", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScalarValue{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &AggregateExpression_Arg_Constant{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlan
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlan
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Column{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &AggregateExpression_Arg_Column{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Column) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Column: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Column: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			m.Node = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Node |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPlan(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPlan
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlan
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPlan
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPlan
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPlan
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPlan        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPlan          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPlan = fmt.Errorf("proto: unexpected end of group")
)
