// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: src/benchmarks/proto/benchmark.proto

package benchmarkpb

import (
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ChargeRequest struct {
	Amount     *Money          `protobuf:"bytes,1,opt,name=amount,proto3" json:"amount,omitempty"`
	CreditCard *CreditCardInfo `protobuf:"bytes,2,opt,name=credit_card,json=creditCard,proto3" json:"credit_card,omitempty"`
}

func (m *ChargeRequest) Reset()      { *m = ChargeRequest{} }
func (*ChargeRequest) ProtoMessage() {}
func (*ChargeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d346505b77f130cf, []int{0}
}
func (m *ChargeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ChargeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ChargeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ChargeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChargeRequest.Merge(m, src)
}
func (m *ChargeRequest) XXX_Size() int {
	return m.Size()
}
func (m *ChargeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ChargeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ChargeRequest proto.InternalMessageInfo

func (m *ChargeRequest) GetAmount() *Money {
	if m != nil {
		return m.Amount
	}
	return nil
}

func (m *ChargeRequest) GetCreditCard() *CreditCardInfo {
	if m != nil {
		return m.CreditCard
	}
	return nil
}

type ChargeResponse struct {
	TransactionId string `protobuf:"bytes,1,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (m *ChargeResponse) Reset()      { *m = ChargeResponse{} }
func (*ChargeResponse) ProtoMessage() {}
func (*ChargeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d346505b77f130cf, []int{1}
}
func (m *ChargeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ChargeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ChargeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ChargeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChargeResponse.Merge(m, src)
}
func (m *ChargeResponse) XXX_Size() int {
	return m.Size()
}
func (m *ChargeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ChargeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ChargeResponse proto.InternalMessageInfo

func (m *ChargeResponse) GetTransactionId() string {
	if m != nil {
		return m.TransactionId
	}
	return ""
}

type Money struct {
	CurrencyCode string `protobuf:"bytes,1,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	Units        int64  `protobuf:"varint,2,opt,name=units,proto3" json:"units,omitempty"`
	Nanos        int32  `protobuf:"varint,3,opt,name=nanos,proto3" json:"nanos,omitempty"`
}

func (m *Money) Reset()      { *m = Money{} }
func (*Money) ProtoMessage() {}
func (*Money) Descriptor() ([]byte, []int) {
	return fileDescriptor_d346505b77f130cf, []int{2}
}
func (m *Money) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Money) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Money.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Money) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Money.Merge(m, src)
}
func (m *Money) XXX_Size() int {
	return m.Size()
}
func (m *Money) XXX_DiscardUnknown() {
	xxx_messageInfo_Money.DiscardUnknown(m)
}

var xxx_messageInfo_Money proto.InternalMessageInfo

func (m *Money) GetCurrencyCode() string {
	if m != nil {
		return m.CurrencyCode
	}
	return ""
}

func (m *Money) GetUnits() int64 {
	if m != nil {
		return m.Units
	}
	return 0
}

func (m *Money) GetNanos() int32 {
	if m != nil {
		return m.Nanos
	}
	return 0
}

type CreditCardInfo struct {
	CreditCardNumber          string `protobuf:"bytes,1,opt,name=credit_card_number,json=creditCardNumber,proto3" json:"credit_card_number,omitempty"`
	CreditCardCvv             int32  `protobuf:"varint,2,opt,name=credit_card_cvv,json=creditCardCvv,proto3" json:"credit_card_cvv,omitempty"`
	CreditCardExpirationYear  int32  `protobuf:"varint,3,opt,name=credit_card_expiration_year,json=creditCardExpirationYear,proto3" json:"credit_card_expiration_year,omitempty"`
	CreditCardExpirationMonth int32  `protobuf:"varint,4,opt,name=credit_card_expiration_month,json=creditCardExpirationMonth,proto3" json:"credit_card_expiration_month,omitempty"`
}

func (m *CreditCardInfo) Reset()      { *m = CreditCardInfo{} }
func (*CreditCardInfo) ProtoMessage() {}
func (*CreditCardInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_d346505b77f130cf, []int{3}
}
func (m *CreditCardInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreditCardInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreditCardInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreditCardInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreditCardInfo.Merge(m, src)
}
func (m *CreditCardInfo) XXX_Size() int {
	return m.Size()
}
func (m *CreditCardInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CreditCardInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CreditCardInfo proto.InternalMessageInfo

func (m *CreditCardInfo) GetCreditCardNumber() string {
	if m != nil {
		return m.CreditCardNumber
	}
	return ""
}

func (m *CreditCardInfo) GetCreditCardCvv() int32 {
	if m != nil {
		return m.CreditCardCvv
	}
	return 0
}

func (m *CreditCardInfo) GetCreditCardExpirationYear() int32 {
	if m != nil {
		return m.CreditCardExpirationYear
	}
	return 0
}

func (m *CreditCardInfo) GetCreditCardExpirationMonth() int32 {
	if m != nil {
		return m.CreditCardExpirationMonth
	}
	return 0
}

func init() {
	proto.RegisterType((*ChargeRequest)(nil), "px.benchmarks.ChargeRequest")
	proto.RegisterType((*ChargeResponse)(nil), "px.benchmarks.ChargeResponse")
	proto.RegisterType((*Money)(nil), "px.benchmarks.Money")
	proto.RegisterType((*CreditCardInfo)(nil), "px.benchmarks.CreditCardInfo")
}

func init() {
	proto.RegisterFile("src/benchmarks/proto/benchmark.proto", fileDescriptor_d346505b77f130cf)
}

var fileDescriptor_d346505b77f130cf = []byte{
	// 435 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x92, 0xbd, 0x6e, 0xd4, 0x40,
	0x14, 0x85, 0x3d, 0x84, 0x5d, 0x89, 0xbb, 0x78, 0x41, 0xa3, 0x14, 0x06, 0x92, 0x51, 0xb4, 0xfc,
	0x28, 0x45, 0xb4, 0x91, 0x42, 0x41, 0x05, 0x08, 0xac, 0x14, 0x29, 0x82, 0x90, 0x29, 0xf8, 0x69,
	0x56, 0xb3, 0xe3, 0x0b, 0x6b, 0x21, 0xcf, 0x98, 0x99, 0xb1, 0x15, 0x17, 0x48, 0x3c, 0x02, 0x8f,
	0xc1, 0xa3, 0x50, 0x6e, 0x99, 0x92, 0xf5, 0x4a, 0x88, 0x32, 0x8f, 0x80, 0x32, 0x76, 0xd6, 0x4e,
	0x94, 0x2d, 0xcf, 0xf1, 0x77, 0x7c, 0xcf, 0xd5, 0x1d, 0x78, 0x64, 0xb4, 0xd8, 0x9f, 0xa2, 0x14,
	0xb3, 0x94, 0xeb, 0xaf, 0x66, 0x3f, 0xd3, 0xca, 0xaa, 0xd6, 0x18, 0x3b, 0x4d, 0xfd, 0xec, 0x64,
	0xdc, 0x42, 0xa3, 0xef, 0xe0, 0x87, 0x33, 0xae, 0xbf, 0x60, 0x84, 0xdf, 0x72, 0x34, 0x96, 0xee,
	0x41, 0x9f, 0xa7, 0x2a, 0x97, 0x36, 0x20, 0x3b, 0x64, 0x77, 0x70, 0xb0, 0x39, 0xbe, 0x14, 0x18,
	0x1f, 0x2b, 0x89, 0x65, 0xd4, 0x30, 0xf4, 0x05, 0x0c, 0x84, 0xc6, 0x38, 0xb1, 0x13, 0xc1, 0x75,
	0x1c, 0xdc, 0x70, 0x91, 0xed, 0x2b, 0x91, 0xd0, 0x11, 0x21, 0xd7, 0xf1, 0x91, 0xfc, 0xac, 0x22,
	0x10, 0x2b, 0x3d, 0x7a, 0x06, 0xc3, 0x8b, 0xf1, 0x26, 0x53, 0xd2, 0x20, 0x7d, 0x0c, 0x43, 0xab,
	0xb9, 0x34, 0x5c, 0xd8, 0x44, 0xc9, 0x49, 0x12, 0xbb, 0x1e, 0xb7, 0x22, 0xbf, 0xe3, 0x1e, 0xc5,
	0xa3, 0x0f, 0xd0, 0x73, 0x4d, 0xe8, 0x43, 0xf0, 0x45, 0xae, 0x35, 0x4a, 0x51, 0x4e, 0x84, 0x8a,
	0xb1, 0xc1, 0x6f, 0x5f, 0x98, 0xa1, 0x8a, 0x91, 0x6e, 0x42, 0x2f, 0x97, 0x89, 0x35, 0xae, 0xe0,
	0x46, 0x54, 0x8b, 0x73, 0x57, 0x72, 0xa9, 0x4c, 0xb0, 0xb1, 0x43, 0x76, 0x7b, 0x51, 0x2d, 0x46,
	0x7f, 0x09, 0x0c, 0x2f, 0x37, 0xa6, 0x7b, 0x40, 0x3b, 0x5b, 0x4e, 0x64, 0x9e, 0x4e, 0x51, 0x37,
	0x83, 0xee, 0xb6, 0xdb, 0xbc, 0x71, 0x3e, 0x7d, 0x02, 0x77, 0xba, 0xb4, 0x28, 0x0a, 0x37, 0xb6,
	0x17, 0xf9, 0x2d, 0x1a, 0x16, 0x05, 0x7d, 0x0e, 0x0f, 0xba, 0x1c, 0x9e, 0x64, 0x89, 0xe6, 0x6e,
	0xe9, 0x12, 0xb9, 0x6e, 0x4a, 0x05, 0x6d, 0xe6, 0x70, 0x05, 0x7c, 0x44, 0xae, 0xe9, 0x4b, 0xd8,
	0x5a, 0x13, 0x4f, 0x95, 0xb4, 0xb3, 0xe0, 0xa6, 0xcb, 0xdf, 0xbb, 0x2e, 0x7f, 0x7c, 0x0e, 0x1c,
	0xbc, 0x87, 0xe1, 0x5b, 0x5e, 0xa6, 0x28, 0xed, 0x3b, 0xd4, 0x45, 0x22, 0x90, 0x1e, 0x42, 0xbf,
	0xbe, 0x06, 0xdd, 0xba, 0x7a, 0xc2, 0xee, 0x1b, 0xb9, 0xbf, 0xbd, 0xe6, 0x6b, 0x7d, 0xc2, 0xd7,
	0xaf, 0xe6, 0x0b, 0xe6, 0x9d, 0x2e, 0x98, 0x77, 0xb6, 0x60, 0xe4, 0x47, 0xc5, 0xc8, 0xaf, 0x8a,
	0x91, 0xdf, 0x15, 0x23, 0xf3, 0x8a, 0x91, 0x3f, 0x15, 0x23, 0xff, 0x2a, 0xe6, 0x9d, 0x55, 0x8c,
	0xfc, 0x5c, 0x32, 0x6f, 0xbe, 0x64, 0xde, 0xe9, 0x92, 0x79, 0x9f, 0x06, 0xab, 0x1f, 0x66, 0xd3,
	0x69, 0xdf, 0x3d, 0xd6, 0xa7, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0x5f, 0x43, 0x03, 0x64, 0xd4,
	0x02, 0x00, 0x00,
}

func (this *ChargeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ChargeRequest)
	if !ok {
		that2, ok := that.(ChargeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Amount.Equal(that1.Amount) {
		return false
	}
	if !this.CreditCard.Equal(that1.CreditCard) {
		return false
	}
	return true
}
func (this *ChargeResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ChargeResponse)
	if !ok {
		that2, ok := that.(ChargeResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TransactionId != that1.TransactionId {
		return false
	}
	return true
}
func (this *Money) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Money)
	if !ok {
		that2, ok := that.(Money)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CurrencyCode != that1.CurrencyCode {
		return false
	}
	if this.Units != that1.Units {
		return false
	}
	if this.Nanos != that1.Nanos {
		return false
	}
	return true
}
func (this *CreditCardInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CreditCardInfo)
	if !ok {
		that2, ok := that.(CreditCardInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CreditCardNumber != that1.CreditCardNumber {
		return false
	}
	if this.CreditCardCvv != that1.CreditCardCvv {
		return false
	}
	if this.CreditCardExpirationYear != that1.CreditCardExpirationYear {
		return false
	}
	if this.CreditCardExpirationMonth != that1.CreditCardExpirationMonth {
		return false
	}
	return true
}
func (this *ChargeRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&benchmarkpb.ChargeRequest{")
	if this.Amount != nil {
		s = append(s, "Amount: "+fmt.Sprintf("%#v", this.Amount)+",\n")
	}
	if this.CreditCard != nil {
		s = append(s, "CreditCard: "+fmt.Sprintf("%#v", this.CreditCard)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ChargeResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&benchmarkpb.ChargeResponse{")
	s = append(s, "TransactionId: "+fmt.Sprintf("%#v", this.TransactionId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Money) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&benchmarkpb.Money{")
	s = append(s, "CurrencyCode: "+fmt.Sprintf("%#v", this.CurrencyCode)+",\n")
	s = append(s, "Units: "+fmt.Sprintf("%#v", this.Units)+",\n")
	s = append(s, "Nanos: "+fmt.Sprintf("%#v", this.Nanos)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CreditCardInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&benchmarkpb.CreditCardInfo{")
	s = append(s, "CreditCardNumber: "+fmt.Sprintf("%#v", this.CreditCardNumber)+",\n")
	s = append(s, "CreditCardCvv: "+fmt.Sprintf("%#v", this.CreditCardCvv)+",\n")
	s = append(s, "CreditCardExpirationYear: "+fmt.Sprintf("%#v", this.CreditCardExpirationYear)+",\n")
	s = append(s, "CreditCardExpirationMonth: "+fmt.Sprintf("%#v", this.CreditCardExpirationMonth)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringBenchmark(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// PaymentServiceClient is the client API for PaymentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PaymentServiceClient interface {
	Charge(ctx context.Context, in *ChargeRequest, opts ...grpc.CallOption) (*ChargeResponse, error)
}

type paymentServiceClient struct {
	cc *grpc.ClientConn
}

func NewPaymentServiceClient(cc *grpc.ClientConn) PaymentServiceClient {
	return &paymentServiceClient{cc}
}

func (c *paymentServiceClient) Charge(ctx context.Context, in *ChargeRequest, opts ...grpc.CallOption) (*ChargeResponse, error) {
	out := new(ChargeResponse)
	err := c.cc.Invoke(ctx, "/px.benchmarks.PaymentService/Charge", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PaymentServiceServer is the server API for PaymentService service.
type PaymentServiceServer interface {
	Charge(context.Context, *ChargeRequest) (*ChargeResponse, error)
}

// UnimplementedPaymentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPaymentServiceServer struct {
}

func (*UnimplementedPaymentServiceServer) Charge(ctx context.Context, req *ChargeRequest) (*ChargeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Charge not implemented")
}

func RegisterPaymentServiceServer(s *grpc.Server, srv PaymentServiceServer) {
	s.RegisterService(&_PaymentService_serviceDesc, srv)
}

func _PaymentService_Charge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChargeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PaymentServiceServer).Charge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/px.benchmarks.PaymentService/Charge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PaymentServiceServer).Charge(ctx, req.(*ChargeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PaymentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "px.benchmarks.PaymentService",
	HandlerType: (*PaymentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Charge",
			Handler:    _PaymentService_Charge_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "src/benchmarks/proto/benchmark.proto",
}

func (m *ChargeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChargeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ChargeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CreditCard != nil {
		{
			size, err := m.CreditCard.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBenchmark(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Amount != nil {
		{
			size, err := m.Amount.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBenchmark(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ChargeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChargeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ChargeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TransactionId) > 0 {
		i -= len(m.TransactionId)
		copy(dAtA[i:], m.TransactionId)
		i = encodeVarintBenchmark(dAtA, i, uint64(len(m.TransactionId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Money) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Money) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Money) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Nanos != 0 {
		i = encodeVarintBenchmark(dAtA, i, uint64(m.Nanos))
		i--
		dAtA[i] = 0x18
	}
	if m.Units != 0 {
		i = encodeVarintBenchmark(dAtA, i, uint64(m.Units))
		i--
		dAtA[i] = 0x10
	}
	if len(m.CurrencyCode) > 0 {
		i -= len(m.CurrencyCode)
		copy(dAtA[i:], m.CurrencyCode)
		i = encodeVarintBenchmark(dAtA, i, uint64(len(m.CurrencyCode)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CreditCardInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreditCardInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreditCardInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CreditCardExpirationMonth != 0 {
		i = encodeVarintBenchmark(dAtA, i, uint64(m.CreditCardExpirationMonth))
		i--
		dAtA[i] = 0x20
	}
	if m.CreditCardExpirationYear != 0 {
		i = encodeVarintBenchmark(dAtA, i, uint64(m.CreditCardExpirationYear))
		i--
		dAtA[i] = 0x18
	}
	if m.CreditCardCvv != 0 {
		i = encodeVarintBenchmark(dAtA, i, uint64(m.CreditCardCvv))
		i--
		dAtA[i] = 0x10
	}
	if len(m.CreditCardNumber) > 0 {
		i -= len(m.CreditCardNumber)
		copy(dAtA[i:], m.CreditCardNumber)
		i = encodeVarintBenchmark(dAtA, i, uint64(len(m.CreditCardNumber)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintBenchmark(dAtA []byte, offset int, v uint64) int {
	offset -= sovBenchmark(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ChargeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Amount != nil {
		l = m.Amount.Size()
		n += 1 + l + sovBenchmark(uint64(l))
	}
	if m.CreditCard != nil {
		l = m.CreditCard.Size()
		n += 1 + l + sovBenchmark(uint64(l))
	}
	return n
}

func (m *ChargeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TransactionId)
	if l > 0 {
		n += 1 + l + sovBenchmark(uint64(l))
	}
	return n
}

func (m *Money) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CurrencyCode)
	if l > 0 {
		n += 1 + l + sovBenchmark(uint64(l))
	}
	if m.Units != 0 {
		n += 1 + sovBenchmark(uint64(m.Units))
	}
	if m.Nanos != 0 {
		n += 1 + sovBenchmark(uint64(m.Nanos))
	}
	return n
}

func (m *CreditCardInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CreditCardNumber)
	if l > 0 {
		n += 1 + l + sovBenchmark(uint64(l))
	}
	if m.CreditCardCvv != 0 {
		n += 1 + sovBenchmark(uint64(m.CreditCardCvv))
	}
	if m.CreditCardExpirationYear != 0 {
		n += 1 + sovBenchmark(uint64(m.CreditCardExpirationYear))
	}
	if m.CreditCardExpirationMonth != 0 {
		n += 1 + sovBenchmark(uint64(m.CreditCardExpirationMonth))
	}
	return n
}

func sovBenchmark(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozBenchmark(x uint64) (n int) {
	return sovBenchmark(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ChargeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ChargeRequest{`,
		`Amount:` + strings.Replace(this.Amount.String(), "Money", "Money", 1) + `,`,
		`CreditCard:` + strings.Replace(this.CreditCard.String(), "CreditCardInfo", "CreditCardInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ChargeResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ChargeResponse{`,
		`TransactionId:` + fmt.Sprintf("%v", this.TransactionId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Money) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Money{`,
		`CurrencyCode:` + fmt.Sprintf("%v", this.CurrencyCode) + `,`,
		`Units:` + fmt.Sprintf("%v", this.Units) + `,`,
		`Nanos:` + fmt.Sprintf("%v", this.Nanos) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreditCardInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreditCardInfo{`,
		`CreditCardNumber:` + fmt.Sprintf("%v", this.CreditCardNumber) + `,`,
		`CreditCardCvv:` + fmt.Sprintf("%v", this.CreditCardCvv) + `,`,
		`CreditCardExpirationYear:` + fmt.Sprintf("%v", this.CreditCardExpirationYear) + `,`,
		`CreditCardExpirationMonth:` + fmt.Sprintf("%v", this.CreditCardExpirationMonth) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringBenchmark(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ChargeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBenchmark
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChargeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChargeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Amount", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBenchmark
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBenchmark
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Amount == nil {
				m.Amount = &Money{}
			}
			if err := m.Amount.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreditCard", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBenchmark
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBenchmark
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreditCard == nil {
				m.CreditCard = &CreditCardInfo{}
			}
			if err := m.CreditCard.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBenchmark(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBenchmark
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChargeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBenchmark
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChargeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChargeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBenchmark
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBenchmark
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TransactionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBenchmark(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBenchmark
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Money) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBenchmark
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Money: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Money: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrencyCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBenchmark
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBenchmark
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrencyCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Units", wireType)
			}
			m.Units = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Units |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nanos", wireType)
			}
			m.Nanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Nanos |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBenchmark(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBenchmark
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreditCardInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBenchmark
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreditCardInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreditCardInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreditCardNumber", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBenchmark
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBenchmark
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreditCardNumber = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreditCardCvv", wireType)
			}
			m.CreditCardCvv = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreditCardCvv |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreditCardExpirationYear", wireType)
			}
			m.CreditCardExpirationYear = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreditCardExpirationYear |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreditCardExpirationMonth", wireType)
			}
			m.CreditCardExpirationMonth = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreditCardExpirationMonth |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBenchmark(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBenchmark
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBenchmark(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBenchmark
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBenchmark
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthBenchmark
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupBenchmark
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthBenchmark
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthBenchmark        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBenchmark          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupBenchmark = fmt.Errorf("proto: unexpected end of group")
)
