/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package metrics

var VTAP_APP_PORT_METRICS = map[string]*Metrics{}

var VTAP_APP_PORT_METRICS_REPLACE = map[string]*Metrics{
	"rrt": NewReplaceMetrics("rrt_sum/rrt_count", ""),

	"error_ratio":        NewReplaceMetrics("error/response", ""),
	"client_error_ratio": NewReplaceMetrics("client_error/response", ""),
	"server_error_ratio": NewReplaceMetrics("server_error/response", ""),
	"timeout_ratio":      NewReplaceMetrics("timeout/request", ""),
	"response_ratio":     NewReplaceMetrics("response/request", ""),
	"success_ratio":      NewReplaceMetrics("1 - error/response", ""),
}

func GetVtapAppPortMetrics() map[string]*Metrics {
	return VTAP_APP_PORT_METRICS
}
