/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cache

import "sync"

type CacheCounter struct {
	Stats *CacheStats

	*sync.Mutex
	exited bool
}

type CacheStats struct {
	CacheSizeOverFlow  uint64 `statsd:"cache_size_overflow"`
	CacheMiss          uint64 `statsd:"cache_miss"`
	CacheHit           uint64 `statsd:"cache_hit"`
	CacheMerge         uint64 `statsd:"cache_merge"`
	CacheMergeDuration uint64 `statsd:"cache_merge_duration"`
}

func (c *CacheCounter) GetCounter() interface{} {
	stats := &CacheStats{}
	stats, c.Stats = c.Stats, stats
	return stats
}

func (c *CacheCounter) Close() {
	c.exited = true
}

func (c *CacheCounter) Closed() bool {
	return c.exited
}
