/**
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package resource

import (
	"github.com/gin-gonic/gin"

	ctrlcommon "github.com/deepflowio/deepflow/server/controller/common"
	"github.com/deepflowio/deepflow/server/controller/http/common/response"
	"github.com/deepflowio/deepflow/server/controller/http/service/resource"
)

type VPC struct{}

func NewVPC() *VPC {
	return new(VPC)
}

func (v *VPC) RegisterTo(e *gin.Engine) {
	e.GET("/v2/epcs", getVPCs)
}

func getVPCs(c *gin.Context) {
	args := make(map[string]interface{})
	if value, ok := c.GetQuery("name"); ok {
		args["name"] = value
	}
	orgID, _ := c.Get(ctrlcommon.HEADER_KEY_X_ORG_ID)
	data, err := resource.GetVPCs(orgID.(int), args)
	response.JSON(c, response.SetData(data), response.SetError(err))
}
