/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package tencent

import (
	"github.com/deepflowio/deepflow/server/controller/cloud/model"
	"github.com/deepflowio/deepflow/server/controller/common"
	"github.com/deepflowio/deepflow/server/libs/logger"
)

func (t *Tencent) getFloatingIPs() (floatingIPs []model.FloatingIP, err error) {
	log.Debug("get floating ips starting", logger.NewORGPrefix(t.orgID))
	for ip, v := range t.publicIPToVinterface {
		floatingIP := model.FloatingIP{
			Lcuuid:        common.GetUUIDByOrgID(t.orgID, v.Lcuuid+ip),
			IP:            ip,
			VMLcuuid:      v.DeviceLcuuid,
			NetworkLcuuid: common.NETWORK_ISP_LCUUID,
			VPCLcuuid:     v.VPCLcuuid,
			RegionLcuuid:  v.RegionLcuuid,
		}
		floatingIPs = append(floatingIPs, floatingIP)
	}
	log.Debug("get floating ips complete", logger.NewORGPrefix(t.orgID))
	return
}
