/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package huawei

import (
	"fmt"

	cloudcommon "github.com/deepflowio/deepflow/server/controller/cloud/common"
	"github.com/deepflowio/deepflow/server/controller/cloud/model"
	"github.com/deepflowio/deepflow/server/controller/common"
	"github.com/deepflowio/deepflow/server/libs/logger"
)

func (h *HuaWei) getAZs() ([]model.AZ, error) {
	var azs []model.AZ
	for project, token := range h.projectTokenMap {
		jAZs, err := h.getRawData(newRawDataGetContext(
			fmt.Sprintf("https://ecs.%s.%s/v1/%s/availability-zones", project.name, h.config.Domain, project.id), token.token, "availability_zones", pageQueryMethodNotPage,
		))
		if err != nil {
			return nil, err
		}

		regionLcuuid := h.projectNameToRegionLcuuid(project.name)
		for i := range jAZs {
			ja := jAZs[i]
			zname := ja.Get("availability_zone_id").MustString()
			if !cloudcommon.CheckJsonAttributes(ja, []string{"availability_zone_id"}) {
				log.Infof("exclude az: %s, missing attr", zname, logger.NewORGPrefix(h.orgID))
				continue
			}
			lcuuid := common.GenerateUUIDByOrgID(h.orgID, zname+"_"+h.lcuuidGenerate)
			azs = append(
				azs,
				model.AZ{
					Lcuuid:       lcuuid,
					Name:         zname,
					RegionLcuuid: regionLcuuid,
				},
			)
			h.toolDataSet.azNameToAZLcuuid[zname] = lcuuid
		}
	}
	return azs, nil
}
