### Table of Contents

**[DeepFlow release v6.5](#v65)**<br/>

# Changelog

### <a id="v65"></a>DeepFlow release v6.5

#### New Feature
* feat: Add Changelog [#7095](https://github.com/deepflowio/deepflow/pull/7095)
* feat: CK’s username and password support the use of special characters [#7229](https://github.com/deepflowio/deepflow/pull/7119)

#### Bug Fix
* fix: wan type cidr may not be tagged [#8813](https://github.com/deepflowio/deepflow/pull/8813) by [lzf575](https://github.com/lzf575)
* fix: the throttler cannot write all data to the queue at once [#8793](https://github.com/deepflowio/deepflow/pull/8793) by [lzf575](https://github.com/lzf575)
* fix: recorder fails to clean 10w data at one time [#8707](https://github.com/deepflowio/deepflow/pull/8707) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: agent - eBPF Correct the maximum data push delay [#8704](https://github.com/deepflowio/deepflow/pull/8704) by [yinjiping](https://github.com/yinjiping)
* fix: update sub domain team_id [#8674](https://github.com/deepflowio/deepflow/pull/8674) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: nil pointer may cause panic [#8672](https://github.com/deepflowio/deepflow/pull/8672) by [lzf575](https://github.com/lzf575)
* fix: invalid bpf syntax [#8648](https://github.com/deepflowio/deepflow/pull/8648) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: pcap,l4_packet,spantrace data exception [#8596](https://github.com/deepflowio/deepflow/pull/8596) by [lzf575](https://github.com/lzf575)
* fix: the policy does not check memory in analyzer mode [#8551](https://github.com/deepflowio/deepflow/pull/8551) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: eBPF SELinux permission-related exit [#8533](https://github.com/deepflowio/deepflow/pull/8533) by [yinjiping](https://github.com/yinjiping)
* fix: panic when prepare write failed [#8524](https://github.com/deepflowio/deepflow/pull/8524) by [lzf575](https://github.com/lzf575)
* fix: agent - eBPF Kernels below v5.2 cannot retrieve IO events [#8511](https://github.com/deepflowio/deepflow/pull/8511) by [yinjiping](https://github.com/yinjiping)
* fix: mongo log was missing the request content [#8478](https://github.com/deepflowio/deepflow/pull/8478) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: ckwriter writing failure caused by not writing data for a long time [#8469](https://github.com/deepflowio/deepflow/pull/8469) by [lzf575](https://github.com/lzf575)
* fix: no need to retry after writing failure [#8452](https://github.com/deepflowio/deepflow/pull/8452) by [lzf575](https://github.com/lzf575)
* fix: agent stuck when ntp is turned on [#8443](https://github.com/deepflowio/deepflow/pull/8443) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: container env supports aggr packets with and without tunnels [#8425](https://github.com/deepflowio/deepflow/pull/8425) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: modify the matching logic of flow_node [#8419](https://github.com/deepflowio/deepflow/pull/8419) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: agent - eBPF Total process message initialization [#8331](https://github.com/deepflowio/deepflow/pull/8331) by [yinjiping](https://github.com/yinjiping)
* fix: remove dynamic libpcap [#8320](https://github.com/deepflowio/deepflow/pull/8320) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: when EPC is unknown, region should not be unknown [#8316](https://github.com/deepflowio/deepflow/pull/8316) by [lzf575](https://github.com/lzf575)
* fix agent - eBPF Fix the parsing of the kernel version (#8311) [#8312](https://github.com/deepflowio/deepflow/pull/8312) by [yinjiping](https://github.com/yinjiping)
* fix: update mirror ci [#8300](https://github.com/deepflowio/deepflow/pull/8300) by [jiumos](https://github.com/jiumos)
* fix: agent - eBPF Random time to process symbol table creation [#8281](https://github.com/deepflowio/deepflow/pull/8281) by [yinjiping](https://github.com/yinjiping)
* fix: add export thread id [#8279](https://github.com/deepflowio/deepflow/pull/8279) by [lzf575](https://github.com/lzf575)
* fix: agent - eBPF Handle the scenario where CONFIG_NET_NS is disabled [#8277](https://github.com/deepflowio/deepflow/pull/8277) by [yinjiping](https://github.com/yinjiping)
* fix: topK multiple parameter query error [#8250](https://github.com/deepflowio/deepflow/pull/8250) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: querier TopK supporrt resource_id [#8234](https://github.com/deepflowio/deepflow/pull/8234) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: agent - Other eBPF bin-file will be selected when kfunc loading fails [#8227](https://github.com/deepflowio/deepflow/pull/8227) by [yinjiping](https://github.com/yinjiping)
* fix: reduce kafka app misidentification [#8206](https://github.com/deepflowio/deepflow/pull/8206) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: incorrect tcp rrt [#8190](https://github.com/deepflowio/deepflow/pull/8190) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: the aggregation method of unsummable fields of custom data_source is wrong [#8182](https://github.com/deepflowio/deepflow/pull/8182) by [lzf575](https://github.com/lzf575)
* fix: applicaition log decode failed causes subsequent data anomalies [#8178](https://github.com/deepflowio/deepflow/pull/8178) by [lzf575](https://github.com/lzf575)
* fix: Bad cstr passed into pcap_compile_nopcap [#8175](https://github.com/deepflowio/deepflow/pull/8175) by [rvql](https://github.com/rvql)
* fix: agent - eBPF fix errors caused by java_syms_update_tasks_head [#8147](https://github.com/deepflowio/deepflow/pull/8147) by [yinjiping](https://github.com/yinjiping)
* fix: dispatcher pipelines is empty [#8001](https://github.com/deepflowio/deepflow/pull/8001) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: incorrect request resource in kafka logs [#8142](https://github.com/deepflowio/deepflow/pull/8142) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: specify the go mod version when cli verify [#8136](https://github.com/deepflowio/deepflow/pull/8136) by [jiumos](https://github.com/jiumos)
* fix:  specify the go mod version when building the cli [#8123](https://github.com/deepflowio/deepflow/pull/8123) by [jiumos](https://github.com/jiumos)
* fix: agent - eBPF Fix the calculation of total process time [#8116](https://github.com/deepflowio/deepflow/pull/8116) by [yinjiping](https://github.com/yinjiping)
* fix: querier last function add order by time [#8113](https://github.com/deepflowio/deepflow/pull/8113) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: agent desensitizes the content in backticks [#8073](https://github.com/deepflowio/deepflow/pull/8073) by [TomatoMr](https://github.com/TomatoMr)
* fix: agent command panic [#8070](https://github.com/deepflowio/deepflow/pull/8070) by [roryye](https://github.com/roryye)
* fix: add timeout to receive agent command heart beat [#8048](https://github.com/deepflowio/deepflow/pull/8048) by [roryye](https://github.com/roryye)
* fix: target port associated to controller [#8057](https://github.com/deepflowio/deepflow/pull/8057) by [askyrie](https://github.com/askyrie)
* fix: OffCpuProfile adds authorization control [#8022](https://github.com/deepflowio/deepflow/pull/8022) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* fix: agent - eBPF Fix the issue with loading '__sys_recvmmsg' [#8052](https://github.com/deepflowio/deepflow/pull/8052) by [yinjiping](https://github.com/yinjiping)
* fix: controller records unnecessary error logs [#8025](https://github.com/deepflowio/deepflow/pull/8025) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: agent - eBPF fentry/fexit Check for '__sys_recvmmsg' [#8011](https://github.com/deepflowio/deepflow/pull/8011) by [yinjiping](https://github.com/yinjiping)
* fix: resource label errors for non-default organization resource chan… [#8009](https://github.com/deepflowio/deepflow/pull/8009) by [lzf575](https://github.com/lzf575)
* fix: controller records unnecessary error logs [#8005](https://github.com/deepflowio/deepflow/pull/8005) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: fixes recorder cache log level error [#7974](https://github.com/deepflowio/deepflow/pull/7974) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: agent - eBPF Remove the handling of redundant process events [#7978](https://github.com/deepflowio/deepflow/pull/7978) by [yinjiping](https://github.com/yinjiping)
* fix: add libpcap to deb package [#7967](https://github.com/deepflowio/deepflow/pull/7967) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: delete agent group [#7963](https://github.com/deepflowio/deepflow/pull/7963) by [roryye](https://github.com/roryye)
* fix: agent - eBPF Modify memory barrier for ring [#7941](https://github.com/deepflowio/deepflow/pull/7941) by [yinjiping](https://github.com/yinjiping)
* fix: delete agent group [#7954](https://github.com/deepflowio/deepflow/pull/7954) by [roryye](https://github.com/roryye)
* fix: agent registration followGroupFeatures is all features [#7950](https://github.com/deepflowio/deepflow/pull/7950) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* fix: issu sql version [#7947](https://github.com/deepflowio/deepflow/pull/7947) by [roryye](https://github.com/roryye)
* fix: incorrect fast path map size [#7892](https://github.com/deepflowio/deepflow/pull/7892) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: abnormal stats data, causing deepflow-server to panic [#7891](https://github.com/deepflowio/deepflow/pull/7891) by [lzf575](https://github.com/lzf575)
* fix: concurrent map read and map write [#7811](https://github.com/deepflowio/deepflow/pull/7811) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat: fixes allocating wrong org id [#7864](https://github.com/deepflowio/deepflow/pull/7864) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: drop data which organization is not exist [#7863](https://github.com/deepflowio/deepflow/pull/7863) by [lzf575](https://github.com/lzf575)
* fix: drop Org data in ckwriter [#7859](https://github.com/deepflowio/deepflow/pull/7859) by [lzf575](https://github.com/lzf575)
* fix: skip check when getting icon fails [#7851](https://github.com/deepflowio/deepflow/pull/7851) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: Add libpcap dependency to installation package [#7834](https://github.com/deepflowio/deepflow/pull/7834) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: fix agent rebalance panic [#7830](https://github.com/deepflowio/deepflow/pull/7830) by [roryye](https://github.com/roryye)
* fix: fix the problem of config pointer copy [#7823](https://github.com/deepflowio/deepflow/pull/7823) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* fix: CVE-2024-35195 vuln [#7809](https://github.com/deepflowio/deepflow/pull/7809) by [taloric](https://github.com/taloric)
* fix: turn off the call monitoring function and stop related functions [#7806](https://github.com/deepflowio/deepflow/pull/7806) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* fix: agent enable feature permission [#7795](https://github.com/deepflowio/deepflow/pull/7795) by [roryye](https://github.com/roryye)
* Revert "fix: refresh agent enable feature" [#7793](https://github.com/deepflowio/deepflow/pull/7793) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* fix: refresh agent enable feature [#7791](https://github.com/deepflowio/deepflow/pull/7791) by [roryye](https://github.com/roryye)
* fix: Modify ch_table update time #26153 [#7785](https://github.com/deepflowio/deepflow/pull/7785) by [Ericsssss](https://github.com/Ericsssss)
* fix: not found replicaset pod [#7761](https://github.com/deepflowio/deepflow/pull/7761) by [askyrie](https://github.com/askyrie)
* fix: uses wrong host when request server http service [#7759](https://github.com/deepflowio/deepflow/pull/7759) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: Fix enum filter error [#7731](https://github.com/deepflowio/deepflow/pull/7731) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: ntp support profile data [#7706](https://github.com/deepflowio/deepflow/pull/7706) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: Modify show tags API error #26063 [#7703](https://github.com/deepflowio/deepflow/pull/7703) by [Ericsssss](https://github.com/Ericsssss)
* fix: agent fixes empty endpoint when setting http-endpoint-extraction.match-rules.prefix: "" [#7699](https://github.com/deepflowio/deepflow/pull/7699) by [TomatoMr](https://github.com/TomatoMr)
* fix: agent remote exec panic [#7694](https://github.com/deepflowio/deepflow/pull/7694) by [roryye](https://github.com/roryye)
* fix: Translate metrics by table [#7678](https://github.com/deepflowio/deepflow/pull/7678) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: abstract pod group association error [#7673](https://github.com/deepflowio/deepflow/pull/7673) by [askyrie](https://github.com/askyrie)
* fix: restart agent after enabling ntp [#7657](https://github.com/deepflowio/deepflow/pull/7657) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: need to drop deepflow_tenant/admin database when drop an organization [#7649](https://github.com/deepflowio/deepflow/pull/7649) by [lzf575](https://github.com/lzf575)
* fix: agent - eBPF Fix Kafka protocol inference [#7644](https://github.com/deepflowio/deepflow/pull/7644) by [yinjiping](https://github.com/yinjiping)
* fix: agent cmd panic [#7638](https://github.com/deepflowio/deepflow/pull/7638) by [roryye](https://github.com/roryye)
* fix: Translate fields by table [#7635](https://github.com/deepflowio/deepflow/pull/7635) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: Modify custom tag show tags error #25979 [#7632](https://github.com/deepflowio/deepflow/pull/7632) by [Ericsssss](https://github.com/Ericsssss)
* fix: modify resource delete error #25844 [#7608](https://github.com/deepflowio/deepflow/pull/7608) by [Ericsssss](https://github.com/Ericsssss)
* fix: Remove useless output from CL [#7593](https://github.com/deepflowio/deepflow/pull/7593) by [roryye](https://github.com/roryye)
* fix: agent - windows compile error [#7589](https://github.com/deepflowio/deepflow/pull/7589) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: agent - missing cbpf l7 log [#7586](https://github.com/deepflowio/deepflow/pull/7586) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: agent - eBPF Modify the whitelist restructuring format [#7580](https://github.com/deepflowio/deepflow/pull/7580) by [yinjiping](https://github.com/yinjiping)
* fix: data under all organizations should be cleared when disk is full [#7566](https://github.com/deepflowio/deepflow/pull/7566) by [lzf575](https://github.com/lzf575)
* fix: do not pub to tagrecorder [#7562](https://github.com/deepflowio/deepflow/pull/7562) by [askyrie](https://github.com/askyrie)
* fix: add log to agent remote command [#7521](https://github.com/deepflowio/deepflow/pull/7521) by [roryye](https://github.com/roryye)
* fix: Do not verify dynamic tags [#7505](https://github.com/deepflowio/deepflow/pull/7505) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: agent - eBPF Continuous Java profiling support for linux 3.10 [#7485](https://github.com/deepflowio/deepflow/pull/7485) by [yinjiping](https://github.com/yinjiping)
* fix: update agent commands permission [#7481](https://github.com/deepflowio/deepflow/pull/7481) by [roryye](https://github.com/roryye)
* fix: process resource api does not response sub_domain field [#7448](https://github.com/deepflowio/deepflow/pull/7448) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: Fix the problem of duplicate fields in select [#7436](https://github.com/deepflowio/deepflow/pull/7436) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: recorder reports wrong sub_domain infomation in domain logs [#7435](https://github.com/deepflowio/deepflow/pull/7435) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: Fix concurrent request command for the same agent [#7431](https://github.com/deepflowio/deepflow/pull/7431) by [roryye](https://github.com/roryye)
* fix: Uniq operator error [#7402](https://github.com/deepflowio/deepflow/pull/7402) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: deepflow-server may panic when updating platform information [#7399](https://github.com/deepflowio/deepflow/pull/7399) by [lzf575](https://github.com/lzf575)
* fix: Add return processing to agent command [#7397](https://github.com/deepflowio/deepflow/pull/7397) by [roryye](https://github.com/roryye)
* fix: Fix windows compilation [#7390](https://github.com/deepflowio/deepflow/pull/7390) by [rvql](https://github.com/rvql)
* fix: Add filter to agent remote command and handle content when error… [#7382](https://github.com/deepflowio/deepflow/pull/7382) by [roryye](https://github.com/roryye)
* fix: Community Edition does not support multi-organization and multi-team features [#7375](https://github.com/deepflowio/deepflow/pull/7375) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* fix: agent wrong desensitized mysql trace_id [#7371](https://github.com/deepflowio/deepflow/pull/7371) by [TomatoMr](https://github.com/TomatoMr)
* fix: Add mysql error log to monitor module [#7364](https://github.com/deepflowio/deepflow/pull/7364) by [roryye](https://github.com/roryye)
* fix: agent - windows compile error [#7359](https://github.com/deepflowio/deepflow/pull/7359) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: agent - vm mac address not updated [#7356](https://github.com/deepflowio/deepflow/pull/7356) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: Fix missing pod interface in macvlan mode [#7336](https://github.com/deepflowio/deepflow/pull/7336) by [rvql](https://github.com/rvql)
* fix: agent - incorrect grpc ebpf tcp seq (#7333) [#7335](https://github.com/deepflowio/deepflow/pull/7335) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: Remove useless output from CLI [#7332](https://github.com/deepflowio/deepflow/pull/7332) by [roryye](https://github.com/roryye)
* fix: agent - missing mysql log [#7324](https://github.com/deepflowio/deepflow/pull/7324) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: if OrgID is set, deepflow-server stats should be stored in deepflow_tenant [#7322](https://github.com/deepflowio/deepflow/pull/7322) by [lzf575](https://github.com/lzf575)
* fix: server recorder fixes db query condition error [#7282](https://github.com/deepflowio/deepflow/pull/7282) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: manually created ips are deleted unexpectedly [#7310](https://github.com/deepflowio/deepflow/pull/7310) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: agent - incorrect http2 log [#7297](https://github.com/deepflowio/deepflow/pull/7297) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: the flow_tag of prometheus may be lost under multiple organizations [#7295](https://github.com/deepflowio/deepflow/pull/7295) by [lzf575](https://github.com/lzf575)
* fix: agent - eBPF Adjust Java syms-cache update logic & error log output [#7290](https://github.com/deepflowio/deepflow/pull/7290) by [yinjiping](https://github.com/yinjiping)
* fix: deepflow stats may write to wrong database [#7286](https://github.com/deepflowio/deepflow/pull/7286) by [lzf575](https://github.com/lzf575)
* fix: agent - eBPF Addressing excessive eBPF maps memory usage [#7276](https://github.com/deepflowio/deepflow/pull/7276) by [yinjiping](https://github.com/yinjiping)
* fix: Show metrics use query cache can be configured [#7271](https://github.com/deepflowio/deepflow/pull/7271) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: server recorder prints unnecessary error logs [#7264](https://github.com/deepflowio/deepflow/pull/7264) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: Network interface card list supports duplicate mac [#7253](https://github.com/deepflowio/deepflow/pull/7253) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: uses long connection to connect to CK for datasources manager [#7242](https://github.com/deepflowio/deepflow/pull/7242) by [lzf575](https://github.com/lzf575)
* fix: server recorder prints unnecessary error logs [#7192](https://github.com/deepflowio/deepflow/pull/7192) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: when modifying the TTL of the CK table fails, the connection to CK needs to be closed [#7202](https://github.com/deepflowio/deepflow/pull/7202) by [lzf575](https://github.com/lzf575)
* fix: getting wrong org-id and team-id when the Agent version is less than v6.5.9 [#7202](https://github.com/deepflowio/deepflow/pull/7202) by [lzf575](https://github.com/lzf575)
* fix: agent Packet fanout can only be set in TapMode::Local mode [#7229](https://github.com/deepflowio/deepflow/pull/7229) by [TomatoMr](https://github.com/TomatoMr)
* fix: Attribute supports Chinese [#7228](https://github.com/deepflowio/deepflow/pull/7228) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: agent - incorrect grpc log collected by uprobe [#7201](https://github.com/deepflowio/deepflow/pull/7201) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: Modify the value of team's short lcuuid corresponding to org_id [#7176](https://github.com/deepflowio/deepflow/pull/7176) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* fix: Only the default organization registers with tsdb [#7169](https://github.com/deepflowio/deepflow/pull/7169) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* fix: agent - eBPF Adjust syscall sendto() for IPv6 mapping to IPv4 [#7159](https://github.com/deepflowio/deepflow/pull/7159) by [yinjiping](https://github.com/yinjiping)
* fix: agent sync ignore loopback ip [#7153](https://github.com/deepflowio/deepflow/pull/7153) by [askyrie](https://github.com/askyrie)
* fix: agent - eBPF Ensure the Sofa protocol can reassemble [#7150](https://github.com/deepflowio/deepflow/pull/7150) by [yinjiping](https://github.com/yinjiping)
* fix: Repair collector network card list display incomplete [#7148](https://github.com/deepflowio/deepflow/pull/7148) by [xiaochaoren1](https://github.com/xiaochaoren1)
* fix: server removes redundant function codes to avoid log errors [#7142](https://github.com/deepflowio/deepflow/pull/7142) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: agent - eBPF Resolve missing fork() syscall on arm64 [#7140](https://github.com/deepflowio/deepflow/pull/7140) by [yinjiping](https://github.com/yinjiping)
* fix: agent - eBPF DNS cannot obtain network tuple data [#7131](https://github.com/deepflowio/deepflow/pull/7131) by [yinjiping](https://github.com/yinjiping)
* fix: Ingester always update prometheus labels even if labels version has not change [#7129](https://github.com/deepflowio/deepflow/pull/7129) by [lzf575](https://github.com/lzf575)
* fix: k8s refresh close keep alive [#7117](https://github.com/deepflowio/deepflow/pull/7117) by [askyrie](https://github.com/askyrie)
* fix: server controller changes prometheus label version when data doe… [#7115](https://github.com/deepflowio/deepflow/pull/7115) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* fix: agent - add sleep before exiting [#7112](https://github.com/deepflowio/deepflow/pull/7112) by [yuanchaoa](https://github.com/yuanchaoa)
* fix: agent - eBPF Enhance Mongo/SOFA/MySQL/HTTP2 protocol inference [#7110](https://github.com/deepflowio/deepflow/pull/7110) by [yinjiping](https://github.com/yinjiping)
* fix: prometheus data cannot be labeled with universal tags，if slow-de… [#7101](https://github.com/deepflowio/deepflow/pull/7101) by [lzf575](https://github.com/lzf575)
* fix: agent - eBPF uprobe HTTP2 is missing setting for l7_proto [#7093](https://github.com/deepflowio/deepflow/pull/7093) by [yinjiping](https://github.com/yinjiping)
* fix: prometheus data cannot be labeled with universal tags, if slow-decoder is used. [#7100](https://github.com/deepflowio/deepflow/pull/7100)
* fix: agent - eBPF strengthening protocol inference for SOFARPC and MySQL [#7110](https://github.com/deepflowio/deepflow/pull/7110)
* fix: server controller changes prometheus label version when data does not change actually. [#7115](https://github.com/deepflowio/deepflow/pull/7115)
* fix: Ingester always update prometheus labels even if labels version has not changed.  [#7128](https://github.com/deepflowio/deepflow/pull/7128)

**[Changelog for v6.5](https://www.deepflow.io/docs/release-notes/release-6.5-ce)**<br/>

#### NEW FEATURE
* feat: agent - eBPF Add a Musl flag option [#9022](https://github.com/deepflowio/deepflow/pull/9022) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Add an extended directory [#9019](https://github.com/deepflowio/deepflow/pull/9019) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Add compilation for extension files [#9015](https://github.com/deepflowio/deepflow/pull/9015) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Adaptation for TLinux 4.14.105-19-0019 [#9014](https://github.com/deepflowio/deepflow/pull/9014) by [yinjiping](https://github.com/yinjiping)
* feat: updatae tunnel decap feature [#8591](https://github.com/deepflowio/deepflow/pull/8591) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: update vtap ignore fields [#8746](https://github.com/deepflowio/deepflow/pull/8746) by [askyrie](https://github.com/askyrie)
*  feat: support fanout in mirror mode and analyzer mode [#8730](https://github.com/deepflowio/deepflow/pull/8730) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: deprecated ipvlan [#8724](https://github.com/deepflowio/deepflow/pull/8724) by [askyrie](https://github.com/askyrie)
* feat: gets by page when refreshing recorder cache [#8712](https://github.com/deepflowio/deepflow/pull/8712) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* feat: agent - eBPF Optimize data push logic (#8653) [#8683](https://github.com/deepflowio/deepflow/pull/8683) by [yinjiping](https://github.com/yinjiping)
* feat: register esxi vtap support cloudtower [#8611](https://github.com/deepflowio/deepflow/pull/8611) by [askyrie](https://github.com/askyrie)
* feat: the role field adds the values local and rest [#8465](https://github.com/deepflowio/deepflow/pull/8465) by [lzf575](https://github.com/lzf575)
* feat: single-endpoints db support storing packet where the tap_side i… [#8463](https://github.com/deepflowio/deepflow/pull/8463) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: agent - eBPF Adapt to 4.19.90-2211.5.0.0178.22.uel20.x86_64 [#8460](https://github.com/deepflowio/deepflow/pull/8460) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Support Kylin OS v10 SP2 [#8431](https://github.com/deepflowio/deepflow/pull/8431) by [yinjiping](https://github.com/yinjiping)
* feat: querier add query cache config [#8405](https://github.com/deepflowio/deepflow/pull/8405) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat: modify the epc of multicast address [#8337](https://github.com/deepflowio/deepflow/pull/8337) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: sort prometheus export tags [#8329](https://github.com/deepflowio/deepflow/pull/8329) by [lzf575](https://github.com/lzf575)
* feat: add ci to check dynamic libs [#8325](https://github.com/deepflowio/deepflow/pull/8325) by [jiumos](https://github.com/jiumos)
* feat: agent - eBPF Profile support RT kernel [#8323](https://github.com/deepflowio/deepflow/pull/8323) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Support RT kernel [#8301](https://github.com/deepflowio/deepflow/pull/8301) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Adjust log output for get_process_starttime_and_comm [#8294](https://github.com/deepflowio/deepflow/pull/8294) by [yinjiping](https://github.com/yinjiping)
* feat: exist function supports non-resource tags [#8256](https://github.com/deepflowio/deepflow/pull/8256) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat: agent - eBPF Adapt 5.10.204-rt100-AD1000-PROTO [#8245](https://github.com/deepflowio/deepflow/pull/8245) by [yinjiping](https://github.com/yinjiping)
* feat: querier uniq function supports multi params [#8229](https://github.com/deepflowio/deepflow/pull/8229) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat: the application log table uses app_service as the primary key [#8221](https://github.com/deepflowio/deepflow/pull/8221) by [lzf575](https://github.com/lzf575)
* feat: default genesis sync vpc name [#8133](https://github.com/deepflowio/deepflow/pull/8133) by [askyrie](https://github.com/askyrie)
* feat: querier support simple sql [#8121](https://github.com/deepflowio/deepflow/pull/8121) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat: agent - eBPF Optimize interface 'java_syms_update_main' [#8103](https://github.com/deepflowio/deepflow/pull/8103) by [yinjiping](https://github.com/yinjiping)
* feat: Change opengauss api group [#8099](https://github.com/deepflowio/deepflow/pull/8099) by [rvql](https://github.com/rvql)
* feat: improves performance of recorder synchronization when there are a large number of process data [#8086](https://github.com/deepflowio/deepflow/pull/8086) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* feat: support multi target port [#8032](https://github.com/deepflowio/deepflow/pull/8032) by [askyrie](https://github.com/askyrie)
* feat: trace tree support store PseudoLink field [#7952](https://github.com/deepflowio/deepflow/pull/7952) by [lzf575](https://github.com/lzf575)
* feat: add enable features to agent group [#7945](https://github.com/deepflowio/deepflow/pull/7945) by [roryye](https://github.com/roryye)
* feat: agent - eBPF Add support for parsing 4.19.90-vhulk2211.3.0.h154 [#7928](https://github.com/deepflowio/deepflow/pull/7928) by [yinjiping](https://github.com/yinjiping)
* feat: add pseudo link field for treenode [#7916](https://github.com/deepflowio/deepflow/pull/7916) by [taloric](https://github.com/taloric)
* feat: agent - eBPF Optimize eBPF socket trace (#7871) [#7913](https://github.com/deepflowio/deepflow/pull/7913) by [yinjiping](https://github.com/yinjiping)
* feat: when only exporting a single kafka data, use the 'sendMessage' interface [#7884](https://github.com/deepflowio/deepflow/pull/7884) by [lzf575](https://github.com/lzf575)
* feat: update domain daily trigger [#7848](https://github.com/deepflowio/deepflow/pull/7848) by [askyrie](https://github.com/askyrie)
* feat: support update time of org list [#7867](https://github.com/deepflowio/deepflow/pull/7867) by [lzf575](https://github.com/lzf575)
* feat: optimize org data check and sync [#7866](https://github.com/deepflowio/deepflow/pull/7866) by [SongZhen0704](https://github.com/SongZhen0704)
* feat: adds detail error record when calling ingester org deletion [#7865](https://github.com/deepflowio/deepflow/pull/7865) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* feat: add api for allocate org id [#7862](https://github.com/deepflowio/deepflow/pull/7862) by [SongZhen0704](https://github.com/SongZhen0704)
* feat: add trace query delta for tracemap [#7847](https://github.com/deepflowio/deepflow/pull/7847) by [taloric](https://github.com/taloric)
* feat: supports clear soft deleted orgs [#7827](https://github.com/deepflowio/deepflow/pull/7827) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* feat: Using libpcap without restarting when the network card does not… [#7781](https://github.com/deepflowio/deepflow/pull/7781) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: agent license func operate [#7771](https://github.com/deepflowio/deepflow/pull/7771) by [roryye](https://github.com/roryye)
* feat: increase billing function control capabilities [#7770](https://github.com/deepflowio/deepflow/pull/7770) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* feat: use dynamic library libpcap instead of libelf static library [#7769](https://github.com/deepflowio/deepflow/pull/7769) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: shortens the interval of checking deleted_org [#7764](https://github.com/deepflowio/deepflow/pull/7764) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* feat: OTel’s HTTP protocol parsing optimization [#7758](https://github.com/deepflowio/deepflow/pull/7758) by [lzf575](https://github.com/lzf575)
* feat: Support k8s opengauss cluster [#7751](https://github.com/deepflowio/deepflow/pull/7751) by [rvql](https://github.com/rvql)
* feat: support opengauss svc [#7744](https://github.com/deepflowio/deepflow/pull/7744) by [askyrie](https://github.com/askyrie)
* Revert "feat: agent - eBPF Modify the version number of the Java agent [#7741](https://github.com/deepflowio/deepflow/pull/7741) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Modify the version number of the Java agent [#7732](https://github.com/deepflowio/deepflow/pull/7732) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Java agent uses caching to reduce send frequency [#7726](https://github.com/deepflowio/deepflow/pull/7726) by [yinjiping](https://github.com/yinjiping)
* feat: supports non-real-time deletion of ck of deleted orgs [#7725](https://github.com/deepflowio/deepflow/pull/7725) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* feat: kubernetes support OpenGaussCluster [#7721](https://github.com/deepflowio/deepflow/pull/7721) by [askyrie](https://github.com/askyrie)
* feat: agent - eBPF Adjust method for checking if agent is running [#7717](https://github.com/deepflowio/deepflow/pull/7717) by [yinjiping](https://github.com/yinjiping)
* feat: agent - flow&app log collected by lo nic do not report ctrl_mac [#7713](https://github.com/deepflowio/deepflow/pull/7713) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: agent - eBPF Improve aggregation efficiency of stack-trace string  [#7663](https://github.com/deepflowio/deepflow/pull/7663) by [yinjiping](https://github.com/yinjiping)
* feat: add request type from Kafka trace map [#7642](https://github.com/deepflowio/deepflow/pull/7642) by [lzf575](https://github.com/lzf575)
* feat: server - Add configuration items to server [#7630](https://github.com/deepflowio/deepflow/pull/7630) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: update trace_tree struct [#7604](https://github.com/deepflowio/deepflow/pull/7604) by [taloric](https://github.com/taloric)
* feat: agent - eBPF Add delay threshold check for push period [#7598](https://github.com/deepflowio/deepflow/pull/7598) by [yinjiping](https://github.com/yinjiping)
* feat: agent - eBPF Add kernel dependency check [#7596](https://github.com/deepflowio/deepflow/pull/7596) by [yinjiping](https://github.com/yinjiping)
*  feat: add cloud common for h3c [#7551](https://github.com/deepflowio/deepflow/pull/7551) by [askyrie](https://github.com/askyrie)
* feat: agent - support parallel protocols [#7585](https://github.com/deepflowio/deepflow/pull/7585) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: add agent cmd timeout to config [#7548](https://github.com/deepflowio/deepflow/pull/7548) by [roryye](https://github.com/roryye)
* feat: Tagrecorder support update team_id [#7544](https://github.com/deepflowio/deepflow/pull/7544) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat: sub domain support update team [#7537](https://github.com/deepflowio/deepflow/pull/7537) by [askyrie](https://github.com/askyrie)
* feat: agent - support server port [#7518](https://github.com/deepflowio/deepflow/pull/7518) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: agent adds the CommandParam fields, modifies the param validation method [#7516](https://github.com/deepflowio/deepflow/pull/7516) by [TomatoMr](https://github.com/TomatoMr)
* feat: agent - eBPF Persist Java symbol table [#7325](https://github.com/deepflowio/deepflow/pull/7325) by [yinjiping](https://github.com/yinjiping)
* feat: prevents dirty data from increasing MySQL IO [#7499](https://github.com/deepflowio/deepflow/pull/7499) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* feat: Server exporters support tag-filter-condition config (#7492) [#7493](https://github.com/deepflowio/deepflow/pull/7493) by [ZhuoZhuoCrayon](https://github.com/ZhuoZhuoCrayon)
* feat: agent - eBPF Remove tracing for HEAD type requests in NGINX [#7489](https://github.com/deepflowio/deepflow/pull/7489) by [yinjiping](https://github.com/yinjiping)
* feat: Querier support no limit [#7479](https://github.com/deepflowio/deepflow/pull/7479) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat:  Ingester support trace_tree [#7443](https://github.com/deepflowio/deepflow/pull/7443) by [lzf575](https://github.com/lzf575)
* feat: agent - dispatcher support set cpu affinity [#7423](https://github.com/deepflowio/deepflow/pull/7423) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: create sub domian set default team id [#7421](https://github.com/deepflowio/deepflow/pull/7421) by [askyrie](https://github.com/askyrie)
* feat: sub domain support filter user id [#7408](https://github.com/deepflowio/deepflow/pull/7408) by [askyrie](https://github.com/askyrie)
* feat: sub domain support team [#7394](https://github.com/deepflowio/deepflow/pull/7394) by [askyrie](https://github.com/askyrie)
* feat: server uses sub_domain team id first when publishing message to tagrecorder [#7384](https://github.com/deepflowio/deepflow/pull/7384) by [ZhengYa-0110](https://github.com/ZhengYa-0110)
* feat: Allow overriding remote exec cmdline with async function [#7385](https://github.com/deepflowio/deepflow/pull/7385) by [rvql](https://github.com/rvql)
* feat: agent - add inner queue to mirror dispatcher [#7345](https://github.com/deepflowio/deepflow/pull/7345) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: Agent remote exec returns specific errors [#7334](https://github.com/deepflowio/deepflow/pull/7334) by [roryye](https://github.com/roryye)
* feat: Add command for java stack/heap dump [#7319](https://github.com/deepflowio/deepflow/pull/7319) by [rvql](https://github.com/rvql)
* feat: agent - eBPF Whitelist implementation reassembly [#7309](https://github.com/deepflowio/deepflow/pull/7309) by [yinjiping](https://github.com/yinjiping)
* feat: agent - support vhost user [#7269](https://github.com/deepflowio/deepflow/pull/7269) by [yuanchaoa](https://github.com/yuanchaoa)
* feat: add debug ctl to rebalance agent by traffic [#7261](https://github.com/deepflowio/deepflow/pull/7261) by [roryye](https://github.com/roryye)
* feat: agent - eBPF Add JAVA symbol file generation log [#7257](https://github.com/deepflowio/deepflow/pull/7257) by [yinjiping](https://github.com/yinjiping)
* feat: Add volcengine icon const [#7232](https://github.com/deepflowio/deepflow/pull/7232) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat: add volcengine icon const [#7180](https://github.com/deepflowio/deepflow/pull/7180) by [askyrie](https://github.com/askyrie)
* feat: Dictionary adds auto-close connection [#7165](https://github.com/deepflowio/deepflow/pull/7165) by [xiaochaoren1](https://github.com/xiaochaoren1)
* feat: deepflow-ctl ingester support debugging by org id [#7163](https://github.com/deepflowio/deepflow/pull/7163) by [lzf575](https://github.com/lzf575)
* feat: add volcengine cloud platform for server controller [#7149](https://github.com/deepflowio/deepflow/pull/7149) by [askyrie](https://github.com/askyrie)
* feat: agent support setting PACKET_FANOUT [#7138](https://github.com/deepflowio/deepflow/pull/7138) by [TomatoMr](https://github.com/TomatoMr)
* feat: CK’s username and password support the use of special characters [#7120](https://github.com/deepflowio/deepflow/pull/7120) by [lzf575](https://github.com/lzf575)
* feat: server - add ebpf event type mem alloc/inuse [#7106](https://github.com/deepflowio/deepflow/pull/7106) by [rvql](https://github.com/rvql)
* feat: add change log [#7095](https://github.com/deepflowio/deepflow/pull/7095) by [Nick-0314](https://github.com/Nick-0314)

#### Refactoring
* refactor: add logs [#8780](https://github.com/deepflowio/deepflow/pull/8780) by [yuanchaoa](https://github.com/yuanchaoa)
* refactor: agent adds the 'disabled-cgroups' configuration. [#8165](https://github.com/deepflowio/deepflow/pull/8165) by [TomatoMr](https://github.com/TomatoMr)
* refactor: agent adds a disable_cgroups option [#8159](https://github.com/deepflowio/deepflow/pull/8159) by [TomatoMr](https://github.com/TomatoMr)
* refactor: agent remove prometheus api sync [#7577](https://github.com/deepflowio/deepflow/pull/7577) by [TomatoMr](https://github.com/TomatoMr)
* refactor: Change crate name [#7158](https://github.com/deepflowio/deepflow/pull/7158) by [rvql](https://github.com/rvql)

#### Documentation
* docs: rename opentemetry to opentelemetry [#7246](https://github.com/deepflowio/deepflow/pull/7246) by [lzf575](https://github.com/lzf575)


#### Chore
* chore: bump golang.org/x/net to v0.27.0 [#7306](https://github.com/deepflowio/deepflow/pull/7306) by [zhangzujian](https://github.com/zhangzujian)
* chore: update cli dependencies [#7250](https://github.com/deepflowio/deepflow/pull/7250) by [lzf575](https://github.com/lzf575)

#### OTHER
* [Controller] get data error from mysql and return directly [#8043](https://github.com/deepflowio/deepflow/pull/8043) by [jin-xiaofeng](https://github.com/jin-xiaofeng)
* Cp 66 lo to v65 [#7716](https://github.com/deepflowio/deepflow/pull/7716) by [lzf575](https://github.com/lzf575)
* support consistent timestamp in l7metrics [#7626](https://github.com/deepflowio/deepflow/pull/7626) by [yuanchaoa](https://github.com/yuanchaoa)
* V65 trace map [#7445](https://github.com/deepflowio/deepflow/pull/7445) by [taloric](https://github.com/taloric)
* bump golang.org/x/net to v0.26.0 [#7234](https://github.com/deepflowio/deepflow/pull/7234) by [zhangzujian](https://github.com/zhangzujian)

#### Performance
* perf: modify materialized view local table without group by [#8574](https://github.com/deepflowio/deepflow/pull/8574) by [lzf575](https://github.com/lzf575)
* perf: improve the performance of json string escape [#8509](https://github.com/deepflowio/deepflow/pull/8509) by [lzf575](https://github.com/lzf575)
* perf: reduce ckwriter memory [#8423](https://github.com/deepflowio/deepflow/pull/8423) by [lzf575](https://github.com/lzf575)
* perf: add setting ttl_only_drop_parts to the CK table to make TTL more efficient [#7266](https://github.com/deepflowio/deepflow/pull/7266) by [lzf575](https://github.com/lzf575)

#### Testing
* chore: use the latest go version to build server/cli [#7235](https://github.com/deepflowio/deepflow/pull/7235) by [zhangzujian](https://github.com/zhangzujian)
