/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

mod brpc;
mod dubbo;
mod sofa_rpc;
mod tars;

pub use brpc::{BrpcInfo, BrpcLog};
pub use dubbo::{DubboInfo, DubboLog};
pub use sofa_rpc::{
    decode_new_rpc_trace_context_with_type, SofaRpcInfo, SofaRpcLog, SOFA_NEW_RPC_TRACE_CTX_KEY,
};
pub use tars::{TarsInfo, TarsLog};

cfg_if::cfg_if! {
    if #[cfg(feature = "enterprise")] {
        mod some_ip;
        mod iso8583;
        pub use some_ip::{SomeIpInfo, SomeIpLog};
        pub use iso8583::{Iso8583Info, Iso8583Log};
    }
}
