local lastTimer = 0;
local lastScan = 0;
local DLLPath = lfs.writedir() .. 'Scripts\\Hooks\\'
package.cpath = package.cpath .. ';' .. DLLPath .. '?.dll;'

log.write('OH6GunnerExport', log.INFO, 'LoadDLL')
local gunnerExport = require('OH6GunnerDataExport')
log.write('OH6GunnerExport', log.INFO, 'DLL loaded')

local terrain = require('terrain')

local scannedUnits = {}
local scanDistance = 10000

local own_data

local update_rate = 0.02
gunnerExport.setUpdateRate(update_rate)

local t

local now
local canExportData = false

local OH6_GunnerExport = {}

function OH6_GunnerExport.onSimulationStart()
    log.write('OH6GunnerExport', log.INFO, 'Gunner Export init')
end

function OH6_GunnerExport.onSimulationStop()
    log.write('OH6GunnerExport', log.INFO, 'Gunner Export stop')
end

function isHostile(a, b)
    if a == nil or b == nil then
        return false
    end
    if b.CoalitionID == 0 then
        return false
    end
    return a.CoalitionID ~= b.CoalitionID
end

function stationHasWeapon(payload, idx)
    local stations = payload and payload.Stations
    local s = stations and stations[idx]
    return s and s.weapon and s.weapon.level1 and s.weapon.level1 ~= 0
end

function checkCanExportData()
    own_data = Export.LoGetSelfData()
    if own_data ~= nil then
        --net.log(own_data.Name)
        local aircraftType = own_data.Name
        if aircraftType == "OH-6A" then
            local payload = Export.LoGetPayloadInfo()
           if stationHasWeapon(payload, 11) or stationHasWeapon(payload, 12) then
                return true
            end
        elseif aircraftType == "AH-6J" then
            local payload = Export.LoGetPayloadInfo()
           if stationHasWeapon(payload, 4) then
                return true
            end
        elseif aircraftType == "MH-6J" then
            local payload = Export.LoGetPayloadInfo()

            for _, idx in ipairs({4, 9, 10, 11, 12}) do
                if stationHasWeapon(payload, idx) then
                    return true
                end
            end
        end
    end

    return false
end

function send_stuff()
    own_data = Export.LoGetSelfData()
    if canExportData and own_data ~= nil then

        local ox = own_data.Position.x
        local oy = own_data.Position.y
        local oz = own_data.Position.z
        local mmo = {}
        --local mmo = Export.LoGetWorldObjects("units")
        local count = 0
        gunnerExport.start()
        for k, pre_v in pairs(scannedUnits) do
            local v = Export.LoGetObjectById(k)

            if v ~= nil and count < 50 and v.GroupName ~= nil then
                local vx = v.Position.x
                local vy = v.Position.y
                local vz = v.Position.z
                local dx = (ox - vx)
                local dy = (oy - vy)
                local dz = (oz - vz)
                local sqr_dist = dx * dx + dy * dy + dz * dz
                if sqr_dist < 4000000 then
                    --2000*2000 m
                    local los = terrain.isVisible(ox, oy, oz, vx, vy, vz)
                    if los then
                        local tlevel = (v.Type and v.Type.level4) or nil
                        if tlevel then
                            gunnerExport.sendData(k, v.Type.level4, vx, vy, vz)
                            count = count + 1
                        end
                    end
                end
            end
            --mmo[k] = nil
        end
        --mmo = nil
        gunnerExport.finish()
    end

end

function OH6_GunnerExport.updateUnitsList()
    if own_data then
        local playerID = Export.LoGetPlayerPlaneId()
        local player = Export.LoGetObjectById(playerID)
        scannedUnits = {}
        if player then
            local o = Export.LoGetWorldObjects("units")
            for k, v in pairs(o) do
                if k ~= playerID and isHostile(own_data, v) then
                    local dist = ((v.Position.x - player.Position.x) * (v.Position.x - player.Position.x)) + ((v.Position.y - player.Position.y) * (v.Position.y - player.Position.y)) + ((v.Position.z - player.Position.z) * (v.Position.z - player.Position.z))
                    --net.log(dist)
                    if dist < scanDistance * scanDistance then
                        scannedUnits[k] = v
                        --net.log("add")
                    end
                end
            end
        end
    end
    --net.log(table.getn(scannedUnits))
end

function OH6_GunnerExport.onSimulationFrame()
    canExportData = checkCanExportData()
    if canExportData then
        t = Export.LoGetModelTime()
        if t > 5 then
            now = DCS.getRealTime()
            if now >= lastScan + 5.0 then
                --net.log("OH6_Gunner Scan")
                OH6_GunnerExport.updateUnitsList()
                lastScan = now
            end
            if now >= lastTimer + update_rate then
                --net.log("OH6_Gunner Send")
                send_stuff()
                lastTimer = now;
            end
        end
    end
end

DCS.setUserCallbacks(OH6_GunnerExport)

net.log("OH6_Gunner Loaded...")


