local wsType_ah6minigunl = 13600
local wsType_ah6minigunr = 13601 
local dispersion = 0.003
local M80 = {
        category = CAT_SHELLS, name = "AH-6 7.62x51mm M80", user_name = _("AH-6 7.62x51mm M80"),
        model_name      = "tracer_bullet_white",
        mass            = 0.00952, --kg of each bullet
        round_mass      = 0.0254, --kg of entire round
        cartridge_mass  = 0.01588, --kg of shell
        explosive       = 0.000,
        v0              = 856.2,   -- 2809 fps = 856.2 m/s
        Dv0             = dispersion,
        Da0             = 0.0007, -- dispersion amount
        Da1             = 0.0,
        life_time       = 30,
        caliber         = 7.62, --mm
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5,1.27,0.70,0.200,2.30},
        k1              = 2.0e-08,
        tracer_off      = -1,
        tracer_on       = 0.000001,
        smoke_tail_life_time = 0,
        scale_tracer    = 0,
        cartridge       = 0,
        scale_smoke     = 1.0,
        smoke_opacity   = 0.1
}
declare_weapon(M80)


    -- 7.62x51mm NATO M61 Armor Piercing
local M61 = {
        category = CAT_SHELLS, name = "AH-6 7.62x51mm M61", user_name = _("AH-6 7.62x51mm M61"),
        model_name      = "tracer_bullet_white",
        mass            = 0.00975, --kg of each bullet
        round_mass      = 0.0256, --kg of entire round
        cartridge_mass  = 0.01588, --kg of shell
        explosive       = 0.000,
        v0              = 854.6,   -- 2804 fps = 854.6 m/s
        Dv0             = 0.0060,
        Da0             = dispersion, -- dispersion amount
        --Da0             = 0.0022, -- dispersion amount
        Da1             = 0.0,
        life_time       = 30,
        caliber         = 7.62, --mm
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5,1.27,0.70,0.200,2.30},
        k1              = 2.0e-08,
        tracer_off      = -1,
        tracer_on       = 0.00001,
        smoke_tail_life_time = 0,
        scale_tracer    = 0,
        cartridge       = 0,
        scale_smoke     = 1.0,
        smoke_opacity   = 0.1
}
declare_weapon(M61)

    -- 7.62x51mm NATO M62 Tracer
local M62 = {
        category = CAT_SHELLS, name = "AH-6 7.62x51mm M62", user_name = _("AH-6 7.62x51mm M62"),
        model_name      = "tracer_bullet_red",
        mass            = 0.0092, --kg of each bullet
        round_mass      = 0.02508, --kg of entire round
        cartridge_mass  = 0.01588, --kg of shell
        explosive       = 0.000,
        v0              = 856.2,   -- 2809 fps = 856.2 m/s
        Dv0             = 0.0060,
        Da0             = dispersion, -- dispersion amount
        --Da0             = 0.0022, -- dispersion amount
        Da1             = 0.0,
        life_time       = 30,
        caliber         = 7.62, --mm
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5,1.27,0.70,0.200,2.30},
        k1              = 2.0e-08,
        tracer_off      = 1.7,
        tracer_on       = 0.00001,
        smoke_tail_life_time = 1.7,
        scale_tracer    = 1,
        cartridge       = 0,
        scale_smoke     = 1.0,
        smoke_opacity   = 0.1
}
declare_weapon(M62)



local function AH6_M134(side,supply_pos)
    local tbl ={}
    tbl.category = CAT_GUN_MOUNT
    tbl.name      = "AH-6_M134"..side
    tbl.supply      =
    {
        shells = {"AH-6 7.62x51mm M80", "AH-6 7.62x51mm M61", "AH-6 7.62x51mm M62"},
        mixes  = {{1,2,3,2,2,3}},   -- for every 6 shots there will be one M62 (tracer)
        count  = 2000,		-- 2000 rounds
    }
    if tbl.mixes then
       tbl.supply.mixes = tbl.mixes
       tbl.mixes        = nil
    end
    tbl.gun =
    {
        max_burst_length    = 1, -- minimum number of rounds fired per burst
        rates               = {4000},
        recoil_coeff        = 0.07*1.3,
        barrels_count       = 6,
    }
    if tbl.rates then
       tbl.gun.rates        =  tbl.rates
       tbl.rates            = nil
    end
    tbl.ejector_pos             = {-0.818,-0.144,0.022} -- position from muzzle connector pos
    tbl.ejector_dir             = {-1, -6, 0} -- left/right; back/front;?/?
    tbl.supply_position         = supply_pos or {0.0, 0.0, 0.0}
    tbl.aft_gun_mount           = false
    tbl.effective_fire_distance = 1000
    tbl.drop_cartridge          = 205	--drop shell shape/size from  aircraft_gun_mounts.lua
    tbl.muzzle_pos              = tbl.muzzle_pos            or  {0.0,0.0, 0.0}     -- all position from connector {front, up/down, left/right}
    tbl.muzzle_pos_connector    = tbl.muzzle_pos_connector  or  "Gun_Point" -- all position from connector
    tbl.azimuth_initial         = tbl.azimuth_initial       or  0
    tbl.elevation_initial       = tbl.elevation_initial     or  0
    if  tbl.effects == nil then
        tbl.effects = {
            { name = "FireEffect"     , arg = tbl.effect_arg_number or 436 },
        --    { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 16.0},
            { name = "SmokeEffect"},
            { name = "DelayedGatlingTrigger", arg = 521, barrels_n = 6, spin_up_t = 0.2, spin_down_t = 0.2}
		}
    end
    return declare_weapon(tbl)
end



local minigunr = {
    category        = CAT_PODS,
    CLSID           = "{AH6_M134R}",
    attribute       = {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
    wsTypeOfWeapon  = {wsType_Weapon,wsType_Shell,wsType_Shell_A,wsType_ah6minigunr},
    Picture         = "M134.png",
    displayName     = _("M134 Minigun"),
    Weight          = 39+50.72,      --loaded	39kg empty gun + 50.72kg ammo
    Weight_Empty    = 39, 
    Cx_pil          = 0.00015,

	
    kind_of_shipping = 2,   -- SOLID_MUNITION
    
    shape_table_data = 
    {
        {
            name = 'AH-6_M134_Minigun_R',
            file = 'AH-6_M134',
            life = 1,
            fire ={0,1},
            username = 'AH-6_M134_Minigun_R',
            index = WSTYPE_PLACEHOLDER
        }
    },
    Elements        = {
        [1]	= {
            Position	=	{0, 0, 0},
            ShapeName	=	"AH-6_M134",
        }, 
    },
    gun_mounts      = {
        AH6_M134("R", {0.0,0.0,0.0})
    },
}
declare_loadout(minigunr)



local minigunl = {
    category        = CAT_PODS,
    CLSID           = "{AH6_M134L}",
    attribute       = {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
    wsTypeOfWeapon  = {wsType_Weapon,wsType_Shell,wsType_Shell_A,wsType_ah6minigunl},
    Picture         = "M134.png",
    displayName     = _("M134 Minigun"),
    Weight          = 39+50,      --loaded	39kg empty gun + 50.72kg ammo
    Weight_Empty    = 39,      --loaded	39kg empty gun + 50.72kg ammo
    Cx_pil          = 0.00015,

	
    kind_of_shipping = 2,   -- SOLID_MUNITION
    shape_table_data = 
    {
        {
            name = 'AH-6_M134_Minigun_L',
            file = 'AH-6_M134',
            life = 1,
            fire ={0,1},
            username = 'AH-6_M134_Minigun_L',
            index = WSTYPE_PLACEHOLDER
        }
    },
    Elements        = {
        [1]	= {
            Position	=	{0, 0, 0},
            ShapeName	=	"AH-6_M134",
        }, 
    },
    gun_mounts      = {
        AH6_M134("L", {0.0,0.0,0.0})
    },
}
declare_loadout(minigunl)




function AH6_DOOR_GUN(tbl)
    tbl.category = CAT_GUN_MOUNT
    tbl.name      = "AH-6_Door_Gun"
    tbl.supply      =
    {
        shells = {"AH-6 7.62x51mm M80", "AH-6 7.62x51mm M61", "AH-6 7.62x51mm M62"},
        mixes  = {{1,2,3,2,2,3}},   -- for every 6 shots there will be one M62 (tracer)
        count  = 250,		-- 2000 rounds
    }
    if tbl.mixes then
       tbl.supply.mixes = tbl.mixes
       tbl.mixes        = nil
    end
    tbl.gun =
    {
        max_burst_length    = 1, -- minimum number of rounds fired per burst
        rates               = {550},
        recoil_coeff        = 0.91,
    }
    if tbl.rates then
       tbl.gun.rates        =  tbl.rates
       tbl.rates            = nil
    end
    tbl.ejector_pos             = {-0.818,-0.144,0.022} -- position from muzzle connector pos
    tbl.ejector_dir             = {-1, -6, 0} -- left/right; back/front;?/?
    --tbl.supply_position         = tbl.supply_position   or {1.0, 0.0, 0.0}
	tbl.supply_position         = {0.0, 0.0, 0.0}
    tbl.aft_gun_mount           = false
    tbl.effective_fire_distance = 1500
    tbl.drop_cartridge          = 205	--drop shell shape/size from  aircraft_gun_mounts.lua
    tbl.muzzle_pos              = tbl.muzzle_pos            or  {0.0,0.0,0.0}     -- all position from connector
    tbl.muzzle_pos_connector    = tbl.muzzle_pos_connector  or  "Gun_Point" -- all position from connector
    tbl.azimuth_initial         = tbl.azimuth_initial       or  0
    tbl.elevation_initial       = tbl.elevation_initial     or  0
    if  tbl.effects == nil then
        tbl.effects = {{ name = "FireEffect"     , arg = tbl.effect_arg_number or 436 },
                       --{ name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 16.0},
                       { name = "SmokeEffect"},
					   }
    end
    return declare_weapon(tbl)
end


door_l = {
    category        = CAT_PODS,
    CLSID           = "{AH-6_Door}",
    attribute       = {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
    wsTypeOfWeapon  = {wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
    Picture         = "M60.png",
    displayName     = _("Doorgunner"),
    Weight          = 100,      --loaded	39kg empty gun + 50.72kg ammo
    Cx_pil          = 0.00015,
    --Elements        = {{ShapeName = "OH-6_M60_doorgun"}},
	Elements        = {},
    kind_of_shipping = 2,   -- SOLID_MUNITION
    gun_mounts      = {
        AH6_DOOR_GUN({})
    },
    shape_table_data = {
        {
            file = 'AH-6_M4',
            username = 'AH-6_Doorgun_l',
            index = WSTYPE_PLACEHOLDER;
        }
    }
}
declare_loadout(door_l)







local ammo_weight = 0.117

local function HMP400(tbl)

	tbl.category	= CAT_GUN_MOUNT 
	tbl.name		= "AH-6_HMP400"
	tbl.supply		= 
	{
		shells	= {
					"M2_12_7",
					"M2_12_7_T", 
					"M242_25_HE_M792"
				 },
		mixes	= {
					{1},
					{2},
					{3},
				}, 
		count	= 400,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	if tbl.count then 
	   tbl.supply.count =  tbl.count
	   tbl.count	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 1,
		rates 			 = {1025},
		recoil_coeff 	 = 1,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {0.0, 0.0, 0.0}
	tbl.ejector_dir 			= {0,0,0}
	tbl.supply_position  		= tbl.supply_position or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 3000
	tbl.drop_cartridge 			= 0
	tbl.muzzle_pos				= tbl.muzzle_pos or  {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector or  "Point_Gun" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {
			{ name = "FireEffect"     , arg = tbl.effect_arg_number or 436 },
			{ name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
			{ name = "SmokeEffect"}
		}
	end
	return declare_weapon(tbl)
end

declare_loadout(
	{
		category			=  CAT_PODS,
		CLSID				= "{AH-6_FN_HMP400}",
		displayName			= _("FN HMP400 (400rnds)"),
		Picture				=	"l081.png",
		attribute			= {wsType_Weapon, wsType_GContainer, wsType_Cannon_Cont, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon		= {wsType_Weapon, wsType_Shell, wsType_Shell_A, wsTypeVulkan},
		Weight				= 89 + (400 * ammo_weight), -- INCLUDE AMMO FOR FULL WEIGHT
        Weight_Empty        = 89,
		Cx_pil				= 0.001220703125,
		kind_of_shipping	= 2,--SOLID_MUNITION
		gun_mounts			= {
			HMP400(
				{
					mixes					= {{1, 1, 2}},
					muzzle_pos				= {0.0, 0.0, 0.0},
					muzzle_pos_connector	= "Point_Gun",
					azimuth_initial			= 0.0, -- -0.04363323, -- 2.5 degs to the left
					effect_arg_number		= 433,
				}
			)
		},
		shape_table_data =
		{
			{
				name		= "AH-6_HMP400";
				file		= "HMP400";
				life		= 1;
				fire		= {0, 1};
				username	= "AH-6_HMP400";
				index		= WSTYPE_PLACEHOLDER;
			},
		},
		Elements = {
			[1]	= {
				Position	=	{0, 0, 0},
				ShapeName	=	"AH-6_HMP400",
			}, 
		}, -- end of Elements
	
	--m3_browing({muzzle_pos = {2.91,   0.42,  -0.5 }  	, rates = {1249},mixes = {{2,1,1,1,1,1}},effect_arg_number = 434,azimuth_initial = 0,elevation_initial = 0,supply_position = {2, -0.3, -0.4}}), --up
	}
)