--mount_vfs_model_path(current_mod_path.."/Shapes")

dofile("Scripts/Database/wsTypes.lua")
dofile(current_mod_path .. "/Weapons/AH-6_special_gear.lua")
dofile(current_mod_path .. "/Weapons/AH-6_guns.lua")
dofile(current_mod_path .. "/Weapons/AH-6_grenades.lua")


local doors = {
	category	= CAT_PODS,
	CLSID		= "{AH-6_DOORS}",
	attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
	Picture		= "icon_door.png",
	displayName	= _("Doors"),
	Weight_Empty	= 0,
	Weight			= 10, -- 200USG = 757.082 liter * 0.79kg/l fuel weight 
	Cx_pil			= 0.000956902,
	Elements  		= {{ShapeName = ""}}, 
}
declare_loadout(doors)



local gunners = {
	category	= CAT_PODS,
	CLSID		= "{AH-6_Gunners}",
	attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
	Picture		= "seat_icon_backrow.png",
	displayName	= _("4 x Gunners"),
	Weight_Empty	= 0,
	Weight			= 450, 
	Cx_pil			= 0.000956902,
	Elements  		= {{ShapeName = ""}}, 
}
declare_loadout(gunners)


local function fuel_tank_goliath(clsid)
	local data =
	{
		category         = CAT_FUEL_TANKS,
		CLSID            = clsid,
		attribute        = { wsType_Air, wsType_Free_Fall, wsType_FuelTank, WSTYPE_PLACEHOLDER },
		Picture          = "PTB.png",
		displayName      = _("Goliath Aux Fuel Tank"),
		Weight_Empty     = 20,
		Weight           = 20 + 185.65, 
		Cx_pil           = 0,
		shape_table_data =
		{
			{
				name = "AH_AUX_TANK",
				file = "ah6_auxtank",
				life = 1,
				fire = { 0, 1 },
				username = "AH_AUX_TANK",
				index = WSTYPE_PLACEHOLDER,
			},
		},
		Elements         =
		{
			{
				ShapeName = "ah6_auxtank",
			},
		},
	}
	declare_loadout(data)
end

fuel_tank_goliath("{AH6_GOLIATH}")


-- Hellfires


declare_loadout(
{
	category   			= CAT_MISSILES, 
	CLSID    				= "AH6_AGM_114K_R1", 
  attribute  			= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
  wsTypeOfWeapon		= "weapons.missiles.AGM_114K",
	Picture   			= "OH58D_AGM_114.png",  
	displayName  			= "1xAGM-114K",
	Cx_pil				=	0.001,
	Weight     			= 45.18+42.18+3.65+2.04, -- Hellfire K 45.18 kg -- Launcher 42.18 kg -- bras armé 3.65 kg -- cablage 2.04 kg
	Count 				= 1,
    settings 				= Get_LGU_GUISettings_Preset("WGU59"),	  
	Elements  = 
	{
	{
		--Position	=	{0.2689, 0.0, 0.0}, -- marche pas ici ?
		ShapeName	=	"OH58D_HRACK_R",
		IsAdapter   =   true,
	},
	{
		--Position	=	{0.4081,	0.4399,	0.212}, -- ext relatif position pylon
		--Position	=	{fwd/aft,	-up/down,	L/R}, -- ext relatif position pylon
		Position	=	{0.15,	-0.1,	0.165}, -- ext relatif position pylon			--- (0.35,	-0.1,	0.165},
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
	-- {
		-- Position	=	{0.403,	-0.13,	-0.17}, -- int relatif position pylon
		-- ShapeName	=	"OH58D_AGM114K",
		-- Rotation    =   {0.0,0.0,0.0},
	-- },
	},
})

declare_loadout(
 {
  category   			= CAT_MISSILES,
  CLSID    				= "AH6_AGM_114K_R",
  attribute  			= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
  wsTypeOfWeapon		= "weapons.missiles.AGM_114K",
  Picture   			= "OH58D_AGM_114.png",
  displayName  			= "2xAGM-114K",
  Cx_pil				=	0.001,
  Weight     			= (2*45.18)+42.18+3.65+2.04, -- Hellfire K 45.18 kg -- Launcher 42.18 kg -- bras armé 3.65 kg -- cablage 2.04 kg
  Count 				= 2,
  settings 				= Get_LGU_GUISettings_Preset("WGU59"),
  Elements  = 
  {
	{
		--Position	=	{0.2689, 0.0, 0.0}, -- marche pas ici ?
		ShapeName	=	"OH58D_HRACK_R",
		IsAdapter   =   true,
	},
	{
		--Position	=	{fwd/aft,	-up/down,	L/R}, -- ext relatif position pylon				
		--Position	=	{0.4081,	0.4399,	0.212}, -- ext relatif position pylon
		Position	=	{0.15,	-0.1,	0.165}, -- ext relatif position pylon
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
	{
		Position	=	{0.15,	-0.1,	-0.17}, -- int relatif position pylon
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
  },
 }
)

declare_loadout(
 {
  category   			= CAT_MISSILES,
  CLSID    				= "AH6_AGM_114K_L1",
  attribute  			= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
  wsTypeOfWeapon		= "weapons.missiles.AGM_114K",
  Picture   			= "OH58D_AGM_114.png",
  displayName  			= "1xAGM-114K",
  Cx_pil				= 0.001,
  Weight     			= 45.18+42.18+3.65+2.04, -- Hellfire K 45.18 kg -- Launcher 42.18 kg -- bras armé 3.65 kg -- cablage 2.04 kg
  Count 				= 1,
  settings 				= Get_LGU_GUISettings_Preset("WGU59"),     
  Elements  = 
  {
	{
		--Position	=	{0,	0,	0},
		ShapeName	=	"OH58D_HRACK_L",
		IsAdapter   =   true,
	},
	{
		Position	=	{0.15,	-0.1,	-0.165}, -- ext relatif position pylon
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
	-- {
		-- Position	=	{0.403,	-0.13,	0.2}, -- int relatif position pylon
		-- ShapeName	=	"OH58D_AGM114K",
		-- Rotation    =   {0.0,0.0,0.0},
	-- },
  },
 }
)

declare_loadout(
 {
  category   			= CAT_MISSILES,
  CLSID    				= "AH6_AGM_114K_L",   
  attribute  			= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
  wsTypeOfWeapon		= "weapons.missiles.AGM_114K",
  Picture   			= "OH58D_AGM_114.png",
  displayName  			= "2xAGM-114K",
  Cx_pil				=	0.001,
  Weight     			= (2*45.18)+42.18+3.65+2.04, -- Hellfire K 45.18 kg -- Launcher 42.18 kg -- bras armé 3.65 kg -- cablage 2.04 kg
  Count 				= 2,
  settings 				= Get_LGU_GUISettings_Preset("WGU59"), 
  Elements  = 
  {
	{
		--Position	=	{0,	0,	0},
		ShapeName	=	"OH58D_HRACK_L",
		IsAdapter   =   true,
	},
	{
		Position	=	{0.15,	-0.1,	-0.165}, -- ext relatif position pylon
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},
	},
	{
		Position	=	{0.15,	-0.1,	0.17}, -- int relatif position pylon 0.20
		ShapeName	=	"AGM-114K",
		Rotation    =   {0.0,0.0,0.0},   
	},
  },
 }
)




-- local AH6_NETGUN = {
-- 	category			= CAT_ROCKETS,
-- 	name				= "Deer Netgun",
-- 	user_name			= _("AH6_NETGUN"),
-- 	wsTypeOfWeapon		= {wsType_Weapon,wsType_NURS,wsType_Rocket,WSTYPE_PLACEHOLDER},
-- 	scheme 				= "nurs-standard",
-- 	model 				= "dap_net",

--         fm = 
--         {
--             mass        = 7.7,   -- start weight, kg
--             caliber     = 0.07, -- Caliber, meters 
--             cx_coeff    = {0.1,0.1889005,0.067,0.08173064,0.208},  -- Cx
--             L           = 0.927, --Length, meters
--             I           = 0.3913938, -- moment of inertia
--             Ix          = 0.0017991, -- not used
--             Ma          = 0.1316980, -- dependence moment coefficient of  by  AoA
--             Mw          = 1000.1, --  dependence moment coefficient by angular speed
--             shapeName   = "",
            
--             wind_time   = 0.575, -- dispersion coefficient
--             wind_sigma  = 4.8, -- dispersion coefficient
            
--             wing_unfold_time = 0.2, -- Unfold time, sec
--         },

--         engine =
--         {
--             fuel_mass   = 0.01, -- Fuel mass, kg
--             impulse     = 690, -- Specific impulse, m/sec
--             boost_time  = 0, -- Time of booster action
--             work_time   = 0.01, -- Time of mid-flight engine action
--             boost_factor= 1, -- Booster to cruise trust ratio
--             nozzle_position =  {{-0.508, 0, 0}}, -- meters
-- 			nozzle_orientationXYZ =  {{0, 0, 0}},
--             tail_width  = 0.15, -- contrail thickness 
--             boost_tail  = 1,
--             work_tail   = 1,

--             smoke_color = {0.0, 0.0, 0.0},
-- 	    smoke_transparency = 0.00,
--         },

-- 	warhead	=
-- 	{
-- 	mass			= 7.7, --HEI heavy
--     	expl_mass        = 0.0, 
--     	other_factors    = { 1.0, 1.0, 1.0 },
--     	concrete_factors = { 1.0, 1.0, 1.0 },
--     	concrete_obj_factor = 0.0,
--     	obj_factors      = { 1.0, 1.0 },
--     	cumulative_factor= 3.0,
--     	cumulative_thickness = 0.9,

-- 	piercing_mass	= 1.54, --HEI [piercing_mass=warhead.mass, ma se (expl_mass/mass)>0.1 allora piercing_mass=mass/5, quindi 0,44/1.7=0,258  --> 1.7/5=0.34]
-- 	},

-- 	shape_table_data =
-- 	{
-- 		{
-- 			file		 = "dap_net",
-- 			life		 = 1,
-- 			fire		 = {0, 1},
-- 			username = "dap_net",
-- 			index = WSTYPE_PLACEHOLDER,
-- 		},
-- 	},

-- 	properties =
-- 	{
--     		dist_min = 1, -- min range, meters
--     		dist_max = 50,    -- max range, meters
-- 	}
-- }
-- declare_weapon(AH6_NETGUN)

-- declare_loadout(
-- {
-- 	category 		= CAT_ROCKETS,
-- 	CLSID 			= "{AH6_NETGUN}",
-- 	attribute 		= {wsType_Weapon,wsType_NURS,wsType_Container,182}, --182 (lau-3)
-- 	wsTypeOfWeapon	=	AH6_NETGUN.wsTypeOfWeapon,	
-- 	Picture 		= "M2RocketPod.png",
-- 	displayName		= _("Netgun"),
-- 	Weight 			= 5, 
-- 	Count			=	1,
-- 	Cx_pil			=	0.00159912109375,
-- 	kind_of_shipping = 2,
-- 	Elements = {
-- 		{
-- 			ShapeName	=	"dap_netgun", -- pod name
-- 			IsAdapter = true,
-- 		},
-- 		{
-- 			DrawArgs	= defaultArgs,
-- 			connector_name = "TUBE_1",
-- 			ShapeName	=	"dap_net",
-- 		},
-- 	},
-- })