dofile(LockOn_Options.common_script_path.."elements_defs.lua")

SetScale(METERS) 

local font7segment = MakeFont({used_DXUnicodeFontData = "font7segment"},{0,255,0,215}) --(R,G,B,opacity)
local center = {0,0,0}  --- {L/R,U/D,forward/back}

local verts = {}
local dx=.0125
local dy=.0075
verts [1]= {-dx,-dy}
verts [2]= {-dx,dy}
verts [3]= {dx,dy}
verts [4]= {dx,-dy}
	
local base 			 = CreateElement "ceMeshPoly"
base.name 			 = "base"
base.vertices 		 = verts
base.indices 		 = {0,1,2,2,3,0}
base.init_pos		 = center   
base.material		 = MakeMaterial(nil,{3,3,30,255})
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL 
base.level			 = 5
base.isdraw			 = true
base.change_opacity  = false
base.isvisible		 = false
base.element_params  = {"DC_POWER_AVAIL"}  
base.controllers     = {{"parameter_in_range",0,0.9,1.1}} 
Add(base)

local N2rpm           = CreateElement "ceStringPoly"
N2rpm.name            = create_guid_string()
N2rpm.material        = font7segment	
N2rpm.alignment       = "RightCenter"
N2rpm.init_pos		  = {-0.005, 0, 0}
N2rpm.stringdefs      = {0.007,0.75*0.007, 0, 0}  -- {size vertical, horizontal, 0, 0}
N2rpm.formats         = {"%.0f"} 
--N2rpm.element_params  = {"IND_TEMP"}
N2rpm.element_params  = {
	"IND_TEMP",
	"VIDS_BRIGHTNESS"
}
N2rpm.controllers     = {
	{"text_using_parameter",0,0},
	{"opacity_using_parameter",1}
}
N2rpm.h_clip_relation = h_clip_relations.compare
N2rpm.level			  = 6
N2rpm.parent_element  = base.name
Add(N2rpm)

local NRrpm           = CreateElement "ceStringPoly"
NRrpm.name            = create_guid_string()
NRrpm.material        = font7segment	
NRrpm.alignment       = "RightCenter"
NRrpm.init_pos		  = {0.018, 0, 0}
NRrpm.stringdefs      = {0.007,0.75*0.007, 0, 0}  -- {size vertical, horizontal, 0, 0}
NRrpm.formats         = {"%.0f"} 
NRrpm.element_params  = {
	"TORQUE_PSI",
	"VIDS_BRIGHTNESS"
}
NRrpm.controllers     = {
	{"text_using_parameter",0,0},
	{"opacity_using_parameter",1}
}
NRrpm.h_clip_relation = h_clip_relations.compare
NRrpm.level			  = 6
NRrpm.parent_element  = base.name
Add(NRrpm)

local mat_green = MakeMaterial(nil,{0,255,0,215})
local mat_yellow = MakeMaterial(nil,{255,255,0,215})
local mat_red = MakeMaterial(nil,{255,0,0,215})

local segmentsL = {
	[1]= {min = 275,  c = mat_green},
	[2]= {min = 300,  c = mat_green},
	[3]= {min = 325, c = mat_green},
	[4]= {min = 350, c = mat_green},
	[5]= {min = 375, c = mat_green},
	[6]= {min = 400, c = mat_green},
	[7]= {min = 425, c = mat_green},
	[8]= {min = 450, c = mat_green},
	[9]= {min = 475, c = mat_green},
	[10]={min = 500, c = mat_green},
	[11]={min = 525, c = mat_green},
	[12]={min = 550, c = mat_green},
	[13]={min = 575, c = mat_green},
	[14]={min = 600, c = mat_green},
	[15]={min = 625, c = mat_green},
	[16]={min = 650, c = mat_green},
	[17]={min = 675, c = mat_green},
	[18]={min = 694, c = mat_yellow},
	[19]={min = 725, c = mat_yellow},
	[20]={min = 750, c = mat_yellow},
	[21]={min = 775, c = mat_yellow},
	[22]={min = 800, c = mat_yellow},
	[23]={min = 825, c = mat_yellow},
	[24]={min = 850, c = mat_red},
	[25]={min = 875, c = mat_red},
	[26]={min = 905, c = mat_red},
	[27]={min = 925, c = mat_red},
	[28]={min = 950, c = mat_red},
	[29]={min = 975, c = mat_red},
}

local segmentsR = {
	[1]= {min = 1,  c = mat_green},
	[2]= {min = 10, c = mat_green},
	[3]= {min = 20, c = mat_green},
	[4]= {min = 22, c = mat_green},
	[5]= {min = 24, c = mat_green},
	[6]= {min = 26, c = mat_green},
	[7]= {min = 28, c = mat_green},
	[8]= {min = 30, c = mat_green},
	[9]= {min = 32, c = mat_green},
	[10]={min = 34, c = mat_green},
	[11]={min = 36, c = mat_green},
	[12]={min = 38, c = mat_green},
	[13]={min = 40, c = mat_green},
	[14]={min = 42, c = mat_green},
	[15]={min = 44, c = mat_green},
	[16]={min = 46, c = mat_green},
	[17]={min = 48, c = mat_green},
	[18]={min = 50, c = mat_green},
	[19]={min = 52, c = mat_green},
	[20]={min = 54, c = mat_green},
	[21]={min = 56, c = mat_green},
	[22]={min = 58, c = mat_green},
	[23]={min = 60, c = mat_yellow},
	[24]={min = 62, c = mat_yellow},
	[25]={min = 64, c = mat_red},
	[26]={min = 66, c = mat_red},
	[27]={min = 68, c = mat_red},
	[28]={min = 70, c = mat_red},
	[29]={min = 72, c = mat_red},
}
local L = -0.153329 - (-0.226234)
local dz= L/29
local x0 =0.01085
local z0 = -0.07962
local x_size = 0.0015
local y_size = 0.5*dz*0.8

local vertices = {{-x_size,  y_size},
				  { x_size,  y_size},
				  { x_size, -y_size},
				  {-x_size, -y_size}}

local function addSegment(element)
	element.vertices = vertices
	element.indices	   		= {0,1,2,2,3,0}
	element.h_clip_relation = h_clip_relations.REWRITE_LEVEL
	element.level 			= 6
	element.parent_element 	= base.name
	Add(element)
end

for i = 1,#segmentsL,1
do 
	local segmentL		  = CreateElement "ceMeshPoly"
	segmentL.name		  = "segmentL_"..i
	segmentL.init_pos	  = { -x0, z0 + (i-1)*dz, 0.002}
	segmentL.element_params  = {
		"IND_TEMP",
		"VIDS_BRIGHTNESS"
	}
	segmentL.controllers  = {
		{"parameter_in_range",0, segmentsL[i].min,1100},
		{"opacity_using_parameter",1}
	}
	segmentL.material = segmentsL[i].c
	addSegment(segmentL)
end

for i = 1,#segmentsR,1
do 
	local segmentR		  = CreateElement "ceMeshPoly"
	segmentR.name		  = "segmentR_"..i
	segmentR.init_pos	  = { x0, z0 + (i-1)*dz, 0.002}
	segmentR.element_params  = {
		"TORQUE_PSI",
		"VIDS_BRIGHTNESS"
	}
	segmentR.controllers  = {
		{"parameter_in_range",0, segmentsR[i].min,110},
		{"opacity_using_parameter",1}
	}
	segmentR.material = segmentsR[i].c
	addSegment(segmentR)
end


