dofile(LockOn_Options.script_path.."ConfigurePackage.lua")

function decimalToDMM(decimal)
    local sign = decimal < 0 and -1 or 1
    decimal = math.abs(decimal)

    local deg = math.floor(decimal)
    local min = math.floor((decimal - deg) * 60000 + 0.5)

    return { deg = deg * sign, min = min }
end

function DMMToDecimal(deg, min)
    local sign = deg < 0 and -1 or 1
    deg = math.abs(deg)
    return sign * (deg + min / 60000.0)
end

function change_char_at(str, position, delta)
    local chars = " ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
    local len = #chars
    
    local currentChar = str:sub(position, position)
    local index = chars:find(currentChar, 1, true) -- Position im chars-String
    
    if not index then
        error("Ungültiges Zeichen an der Position: "..currentChar)
    end
    
    -- Berechne neue Position mit Wrap-around
    local newIndex = ((index - 1 + delta) % len) + 1
    
    -- Ersetze das Zeichen
    local newChar = chars:sub(newIndex, newIndex)
    return str:sub(1, position-1) .. newChar .. str:sub(position+1)
end

function change_latlon(number, pos, delta)
    local dms = decimalToDMM(number)
    local deg = dms.deg
    local min = dms.min
  
    -- Stellenmanipulation
    if pos == 1 then deg = deg + 10 * delta end
    if pos == 2 then deg = deg + 1 * delta end
    if pos == 3 then min = min + 10000 * delta end
    if pos == 4 then min = min + 1000 * delta end
    if pos == 5 then min = min + 100 * delta end
    if pos == 6 then min = min + 10 * delta end
    if pos == 7 then min = min + 1 * delta end

    -- Grenzen
    if min < 0 then min = 0 end
    if min > 59999 then min = 59999 end

    return DMMToDecimal(deg, min)
end
