dofile(LockOn_Options.script_path .. "command_defs.lua")

local dev = GetSelf()
local update_time_step = 0.1


dev:listen_command(device_commands.lights_radio)

dev:listen_command(Keys.LandingLight)
dev:listen_command(Keys.lights_vids_inc)
dev:listen_command(Keys.lights_vids_dec)
dev:listen_command(Keys.lights_rdralt_inc)
dev:listen_command(Keys.lights_rdralt_dec)
dev:listen_command(Keys.lights_dhi_inc)
dev:listen_command(Keys.lights_dhi_dec)
dev:listen_command(Keys.lights_fqi_inc)
dev:listen_command(Keys.lights_fqi_dec)
dev:listen_command(Keys.lights_radio_inc)
dev:listen_command(Keys.lights_radio_dec)
dev:listen_command(Keys.lights_ams_dim_inc)
dev:listen_command(Keys.lights_ams_dim_dec)
dev:listen_command(Keys.lights_panels_dim_inc)
dev:listen_command(Keys.lights_panels_dim_dec)
dev:listen_command(Keys.strobe_top)
dev:listen_command(Keys.strobe_both)
dev:listen_command(Keys.strobe_topboth_toggle)
dev:listen_command(Keys.strobe_mode_on)
dev:listen_command(Keys.strobe_mode_off)
dev:listen_command(Keys.strobe_mode_toggle)
dev:listen_command(Keys.pos_light_on)
dev:listen_command(Keys.pos_light_off)
dev:listen_command(Keys.pos_light_toggle)
dev:listen_command(Keys.pos_light_dim_inc)
dev:listen_command(Keys.pos_light_dim_dec)

--local mid_panel_lights = get_param_handle("Mid_Panel_Lights")

local vids_brightness_handle = get_param_handle("VIDS_BRIGHTNESS")
local rdralt_brightness_handle = get_param_handle("RDRALT_BRIGHTNESS")
local dhi_brightness_handle = get_param_handle("DHI_BRIGHTNESS")
local fqi_brightness_handle = get_param_handle("FQI_BRIGHTNESS")

local radio_lights_handle = get_param_handle("RADIO_LIGHTS")
local mid_panel_lights_handle = get_param_handle("MIDPANEL_LIGHTS")

local flight_instrument_lights_handle = get_param_handle("FLIGHT_INSTRUMENT_LIGHTS")
local instrument_lights_handle =  get_param_handle("INSTRUMENT_LIGHTS")

local ams_lights_handle = get_param_handle("AMS_LIGHTS")

local dc_elec = get_param_handle("DC_POWER_AVAIL")
local LIGHTS_CURRENT = get_param_handle("LIGHTS_CURRENT")

--local mid_panel_lights_value = 0.0
local both_strobes = 1.0
local taxi_light = 0.0
local pos_light_dim = 1.0
local pos_light_enabled = 0.0
local acol_light = 0.0
local current = 0.0
local dc_ok = 0

local radios_brightness = 0.0
local vids_brightness = 0.5
local rdralt_brightness = 0.5
local dhi_brightness = 0.5
local fqi_brightness = 0.5
local panels_brightness = 0.5
local ams_brightness = 0.5


local dev = GetSelf()

local acol_timer = 0.0

local function update_lights()
    dc_ok = dc_elec:get()
    current = 0.0

    
    vids_brightness_handle:set(vids_brightness * dc_ok)
    rdralt_brightness_handle:set(rdralt_brightness * dc_ok)
    dhi_brightness_handle:set(dhi_brightness * dc_ok)
    fqi_brightness_handle:set(fqi_brightness * dc_ok)
    
    radio_lights_handle:set(radios_brightness * dc_ok)
    mid_panel_lights_handle:set(radios_brightness * dc_ok)
    
    flight_instrument_lights_handle:set(panels_brightness * dc_ok)
    instrument_lights_handle:set(panels_brightness * dc_ok)

    ams_lights_handle:set(ams_brightness * dc_ok)

    
    
    current = current + taxi_light * dc_ok * 2
    current = current + pos_light_enabled * pos_light_dim * dc_ok * 2
    current = current + acol_light * dc_ok * 2

    set_aircraft_draw_argument_value(115, taxi_light * dc_ok)

    set_aircraft_draw_argument_value(122, pos_light_enabled * pos_light_dim * dc_ok)

    acol_timer = acol_timer + update_time_step
    if acol_timer > 1.0 then
        acol_timer = 0.0
    end
    local acol_on = 0.0
    if acol_timer < 0.1 then
        acol_on = 1.0
    end
    local acol2_on = 0.0
    if acol_timer < 0.6 and acol_timer >= 0.5 then
        acol2_on = 1.0
    end
    set_aircraft_draw_argument_value(123, acol_on * acol_light * dc_ok)
    set_aircraft_draw_argument_value(124, both_strobes * acol2_on * acol_light * dc_ok)
end

make_default_activity(update_time_step)

function post_initialize()
    local abstime = get_absolute_model_time()
    local hours = abstime / 3600.0

    local birth = LockOn_Options.init_conditions.birth_place
    if birth == "GROUND_HOT" or birth == "AIR_HOT" then
        local light_enable = false
        if hours <= 6 or hours >= 17 then
            light_enable = true
            taxi_light = 1.0
        end
        --mid_panel_lights_value = 0.5 * light_enable


        if light_enable then
            dev:performClickableAction(device_commands.MPS_StrobeMode, 0.0, true)
            dev:performClickableAction(device_commands.MPS_PosLightMode, 0.0, true)
        else
            dev:performClickableAction(device_commands.MPS_StrobeMode, 0.5, true)
            dev:performClickableAction(device_commands.MPS_PosLightMode, 0.5, true)
        end
        radios_brightness = 0.5
    elseif birth == "GROUND_COLD" then
        --mid_panel_lights_value = 0.0
        dev:performClickableAction(device_commands.MPS_StrobeMode, 0.5, true)
        dev:performClickableAction(device_commands.MPS_PosLightMode, 0.5, true)
    end
    dev:performClickableAction(device_commands.lights_radio, radios_brightness, true)
    dev:performClickableAction(device_commands.lights_rdralt, rdralt_brightness, true)
    dev:performClickableAction(device_commands.lights_vids_dim, vids_brightness, true)
    dev:performClickableAction(device_commands.lights_dhi, dhi_brightness, true)
    dev:performClickableAction(device_commands.lights_fqi, fqi_brightness, true)
    dev:performClickableAction(device_commands.MPS_PosLightDim, 1.0, true)
    update_lights()
end

function SetCommand(command, value)

    if command == Keys.acol_light_off then
        dev:performClickableAction(device_commands.MPS_StrobeMode, 0.5, true)
    end
    if command == Keys.acol_light_on then
        dev:performClickableAction(device_commands.MPS_StrobeMode, 0.0, true)
    end


    if command == Keys.LandingLight then
        if taxi_light < 0.5 then
            taxi_light = 1.0
        else
            taxi_light = 0.0
        end
    end

    if command == Keys.lights_vids_inc then 
        vids_brightness = vids_brightness+0.0015
        if vids_brightness > 1.0 then vids_brightness = 1.0 end
        dev:performClickableAction(device_commands.lights_vids_dim, vids_brightness, true)
    end
    if command == Keys.lights_vids_dec then 
        vids_brightness = vids_brightness-0.0015
        if vids_brightness < 0.0 then vids_brightness = 0.0 end
        dev:performClickableAction(device_commands.lights_vids_dim,vids_brightness, true)
    end
    if command == device_commands.lights_vids_dim then
        vids_brightness = value
    end

    if command == Keys.lights_rdralt_inc then 
        rdralt_brightness = rdralt_brightness+0.0015
        if rdralt_brightness > 1.0 then rdralt_brightness = 1.0 end
        dev:performClickableAction(device_commands.lights_rdralt, rdralt_brightness, true)
    end
    if command == Keys.lights_rdralt_dec then 
        rdralt_brightness = rdralt_brightness-0.0015
        if rdralt_brightness < 0.0 then rdralt_brightness = 0.0 end
        dev:performClickableAction(device_commands.lights_rdralt, rdralt_brightness, true)
    end
    if command == device_commands.lights_rdralt then
        rdralt_brightness = value
    end

    if command == Keys.lights_dhi_inc then 
        dhi_brightness = dhi_brightness+0.0015
        if dhi_brightness > 1.0 then dhi_brightness = 1.0 end
        dev:performClickableAction(device_commands.lights_dhi, dhi_brightness, true)
    end
    if command == Keys.lights_dhi_dec then 
        dhi_brightness = dhi_brightness-0.0015
        if dhi_brightness < 0.0 then dhi_brightness = 0.0 end
        dev:performClickableAction(device_commands.lights_dhi, dhi_brightness, true)
    end
    if command == device_commands.lights_dhi then
        dhi_brightness = value
    end

    if command == Keys.lights_fqi_inc then 
        fqi_brightness = fqi_brightness+0.0015
        if fqi_brightness > 1.0 then fqi_brightness = 1.0 end
        dev:performClickableAction(device_commands.lights_fqi, fqi_brightness, true)
    end
    if command == Keys.lights_fqi_dec then 
        fqi_brightness = fqi_brightness-0.0015
        if fqi_brightness < 0.0 then fqi_brightness = 0.0 end
        dev:performClickableAction(device_commands.lights_fqi, fqi_brightness, true)
    end
    if command == device_commands.lights_fqi then
        fqi_brightness = value
    end


    if command == Keys.lights_radio_inc then
        radios_brightness = radios_brightness+0.0015
        if radios_brightness > 1.0 then radios_brightness = 1.0 end
        dev:performClickableAction(device_commands.lights_radio, radios_brightness, true)
    end
    if command == Keys.lights_radio_dec then
        radios_brightness = radios_brightness-0.0015
        if radios_brightness < 0.0 then radios_brightness = 0.0 end
        dev:performClickableAction(device_commands.lights_radio, radios_brightness, true)
    end
    if command == device_commands.lights_radio then
        radios_brightness = value
    end

    if command == Keys.lights_ams_dim_inc then 
        ams_brightness = ams_brightness+0.0015
        if ams_brightness > 1.0 then ams_brightness =1.0 end
        dev:performClickableAction(device_commands.MPS_AMSDim, ams_brightness, true)
    end
    if command == Keys.lights_ams_dim_dec then 
        ams_brightness = ams_brightness-0.0015
        if ams_brightness < 0.0 then ams_brightness = 0.0 end
        dev:performClickableAction(device_commands.MPS_AMSDim, ams_brightness, true)
    end
    if command == device_commands.MPS_AMSDim then
        --print_message_to_user('MPS_AMSDim : ' .. value, 5)
        ams_brightness =value
    end

    if command == Keys.lights_panels_dim_inc then 
        panels_brightness = panels_brightness+0.0015
        if panels_brightness > 1.0 then panels_brightness =1.0 end
        dev:performClickableAction(device_commands.MPS_PanelsDim,panels_brightness, true)
    end
    if command == Keys.lights_panels_dim_dec then 
        panels_brightness = panels_brightness-0.0015
        if panels_brightness < 0.0 then panels_brightness = 0.0 end
        dev:performClickableAction(device_commands.MPS_PanelsDim,panels_brightness, true)
    end
    if command == device_commands.MPS_PanelsDim then
        panels_brightness =value
        --print_message_to_user('MPS_PanelsDim : ' .. value, 5)
    end

    if command == Keys.strobe_top then
        dev:performClickableAction(device_commands.MPS_StrobeTopBoth,1, true)
    end
    if command == Keys.strobe_both then
        dev:performClickableAction(device_commands.MPS_StrobeTopBoth,0, true)
    end
    if command == Keys.strobe_topboth_toggle then
        if both_strobes >0.5 then 
            dev:performClickableAction(device_commands.MPS_StrobeTopBoth,1, true)
        else
            dev:performClickableAction(device_commands.MPS_StrobeTopBoth,0, true)
        end
    end
    if command == device_commands.MPS_StrobeTopBoth then
        both_strobes = 1 - value
    end

    if command == Keys.strobe_mode_on then
        dev:performClickableAction(device_commands.MPS_StrobeMode,0, true)
    end
    if command == Keys.strobe_mode_off then
        dev:performClickableAction(device_commands.MPS_StrobeMode,0.5, true)
    end
    if command == Keys.strobe_mode_toggle then
        if acol_light < 0.3 then 
            dev:performClickableAction(device_commands.MPS_StrobeMode,0, true)
        else
            dev:performClickableAction(device_commands.MPS_StrobeMode,0.5, true)
        end
    end
    if command == device_commands.MPS_StrobeMode then
        if value < 0.3 then
            acol_light = 1.0
        else
            acol_light = 0.0
        end
    end

    if command == Keys.pos_light_on then
        dev:performClickableAction(device_commands.MPS_PosLightMode,0, true)
    end
    if command == Keys.pos_light_off then
        dev:performClickableAction(device_commands.MPS_PosLightMode,0.5, true)
    end
    if command == Keys.pos_light_toggle then
        if pos_light_enabled < 0.3 then 
            dev:performClickableAction(device_commands.MPS_PosLightMode,0, true)
        else
            dev:performClickableAction(device_commands.MPS_PosLightMode,0.5, true)
        end
    end
    if command == device_commands.MPS_PosLightMode then
        if value < 0.3 then
            pos_light_enabled = 1.0
        else
            pos_light_enabled = 0.0
        end
    end

    if command == Keys.pos_light_dim_inc then 
        pos_light_dim = pos_light_dim +0.25 
        if pos_light_dim >1.0 then pos_light_dim = 1.0 end
        dev:performClickableAction(device_commands.MPS_PosLightDim,pos_light_dim,true)
    end
    if command == Keys.pos_light_dim_dec then 
        pos_light_dim = pos_light_dim -0.25 
        if pos_light_dim <0.0 then pos_light_dim = 0.0 end
        dev:performClickableAction(device_commands.MPS_PosLightDim,pos_light_dim,true)
    end
    if command == device_commands.MPS_PosLightDim then
        pos_light_dim = value
    end
end

function update()
    update_lights()
    LIGHTS_CURRENT:set(current)
end

need_to_be_closed = false -- close lua state after initialization
