dofile(LockOn_Options.script_path .. "command_defs.lua")
dofile(LockOn_Options.script_path .. "devices.lua")


local dc_ok = false
local ac_ok = false
local gen_enabled = false
local att_ind_enabled = false
local start_pump_enabled = false
local inverter_enabled = false
local radio_master_enable = false
local pitot_heating_enable = false
local anti_ice_enable = false
local scavair_enable = false
local current = 0.0

local flash_time = 0.0
local flash_interval = 0.25
local warning_test_pressed = false


local dev = GetSelf()
local update_time_step = 0.05
make_default_activity(update_time_step)

dev:listen_command(device_commands.electricsystem_batt)
dev:listen_command(device_commands.electricsystem_inverter)
dev:listen_command(device_commands.electricsystem_gen)
dev:listen_command(device_commands.electricsystem_start_pump)
dev:listen_command(device_commands.electricsystem_att_ind)
dev:listen_command(device_commands.electricsystem_scavair)


dev:listen_command(Keys.BattSwitchBatt)
dev:listen_command(Keys.BattSwitchOff)
dev:listen_command(Keys.BattSwitchExt)
dev:listen_command(Keys.gen_on)
dev:listen_command(Keys.gen_off)
dev:listen_command(Keys.gen_toggle)
dev:listen_command(Keys.inverter_on)
dev:listen_command(Keys.inverter_off)
dev:listen_command(Keys.inverter_toggle)

dev:listen_command(Keys.att_ind_on)
dev:listen_command(Keys.att_ind_off)
dev:listen_command(Keys.att_ind_toggle)
dev:listen_command(Keys.start_pump_on)
dev:listen_command(Keys.start_pump_off)
dev:listen_command(Keys.start_pump_toggle)
dev:listen_command(Keys.scavair_on)
dev:listen_command(Keys.scavair_off)
dev:listen_command(Keys.scavair_toggle)
dev:listen_command(Keys.pitot_on)
dev:listen_command(Keys.pitot_off)
dev:listen_command(Keys.pitot_toggle)
dev:listen_command(Keys.masterradio_on)
dev:listen_command(Keys.masterradio_off)
dev:listen_command(Keys.masterradio_toggle)
dev:listen_command(Keys.antiice_on)
dev:listen_command(Keys.antiice_off)
dev:listen_command(Keys.antiice_toggle)

local dc_elec           = get_param_handle("DC_POWER_AVAIL")
local ac_elec           = get_param_handle("AC_POWER_AVAIL")
local radio_power       = get_param_handle("RADIO_POWER_AVAIL")
local pitot_power       = get_param_handle("PITOT_HEATING_POWER")
local anti_ice_power    = get_param_handle("ANTI_ICE_POWER")

local BATTERY_VOLTAGE   = get_param_handle("BATTERY_VOLTAGE")
local GENERATOR_VOLTAGE = get_param_handle("GENERATOR_VOLTAGE")
local INVERTER_VOLTAGE  = get_param_handle("INVERTER_VOLTAGE")

local att_ind_on        = get_param_handle("POWER_ATT_IND")

local IND_DCAMPS        = get_param_handle("IND_DCAMPS")
local STARTER_CURRENT   = get_param_handle("STARTER_CURRENT")
local LIGHTS_CURRENT    = get_param_handle("LIGHTS_CURRENT")
local WEAPONS_CURRENT   = get_param_handle("WEAPONS_CURRENT")


local WARNING_ENGINE_OUT  = get_param_handle("Warning_Engine_Out")
local WARNING_OIL_PRESS   = get_param_handle("Warning_Oil_Press")
local WARNING_OIL_TEMP    = get_param_handle("Warning_Oil_Temp")
local WARNING_BATT_160    = get_param_handle("Warning_Batt_Temp_160")
local WARNING_BATT_140    = get_param_handle("Warning_Batt_Temp_140")
local WARNING_GEN_OUT     = get_param_handle("Warning_Generator_Out")

local WARNING_ENG_CHIPS   = get_param_handle("Warning_Eng_Chips")
local WARNING_MR_CHIPS    = get_param_handle("Warning_MR_Chips")
local WARNING_TR_CHIPS    = get_param_handle("Warning_TR_Chips")

local WARNING_FUEL_FILTER = get_param_handle("Warning_Fuel_Filter")
local WARNING_AIR_FILTER  = get_param_handle("Warning_Air_Filter")
local WARNING_IFF         = get_param_handle("Warning_IFF")
local WARNING_RE_IGN      = get_param_handle("Warning_Re_ign")

local WARNING_TEST_PRESSED      = get_param_handle("WARNING_TEST_PRESSED")

local MR_CHIPS = get_param_handle("MR_CHIPS")


local N2       = get_param_handle("RPM_N2")
local N1       = get_param_handle("RPM_N1")
local THROTTLE = get_param_handle("THROTTLE")

function post_initialize()
	sndhost = create_sound_host("COCKPIT_ELEC", "HEADPHONES", -1.0, 1.0, 0)
	warning_sound = sndhost:create_sound("Cockpit/engine_warning")
	--warning_sound = sndhost:create_sound("Cockpit/prep_red")


	local birth = LockOn_Options.init_conditions.birth_place
	if birth == "GROUND_HOT" or birth == "AIR_HOT" then
		dev:performClickableAction(device_commands.electricsystem_batt, 1.0, true)
		dev:performClickableAction(device_commands.electricsystem_inverter, 1.0, true)
		dev:performClickableAction(device_commands.electricsystem_gen, 1.0, true)
		dev:performClickableAction(device_commands.electricsystem_start_pump, -1.0, true)
		dev:performClickableAction(device_commands.electricsystem_att_ind, 1.0, true)
		dev:performClickableAction(device_commands.engine_reignition, 1.0, true)
		dev:performClickableAction(device_commands.electricsystem_master_radio, 1.0, true)

		dispatch_action(nil, EFM_commands.electricsystem_batt, 1.0)
		dispatch_action(nil, EFM_commands.electricsystem_inverter, 1.0)
		dispatch_action(nil, EFM_commands.electricsystem_gen, 1.0)
		dispatch_action(nil, EFM_commands.electricsystem_start_pump, -1.0)

		inverter_enabled = true
		att_ind_enabled = true
		pitot_heating_enable = false
		anti_ice_enable = false
		gen_enabled = true
		scavair_enable = true
		start_pump_enabled = true
	elseif birth == "GROUND_COLD" then
		dev:performClickableAction(device_commands.electricsystem_batt, 0.5, true)
		dev:performClickableAction(device_commands.electricsystem_inverter, 0.0, true)
		dev:performClickableAction(device_commands.electricsystem_gen, 0.0, true)
		dev:performClickableAction(device_commands.electricsystem_start_pump, 0.0, true)
		dev:performClickableAction(device_commands.electricsystem_att_ind, 0.0, true)
		dev:performClickableAction(device_commands.engine_reignition, 0.0, true)
		dev:performClickableAction(device_commands.electricsystem_master_radio, 0.0, true)

		dispatch_action(nil, EFM_commands.electricsystem_batt, 0.5)
		dispatch_action(nil, EFM_commands.electricsystem_inverter, 0.0)
		dispatch_action(nil, EFM_commands.electricsystem_gen, 0.0)
		dispatch_action(nil, EFM_commands.electricsystem_start_pump, 0.0)

		inverter_enabled = false
		att_ind_enabled = false
		gen_enabled = false
		pitot_heating_enable = false
		anti_ice_enable = false
		scavair_enable = false
		start_pump_enabled = false
	end
end

function SetCommand(command, value)
	if command == device_commands.electricsystem_batt then
		dispatch_action(nil, EFM_commands.electricsystem_batt, value)
	end

	if command == Keys.BattSwitchBatt then
		dev:performClickableAction(device_commands.electricsystem_batt, 1.0, true)
	end
	if command == Keys.BattSwitchOff then
		dev:performClickableAction(device_commands.electricsystem_batt, 0.5, true)
	end
	if command == Keys.BattSwitchExt then
		dev:performClickableAction(device_commands.electricsystem_batt, 0.0, true)
	end

	if command == device_commands.electricsystem_inverter then
		dispatch_action(nil, EFM_commands.electricsystem_inverter, value)
		if value > 0.5 then
			inverter_enabled = true
		else
			inverter_enabled = false
		end
	end
	if command == Keys.inverter_on then
		dev:performClickableAction(device_commands.electricsystem_inverter, 1.0, true)
	end
	if command == Keys.inverter_off then
		dev:performClickableAction(device_commands.electricsystem_inverter, 0.0, true)
	end
	if command == Keys.inverter_toggle then
		if inverter_enabled then
			dev:performClickableAction(device_commands.electricsystem_inverter, 0.0, true)
		else
			dev:performClickableAction(device_commands.electricsystem_inverter, 1.0, true)
		end
	end

	if command == Keys.gen_on then
		dev:performClickableAction(device_commands.electricsystem_gen, 1.0, true)
	end

	if command == Keys.gen_off then
		dev:performClickableAction(device_commands.electricsystem_gen, 0.0, true)
	end

	if command == Keys.gen_toggle then
		if gen_enabled then
			dev:performClickableAction(device_commands.electricsystem_gen, 0.0, true)
		else
			dev:performClickableAction(device_commands.electricsystem_gen, 1.0, true)
		end
	end
	if command == device_commands.electricsystem_gen then
		if value > 0.5 then
			gen_enabled = true
		else
			gen_enabled = false
		end
		dispatch_action(nil, EFM_commands.electricsystem_gen, value)
	end


	if command == Keys.start_pump_on then
		dev:performClickableAction(device_commands.electricsystem_start_pump, 1.0, true)
	end
	if command == Keys.start_pump_off then
		dev:performClickableAction(device_commands.electricsystem_start_pump, 0.0, true)
	end
	if command == Keys.start_pump_toggle then
		if start_pump_enabled then
			dev:performClickableAction(device_commands.electricsystem_start_pump, 0.0, true)
		else
			dev:performClickableAction(device_commands.electricsystem_start_pump, 1.0, true)
		end
	end
	if command == device_commands.electricsystem_start_pump then
		start_pump_enabled = value > 0.5
		dispatch_action(nil, EFM_commands.electricsystem_start_pump, value)
	end




	if command == Keys.pitot_on then
		dev:performClickableAction(device_commands.electricsystem_pitot, 1.0, true)
	end
	if command == Keys.pitot_off then
		dev:performClickableAction(device_commands.electricsystem_pitot, 0.0, true)
	end
	if command == Keys.pitot_toggle then
		if pitot_heating_enable then
			dev:performClickableAction(device_commands.electricsystem_pitot, 0.0, true)
		else
			dev:performClickableAction(device_commands.electricsystem_pitot, 1.0, true)
		end
	end
	if command == device_commands.electricsystem_pitot then
		if value < 0.5 then
			pitot_heating_enable = false
			dispatch_action(nil, EFM_commands.pitot_heating, 0)
		else
			pitot_heating_enable = true
			dispatch_action(nil, EFM_commands.pitot_heating, 1)
		end
	end
	if command == device_commands.electricsystem_anti_ice then
		if value < 0.5 then
			anti_ice_enable = false
		else
			anti_ice_enable = true
		end
	end


	if command == Keys.att_ind_on then
		dev:performClickableAction(device_commands.electricsystem_att_ind, 1.0, true)
	end
	if command == Keys.att_ind_off then
		dev:performClickableAction(device_commands.electricsystem_att_ind, 0.0, true)
	end
	if command == Keys.att_ind_toggle then
		if att_ind_enabled then
			dev:performClickableAction(device_commands.electricsystem_att_ind, 0.0, true)
		else
			dev:performClickableAction(device_commands.electricsystem_att_ind, 1.0, true)
		end
	end
	if command == device_commands.electricsystem_att_ind then
		att_ind_enabled = value > 0.5
	end


	if command == Keys.masterradio_on then
		dev:performClickableAction(device_commands.electricsystem_master_radio, 1.0, true)
	end
	if command == Keys.masterradio_off then
		dev:performClickableAction(device_commands.electricsystem_master_radio, 0.0, true)
	end
	if command == Keys.masterradio_toggle then
		if radio_master_enable then
			dev:performClickableAction(device_commands.electricsystem_master_radio, 0.0, true)
		else
			dev:performClickableAction(device_commands.electricsystem_master_radio, 1.0, true)
		end
	end
	if command == device_commands.electricsystem_master_radio then
		if value < 0.5 then
			radio_master_enable = false
		else
			radio_master_enable = true
		end
	end

	if command == Keys.scavair_on then
		dev:performClickableAction(device_commands.electricsystem_scavair, 1.0, true)
	end
	if command == Keys.scavair_off then
		dev:performClickableAction(device_commands.electricsystem_scavair, 0.0, true)
	end
	if command == Keys.scavair_toggle then
		if scavair_enable then
			dev:performClickableAction(device_commands.electricsystem_scavair, 0.0, true)
		else
			dev:performClickableAction(device_commands.electricsystem_scavair, 1.0, true)
		end
	end
	if command == device_commands.electricsystem_scavair then
		if value < 0.5 then
			scavair_enable = false
		else
			scavair_enable = true
		end
	end


	if command == Keys.antiice_on then
		dev:performClickableAction(device_commands.electricsystem_anti_ice, 1.0, true)
	end
	if command == Keys.antiice_off then
		dev:performClickableAction(device_commands.electricsystem_anti_ice, 0.0, true)
	end
	if command == Keys.antiice_toggle then
		if anti_ice_enable then
			dev:performClickableAction(device_commands.electricsystem_anti_ice, 0.0, true)
		else
			dev:performClickableAction(device_commands.electricsystem_anti_ice, 1.0, true)
		end
	end
	if command == device_commands.electricsystem_anti_ice then
		anti_ice_enable = value > 0.5
	end

	if command == device_commands.warning_lights_test then
		warning_test_pressed = value > 0.5
		WARNING_TEST_PRESSED:set(value)
	end
end

local function gen_ok()
	if GENERATOR_VOLTAGE:get() > BATTERY_VOLTAGE:get() then
		return true
	else
		return false
	end
end

local function update_generator()
	if not gen_ok() then
		if dc_ok then
			if not warning_test_pressed then
				WARNING_GEN_OUT:set(1.0)
			end
		else
			if not warning_test_pressed then
				WARNING_GEN_OUT:set(0.0)
			end
		end
	else
		if not warning_test_pressed then
			WARNING_GEN_OUT:set(0.0)
		end
	end
end

local function update_engine_warning()
	flash_time = flash_time + update_time_step
	if flash_time > 2 * flash_interval then
		flash_time = 0.0
	end

	--print_message_to_user(THROTTLE:get())
	local test = false
	if dc_ok then
		if N1:get() * 1.2 < 0.55 then
			if flash_time > flash_interval then
				if not warning_test_pressed then 
					WARNING_ENGINE_OUT:set(1.0)
					WARNING_OIL_PRESS:set(0.0)
				end
			else
				if not warning_test_pressed then 
					WARNING_ENGINE_OUT:set(0.0)
					WARNING_OIL_PRESS:set(1.0)
				end
			end
			if gen_enabled then
				warning_sound:play_continue()
			else
				warning_sound:stop()
			end
		else
			if N2:get() < 0.95 and gen_enabled and THROTTLE:get() > 0.95 then
				if not warning_test_pressed then 
					WARNING_ENGINE_OUT:set(1.0)
				end
				warning_sound:play_continue()
			else
				if not warning_test_pressed then 
					WARNING_ENGINE_OUT:set(0.0)
				end
				warning_sound:stop()
			end
			if not warning_test_pressed then 
				WARNING_OIL_PRESS:set(0.0)
			end
		end

		if MR_CHIPS:get()>0.5 then 
			WARNING_MR_CHIPS:set(1)
		else
			if not warning_test_pressed then 
				WARNING_MR_CHIPS:set(0)
			end
		end
	else
		warning_sound:stop()
		if not warning_test_pressed then 
			WARNING_ENGINE_OUT:set(0.0)
			WARNING_OIL_PRESS:set(0.0)
		end
	end
end

local function update_warning_test()
	if warning_test_pressed then
		WARNING_ENGINE_OUT:set(1)
		WARNING_OIL_PRESS:set(1)
		WARNING_OIL_TEMP:set(1)
		WARNING_BATT_160:set(1)
		WARNING_BATT_140:set(1)
		WARNING_GEN_OUT:set(1)
		WARNING_ENG_CHIPS:set(1)
		WARNING_MR_CHIPS:set(1)
		WARNING_TR_CHIPS:set(1)
		WARNING_FUEL_FILTER:set(1)
		WARNING_AIR_FILTER:set(1)
		WARNING_IFF:set(1)
		WARNING_RE_IGN:set(1)
	else
		--WARNING_ENGINE_OUT:set(1)
		--WARNING_OIL_PRESS:set(1)
		WARNING_OIL_TEMP:set(0)
		WARNING_BATT_160:set(0)
		WARNING_BATT_140:set(0)
		--WARNING_GEN_OUT:set(0)
		WARNING_ENG_CHIPS:set(0)
		--WARNING_MR_CHIPS:set(0)
		WARNING_TR_CHIPS:set(0)
		WARNING_FUEL_FILTER:set(0)
		WARNING_AIR_FILTER:set(0)
		WARNING_IFF:set(0)
		WARNING_RE_IGN:set(0)
	end
end

function update()
	dc_ok = dc_elec:get() > 0.5
	ac_ok = ac_elec:get() > 0.5
	local base_current = 0.0

	if dc_ok then
		base_current = base_current + 15.0
		if radio_master_enable then
			radio_power:set(1)
		else
			radio_power:set(0)
		end

		if pitot_heating_enable then
			pitot_power:set(1)
		else
			pitot_power:set(0)
		end

		if anti_ice_enable then
			anti_ice_power:set(1)
		else
			anti_ice_power:set(0)
		end
	else
		pitot_power:set(0)
		anti_ice_power:set(0)
		radio_power:set(0)
	end

	if ac_ok and att_ind_enabled then
		att_ind_on:set(1.0)
		base_current = base_current + 10.0
	else
		att_ind_on:set(0.0)
	end
	update_generator()
	update_engine_warning()
	current = base_current + STARTER_CURRENT:get() + LIGHTS_CURRENT:get() + WEAPONS_CURRENT:get()
	IND_DCAMPS:set(current)
	update_warning_test()
	dev:DC_Battery_on(dc_ok)
    dev:AC_Generator_1_on(ac_ok)
end

need_to_be_closed = false -- close lua state after initialization
