dofile(LockOn_Options.common_script_path.."elements_defs.lua")

SetScale(METERS) 

local avionics_otf = {class = "ceUITTF", ttf = LockOn_Options.script_path.."Ressources/hp-simplified-hans-regular.ttf", size = 40}
FONT  = MakeFont(avionics_otf, {30,255,255,215})

local fontDotMatrix = MakeFont({used_DXUnicodeFontData = "fontDotMatrix"},{0,255,0,255}) --(R,G,B,opacity)
local center = {0,0,0}  --- {L/R,U/D,forward/back}


local pos_low_x = -0.019162
local pos_low_y = 0.014332

local low_text           = CreateElement "ceStringPoly"
low_text.name            = create_guid_string()
low_text.material        = FONT
low_text.init_pos        = {pos_low_x,pos_low_y,0.0}		
low_text.alignment       = "CenterCenter"
low_text.stringdefs      = {0.0045,0.0055, 0, 0}  -- {size vertical, horizontal, 0, 0}
low_text.value = "LO"
low_text.element_params  = {
    "RAD_ALT_LOW_STAT",
    "RDRALT_BRIGHTNESS"
}
low_text.controllers    = {
    {"parameter_in_range",0,0.5,1.1},
    {"opacity_using_parameter",1}
}
Add(low_text)


local pos_high_x =-0.013736
local pos_high_y = 0.031146

local high_text           = CreateElement "ceStringPoly"
high_text.name            = create_guid_string()
high_text.material        = FONT
high_text.init_pos        = {pos_high_x,pos_high_y,0.0}		
high_text.alignment       = "CenterCenter"
high_text.stringdefs      = {0.0045,0.0055, 0, 0}  -- {size vertical, horizontal, 0, 0}
high_text.value = "HI"
high_text.element_params  = {
    "RAD_ALT_HIGH_STAT",
    "RDRALT_BRIGHTNESS"
}
high_text.controllers    = {
	{"parameter_in_range",0,0.5,1.1},
    {"opacity_using_parameter",1}
}
Add(high_text)


local verts = {}
local dx=.025
local dy=.006
verts [1]= {-dx,-dy}
verts [2]= {-dx,dy}
verts [3]= {dx,dy}
verts [4]= {dx,-dy}
	
local base 			 = CreateElement "ceMeshPoly"
base.name 			 = "base"
base.vertices 		 = verts
base.indices 		 = {0,1,2,2,3,0}
base.init_pos		 = center   
base.material		 = MakeMaterial(nil,{3,3,3,255})
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL 
base.level			 = 5
base.isdraw			 = true
base.change_opacity  = false
base.isvisible		 = false
base.element_params  = {"DC_POWER_AVAIL"}  
base.controllers     = {
    {"parameter_in_range",0,0.9,1.1}
    } 
Add(base)

local Ralt_xxxN           = CreateElement "ceStringPoly"
Ralt_xxxN.name            = create_guid_string()
Ralt_xxxN.material        = fontDotMatrix	
Ralt_xxxN.parent_element  = "base"
Ralt_xxxN.alignment       = "CenterCenter"
Ralt_xxxN.stringdefs      = {0.008,0.75*0.0075, 0.00405, 0}  -- {size vertical, size horizontal, horizontal spacing, 0}
Ralt_xxxN.formats         = {"%4.0f"} 
Ralt_xxxN.element_params  = {
    "CURRENT_RALT",
    "RALT_OFF",
    "RDRALT_BRIGHTNESS"
}
Ralt_xxxN.controllers     = {
    {"text_using_parameter",0,0},
    {"parameter_in_range",1,-0.1,0.9},
    {"opacity_using_parameter",2}
}
Ralt_xxxN.h_clip_relation = h_clip_relations.compare
Ralt_xxxN.level			  = 6
Add(Ralt_xxxN)