

local OrderedList = {}
OrderedList.__index = OrderedList

function OrderedList.new()
    return setmetatable({
        items = {},   -- key → value
        order = {},   -- array of keys
        cursor = 1    -- current index in `order`
    }, OrderedList)
end

-- Add an item with a fixed ID
function OrderedList:add(id, value)
    if self.items[id] == nil then
        table.insert(self.order, id)
    end
    self.items[id] = value
end

-- Remove current item
function OrderedList:remove()
    local id = self.order[self.cursor]
    if not id then return nil end

    self.items[id] = nil
    table.remove(self.order, self.cursor)

    -- Cursor anpassen, falls wir hinter dem Ende gelandet sind
    if self.cursor > #self.order then
        self.cursor = #self.order
    end

    return id
end

-- Get current item
function OrderedList:get()
    local id = self.order[self.cursor]
    if not id then return nil end
    return self.items[id], id
end

function OrderedList:set(value)
    local id = self.order[self.cursor]
    if not id then return nil end
    self.items[id] = value
end

-- Move to next item
function OrderedList:next()
    if self.cursor < #self.order then
        self.cursor = self.cursor + 1
    else
        self.cursor = 1
    end
    return self:get()
end

-- Move to previous item
function OrderedList:prev()
    if self.cursor > 1 then
        self.cursor = self.cursor - 1
    else
        self.cursor = #self.order
    end
    return self:get()
end


function OrderedList:getById(id)
    return self.items[id]
end

-- Direktes Element per Reihenfolge-Index
function OrderedList:getByIndex(i)
    local id = self.order[i]
    if not id then return nil end
    return self.items[id], id
end

-- Cursor auf bestimmte ID setzen
function OrderedList:jumpTo(id)
    for i, key in ipairs(self.order) do
        if key == id then
            self.cursor = i
            return true
        end
    end
    return false
end

function OrderedList:N()
    return #self.order
end

function OrderedList:sort(compare)
    local id = self.order[self.cursor]
    table.sort(self.order, function(a, b)
        return compare(self.items[a], self.items[b], a, b)
    end)

    for i, key in ipairs(self.order) do
        if key == id then
            self.cursor = i
        end
    end
end

function OrderedList:goToFirst()
    self.cursor = 1
end

function OrderedList:has(id)
    return self.items[id] ~= nil
end

return OrderedList