dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."Argus7000/Argus7000_device.lua")
dofile(LockOn_Options.script_path.."TNL3100/TNL3100_device.lua")
dofile(LockOn_Options.script_path.."Nav/nav_data.lua")

--local Terrain = require('terrain')

local dev = GetSelf()
local sensor_data = get_base_data()
local update_time_step = 0.05 
make_default_activity(update_time_step)



dev:listen_command(Keys.argus_arr)
dev:listen_command(Keys.argus_enr)
dev:listen_command(Keys.argus_dep)
dev:listen_command(Keys.argus_aux)
dev:listen_command(Keys.argus_power)
dev:listen_command(Keys.argus_dim_inc)
dev:listen_command(Keys.argus_dim_dec)
dev:listen_command(device_commands.argus_enr)

dev:listen_command(device_commands.TNL3100_PWR)
dev:listen_command(device_commands.TNL3100_NAV)
dev:listen_command(device_commands.TNL3100_WPT)
dev:listen_command(device_commands.TNL3100_APT_VOR)
dev:listen_command(device_commands.TNL3100_D)
dev:listen_command(device_commands.TNL3100_FPL)
dev:listen_command(device_commands.TNL3100_CALC)
dev:listen_command(device_commands.TNL3100_AUX)
dev:listen_command(device_commands.TNL3100_MSG)
dev:listen_command(device_commands.TNL3100_ENT)
dev:listen_command(device_commands.TNL3100_INNER)
dev:listen_command(device_commands.TNL3100_OUTER)


dev:listen_command(Keys.tnl3100_pwr)
dev:listen_command(Keys.tnl3100_nav)
dev:listen_command(Keys.tnl3100_wpt)
dev:listen_command(Keys.tnl3100_apt_vor)
dev:listen_command(Keys.tnl3100_D)
dev:listen_command(Keys.tnl3100_fpl)
dev:listen_command(Keys.tnl3100_calc)
dev:listen_command(Keys.tnl3100_aux)
dev:listen_command(Keys.tnl3100_msg)
dev:listen_command(Keys.tnl3100_ent)
dev:listen_command(Keys.tnl3100_inner_inc)
dev:listen_command(Keys.tnl3100_inner_dec)
dev:listen_command(Keys.tnl3100_outer_inc)
dev:listen_command(Keys.tnl3100_outer_dec)

function post_initialize()
	local dev = GetSelf()
    local birth = LockOn_Options.init_conditions.birth_place
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then 			  
		
    elseif birth=="GROUND_COLD" then
		
    end
    argus_post_initialize(dev)
    tnl3100_post_initialize()
    local x, y, z = sensor_data.getSelfCoordinates()
    sortAirportsByDistance({x=x,y=z})
    getAirports():goToFirst()
end


function SetCommand(command,value)
    argus_SetCommand(command,value)
    tnl3100_SetCommand(command,value)
end


function update()
    
    local x, y, z = sensor_data.getSelfCoordinates()
    
    sortAirportsByDistance({x=x,y=z})
    argus_update_airports(getAirports())
    set_waypoints(
        get_state():get_draw_waypoints(),
        get_state():get_actual_waypoint()
    )
    set_nav_data(
        get_state():get_eta(),
        get_state():get_crosstrack_distance(),
        get_state():get_distance()
    )
    tnl3100_update(getAirports())
    argus_update()
end

need_to_be_closed = false 