dofile(LockOn_Options.script_path.."command_defs.lua")

local dev = GetSelf()
local sensor_data = get_base_data()
local update_time_step = 0.05  
make_default_activity(update_time_step)

dev:listen_command(device_commands.avionic_baroAltPressure)
dev:listen_command(device_commands.radarAltLow)
dev:listen_command(device_commands.radarAltHigh)

dev:listen_command(Keys.inc_baroalt_pressure)
dev:listen_command(Keys.dec_baroalt_pressure)
dev:listen_command(Keys.inc_radaralt_low)
dev:listen_command(Keys.dec_radaralt_low)
dev:listen_command(Keys.inc_radaralt_high)
dev:listen_command(Keys.dec_radaralt_high)


local meterspersecond_to_knots =1.94384

local radian_to_degree = 57.2957795
local meters_to_feet = 3.2808399
local hg_to_hpa = 33.8638867

local ALT_PRESSURE_MAX = 30.99 -- in Hg
local ALT_PRESSURE_MIN = 29.10 -- in Hg
local ALT_PRESSURE_STD = 29.92 -- in Hg

local adi_bank = get_param_handle("ADI_BANK") 
local adi_pitch = get_param_handle("ADI_PITCH") 
local adi_slip = get_param_handle("ADI_SLIP") 


local ias_pilot = get_param_handle("IND_IAS") 
local climb = get_param_handle("IND_CLIMB")



local alt_adj_Nxxx = get_param_handle("altadjNxxx")
local alt_adj_xNxx = get_param_handle("altadjxNxx")
local alt_adj_xxNx = get_param_handle("altadjxxNx")
local alt_adj_xxxN = get_param_handle("altadjxxxN")

local alt_adj_hp_Nxxx = get_param_handle("altadjhpNxxx")
local alt_adj_hp_xNxx = get_param_handle("altadjhpxNxx")
local alt_adj_hp_xxNx = get_param_handle("altadjhpxxNx")
local alt_adj_hp_xxxN = get_param_handle("altadjhpxxxN")

local alt_ind = get_param_handle("altind") 

local alt_Nxx = get_param_handle("altNxx") 
local alt_xNx = get_param_handle("altxNx") 
local alt_xxN = get_param_handle("altxxN") 

local alt_off = get_param_handle("ALTITUDE_OFF")
local att_off = get_param_handle("ATTITUDE_OFF")

local current_Ralt = get_param_handle("CURRENT_RALT")
local radaraltind = get_param_handle("radaraltind") 
local Ralt_Off = get_param_handle("RALT_OFF")

local radaraltlow = get_param_handle("RAD_ALT_LOW")
local radaralthigh = get_param_handle("RAD_ALT_HIGH")
local RADAR_ALT_OFF = get_param_handle("RADAR_ALT_OFF")

local RAD_ALT_LOW_STAT = get_param_handle("RAD_ALT_LOW_STAT")
local RAD_ALT_HIGH_STAT = get_param_handle("RAD_ALT_HIGH_STAT")


local ac_elec = get_param_handle("AC_POWER_AVAIL")
local dc_elec = get_param_handle("DC_POWER_AVAIL")
local att_ind_on = get_param_handle("POWER_ATT_IND")
local current_hdg = get_param_handle("CURRENT_HDG")

local alt_setting =ALT_PRESSURE_STD

local ac_ok = false
local dc_ok = false
local att_ind_ok = false

local roll = 0.0
local pitch = 0.0
local slip = 0.0
local alt=0

local radar_alt_low = 0
local radar_alt_high = 1000

ias_pilot:set(0.0)


function post_initialize()
	alt_setting = ALT_PRESSURE_STD
	local dev = GetSelf()
    local birth = LockOn_Options.init_conditions.birth_place	
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then 			  
        		
    elseif birth=="GROUND_COLD" then
        		
    end
end

--dev:listen_command(device_commands.AltimeterSet)
function SetCommand(command,value)
	if command == Keys.inc_baroalt_pressure then 
		dev:performClickableAction(device_commands.avionic_baroAltPressure, 0.0015, true)
	end
	if command == Keys.dec_baroalt_pressure then 
		dev:performClickableAction(device_commands.avionic_baroAltPressure, -0.0015, true)
	end
    if command == device_commands.avionic_baroAltPressure then
		alt_setting = alt_setting + value*0.5
		if alt_setting > ALT_PRESSURE_MAX then
			alt_setting = ALT_PRESSURE_MAX
		elseif alt_setting < ALT_PRESSURE_MIN then
			alt_setting = ALT_PRESSURE_MIN
		end
	end

	if command == Keys.inc_radaralt_low then 
		dev:performClickableAction(device_commands.radarAltLow, 0.0015, true)
	end
	if command == Keys.dec_radaralt_low then 
		dev:performClickableAction(device_commands.radarAltLow, -0.0015, true)
	end
	if command == device_commands.radarAltLow then
		local factor = 200
		if radar_alt_low > 200 then factor = factor*6.5 end
		radar_alt_low = radar_alt_low+ value*factor
		if radar_alt_low < -10 then radar_alt_low = -10 end
		if radar_alt_low > 1500 then radar_alt_low = 1500 end
	end

	if command == Keys.inc_radaralt_high then 
		dev:performClickableAction(device_commands.radarAltHigh, 0.0015, true)
	end
	if command == Keys.dec_radaralt_high then 
		dev:performClickableAction(device_commands.radarAltHigh, -0.0015, true)
	end
	if command == device_commands.radarAltHigh then 
		local factor = 200
		if radar_alt_high > 200 then factor = factor*6.5 end
		radar_alt_high = radar_alt_high+ value*factor
		if radar_alt_high < 0 then radar_alt_high = 0 end
		if radar_alt_high > 1500 then radar_alt_high = 1500 end
	end
end


local function update_slip()
	local ay = sensor_data.getVerticalAcceleration()
	local ax = sensor_data.getHorizontalAcceleration() 
	local az = sensor_data.getLateralAcceleration() 
	--print_message_to_user(math.sqrt(ax*ax+ay*ay+az*az))
	local slip_acc = az/math.sqrt(ax*ax+ay*ay+az*az)
	local update_fac = 0.1
	slip = (1-update_fac)*slip + update_fac * slip_acc
	adi_slip:set(2*math.pi*slip)
end

local function update_climb()
	local v_speed = sensor_data.getVerticalVelocity()* meters_to_feet/1000*60
	--print_message_to_user(v_speed)
	
	if dc_ok then 
		v=v_speed
		if v > 6.0 then 
			v=6.0
		end
		if v < -6.0 then 
			v=-6.0
		end
	end
	
	climb:set(v)
end

local function update_adi()
	if att_ind_ok then
		roll = sensor_data.getRoll()
		pitch = sensor_data.getPitch()
		att_off:set(1.0)
	else
		att_off:set(0.0)
	end
	
	adi_bank:set(roll)
	adi_pitch:set(0.5*pitch)
end

local function update_radar_altitude()
	if dc_ok then 
		local pitch = (sensor_data.getPitch()*radian_to_degree)
		local roll = (sensor_data.getRoll()*radian_to_degree)
		local on = true
		if (pitch > 35 or pitch < -35) or (roll > 45 or roll < -45) then 
			on = false 
		end
		local height = sensor_data.getRadarAltitude()*meters_to_feet-0
		if height > radar_alt_high then 
			RAD_ALT_HIGH_STAT:set(1)
		else
			RAD_ALT_HIGH_STAT:set(0)
		end
		if height < radar_alt_low then 
			RAD_ALT_LOW_STAT:set(1)
		else
			RAD_ALT_LOW_STAT:set(0)
		end
		if radar_alt_low < 0 then on = false end
		if on then 
			current_Ralt:set(height)
			radaraltind:set(height)
			Ralt_Off:set(0)
		else
			current_Ralt:set(0)
			radaraltind:set(0)
			Ralt_Off:set(1)
		end
		radaraltlow:set(radar_alt_low)
		radaralthigh:set(radar_alt_high)
		RADAR_ALT_OFF:set(1)
	else
		RAD_ALT_HIGH_STAT:set(0)
		RAD_ALT_LOW_STAT:set(0)
		Ralt_Off:set(1)
		RADAR_ALT_OFF:set(0)
	end
end

local function update_altimeter()
	if dc_ok then
    	alt = sensor_data.getBarometricAltitude()*meters_to_feet
		alt_off:set(1.0)
	else
		alt_off:set(0.0)
	end
	
	local Nxxx, rest = math.modf(alt_setting/10) 
	local xNxx, rest = math.modf(rest*10) 
	local xxNx, rest = math.modf(rest*10) 
	local xxxN, rest = math.modf(rest*10) 

    alt_adj_Nxxx:set(0.1*Nxxx)
	alt_adj_xNxx:set(0.1*xNxx)
    alt_adj_xxNx:set(0.1*xxNx)
    alt_adj_xxxN:set(0.1*xxxN)

	local Nxxx, rest = math.modf(alt_setting*hg_to_hpa/1000) 
	local xNxx, rest = math.modf(rest*10) 
	local xxNx, rest = math.modf(rest*10) 
	local xxxN, rest = math.modf(rest*10) 
	
    alt_adj_hp_Nxxx:set(0.1*Nxxx)
	alt_adj_hp_xNxx:set(0.1*xNxx)
    alt_adj_hp_xxNx:set(0.1*xxNx)
    alt_adj_hp_xxxN:set(0.1*xxxN)

	-- based on setting, adjust displayed altitude
    local alt_adj = alt + (alt_setting - ALT_PRESSURE_STD)*1000   -- 1000 feet per inHg / 10 feet per .01 
	local altNxx, rest = math.modf(alt_adj/10000) 
	local altxNx, rest = math.modf(rest*10) 
	local altind = rest
	local altxxN, rest = math.modf(rest*10) 
	
	--print_message_to_user("Alt: " .. tostring(alt_adj).. "ind: " .. tostring(altind))
	alt_ind:set(altind)
	alt_Nxx:set(0.1*altNxx)
	alt_xNx:set(0.1*altxNx)
	alt_xxN:set(0.1*altxxN)
end

local function update_bearing()
	current_hdg:set(360-(sensor_data.getHeading()*radian_to_degree))
end

function update()
	ac_ok = ac_elec:get() > 0.5
	dc_ok = dc_elec:get() > 0.5
	att_ind_ok = att_ind_on:get() > 0.5
	update_adi()
	update_slip()
	update_climb()
	update_altimeter()
	update_radar_altitude()
	update_bearing()
end

need_to_be_closed = false 