dofile(LockOn_Options.script_path .. "command_defs.lua")
--dofile(LockOn_Options.script_path.."TNL3100/TNL3100_helper.lua")

OrderedList = dofile(LockOn_Options.script_path.."Nav/OrderedList.lua")

local dev = GetSelf()
local sensor_data = get_base_data()
local update_time_step = 0.2

ranges = {
	[1] = 1,
	[2] = 2.5,
	[3] = 5,
	[4] = 10,
	[5] = 25,
	[6] = 50,
	[7] = 100,
	[8] = 250,
}

local dc_elec = get_param_handle("DC_POWER_AVAIL")

local ARGUS_TRACK_HDG = get_param_handle("ARGUS_TRACK_HDG")
local ARGUS_TRACK_HDG_ENABLED = get_param_handle("ARGUS_TRACK_HDG_ENABLED")
local ENR_ENABLED = get_param_handle("ARGUS_ENR_ENABLED")
local ADF_DISP_ENABLED = get_param_handle("ADF_DISP_ENABLED")
local ARGUS_MODE_STR = get_param_handle("ARGUS_MODE_STR")
local GROUND_SPEED_KTS = get_param_handle("GROUND_SPEED_KTS")
local CURRENT_HDG = get_param_handle("CURRENT_HDG")

local ETA_HOURS = get_param_handle("ETA_HOURS")
local ETA_SECS = get_param_handle("ETA_SECS")

local ARGUS_DIST = get_param_handle("ARGUS_DIST")
local ARGUS_BRG = get_param_handle("ARGUS_BRG")

local ARGUS_CROSSTRACK_DIST = get_param_handle("ARGUS_CROSSTRACK_DIST")
local ARGUS_CROSSTRACK_MODE = get_param_handle("ARGUS_CROSSTRACK_MODE")
local ARGUS_CROSSTRACK_DIR = get_param_handle("ARGUS_CROSSTRACK_DIR")
local ARGUS_WPI_TEXT = get_param_handle("ARGUS_WPI_TEXT")

local SELF_X = get_param_handle("SELF_X")
local SELF_Y = get_param_handle("SELF_Y")

local AWP_X = get_param_handle("ARGUS_AWP_X")
local AWP_Y = get_param_handle("ARGUS_AWP_Y")
local SHOW_AC_WP = get_param_handle("ARGUS_SHOW_AC_WP")


local BRIGHTNESS = get_param_handle("ARGUS_BRIGHTNESS")
local ARGUS_POWER = get_param_handle("ARGUS_POWER")
local mode = 4
local brightness = 1.0

local eta = -1
local crosstrack_dist = 0
local distance = 0
ARGUS_TRACK_HDG:set("--")
eta_str_h = "--"
eta_str_m = "--"
eta_str_s = "--"

local power = 1
local enr_pressed = false
local t_enr_pressed = 0.0
local enr_short = true
i_range = 2
local range = ranges[i_range]

ARGUS_POWER:set(power)

local function enable_dep_mode()
	ENR_ENABLED:set(0)
	ARGUS_TRACK_HDG_ENABLED:set(1)
	ADF_DISP_ENABLED:set(0)
	ARGUS_MODE_STR:set("DEP/" .. range)
	mode = 1
end

ARGUS_CROSSTRACK_DIST:set(0)
ARGUS_CROSSTRACK_MODE:set(1)
ARGUS_CROSSTRACK_DIR:set("R")
ARGUS_WPI_TEXT:set("----")

local function enable_arr_mode()
	ENR_ENABLED:set(0)
	ARGUS_TRACK_HDG_ENABLED:set(1)
	ADF_DISP_ENABLED:set(0)
	ARGUS_MODE_STR:set("ARR/" .. range)
	mode = 3
end

local function enable_enr_mode()
	ENR_ENABLED:set(1)
	ARGUS_TRACK_HDG_ENABLED:set(1)
	ADF_DISP_ENABLED:set(0)
	ARGUS_MODE_STR:set("ENR/" .. range)
	mode = 2
end

local function enable_adf_display()
	ENR_ENABLED:set(0)
	ARGUS_TRACK_HDG_ENABLED:set(0)
	ADF_DISP_ENABLED:set(1)
	ARGUS_MODE_STR:set("ADF MODE")
	mode = 4
end

enable_adf_display()

local function update_range()
	range = ranges[i_range]
	if mode == 1 then
		ARGUS_MODE_STR:set("DEP/" .. range)
	elseif mode == 2 then
		ARGUS_MODE_STR:set("ENR/" .. range)
	elseif mode == 3 then
		ARGUS_MODE_STR:set("ARR/" .. range)
	end
end

local function increase_range()
	i_range = i_range + 1
	if i_range > 8 then
		i_range = 1
	end
	update_range()
end

local function decrease_range()
	i_range = i_range - 1
	if i_range < 1 then
		i_range = 8
	end
	update_range()
end

theatre               = get_terrain_related_data("name")
local wps_params      = {}
local airports_params = {}

local waypoints       = {}
local actual_waypoint = 2

function set_waypoints(_waypoints, _actual_waypoint)
	waypoints = _waypoints
	actual_waypoint = _actual_waypoint
end



function set_nav_data(eta_, crosstrack_dist_, distance_)
	eta = eta_
	crosstrack_dist = crosstrack_dist_
	distance = distance_
end

local function initWaypointParams()
	for ia = 1, 50 do
		local i = "_" .. ia .. "_"
		wps_params[ia] =
		{
			x = get_param_handle("ARGUS_WP_" .. ia .. "_X"),
			y = get_param_handle("ARGUS_WP_" .. ia .. "_Y"),
			name = get_param_handle("ARGUS_WP_" .. ia .. "_NAME"),
			disp = get_param_handle("ARGUS_WP_" .. ia .. "_DISP")
		}
		wps_params[ia].x:set(0)
		wps_params[ia].y:set(0)
		wps_params[ia].name:set("")
		wps_params[ia].disp:set(0)
	end
end

local function initAirportsParams()
	for i_ap = 1, 10 do
		local i = "_" .. i_ap .. "_"
		airports_params[i_ap] =
		{
			x = get_param_handle("ARGUS_AP_" .. i_ap .. "_X"),
			y = get_param_handle("ARGUS_AP_" .. i_ap .. "_Y"),
			name = get_param_handle("ARGUS_AP_" .. i_ap .. "_NAME"),
			disp = get_param_handle("ARGUS_AP_" .. i_ap .. "_DISP"),
			runways = {}
		}


		airports_params[i_ap].x:set(0)
		airports_params[i_ap].y:set(0)
		airports_params[i_ap].name:set("XXX")
		airports_params[i_ap].disp:set(0)
		for i_rw = 1, 5 do
			airports_params[i_ap].runways[i_rw] = {
				disp = get_param_handle("ARGUS_AP_" .. i_ap .. "_RW_" .. i_rw .. "_DISP"),
				x1 = get_param_handle("ARGUS_AP_" .. i_ap .. "_RW_" .. i_rw .. "_XS"),
				y1 = get_param_handle("ARGUS_AP_" .. i_ap .. "_RW_" .. i_rw .. "_YS"),
				x2 = get_param_handle("ARGUS_AP_" .. i_ap .. "_RW_" .. i_rw .. "_XE"),
				y2 = get_param_handle("ARGUS_AP_" .. i_ap .. "_RW_" .. i_rw .. "_YE")
			}
		end
	end
end

initWaypointParams()
initAirportsParams()

local function update_waypoints()
	local x, y, z = sensor_data.getSelfCoordinates()
	local set_some = false
	for ia = 1, 50 do
		wp = waypoints[ia]
		if wp ~= nil and wp.point.x ~= nil then
			set_some = true
			wps_params[ia].x:set((wp.point.x) / range / 1852)
			wps_params[ia].y:set((wp.point.y) / range / 1852)
			wps_params[ia].name:set(wp.name)
			wps_params[ia].disp:set(1)
			--print_message_to_user("WP" .. (ia - 1))
		else
			wps_params[ia].disp:set(0)
		end
	end

	-- if set_some then 
	-- 	wps_params[1].x:set((x) / range / 1852)
	-- 	wps_params[1].y:set((z) / range / 1852)
	-- 	--wps_params[1].name:set("WP" .. (ia - 1))
	-- 	wps_params[1].disp:set(1)
	-- else
	-- 	wps_params[1].disp:set(0)
	-- end

	-- move this to target
	local wp = nil
	if actual_waypoint ~= -1 then
		if waypoints[actual_waypoint] ~= nil then
			wp = waypoints[actual_waypoint]
		end
	end

	if wp ~= nil then
		local delta_x = wp.point.x - x
		local delta_z = wp.point.y - z

		AWP_X:set(wp.point.x/ range / 1852)
		AWP_Y:set(wp.point.y/ range / 1852)
		SHOW_AC_WP:set(1.0)

		local str = string.format("%3.1f", distance / 1852.0)
		ARGUS_DIST:set(distance / 1852.0)
		local bearing = math.deg(math.atan2(delta_z, delta_x))
		if bearing < 0 then bearing = bearing + 360 end
		ARGUS_BRG:set(bearing)
		hdg = CURRENT_HDG:get()
		delta_hdg = bearing - hdg
		if delta_hdg < 180.0 then delta_hdg = delta_hdg + 360.0 end
		if delta_hdg > 180.0 then delta_hdg = delta_hdg - 360.0 end
		local dh_dir = "L"
		if delta_hdg > 0 then dh_dir = "R" end
		ARGUS_TRACK_HDG:set(
			string.format("%s %.1f°", dh_dir, math.abs(delta_hdg)))

		ARGUS_WPI_TEXT:set(wp.name)

		local speed = GROUND_SPEED_KTS:get() * 0.514444
		if speed < 1 or eta < 0 then
			ETA_HOURS:set("--:--")
			ETA_SECS:set(":--")
		else
			local hour = eta / 3600.0
			local int, frac = math.modf(hour)
			local int1, frac1 = math.modf(frac * 60)
			local mins = math.floor(frac * 60)
			eta_str_h = string.format("%02.0f:%02.0f", hour, mins)
			eta_str_s = string.format(":%02.0f", frac1 * 60)
			ETA_HOURS:set(eta_str_h)
			ETA_SECS:set(eta_str_s)
		end
	else
		ETA_HOURS:set("--:--")
		ETA_SECS:set(":--")
		ARGUS_DIST:set("---.-")
		ARGUS_BRG:set("---")
		SHOW_AC_WP:set(0.0)
	end
end

local function enr_button(value)
	if value > 0.5 then
		t_enr_pressed = 0.0
		enr_pressed = true
		enr_short = true
	else
		enr_pressed = false
		if mode ~= 2 then
			enable_enr_mode()
		else
			if enr_short then
				increase_range()
			end
		end
	end
end

local function power_button(value)
	if value < 0.5 then
		if power == 0 then
			power = 1
		else
			power = 0
		end
		ARGUS_POWER:set(power)
	end
end

function argus_post_initialize(dev_)
	local birth = LockOn_Options.init_conditions.birth_place	
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then 		
		power = 1
    elseif birth=="GROUND_COLD" then
		power = 0
    end
	dev = dev_
	dev:performClickableAction(device_commands.argus_dim, 1.0, true)
end

function argus_SetCommand(command, value)
	if command == Keys.argus_dep then
		enable_dep_mode()
	end
	if command == device_commands.argus_dep then
		enable_dep_mode()
	end

	if command == Keys.argus_enr then
		enr_button(value)
	end
	if command == device_commands.argus_enr then
		enr_button(value)
	end

	if command == Keys.argus_arr then
		enable_arr_mode()
	end
	if command == device_commands.argus_arr then
		enable_arr_mode()
	end

	if command == Keys.argus_aux then
		enable_adf_display()
	end
	if command == device_commands.argus_aux then
		enable_adf_display()
	end


	if command == Keys.argus_dim_inc then
		brightness = brightness + 0.002
		if brightness > 1.0 then brightness = 1.0 end
		dev:performClickableAction(device_commands.argus_dim, brightness, true)
	end
	if command == Keys.argus_dim_dec then
		brightness = brightness - 0.002
		if brightness < 0.0 then brightness = 0.0 end
		dev:performClickableAction(device_commands.argus_dim, brightness, true)
	end
	if command == device_commands.argus_dim then
		brightness = value
		BRIGHTNESS:set(brightness)
	end

	if command == Keys.argus_power then
		power_button(value)
	end
	if command == device_commands.argus_power then
		power_button(value)
	end
end

function argus_update_airports(airports)
	for i = 1, 10 do
		local ap = airports:getByIndex(i)
		if ap ~= nil then 
			local x_ap = ap.point.x
			local y_ap = ap.point.y
			airports_params[i].x:set(x_ap / range / 1852)
			airports_params[i].y:set(y_ap / range / 1852)
			airports_params[i].disp:set(1.0)
			local ap_name_str = ap.code
			if ap_name_str == nil then
				ap_name_str = string.sub(ap.display_name,1,3)
			end
			airports_params[i].name:set(ap_name_str)
			for i_rw = 1, #ap.runways do
				if i_rw <= 5 then
					local rw = ap.runways[i_rw]
					airports_params[i].runways[i_rw].x1:set((rw.runwayEnd1.x - x_ap) / range / 1852)
					airports_params[i].runways[i_rw].y1:set((rw.runwayEnd1.y - y_ap) / range / 1852)

					airports_params[i].runways[i_rw].x2:set((rw.runwayEnd2.x - x_ap) / range / 1852)
					airports_params[i].runways[i_rw].y2:set((rw.runwayEnd2.y - y_ap) / range / 1852)

					airports_params[i].runways[i_rw].disp:set(1.0)
				end
			end
		end
	end
end

function argus_update()
	if enr_pressed then
		t_enr_pressed = t_enr_pressed + 0.05
		if t_enr_pressed > 0.5 then
			decrease_range()
			t_enr_pressed = 0.0
			enr_short = false
		end
	end
	local x, y, z = sensor_data.getSelfCoordinates()
	SELF_X:set(x / range / 1852)
	SELF_Y:set(z / range / 1852)
	update_waypoints()

	if mode == 2 then
		if math.abs(crosstrack_dist * 0.00054) > 1.0 then
			if crosstrack_dist < 0.0 then
				ARGUS_CROSSTRACK_DIR:set("L")
			else
				ARGUS_CROSSTRACK_DIR:set("R")
			end
			ARGUS_CROSSTRACK_DIST:set(math.abs(crosstrack_dist * 0.00054))
			ARGUS_CROSSTRACK_MODE:set(1.0)
		else
			ARGUS_CROSSTRACK_DIST:set(crosstrack_dist * 0.00054)
			ARGUS_CROSSTRACK_MODE:set(0.0)
		end
	end

	local dc_ok = dc_elec:get() > 0.5
    if dc_ok then 
        if power ==1 then 
			ARGUS_POWER:set(1)
		else
			ARGUS_POWER:set(0)
		end
    else
        ARGUS_POWER:set(0)
    end

end

need_to_be_closed = false
