/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#include <app/util/basic-types.h>

namespace chip {
namespace app {
namespace Clusters {

// Matter does not have global commands

namespace Identify {
namespace Commands {

namespace Identify {
static constexpr CommandId Id = 0x00000000;
} // namespace Identify

namespace TriggerEffect {
static constexpr CommandId Id = 0x00000040;
} // namespace TriggerEffect

} // namespace Commands
} // namespace Identify

namespace Groups {
namespace Commands {

namespace AddGroup {
static constexpr CommandId Id = 0x00000000;
} // namespace AddGroup

namespace AddGroupResponse {
static constexpr CommandId Id = 0x00000000;
} // namespace AddGroupResponse

namespace ViewGroup {
static constexpr CommandId Id = 0x00000001;
} // namespace ViewGroup

namespace ViewGroupResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ViewGroupResponse

namespace GetGroupMembership {
static constexpr CommandId Id = 0x00000002;
} // namespace GetGroupMembership

namespace GetGroupMembershipResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace GetGroupMembershipResponse

namespace RemoveGroup {
static constexpr CommandId Id = 0x00000003;
} // namespace RemoveGroup

namespace RemoveGroupResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace RemoveGroupResponse

namespace RemoveAllGroups {
static constexpr CommandId Id = 0x00000004;
} // namespace RemoveAllGroups

namespace AddGroupIfIdentifying {
static constexpr CommandId Id = 0x00000005;
} // namespace AddGroupIfIdentifying

} // namespace Commands
} // namespace Groups

namespace OnOff {
namespace Commands {

namespace Off {
static constexpr CommandId Id = 0x00000000;
} // namespace Off

namespace On {
static constexpr CommandId Id = 0x00000001;
} // namespace On

namespace Toggle {
static constexpr CommandId Id = 0x00000002;
} // namespace Toggle

namespace OffWithEffect {
static constexpr CommandId Id = 0x00000040;
} // namespace OffWithEffect

namespace OnWithRecallGlobalScene {
static constexpr CommandId Id = 0x00000041;
} // namespace OnWithRecallGlobalScene

namespace OnWithTimedOff {
static constexpr CommandId Id = 0x00000042;
} // namespace OnWithTimedOff

} // namespace Commands
} // namespace OnOff

namespace LevelControl {
namespace Commands {

namespace MoveToLevel {
static constexpr CommandId Id = 0x00000000;
} // namespace MoveToLevel

namespace Move {
static constexpr CommandId Id = 0x00000001;
} // namespace Move

namespace Step {
static constexpr CommandId Id = 0x00000002;
} // namespace Step

namespace Stop {
static constexpr CommandId Id = 0x00000003;
} // namespace Stop

namespace MoveToLevelWithOnOff {
static constexpr CommandId Id = 0x00000004;
} // namespace MoveToLevelWithOnOff

namespace MoveWithOnOff {
static constexpr CommandId Id = 0x00000005;
} // namespace MoveWithOnOff

namespace StepWithOnOff {
static constexpr CommandId Id = 0x00000006;
} // namespace StepWithOnOff

namespace StopWithOnOff {
static constexpr CommandId Id = 0x00000007;
} // namespace StopWithOnOff

namespace MoveToClosestFrequency {
static constexpr CommandId Id = 0x00000008;
} // namespace MoveToClosestFrequency

} // namespace Commands
} // namespace LevelControl

namespace AccessControl {
namespace Commands {

namespace ReviewFabricRestrictions {
static constexpr CommandId Id = 0x00000000;
} // namespace ReviewFabricRestrictions

namespace ReviewFabricRestrictionsResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ReviewFabricRestrictionsResponse

} // namespace Commands
} // namespace AccessControl

namespace Actions {
namespace Commands {

namespace InstantAction {
static constexpr CommandId Id = 0x00000000;
} // namespace InstantAction

namespace InstantActionWithTransition {
static constexpr CommandId Id = 0x00000001;
} // namespace InstantActionWithTransition

namespace StartAction {
static constexpr CommandId Id = 0x00000002;
} // namespace StartAction

namespace StartActionWithDuration {
static constexpr CommandId Id = 0x00000003;
} // namespace StartActionWithDuration

namespace StopAction {
static constexpr CommandId Id = 0x00000004;
} // namespace StopAction

namespace PauseAction {
static constexpr CommandId Id = 0x00000005;
} // namespace PauseAction

namespace PauseActionWithDuration {
static constexpr CommandId Id = 0x00000006;
} // namespace PauseActionWithDuration

namespace ResumeAction {
static constexpr CommandId Id = 0x00000007;
} // namespace ResumeAction

namespace EnableAction {
static constexpr CommandId Id = 0x00000008;
} // namespace EnableAction

namespace EnableActionWithDuration {
static constexpr CommandId Id = 0x00000009;
} // namespace EnableActionWithDuration

namespace DisableAction {
static constexpr CommandId Id = 0x0000000A;
} // namespace DisableAction

namespace DisableActionWithDuration {
static constexpr CommandId Id = 0x0000000B;
} // namespace DisableActionWithDuration

} // namespace Commands
} // namespace Actions

namespace BasicInformation {
namespace Commands {

namespace MfgSpecificPing {
static constexpr CommandId Id = 0x10020000;
} // namespace MfgSpecificPing

} // namespace Commands
} // namespace BasicInformation

namespace OtaSoftwareUpdateProvider {
namespace Commands {

namespace QueryImage {
static constexpr CommandId Id = 0x00000000;
} // namespace QueryImage

namespace QueryImageResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace QueryImageResponse

namespace ApplyUpdateRequest {
static constexpr CommandId Id = 0x00000002;
} // namespace ApplyUpdateRequest

namespace ApplyUpdateResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace ApplyUpdateResponse

namespace NotifyUpdateApplied {
static constexpr CommandId Id = 0x00000004;
} // namespace NotifyUpdateApplied

} // namespace Commands
} // namespace OtaSoftwareUpdateProvider

namespace OtaSoftwareUpdateRequestor {
namespace Commands {

namespace AnnounceOTAProvider {
static constexpr CommandId Id = 0x00000000;
} // namespace AnnounceOTAProvider

} // namespace Commands
} // namespace OtaSoftwareUpdateRequestor

namespace GeneralCommissioning {
namespace Commands {

namespace ArmFailSafe {
static constexpr CommandId Id = 0x00000000;
} // namespace ArmFailSafe

namespace ArmFailSafeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ArmFailSafeResponse

namespace SetRegulatoryConfig {
static constexpr CommandId Id = 0x00000002;
} // namespace SetRegulatoryConfig

namespace SetRegulatoryConfigResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace SetRegulatoryConfigResponse

namespace CommissioningComplete {
static constexpr CommandId Id = 0x00000004;
} // namespace CommissioningComplete

namespace CommissioningCompleteResponse {
static constexpr CommandId Id = 0x00000005;
} // namespace CommissioningCompleteResponse

namespace SetTCAcknowledgements {
static constexpr CommandId Id = 0x00000006;
} // namespace SetTCAcknowledgements

namespace SetTCAcknowledgementsResponse {
static constexpr CommandId Id = 0x00000007;
} // namespace SetTCAcknowledgementsResponse

} // namespace Commands
} // namespace GeneralCommissioning

namespace NetworkCommissioning {
namespace Commands {

namespace ScanNetworks {
static constexpr CommandId Id = 0x00000000;
} // namespace ScanNetworks

namespace ScanNetworksResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ScanNetworksResponse

namespace AddOrUpdateWiFiNetwork {
static constexpr CommandId Id = 0x00000002;
} // namespace AddOrUpdateWiFiNetwork

namespace AddOrUpdateThreadNetwork {
static constexpr CommandId Id = 0x00000003;
} // namespace AddOrUpdateThreadNetwork

namespace RemoveNetwork {
static constexpr CommandId Id = 0x00000004;
} // namespace RemoveNetwork

namespace NetworkConfigResponse {
static constexpr CommandId Id = 0x00000005;
} // namespace NetworkConfigResponse

namespace ConnectNetwork {
static constexpr CommandId Id = 0x00000006;
} // namespace ConnectNetwork

namespace ConnectNetworkResponse {
static constexpr CommandId Id = 0x00000007;
} // namespace ConnectNetworkResponse

namespace ReorderNetwork {
static constexpr CommandId Id = 0x00000008;
} // namespace ReorderNetwork

namespace QueryIdentity {
static constexpr CommandId Id = 0x00000009;
} // namespace QueryIdentity

namespace QueryIdentityResponse {
static constexpr CommandId Id = 0x0000000A;
} // namespace QueryIdentityResponse

} // namespace Commands
} // namespace NetworkCommissioning

namespace DiagnosticLogs {
namespace Commands {

namespace RetrieveLogsRequest {
static constexpr CommandId Id = 0x00000000;
} // namespace RetrieveLogsRequest

namespace RetrieveLogsResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace RetrieveLogsResponse

} // namespace Commands
} // namespace DiagnosticLogs

namespace GeneralDiagnostics {
namespace Commands {

namespace TestEventTrigger {
static constexpr CommandId Id = 0x00000000;
} // namespace TestEventTrigger

namespace TimeSnapshot {
static constexpr CommandId Id = 0x00000001;
} // namespace TimeSnapshot

namespace TimeSnapshotResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace TimeSnapshotResponse

namespace PayloadTestRequest {
static constexpr CommandId Id = 0x00000003;
} // namespace PayloadTestRequest

namespace PayloadTestResponse {
static constexpr CommandId Id = 0x00000004;
} // namespace PayloadTestResponse

} // namespace Commands
} // namespace GeneralDiagnostics

namespace SoftwareDiagnostics {
namespace Commands {

namespace ResetWatermarks {
static constexpr CommandId Id = 0x00000000;
} // namespace ResetWatermarks

} // namespace Commands
} // namespace SoftwareDiagnostics

namespace ThreadNetworkDiagnostics {
namespace Commands {

namespace ResetCounts {
static constexpr CommandId Id = 0x00000000;
} // namespace ResetCounts

} // namespace Commands
} // namespace ThreadNetworkDiagnostics

namespace WiFiNetworkDiagnostics {
namespace Commands {

namespace ResetCounts {
static constexpr CommandId Id = 0x00000000;
} // namespace ResetCounts

} // namespace Commands
} // namespace WiFiNetworkDiagnostics

namespace EthernetNetworkDiagnostics {
namespace Commands {

namespace ResetCounts {
static constexpr CommandId Id = 0x00000000;
} // namespace ResetCounts

} // namespace Commands
} // namespace EthernetNetworkDiagnostics

namespace TimeSynchronization {
namespace Commands {

namespace SetUTCTime {
static constexpr CommandId Id = 0x00000000;
} // namespace SetUTCTime

namespace SetTrustedTimeSource {
static constexpr CommandId Id = 0x00000001;
} // namespace SetTrustedTimeSource

namespace SetTimeZone {
static constexpr CommandId Id = 0x00000002;
} // namespace SetTimeZone

namespace SetTimeZoneResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace SetTimeZoneResponse

namespace SetDSTOffset {
static constexpr CommandId Id = 0x00000004;
} // namespace SetDSTOffset

namespace SetDefaultNTP {
static constexpr CommandId Id = 0x00000005;
} // namespace SetDefaultNTP

} // namespace Commands
} // namespace TimeSynchronization

namespace BridgedDeviceBasicInformation {
namespace Commands {

namespace KeepActive {
static constexpr CommandId Id = 0x00000080;
} // namespace KeepActive

} // namespace Commands
} // namespace BridgedDeviceBasicInformation

namespace AdministratorCommissioning {
namespace Commands {

namespace OpenCommissioningWindow {
static constexpr CommandId Id = 0x00000000;
} // namespace OpenCommissioningWindow

namespace OpenBasicCommissioningWindow {
static constexpr CommandId Id = 0x00000001;
} // namespace OpenBasicCommissioningWindow

namespace RevokeCommissioning {
static constexpr CommandId Id = 0x00000002;
} // namespace RevokeCommissioning

} // namespace Commands
} // namespace AdministratorCommissioning

namespace OperationalCredentials {
namespace Commands {

namespace AttestationRequest {
static constexpr CommandId Id = 0x00000000;
} // namespace AttestationRequest

namespace AttestationResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace AttestationResponse

namespace CertificateChainRequest {
static constexpr CommandId Id = 0x00000002;
} // namespace CertificateChainRequest

namespace CertificateChainResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace CertificateChainResponse

namespace CSRRequest {
static constexpr CommandId Id = 0x00000004;
} // namespace CSRRequest

namespace CSRResponse {
static constexpr CommandId Id = 0x00000005;
} // namespace CSRResponse

namespace AddNOC {
static constexpr CommandId Id = 0x00000006;
} // namespace AddNOC

namespace UpdateNOC {
static constexpr CommandId Id = 0x00000007;
} // namespace UpdateNOC

namespace NOCResponse {
static constexpr CommandId Id = 0x00000008;
} // namespace NOCResponse

namespace UpdateFabricLabel {
static constexpr CommandId Id = 0x00000009;
} // namespace UpdateFabricLabel

namespace RemoveFabric {
static constexpr CommandId Id = 0x0000000A;
} // namespace RemoveFabric

namespace AddTrustedRootCertificate {
static constexpr CommandId Id = 0x0000000B;
} // namespace AddTrustedRootCertificate

} // namespace Commands
} // namespace OperationalCredentials

namespace GroupKeyManagement {
namespace Commands {

namespace KeySetWrite {
static constexpr CommandId Id = 0x00000000;
} // namespace KeySetWrite

namespace KeySetRead {
static constexpr CommandId Id = 0x00000001;
} // namespace KeySetRead

namespace KeySetReadResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace KeySetReadResponse

namespace KeySetRemove {
static constexpr CommandId Id = 0x00000003;
} // namespace KeySetRemove

namespace KeySetReadAllIndices {
static constexpr CommandId Id = 0x00000004;
} // namespace KeySetReadAllIndices

namespace KeySetReadAllIndicesResponse {
static constexpr CommandId Id = 0x00000005;
} // namespace KeySetReadAllIndicesResponse

} // namespace Commands
} // namespace GroupKeyManagement

namespace IcdManagement {
namespace Commands {

namespace RegisterClient {
static constexpr CommandId Id = 0x00000000;
} // namespace RegisterClient

namespace RegisterClientResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace RegisterClientResponse

namespace UnregisterClient {
static constexpr CommandId Id = 0x00000002;
} // namespace UnregisterClient

namespace StayActiveRequest {
static constexpr CommandId Id = 0x00000003;
} // namespace StayActiveRequest

namespace StayActiveResponse {
static constexpr CommandId Id = 0x00000004;
} // namespace StayActiveResponse

} // namespace Commands
} // namespace IcdManagement

namespace Timer {
namespace Commands {

namespace SetTimer {
static constexpr CommandId Id = 0x00000000;
} // namespace SetTimer

namespace ResetTimer {
static constexpr CommandId Id = 0x00000001;
} // namespace ResetTimer

namespace AddTime {
static constexpr CommandId Id = 0x00000002;
} // namespace AddTime

namespace ReduceTime {
static constexpr CommandId Id = 0x00000003;
} // namespace ReduceTime

} // namespace Commands
} // namespace Timer

namespace OvenCavityOperationalState {
namespace Commands {

namespace Pause {
static constexpr CommandId Id = 0x00000000;
} // namespace Pause

namespace Stop {
static constexpr CommandId Id = 0x00000001;
} // namespace Stop

namespace Start {
static constexpr CommandId Id = 0x00000002;
} // namespace Start

namespace Resume {
static constexpr CommandId Id = 0x00000003;
} // namespace Resume

namespace OperationalCommandResponse {
static constexpr CommandId Id = 0x00000004;
} // namespace OperationalCommandResponse

} // namespace Commands
} // namespace OvenCavityOperationalState

namespace OvenMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace OvenMode

namespace ModeSelect {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

} // namespace Commands
} // namespace ModeSelect

namespace LaundryWasherMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace LaundryWasherMode

namespace RefrigeratorAndTemperatureControlledCabinetMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace RefrigeratorAndTemperatureControlledCabinetMode

namespace RvcRunMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace RvcRunMode

namespace RvcCleanMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace RvcCleanMode

namespace TemperatureControl {
namespace Commands {

namespace SetTemperature {
static constexpr CommandId Id = 0x00000000;
} // namespace SetTemperature

} // namespace Commands
} // namespace TemperatureControl

namespace DishwasherMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace DishwasherMode

namespace SmokeCoAlarm {
namespace Commands {

namespace SelfTestRequest {
static constexpr CommandId Id = 0x00000000;
} // namespace SelfTestRequest

} // namespace Commands
} // namespace SmokeCoAlarm

namespace DishwasherAlarm {
namespace Commands {

namespace Reset {
static constexpr CommandId Id = 0x00000000;
} // namespace Reset

namespace ModifyEnabledAlarms {
static constexpr CommandId Id = 0x00000001;
} // namespace ModifyEnabledAlarms

} // namespace Commands
} // namespace DishwasherAlarm

namespace MicrowaveOvenControl {
namespace Commands {

namespace SetCookingParameters {
static constexpr CommandId Id = 0x00000000;
} // namespace SetCookingParameters

namespace AddMoreTime {
static constexpr CommandId Id = 0x00000001;
} // namespace AddMoreTime

} // namespace Commands
} // namespace MicrowaveOvenControl

namespace OperationalState {
namespace Commands {

namespace Pause {
static constexpr CommandId Id = 0x00000000;
} // namespace Pause

namespace Stop {
static constexpr CommandId Id = 0x00000001;
} // namespace Stop

namespace Start {
static constexpr CommandId Id = 0x00000002;
} // namespace Start

namespace Resume {
static constexpr CommandId Id = 0x00000003;
} // namespace Resume

namespace OperationalCommandResponse {
static constexpr CommandId Id = 0x00000004;
} // namespace OperationalCommandResponse

} // namespace Commands
} // namespace OperationalState

namespace RvcOperationalState {
namespace Commands {

namespace Pause {
static constexpr CommandId Id = 0x00000000;
} // namespace Pause

namespace Resume {
static constexpr CommandId Id = 0x00000003;
} // namespace Resume

namespace OperationalCommandResponse {
static constexpr CommandId Id = 0x00000004;
} // namespace OperationalCommandResponse

namespace GoHome {
static constexpr CommandId Id = 0x00000080;
} // namespace GoHome

} // namespace Commands
} // namespace RvcOperationalState

namespace ScenesManagement {
namespace Commands {

namespace AddScene {
static constexpr CommandId Id = 0x00000000;
} // namespace AddScene

namespace AddSceneResponse {
static constexpr CommandId Id = 0x00000000;
} // namespace AddSceneResponse

namespace ViewScene {
static constexpr CommandId Id = 0x00000001;
} // namespace ViewScene

namespace ViewSceneResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ViewSceneResponse

namespace RemoveScene {
static constexpr CommandId Id = 0x00000002;
} // namespace RemoveScene

namespace RemoveSceneResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace RemoveSceneResponse

namespace RemoveAllScenes {
static constexpr CommandId Id = 0x00000003;
} // namespace RemoveAllScenes

namespace RemoveAllScenesResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace RemoveAllScenesResponse

namespace StoreScene {
static constexpr CommandId Id = 0x00000004;
} // namespace StoreScene

namespace StoreSceneResponse {
static constexpr CommandId Id = 0x00000004;
} // namespace StoreSceneResponse

namespace RecallScene {
static constexpr CommandId Id = 0x00000005;
} // namespace RecallScene

namespace GetSceneMembership {
static constexpr CommandId Id = 0x00000006;
} // namespace GetSceneMembership

namespace GetSceneMembershipResponse {
static constexpr CommandId Id = 0x00000006;
} // namespace GetSceneMembershipResponse

namespace CopyScene {
static constexpr CommandId Id = 0x00000040;
} // namespace CopyScene

namespace CopySceneResponse {
static constexpr CommandId Id = 0x00000040;
} // namespace CopySceneResponse

} // namespace Commands
} // namespace ScenesManagement

namespace HepaFilterMonitoring {
namespace Commands {

namespace ResetCondition {
static constexpr CommandId Id = 0x00000000;
} // namespace ResetCondition

} // namespace Commands
} // namespace HepaFilterMonitoring

namespace ActivatedCarbonFilterMonitoring {
namespace Commands {

namespace ResetCondition {
static constexpr CommandId Id = 0x00000000;
} // namespace ResetCondition

} // namespace Commands
} // namespace ActivatedCarbonFilterMonitoring

namespace BooleanStateConfiguration {
namespace Commands {

namespace SuppressAlarm {
static constexpr CommandId Id = 0x00000000;
} // namespace SuppressAlarm

namespace EnableDisableAlarm {
static constexpr CommandId Id = 0x00000001;
} // namespace EnableDisableAlarm

} // namespace Commands
} // namespace BooleanStateConfiguration

namespace ValveConfigurationAndControl {
namespace Commands {

namespace Open {
static constexpr CommandId Id = 0x00000000;
} // namespace Open

namespace Close {
static constexpr CommandId Id = 0x00000001;
} // namespace Close

} // namespace Commands
} // namespace ValveConfigurationAndControl

namespace WaterHeaterManagement {
namespace Commands {

namespace Boost {
static constexpr CommandId Id = 0x00000000;
} // namespace Boost

namespace CancelBoost {
static constexpr CommandId Id = 0x00000001;
} // namespace CancelBoost

} // namespace Commands
} // namespace WaterHeaterManagement

namespace DemandResponseLoadControl {
namespace Commands {

namespace RegisterLoadControlProgramRequest {
static constexpr CommandId Id = 0x00000000;
} // namespace RegisterLoadControlProgramRequest

namespace UnregisterLoadControlProgramRequest {
static constexpr CommandId Id = 0x00000001;
} // namespace UnregisterLoadControlProgramRequest

namespace AddLoadControlEventRequest {
static constexpr CommandId Id = 0x00000002;
} // namespace AddLoadControlEventRequest

namespace RemoveLoadControlEventRequest {
static constexpr CommandId Id = 0x00000003;
} // namespace RemoveLoadControlEventRequest

namespace ClearLoadControlEventsRequest {
static constexpr CommandId Id = 0x00000004;
} // namespace ClearLoadControlEventsRequest

} // namespace Commands
} // namespace DemandResponseLoadControl

namespace Messages {
namespace Commands {

namespace PresentMessagesRequest {
static constexpr CommandId Id = 0x00000000;
} // namespace PresentMessagesRequest

namespace CancelMessagesRequest {
static constexpr CommandId Id = 0x00000001;
} // namespace CancelMessagesRequest

} // namespace Commands
} // namespace Messages

namespace DeviceEnergyManagement {
namespace Commands {

namespace PowerAdjustRequest {
static constexpr CommandId Id = 0x00000000;
} // namespace PowerAdjustRequest

namespace CancelPowerAdjustRequest {
static constexpr CommandId Id = 0x00000001;
} // namespace CancelPowerAdjustRequest

namespace StartTimeAdjustRequest {
static constexpr CommandId Id = 0x00000002;
} // namespace StartTimeAdjustRequest

namespace PauseRequest {
static constexpr CommandId Id = 0x00000003;
} // namespace PauseRequest

namespace ResumeRequest {
static constexpr CommandId Id = 0x00000004;
} // namespace ResumeRequest

namespace ModifyForecastRequest {
static constexpr CommandId Id = 0x00000005;
} // namespace ModifyForecastRequest

namespace RequestConstraintBasedForecast {
static constexpr CommandId Id = 0x00000006;
} // namespace RequestConstraintBasedForecast

namespace CancelRequest {
static constexpr CommandId Id = 0x00000007;
} // namespace CancelRequest

} // namespace Commands
} // namespace DeviceEnergyManagement

namespace EnergyEvse {
namespace Commands {

namespace GetTargetsResponse {
static constexpr CommandId Id = 0x00000000;
} // namespace GetTargetsResponse

namespace Disable {
static constexpr CommandId Id = 0x00000001;
} // namespace Disable

namespace EnableCharging {
static constexpr CommandId Id = 0x00000002;
} // namespace EnableCharging

namespace EnableDischarging {
static constexpr CommandId Id = 0x00000003;
} // namespace EnableDischarging

namespace StartDiagnostics {
static constexpr CommandId Id = 0x00000004;
} // namespace StartDiagnostics

namespace SetTargets {
static constexpr CommandId Id = 0x00000005;
} // namespace SetTargets

namespace GetTargets {
static constexpr CommandId Id = 0x00000006;
} // namespace GetTargets

namespace ClearTargets {
static constexpr CommandId Id = 0x00000007;
} // namespace ClearTargets

} // namespace Commands
} // namespace EnergyEvse

namespace EnergyEvseMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace EnergyEvseMode

namespace WaterHeaterMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace WaterHeaterMode

namespace DeviceEnergyManagementMode {
namespace Commands {

namespace ChangeToMode {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeToModeResponse

} // namespace Commands
} // namespace DeviceEnergyManagementMode

namespace DoorLock {
namespace Commands {

namespace LockDoor {
static constexpr CommandId Id = 0x00000000;
} // namespace LockDoor

namespace UnlockDoor {
static constexpr CommandId Id = 0x00000001;
} // namespace UnlockDoor

namespace UnlockWithTimeout {
static constexpr CommandId Id = 0x00000003;
} // namespace UnlockWithTimeout

namespace SetWeekDaySchedule {
static constexpr CommandId Id = 0x0000000B;
} // namespace SetWeekDaySchedule

namespace GetWeekDaySchedule {
static constexpr CommandId Id = 0x0000000C;
} // namespace GetWeekDaySchedule

namespace GetWeekDayScheduleResponse {
static constexpr CommandId Id = 0x0000000C;
} // namespace GetWeekDayScheduleResponse

namespace ClearWeekDaySchedule {
static constexpr CommandId Id = 0x0000000D;
} // namespace ClearWeekDaySchedule

namespace SetYearDaySchedule {
static constexpr CommandId Id = 0x0000000E;
} // namespace SetYearDaySchedule

namespace GetYearDaySchedule {
static constexpr CommandId Id = 0x0000000F;
} // namespace GetYearDaySchedule

namespace GetYearDayScheduleResponse {
static constexpr CommandId Id = 0x0000000F;
} // namespace GetYearDayScheduleResponse

namespace ClearYearDaySchedule {
static constexpr CommandId Id = 0x00000010;
} // namespace ClearYearDaySchedule

namespace SetHolidaySchedule {
static constexpr CommandId Id = 0x00000011;
} // namespace SetHolidaySchedule

namespace GetHolidaySchedule {
static constexpr CommandId Id = 0x00000012;
} // namespace GetHolidaySchedule

namespace GetHolidayScheduleResponse {
static constexpr CommandId Id = 0x00000012;
} // namespace GetHolidayScheduleResponse

namespace ClearHolidaySchedule {
static constexpr CommandId Id = 0x00000013;
} // namespace ClearHolidaySchedule

namespace SetUser {
static constexpr CommandId Id = 0x0000001A;
} // namespace SetUser

namespace GetUser {
static constexpr CommandId Id = 0x0000001B;
} // namespace GetUser

namespace GetUserResponse {
static constexpr CommandId Id = 0x0000001C;
} // namespace GetUserResponse

namespace ClearUser {
static constexpr CommandId Id = 0x0000001D;
} // namespace ClearUser

namespace SetCredential {
static constexpr CommandId Id = 0x00000022;
} // namespace SetCredential

namespace SetCredentialResponse {
static constexpr CommandId Id = 0x00000023;
} // namespace SetCredentialResponse

namespace GetCredentialStatus {
static constexpr CommandId Id = 0x00000024;
} // namespace GetCredentialStatus

namespace GetCredentialStatusResponse {
static constexpr CommandId Id = 0x00000025;
} // namespace GetCredentialStatusResponse

namespace ClearCredential {
static constexpr CommandId Id = 0x00000026;
} // namespace ClearCredential

namespace UnboltDoor {
static constexpr CommandId Id = 0x00000027;
} // namespace UnboltDoor

namespace SetAliroReaderConfig {
static constexpr CommandId Id = 0x00000028;
} // namespace SetAliroReaderConfig

namespace ClearAliroReaderConfig {
static constexpr CommandId Id = 0x00000029;
} // namespace ClearAliroReaderConfig

} // namespace Commands
} // namespace DoorLock

namespace WindowCovering {
namespace Commands {

namespace UpOrOpen {
static constexpr CommandId Id = 0x00000000;
} // namespace UpOrOpen

namespace DownOrClose {
static constexpr CommandId Id = 0x00000001;
} // namespace DownOrClose

namespace StopMotion {
static constexpr CommandId Id = 0x00000002;
} // namespace StopMotion

namespace GoToLiftValue {
static constexpr CommandId Id = 0x00000004;
} // namespace GoToLiftValue

namespace GoToLiftPercentage {
static constexpr CommandId Id = 0x00000005;
} // namespace GoToLiftPercentage

namespace GoToTiltValue {
static constexpr CommandId Id = 0x00000007;
} // namespace GoToTiltValue

namespace GoToTiltPercentage {
static constexpr CommandId Id = 0x00000008;
} // namespace GoToTiltPercentage

} // namespace Commands
} // namespace WindowCovering

namespace ServiceArea {
namespace Commands {

namespace SelectAreas {
static constexpr CommandId Id = 0x00000000;
} // namespace SelectAreas

namespace SelectAreasResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace SelectAreasResponse

namespace SkipArea {
static constexpr CommandId Id = 0x00000002;
} // namespace SkipArea

namespace SkipAreaResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace SkipAreaResponse

} // namespace Commands
} // namespace ServiceArea

namespace Thermostat {
namespace Commands {

namespace SetpointRaiseLower {
static constexpr CommandId Id = 0x00000000;
} // namespace SetpointRaiseLower

namespace GetWeeklyScheduleResponse {
static constexpr CommandId Id = 0x00000000;
} // namespace GetWeeklyScheduleResponse

namespace SetWeeklySchedule {
static constexpr CommandId Id = 0x00000001;
} // namespace SetWeeklySchedule

namespace GetWeeklySchedule {
static constexpr CommandId Id = 0x00000002;
} // namespace GetWeeklySchedule

namespace ClearWeeklySchedule {
static constexpr CommandId Id = 0x00000003;
} // namespace ClearWeeklySchedule

namespace SetActiveScheduleRequest {
static constexpr CommandId Id = 0x00000005;
} // namespace SetActiveScheduleRequest

namespace SetActivePresetRequest {
static constexpr CommandId Id = 0x00000006;
} // namespace SetActivePresetRequest

namespace AtomicResponse {
static constexpr CommandId Id = 0x000000FD;
} // namespace AtomicResponse

namespace AtomicRequest {
static constexpr CommandId Id = 0x000000FE;
} // namespace AtomicRequest

} // namespace Commands
} // namespace Thermostat

namespace FanControl {
namespace Commands {

namespace Step {
static constexpr CommandId Id = 0x00000000;
} // namespace Step

} // namespace Commands
} // namespace FanControl

namespace ColorControl {
namespace Commands {

namespace MoveToHue {
static constexpr CommandId Id = 0x00000000;
} // namespace MoveToHue

namespace MoveHue {
static constexpr CommandId Id = 0x00000001;
} // namespace MoveHue

namespace StepHue {
static constexpr CommandId Id = 0x00000002;
} // namespace StepHue

namespace MoveToSaturation {
static constexpr CommandId Id = 0x00000003;
} // namespace MoveToSaturation

namespace MoveSaturation {
static constexpr CommandId Id = 0x00000004;
} // namespace MoveSaturation

namespace StepSaturation {
static constexpr CommandId Id = 0x00000005;
} // namespace StepSaturation

namespace MoveToHueAndSaturation {
static constexpr CommandId Id = 0x00000006;
} // namespace MoveToHueAndSaturation

namespace MoveToColor {
static constexpr CommandId Id = 0x00000007;
} // namespace MoveToColor

namespace MoveColor {
static constexpr CommandId Id = 0x00000008;
} // namespace MoveColor

namespace StepColor {
static constexpr CommandId Id = 0x00000009;
} // namespace StepColor

namespace MoveToColorTemperature {
static constexpr CommandId Id = 0x0000000A;
} // namespace MoveToColorTemperature

namespace EnhancedMoveToHue {
static constexpr CommandId Id = 0x00000040;
} // namespace EnhancedMoveToHue

namespace EnhancedMoveHue {
static constexpr CommandId Id = 0x00000041;
} // namespace EnhancedMoveHue

namespace EnhancedStepHue {
static constexpr CommandId Id = 0x00000042;
} // namespace EnhancedStepHue

namespace EnhancedMoveToHueAndSaturation {
static constexpr CommandId Id = 0x00000043;
} // namespace EnhancedMoveToHueAndSaturation

namespace ColorLoopSet {
static constexpr CommandId Id = 0x00000044;
} // namespace ColorLoopSet

namespace StopMoveStep {
static constexpr CommandId Id = 0x00000047;
} // namespace StopMoveStep

namespace MoveColorTemperature {
static constexpr CommandId Id = 0x0000004B;
} // namespace MoveColorTemperature

namespace StepColorTemperature {
static constexpr CommandId Id = 0x0000004C;
} // namespace StepColorTemperature

} // namespace Commands
} // namespace ColorControl

namespace WiFiNetworkManagement {
namespace Commands {

namespace NetworkPassphraseRequest {
static constexpr CommandId Id = 0x00000000;
} // namespace NetworkPassphraseRequest

namespace NetworkPassphraseResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace NetworkPassphraseResponse

} // namespace Commands
} // namespace WiFiNetworkManagement

namespace ThreadBorderRouterManagement {
namespace Commands {

namespace GetActiveDatasetRequest {
static constexpr CommandId Id = 0x00000000;
} // namespace GetActiveDatasetRequest

namespace GetPendingDatasetRequest {
static constexpr CommandId Id = 0x00000001;
} // namespace GetPendingDatasetRequest

namespace DatasetResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace DatasetResponse

namespace SetActiveDatasetRequest {
static constexpr CommandId Id = 0x00000003;
} // namespace SetActiveDatasetRequest

namespace SetPendingDatasetRequest {
static constexpr CommandId Id = 0x00000004;
} // namespace SetPendingDatasetRequest

} // namespace Commands
} // namespace ThreadBorderRouterManagement

namespace ThreadNetworkDirectory {
namespace Commands {

namespace AddNetwork {
static constexpr CommandId Id = 0x00000000;
} // namespace AddNetwork

namespace RemoveNetwork {
static constexpr CommandId Id = 0x00000001;
} // namespace RemoveNetwork

namespace GetOperationalDataset {
static constexpr CommandId Id = 0x00000002;
} // namespace GetOperationalDataset

namespace OperationalDatasetResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace OperationalDatasetResponse

} // namespace Commands
} // namespace ThreadNetworkDirectory

namespace Channel {
namespace Commands {

namespace ChangeChannel {
static constexpr CommandId Id = 0x00000000;
} // namespace ChangeChannel

namespace ChangeChannelResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ChangeChannelResponse

namespace ChangeChannelByNumber {
static constexpr CommandId Id = 0x00000002;
} // namespace ChangeChannelByNumber

namespace SkipChannel {
static constexpr CommandId Id = 0x00000003;
} // namespace SkipChannel

namespace GetProgramGuide {
static constexpr CommandId Id = 0x00000004;
} // namespace GetProgramGuide

namespace ProgramGuideResponse {
static constexpr CommandId Id = 0x00000005;
} // namespace ProgramGuideResponse

namespace RecordProgram {
static constexpr CommandId Id = 0x00000006;
} // namespace RecordProgram

namespace CancelRecordProgram {
static constexpr CommandId Id = 0x00000007;
} // namespace CancelRecordProgram

} // namespace Commands
} // namespace Channel

namespace TargetNavigator {
namespace Commands {

namespace NavigateTarget {
static constexpr CommandId Id = 0x00000000;
} // namespace NavigateTarget

namespace NavigateTargetResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace NavigateTargetResponse

} // namespace Commands
} // namespace TargetNavigator

namespace MediaPlayback {
namespace Commands {

namespace Play {
static constexpr CommandId Id = 0x00000000;
} // namespace Play

namespace Pause {
static constexpr CommandId Id = 0x00000001;
} // namespace Pause

namespace Stop {
static constexpr CommandId Id = 0x00000002;
} // namespace Stop

namespace StartOver {
static constexpr CommandId Id = 0x00000003;
} // namespace StartOver

namespace Previous {
static constexpr CommandId Id = 0x00000004;
} // namespace Previous

namespace Next {
static constexpr CommandId Id = 0x00000005;
} // namespace Next

namespace Rewind {
static constexpr CommandId Id = 0x00000006;
} // namespace Rewind

namespace FastForward {
static constexpr CommandId Id = 0x00000007;
} // namespace FastForward

namespace SkipForward {
static constexpr CommandId Id = 0x00000008;
} // namespace SkipForward

namespace SkipBackward {
static constexpr CommandId Id = 0x00000009;
} // namespace SkipBackward

namespace PlaybackResponse {
static constexpr CommandId Id = 0x0000000A;
} // namespace PlaybackResponse

namespace Seek {
static constexpr CommandId Id = 0x0000000B;
} // namespace Seek

namespace ActivateAudioTrack {
static constexpr CommandId Id = 0x0000000C;
} // namespace ActivateAudioTrack

namespace ActivateTextTrack {
static constexpr CommandId Id = 0x0000000D;
} // namespace ActivateTextTrack

namespace DeactivateTextTrack {
static constexpr CommandId Id = 0x0000000E;
} // namespace DeactivateTextTrack

} // namespace Commands
} // namespace MediaPlayback

namespace MediaInput {
namespace Commands {

namespace SelectInput {
static constexpr CommandId Id = 0x00000000;
} // namespace SelectInput

namespace ShowInputStatus {
static constexpr CommandId Id = 0x00000001;
} // namespace ShowInputStatus

namespace HideInputStatus {
static constexpr CommandId Id = 0x00000002;
} // namespace HideInputStatus

namespace RenameInput {
static constexpr CommandId Id = 0x00000003;
} // namespace RenameInput

} // namespace Commands
} // namespace MediaInput

namespace LowPower {
namespace Commands {

namespace Sleep {
static constexpr CommandId Id = 0x00000000;
} // namespace Sleep

} // namespace Commands
} // namespace LowPower

namespace KeypadInput {
namespace Commands {

namespace SendKey {
static constexpr CommandId Id = 0x00000000;
} // namespace SendKey

namespace SendKeyResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace SendKeyResponse

} // namespace Commands
} // namespace KeypadInput

namespace ContentLauncher {
namespace Commands {

namespace LaunchContent {
static constexpr CommandId Id = 0x00000000;
} // namespace LaunchContent

namespace LaunchURL {
static constexpr CommandId Id = 0x00000001;
} // namespace LaunchURL

namespace LauncherResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace LauncherResponse

} // namespace Commands
} // namespace ContentLauncher

namespace AudioOutput {
namespace Commands {

namespace SelectOutput {
static constexpr CommandId Id = 0x00000000;
} // namespace SelectOutput

namespace RenameOutput {
static constexpr CommandId Id = 0x00000001;
} // namespace RenameOutput

} // namespace Commands
} // namespace AudioOutput

namespace ApplicationLauncher {
namespace Commands {

namespace LaunchApp {
static constexpr CommandId Id = 0x00000000;
} // namespace LaunchApp

namespace StopApp {
static constexpr CommandId Id = 0x00000001;
} // namespace StopApp

namespace HideApp {
static constexpr CommandId Id = 0x00000002;
} // namespace HideApp

namespace LauncherResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace LauncherResponse

} // namespace Commands
} // namespace ApplicationLauncher

namespace AccountLogin {
namespace Commands {

namespace GetSetupPIN {
static constexpr CommandId Id = 0x00000000;
} // namespace GetSetupPIN

namespace GetSetupPINResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace GetSetupPINResponse

namespace Login {
static constexpr CommandId Id = 0x00000002;
} // namespace Login

namespace Logout {
static constexpr CommandId Id = 0x00000003;
} // namespace Logout

} // namespace Commands
} // namespace AccountLogin

namespace ContentControl {
namespace Commands {

namespace UpdatePIN {
static constexpr CommandId Id = 0x00000000;
} // namespace UpdatePIN

namespace ResetPIN {
static constexpr CommandId Id = 0x00000001;
} // namespace ResetPIN

namespace ResetPINResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace ResetPINResponse

namespace Enable {
static constexpr CommandId Id = 0x00000003;
} // namespace Enable

namespace Disable {
static constexpr CommandId Id = 0x00000004;
} // namespace Disable

namespace AddBonusTime {
static constexpr CommandId Id = 0x00000005;
} // namespace AddBonusTime

namespace SetScreenDailyTime {
static constexpr CommandId Id = 0x00000006;
} // namespace SetScreenDailyTime

namespace BlockUnratedContent {
static constexpr CommandId Id = 0x00000007;
} // namespace BlockUnratedContent

namespace UnblockUnratedContent {
static constexpr CommandId Id = 0x00000008;
} // namespace UnblockUnratedContent

namespace SetOnDemandRatingThreshold {
static constexpr CommandId Id = 0x00000009;
} // namespace SetOnDemandRatingThreshold

namespace SetScheduledContentRatingThreshold {
static constexpr CommandId Id = 0x0000000A;
} // namespace SetScheduledContentRatingThreshold

} // namespace Commands
} // namespace ContentControl

namespace ContentAppObserver {
namespace Commands {

namespace ContentAppMessage {
static constexpr CommandId Id = 0x00000000;
} // namespace ContentAppMessage

namespace ContentAppMessageResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace ContentAppMessageResponse

} // namespace Commands
} // namespace ContentAppObserver

namespace WebRTCTransportProvider {
namespace Commands {

namespace SolicitOffer {
static constexpr CommandId Id = 0x00000001;
} // namespace SolicitOffer

namespace SolicitOfferResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace SolicitOfferResponse

namespace ProvideOffer {
static constexpr CommandId Id = 0x00000003;
} // namespace ProvideOffer

namespace ProvideOfferResponse {
static constexpr CommandId Id = 0x00000004;
} // namespace ProvideOfferResponse

namespace ProvideAnswer {
static constexpr CommandId Id = 0x00000005;
} // namespace ProvideAnswer

namespace ProvideICECandidate {
static constexpr CommandId Id = 0x00000006;
} // namespace ProvideICECandidate

namespace EndSession {
static constexpr CommandId Id = 0x00000007;
} // namespace EndSession

} // namespace Commands
} // namespace WebRTCTransportProvider

namespace Chime {
namespace Commands {

namespace PlayChimeSound {
static constexpr CommandId Id = 0x00000000;
} // namespace PlayChimeSound

} // namespace Commands
} // namespace Chime

namespace CommissionerControl {
namespace Commands {

namespace RequestCommissioningApproval {
static constexpr CommandId Id = 0x00000000;
} // namespace RequestCommissioningApproval

namespace CommissionNode {
static constexpr CommandId Id = 0x00000001;
} // namespace CommissionNode

namespace ReverseOpenCommissioningWindow {
static constexpr CommandId Id = 0x00000002;
} // namespace ReverseOpenCommissioningWindow

} // namespace Commands
} // namespace CommissionerControl

namespace UnitTesting {
namespace Commands {

namespace Test {
static constexpr CommandId Id = 0x00000000;
} // namespace Test

namespace TestSpecificResponse {
static constexpr CommandId Id = 0x00000000;
} // namespace TestSpecificResponse

namespace TestNotHandled {
static constexpr CommandId Id = 0x00000001;
} // namespace TestNotHandled

namespace TestAddArgumentsResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace TestAddArgumentsResponse

namespace TestSpecific {
static constexpr CommandId Id = 0x00000002;
} // namespace TestSpecific

namespace TestSimpleArgumentResponse {
static constexpr CommandId Id = 0x00000002;
} // namespace TestSimpleArgumentResponse

namespace TestUnknownCommand {
static constexpr CommandId Id = 0x00000003;
} // namespace TestUnknownCommand

namespace TestStructArrayArgumentResponse {
static constexpr CommandId Id = 0x00000003;
} // namespace TestStructArrayArgumentResponse

namespace TestAddArguments {
static constexpr CommandId Id = 0x00000004;
} // namespace TestAddArguments

namespace TestListInt8UReverseResponse {
static constexpr CommandId Id = 0x00000004;
} // namespace TestListInt8UReverseResponse

namespace TestSimpleArgumentRequest {
static constexpr CommandId Id = 0x00000005;
} // namespace TestSimpleArgumentRequest

namespace TestEnumsResponse {
static constexpr CommandId Id = 0x00000005;
} // namespace TestEnumsResponse

namespace TestStructArrayArgumentRequest {
static constexpr CommandId Id = 0x00000006;
} // namespace TestStructArrayArgumentRequest

namespace TestNullableOptionalResponse {
static constexpr CommandId Id = 0x00000006;
} // namespace TestNullableOptionalResponse

namespace TestStructArgumentRequest {
static constexpr CommandId Id = 0x00000007;
} // namespace TestStructArgumentRequest

namespace TestComplexNullableOptionalResponse {
static constexpr CommandId Id = 0x00000007;
} // namespace TestComplexNullableOptionalResponse

namespace TestNestedStructArgumentRequest {
static constexpr CommandId Id = 0x00000008;
} // namespace TestNestedStructArgumentRequest

namespace BooleanResponse {
static constexpr CommandId Id = 0x00000008;
} // namespace BooleanResponse

namespace TestListStructArgumentRequest {
static constexpr CommandId Id = 0x00000009;
} // namespace TestListStructArgumentRequest

namespace SimpleStructResponse {
static constexpr CommandId Id = 0x00000009;
} // namespace SimpleStructResponse

namespace TestListInt8UArgumentRequest {
static constexpr CommandId Id = 0x0000000A;
} // namespace TestListInt8UArgumentRequest

namespace TestEmitTestEventResponse {
static constexpr CommandId Id = 0x0000000A;
} // namespace TestEmitTestEventResponse

namespace TestNestedStructListArgumentRequest {
static constexpr CommandId Id = 0x0000000B;
} // namespace TestNestedStructListArgumentRequest

namespace TestEmitTestFabricScopedEventResponse {
static constexpr CommandId Id = 0x0000000B;
} // namespace TestEmitTestFabricScopedEventResponse

namespace TestListNestedStructListArgumentRequest {
static constexpr CommandId Id = 0x0000000C;
} // namespace TestListNestedStructListArgumentRequest

namespace TestBatchHelperResponse {
static constexpr CommandId Id = 0x0000000C;
} // namespace TestBatchHelperResponse

namespace TestListInt8UReverseRequest {
static constexpr CommandId Id = 0x0000000D;
} // namespace TestListInt8UReverseRequest

namespace StringEchoResponse {
static constexpr CommandId Id = 0x0000000D;
} // namespace StringEchoResponse

namespace TestEnumsRequest {
static constexpr CommandId Id = 0x0000000E;
} // namespace TestEnumsRequest

namespace GlobalEchoResponse {
static constexpr CommandId Id = 0x0000000E;
} // namespace GlobalEchoResponse

namespace TestNullableOptionalRequest {
static constexpr CommandId Id = 0x0000000F;
} // namespace TestNullableOptionalRequest

namespace TestComplexNullableOptionalRequest {
static constexpr CommandId Id = 0x00000010;
} // namespace TestComplexNullableOptionalRequest

namespace SimpleStructEchoRequest {
static constexpr CommandId Id = 0x00000011;
} // namespace SimpleStructEchoRequest

namespace TimedInvokeRequest {
static constexpr CommandId Id = 0x00000012;
} // namespace TimedInvokeRequest

namespace TestSimpleOptionalArgumentRequest {
static constexpr CommandId Id = 0x00000013;
} // namespace TestSimpleOptionalArgumentRequest

namespace TestEmitTestEventRequest {
static constexpr CommandId Id = 0x00000014;
} // namespace TestEmitTestEventRequest

namespace TestEmitTestFabricScopedEventRequest {
static constexpr CommandId Id = 0x00000015;
} // namespace TestEmitTestFabricScopedEventRequest

namespace TestBatchHelperRequest {
static constexpr CommandId Id = 0x00000016;
} // namespace TestBatchHelperRequest

namespace TestSecondBatchHelperRequest {
static constexpr CommandId Id = 0x00000017;
} // namespace TestSecondBatchHelperRequest

namespace StringEchoRequest {
static constexpr CommandId Id = 0x00000018;
} // namespace StringEchoRequest

namespace GlobalEchoRequest {
static constexpr CommandId Id = 0x00000019;
} // namespace GlobalEchoRequest

namespace TestDifferentVendorMeiRequest {
static constexpr CommandId Id = 0xFFF200AA;
} // namespace TestDifferentVendorMeiRequest

namespace TestDifferentVendorMeiResponse {
static constexpr CommandId Id = 0xFFF200BB;
} // namespace TestDifferentVendorMeiResponse

} // namespace Commands
} // namespace UnitTesting

namespace FaultInjection {
namespace Commands {

namespace FailAtFault {
static constexpr CommandId Id = 0x00000000;
} // namespace FailAtFault

namespace FailRandomlyAtFault {
static constexpr CommandId Id = 0x00000001;
} // namespace FailRandomlyAtFault

} // namespace Commands
} // namespace FaultInjection

namespace SampleMei {
namespace Commands {

namespace Ping {
static constexpr CommandId Id = 0x00000000;
} // namespace Ping

namespace AddArgumentsResponse {
static constexpr CommandId Id = 0x00000001;
} // namespace AddArgumentsResponse

namespace AddArguments {
static constexpr CommandId Id = 0x00000002;
} // namespace AddArguments

} // namespace Commands
} // namespace SampleMei

} // namespace Clusters
} // namespace app
} // namespace chip
