/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** RTC_TOUCH_INT_RAW_REG register
 *  need_des
 */
#define RTC_TOUCH_INT_RAW_REG (DR_REG_LP_TOUCH_BASE + 0x0)
/** RTC_TOUCH_SCAN_DONE_INT_RAW : R/WTC/SS; bitpos: [0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_SCAN_DONE_INT_RAW    (BIT(0))
#define RTC_TOUCH_SCAN_DONE_INT_RAW_M  (RTC_TOUCH_SCAN_DONE_INT_RAW_V << RTC_TOUCH_SCAN_DONE_INT_RAW_S)
#define RTC_TOUCH_SCAN_DONE_INT_RAW_V  0x00000001U
#define RTC_TOUCH_SCAN_DONE_INT_RAW_S  0
/** RTC_TOUCH_DONE_INT_RAW : R/WTC/SS; bitpos: [1]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_DONE_INT_RAW    (BIT(1))
#define RTC_TOUCH_DONE_INT_RAW_M  (RTC_TOUCH_DONE_INT_RAW_V << RTC_TOUCH_DONE_INT_RAW_S)
#define RTC_TOUCH_DONE_INT_RAW_V  0x00000001U
#define RTC_TOUCH_DONE_INT_RAW_S  1
/** RTC_TOUCH_ACTIVE_INT_RAW : R/WTC/SS; bitpos: [2]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_ACTIVE_INT_RAW    (BIT(2))
#define RTC_TOUCH_ACTIVE_INT_RAW_M  (RTC_TOUCH_ACTIVE_INT_RAW_V << RTC_TOUCH_ACTIVE_INT_RAW_S)
#define RTC_TOUCH_ACTIVE_INT_RAW_V  0x00000001U
#define RTC_TOUCH_ACTIVE_INT_RAW_S  2
/** RTC_TOUCH_INACTIVE_INT_RAW : R/WTC/SS; bitpos: [3]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_INACTIVE_INT_RAW    (BIT(3))
#define RTC_TOUCH_INACTIVE_INT_RAW_M  (RTC_TOUCH_INACTIVE_INT_RAW_V << RTC_TOUCH_INACTIVE_INT_RAW_S)
#define RTC_TOUCH_INACTIVE_INT_RAW_V  0x00000001U
#define RTC_TOUCH_INACTIVE_INT_RAW_S  3
/** RTC_TOUCH_TIMEOUT_INT_RAW : R/WTC/SS; bitpos: [4]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_TIMEOUT_INT_RAW    (BIT(4))
#define RTC_TOUCH_TIMEOUT_INT_RAW_M  (RTC_TOUCH_TIMEOUT_INT_RAW_V << RTC_TOUCH_TIMEOUT_INT_RAW_S)
#define RTC_TOUCH_TIMEOUT_INT_RAW_V  0x00000001U
#define RTC_TOUCH_TIMEOUT_INT_RAW_S  4
/** RTC_TOUCH_APPROACH_LOOP_DONE_INT_RAW : R/WTC/SS; bitpos: [5]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_RAW    (BIT(5))
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_RAW_M  (RTC_TOUCH_APPROACH_LOOP_DONE_INT_RAW_V << RTC_TOUCH_APPROACH_LOOP_DONE_INT_RAW_S)
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_RAW_V  0x00000001U
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_RAW_S  5
/** RTC_TOUCH_BENCHMARK_UPDATE_INT_RAW : R/WTC/SS; bitpos: [6]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_RAW    (BIT(6))
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_RAW_M  (RTC_TOUCH_BENCHMARK_UPDATE_INT_RAW_V << RTC_TOUCH_BENCHMARK_UPDATE_INT_RAW_S)
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_RAW_V  0x00000001U
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_RAW_S  6

/** RTC_TOUCH_INT_ST_REG register
 *  need_des
 */
#define RTC_TOUCH_INT_ST_REG (DR_REG_LP_TOUCH_BASE + 0x4)
/** RTC_TOUCH_SCAN_DONE_INT_ST : RO; bitpos: [0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_SCAN_DONE_INT_ST    (BIT(0))
#define RTC_TOUCH_SCAN_DONE_INT_ST_M  (RTC_TOUCH_SCAN_DONE_INT_ST_V << RTC_TOUCH_SCAN_DONE_INT_ST_S)
#define RTC_TOUCH_SCAN_DONE_INT_ST_V  0x00000001U
#define RTC_TOUCH_SCAN_DONE_INT_ST_S  0
/** RTC_TOUCH_DONE_INT_ST : RO; bitpos: [1]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_DONE_INT_ST    (BIT(1))
#define RTC_TOUCH_DONE_INT_ST_M  (RTC_TOUCH_DONE_INT_ST_V << RTC_TOUCH_DONE_INT_ST_S)
#define RTC_TOUCH_DONE_INT_ST_V  0x00000001U
#define RTC_TOUCH_DONE_INT_ST_S  1
/** RTC_TOUCH_ACTIVE_INT_ST : RO; bitpos: [2]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_ACTIVE_INT_ST    (BIT(2))
#define RTC_TOUCH_ACTIVE_INT_ST_M  (RTC_TOUCH_ACTIVE_INT_ST_V << RTC_TOUCH_ACTIVE_INT_ST_S)
#define RTC_TOUCH_ACTIVE_INT_ST_V  0x00000001U
#define RTC_TOUCH_ACTIVE_INT_ST_S  2
/** RTC_TOUCH_INACTIVE_INT_ST : RO; bitpos: [3]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_INACTIVE_INT_ST    (BIT(3))
#define RTC_TOUCH_INACTIVE_INT_ST_M  (RTC_TOUCH_INACTIVE_INT_ST_V << RTC_TOUCH_INACTIVE_INT_ST_S)
#define RTC_TOUCH_INACTIVE_INT_ST_V  0x00000001U
#define RTC_TOUCH_INACTIVE_INT_ST_S  3
/** RTC_TOUCH_TIMEOUT_INT_ST : RO; bitpos: [4]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_TIMEOUT_INT_ST    (BIT(4))
#define RTC_TOUCH_TIMEOUT_INT_ST_M  (RTC_TOUCH_TIMEOUT_INT_ST_V << RTC_TOUCH_TIMEOUT_INT_ST_S)
#define RTC_TOUCH_TIMEOUT_INT_ST_V  0x00000001U
#define RTC_TOUCH_TIMEOUT_INT_ST_S  4
/** RTC_TOUCH_APPROACH_LOOP_DONE_INT_ST : RO; bitpos: [5]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_ST    (BIT(5))
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_ST_M  (RTC_TOUCH_APPROACH_LOOP_DONE_INT_ST_V << RTC_TOUCH_APPROACH_LOOP_DONE_INT_ST_S)
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_ST_V  0x00000001U
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_ST_S  5
/** RTC_TOUCH_BENCHMARK_UPDATE_INT_ST : RO; bitpos: [6]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_ST    (BIT(6))
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_ST_M  (RTC_TOUCH_BENCHMARK_UPDATE_INT_ST_V << RTC_TOUCH_BENCHMARK_UPDATE_INT_ST_S)
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_ST_V  0x00000001U
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_ST_S  6

/** RTC_TOUCH_INT_ENA_REG register
 *  need_des
 */
#define RTC_TOUCH_INT_ENA_REG (DR_REG_LP_TOUCH_BASE + 0x8)
/** RTC_TOUCH_SCAN_DONE_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_SCAN_DONE_INT_ENA    (BIT(0))
#define RTC_TOUCH_SCAN_DONE_INT_ENA_M  (RTC_TOUCH_SCAN_DONE_INT_ENA_V << RTC_TOUCH_SCAN_DONE_INT_ENA_S)
#define RTC_TOUCH_SCAN_DONE_INT_ENA_V  0x00000001U
#define RTC_TOUCH_SCAN_DONE_INT_ENA_S  0
/** RTC_TOUCH_DONE_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_DONE_INT_ENA    (BIT(1))
#define RTC_TOUCH_DONE_INT_ENA_M  (RTC_TOUCH_DONE_INT_ENA_V << RTC_TOUCH_DONE_INT_ENA_S)
#define RTC_TOUCH_DONE_INT_ENA_V  0x00000001U
#define RTC_TOUCH_DONE_INT_ENA_S  1
/** RTC_TOUCH_ACTIVE_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_ACTIVE_INT_ENA    (BIT(2))
#define RTC_TOUCH_ACTIVE_INT_ENA_M  (RTC_TOUCH_ACTIVE_INT_ENA_V << RTC_TOUCH_ACTIVE_INT_ENA_S)
#define RTC_TOUCH_ACTIVE_INT_ENA_V  0x00000001U
#define RTC_TOUCH_ACTIVE_INT_ENA_S  2
/** RTC_TOUCH_INACTIVE_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_INACTIVE_INT_ENA    (BIT(3))
#define RTC_TOUCH_INACTIVE_INT_ENA_M  (RTC_TOUCH_INACTIVE_INT_ENA_V << RTC_TOUCH_INACTIVE_INT_ENA_S)
#define RTC_TOUCH_INACTIVE_INT_ENA_V  0x00000001U
#define RTC_TOUCH_INACTIVE_INT_ENA_S  3
/** RTC_TOUCH_TIMEOUT_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_TIMEOUT_INT_ENA    (BIT(4))
#define RTC_TOUCH_TIMEOUT_INT_ENA_M  (RTC_TOUCH_TIMEOUT_INT_ENA_V << RTC_TOUCH_TIMEOUT_INT_ENA_S)
#define RTC_TOUCH_TIMEOUT_INT_ENA_V  0x00000001U
#define RTC_TOUCH_TIMEOUT_INT_ENA_S  4
/** RTC_TOUCH_APPROACH_LOOP_DONE_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_ENA    (BIT(5))
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_ENA_M  (RTC_TOUCH_APPROACH_LOOP_DONE_INT_ENA_V << RTC_TOUCH_APPROACH_LOOP_DONE_INT_ENA_S)
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_ENA_V  0x00000001U
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_ENA_S  5
/** RTC_TOUCH_BENCHMARK_UPDATE_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_ENA    (BIT(6))
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_ENA_M  (RTC_TOUCH_BENCHMARK_UPDATE_INT_ENA_V << RTC_TOUCH_BENCHMARK_UPDATE_INT_ENA_S)
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_ENA_V  0x00000001U
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_ENA_S  6

/** RTC_TOUCH_INT_CLR_REG register
 *  need_des
 */
#define RTC_TOUCH_INT_CLR_REG (DR_REG_LP_TOUCH_BASE + 0xc)
/** RTC_TOUCH_SCAN_DONE_INT_CLR : WT; bitpos: [0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_SCAN_DONE_INT_CLR    (BIT(0))
#define RTC_TOUCH_SCAN_DONE_INT_CLR_M  (RTC_TOUCH_SCAN_DONE_INT_CLR_V << RTC_TOUCH_SCAN_DONE_INT_CLR_S)
#define RTC_TOUCH_SCAN_DONE_INT_CLR_V  0x00000001U
#define RTC_TOUCH_SCAN_DONE_INT_CLR_S  0
/** RTC_TOUCH_DONE_INT_CLR : WT; bitpos: [1]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_DONE_INT_CLR    (BIT(1))
#define RTC_TOUCH_DONE_INT_CLR_M  (RTC_TOUCH_DONE_INT_CLR_V << RTC_TOUCH_DONE_INT_CLR_S)
#define RTC_TOUCH_DONE_INT_CLR_V  0x00000001U
#define RTC_TOUCH_DONE_INT_CLR_S  1
/** RTC_TOUCH_ACTIVE_INT_CLR : WT; bitpos: [2]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_ACTIVE_INT_CLR    (BIT(2))
#define RTC_TOUCH_ACTIVE_INT_CLR_M  (RTC_TOUCH_ACTIVE_INT_CLR_V << RTC_TOUCH_ACTIVE_INT_CLR_S)
#define RTC_TOUCH_ACTIVE_INT_CLR_V  0x00000001U
#define RTC_TOUCH_ACTIVE_INT_CLR_S  2
/** RTC_TOUCH_INACTIVE_INT_CLR : WT; bitpos: [3]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_INACTIVE_INT_CLR    (BIT(3))
#define RTC_TOUCH_INACTIVE_INT_CLR_M  (RTC_TOUCH_INACTIVE_INT_CLR_V << RTC_TOUCH_INACTIVE_INT_CLR_S)
#define RTC_TOUCH_INACTIVE_INT_CLR_V  0x00000001U
#define RTC_TOUCH_INACTIVE_INT_CLR_S  3
/** RTC_TOUCH_TIMEOUT_INT_CLR : WT; bitpos: [4]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_TIMEOUT_INT_CLR    (BIT(4))
#define RTC_TOUCH_TIMEOUT_INT_CLR_M  (RTC_TOUCH_TIMEOUT_INT_CLR_V << RTC_TOUCH_TIMEOUT_INT_CLR_S)
#define RTC_TOUCH_TIMEOUT_INT_CLR_V  0x00000001U
#define RTC_TOUCH_TIMEOUT_INT_CLR_S  4
/** RTC_TOUCH_APPROACH_LOOP_DONE_INT_CLR : WT; bitpos: [5]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_CLR    (BIT(5))
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_CLR_M  (RTC_TOUCH_APPROACH_LOOP_DONE_INT_CLR_V << RTC_TOUCH_APPROACH_LOOP_DONE_INT_CLR_S)
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_CLR_V  0x00000001U
#define RTC_TOUCH_APPROACH_LOOP_DONE_INT_CLR_S  5
/** RTC_TOUCH_BENCHMARK_UPDATE_INT_CLR : WT; bitpos: [6]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_CLR    (BIT(6))
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_CLR_M  (RTC_TOUCH_BENCHMARK_UPDATE_INT_CLR_V << RTC_TOUCH_BENCHMARK_UPDATE_INT_CLR_S)
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_CLR_V  0x00000001U
#define RTC_TOUCH_BENCHMARK_UPDATE_INT_CLR_S  6

/** RTC_TOUCH_CHN_STATUS_REG register
 *  need_des
 */
#define RTC_TOUCH_CHN_STATUS_REG (DR_REG_LP_TOUCH_BASE + 0x10)
/** RTC_TOUCH_PAD_ACTIVE : RO; bitpos: [14:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD_ACTIVE    0x00007FFFU
#define RTC_TOUCH_PAD_ACTIVE_M  (RTC_TOUCH_PAD_ACTIVE_V << RTC_TOUCH_PAD_ACTIVE_S)
#define RTC_TOUCH_PAD_ACTIVE_V  0x00007FFFU
#define RTC_TOUCH_PAD_ACTIVE_S  0
/** RTC_TOUCH_MEAS_DONE : RO; bitpos: [15]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_MEAS_DONE    (BIT(15))
#define RTC_TOUCH_MEAS_DONE_M  (RTC_TOUCH_MEAS_DONE_V << RTC_TOUCH_MEAS_DONE_S)
#define RTC_TOUCH_MEAS_DONE_V  0x00000001U
#define RTC_TOUCH_MEAS_DONE_S  15
/** RTC_TOUCH_SCAN_CURR : RO; bitpos: [19:16]; default: 15;
 *  need_des
 */
#define RTC_TOUCH_SCAN_CURR    0x0000000FU
#define RTC_TOUCH_SCAN_CURR_M  (RTC_TOUCH_SCAN_CURR_V << RTC_TOUCH_SCAN_CURR_S)
#define RTC_TOUCH_SCAN_CURR_V  0x0000000FU
#define RTC_TOUCH_SCAN_CURR_S  16

/** RTC_TOUCH_STATUS_0_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_0_REG (DR_REG_LP_TOUCH_BASE + 0x14)
/** RTC_TOUCH_PAD0_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD0_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD0_DATA_M  (RTC_TOUCH_PAD0_DATA_V << RTC_TOUCH_PAD0_DATA_S)
#define RTC_TOUCH_PAD0_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD0_DATA_S  0
/** RTC_TOUCH_PAD0_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD0_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD0_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD0_DEBOUNCE_CNT_V << RTC_TOUCH_PAD0_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD0_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD0_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD0_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD0_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD0_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD0_NEG_NOISE_CNT_V << RTC_TOUCH_PAD0_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD0_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD0_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_1_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_1_REG (DR_REG_LP_TOUCH_BASE + 0x18)
/** RTC_TOUCH_PAD1_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD1_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD1_DATA_M  (RTC_TOUCH_PAD1_DATA_V << RTC_TOUCH_PAD1_DATA_S)
#define RTC_TOUCH_PAD1_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD1_DATA_S  0
/** RTC_TOUCH_PAD1_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD1_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD1_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD1_DEBOUNCE_CNT_V << RTC_TOUCH_PAD1_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD1_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD1_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD1_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD1_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD1_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD1_NEG_NOISE_CNT_V << RTC_TOUCH_PAD1_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD1_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD1_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_2_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_2_REG (DR_REG_LP_TOUCH_BASE + 0x1c)
/** RTC_TOUCH_PAD2_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD2_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD2_DATA_M  (RTC_TOUCH_PAD2_DATA_V << RTC_TOUCH_PAD2_DATA_S)
#define RTC_TOUCH_PAD2_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD2_DATA_S  0
/** RTC_TOUCH_PAD2_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD2_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD2_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD2_DEBOUNCE_CNT_V << RTC_TOUCH_PAD2_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD2_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD2_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD2_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD2_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD2_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD2_NEG_NOISE_CNT_V << RTC_TOUCH_PAD2_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD2_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD2_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_3_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_3_REG (DR_REG_LP_TOUCH_BASE + 0x20)
/** RTC_TOUCH_PAD3_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD3_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD3_DATA_M  (RTC_TOUCH_PAD3_DATA_V << RTC_TOUCH_PAD3_DATA_S)
#define RTC_TOUCH_PAD3_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD3_DATA_S  0
/** RTC_TOUCH_PAD3_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD3_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD3_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD3_DEBOUNCE_CNT_V << RTC_TOUCH_PAD3_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD3_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD3_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD3_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD3_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD3_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD3_NEG_NOISE_CNT_V << RTC_TOUCH_PAD3_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD3_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD3_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_4_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_4_REG (DR_REG_LP_TOUCH_BASE + 0x24)
/** RTC_TOUCH_PAD4_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD4_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD4_DATA_M  (RTC_TOUCH_PAD4_DATA_V << RTC_TOUCH_PAD4_DATA_S)
#define RTC_TOUCH_PAD4_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD4_DATA_S  0
/** RTC_TOUCH_PAD4_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD4_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD4_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD4_DEBOUNCE_CNT_V << RTC_TOUCH_PAD4_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD4_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD4_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD4_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD4_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD4_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD4_NEG_NOISE_CNT_V << RTC_TOUCH_PAD4_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD4_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD4_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_5_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_5_REG (DR_REG_LP_TOUCH_BASE + 0x28)
/** RTC_TOUCH_PAD5_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD5_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD5_DATA_M  (RTC_TOUCH_PAD5_DATA_V << RTC_TOUCH_PAD5_DATA_S)
#define RTC_TOUCH_PAD5_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD5_DATA_S  0
/** RTC_TOUCH_PAD5_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD5_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD5_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD5_DEBOUNCE_CNT_V << RTC_TOUCH_PAD5_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD5_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD5_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD5_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD5_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD5_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD5_NEG_NOISE_CNT_V << RTC_TOUCH_PAD5_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD5_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD5_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_6_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_6_REG (DR_REG_LP_TOUCH_BASE + 0x2c)
/** RTC_TOUCH_PAD6_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD6_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD6_DATA_M  (RTC_TOUCH_PAD6_DATA_V << RTC_TOUCH_PAD6_DATA_S)
#define RTC_TOUCH_PAD6_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD6_DATA_S  0
/** RTC_TOUCH_PAD6_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD6_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD6_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD6_DEBOUNCE_CNT_V << RTC_TOUCH_PAD6_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD6_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD6_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD6_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD6_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD6_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD6_NEG_NOISE_CNT_V << RTC_TOUCH_PAD6_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD6_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD6_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_7_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_7_REG (DR_REG_LP_TOUCH_BASE + 0x30)
/** RTC_TOUCH_PAD7_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD7_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD7_DATA_M  (RTC_TOUCH_PAD7_DATA_V << RTC_TOUCH_PAD7_DATA_S)
#define RTC_TOUCH_PAD7_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD7_DATA_S  0
/** RTC_TOUCH_PAD7_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD7_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD7_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD7_DEBOUNCE_CNT_V << RTC_TOUCH_PAD7_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD7_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD7_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD7_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD7_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD7_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD7_NEG_NOISE_CNT_V << RTC_TOUCH_PAD7_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD7_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD7_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_8_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_8_REG (DR_REG_LP_TOUCH_BASE + 0x34)
/** RTC_TOUCH_PAD8_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD8_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD8_DATA_M  (RTC_TOUCH_PAD8_DATA_V << RTC_TOUCH_PAD8_DATA_S)
#define RTC_TOUCH_PAD8_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD8_DATA_S  0
/** RTC_TOUCH_PAD8_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD8_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD8_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD8_DEBOUNCE_CNT_V << RTC_TOUCH_PAD8_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD8_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD8_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD8_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD8_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD8_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD8_NEG_NOISE_CNT_V << RTC_TOUCH_PAD8_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD8_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD8_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_9_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_9_REG (DR_REG_LP_TOUCH_BASE + 0x38)
/** RTC_TOUCH_PAD9_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD9_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD9_DATA_M  (RTC_TOUCH_PAD9_DATA_V << RTC_TOUCH_PAD9_DATA_S)
#define RTC_TOUCH_PAD9_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD9_DATA_S  0
/** RTC_TOUCH_PAD9_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD9_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD9_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD9_DEBOUNCE_CNT_V << RTC_TOUCH_PAD9_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD9_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD9_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD9_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD9_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD9_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD9_NEG_NOISE_CNT_V << RTC_TOUCH_PAD9_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD9_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD9_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_10_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_10_REG (DR_REG_LP_TOUCH_BASE + 0x3c)
/** RTC_TOUCH_PAD10_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD10_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD10_DATA_M  (RTC_TOUCH_PAD10_DATA_V << RTC_TOUCH_PAD10_DATA_S)
#define RTC_TOUCH_PAD10_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD10_DATA_S  0
/** RTC_TOUCH_PAD10_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD10_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD10_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD10_DEBOUNCE_CNT_V << RTC_TOUCH_PAD10_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD10_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD10_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD10_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD10_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD10_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD10_NEG_NOISE_CNT_V << RTC_TOUCH_PAD10_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD10_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD10_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_11_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_11_REG (DR_REG_LP_TOUCH_BASE + 0x40)
/** RTC_TOUCH_PAD11_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD11_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD11_DATA_M  (RTC_TOUCH_PAD11_DATA_V << RTC_TOUCH_PAD11_DATA_S)
#define RTC_TOUCH_PAD11_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD11_DATA_S  0
/** RTC_TOUCH_PAD11_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD11_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD11_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD11_DEBOUNCE_CNT_V << RTC_TOUCH_PAD11_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD11_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD11_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD11_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD11_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD11_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD11_NEG_NOISE_CNT_V << RTC_TOUCH_PAD11_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD11_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD11_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_12_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_12_REG (DR_REG_LP_TOUCH_BASE + 0x44)
/** RTC_TOUCH_PAD12_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD12_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD12_DATA_M  (RTC_TOUCH_PAD12_DATA_V << RTC_TOUCH_PAD12_DATA_S)
#define RTC_TOUCH_PAD12_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD12_DATA_S  0
/** RTC_TOUCH_PAD12_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD12_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD12_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD12_DEBOUNCE_CNT_V << RTC_TOUCH_PAD12_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD12_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD12_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD12_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD12_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD12_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD12_NEG_NOISE_CNT_V << RTC_TOUCH_PAD12_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD12_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD12_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_13_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_13_REG (DR_REG_LP_TOUCH_BASE + 0x48)
/** RTC_TOUCH_PAD13_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD13_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD13_DATA_M  (RTC_TOUCH_PAD13_DATA_V << RTC_TOUCH_PAD13_DATA_S)
#define RTC_TOUCH_PAD13_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD13_DATA_S  0
/** RTC_TOUCH_PAD13_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD13_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD13_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD13_DEBOUNCE_CNT_V << RTC_TOUCH_PAD13_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD13_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD13_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD13_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD13_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD13_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD13_NEG_NOISE_CNT_V << RTC_TOUCH_PAD13_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD13_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD13_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_14_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_14_REG (DR_REG_LP_TOUCH_BASE + 0x4c)
/** RTC_TOUCH_PAD14_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD14_DATA    0x0000FFFFU
#define RTC_TOUCH_PAD14_DATA_M  (RTC_TOUCH_PAD14_DATA_V << RTC_TOUCH_PAD14_DATA_S)
#define RTC_TOUCH_PAD14_DATA_V  0x0000FFFFU
#define RTC_TOUCH_PAD14_DATA_S  0
/** RTC_TOUCH_PAD14_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD14_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_PAD14_DEBOUNCE_CNT_M  (RTC_TOUCH_PAD14_DEBOUNCE_CNT_V << RTC_TOUCH_PAD14_DEBOUNCE_CNT_S)
#define RTC_TOUCH_PAD14_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_PAD14_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_PAD14_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD14_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_PAD14_NEG_NOISE_CNT_M  (RTC_TOUCH_PAD14_NEG_NOISE_CNT_V << RTC_TOUCH_PAD14_NEG_NOISE_CNT_S)
#define RTC_TOUCH_PAD14_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_PAD14_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_15_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_15_REG (DR_REG_LP_TOUCH_BASE + 0x50)
/** RTC_TOUCH_SLP_DATA : RO; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_SLP_DATA    0x0000FFFFU
#define RTC_TOUCH_SLP_DATA_M  (RTC_TOUCH_SLP_DATA_V << RTC_TOUCH_SLP_DATA_S)
#define RTC_TOUCH_SLP_DATA_V  0x0000FFFFU
#define RTC_TOUCH_SLP_DATA_S  0
/** RTC_TOUCH_SLP_DEBOUNCE_CNT : RO; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_SLP_DEBOUNCE_CNT    0x00000007U
#define RTC_TOUCH_SLP_DEBOUNCE_CNT_M  (RTC_TOUCH_SLP_DEBOUNCE_CNT_V << RTC_TOUCH_SLP_DEBOUNCE_CNT_S)
#define RTC_TOUCH_SLP_DEBOUNCE_CNT_V  0x00000007U
#define RTC_TOUCH_SLP_DEBOUNCE_CNT_S  16
/** RTC_TOUCH_SLP_NEG_NOISE_CNT : RO; bitpos: [22:19]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_SLP_NEG_NOISE_CNT    0x0000000FU
#define RTC_TOUCH_SLP_NEG_NOISE_CNT_M  (RTC_TOUCH_SLP_NEG_NOISE_CNT_V << RTC_TOUCH_SLP_NEG_NOISE_CNT_S)
#define RTC_TOUCH_SLP_NEG_NOISE_CNT_V  0x0000000FU
#define RTC_TOUCH_SLP_NEG_NOISE_CNT_S  19

/** RTC_TOUCH_STATUS_16_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_16_REG (DR_REG_LP_TOUCH_BASE + 0x54)
/** RTC_TOUCH_APPROACH_PAD2_CNT : RO; bitpos: [7:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_APPROACH_PAD2_CNT    0x000000FFU
#define RTC_TOUCH_APPROACH_PAD2_CNT_M  (RTC_TOUCH_APPROACH_PAD2_CNT_V << RTC_TOUCH_APPROACH_PAD2_CNT_S)
#define RTC_TOUCH_APPROACH_PAD2_CNT_V  0x000000FFU
#define RTC_TOUCH_APPROACH_PAD2_CNT_S  0
/** RTC_TOUCH_APPROACH_PAD1_CNT : RO; bitpos: [15:8]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_APPROACH_PAD1_CNT    0x000000FFU
#define RTC_TOUCH_APPROACH_PAD1_CNT_M  (RTC_TOUCH_APPROACH_PAD1_CNT_V << RTC_TOUCH_APPROACH_PAD1_CNT_S)
#define RTC_TOUCH_APPROACH_PAD1_CNT_V  0x000000FFU
#define RTC_TOUCH_APPROACH_PAD1_CNT_S  8
/** RTC_TOUCH_APPROACH_PAD0_CNT : RO; bitpos: [23:16]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_APPROACH_PAD0_CNT    0x000000FFU
#define RTC_TOUCH_APPROACH_PAD0_CNT_M  (RTC_TOUCH_APPROACH_PAD0_CNT_V << RTC_TOUCH_APPROACH_PAD0_CNT_S)
#define RTC_TOUCH_APPROACH_PAD0_CNT_V  0x000000FFU
#define RTC_TOUCH_APPROACH_PAD0_CNT_S  16
/** RTC_TOUCH_SLP_APPROACH_CNT : RO; bitpos: [31:24]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_SLP_APPROACH_CNT    0x000000FFU
#define RTC_TOUCH_SLP_APPROACH_CNT_M  (RTC_TOUCH_SLP_APPROACH_CNT_V << RTC_TOUCH_SLP_APPROACH_CNT_S)
#define RTC_TOUCH_SLP_APPROACH_CNT_V  0x000000FFU
#define RTC_TOUCH_SLP_APPROACH_CNT_S  24

/** RTC_TOUCH_STATUS_17_REG register
 *  need_des
 */
#define RTC_TOUCH_STATUS_17_REG (DR_REG_LP_TOUCH_BASE + 0x58)
/** RTC_TOUCH_DCAP_LPF : RO; bitpos: [6:0]; default: 0;
 *  Reserved
 */
#define RTC_TOUCH_DCAP_LPF    0x0000007FU
#define RTC_TOUCH_DCAP_LPF_M  (RTC_TOUCH_DCAP_LPF_V << RTC_TOUCH_DCAP_LPF_S)
#define RTC_TOUCH_DCAP_LPF_V  0x0000007FU
#define RTC_TOUCH_DCAP_LPF_S  0
/** RTC_TOUCH_DRES_LPF : RO; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_DRES_LPF    0x00000003U
#define RTC_TOUCH_DRES_LPF_M  (RTC_TOUCH_DRES_LPF_V << RTC_TOUCH_DRES_LPF_S)
#define RTC_TOUCH_DRES_LPF_V  0x00000003U
#define RTC_TOUCH_DRES_LPF_S  7
/** RTC_TOUCH_DRV_LS : RO; bitpos: [12:9]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_DRV_LS    0x0000000FU
#define RTC_TOUCH_DRV_LS_M  (RTC_TOUCH_DRV_LS_V << RTC_TOUCH_DRV_LS_S)
#define RTC_TOUCH_DRV_LS_V  0x0000000FU
#define RTC_TOUCH_DRV_LS_S  9
/** RTC_TOUCH_DRV_HS : RO; bitpos: [17:13]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_DRV_HS    0x0000001FU
#define RTC_TOUCH_DRV_HS_M  (RTC_TOUCH_DRV_HS_V << RTC_TOUCH_DRV_HS_S)
#define RTC_TOUCH_DRV_HS_V  0x0000001FU
#define RTC_TOUCH_DRV_HS_S  13
/** RTC_TOUCH_DBIAS : RO; bitpos: [22:18]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_DBIAS    0x0000001FU
#define RTC_TOUCH_DBIAS_M  (RTC_TOUCH_DBIAS_V << RTC_TOUCH_DBIAS_S)
#define RTC_TOUCH_DBIAS_V  0x0000001FU
#define RTC_TOUCH_DBIAS_S  18
/** RTC_TOUCH_FREQ_SCAN_CNT : RO; bitpos: [24:23]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_FREQ_SCAN_CNT    0x00000003U
#define RTC_TOUCH_FREQ_SCAN_CNT_M  (RTC_TOUCH_FREQ_SCAN_CNT_V << RTC_TOUCH_FREQ_SCAN_CNT_S)
#define RTC_TOUCH_FREQ_SCAN_CNT_V  0x00000003U
#define RTC_TOUCH_FREQ_SCAN_CNT_S  23

/** RTC_TOUCH_CHN_TMP_STATUS_REG register
 *  need_des
 */
#define RTC_TOUCH_CHN_TMP_STATUS_REG (DR_REG_LP_TOUCH_BASE + 0x5c)
/** RTC_TOUCH_PAD_INACTIVE_STATUS : RO; bitpos: [14:0]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD_INACTIVE_STATUS    0x00007FFFU
#define RTC_TOUCH_PAD_INACTIVE_STATUS_M  (RTC_TOUCH_PAD_INACTIVE_STATUS_V << RTC_TOUCH_PAD_INACTIVE_STATUS_S)
#define RTC_TOUCH_PAD_INACTIVE_STATUS_V  0x00007FFFU
#define RTC_TOUCH_PAD_INACTIVE_STATUS_S  0
/** RTC_TOUCH_PAD_ACTIVE_STATUS : RO; bitpos: [29:15]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_PAD_ACTIVE_STATUS    0x00007FFFU
#define RTC_TOUCH_PAD_ACTIVE_STATUS_M  (RTC_TOUCH_PAD_ACTIVE_STATUS_V << RTC_TOUCH_PAD_ACTIVE_STATUS_S)
#define RTC_TOUCH_PAD_ACTIVE_STATUS_V  0x00007FFFU
#define RTC_TOUCH_PAD_ACTIVE_STATUS_S  15

/** RTC_TOUCH_DATE_REG register
 *  need_des
 */
#define RTC_TOUCH_DATE_REG (DR_REG_LP_TOUCH_BASE + 0x100)
/** RTC_TOUCH_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define RTC_TOUCH_CLK_EN    (BIT(31))
#define RTC_TOUCH_CLK_EN_M  (RTC_TOUCH_CLK_EN_V << RTC_TOUCH_CLK_EN_S)
#define RTC_TOUCH_CLK_EN_V  0x00000001U
#define RTC_TOUCH_CLK_EN_S  31

#ifdef __cplusplus
}
#endif
