/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** TEE_PMS_DATE_REG register
 *  NA
 */
#define TEE_PMS_DATE_REG (DR_REG_TEE_BASE + 0x0)
/** TEE_TEE_DATE : R/W; bitpos: [31:0]; default: 2363943;
 *  NA
 */
#define TEE_TEE_DATE    0xFFFFFFFFU
#define TEE_TEE_DATE_M  (TEE_TEE_DATE_V << TEE_TEE_DATE_S)
#define TEE_TEE_DATE_V  0xFFFFFFFFU
#define TEE_TEE_DATE_S  0

/** TEE_PMS_CLK_EN_REG register
 *  NA
 */
#define TEE_PMS_CLK_EN_REG (DR_REG_TEE_BASE + 0x4)
/** TEE_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define TEE_REG_CLK_EN    (BIT(0))
#define TEE_REG_CLK_EN_M  (TEE_REG_CLK_EN_V << TEE_REG_CLK_EN_S)
#define TEE_REG_CLK_EN_V  0x00000001U
#define TEE_REG_CLK_EN_S  0

/** TEE_LP_MM_PMS_REG0_REG register
 *  NA
 */
#define TEE_LP_MM_PMS_REG0_REG (DR_REG_TEE_BASE + 0x8)
/** TEE_REG_LP_MM_LP_SYSREG_ALLOW : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_SYSREG_ALLOW    (BIT(0))
#define TEE_REG_LP_MM_LP_SYSREG_ALLOW_M  (TEE_REG_LP_MM_LP_SYSREG_ALLOW_V << TEE_REG_LP_MM_LP_SYSREG_ALLOW_S)
#define TEE_REG_LP_MM_LP_SYSREG_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_SYSREG_ALLOW_S  0
/** TEE_REG_LP_MM_LP_AONCLKRST_ALLOW : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_AONCLKRST_ALLOW    (BIT(1))
#define TEE_REG_LP_MM_LP_AONCLKRST_ALLOW_M  (TEE_REG_LP_MM_LP_AONCLKRST_ALLOW_V << TEE_REG_LP_MM_LP_AONCLKRST_ALLOW_S)
#define TEE_REG_LP_MM_LP_AONCLKRST_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_AONCLKRST_ALLOW_S  1
/** TEE_REG_LP_MM_LP_TIMER_ALLOW : R/W; bitpos: [2]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_TIMER_ALLOW    (BIT(2))
#define TEE_REG_LP_MM_LP_TIMER_ALLOW_M  (TEE_REG_LP_MM_LP_TIMER_ALLOW_V << TEE_REG_LP_MM_LP_TIMER_ALLOW_S)
#define TEE_REG_LP_MM_LP_TIMER_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_TIMER_ALLOW_S  2
/** TEE_REG_LP_MM_LP_ANAPERI_ALLOW : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_ANAPERI_ALLOW    (BIT(3))
#define TEE_REG_LP_MM_LP_ANAPERI_ALLOW_M  (TEE_REG_LP_MM_LP_ANAPERI_ALLOW_V << TEE_REG_LP_MM_LP_ANAPERI_ALLOW_S)
#define TEE_REG_LP_MM_LP_ANAPERI_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_ANAPERI_ALLOW_S  3
/** TEE_REG_LP_MM_LP_PMU_ALLOW : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_PMU_ALLOW    (BIT(4))
#define TEE_REG_LP_MM_LP_PMU_ALLOW_M  (TEE_REG_LP_MM_LP_PMU_ALLOW_V << TEE_REG_LP_MM_LP_PMU_ALLOW_S)
#define TEE_REG_LP_MM_LP_PMU_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_PMU_ALLOW_S  4
/** TEE_REG_LP_MM_LP_WDT_ALLOW : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_WDT_ALLOW    (BIT(5))
#define TEE_REG_LP_MM_LP_WDT_ALLOW_M  (TEE_REG_LP_MM_LP_WDT_ALLOW_V << TEE_REG_LP_MM_LP_WDT_ALLOW_S)
#define TEE_REG_LP_MM_LP_WDT_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_WDT_ALLOW_S  5
/** TEE_REG_LP_MM_LP_MAILBOX_ALLOW : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_MAILBOX_ALLOW    (BIT(6))
#define TEE_REG_LP_MM_LP_MAILBOX_ALLOW_M  (TEE_REG_LP_MM_LP_MAILBOX_ALLOW_V << TEE_REG_LP_MM_LP_MAILBOX_ALLOW_S)
#define TEE_REG_LP_MM_LP_MAILBOX_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_MAILBOX_ALLOW_S  6
/** TEE_REG_LP_MM_LP_RTC_ALLOW : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_RTC_ALLOW    (BIT(7))
#define TEE_REG_LP_MM_LP_RTC_ALLOW_M  (TEE_REG_LP_MM_LP_RTC_ALLOW_V << TEE_REG_LP_MM_LP_RTC_ALLOW_S)
#define TEE_REG_LP_MM_LP_RTC_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_RTC_ALLOW_S  7
/** TEE_REG_LP_MM_LP_PERICLKRST_ALLOW : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_PERICLKRST_ALLOW    (BIT(8))
#define TEE_REG_LP_MM_LP_PERICLKRST_ALLOW_M  (TEE_REG_LP_MM_LP_PERICLKRST_ALLOW_V << TEE_REG_LP_MM_LP_PERICLKRST_ALLOW_S)
#define TEE_REG_LP_MM_LP_PERICLKRST_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_PERICLKRST_ALLOW_S  8
/** TEE_REG_LP_MM_LP_UART_ALLOW : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_UART_ALLOW    (BIT(9))
#define TEE_REG_LP_MM_LP_UART_ALLOW_M  (TEE_REG_LP_MM_LP_UART_ALLOW_V << TEE_REG_LP_MM_LP_UART_ALLOW_S)
#define TEE_REG_LP_MM_LP_UART_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_UART_ALLOW_S  9
/** TEE_REG_LP_MM_LP_I2C_ALLOW : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_I2C_ALLOW    (BIT(10))
#define TEE_REG_LP_MM_LP_I2C_ALLOW_M  (TEE_REG_LP_MM_LP_I2C_ALLOW_V << TEE_REG_LP_MM_LP_I2C_ALLOW_S)
#define TEE_REG_LP_MM_LP_I2C_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_I2C_ALLOW_S  10
/** TEE_REG_LP_MM_LP_SPI_ALLOW : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_SPI_ALLOW    (BIT(11))
#define TEE_REG_LP_MM_LP_SPI_ALLOW_M  (TEE_REG_LP_MM_LP_SPI_ALLOW_V << TEE_REG_LP_MM_LP_SPI_ALLOW_S)
#define TEE_REG_LP_MM_LP_SPI_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_SPI_ALLOW_S  11
/** TEE_REG_LP_MM_LP_I2CMST_ALLOW : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_I2CMST_ALLOW    (BIT(12))
#define TEE_REG_LP_MM_LP_I2CMST_ALLOW_M  (TEE_REG_LP_MM_LP_I2CMST_ALLOW_V << TEE_REG_LP_MM_LP_I2CMST_ALLOW_S)
#define TEE_REG_LP_MM_LP_I2CMST_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_I2CMST_ALLOW_S  12
/** TEE_REG_LP_MM_LP_I2S_ALLOW : R/W; bitpos: [13]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_I2S_ALLOW    (BIT(13))
#define TEE_REG_LP_MM_LP_I2S_ALLOW_M  (TEE_REG_LP_MM_LP_I2S_ALLOW_V << TEE_REG_LP_MM_LP_I2S_ALLOW_S)
#define TEE_REG_LP_MM_LP_I2S_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_I2S_ALLOW_S  13
/** TEE_REG_LP_MM_LP_ADC_ALLOW : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_ADC_ALLOW    (BIT(14))
#define TEE_REG_LP_MM_LP_ADC_ALLOW_M  (TEE_REG_LP_MM_LP_ADC_ALLOW_V << TEE_REG_LP_MM_LP_ADC_ALLOW_S)
#define TEE_REG_LP_MM_LP_ADC_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_ADC_ALLOW_S  14
/** TEE_REG_LP_MM_LP_TOUCH_ALLOW : R/W; bitpos: [15]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_TOUCH_ALLOW    (BIT(15))
#define TEE_REG_LP_MM_LP_TOUCH_ALLOW_M  (TEE_REG_LP_MM_LP_TOUCH_ALLOW_V << TEE_REG_LP_MM_LP_TOUCH_ALLOW_S)
#define TEE_REG_LP_MM_LP_TOUCH_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_TOUCH_ALLOW_S  15
/** TEE_REG_LP_MM_LP_IOMUX_ALLOW : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_IOMUX_ALLOW    (BIT(16))
#define TEE_REG_LP_MM_LP_IOMUX_ALLOW_M  (TEE_REG_LP_MM_LP_IOMUX_ALLOW_V << TEE_REG_LP_MM_LP_IOMUX_ALLOW_S)
#define TEE_REG_LP_MM_LP_IOMUX_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_IOMUX_ALLOW_S  16
/** TEE_REG_LP_MM_LP_INTR_ALLOW : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_INTR_ALLOW    (BIT(17))
#define TEE_REG_LP_MM_LP_INTR_ALLOW_M  (TEE_REG_LP_MM_LP_INTR_ALLOW_V << TEE_REG_LP_MM_LP_INTR_ALLOW_S)
#define TEE_REG_LP_MM_LP_INTR_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_INTR_ALLOW_S  17
/** TEE_REG_LP_MM_LP_EFUSE_ALLOW : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_EFUSE_ALLOW    (BIT(18))
#define TEE_REG_LP_MM_LP_EFUSE_ALLOW_M  (TEE_REG_LP_MM_LP_EFUSE_ALLOW_V << TEE_REG_LP_MM_LP_EFUSE_ALLOW_S)
#define TEE_REG_LP_MM_LP_EFUSE_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_EFUSE_ALLOW_S  18
/** TEE_REG_LP_MM_LP_PMS_ALLOW : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_PMS_ALLOW    (BIT(19))
#define TEE_REG_LP_MM_LP_PMS_ALLOW_M  (TEE_REG_LP_MM_LP_PMS_ALLOW_V << TEE_REG_LP_MM_LP_PMS_ALLOW_S)
#define TEE_REG_LP_MM_LP_PMS_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_PMS_ALLOW_S  19
/** TEE_REG_LP_MM_HP2LP_PMS_ALLOW : R/W; bitpos: [20]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP2LP_PMS_ALLOW    (BIT(20))
#define TEE_REG_LP_MM_HP2LP_PMS_ALLOW_M  (TEE_REG_LP_MM_HP2LP_PMS_ALLOW_V << TEE_REG_LP_MM_HP2LP_PMS_ALLOW_S)
#define TEE_REG_LP_MM_HP2LP_PMS_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP2LP_PMS_ALLOW_S  20
/** TEE_REG_LP_MM_LP_TSENS_ALLOW : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_TSENS_ALLOW    (BIT(21))
#define TEE_REG_LP_MM_LP_TSENS_ALLOW_M  (TEE_REG_LP_MM_LP_TSENS_ALLOW_V << TEE_REG_LP_MM_LP_TSENS_ALLOW_S)
#define TEE_REG_LP_MM_LP_TSENS_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_TSENS_ALLOW_S  21
/** TEE_REG_LP_MM_LP_HUK_ALLOW : R/W; bitpos: [22]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_HUK_ALLOW    (BIT(22))
#define TEE_REG_LP_MM_LP_HUK_ALLOW_M  (TEE_REG_LP_MM_LP_HUK_ALLOW_V << TEE_REG_LP_MM_LP_HUK_ALLOW_S)
#define TEE_REG_LP_MM_LP_HUK_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_HUK_ALLOW_S  22
/** TEE_REG_LP_MM_LP_TCM_RAM_ALLOW : R/W; bitpos: [23]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_TCM_RAM_ALLOW    (BIT(23))
#define TEE_REG_LP_MM_LP_TCM_RAM_ALLOW_M  (TEE_REG_LP_MM_LP_TCM_RAM_ALLOW_V << TEE_REG_LP_MM_LP_TCM_RAM_ALLOW_S)
#define TEE_REG_LP_MM_LP_TCM_RAM_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_TCM_RAM_ALLOW_S  23
/** TEE_REG_LP_MM_LP_TRNG_ALLOW : R/W; bitpos: [24]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP_TRNG_ALLOW    (BIT(24))
#define TEE_REG_LP_MM_LP_TRNG_ALLOW_M  (TEE_REG_LP_MM_LP_TRNG_ALLOW_V << TEE_REG_LP_MM_LP_TRNG_ALLOW_S)
#define TEE_REG_LP_MM_LP_TRNG_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP_TRNG_ALLOW_S  24

/** TEE_PERI_REGION0_LOW_REG register
 *  NA
 */
#define TEE_PERI_REGION0_LOW_REG (DR_REG_TEE_BASE + 0xc)
/** TEE_REG_PERI_REGION0_LOW : R/W; bitpos: [31:2]; default: 0;
 *  NA
 */
#define TEE_REG_PERI_REGION0_LOW    0x3FFFFFFFU
#define TEE_REG_PERI_REGION0_LOW_M  (TEE_REG_PERI_REGION0_LOW_V << TEE_REG_PERI_REGION0_LOW_S)
#define TEE_REG_PERI_REGION0_LOW_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION0_LOW_S  2

/** TEE_PERI_REGION0_HIGH_REG register
 *  NA
 */
#define TEE_PERI_REGION0_HIGH_REG (DR_REG_TEE_BASE + 0x10)
/** TEE_REG_PERI_REGION0_HIGH : R/W; bitpos: [31:2]; default: 1073741823;
 *  NA
 */
#define TEE_REG_PERI_REGION0_HIGH    0x3FFFFFFFU
#define TEE_REG_PERI_REGION0_HIGH_M  (TEE_REG_PERI_REGION0_HIGH_V << TEE_REG_PERI_REGION0_HIGH_S)
#define TEE_REG_PERI_REGION0_HIGH_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION0_HIGH_S  2

/** TEE_PERI_REGION1_LOW_REG register
 *  NA
 */
#define TEE_PERI_REGION1_LOW_REG (DR_REG_TEE_BASE + 0x14)
/** TEE_REG_PERI_REGION1_LOW : R/W; bitpos: [31:2]; default: 0;
 *  NA
 */
#define TEE_REG_PERI_REGION1_LOW    0x3FFFFFFFU
#define TEE_REG_PERI_REGION1_LOW_M  (TEE_REG_PERI_REGION1_LOW_V << TEE_REG_PERI_REGION1_LOW_S)
#define TEE_REG_PERI_REGION1_LOW_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION1_LOW_S  2

/** TEE_PERI_REGION1_HIGH_REG register
 *  NA
 */
#define TEE_PERI_REGION1_HIGH_REG (DR_REG_TEE_BASE + 0x18)
/** TEE_REG_PERI_REGION1_HIGH : R/W; bitpos: [31:2]; default: 1073741823;
 *  NA
 */
#define TEE_REG_PERI_REGION1_HIGH    0x3FFFFFFFU
#define TEE_REG_PERI_REGION1_HIGH_M  (TEE_REG_PERI_REGION1_HIGH_V << TEE_REG_PERI_REGION1_HIGH_S)
#define TEE_REG_PERI_REGION1_HIGH_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION1_HIGH_S  2

/** TEE_PERI_REGION_PMS_REG register
 *  NA
 */
#define TEE_PERI_REGION_PMS_REG (DR_REG_TEE_BASE + 0x1c)
/** TEE_REG_LP_CORE_REGION_PMS : R/W; bitpos: [1:0]; default: 3;
 *  NA
 */
#define TEE_REG_LP_CORE_REGION_PMS    0x00000003U
#define TEE_REG_LP_CORE_REGION_PMS_M  (TEE_REG_LP_CORE_REGION_PMS_V << TEE_REG_LP_CORE_REGION_PMS_S)
#define TEE_REG_LP_CORE_REGION_PMS_V  0x00000003U
#define TEE_REG_LP_CORE_REGION_PMS_S  0
/** TEE_REG_HP_CORE0_UM_REGION_PMS : R/W; bitpos: [3:2]; default: 3;
 *  NA
 */
#define TEE_REG_HP_CORE0_UM_REGION_PMS    0x00000003U
#define TEE_REG_HP_CORE0_UM_REGION_PMS_M  (TEE_REG_HP_CORE0_UM_REGION_PMS_V << TEE_REG_HP_CORE0_UM_REGION_PMS_S)
#define TEE_REG_HP_CORE0_UM_REGION_PMS_V  0x00000003U
#define TEE_REG_HP_CORE0_UM_REGION_PMS_S  2
/** TEE_REG_HP_CORE0_MM_REGION_PMS : R/W; bitpos: [5:4]; default: 3;
 *  NA
 */
#define TEE_REG_HP_CORE0_MM_REGION_PMS    0x00000003U
#define TEE_REG_HP_CORE0_MM_REGION_PMS_M  (TEE_REG_HP_CORE0_MM_REGION_PMS_V << TEE_REG_HP_CORE0_MM_REGION_PMS_S)
#define TEE_REG_HP_CORE0_MM_REGION_PMS_V  0x00000003U
#define TEE_REG_HP_CORE0_MM_REGION_PMS_S  4
/** TEE_REG_HP_CORE1_UM_REGION_PMS : R/W; bitpos: [7:6]; default: 3;
 *  NA
 */
#define TEE_REG_HP_CORE1_UM_REGION_PMS    0x00000003U
#define TEE_REG_HP_CORE1_UM_REGION_PMS_M  (TEE_REG_HP_CORE1_UM_REGION_PMS_V << TEE_REG_HP_CORE1_UM_REGION_PMS_S)
#define TEE_REG_HP_CORE1_UM_REGION_PMS_V  0x00000003U
#define TEE_REG_HP_CORE1_UM_REGION_PMS_S  6
/** TEE_REG_HP_CORE1_MM_REGION_PMS : R/W; bitpos: [9:8]; default: 3;
 *  NA
 */
#define TEE_REG_HP_CORE1_MM_REGION_PMS    0x00000003U
#define TEE_REG_HP_CORE1_MM_REGION_PMS_M  (TEE_REG_HP_CORE1_MM_REGION_PMS_V << TEE_REG_HP_CORE1_MM_REGION_PMS_S)
#define TEE_REG_HP_CORE1_MM_REGION_PMS_V  0x00000003U
#define TEE_REG_HP_CORE1_MM_REGION_PMS_S  8

/** TEE_PERI_REGION_2_TO_7_PMS_REG register
 *  NA
 */
#define TEE_PERI_REGION_2_TO_7_PMS_REG (DR_REG_TEE_BASE + 0x20)
/** TEE_REG_LP_CORE_REGION_2_TO_7_PMS : R/W; bitpos: [5:0]; default: 63;
 *  NA
 */
#define TEE_REG_LP_CORE_REGION_2_TO_7_PMS    0x0000003FU
#define TEE_REG_LP_CORE_REGION_2_TO_7_PMS_M  (TEE_REG_LP_CORE_REGION_2_TO_7_PMS_V << TEE_REG_LP_CORE_REGION_2_TO_7_PMS_S)
#define TEE_REG_LP_CORE_REGION_2_TO_7_PMS_V  0x0000003FU
#define TEE_REG_LP_CORE_REGION_2_TO_7_PMS_S  0
/** TEE_REG_HP_CORE0_UM_REGION_2_TO_7_PMS : R/W; bitpos: [11:6]; default: 63;
 *  NA
 */
#define TEE_REG_HP_CORE0_UM_REGION_2_TO_7_PMS    0x0000003FU
#define TEE_REG_HP_CORE0_UM_REGION_2_TO_7_PMS_M  (TEE_REG_HP_CORE0_UM_REGION_2_TO_7_PMS_V << TEE_REG_HP_CORE0_UM_REGION_2_TO_7_PMS_S)
#define TEE_REG_HP_CORE0_UM_REGION_2_TO_7_PMS_V  0x0000003FU
#define TEE_REG_HP_CORE0_UM_REGION_2_TO_7_PMS_S  6
/** TEE_REG_HP_CORE0_MM_REGION_2_TO_7_PMS : R/W; bitpos: [17:12]; default: 63;
 *  NA
 */
#define TEE_REG_HP_CORE0_MM_REGION_2_TO_7_PMS    0x0000003FU
#define TEE_REG_HP_CORE0_MM_REGION_2_TO_7_PMS_M  (TEE_REG_HP_CORE0_MM_REGION_2_TO_7_PMS_V << TEE_REG_HP_CORE0_MM_REGION_2_TO_7_PMS_S)
#define TEE_REG_HP_CORE0_MM_REGION_2_TO_7_PMS_V  0x0000003FU
#define TEE_REG_HP_CORE0_MM_REGION_2_TO_7_PMS_S  12
/** TEE_REG_HP_CORE1_UM_REGION_2_TO_7_PMS : R/W; bitpos: [23:18]; default: 63;
 *  NA
 */
#define TEE_REG_HP_CORE1_UM_REGION_2_TO_7_PMS    0x0000003FU
#define TEE_REG_HP_CORE1_UM_REGION_2_TO_7_PMS_M  (TEE_REG_HP_CORE1_UM_REGION_2_TO_7_PMS_V << TEE_REG_HP_CORE1_UM_REGION_2_TO_7_PMS_S)
#define TEE_REG_HP_CORE1_UM_REGION_2_TO_7_PMS_V  0x0000003FU
#define TEE_REG_HP_CORE1_UM_REGION_2_TO_7_PMS_S  18
/** TEE_REG_HP_CORE1_MM_REGION_2_TO_7_PMS : R/W; bitpos: [29:24]; default: 63;
 *  NA
 */
#define TEE_REG_HP_CORE1_MM_REGION_2_TO_7_PMS    0x0000003FU
#define TEE_REG_HP_CORE1_MM_REGION_2_TO_7_PMS_M  (TEE_REG_HP_CORE1_MM_REGION_2_TO_7_PMS_V << TEE_REG_HP_CORE1_MM_REGION_2_TO_7_PMS_S)
#define TEE_REG_HP_CORE1_MM_REGION_2_TO_7_PMS_V  0x0000003FU
#define TEE_REG_HP_CORE1_MM_REGION_2_TO_7_PMS_S  24

/** TEE_PERI_REGION2_LOW_REG register
 *  NA
 */
#define TEE_PERI_REGION2_LOW_REG (DR_REG_TEE_BASE + 0x24)
/** TEE_REG_PERI_REGION2_LOW : R/W; bitpos: [31:2]; default: 0;
 *  NA
 */
#define TEE_REG_PERI_REGION2_LOW    0x3FFFFFFFU
#define TEE_REG_PERI_REGION2_LOW_M  (TEE_REG_PERI_REGION2_LOW_V << TEE_REG_PERI_REGION2_LOW_S)
#define TEE_REG_PERI_REGION2_LOW_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION2_LOW_S  2

/** TEE_PERI_REGION2_HIGH_REG register
 *  NA
 */
#define TEE_PERI_REGION2_HIGH_REG (DR_REG_TEE_BASE + 0x28)
/** TEE_REG_PERI_REGION2_HIGH : R/W; bitpos: [31:2]; default: 1073741823;
 *  NA
 */
#define TEE_REG_PERI_REGION2_HIGH    0x3FFFFFFFU
#define TEE_REG_PERI_REGION2_HIGH_M  (TEE_REG_PERI_REGION2_HIGH_V << TEE_REG_PERI_REGION2_HIGH_S)
#define TEE_REG_PERI_REGION2_HIGH_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION2_HIGH_S  2

/** TEE_PERI_REGION3_LOW_REG register
 *  NA
 */
#define TEE_PERI_REGION3_LOW_REG (DR_REG_TEE_BASE + 0x2c)
/** TEE_REG_PERI_REGION3_LOW : R/W; bitpos: [31:2]; default: 0;
 *  NA
 */
#define TEE_REG_PERI_REGION3_LOW    0x3FFFFFFFU
#define TEE_REG_PERI_REGION3_LOW_M  (TEE_REG_PERI_REGION3_LOW_V << TEE_REG_PERI_REGION3_LOW_S)
#define TEE_REG_PERI_REGION3_LOW_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION3_LOW_S  2

/** TEE_PERI_REGION3_HIGH_REG register
 *  NA
 */
#define TEE_PERI_REGION3_HIGH_REG (DR_REG_TEE_BASE + 0x30)
/** TEE_REG_PERI_REGION3_HIGH : R/W; bitpos: [31:2]; default: 1073741823;
 *  NA
 */
#define TEE_REG_PERI_REGION3_HIGH    0x3FFFFFFFU
#define TEE_REG_PERI_REGION3_HIGH_M  (TEE_REG_PERI_REGION3_HIGH_V << TEE_REG_PERI_REGION3_HIGH_S)
#define TEE_REG_PERI_REGION3_HIGH_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION3_HIGH_S  2

/** TEE_PERI_REGION4_LOW_REG register
 *  NA
 */
#define TEE_PERI_REGION4_LOW_REG (DR_REG_TEE_BASE + 0x34)
/** TEE_REG_PERI_REGION4_LOW : R/W; bitpos: [31:2]; default: 0;
 *  NA
 */
#define TEE_REG_PERI_REGION4_LOW    0x3FFFFFFFU
#define TEE_REG_PERI_REGION4_LOW_M  (TEE_REG_PERI_REGION4_LOW_V << TEE_REG_PERI_REGION4_LOW_S)
#define TEE_REG_PERI_REGION4_LOW_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION4_LOW_S  2

/** TEE_PERI_REGION4_HIGH_REG register
 *  NA
 */
#define TEE_PERI_REGION4_HIGH_REG (DR_REG_TEE_BASE + 0x38)
/** TEE_REG_PERI_REGION4_HIGH : R/W; bitpos: [31:2]; default: 1073741823;
 *  NA
 */
#define TEE_REG_PERI_REGION4_HIGH    0x3FFFFFFFU
#define TEE_REG_PERI_REGION4_HIGH_M  (TEE_REG_PERI_REGION4_HIGH_V << TEE_REG_PERI_REGION4_HIGH_S)
#define TEE_REG_PERI_REGION4_HIGH_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION4_HIGH_S  2

/** TEE_PERI_REGION5_LOW_REG register
 *  NA
 */
#define TEE_PERI_REGION5_LOW_REG (DR_REG_TEE_BASE + 0x3c)
/** TEE_REG_PERI_REGION5_LOW : R/W; bitpos: [31:2]; default: 0;
 *  NA
 */
#define TEE_REG_PERI_REGION5_LOW    0x3FFFFFFFU
#define TEE_REG_PERI_REGION5_LOW_M  (TEE_REG_PERI_REGION5_LOW_V << TEE_REG_PERI_REGION5_LOW_S)
#define TEE_REG_PERI_REGION5_LOW_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION5_LOW_S  2

/** TEE_PERI_REGION5_HIGH_REG register
 *  NA
 */
#define TEE_PERI_REGION5_HIGH_REG (DR_REG_TEE_BASE + 0x40)
/** TEE_REG_PERI_REGION5_HIGH : R/W; bitpos: [31:2]; default: 1073741823;
 *  NA
 */
#define TEE_REG_PERI_REGION5_HIGH    0x3FFFFFFFU
#define TEE_REG_PERI_REGION5_HIGH_M  (TEE_REG_PERI_REGION5_HIGH_V << TEE_REG_PERI_REGION5_HIGH_S)
#define TEE_REG_PERI_REGION5_HIGH_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION5_HIGH_S  2

/** TEE_PERI_REGION6_LOW_REG register
 *  NA
 */
#define TEE_PERI_REGION6_LOW_REG (DR_REG_TEE_BASE + 0x44)
/** TEE_REG_PERI_REGION6_LOW : R/W; bitpos: [31:2]; default: 0;
 *  NA
 */
#define TEE_REG_PERI_REGION6_LOW    0x3FFFFFFFU
#define TEE_REG_PERI_REGION6_LOW_M  (TEE_REG_PERI_REGION6_LOW_V << TEE_REG_PERI_REGION6_LOW_S)
#define TEE_REG_PERI_REGION6_LOW_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION6_LOW_S  2

/** TEE_PERI_REGION6_HIGH_REG register
 *  NA
 */
#define TEE_PERI_REGION6_HIGH_REG (DR_REG_TEE_BASE + 0x48)
/** TEE_REG_PERI_REGION6_HIGH : R/W; bitpos: [31:2]; default: 1073741823;
 *  NA
 */
#define TEE_REG_PERI_REGION6_HIGH    0x3FFFFFFFU
#define TEE_REG_PERI_REGION6_HIGH_M  (TEE_REG_PERI_REGION6_HIGH_V << TEE_REG_PERI_REGION6_HIGH_S)
#define TEE_REG_PERI_REGION6_HIGH_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION6_HIGH_S  2

/** TEE_PERI_REGION7_LOW_REG register
 *  NA
 */
#define TEE_PERI_REGION7_LOW_REG (DR_REG_TEE_BASE + 0x4c)
/** TEE_REG_PERI_REGION7_LOW : R/W; bitpos: [31:2]; default: 0;
 *  NA
 */
#define TEE_REG_PERI_REGION7_LOW    0x3FFFFFFFU
#define TEE_REG_PERI_REGION7_LOW_M  (TEE_REG_PERI_REGION7_LOW_V << TEE_REG_PERI_REGION7_LOW_S)
#define TEE_REG_PERI_REGION7_LOW_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION7_LOW_S  2

/** TEE_PERI_REGION7_HIGH_REG register
 *  NA
 */
#define TEE_PERI_REGION7_HIGH_REG (DR_REG_TEE_BASE + 0x50)
/** TEE_REG_PERI_REGION7_HIGH : R/W; bitpos: [31:2]; default: 1073741823;
 *  NA
 */
#define TEE_REG_PERI_REGION7_HIGH    0x3FFFFFFFU
#define TEE_REG_PERI_REGION7_HIGH_M  (TEE_REG_PERI_REGION7_HIGH_V << TEE_REG_PERI_REGION7_HIGH_S)
#define TEE_REG_PERI_REGION7_HIGH_V  0x3FFFFFFFU
#define TEE_REG_PERI_REGION7_HIGH_S  2

#ifdef __cplusplus
}
#endif
