/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#include <app-common/zap-generated/cluster-enums.h>

namespace chip {
namespace app {
namespace Clusters {
static auto __attribute__((unused)) EnsureKnownEnumValue(Globals::AreaTypeTag val)
{
    using EnumType = Globals::AreaTypeTag;
    switch (val)
    {
    case EnumType::kAisle:
    case EnumType::kAttic:
    case EnumType::kBackDoor:
    case EnumType::kBackYard:
    case EnumType::kBalcony:
    case EnumType::kBallroom:
    case EnumType::kBathroom:
    case EnumType::kBedroom:
    case EnumType::kBorder:
    case EnumType::kBoxroom:
    case EnumType::kBreakfastRoom:
    case EnumType::kCarport:
    case EnumType::kCellar:
    case EnumType::kCloakroom:
    case EnumType::kCloset:
    case EnumType::kConservatory:
    case EnumType::kCorridor:
    case EnumType::kCraftRoom:
    case EnumType::kCupboard:
    case EnumType::kDeck:
    case EnumType::kDen:
    case EnumType::kDining:
    case EnumType::kDrawingRoom:
    case EnumType::kDressingRoom:
    case EnumType::kDriveway:
    case EnumType::kElevator:
    case EnumType::kEnsuite:
    case EnumType::kEntrance:
    case EnumType::kEntryway:
    case EnumType::kFamilyRoom:
    case EnumType::kFoyer:
    case EnumType::kFrontDoor:
    case EnumType::kFrontYard:
    case EnumType::kGameRoom:
    case EnumType::kGarage:
    case EnumType::kGarageDoor:
    case EnumType::kGarden:
    case EnumType::kGardenDoor:
    case EnumType::kGuestBathroom:
    case EnumType::kGuestBedroom:
    case EnumType::kGuestRestroom:
    case EnumType::kGuestRoom:
    case EnumType::kGym:
    case EnumType::kHallway:
    case EnumType::kHearthRoom:
    case EnumType::kKidsRoom:
    case EnumType::kKidsBedroom:
    case EnumType::kKitchen:
    case EnumType::kLarder:
    case EnumType::kLaundryRoom:
    case EnumType::kLawn:
    case EnumType::kLibrary:
    case EnumType::kLivingRoom:
    case EnumType::kLounge:
    case EnumType::kMediaTvRoom:
    case EnumType::kMudRoom:
    case EnumType::kMusicRoom:
    case EnumType::kNursery:
    case EnumType::kOffice:
    case EnumType::kOutdoorKitchen:
    case EnumType::kOutside:
    case EnumType::kPantry:
    case EnumType::kParkingLot:
    case EnumType::kParlor:
    case EnumType::kPatio:
    case EnumType::kPlayRoom:
    case EnumType::kPoolRoom:
    case EnumType::kPorch:
    case EnumType::kPrimaryBathroom:
    case EnumType::kPrimaryBedroom:
    case EnumType::kRamp:
    case EnumType::kReceptionRoom:
    case EnumType::kRecreationRoom:
    case EnumType::kRestroom:
    case EnumType::kRoof:
    case EnumType::kSauna:
    case EnumType::kScullery:
    case EnumType::kSewingRoom:
    case EnumType::kShed:
    case EnumType::kSideDoor:
    case EnumType::kSideYard:
    case EnumType::kSittingRoom:
    case EnumType::kSnug:
    case EnumType::kSpa:
    case EnumType::kStaircase:
    case EnumType::kSteamRoom:
    case EnumType::kStorageRoom:
    case EnumType::kStudio:
    case EnumType::kStudy:
    case EnumType::kSunRoom:
    case EnumType::kSwimmingPool:
    case EnumType::kTerrace:
    case EnumType::kUtilityRoom:
    case EnumType::kWard:
    case EnumType::kWorkshop:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Globals::AtomicRequestTypeEnum val)
{
    using EnumType = Globals::AtomicRequestTypeEnum;
    switch (val)
    {
    case EnumType::kBeginWrite:
    case EnumType::kCommitWrite:
    case EnumType::kRollbackWrite:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(detail::ChangeIndicationEnum val)
{
    using EnumType = detail::ChangeIndicationEnum;
    switch (val)
    {
    case EnumType::kOk:
    case EnumType::kWarning:
    case EnumType::kCritical:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(detail::DegradationDirectionEnum val)
{
    using EnumType = detail::DegradationDirectionEnum;
    switch (val)
    {
    case EnumType::kUp:
    case EnumType::kDown:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Globals::FloorSurfaceTag val)
{
    using EnumType = Globals::FloorSurfaceTag;
    switch (val)
    {
    case EnumType::kCarpet:
    case EnumType::kCeramic:
    case EnumType::kConcrete:
    case EnumType::kCork:
    case EnumType::kDeepCarpet:
    case EnumType::kDirt:
    case EnumType::kEngineeredWood:
    case EnumType::kGlass:
    case EnumType::kGrass:
    case EnumType::kHardwood:
    case EnumType::kLaminate:
    case EnumType::kLinoleum:
    case EnumType::kMat:
    case EnumType::kMetal:
    case EnumType::kPlastic:
    case EnumType::kPolishedConcrete:
    case EnumType::kRubber:
    case EnumType::kRug:
    case EnumType::kSand:
    case EnumType::kStone:
    case EnumType::kTatami:
    case EnumType::kTerrazzo:
    case EnumType::kTile:
    case EnumType::kVinyl:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Globals::LandmarkTag val)
{
    using EnumType = Globals::LandmarkTag;
    switch (val)
    {
    case EnumType::kAirConditioner:
    case EnumType::kAirPurifier:
    case EnumType::kBackDoor:
    case EnumType::kBarStool:
    case EnumType::kBathMat:
    case EnumType::kBathtub:
    case EnumType::kBed:
    case EnumType::kBookshelf:
    case EnumType::kChair:
    case EnumType::kChristmasTree:
    case EnumType::kCoatRack:
    case EnumType::kCoffeeTable:
    case EnumType::kCookingRange:
    case EnumType::kCouch:
    case EnumType::kCountertop:
    case EnumType::kCradle:
    case EnumType::kCrib:
    case EnumType::kDesk:
    case EnumType::kDiningTable:
    case EnumType::kDishwasher:
    case EnumType::kDoor:
    case EnumType::kDresser:
    case EnumType::kLaundryDryer:
    case EnumType::kFan:
    case EnumType::kFireplace:
    case EnumType::kFreezer:
    case EnumType::kFrontDoor:
    case EnumType::kHighChair:
    case EnumType::kKitchenIsland:
    case EnumType::kLamp:
    case EnumType::kLitterBox:
    case EnumType::kMirror:
    case EnumType::kNightstand:
    case EnumType::kOven:
    case EnumType::kPetBed:
    case EnumType::kPetBowl:
    case EnumType::kPetCrate:
    case EnumType::kRefrigerator:
    case EnumType::kScratchingPost:
    case EnumType::kShoeRack:
    case EnumType::kShower:
    case EnumType::kSideDoor:
    case EnumType::kSink:
    case EnumType::kSofa:
    case EnumType::kStove:
    case EnumType::kTable:
    case EnumType::kToilet:
    case EnumType::kTrashCan:
    case EnumType::kLaundryWasher:
    case EnumType::kWindow:
    case EnumType::kWineCooler:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(detail::LevelValueEnum val)
{
    using EnumType = detail::LevelValueEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kLow:
    case EnumType::kMedium:
    case EnumType::kHigh:
    case EnumType::kCritical:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(detail::MeasurementMediumEnum val)
{
    using EnumType = detail::MeasurementMediumEnum;
    switch (val)
    {
    case EnumType::kAir:
    case EnumType::kWater:
    case EnumType::kSoil:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(detail::MeasurementTypeEnum val)
{
    using EnumType = detail::MeasurementTypeEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kVoltage:
    case EnumType::kActiveCurrent:
    case EnumType::kReactiveCurrent:
    case EnumType::kApparentCurrent:
    case EnumType::kActivePower:
    case EnumType::kReactivePower:
    case EnumType::kApparentPower:
    case EnumType::kRMSVoltage:
    case EnumType::kRMSCurrent:
    case EnumType::kRMSPower:
    case EnumType::kFrequency:
    case EnumType::kPowerFactor:
    case EnumType::kNeutralCurrent:
    case EnumType::kElectricalEnergy:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(detail::MeasurementUnitEnum val)
{
    using EnumType = detail::MeasurementUnitEnum;
    switch (val)
    {
    case EnumType::kPpm:
    case EnumType::kPpb:
    case EnumType::kPpt:
    case EnumType::kMgm3:
    case EnumType::kUgm3:
    case EnumType::kNgm3:
    case EnumType::kPm3:
    case EnumType::kBqm3:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Globals::PositionTag val)
{
    using EnumType = Globals::PositionTag;
    switch (val)
    {
    case EnumType::kLeft:
    case EnumType::kRight:
    case EnumType::kTop:
    case EnumType::kBottom:
    case EnumType::kMiddle:
    case EnumType::kRow:
    case EnumType::kColumn:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(detail::ProductIdentifierTypeEnum val)
{
    using EnumType = detail::ProductIdentifierTypeEnum;
    switch (val)
    {
    case EnumType::kUpc:
    case EnumType::kGtin8:
    case EnumType::kEan:
    case EnumType::kGtin14:
    case EnumType::kOem:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Globals::RelativePositionTag val)
{
    using EnumType = Globals::RelativePositionTag;
    switch (val)
    {
    case EnumType::kUnder:
    case EnumType::kNextTo:
    case EnumType::kAround:
    case EnumType::kOn:
    case EnumType::kAbove:
    case EnumType::kFrontOf:
    case EnumType::kBehind:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(detail::StreamTypeEnum val)
{
    using EnumType = detail::StreamTypeEnum;
    switch (val)
    {
    case EnumType::kInternal:
    case EnumType::kRecording:
    case EnumType::kAnalysis:
    case EnumType::kLiveView:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Globals::TestGlobalEnum val)
{
    using EnumType = Globals::TestGlobalEnum;
    switch (val)
    {
    case EnumType::kSomeValue:
    case EnumType::kSomeOtherValue:
    case EnumType::kFinalValue:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Globals::ThreeLevelAutoEnum val)
{
    using EnumType = Globals::ThreeLevelAutoEnum;
    switch (val)
    {
    case EnumType::kLow:
    case EnumType::kMedium:
    case EnumType::kHigh:
    case EnumType::kAutomatic:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(detail::WebRTCEndReasonEnum val)
{
    using EnumType = detail::WebRTCEndReasonEnum;
    switch (val)
    {
    case EnumType::kIceFailed:
    case EnumType::kIceTimeout:
    case EnumType::kUserHangup:
    case EnumType::kUserBusy:
    case EnumType::kReplaced:
    case EnumType::kNoUserMedia:
    case EnumType::kInviteTimeout:
    case EnumType::kAnsweredElsewhere:
    case EnumType::kOutOfResources:
    case EnumType::kMediaTimeout:
    case EnumType::kLowPower:
    case EnumType::kUnknownReason:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Identify::EffectIdentifierEnum val)
{
    using EnumType = Identify::EffectIdentifierEnum;
    switch (val)
    {
    case EnumType::kBlink:
    case EnumType::kBreathe:
    case EnumType::kOkay:
    case EnumType::kChannelChange:
    case EnumType::kFinishEffect:
    case EnumType::kStopEffect:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Identify::EffectVariantEnum val)
{
    using EnumType = Identify::EffectVariantEnum;
    switch (val)
    {
    case EnumType::kDefault:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Identify::IdentifyTypeEnum val)
{
    using EnumType = Identify::IdentifyTypeEnum;
    switch (val)
    {
    case EnumType::kNone:
    case EnumType::kLightOutput:
    case EnumType::kVisibleIndicator:
    case EnumType::kAudibleBeep:
    case EnumType::kDisplay:
    case EnumType::kActuator:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OnOff::DelayedAllOffEffectVariantEnum val)
{
    using EnumType = OnOff::DelayedAllOffEffectVariantEnum;
    switch (val)
    {
    case EnumType::kDelayedOffFastFade:
    case EnumType::kNoFade:
    case EnumType::kDelayedOffSlowFade:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OnOff::DyingLightEffectVariantEnum val)
{
    using EnumType = OnOff::DyingLightEffectVariantEnum;
    switch (val)
    {
    case EnumType::kDyingLightFadeOff:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OnOff::EffectIdentifierEnum val)
{
    using EnumType = OnOff::EffectIdentifierEnum;
    switch (val)
    {
    case EnumType::kDelayedAllOff:
    case EnumType::kDyingLight:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OnOff::StartUpOnOffEnum val)
{
    using EnumType = OnOff::StartUpOnOffEnum;
    switch (val)
    {
    case EnumType::kOff:
    case EnumType::kOn:
    case EnumType::kToggle:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(LevelControl::MoveModeEnum val)
{
    using EnumType = LevelControl::MoveModeEnum;
    switch (val)
    {
    case EnumType::kUp:
    case EnumType::kDown:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(LevelControl::StepModeEnum val)
{
    using EnumType = LevelControl::StepModeEnum;
    switch (val)
    {
    case EnumType::kUp:
    case EnumType::kDown:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(AccessControl::AccessControlEntryAuthModeEnum val)
{
    using EnumType = AccessControl::AccessControlEntryAuthModeEnum;
    switch (val)
    {
    case EnumType::kPase:
    case EnumType::kCase:
    case EnumType::kGroup:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(AccessControl::AccessControlEntryPrivilegeEnum val)
{
    using EnumType = AccessControl::AccessControlEntryPrivilegeEnum;
    switch (val)
    {
    case EnumType::kView:
    case EnumType::kProxyView:
    case EnumType::kOperate:
    case EnumType::kManage:
    case EnumType::kAdminister:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(AccessControl::AccessRestrictionTypeEnum val)
{
    using EnumType = AccessControl::AccessRestrictionTypeEnum;
    switch (val)
    {
    case EnumType::kAttributeAccessForbidden:
    case EnumType::kAttributeWriteForbidden:
    case EnumType::kCommandForbidden:
    case EnumType::kEventForbidden:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(AccessControl::ChangeTypeEnum val)
{
    using EnumType = AccessControl::ChangeTypeEnum;
    switch (val)
    {
    case EnumType::kChanged:
    case EnumType::kAdded:
    case EnumType::kRemoved:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Actions::ActionErrorEnum val)
{
    using EnumType = Actions::ActionErrorEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kInterrupted:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Actions::ActionStateEnum val)
{
    using EnumType = Actions::ActionStateEnum;
    switch (val)
    {
    case EnumType::kInactive:
    case EnumType::kActive:
    case EnumType::kPaused:
    case EnumType::kDisabled:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Actions::ActionTypeEnum val)
{
    using EnumType = Actions::ActionTypeEnum;
    switch (val)
    {
    case EnumType::kOther:
    case EnumType::kScene:
    case EnumType::kSequence:
    case EnumType::kAutomation:
    case EnumType::kException:
    case EnumType::kNotification:
    case EnumType::kAlarm:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Actions::EndpointListTypeEnum val)
{
    using EnumType = Actions::EndpointListTypeEnum;
    switch (val)
    {
    case EnumType::kOther:
    case EnumType::kRoom:
    case EnumType::kZone:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(BasicInformation::ColorEnum val)
{
    using EnumType = BasicInformation::ColorEnum;
    switch (val)
    {
    case EnumType::kBlack:
    case EnumType::kNavy:
    case EnumType::kGreen:
    case EnumType::kTeal:
    case EnumType::kMaroon:
    case EnumType::kPurple:
    case EnumType::kOlive:
    case EnumType::kGray:
    case EnumType::kBlue:
    case EnumType::kLime:
    case EnumType::kAqua:
    case EnumType::kRed:
    case EnumType::kFuchsia:
    case EnumType::kYellow:
    case EnumType::kWhite:
    case EnumType::kNickel:
    case EnumType::kChrome:
    case EnumType::kBrass:
    case EnumType::kCopper:
    case EnumType::kSilver:
    case EnumType::kGold:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(BasicInformation::ProductFinishEnum val)
{
    using EnumType = BasicInformation::ProductFinishEnum;
    switch (val)
    {
    case EnumType::kOther:
    case EnumType::kMatte:
    case EnumType::kSatin:
    case EnumType::kPolished:
    case EnumType::kRugged:
    case EnumType::kFabric:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateProvider::ApplyUpdateActionEnum val)
{
    using EnumType = OtaSoftwareUpdateProvider::ApplyUpdateActionEnum;
    switch (val)
    {
    case EnumType::kProceed:
    case EnumType::kAwaitNextAction:
    case EnumType::kDiscontinue:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateProvider::DownloadProtocolEnum val)
{
    using EnumType = OtaSoftwareUpdateProvider::DownloadProtocolEnum;
    switch (val)
    {
    case EnumType::kBDXSynchronous:
    case EnumType::kBDXAsynchronous:
    case EnumType::kHttps:
    case EnumType::kVendorSpecific:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateProvider::StatusEnum val)
{
    using EnumType = OtaSoftwareUpdateProvider::StatusEnum;
    switch (val)
    {
    case EnumType::kUpdateAvailable:
    case EnumType::kBusy:
    case EnumType::kNotAvailable:
    case EnumType::kDownloadProtocolNotSupported:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateRequestor::AnnouncementReasonEnum val)
{
    using EnumType = OtaSoftwareUpdateRequestor::AnnouncementReasonEnum;
    switch (val)
    {
    case EnumType::kSimpleAnnouncement:
    case EnumType::kUpdateAvailable:
    case EnumType::kUrgentUpdateAvailable:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateRequestor::ChangeReasonEnum val)
{
    using EnumType = OtaSoftwareUpdateRequestor::ChangeReasonEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kSuccess:
    case EnumType::kFailure:
    case EnumType::kTimeOut:
    case EnumType::kDelayByProvider:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateRequestor::UpdateStateEnum val)
{
    using EnumType = OtaSoftwareUpdateRequestor::UpdateStateEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kIdle:
    case EnumType::kQuerying:
    case EnumType::kDelayedOnQuery:
    case EnumType::kDownloading:
    case EnumType::kApplying:
    case EnumType::kDelayedOnApply:
    case EnumType::kRollingBack:
    case EnumType::kDelayedOnUserConsent:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(TimeFormatLocalization::CalendarTypeEnum val)
{
    using EnumType = TimeFormatLocalization::CalendarTypeEnum;
    switch (val)
    {
    case EnumType::kBuddhist:
    case EnumType::kChinese:
    case EnumType::kCoptic:
    case EnumType::kEthiopian:
    case EnumType::kGregorian:
    case EnumType::kHebrew:
    case EnumType::kIndian:
    case EnumType::kIslamic:
    case EnumType::kJapanese:
    case EnumType::kKorean:
    case EnumType::kPersian:
    case EnumType::kTaiwanese:
    case EnumType::kUseActiveLocale:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(TimeFormatLocalization::HourFormatEnum val)
{
    using EnumType = TimeFormatLocalization::HourFormatEnum;
    switch (val)
    {
    case EnumType::k12hr:
    case EnumType::k24hr:
    case EnumType::kUseActiveLocale:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(UnitLocalization::TempUnitEnum val)
{
    using EnumType = UnitLocalization::TempUnitEnum;
    switch (val)
    {
    case EnumType::kFahrenheit:
    case EnumType::kCelsius:
    case EnumType::kKelvin:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatApprovedChemistryEnum val)
{
    using EnumType = PowerSource::BatApprovedChemistryEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kAlkaline:
    case EnumType::kLithiumCarbonFluoride:
    case EnumType::kLithiumChromiumOxide:
    case EnumType::kLithiumCopperOxide:
    case EnumType::kLithiumIronDisulfide:
    case EnumType::kLithiumManganeseDioxide:
    case EnumType::kLithiumThionylChloride:
    case EnumType::kMagnesium:
    case EnumType::kMercuryOxide:
    case EnumType::kNickelOxyhydride:
    case EnumType::kSilverOxide:
    case EnumType::kZincAir:
    case EnumType::kZincCarbon:
    case EnumType::kZincChloride:
    case EnumType::kZincManganeseDioxide:
    case EnumType::kLeadAcid:
    case EnumType::kLithiumCobaltOxide:
    case EnumType::kLithiumIon:
    case EnumType::kLithiumIonPolymer:
    case EnumType::kLithiumIronPhosphate:
    case EnumType::kLithiumSulfur:
    case EnumType::kLithiumTitanate:
    case EnumType::kNickelCadmium:
    case EnumType::kNickelHydrogen:
    case EnumType::kNickelIron:
    case EnumType::kNickelMetalHydride:
    case EnumType::kNickelZinc:
    case EnumType::kSilverZinc:
    case EnumType::kSodiumIon:
    case EnumType::kSodiumSulfur:
    case EnumType::kZincBromide:
    case EnumType::kZincCerium:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatChargeFaultEnum val)
{
    using EnumType = PowerSource::BatChargeFaultEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kAmbientTooHot:
    case EnumType::kAmbientTooCold:
    case EnumType::kBatteryTooHot:
    case EnumType::kBatteryTooCold:
    case EnumType::kBatteryAbsent:
    case EnumType::kBatteryOverVoltage:
    case EnumType::kBatteryUnderVoltage:
    case EnumType::kChargerOverVoltage:
    case EnumType::kChargerUnderVoltage:
    case EnumType::kSafetyTimeout:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatChargeLevelEnum val)
{
    using EnumType = PowerSource::BatChargeLevelEnum;
    switch (val)
    {
    case EnumType::kOk:
    case EnumType::kWarning:
    case EnumType::kCritical:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatChargeStateEnum val)
{
    using EnumType = PowerSource::BatChargeStateEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kIsCharging:
    case EnumType::kIsAtFullCharge:
    case EnumType::kIsNotCharging:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatCommonDesignationEnum val)
{
    using EnumType = PowerSource::BatCommonDesignationEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kAaa:
    case EnumType::kAa:
    case EnumType::kC:
    case EnumType::kD:
    case EnumType::k4v5:
    case EnumType::k6v0:
    case EnumType::k9v0:
    case EnumType::k12aa:
    case EnumType::kAaaa:
    case EnumType::kA:
    case EnumType::kB:
    case EnumType::kF:
    case EnumType::kN:
    case EnumType::kNo6:
    case EnumType::kSubC:
    case EnumType::kA23:
    case EnumType::kA27:
    case EnumType::kBa5800:
    case EnumType::kDuplex:
    case EnumType::k4sr44:
    case EnumType::k523:
    case EnumType::k531:
    case EnumType::k15v0:
    case EnumType::k22v5:
    case EnumType::k30v0:
    case EnumType::k45v0:
    case EnumType::k67v5:
    case EnumType::kJ:
    case EnumType::kCr123a:
    case EnumType::kCr2:
    case EnumType::k2cr5:
    case EnumType::kCrP2:
    case EnumType::kCrV3:
    case EnumType::kSr41:
    case EnumType::kSr43:
    case EnumType::kSr44:
    case EnumType::kSr45:
    case EnumType::kSr48:
    case EnumType::kSr54:
    case EnumType::kSr55:
    case EnumType::kSr57:
    case EnumType::kSr58:
    case EnumType::kSr59:
    case EnumType::kSr60:
    case EnumType::kSr63:
    case EnumType::kSr64:
    case EnumType::kSr65:
    case EnumType::kSr66:
    case EnumType::kSr67:
    case EnumType::kSr68:
    case EnumType::kSr69:
    case EnumType::kSr516:
    case EnumType::kSr731:
    case EnumType::kSr712:
    case EnumType::kLr932:
    case EnumType::kA5:
    case EnumType::kA10:
    case EnumType::kA13:
    case EnumType::kA312:
    case EnumType::kA675:
    case EnumType::kAc41e:
    case EnumType::k10180:
    case EnumType::k10280:
    case EnumType::k10440:
    case EnumType::k14250:
    case EnumType::k14430:
    case EnumType::k14500:
    case EnumType::k14650:
    case EnumType::k15270:
    case EnumType::k16340:
    case EnumType::kRcr123a:
    case EnumType::k17500:
    case EnumType::k17670:
    case EnumType::k18350:
    case EnumType::k18500:
    case EnumType::k18650:
    case EnumType::k19670:
    case EnumType::k25500:
    case EnumType::k26650:
    case EnumType::k32600:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatFaultEnum val)
{
    using EnumType = PowerSource::BatFaultEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kOverTemp:
    case EnumType::kUnderTemp:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatReplaceabilityEnum val)
{
    using EnumType = PowerSource::BatReplaceabilityEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kNotReplaceable:
    case EnumType::kUserReplaceable:
    case EnumType::kFactoryReplaceable:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::PowerSourceStatusEnum val)
{
    using EnumType = PowerSource::PowerSourceStatusEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kActive:
    case EnumType::kStandby:
    case EnumType::kUnavailable:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::WiredCurrentTypeEnum val)
{
    using EnumType = PowerSource::WiredCurrentTypeEnum;
    switch (val)
    {
    case EnumType::kAc:
    case EnumType::kDc:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::WiredFaultEnum val)
{
    using EnumType = PowerSource::WiredFaultEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kOverVoltage:
    case EnumType::kUnderVoltage:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralCommissioning::CommissioningErrorEnum val)
{
    using EnumType = GeneralCommissioning::CommissioningErrorEnum;
    switch (val)
    {
    case EnumType::kOk:
    case EnumType::kValueOutsideRange:
    case EnumType::kInvalidAuthentication:
    case EnumType::kNoFailSafe:
    case EnumType::kBusyWithOtherAdmin:
    case EnumType::kRequiredTCNotAccepted:
    case EnumType::kTCAcknowledgementsNotReceived:
    case EnumType::kTCMinVersionNotMet:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralCommissioning::RegulatoryLocationTypeEnum val)
{
    using EnumType = GeneralCommissioning::RegulatoryLocationTypeEnum;
    switch (val)
    {
    case EnumType::kIndoor:
    case EnumType::kOutdoor:
    case EnumType::kIndoorOutdoor:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(NetworkCommissioning::NetworkCommissioningStatusEnum val)
{
    using EnumType = NetworkCommissioning::NetworkCommissioningStatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kOutOfRange:
    case EnumType::kBoundsExceeded:
    case EnumType::kNetworkIDNotFound:
    case EnumType::kDuplicateNetworkID:
    case EnumType::kNetworkNotFound:
    case EnumType::kRegulatoryError:
    case EnumType::kAuthFailure:
    case EnumType::kUnsupportedSecurity:
    case EnumType::kOtherConnectionFailure:
    case EnumType::kIPV6Failed:
    case EnumType::kIPBindFailed:
    case EnumType::kUnknownError:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(NetworkCommissioning::WiFiBandEnum val)
{
    using EnumType = NetworkCommissioning::WiFiBandEnum;
    switch (val)
    {
    case EnumType::k2g4:
    case EnumType::k3g65:
    case EnumType::k5g:
    case EnumType::k6g:
    case EnumType::k60g:
    case EnumType::k1g:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(DiagnosticLogs::IntentEnum val)
{
    using EnumType = DiagnosticLogs::IntentEnum;
    switch (val)
    {
    case EnumType::kEndUserSupport:
    case EnumType::kNetworkDiag:
    case EnumType::kCrashLogs:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DiagnosticLogs::StatusEnum val)
{
    using EnumType = DiagnosticLogs::StatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kExhausted:
    case EnumType::kNoLogs:
    case EnumType::kBusy:
    case EnumType::kDenied:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DiagnosticLogs::TransferProtocolEnum val)
{
    using EnumType = DiagnosticLogs::TransferProtocolEnum;
    switch (val)
    {
    case EnumType::kResponsePayload:
    case EnumType::kBdx:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::BootReasonEnum val)
{
    using EnumType = GeneralDiagnostics::BootReasonEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kPowerOnReboot:
    case EnumType::kBrownOutReset:
    case EnumType::kSoftwareWatchdogReset:
    case EnumType::kHardwareWatchdogReset:
    case EnumType::kSoftwareUpdateCompleted:
    case EnumType::kSoftwareReset:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::HardwareFaultEnum val)
{
    using EnumType = GeneralDiagnostics::HardwareFaultEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kRadio:
    case EnumType::kSensor:
    case EnumType::kResettableOverTemp:
    case EnumType::kNonResettableOverTemp:
    case EnumType::kPowerSource:
    case EnumType::kVisualDisplayFault:
    case EnumType::kAudioOutputFault:
    case EnumType::kUserInterfaceFault:
    case EnumType::kNonVolatileMemoryError:
    case EnumType::kTamperDetected:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::InterfaceTypeEnum val)
{
    using EnumType = GeneralDiagnostics::InterfaceTypeEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kWiFi:
    case EnumType::kEthernet:
    case EnumType::kCellular:
    case EnumType::kThread:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::NetworkFaultEnum val)
{
    using EnumType = GeneralDiagnostics::NetworkFaultEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kHardwareFailure:
    case EnumType::kNetworkJammed:
    case EnumType::kConnectionFailed:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::RadioFaultEnum val)
{
    using EnumType = GeneralDiagnostics::RadioFaultEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kWiFiFault:
    case EnumType::kCellularFault:
    case EnumType::kThreadFault:
    case EnumType::kNFCFault:
    case EnumType::kBLEFault:
    case EnumType::kEthernetFault:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ThreadNetworkDiagnostics::ConnectionStatusEnum val)
{
    using EnumType = ThreadNetworkDiagnostics::ConnectionStatusEnum;
    switch (val)
    {
    case EnumType::kConnected:
    case EnumType::kNotConnected:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ThreadNetworkDiagnostics::NetworkFaultEnum val)
{
    using EnumType = ThreadNetworkDiagnostics::NetworkFaultEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kLinkDown:
    case EnumType::kHardwareFailure:
    case EnumType::kNetworkJammed:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ThreadNetworkDiagnostics::RoutingRoleEnum val)
{
    using EnumType = ThreadNetworkDiagnostics::RoutingRoleEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kUnassigned:
    case EnumType::kSleepyEndDevice:
    case EnumType::kEndDevice:
    case EnumType::kReed:
    case EnumType::kRouter:
    case EnumType::kLeader:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(WiFiNetworkDiagnostics::AssociationFailureCauseEnum val)
{
    using EnumType = WiFiNetworkDiagnostics::AssociationFailureCauseEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kAssociationFailed:
    case EnumType::kAuthenticationFailed:
    case EnumType::kSsidNotFound:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(WiFiNetworkDiagnostics::ConnectionStatusEnum val)
{
    using EnumType = WiFiNetworkDiagnostics::ConnectionStatusEnum;
    switch (val)
    {
    case EnumType::kConnected:
    case EnumType::kNotConnected:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(WiFiNetworkDiagnostics::SecurityTypeEnum val)
{
    using EnumType = WiFiNetworkDiagnostics::SecurityTypeEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kNone:
    case EnumType::kWep:
    case EnumType::kWpa:
    case EnumType::kWpa2:
    case EnumType::kWpa3:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(WiFiNetworkDiagnostics::WiFiVersionEnum val)
{
    using EnumType = WiFiNetworkDiagnostics::WiFiVersionEnum;
    switch (val)
    {
    case EnumType::kA:
    case EnumType::kB:
    case EnumType::kG:
    case EnumType::kN:
    case EnumType::kAc:
    case EnumType::kAx:
    case EnumType::kAh:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(EthernetNetworkDiagnostics::PHYRateEnum val)
{
    using EnumType = EthernetNetworkDiagnostics::PHYRateEnum;
    switch (val)
    {
    case EnumType::kRate10M:
    case EnumType::kRate100M:
    case EnumType::kRate1G:
    case EnumType::kRate25g:
    case EnumType::kRate5G:
    case EnumType::kRate10G:
    case EnumType::kRate40G:
    case EnumType::kRate100G:
    case EnumType::kRate200G:
    case EnumType::kRate400G:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(TimeSynchronization::GranularityEnum val)
{
    using EnumType = TimeSynchronization::GranularityEnum;
    switch (val)
    {
    case EnumType::kNoTimeGranularity:
    case EnumType::kMinutesGranularity:
    case EnumType::kSecondsGranularity:
    case EnumType::kMillisecondsGranularity:
    case EnumType::kMicrosecondsGranularity:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(TimeSynchronization::StatusCode val)
{
    using EnumType = TimeSynchronization::StatusCode;
    switch (val)
    {
    case EnumType::kTimeNotAccepted:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(TimeSynchronization::TimeSourceEnum val)
{
    using EnumType = TimeSynchronization::TimeSourceEnum;
    switch (val)
    {
    case EnumType::kNone:
    case EnumType::kUnknown:
    case EnumType::kAdmin:
    case EnumType::kNodeTimeCluster:
    case EnumType::kNonMatterSNTP:
    case EnumType::kNonMatterNTP:
    case EnumType::kMatterSNTP:
    case EnumType::kMatterNTP:
    case EnumType::kMixedNTP:
    case EnumType::kNonMatterSNTPNTS:
    case EnumType::kNonMatterNTPNTS:
    case EnumType::kMatterSNTPNTS:
    case EnumType::kMatterNTPNTS:
    case EnumType::kMixedNTPNTS:
    case EnumType::kCloudSource:
    case EnumType::kPtp:
    case EnumType::kGnss:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(TimeSynchronization::TimeZoneDatabaseEnum val)
{
    using EnumType = TimeSynchronization::TimeZoneDatabaseEnum;
    switch (val)
    {
    case EnumType::kFull:
    case EnumType::kPartial:
    case EnumType::kNone:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(BridgedDeviceBasicInformation::ColorEnum val)
{
    using EnumType = BridgedDeviceBasicInformation::ColorEnum;
    switch (val)
    {
    case EnumType::kBlack:
    case EnumType::kNavy:
    case EnumType::kGreen:
    case EnumType::kTeal:
    case EnumType::kMaroon:
    case EnumType::kPurple:
    case EnumType::kOlive:
    case EnumType::kGray:
    case EnumType::kBlue:
    case EnumType::kLime:
    case EnumType::kAqua:
    case EnumType::kRed:
    case EnumType::kFuchsia:
    case EnumType::kYellow:
    case EnumType::kWhite:
    case EnumType::kNickel:
    case EnumType::kChrome:
    case EnumType::kBrass:
    case EnumType::kCopper:
    case EnumType::kSilver:
    case EnumType::kGold:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(BridgedDeviceBasicInformation::ProductFinishEnum val)
{
    using EnumType = BridgedDeviceBasicInformation::ProductFinishEnum;
    switch (val)
    {
    case EnumType::kOther:
    case EnumType::kMatte:
    case EnumType::kSatin:
    case EnumType::kPolished:
    case EnumType::kRugged:
    case EnumType::kFabric:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(AdministratorCommissioning::CommissioningWindowStatusEnum val)
{
    using EnumType = AdministratorCommissioning::CommissioningWindowStatusEnum;
    switch (val)
    {
    case EnumType::kWindowNotOpen:
    case EnumType::kEnhancedWindowOpen:
    case EnumType::kBasicWindowOpen:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(AdministratorCommissioning::StatusCode val)
{
    using EnumType = AdministratorCommissioning::StatusCode;
    switch (val)
    {
    case EnumType::kBusy:
    case EnumType::kPAKEParameterError:
    case EnumType::kWindowNotOpen:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OperationalCredentials::CertificateChainTypeEnum val)
{
    using EnumType = OperationalCredentials::CertificateChainTypeEnum;
    switch (val)
    {
    case EnumType::kDACCertificate:
    case EnumType::kPAICertificate:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OperationalCredentials::NodeOperationalCertStatusEnum val)
{
    using EnumType = OperationalCredentials::NodeOperationalCertStatusEnum;
    switch (val)
    {
    case EnumType::kOk:
    case EnumType::kInvalidPublicKey:
    case EnumType::kInvalidNodeOpId:
    case EnumType::kInvalidNOC:
    case EnumType::kMissingCsr:
    case EnumType::kTableFull:
    case EnumType::kInvalidAdminSubject:
    case EnumType::kFabricConflict:
    case EnumType::kLabelConflict:
    case EnumType::kInvalidFabricIndex:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(GroupKeyManagement::GroupKeySecurityPolicyEnum val)
{
    using EnumType = GroupKeyManagement::GroupKeySecurityPolicyEnum;
    switch (val)
    {
    case EnumType::kTrustFirst:
    case EnumType::kCacheAndSync:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(IcdManagement::ClientTypeEnum val)
{
    using EnumType = IcdManagement::ClientTypeEnum;
    switch (val)
    {
    case EnumType::kPermanent:
    case EnumType::kEphemeral:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(IcdManagement::OperatingModeEnum val)
{
    using EnumType = IcdManagement::OperatingModeEnum;
    switch (val)
    {
    case EnumType::kSit:
    case EnumType::kLit:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Timer::TimerStatusEnum val)
{
    using EnumType = Timer::TimerStatusEnum;
    switch (val)
    {
    case EnumType::kRunning:
    case EnumType::kPaused:
    case EnumType::kExpired:
    case EnumType::kReady:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OvenCavityOperationalState::ErrorStateEnum val)
{
    using EnumType = OvenCavityOperationalState::ErrorStateEnum;
    switch (val)
    {
    case EnumType::kNoError:
    case EnumType::kUnableToStartOrResume:
    case EnumType::kUnableToCompleteOperation:
    case EnumType::kCommandInvalidInState:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OvenCavityOperationalState::OperationalStateEnum val)
{
    using EnumType = OvenCavityOperationalState::OperationalStateEnum;
    switch (val)
    {
    case EnumType::kStopped:
    case EnumType::kRunning:
    case EnumType::kPaused:
    case EnumType::kError:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OvenMode::ModeTag val)
{
    using EnumType = OvenMode::ModeTag;
    switch (val)
    {
    case EnumType::kAuto:
    case EnumType::kQuick:
    case EnumType::kQuiet:
    case EnumType::kLowNoise:
    case EnumType::kLowEnergy:
    case EnumType::kVacation:
    case EnumType::kMin:
    case EnumType::kMax:
    case EnumType::kNight:
    case EnumType::kDay:
    case EnumType::kBake:
    case EnumType::kConvection:
    case EnumType::kGrill:
    case EnumType::kRoast:
    case EnumType::kClean:
    case EnumType::kConvectionBake:
    case EnumType::kConvectionRoast:
    case EnumType::kWarming:
    case EnumType::kProofing:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(LaundryDryerControls::DrynessLevelEnum val)
{
    using EnumType = LaundryDryerControls::DrynessLevelEnum;
    switch (val)
    {
    case EnumType::kLow:
    case EnumType::kNormal:
    case EnumType::kExtra:
    case EnumType::kMax:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(LaundryWasherControls::NumberOfRinsesEnum val)
{
    using EnumType = LaundryWasherControls::NumberOfRinsesEnum;
    switch (val)
    {
    case EnumType::kNone:
    case EnumType::kNormal:
    case EnumType::kExtra:
    case EnumType::kMax:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(AirQuality::AirQualityEnum val)
{
    using EnumType = AirQuality::AirQualityEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kGood:
    case EnumType::kFair:
    case EnumType::kModerate:
    case EnumType::kPoor:
    case EnumType::kVeryPoor:
    case EnumType::kExtremelyPoor:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(SmokeCoAlarm::AlarmStateEnum val)
{
    using EnumType = SmokeCoAlarm::AlarmStateEnum;
    switch (val)
    {
    case EnumType::kNormal:
    case EnumType::kWarning:
    case EnumType::kCritical:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(SmokeCoAlarm::ContaminationStateEnum val)
{
    using EnumType = SmokeCoAlarm::ContaminationStateEnum;
    switch (val)
    {
    case EnumType::kNormal:
    case EnumType::kLow:
    case EnumType::kWarning:
    case EnumType::kCritical:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(SmokeCoAlarm::EndOfServiceEnum val)
{
    using EnumType = SmokeCoAlarm::EndOfServiceEnum;
    switch (val)
    {
    case EnumType::kNormal:
    case EnumType::kExpired:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(SmokeCoAlarm::ExpressedStateEnum val)
{
    using EnumType = SmokeCoAlarm::ExpressedStateEnum;
    switch (val)
    {
    case EnumType::kNormal:
    case EnumType::kSmokeAlarm:
    case EnumType::kCOAlarm:
    case EnumType::kBatteryAlert:
    case EnumType::kTesting:
    case EnumType::kHardwareFault:
    case EnumType::kEndOfService:
    case EnumType::kInterconnectSmoke:
    case EnumType::kInterconnectCO:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(SmokeCoAlarm::MuteStateEnum val)
{
    using EnumType = SmokeCoAlarm::MuteStateEnum;
    switch (val)
    {
    case EnumType::kNotMuted:
    case EnumType::kMuted:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(SmokeCoAlarm::SensitivityEnum val)
{
    using EnumType = SmokeCoAlarm::SensitivityEnum;
    switch (val)
    {
    case EnumType::kHigh:
    case EnumType::kStandard:
    case EnumType::kLow:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(MicrowaveOvenMode::ModeTag val)
{
    using EnumType = MicrowaveOvenMode::ModeTag;
    switch (val)
    {
    case EnumType::kAuto:
    case EnumType::kQuick:
    case EnumType::kQuiet:
    case EnumType::kLowNoise:
    case EnumType::kLowEnergy:
    case EnumType::kVacation:
    case EnumType::kMin:
    case EnumType::kMax:
    case EnumType::kNight:
    case EnumType::kDay:
    case EnumType::kNormal:
    case EnumType::kDefrost:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OperationalState::ErrorStateEnum val)
{
    using EnumType = OperationalState::ErrorStateEnum;
    switch (val)
    {
    case EnumType::kNoError:
    case EnumType::kUnableToStartOrResume:
    case EnumType::kUnableToCompleteOperation:
    case EnumType::kCommandInvalidInState:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OperationalState::OperationalStateEnum val)
{
    using EnumType = OperationalState::OperationalStateEnum;
    switch (val)
    {
    case EnumType::kStopped:
    case EnumType::kRunning:
    case EnumType::kPaused:
    case EnumType::kError:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ValveConfigurationAndControl::StatusCodeEnum val)
{
    using EnumType = ValveConfigurationAndControl::StatusCodeEnum;
    switch (val)
    {
    case EnumType::kFailureDueToFault:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ValveConfigurationAndControl::ValveStateEnum val)
{
    using EnumType = ValveConfigurationAndControl::ValveStateEnum;
    switch (val)
    {
    case EnumType::kClosed:
    case EnumType::kOpen:
    case EnumType::kTransitioning:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ElectricalPowerMeasurement::PowerModeEnum val)
{
    using EnumType = ElectricalPowerMeasurement::PowerModeEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kDc:
    case EnumType::kAc:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(WaterHeaterManagement::BoostStateEnum val)
{
    using EnumType = WaterHeaterManagement::BoostStateEnum;
    switch (val)
    {
    case EnumType::kInactive:
    case EnumType::kActive:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(DemandResponseLoadControl::CriticalityLevelEnum val)
{
    using EnumType = DemandResponseLoadControl::CriticalityLevelEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kGreen:
    case EnumType::kLevel1:
    case EnumType::kLevel2:
    case EnumType::kLevel3:
    case EnumType::kLevel4:
    case EnumType::kLevel5:
    case EnumType::kEmergency:
    case EnumType::kPlannedOutage:
    case EnumType::kServiceDisconnect:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DemandResponseLoadControl::HeatingSourceEnum val)
{
    using EnumType = DemandResponseLoadControl::HeatingSourceEnum;
    switch (val)
    {
    case EnumType::kAny:
    case EnumType::kElectric:
    case EnumType::kNonElectric:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DemandResponseLoadControl::LoadControlEventChangeSourceEnum val)
{
    using EnumType = DemandResponseLoadControl::LoadControlEventChangeSourceEnum;
    switch (val)
    {
    case EnumType::kAutomatic:
    case EnumType::kUserAction:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DemandResponseLoadControl::LoadControlEventStatusEnum val)
{
    using EnumType = DemandResponseLoadControl::LoadControlEventStatusEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kReceived:
    case EnumType::kInProgress:
    case EnumType::kCompleted:
    case EnumType::kOptedOut:
    case EnumType::kOptedIn:
    case EnumType::kCanceled:
    case EnumType::kSuperseded:
    case EnumType::kPartialOptedOut:
    case EnumType::kPartialOptedIn:
    case EnumType::kNoParticipation:
    case EnumType::kUnavailable:
    case EnumType::kFailed:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Messages::FutureMessagePreferenceEnum val)
{
    using EnumType = Messages::FutureMessagePreferenceEnum;
    switch (val)
    {
    case EnumType::kAllowed:
    case EnumType::kIncreased:
    case EnumType::kReduced:
    case EnumType::kDisallowed:
    case EnumType::kBanned:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Messages::MessagePriorityEnum val)
{
    using EnumType = Messages::MessagePriorityEnum;
    switch (val)
    {
    case EnumType::kLow:
    case EnumType::kMedium:
    case EnumType::kHigh:
    case EnumType::kCritical:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(DeviceEnergyManagement::AdjustmentCauseEnum val)
{
    using EnumType = DeviceEnergyManagement::AdjustmentCauseEnum;
    switch (val)
    {
    case EnumType::kLocalOptimization:
    case EnumType::kGridOptimization:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DeviceEnergyManagement::CauseEnum val)
{
    using EnumType = DeviceEnergyManagement::CauseEnum;
    switch (val)
    {
    case EnumType::kNormalCompletion:
    case EnumType::kOffline:
    case EnumType::kFault:
    case EnumType::kUserOptOut:
    case EnumType::kCancelled:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DeviceEnergyManagement::CostTypeEnum val)
{
    using EnumType = DeviceEnergyManagement::CostTypeEnum;
    switch (val)
    {
    case EnumType::kFinancial:
    case EnumType::kGHGEmissions:
    case EnumType::kComfort:
    case EnumType::kTemperature:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DeviceEnergyManagement::ESAStateEnum val)
{
    using EnumType = DeviceEnergyManagement::ESAStateEnum;
    switch (val)
    {
    case EnumType::kOffline:
    case EnumType::kOnline:
    case EnumType::kFault:
    case EnumType::kPowerAdjustActive:
    case EnumType::kPaused:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DeviceEnergyManagement::ESATypeEnum val)
{
    using EnumType = DeviceEnergyManagement::ESATypeEnum;
    switch (val)
    {
    case EnumType::kEvse:
    case EnumType::kSpaceHeating:
    case EnumType::kWaterHeating:
    case EnumType::kSpaceCooling:
    case EnumType::kSpaceHeatingCooling:
    case EnumType::kBatteryStorage:
    case EnumType::kSolarPV:
    case EnumType::kFridgeFreezer:
    case EnumType::kWashingMachine:
    case EnumType::kDishwasher:
    case EnumType::kCooking:
    case EnumType::kHomeWaterPump:
    case EnumType::kIrrigationWaterPump:
    case EnumType::kPoolPump:
    case EnumType::kOther:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DeviceEnergyManagement::ForecastUpdateReasonEnum val)
{
    using EnumType = DeviceEnergyManagement::ForecastUpdateReasonEnum;
    switch (val)
    {
    case EnumType::kInternalOptimization:
    case EnumType::kLocalOptimization:
    case EnumType::kGridOptimization:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DeviceEnergyManagement::OptOutStateEnum val)
{
    using EnumType = DeviceEnergyManagement::OptOutStateEnum;
    switch (val)
    {
    case EnumType::kNoOptOut:
    case EnumType::kLocalOptOut:
    case EnumType::kGridOptOut:
    case EnumType::kOptOut:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DeviceEnergyManagement::PowerAdjustReasonEnum val)
{
    using EnumType = DeviceEnergyManagement::PowerAdjustReasonEnum;
    switch (val)
    {
    case EnumType::kNoAdjustment:
    case EnumType::kLocalOptimizationAdjustment:
    case EnumType::kGridOptimizationAdjustment:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(EnergyEvse::EnergyTransferStoppedReasonEnum val)
{
    using EnumType = EnergyEvse::EnergyTransferStoppedReasonEnum;
    switch (val)
    {
    case EnumType::kEVStopped:
    case EnumType::kEVSEStopped:
    case EnumType::kOther:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(EnergyEvse::FaultStateEnum val)
{
    using EnumType = EnergyEvse::FaultStateEnum;
    switch (val)
    {
    case EnumType::kNoError:
    case EnumType::kMeterFailure:
    case EnumType::kOverVoltage:
    case EnumType::kUnderVoltage:
    case EnumType::kOverCurrent:
    case EnumType::kContactWetFailure:
    case EnumType::kContactDryFailure:
    case EnumType::kGroundFault:
    case EnumType::kPowerLoss:
    case EnumType::kPowerQuality:
    case EnumType::kPilotShortCircuit:
    case EnumType::kEmergencyStop:
    case EnumType::kEVDisconnected:
    case EnumType::kWrongPowerSupply:
    case EnumType::kLiveNeutralSwap:
    case EnumType::kOverTemperature:
    case EnumType::kOther:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(EnergyEvse::StateEnum val)
{
    using EnumType = EnergyEvse::StateEnum;
    switch (val)
    {
    case EnumType::kNotPluggedIn:
    case EnumType::kPluggedInNoDemand:
    case EnumType::kPluggedInDemand:
    case EnumType::kPluggedInCharging:
    case EnumType::kPluggedInDischarging:
    case EnumType::kSessionEnding:
    case EnumType::kFault:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(EnergyEvse::SupplyStateEnum val)
{
    using EnumType = EnergyEvse::SupplyStateEnum;
    switch (val)
    {
    case EnumType::kDisabled:
    case EnumType::kChargingEnabled:
    case EnumType::kDischargingEnabled:
    case EnumType::kDisabledError:
    case EnumType::kDisabledDiagnostics:
    case EnumType::kEnabled:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(EnergyPreference::EnergyPriorityEnum val)
{
    using EnumType = EnergyPreference::EnergyPriorityEnum;
    switch (val)
    {
    case EnumType::kComfort:
    case EnumType::kSpeed:
    case EnumType::kEfficiency:
    case EnumType::kWaterConsumption:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::AlarmCodeEnum val)
{
    using EnumType = DoorLock::AlarmCodeEnum;
    switch (val)
    {
    case EnumType::kLockJammed:
    case EnumType::kLockFactoryReset:
    case EnumType::kLockRadioPowerCycled:
    case EnumType::kWrongCodeEntryLimit:
    case EnumType::kFrontEsceutcheonRemoved:
    case EnumType::kDoorForcedOpen:
    case EnumType::kDoorAjar:
    case EnumType::kForcedUser:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::CredentialRuleEnum val)
{
    using EnumType = DoorLock::CredentialRuleEnum;
    switch (val)
    {
    case EnumType::kSingle:
    case EnumType::kDual:
    case EnumType::kTri:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::CredentialTypeEnum val)
{
    using EnumType = DoorLock::CredentialTypeEnum;
    switch (val)
    {
    case EnumType::kProgrammingPIN:
    case EnumType::kPin:
    case EnumType::kRfid:
    case EnumType::kFingerprint:
    case EnumType::kFingerVein:
    case EnumType::kFace:
    case EnumType::kAliroCredentialIssuerKey:
    case EnumType::kAliroEvictableEndpointKey:
    case EnumType::kAliroNonEvictableEndpointKey:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DataOperationTypeEnum val)
{
    using EnumType = DoorLock::DataOperationTypeEnum;
    switch (val)
    {
    case EnumType::kAdd:
    case EnumType::kClear:
    case EnumType::kModify:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlLockState val)
{
    using EnumType = DoorLock::DlLockState;
    switch (val)
    {
    case EnumType::kNotFullyLocked:
    case EnumType::kLocked:
    case EnumType::kUnlocked:
    case EnumType::kUnlatched:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlLockType val)
{
    using EnumType = DoorLock::DlLockType;
    switch (val)
    {
    case EnumType::kDeadBolt:
    case EnumType::kMagnetic:
    case EnumType::kOther:
    case EnumType::kMortise:
    case EnumType::kRim:
    case EnumType::kLatchBolt:
    case EnumType::kCylindricalLock:
    case EnumType::kTubularLock:
    case EnumType::kInterconnectedLock:
    case EnumType::kDeadLatch:
    case EnumType::kDoorFurniture:
    case EnumType::kEurocylinder:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlStatus val)
{
    using EnumType = DoorLock::DlStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kFailure:
    case EnumType::kDuplicate:
    case EnumType::kOccupied:
    case EnumType::kInvalidField:
    case EnumType::kResourceExhausted:
    case EnumType::kNotFound:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockOperationEventCode val)
{
    using EnumType = DoorLock::DoorLockOperationEventCode;
    switch (val)
    {
    case EnumType::kUnknownOrMfgSpecific:
    case EnumType::kLock:
    case EnumType::kUnlock:
    case EnumType::kLockInvalidPinOrId:
    case EnumType::kLockInvalidSchedule:
    case EnumType::kUnlockInvalidPinOrId:
    case EnumType::kUnlockInvalidSchedule:
    case EnumType::kOneTouchLock:
    case EnumType::kKeyLock:
    case EnumType::kKeyUnlock:
    case EnumType::kAutoLock:
    case EnumType::kScheduleLock:
    case EnumType::kScheduleUnlock:
    case EnumType::kManualLock:
    case EnumType::kManualUnlock:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockProgrammingEventCode val)
{
    using EnumType = DoorLock::DoorLockProgrammingEventCode;
    switch (val)
    {
    case EnumType::kUnknownOrMfgSpecific:
    case EnumType::kMasterCodeChanged:
    case EnumType::kPinAdded:
    case EnumType::kPinDeleted:
    case EnumType::kPinChanged:
    case EnumType::kIdAdded:
    case EnumType::kIdDeleted:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockSetPinOrIdStatus val)
{
    using EnumType = DoorLock::DoorLockSetPinOrIdStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kGeneralFailure:
    case EnumType::kMemoryFull:
    case EnumType::kDuplicateCodeError:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockUserStatus val)
{
    using EnumType = DoorLock::DoorLockUserStatus;
    switch (val)
    {
    case EnumType::kAvailable:
    case EnumType::kOccupiedEnabled:
    case EnumType::kOccupiedDisabled:
    case EnumType::kNotSupported:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockUserType val)
{
    using EnumType = DoorLock::DoorLockUserType;
    switch (val)
    {
    case EnumType::kUnrestricted:
    case EnumType::kYearDayScheduleUser:
    case EnumType::kWeekDayScheduleUser:
    case EnumType::kMasterUser:
    case EnumType::kNonAccessUser:
    case EnumType::kNotSupported:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorStateEnum val)
{
    using EnumType = DoorLock::DoorStateEnum;
    switch (val)
    {
    case EnumType::kDoorOpen:
    case EnumType::kDoorClosed:
    case EnumType::kDoorJammed:
    case EnumType::kDoorForcedOpen:
    case EnumType::kDoorUnspecifiedError:
    case EnumType::kDoorAjar:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::LockDataTypeEnum val)
{
    using EnumType = DoorLock::LockDataTypeEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kProgrammingCode:
    case EnumType::kUserIndex:
    case EnumType::kWeekDaySchedule:
    case EnumType::kYearDaySchedule:
    case EnumType::kHolidaySchedule:
    case EnumType::kPin:
    case EnumType::kRfid:
    case EnumType::kFingerprint:
    case EnumType::kFingerVein:
    case EnumType::kFace:
    case EnumType::kAliroCredentialIssuerKey:
    case EnumType::kAliroEvictableEndpointKey:
    case EnumType::kAliroNonEvictableEndpointKey:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::LockOperationTypeEnum val)
{
    using EnumType = DoorLock::LockOperationTypeEnum;
    switch (val)
    {
    case EnumType::kLock:
    case EnumType::kUnlock:
    case EnumType::kNonAccessUserEvent:
    case EnumType::kForcedUserEvent:
    case EnumType::kUnlatch:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::OperatingModeEnum val)
{
    using EnumType = DoorLock::OperatingModeEnum;
    switch (val)
    {
    case EnumType::kNormal:
    case EnumType::kVacation:
    case EnumType::kPrivacy:
    case EnumType::kNoRemoteLockUnlock:
    case EnumType::kPassage:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::OperationErrorEnum val)
{
    using EnumType = DoorLock::OperationErrorEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kInvalidCredential:
    case EnumType::kDisabledUserDenied:
    case EnumType::kRestricted:
    case EnumType::kInsufficientBattery:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::OperationSourceEnum val)
{
    using EnumType = DoorLock::OperationSourceEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kManual:
    case EnumType::kProprietaryRemote:
    case EnumType::kKeypad:
    case EnumType::kAuto:
    case EnumType::kButton:
    case EnumType::kSchedule:
    case EnumType::kRemote:
    case EnumType::kRfid:
    case EnumType::kBiometric:
    case EnumType::kAliro:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::UserStatusEnum val)
{
    using EnumType = DoorLock::UserStatusEnum;
    switch (val)
    {
    case EnumType::kAvailable:
    case EnumType::kOccupiedEnabled:
    case EnumType::kOccupiedDisabled:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::UserTypeEnum val)
{
    using EnumType = DoorLock::UserTypeEnum;
    switch (val)
    {
    case EnumType::kUnrestrictedUser:
    case EnumType::kYearDayScheduleUser:
    case EnumType::kWeekDayScheduleUser:
    case EnumType::kProgrammingUser:
    case EnumType::kNonAccessUser:
    case EnumType::kForcedUser:
    case EnumType::kDisposableUser:
    case EnumType::kExpiringUser:
    case EnumType::kScheduleRestrictedUser:
    case EnumType::kRemoteOnlyUser:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(WindowCovering::EndProductType val)
{
    using EnumType = WindowCovering::EndProductType;
    switch (val)
    {
    case EnumType::kRollerShade:
    case EnumType::kRomanShade:
    case EnumType::kBalloonShade:
    case EnumType::kWovenWood:
    case EnumType::kPleatedShade:
    case EnumType::kCellularShade:
    case EnumType::kLayeredShade:
    case EnumType::kLayeredShade2D:
    case EnumType::kSheerShade:
    case EnumType::kTiltOnlyInteriorBlind:
    case EnumType::kInteriorBlind:
    case EnumType::kVerticalBlindStripCurtain:
    case EnumType::kInteriorVenetianBlind:
    case EnumType::kExteriorVenetianBlind:
    case EnumType::kLateralLeftCurtain:
    case EnumType::kLateralRightCurtain:
    case EnumType::kCentralCurtain:
    case EnumType::kRollerShutter:
    case EnumType::kExteriorVerticalScreen:
    case EnumType::kAwningTerracePatio:
    case EnumType::kAwningVerticalScreen:
    case EnumType::kTiltOnlyPergola:
    case EnumType::kSwingingShutter:
    case EnumType::kSlidingShutter:
    case EnumType::kUnknown:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(WindowCovering::Type val)
{
    using EnumType = WindowCovering::Type;
    switch (val)
    {
    case EnumType::kRollerShade:
    case EnumType::kRollerShade2Motor:
    case EnumType::kRollerShadeExterior:
    case EnumType::kRollerShadeExterior2Motor:
    case EnumType::kDrapery:
    case EnumType::kAwning:
    case EnumType::kShutter:
    case EnumType::kTiltBlindTiltOnly:
    case EnumType::kTiltBlindLiftAndTilt:
    case EnumType::kProjectorScreen:
    case EnumType::kUnknown:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ServiceArea::OperationalStatusEnum val)
{
    using EnumType = ServiceArea::OperationalStatusEnum;
    switch (val)
    {
    case EnumType::kPending:
    case EnumType::kOperating:
    case EnumType::kSkipped:
    case EnumType::kCompleted:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ServiceArea::SelectAreasStatus val)
{
    using EnumType = ServiceArea::SelectAreasStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kUnsupportedArea:
    case EnumType::kInvalidInMode:
    case EnumType::kInvalidSet:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ServiceArea::SkipAreaStatus val)
{
    using EnumType = ServiceArea::SkipAreaStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kInvalidAreaList:
    case EnumType::kInvalidInMode:
    case EnumType::kInvalidSkippedArea:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(PumpConfigurationAndControl::ControlModeEnum val)
{
    using EnumType = PumpConfigurationAndControl::ControlModeEnum;
    switch (val)
    {
    case EnumType::kConstantSpeed:
    case EnumType::kConstantPressure:
    case EnumType::kProportionalPressure:
    case EnumType::kConstantFlow:
    case EnumType::kConstantTemperature:
    case EnumType::kAutomatic:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PumpConfigurationAndControl::OperationModeEnum val)
{
    using EnumType = PumpConfigurationAndControl::OperationModeEnum;
    switch (val)
    {
    case EnumType::kNormal:
    case EnumType::kMinimum:
    case EnumType::kMaximum:
    case EnumType::kLocal:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ACCapacityFormatEnum val)
{
    using EnumType = Thermostat::ACCapacityFormatEnum;
    switch (val)
    {
    case EnumType::kBTUh:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ACCompressorTypeEnum val)
{
    using EnumType = Thermostat::ACCompressorTypeEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kT1:
    case EnumType::kT2:
    case EnumType::kT3:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ACLouverPositionEnum val)
{
    using EnumType = Thermostat::ACLouverPositionEnum;
    switch (val)
    {
    case EnumType::kClosed:
    case EnumType::kOpen:
    case EnumType::kQuarter:
    case EnumType::kHalf:
    case EnumType::kThreeQuarters:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ACRefrigerantTypeEnum val)
{
    using EnumType = Thermostat::ACRefrigerantTypeEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kR22:
    case EnumType::kR410a:
    case EnumType::kR407c:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ACTypeEnum val)
{
    using EnumType = Thermostat::ACTypeEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kCoolingFixed:
    case EnumType::kHeatPumpFixed:
    case EnumType::kCoolingInverter:
    case EnumType::kHeatPumpInverter:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ControlSequenceOfOperationEnum val)
{
    using EnumType = Thermostat::ControlSequenceOfOperationEnum;
    switch (val)
    {
    case EnumType::kCoolingOnly:
    case EnumType::kCoolingWithReheat:
    case EnumType::kHeatingOnly:
    case EnumType::kHeatingWithReheat:
    case EnumType::kCoolingAndHeating:
    case EnumType::kCoolingAndHeatingWithReheat:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::PresetScenarioEnum val)
{
    using EnumType = Thermostat::PresetScenarioEnum;
    switch (val)
    {
    case EnumType::kOccupied:
    case EnumType::kUnoccupied:
    case EnumType::kSleep:
    case EnumType::kWake:
    case EnumType::kVacation:
    case EnumType::kGoingToSleep:
    case EnumType::kUserDefined:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::SetpointChangeSourceEnum val)
{
    using EnumType = Thermostat::SetpointChangeSourceEnum;
    switch (val)
    {
    case EnumType::kManual:
    case EnumType::kSchedule:
    case EnumType::kExternal:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::SetpointRaiseLowerModeEnum val)
{
    using EnumType = Thermostat::SetpointRaiseLowerModeEnum;
    switch (val)
    {
    case EnumType::kHeat:
    case EnumType::kCool:
    case EnumType::kBoth:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::StartOfWeekEnum val)
{
    using EnumType = Thermostat::StartOfWeekEnum;
    switch (val)
    {
    case EnumType::kSunday:
    case EnumType::kMonday:
    case EnumType::kTuesday:
    case EnumType::kWednesday:
    case EnumType::kThursday:
    case EnumType::kFriday:
    case EnumType::kSaturday:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::SystemModeEnum val)
{
    using EnumType = Thermostat::SystemModeEnum;
    switch (val)
    {
    case EnumType::kOff:
    case EnumType::kAuto:
    case EnumType::kCool:
    case EnumType::kHeat:
    case EnumType::kEmergencyHeat:
    case EnumType::kPrecooling:
    case EnumType::kFanOnly:
    case EnumType::kDry:
    case EnumType::kSleep:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::TemperatureSetpointHoldEnum val)
{
    using EnumType = Thermostat::TemperatureSetpointHoldEnum;
    switch (val)
    {
    case EnumType::kSetpointHoldOff:
    case EnumType::kSetpointHoldOn:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ThermostatRunningModeEnum val)
{
    using EnumType = Thermostat::ThermostatRunningModeEnum;
    switch (val)
    {
    case EnumType::kOff:
    case EnumType::kCool:
    case EnumType::kHeat:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(FanControl::AirflowDirectionEnum val)
{
    using EnumType = FanControl::AirflowDirectionEnum;
    switch (val)
    {
    case EnumType::kForward:
    case EnumType::kReverse:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(FanControl::FanModeEnum val)
{
    using EnumType = FanControl::FanModeEnum;
    switch (val)
    {
    case EnumType::kOff:
    case EnumType::kLow:
    case EnumType::kMedium:
    case EnumType::kHigh:
    case EnumType::kOn:
    case EnumType::kAuto:
    case EnumType::kSmart:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(FanControl::FanModeSequenceEnum val)
{
    using EnumType = FanControl::FanModeSequenceEnum;
    switch (val)
    {
    case EnumType::kOffLowMedHigh:
    case EnumType::kOffLowHigh:
    case EnumType::kOffLowMedHighAuto:
    case EnumType::kOffLowHighAuto:
    case EnumType::kOffHighAuto:
    case EnumType::kOffHigh:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(FanControl::StepDirectionEnum val)
{
    using EnumType = FanControl::StepDirectionEnum;
    switch (val)
    {
    case EnumType::kIncrease:
    case EnumType::kDecrease:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ThermostatUserInterfaceConfiguration::KeypadLockoutEnum val)
{
    using EnumType = ThermostatUserInterfaceConfiguration::KeypadLockoutEnum;
    switch (val)
    {
    case EnumType::kNoLockout:
    case EnumType::kLockout1:
    case EnumType::kLockout2:
    case EnumType::kLockout3:
    case EnumType::kLockout4:
    case EnumType::kLockout5:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused))
EnsureKnownEnumValue(ThermostatUserInterfaceConfiguration::ScheduleProgrammingVisibilityEnum val)
{
    using EnumType = ThermostatUserInterfaceConfiguration::ScheduleProgrammingVisibilityEnum;
    switch (val)
    {
    case EnumType::kScheduleProgrammingPermitted:
    case EnumType::kScheduleProgrammingDenied:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ThermostatUserInterfaceConfiguration::TemperatureDisplayModeEnum val)
{
    using EnumType = ThermostatUserInterfaceConfiguration::TemperatureDisplayModeEnum;
    switch (val)
    {
    case EnumType::kCelsius:
    case EnumType::kFahrenheit:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::ColorLoopActionEnum val)
{
    using EnumType = ColorControl::ColorLoopActionEnum;
    switch (val)
    {
    case EnumType::kDeactivate:
    case EnumType::kActivateFromColorLoopStartEnhancedHue:
    case EnumType::kActivateFromEnhancedCurrentHue:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::ColorLoopDirectionEnum val)
{
    using EnumType = ColorControl::ColorLoopDirectionEnum;
    switch (val)
    {
    case EnumType::kDecrement:
    case EnumType::kIncrement:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::ColorModeEnum val)
{
    using EnumType = ColorControl::ColorModeEnum;
    switch (val)
    {
    case EnumType::kCurrentHueAndCurrentSaturation:
    case EnumType::kCurrentXAndCurrentY:
    case EnumType::kColorTemperatureMireds:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::DirectionEnum val)
{
    using EnumType = ColorControl::DirectionEnum;
    switch (val)
    {
    case EnumType::kShortest:
    case EnumType::kLongest:
    case EnumType::kUp:
    case EnumType::kDown:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::DriftCompensationEnum val)
{
    using EnumType = ColorControl::DriftCompensationEnum;
    switch (val)
    {
    case EnumType::kNone:
    case EnumType::kOtherOrUnknown:
    case EnumType::kTemperatureMonitoring:
    case EnumType::kOpticalLuminanceMonitoringAndFeedback:
    case EnumType::kOpticalColorMonitoringAndFeedback:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::EnhancedColorModeEnum val)
{
    using EnumType = ColorControl::EnhancedColorModeEnum;
    switch (val)
    {
    case EnumType::kCurrentHueAndCurrentSaturation:
    case EnumType::kCurrentXAndCurrentY:
    case EnumType::kColorTemperatureMireds:
    case EnumType::kEnhancedCurrentHueAndCurrentSaturation:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::MoveModeEnum val)
{
    using EnumType = ColorControl::MoveModeEnum;
    switch (val)
    {
    case EnumType::kStop:
    case EnumType::kUp:
    case EnumType::kDown:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::StepModeEnum val)
{
    using EnumType = ColorControl::StepModeEnum;
    switch (val)
    {
    case EnumType::kUp:
    case EnumType::kDown:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(IlluminanceMeasurement::LightSensorTypeEnum val)
{
    using EnumType = IlluminanceMeasurement::LightSensorTypeEnum;
    switch (val)
    {
    case EnumType::kPhotodiode:
    case EnumType::kCmos:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OccupancySensing::OccupancySensorTypeEnum val)
{
    using EnumType = OccupancySensing::OccupancySensorTypeEnum;
    switch (val)
    {
    case EnumType::kPir:
    case EnumType::kUltrasonic:
    case EnumType::kPIRAndUltrasonic:
    case EnumType::kPhysicalContact:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Channel::ChannelTypeEnum val)
{
    using EnumType = Channel::ChannelTypeEnum;
    switch (val)
    {
    case EnumType::kSatellite:
    case EnumType::kCable:
    case EnumType::kTerrestrial:
    case EnumType::kOtt:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Channel::LineupInfoTypeEnum val)
{
    using EnumType = Channel::LineupInfoTypeEnum;
    switch (val)
    {
    case EnumType::kMso:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Channel::StatusEnum val)
{
    using EnumType = Channel::StatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kMultipleMatches:
    case EnumType::kNoMatches:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(TargetNavigator::StatusEnum val)
{
    using EnumType = TargetNavigator::StatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kTargetNotFound:
    case EnumType::kNotAllowed:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(MediaPlayback::CharacteristicEnum val)
{
    using EnumType = MediaPlayback::CharacteristicEnum;
    switch (val)
    {
    case EnumType::kForcedSubtitles:
    case EnumType::kDescribesVideo:
    case EnumType::kEasyToRead:
    case EnumType::kFrameBased:
    case EnumType::kMainProgram:
    case EnumType::kOriginalContent:
    case EnumType::kVoiceOverTranslation:
    case EnumType::kCaption:
    case EnumType::kSubtitle:
    case EnumType::kAlternate:
    case EnumType::kSupplementary:
    case EnumType::kCommentary:
    case EnumType::kDubbedTranslation:
    case EnumType::kDescription:
    case EnumType::kMetadata:
    case EnumType::kEnhancedAudioIntelligibility:
    case EnumType::kEmergency:
    case EnumType::kKaraoke:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(MediaPlayback::PlaybackStateEnum val)
{
    using EnumType = MediaPlayback::PlaybackStateEnum;
    switch (val)
    {
    case EnumType::kPlaying:
    case EnumType::kPaused:
    case EnumType::kNotPlaying:
    case EnumType::kBuffering:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(MediaPlayback::StatusEnum val)
{
    using EnumType = MediaPlayback::StatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kInvalidStateForCommand:
    case EnumType::kNotAllowed:
    case EnumType::kNotActive:
    case EnumType::kSpeedOutOfRange:
    case EnumType::kSeekOutOfRange:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(MediaInput::InputTypeEnum val)
{
    using EnumType = MediaInput::InputTypeEnum;
    switch (val)
    {
    case EnumType::kInternal:
    case EnumType::kAux:
    case EnumType::kCoax:
    case EnumType::kComposite:
    case EnumType::kHdmi:
    case EnumType::kInput:
    case EnumType::kLine:
    case EnumType::kOptical:
    case EnumType::kVideo:
    case EnumType::kScart:
    case EnumType::kUsb:
    case EnumType::kOther:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(KeypadInput::CECKeyCodeEnum val)
{
    using EnumType = KeypadInput::CECKeyCodeEnum;
    switch (val)
    {
    case EnumType::kSelect:
    case EnumType::kUp:
    case EnumType::kDown:
    case EnumType::kLeft:
    case EnumType::kRight:
    case EnumType::kRightUp:
    case EnumType::kRightDown:
    case EnumType::kLeftUp:
    case EnumType::kLeftDown:
    case EnumType::kRootMenu:
    case EnumType::kSetupMenu:
    case EnumType::kContentsMenu:
    case EnumType::kFavoriteMenu:
    case EnumType::kExit:
    case EnumType::kMediaTopMenu:
    case EnumType::kMediaContextSensitiveMenu:
    case EnumType::kNumberEntryMode:
    case EnumType::kNumber11:
    case EnumType::kNumber12:
    case EnumType::kNumber0OrNumber10:
    case EnumType::kNumbers1:
    case EnumType::kNumbers2:
    case EnumType::kNumbers3:
    case EnumType::kNumbers4:
    case EnumType::kNumbers5:
    case EnumType::kNumbers6:
    case EnumType::kNumbers7:
    case EnumType::kNumbers8:
    case EnumType::kNumbers9:
    case EnumType::kDot:
    case EnumType::kEnter:
    case EnumType::kClear:
    case EnumType::kNextFavorite:
    case EnumType::kChannelUp:
    case EnumType::kChannelDown:
    case EnumType::kPreviousChannel:
    case EnumType::kSoundSelect:
    case EnumType::kInputSelect:
    case EnumType::kDisplayInformation:
    case EnumType::kHelp:
    case EnumType::kPageUp:
    case EnumType::kPageDown:
    case EnumType::kPower:
    case EnumType::kVolumeUp:
    case EnumType::kVolumeDown:
    case EnumType::kMute:
    case EnumType::kPlay:
    case EnumType::kStop:
    case EnumType::kPause:
    case EnumType::kRecord:
    case EnumType::kRewind:
    case EnumType::kFastForward:
    case EnumType::kEject:
    case EnumType::kForward:
    case EnumType::kBackward:
    case EnumType::kStopRecord:
    case EnumType::kPauseRecord:
    case EnumType::kReserved:
    case EnumType::kAngle:
    case EnumType::kSubPicture:
    case EnumType::kVideoOnDemand:
    case EnumType::kElectronicProgramGuide:
    case EnumType::kTimerProgramming:
    case EnumType::kInitialConfiguration:
    case EnumType::kSelectBroadcastType:
    case EnumType::kSelectSoundPresentation:
    case EnumType::kPlayFunction:
    case EnumType::kPausePlayFunction:
    case EnumType::kRecordFunction:
    case EnumType::kPauseRecordFunction:
    case EnumType::kStopFunction:
    case EnumType::kMuteFunction:
    case EnumType::kRestoreVolumeFunction:
    case EnumType::kTuneFunction:
    case EnumType::kSelectMediaFunction:
    case EnumType::kSelectAvInputFunction:
    case EnumType::kSelectAudioInputFunction:
    case EnumType::kPowerToggleFunction:
    case EnumType::kPowerOffFunction:
    case EnumType::kPowerOnFunction:
    case EnumType::kF1Blue:
    case EnumType::kF2Red:
    case EnumType::kF3Green:
    case EnumType::kF4Yellow:
    case EnumType::kF5:
    case EnumType::kData:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(KeypadInput::StatusEnum val)
{
    using EnumType = KeypadInput::StatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kUnsupportedKey:
    case EnumType::kInvalidKeyInCurrentState:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ContentLauncher::CharacteristicEnum val)
{
    using EnumType = ContentLauncher::CharacteristicEnum;
    switch (val)
    {
    case EnumType::kForcedSubtitles:
    case EnumType::kDescribesVideo:
    case EnumType::kEasyToRead:
    case EnumType::kFrameBased:
    case EnumType::kMainProgram:
    case EnumType::kOriginalContent:
    case EnumType::kVoiceOverTranslation:
    case EnumType::kCaption:
    case EnumType::kSubtitle:
    case EnumType::kAlternate:
    case EnumType::kSupplementary:
    case EnumType::kCommentary:
    case EnumType::kDubbedTranslation:
    case EnumType::kDescription:
    case EnumType::kMetadata:
    case EnumType::kEnhancedAudioIntelligibility:
    case EnumType::kEmergency:
    case EnumType::kKaraoke:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ContentLauncher::MetricTypeEnum val)
{
    using EnumType = ContentLauncher::MetricTypeEnum;
    switch (val)
    {
    case EnumType::kPixels:
    case EnumType::kPercentage:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ContentLauncher::ParameterEnum val)
{
    using EnumType = ContentLauncher::ParameterEnum;
    switch (val)
    {
    case EnumType::kActor:
    case EnumType::kChannel:
    case EnumType::kCharacter:
    case EnumType::kDirector:
    case EnumType::kEvent:
    case EnumType::kFranchise:
    case EnumType::kGenre:
    case EnumType::kLeague:
    case EnumType::kPopularity:
    case EnumType::kProvider:
    case EnumType::kSport:
    case EnumType::kSportsTeam:
    case EnumType::kType:
    case EnumType::kVideo:
    case EnumType::kSeason:
    case EnumType::kEpisode:
    case EnumType::kAny:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ContentLauncher::StatusEnum val)
{
    using EnumType = ContentLauncher::StatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kURLNotAvailable:
    case EnumType::kAuthFailed:
    case EnumType::kTextTrackNotAvailable:
    case EnumType::kAudioTrackNotAvailable:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(AudioOutput::OutputTypeEnum val)
{
    using EnumType = AudioOutput::OutputTypeEnum;
    switch (val)
    {
    case EnumType::kHdmi:
    case EnumType::kBt:
    case EnumType::kOptical:
    case EnumType::kHeadphone:
    case EnumType::kInternal:
    case EnumType::kOther:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ApplicationLauncher::StatusEnum val)
{
    using EnumType = ApplicationLauncher::StatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kAppNotAvailable:
    case EnumType::kSystemBusy:
    case EnumType::kPendingUserApproval:
    case EnumType::kDownloading:
    case EnumType::kInstalling:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ApplicationBasic::ApplicationStatusEnum val)
{
    using EnumType = ApplicationBasic::ApplicationStatusEnum;
    switch (val)
    {
    case EnumType::kStopped:
    case EnumType::kActiveVisibleFocus:
    case EnumType::kActiveHidden:
    case EnumType::kActiveVisibleNotFocus:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ContentAppObserver::StatusEnum val)
{
    using EnumType = ContentAppObserver::StatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kUnexpectedData:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(UnitTesting::SimpleEnum val)
{
    using EnumType = UnitTesting::SimpleEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kValueA:
    case EnumType::kValueB:
    case EnumType::kValueC:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(FaultInjection::FaultType val)
{
    using EnumType = FaultInjection::FaultType;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kSystemFault:
    case EnumType::kInetFault:
    case EnumType::kChipFault:
    case EnumType::kCertFault:
        return val;
    default:
        return EnumType::kUnknownEnumValue;
    }
}

} // namespace Clusters
} // namespace app
} // namespace chip
