/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** SDIO_SLC_HOST_FUNC2_0_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FUNC2_0_REG (DR_REG_SLCHOST_BASE + 0x10)
/** SDIO_SLC_HOST_SLC_FUNC2_INT : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_FUNC2_INT    (BIT(24))
#define SDIO_SLC_HOST_SLC_FUNC2_INT_M  (SDIO_SLC_HOST_SLC_FUNC2_INT_V << SDIO_SLC_HOST_SLC_FUNC2_INT_S)
#define SDIO_SLC_HOST_SLC_FUNC2_INT_V  0x00000001U
#define SDIO_SLC_HOST_SLC_FUNC2_INT_S  24

/** SDIO_SLC_HOST_FUNC2_1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FUNC2_1_REG (DR_REG_SLCHOST_BASE + 0x14)
/** SDIO_SLC_HOST_SLC_FUNC2_INT_EN : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_FUNC2_INT_EN    (BIT(0))
#define SDIO_SLC_HOST_SLC_FUNC2_INT_EN_M  (SDIO_SLC_HOST_SLC_FUNC2_INT_EN_V << SDIO_SLC_HOST_SLC_FUNC2_INT_EN_S)
#define SDIO_SLC_HOST_SLC_FUNC2_INT_EN_V  0x00000001U
#define SDIO_SLC_HOST_SLC_FUNC2_INT_EN_S  0

/** SDIO_SLC_HOST_FUNC2_2_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FUNC2_2_REG (DR_REG_SLCHOST_BASE + 0x20)
/** SDIO_SLC_HOST_SLC_FUNC1_MDSTAT : R/W; bitpos: [0]; default: 1;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_FUNC1_MDSTAT    (BIT(0))
#define SDIO_SLC_HOST_SLC_FUNC1_MDSTAT_M  (SDIO_SLC_HOST_SLC_FUNC1_MDSTAT_V << SDIO_SLC_HOST_SLC_FUNC1_MDSTAT_S)
#define SDIO_SLC_HOST_SLC_FUNC1_MDSTAT_V  0x00000001U
#define SDIO_SLC_HOST_SLC_FUNC1_MDSTAT_S  0

/** SDIO_SLC_HOST_GPIO_STATUS0_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_STATUS0_REG (DR_REG_SLCHOST_BASE + 0x34)
/** SDIO_SLC_HOST_GPIO_SDIO_INT0 : RO; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_INT0    0xFFFFFFFFU
#define SDIO_SLC_HOST_GPIO_SDIO_INT0_M  (SDIO_SLC_HOST_GPIO_SDIO_INT0_V << SDIO_SLC_HOST_GPIO_SDIO_INT0_S)
#define SDIO_SLC_HOST_GPIO_SDIO_INT0_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_GPIO_SDIO_INT0_S  0

/** SDIO_SLC_HOST_GPIO_STATUS1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_STATUS1_REG (DR_REG_SLCHOST_BASE + 0x38)
/** SDIO_SLC_HOST_GPIO_SDIO_INT1 : RO; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_INT1    0xFFFFFFFFU
#define SDIO_SLC_HOST_GPIO_SDIO_INT1_M  (SDIO_SLC_HOST_GPIO_SDIO_INT1_V << SDIO_SLC_HOST_GPIO_SDIO_INT1_S)
#define SDIO_SLC_HOST_GPIO_SDIO_INT1_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_GPIO_SDIO_INT1_S  0

/** SDIO_SLC_HOST_GPIO_IN0_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_IN0_REG (DR_REG_SLCHOST_BASE + 0x3c)
/** SDIO_SLC_HOST_GPIO_SDIO_IN0 : RO; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_IN0    0xFFFFFFFFU
#define SDIO_SLC_HOST_GPIO_SDIO_IN0_M  (SDIO_SLC_HOST_GPIO_SDIO_IN0_V << SDIO_SLC_HOST_GPIO_SDIO_IN0_S)
#define SDIO_SLC_HOST_GPIO_SDIO_IN0_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_GPIO_SDIO_IN0_S  0

/** SDIO_SLC_HOST_GPIO_IN1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_IN1_REG (DR_REG_SLCHOST_BASE + 0x40)
/** SDIO_SLC_HOST_GPIO_SDIO_IN1 : RO; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_IN1    0xFFFFFFFFU
#define SDIO_SLC_HOST_GPIO_SDIO_IN1_M  (SDIO_SLC_HOST_GPIO_SDIO_IN1_V << SDIO_SLC_HOST_GPIO_SDIO_IN1_S)
#define SDIO_SLC_HOST_GPIO_SDIO_IN1_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_GPIO_SDIO_IN1_S  0

/** SDIO_SLC_HOST_SLC0HOST_TOKEN_RDATA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TOKEN_RDATA_REG (DR_REG_SLCHOST_BASE + 0x44)
/** SDIO_SLC_HOST_SLC0_TOKEN0 : RO; bitpos: [11:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0    0x00000FFFU
#define SDIO_SLC_HOST_SLC0_TOKEN0_M  (SDIO_SLC_HOST_SLC0_TOKEN0_V << SDIO_SLC_HOST_SLC0_TOKEN0_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_V  0x00000FFFU
#define SDIO_SLC_HOST_SLC0_TOKEN0_S  0
/** SDIO_SLC_HOST_SLC0_RX_PF_VALID : RO; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID    (BIT(12))
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_M  (SDIO_SLC_HOST_SLC0_RX_PF_VALID_V << SDIO_SLC_HOST_SLC0_RX_PF_VALID_S)
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_S  12
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_TOKEN1 : RO; bitpos: [27:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_TOKEN1    0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_TOKEN1_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_TOKEN1_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_TOKEN1_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_TOKEN1_V  0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_TOKEN1_S  16
/** SDIO_SLC_HOST_SLC0_RX_PF_EOF : RO; bitpos: [31:28]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_PF_EOF    0x0000000FU
#define SDIO_SLC_HOST_SLC0_RX_PF_EOF_M  (SDIO_SLC_HOST_SLC0_RX_PF_EOF_V << SDIO_SLC_HOST_SLC0_RX_PF_EOF_S)
#define SDIO_SLC_HOST_SLC0_RX_PF_EOF_V  0x0000000FU
#define SDIO_SLC_HOST_SLC0_RX_PF_EOF_S  28

/** SDIO_SLC_HOST_SLC0_HOST_PF_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_HOST_PF_REG (DR_REG_SLCHOST_BASE + 0x48)
/** SDIO_SLC_HOST_SLC0_PF_DATA : RO; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_PF_DATA    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC0_PF_DATA_M  (SDIO_SLC_HOST_SLC0_PF_DATA_V << SDIO_SLC_HOST_SLC0_PF_DATA_S)
#define SDIO_SLC_HOST_SLC0_PF_DATA_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC0_PF_DATA_S  0

/** SDIO_SLC_HOST_SLC1_HOST_PF_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_HOST_PF_REG (DR_REG_SLCHOST_BASE + 0x4c)
/** SDIO_SLC_HOST_SLC1_PF_DATA : RO; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_PF_DATA    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC1_PF_DATA_M  (SDIO_SLC_HOST_SLC1_PF_DATA_V << SDIO_SLC_HOST_SLC1_PF_DATA_S)
#define SDIO_SLC_HOST_SLC1_PF_DATA_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC1_PF_DATA_S  0

/** SDIO_SLC_HOST_SLC0HOST_INT_RAW_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_INT_RAW_REG (DR_REG_SLCHOST_BASE + 0x50)
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_RAW : R/WTC/SS; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_RAW    (BIT(0))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_RAW_S  0
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_RAW : R/WTC/SS; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_RAW    (BIT(1))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_RAW_S  1
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_RAW : R/WTC/SS; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_RAW    (BIT(2))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_RAW_S  2
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_RAW : R/WTC/SS; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_RAW    (BIT(3))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_RAW_S  3
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_RAW : R/WTC/SS; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_RAW    (BIT(4))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_RAW_S  4
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_RAW : R/WTC/SS; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_RAW    (BIT(5))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_RAW_S  5
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_RAW : R/WTC/SS/SC; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_RAW    (BIT(6))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_RAW_S  6
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_RAW : R/WTC/SS/SC; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_RAW    (BIT(7))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_RAW_S  7
/** SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_RAW : R/WTC/SS; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_RAW    (BIT(8))
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_RAW_S  8
/** SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_RAW : R/WTC/SS; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_RAW    (BIT(9))
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_RAW_S  9
/** SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_RAW : R/WTC/SS; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_RAW    (BIT(10))
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_RAW_S  10
/** SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_RAW : R/WTC/SS; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_RAW    (BIT(11))
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_RAW_V << SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_RAW_S  11
/** SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_RAW : R/WTC/SS; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_RAW    (BIT(12))
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_RAW_M  (SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_RAW_V << SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_RAW_S  12
/** SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_RAW : R/WTC/SS; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_RAW    (BIT(13))
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_RAW_M  (SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_RAW_V << SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_RAW_S  13
/** SDIO_SLC_HOST_SLC0HOST_RX_START_INT_RAW : R/WTC/SS; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_RAW    (BIT(14))
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_RAW_M  (SDIO_SLC_HOST_SLC0HOST_RX_START_INT_RAW_V << SDIO_SLC_HOST_SLC0HOST_RX_START_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_RAW_S  14
/** SDIO_SLC_HOST_SLC0HOST_TX_START_INT_RAW : R/WTC/SS; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_RAW    (BIT(15))
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_RAW_M  (SDIO_SLC_HOST_SLC0HOST_TX_START_INT_RAW_V << SDIO_SLC_HOST_SLC0HOST_TX_START_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_RAW_S  15
/** SDIO_SLC_HOST_SLC0_RX_UDF_INT_RAW : R/WTC/SS; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_RAW    (BIT(16))
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_RAW_M  (SDIO_SLC_HOST_SLC0_RX_UDF_INT_RAW_V << SDIO_SLC_HOST_SLC0_RX_UDF_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_RAW_S  16
/** SDIO_SLC_HOST_SLC0_TX_OVF_INT_RAW : R/WTC/SS; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_RAW    (BIT(17))
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_RAW_M  (SDIO_SLC_HOST_SLC0_TX_OVF_INT_RAW_V << SDIO_SLC_HOST_SLC0_TX_OVF_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_RAW_S  17
/** SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_RAW : R/WTC/SS; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_RAW    (BIT(18))
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_RAW_M  (SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_RAW_V << SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_RAW_S  18
/** SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_RAW : R/WTC/SS; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_RAW    (BIT(19))
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_RAW_M  (SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_RAW_V << SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_RAW_S  19
/** SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_RAW : R/WTC/SS; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_RAW    (BIT(20))
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_RAW_M  (SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_RAW_V << SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_RAW_S  20
/** SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_RAW : R/WTC/SS; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_RAW    (BIT(21))
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_RAW_M  (SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_RAW_V << SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_RAW_S  21
/** SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_RAW : R/WTC/SS; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_RAW    (BIT(22))
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_RAW_M  (SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_RAW_V << SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_RAW_S  22
/** SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_RAW : R/WTC/SS; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_RAW    (BIT(23))
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_RAW_M  (SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_RAW_V << SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_RAW_S  23
/** SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_RAW : R/WTC/SS; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_RAW    (BIT(24))
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_RAW_M  (SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_RAW_V << SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_RAW_S)
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_RAW_S  24
/** SDIO_SLC_HOST_GPIO_SDIO_INT_RAW : R/WTC/SS/SC; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_INT_RAW    (BIT(25))
#define SDIO_SLC_HOST_GPIO_SDIO_INT_RAW_M  (SDIO_SLC_HOST_GPIO_SDIO_INT_RAW_V << SDIO_SLC_HOST_GPIO_SDIO_INT_RAW_S)
#define SDIO_SLC_HOST_GPIO_SDIO_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_GPIO_SDIO_INT_RAW_S  25

/** SDIO_SLC_HOST_SLC1HOST_INT_RAW_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_INT_RAW_REG (DR_REG_SLCHOST_BASE + 0x54)
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_RAW : R/WTC/SS; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_RAW    (BIT(0))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_RAW_S  0
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_RAW : R/WTC/SS; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_RAW    (BIT(1))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_RAW_S  1
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_RAW : R/WTC/SS; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_RAW    (BIT(2))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_RAW_S  2
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_RAW : R/WTC/SS; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_RAW    (BIT(3))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_RAW_S  3
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_RAW : R/WTC/SS; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_RAW    (BIT(4))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_RAW_S  4
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_RAW : R/WTC/SS; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_RAW    (BIT(5))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_RAW_S  5
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_RAW : R/WTC/SS/SC; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_RAW    (BIT(6))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_RAW_S  6
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_RAW : R/WTC/SS/SC; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_RAW    (BIT(7))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_RAW_S  7
/** SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_RAW : R/WTC/SS; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_RAW    (BIT(8))
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_RAW_S  8
/** SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_RAW : R/WTC/SS; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_RAW    (BIT(9))
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_RAW_S  9
/** SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_RAW : R/WTC/SS; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_RAW    (BIT(10))
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_RAW_S  10
/** SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_RAW : R/WTC/SS; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_RAW    (BIT(11))
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_RAW_V << SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_RAW_S  11
/** SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_RAW : R/WTC/SS; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_RAW    (BIT(12))
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_RAW_M  (SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_RAW_V << SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_RAW_S  12
/** SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_RAW : R/WTC/SS; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_RAW    (BIT(13))
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_RAW_M  (SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_RAW_V << SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_RAW_S  13
/** SDIO_SLC_HOST_SLC1HOST_RX_START_INT_RAW : R/WTC/SS; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_RAW    (BIT(14))
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_RAW_M  (SDIO_SLC_HOST_SLC1HOST_RX_START_INT_RAW_V << SDIO_SLC_HOST_SLC1HOST_RX_START_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_RAW_S  14
/** SDIO_SLC_HOST_SLC1HOST_TX_START_INT_RAW : R/WTC/SS; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_RAW    (BIT(15))
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_RAW_M  (SDIO_SLC_HOST_SLC1HOST_TX_START_INT_RAW_V << SDIO_SLC_HOST_SLC1HOST_TX_START_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_RAW_S  15
/** SDIO_SLC_HOST_SLC1_RX_UDF_INT_RAW : R/WTC/SS; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_RAW    (BIT(16))
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_RAW_M  (SDIO_SLC_HOST_SLC1_RX_UDF_INT_RAW_V << SDIO_SLC_HOST_SLC1_RX_UDF_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_RAW_S  16
/** SDIO_SLC_HOST_SLC1_TX_OVF_INT_RAW : R/WTC/SS; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_RAW    (BIT(17))
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_RAW_M  (SDIO_SLC_HOST_SLC1_TX_OVF_INT_RAW_V << SDIO_SLC_HOST_SLC1_TX_OVF_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_RAW_S  17
/** SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_RAW : R/WTC/SS; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_RAW    (BIT(18))
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_RAW_M  (SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_RAW_V << SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_RAW_S  18
/** SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_RAW : R/WTC/SS; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_RAW    (BIT(19))
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_RAW_M  (SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_RAW_V << SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_RAW_S  19
/** SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_RAW : R/WTC/SS; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_RAW    (BIT(20))
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_RAW_M  (SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_RAW_V << SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_RAW_S  20
/** SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_RAW : R/WTC/SS; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_RAW    (BIT(21))
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_RAW_M  (SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_RAW_V << SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_RAW_S  21
/** SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_RAW : R/WTC/SS; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_RAW    (BIT(22))
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_RAW_M  (SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_RAW_V << SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_RAW_S  22
/** SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_RAW : R/WTC/SS; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_RAW    (BIT(23))
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_RAW_M  (SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_RAW_V << SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_RAW_S  23
/** SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_RAW : R/WTC/SS; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_RAW    (BIT(24))
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_RAW_M  (SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_RAW_V << SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_RAW_S  24
/** SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_RAW : R/WTC/SS; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_RAW    (BIT(25))
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_RAW_M  (SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_RAW_V << SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_RAW_S)
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_RAW_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_RAW_S  25

/** SDIO_SLC_HOST_SLC0HOST_INT_ST_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_INT_ST_REG (DR_REG_SLCHOST_BASE + 0x58)
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ST : RO; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ST    (BIT(0))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ST_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ST_S  0
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ST : RO; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ST    (BIT(1))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ST_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ST_S  1
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ST : RO; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ST    (BIT(2))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ST_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ST_S  2
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ST : RO; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ST    (BIT(3))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ST_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ST_S  3
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ST : RO; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ST    (BIT(4))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ST_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ST_S  4
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ST : RO; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ST    (BIT(5))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ST_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ST_S  5
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ST : RO; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ST    (BIT(6))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ST_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ST_S  6
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ST : RO; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ST    (BIT(7))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ST_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ST_S  7
/** SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ST : RO; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ST    (BIT(8))
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ST_V << SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ST_S  8
/** SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ST : RO; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ST    (BIT(9))
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ST_V << SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ST_S  9
/** SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ST : RO; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ST    (BIT(10))
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ST_V << SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ST_S  10
/** SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ST : RO; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ST    (BIT(11))
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ST_M  (SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ST_V << SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ST_S  11
/** SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ST : RO; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ST    (BIT(12))
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ST_M  (SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ST_V << SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ST_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ST_S  12
/** SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ST : RO; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ST    (BIT(13))
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ST_M  (SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ST_V << SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ST_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ST_S  13
/** SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ST : RO; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ST    (BIT(14))
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ST_M  (SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ST_V << SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ST_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ST_S  14
/** SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ST : RO; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ST    (BIT(15))
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ST_M  (SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ST_V << SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ST_S)
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ST_S  15
/** SDIO_SLC_HOST_SLC0_RX_UDF_INT_ST : RO; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ST    (BIT(16))
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ST_M  (SDIO_SLC_HOST_SLC0_RX_UDF_INT_ST_V << SDIO_SLC_HOST_SLC0_RX_UDF_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ST_S  16
/** SDIO_SLC_HOST_SLC0_TX_OVF_INT_ST : RO; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ST    (BIT(17))
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ST_M  (SDIO_SLC_HOST_SLC0_TX_OVF_INT_ST_V << SDIO_SLC_HOST_SLC0_TX_OVF_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ST_S  17
/** SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ST : RO; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ST    (BIT(18))
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ST_M  (SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ST_V << SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ST_S  18
/** SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ST : RO; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ST    (BIT(19))
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ST_M  (SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ST_V << SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ST_S  19
/** SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ST : RO; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ST    (BIT(20))
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ST_M  (SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ST_V << SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ST_S  20
/** SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ST : RO; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ST    (BIT(21))
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ST_M  (SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ST_V << SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ST_S  21
/** SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ST : RO; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ST    (BIT(22))
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ST_M  (SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ST_V << SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ST_S  22
/** SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ST : RO; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ST    (BIT(23))
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ST_M  (SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ST_V << SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ST_S  23
/** SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ST : RO; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ST    (BIT(24))
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ST_M  (SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ST_V << SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ST_S)
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ST_S  24
/** SDIO_SLC_HOST_GPIO_SDIO_INT_ST : RO; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ST    (BIT(25))
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ST_M  (SDIO_SLC_HOST_GPIO_SDIO_INT_ST_V << SDIO_SLC_HOST_GPIO_SDIO_INT_ST_S)
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ST_S  25

/** SDIO_SLC_HOST_SLC1HOST_INT_ST_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_INT_ST_REG (DR_REG_SLCHOST_BASE + 0x5c)
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ST : RO; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ST    (BIT(0))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ST_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ST_S  0
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ST : RO; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ST    (BIT(1))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ST_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ST_S  1
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ST : RO; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ST    (BIT(2))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ST_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ST_S  2
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ST : RO; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ST    (BIT(3))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ST_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ST_S  3
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ST : RO; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ST    (BIT(4))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ST_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ST_S  4
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ST : RO; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ST    (BIT(5))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ST_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ST_S  5
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ST : RO; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ST    (BIT(6))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ST_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ST_S  6
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ST : RO; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ST    (BIT(7))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ST_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ST_S  7
/** SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ST : RO; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ST    (BIT(8))
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ST_V << SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ST_S  8
/** SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ST : RO; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ST    (BIT(9))
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ST_V << SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ST_S  9
/** SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ST : RO; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ST    (BIT(10))
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ST_V << SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ST_S  10
/** SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ST : RO; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ST    (BIT(11))
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ST_M  (SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ST_V << SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ST_S  11
/** SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ST : RO; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ST    (BIT(12))
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ST_M  (SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ST_V << SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ST_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ST_S  12
/** SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ST : RO; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ST    (BIT(13))
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ST_M  (SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ST_V << SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ST_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ST_S  13
/** SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ST : RO; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ST    (BIT(14))
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ST_M  (SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ST_V << SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ST_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ST_S  14
/** SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ST : RO; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ST    (BIT(15))
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ST_M  (SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ST_V << SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ST_S)
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ST_S  15
/** SDIO_SLC_HOST_SLC1_RX_UDF_INT_ST : RO; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ST    (BIT(16))
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ST_M  (SDIO_SLC_HOST_SLC1_RX_UDF_INT_ST_V << SDIO_SLC_HOST_SLC1_RX_UDF_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ST_S  16
/** SDIO_SLC_HOST_SLC1_TX_OVF_INT_ST : RO; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ST    (BIT(17))
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ST_M  (SDIO_SLC_HOST_SLC1_TX_OVF_INT_ST_V << SDIO_SLC_HOST_SLC1_TX_OVF_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ST_S  17
/** SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ST : RO; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ST    (BIT(18))
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ST_M  (SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ST_V << SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ST_S  18
/** SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ST : RO; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ST    (BIT(19))
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ST_M  (SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ST_V << SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ST_S  19
/** SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ST : RO; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ST    (BIT(20))
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ST_M  (SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ST_V << SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ST_S  20
/** SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ST : RO; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ST    (BIT(21))
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ST_M  (SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ST_V << SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ST_S  21
/** SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ST : RO; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ST    (BIT(22))
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ST_M  (SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ST_V << SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ST_S  22
/** SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ST : RO; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ST    (BIT(23))
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ST_M  (SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ST_V << SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ST_S  23
/** SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ST : RO; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ST    (BIT(24))
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ST_M  (SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ST_V << SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ST_S  24
/** SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ST : RO; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ST    (BIT(25))
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ST_M  (SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ST_V << SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ST_S)
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ST_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ST_S  25

/** SDIO_SLC_HOST_PKT_LEN_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_PKT_LEN_REG (DR_REG_SLCHOST_BASE + 0x60)
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN : RO; bitpos: [19:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN    0x000FFFFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_V  0x000FFFFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_S  0
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_CHECK : RO; bitpos: [31:20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_CHECK    0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_CHECK_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_CHECK_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_CHECK_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_CHECK_V  0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN_CHECK_S  20

/** SDIO_SLC_HOST_STATE_W0_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_STATE_W0_REG (DR_REG_SLCHOST_BASE + 0x64)
/** SDIO_SLC_HOST_SLCHOST_STATE0 : RO; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_STATE0    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE0_M  (SDIO_SLC_HOST_SLCHOST_STATE0_V << SDIO_SLC_HOST_SLCHOST_STATE0_S)
#define SDIO_SLC_HOST_SLCHOST_STATE0_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE0_S  0
/** SDIO_SLC_HOST_SLCHOST_STATE1 : RO; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_STATE1    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE1_M  (SDIO_SLC_HOST_SLCHOST_STATE1_V << SDIO_SLC_HOST_SLCHOST_STATE1_S)
#define SDIO_SLC_HOST_SLCHOST_STATE1_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE1_S  8
/** SDIO_SLC_HOST_SLCHOST_STATE2 : RO; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_STATE2    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE2_M  (SDIO_SLC_HOST_SLCHOST_STATE2_V << SDIO_SLC_HOST_SLCHOST_STATE2_S)
#define SDIO_SLC_HOST_SLCHOST_STATE2_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE2_S  16
/** SDIO_SLC_HOST_SLCHOST_STATE3 : RO; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_STATE3    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE3_M  (SDIO_SLC_HOST_SLCHOST_STATE3_V << SDIO_SLC_HOST_SLCHOST_STATE3_S)
#define SDIO_SLC_HOST_SLCHOST_STATE3_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE3_S  24

/** SDIO_SLC_HOST_STATE_W1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_STATE_W1_REG (DR_REG_SLCHOST_BASE + 0x68)
/** SDIO_SLC_HOST_SLCHOST_STATE4 : RO; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_STATE4    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE4_M  (SDIO_SLC_HOST_SLCHOST_STATE4_V << SDIO_SLC_HOST_SLCHOST_STATE4_S)
#define SDIO_SLC_HOST_SLCHOST_STATE4_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE4_S  0
/** SDIO_SLC_HOST_SLCHOST_STATE5 : RO; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_STATE5    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE5_M  (SDIO_SLC_HOST_SLCHOST_STATE5_V << SDIO_SLC_HOST_SLCHOST_STATE5_S)
#define SDIO_SLC_HOST_SLCHOST_STATE5_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE5_S  8
/** SDIO_SLC_HOST_SLCHOST_STATE6 : RO; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_STATE6    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE6_M  (SDIO_SLC_HOST_SLCHOST_STATE6_V << SDIO_SLC_HOST_SLCHOST_STATE6_S)
#define SDIO_SLC_HOST_SLCHOST_STATE6_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE6_S  16
/** SDIO_SLC_HOST_SLCHOST_STATE7 : RO; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_STATE7    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE7_M  (SDIO_SLC_HOST_SLCHOST_STATE7_V << SDIO_SLC_HOST_SLCHOST_STATE7_S)
#define SDIO_SLC_HOST_SLCHOST_STATE7_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_STATE7_S  24

/** SDIO_SLC_HOST_CONF_W0_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W0_REG (DR_REG_SLCHOST_BASE + 0x6c)
/** SDIO_SLC_HOST_SLCHOST_CONF0 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF0    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF0_M  (SDIO_SLC_HOST_SLCHOST_CONF0_V << SDIO_SLC_HOST_SLCHOST_CONF0_S)
#define SDIO_SLC_HOST_SLCHOST_CONF0_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF0_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF1 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF1    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF1_M  (SDIO_SLC_HOST_SLCHOST_CONF1_V << SDIO_SLC_HOST_SLCHOST_CONF1_S)
#define SDIO_SLC_HOST_SLCHOST_CONF1_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF1_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF2 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF2    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF2_M  (SDIO_SLC_HOST_SLCHOST_CONF2_V << SDIO_SLC_HOST_SLCHOST_CONF2_S)
#define SDIO_SLC_HOST_SLCHOST_CONF2_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF2_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF3 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF3    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF3_M  (SDIO_SLC_HOST_SLCHOST_CONF3_V << SDIO_SLC_HOST_SLCHOST_CONF3_S)
#define SDIO_SLC_HOST_SLCHOST_CONF3_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF3_S  24

/** SDIO_SLC_HOST_CONF_W1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W1_REG (DR_REG_SLCHOST_BASE + 0x70)
/** SDIO_SLC_HOST_SLCHOST_CONF4 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF4    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF4_M  (SDIO_SLC_HOST_SLCHOST_CONF4_V << SDIO_SLC_HOST_SLCHOST_CONF4_S)
#define SDIO_SLC_HOST_SLCHOST_CONF4_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF4_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF5 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF5    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF5_M  (SDIO_SLC_HOST_SLCHOST_CONF5_V << SDIO_SLC_HOST_SLCHOST_CONF5_S)
#define SDIO_SLC_HOST_SLCHOST_CONF5_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF5_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF6 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF6    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF6_M  (SDIO_SLC_HOST_SLCHOST_CONF6_V << SDIO_SLC_HOST_SLCHOST_CONF6_S)
#define SDIO_SLC_HOST_SLCHOST_CONF6_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF6_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF7 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF7    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF7_M  (SDIO_SLC_HOST_SLCHOST_CONF7_V << SDIO_SLC_HOST_SLCHOST_CONF7_S)
#define SDIO_SLC_HOST_SLCHOST_CONF7_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF7_S  24

/** SDIO_SLC_HOST_CONF_W2_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W2_REG (DR_REG_SLCHOST_BASE + 0x74)
/** SDIO_SLC_HOST_SLCHOST_CONF8 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF8    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF8_M  (SDIO_SLC_HOST_SLCHOST_CONF8_V << SDIO_SLC_HOST_SLCHOST_CONF8_S)
#define SDIO_SLC_HOST_SLCHOST_CONF8_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF8_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF9 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF9    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF9_M  (SDIO_SLC_HOST_SLCHOST_CONF9_V << SDIO_SLC_HOST_SLCHOST_CONF9_S)
#define SDIO_SLC_HOST_SLCHOST_CONF9_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF9_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF10 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF10    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF10_M  (SDIO_SLC_HOST_SLCHOST_CONF10_V << SDIO_SLC_HOST_SLCHOST_CONF10_S)
#define SDIO_SLC_HOST_SLCHOST_CONF10_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF10_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF11 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF11    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF11_M  (SDIO_SLC_HOST_SLCHOST_CONF11_V << SDIO_SLC_HOST_SLCHOST_CONF11_S)
#define SDIO_SLC_HOST_SLCHOST_CONF11_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF11_S  24

/** SDIO_SLC_HOST_CONF_W3_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W3_REG (DR_REG_SLCHOST_BASE + 0x78)
/** SDIO_SLC_HOST_SLCHOST_CONF12 : R/W; bitpos: [7:0]; default: 192;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF12    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF12_M  (SDIO_SLC_HOST_SLCHOST_CONF12_V << SDIO_SLC_HOST_SLCHOST_CONF12_S)
#define SDIO_SLC_HOST_SLCHOST_CONF12_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF12_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF13 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF13    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF13_M  (SDIO_SLC_HOST_SLCHOST_CONF13_V << SDIO_SLC_HOST_SLCHOST_CONF13_S)
#define SDIO_SLC_HOST_SLCHOST_CONF13_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF13_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF14 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF14    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF14_M  (SDIO_SLC_HOST_SLCHOST_CONF14_V << SDIO_SLC_HOST_SLCHOST_CONF14_S)
#define SDIO_SLC_HOST_SLCHOST_CONF14_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF14_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF15 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF15    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF15_M  (SDIO_SLC_HOST_SLCHOST_CONF15_V << SDIO_SLC_HOST_SLCHOST_CONF15_S)
#define SDIO_SLC_HOST_SLCHOST_CONF15_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF15_S  24

/** SDIO_SLC_HOST_CONF_W4_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W4_REG (DR_REG_SLCHOST_BASE + 0x7c)
/** SDIO_SLC_HOST_SLCHOST_CONF16 : R/W; bitpos: [7:0]; default: 255;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF16    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF16_M  (SDIO_SLC_HOST_SLCHOST_CONF16_V << SDIO_SLC_HOST_SLCHOST_CONF16_S)
#define SDIO_SLC_HOST_SLCHOST_CONF16_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF16_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF17 : R/W; bitpos: [15:8]; default: 1;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF17    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF17_M  (SDIO_SLC_HOST_SLCHOST_CONF17_V << SDIO_SLC_HOST_SLCHOST_CONF17_S)
#define SDIO_SLC_HOST_SLCHOST_CONF17_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF17_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF18 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF18    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF18_M  (SDIO_SLC_HOST_SLCHOST_CONF18_V << SDIO_SLC_HOST_SLCHOST_CONF18_S)
#define SDIO_SLC_HOST_SLCHOST_CONF18_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF18_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF19 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF19    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF19_M  (SDIO_SLC_HOST_SLCHOST_CONF19_V << SDIO_SLC_HOST_SLCHOST_CONF19_S)
#define SDIO_SLC_HOST_SLCHOST_CONF19_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF19_S  24

/** SDIO_SLC_HOST_CONF_W5_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W5_REG (DR_REG_SLCHOST_BASE + 0x80)
/** SDIO_SLC_HOST_SLCHOST_CONF20 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF20    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF20_M  (SDIO_SLC_HOST_SLCHOST_CONF20_V << SDIO_SLC_HOST_SLCHOST_CONF20_S)
#define SDIO_SLC_HOST_SLCHOST_CONF20_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF20_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF21 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF21    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF21_M  (SDIO_SLC_HOST_SLCHOST_CONF21_V << SDIO_SLC_HOST_SLCHOST_CONF21_S)
#define SDIO_SLC_HOST_SLCHOST_CONF21_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF21_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF22 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF22    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF22_M  (SDIO_SLC_HOST_SLCHOST_CONF22_V << SDIO_SLC_HOST_SLCHOST_CONF22_S)
#define SDIO_SLC_HOST_SLCHOST_CONF22_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF22_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF23 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF23    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF23_M  (SDIO_SLC_HOST_SLCHOST_CONF23_V << SDIO_SLC_HOST_SLCHOST_CONF23_S)
#define SDIO_SLC_HOST_SLCHOST_CONF23_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF23_S  24

/** SDIO_SLC_HOST_WIN_CMD_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_WIN_CMD_REG (DR_REG_SLCHOST_BASE + 0x84)
/** SDIO_SLC_HOST_SLCHOST_WIN_CMD : R/W; bitpos: [15:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_WIN_CMD    0x0000FFFFU
#define SDIO_SLC_HOST_SLCHOST_WIN_CMD_M  (SDIO_SLC_HOST_SLCHOST_WIN_CMD_V << SDIO_SLC_HOST_SLCHOST_WIN_CMD_S)
#define SDIO_SLC_HOST_SLCHOST_WIN_CMD_V  0x0000FFFFU
#define SDIO_SLC_HOST_SLCHOST_WIN_CMD_S  0

/** SDIO_SLC_HOST_CONF_W6_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W6_REG (DR_REG_SLCHOST_BASE + 0x88)
/** SDIO_SLC_HOST_SLCHOST_CONF24 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF24    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF24_M  (SDIO_SLC_HOST_SLCHOST_CONF24_V << SDIO_SLC_HOST_SLCHOST_CONF24_S)
#define SDIO_SLC_HOST_SLCHOST_CONF24_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF24_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF25 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF25    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF25_M  (SDIO_SLC_HOST_SLCHOST_CONF25_V << SDIO_SLC_HOST_SLCHOST_CONF25_S)
#define SDIO_SLC_HOST_SLCHOST_CONF25_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF25_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF26 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF26    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF26_M  (SDIO_SLC_HOST_SLCHOST_CONF26_V << SDIO_SLC_HOST_SLCHOST_CONF26_S)
#define SDIO_SLC_HOST_SLCHOST_CONF26_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF26_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF27 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF27    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF27_M  (SDIO_SLC_HOST_SLCHOST_CONF27_V << SDIO_SLC_HOST_SLCHOST_CONF27_S)
#define SDIO_SLC_HOST_SLCHOST_CONF27_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF27_S  24

/** SDIO_SLC_HOST_CONF_W7_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W7_REG (DR_REG_SLCHOST_BASE + 0x8c)
/** SDIO_SLC_HOST_SLCHOST_CONF28 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF28    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF28_M  (SDIO_SLC_HOST_SLCHOST_CONF28_V << SDIO_SLC_HOST_SLCHOST_CONF28_S)
#define SDIO_SLC_HOST_SLCHOST_CONF28_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF28_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF29 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF29    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF29_M  (SDIO_SLC_HOST_SLCHOST_CONF29_V << SDIO_SLC_HOST_SLCHOST_CONF29_S)
#define SDIO_SLC_HOST_SLCHOST_CONF29_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF29_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF30 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF30    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF30_M  (SDIO_SLC_HOST_SLCHOST_CONF30_V << SDIO_SLC_HOST_SLCHOST_CONF30_S)
#define SDIO_SLC_HOST_SLCHOST_CONF30_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF30_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF31 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF31    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF31_M  (SDIO_SLC_HOST_SLCHOST_CONF31_V << SDIO_SLC_HOST_SLCHOST_CONF31_S)
#define SDIO_SLC_HOST_SLCHOST_CONF31_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF31_S  24

/** SDIO_SLC_HOST_PKT_LEN0_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_PKT_LEN0_REG (DR_REG_SLCHOST_BASE + 0x90)
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0 : RO; bitpos: [19:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0    0x000FFFFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_V  0x000FFFFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_S  0
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_CHECK : RO; bitpos: [31:20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_CHECK    0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_CHECK_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_CHECK_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_CHECK_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_CHECK_V  0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN0_CHECK_S  20

/** SDIO_SLC_HOST_PKT_LEN1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_PKT_LEN1_REG (DR_REG_SLCHOST_BASE + 0x94)
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1 : RO; bitpos: [19:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1    0x000FFFFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_V  0x000FFFFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_S  0
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_CHECK : RO; bitpos: [31:20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_CHECK    0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_CHECK_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_CHECK_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_CHECK_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_CHECK_V  0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN1_CHECK_S  20

/** SDIO_SLC_HOST_PKT_LEN2_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_PKT_LEN2_REG (DR_REG_SLCHOST_BASE + 0x98)
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2 : RO; bitpos: [19:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2    0x000FFFFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_V  0x000FFFFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_S  0
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_CHECK : RO; bitpos: [31:20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_CHECK    0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_CHECK_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_CHECK_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_CHECK_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_CHECK_V  0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC0_LEN2_CHECK_S  20

/** SDIO_SLC_HOST_CONF_W8_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W8_REG (DR_REG_SLCHOST_BASE + 0x9c)
/** SDIO_SLC_HOST_SLCHOST_CONF32 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF32    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF32_M  (SDIO_SLC_HOST_SLCHOST_CONF32_V << SDIO_SLC_HOST_SLCHOST_CONF32_S)
#define SDIO_SLC_HOST_SLCHOST_CONF32_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF32_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF33 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF33    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF33_M  (SDIO_SLC_HOST_SLCHOST_CONF33_V << SDIO_SLC_HOST_SLCHOST_CONF33_S)
#define SDIO_SLC_HOST_SLCHOST_CONF33_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF33_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF34 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF34    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF34_M  (SDIO_SLC_HOST_SLCHOST_CONF34_V << SDIO_SLC_HOST_SLCHOST_CONF34_S)
#define SDIO_SLC_HOST_SLCHOST_CONF34_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF34_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF35 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF35    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF35_M  (SDIO_SLC_HOST_SLCHOST_CONF35_V << SDIO_SLC_HOST_SLCHOST_CONF35_S)
#define SDIO_SLC_HOST_SLCHOST_CONF35_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF35_S  24

/** SDIO_SLC_HOST_CONF_W9_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W9_REG (DR_REG_SLCHOST_BASE + 0xa0)
/** SDIO_SLC_HOST_SLCHOST_CONF36 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF36    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF36_M  (SDIO_SLC_HOST_SLCHOST_CONF36_V << SDIO_SLC_HOST_SLCHOST_CONF36_S)
#define SDIO_SLC_HOST_SLCHOST_CONF36_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF36_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF37 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF37    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF37_M  (SDIO_SLC_HOST_SLCHOST_CONF37_V << SDIO_SLC_HOST_SLCHOST_CONF37_S)
#define SDIO_SLC_HOST_SLCHOST_CONF37_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF37_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF38 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF38    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF38_M  (SDIO_SLC_HOST_SLCHOST_CONF38_V << SDIO_SLC_HOST_SLCHOST_CONF38_S)
#define SDIO_SLC_HOST_SLCHOST_CONF38_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF38_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF39 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF39    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF39_M  (SDIO_SLC_HOST_SLCHOST_CONF39_V << SDIO_SLC_HOST_SLCHOST_CONF39_S)
#define SDIO_SLC_HOST_SLCHOST_CONF39_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF39_S  24

/** SDIO_SLC_HOST_CONF_W10_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W10_REG (DR_REG_SLCHOST_BASE + 0xa4)
/** SDIO_SLC_HOST_SLCHOST_CONF40 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF40    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF40_M  (SDIO_SLC_HOST_SLCHOST_CONF40_V << SDIO_SLC_HOST_SLCHOST_CONF40_S)
#define SDIO_SLC_HOST_SLCHOST_CONF40_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF40_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF41 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF41    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF41_M  (SDIO_SLC_HOST_SLCHOST_CONF41_V << SDIO_SLC_HOST_SLCHOST_CONF41_S)
#define SDIO_SLC_HOST_SLCHOST_CONF41_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF41_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF42 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF42    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF42_M  (SDIO_SLC_HOST_SLCHOST_CONF42_V << SDIO_SLC_HOST_SLCHOST_CONF42_S)
#define SDIO_SLC_HOST_SLCHOST_CONF42_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF42_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF43 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF43    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF43_M  (SDIO_SLC_HOST_SLCHOST_CONF43_V << SDIO_SLC_HOST_SLCHOST_CONF43_S)
#define SDIO_SLC_HOST_SLCHOST_CONF43_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF43_S  24

/** SDIO_SLC_HOST_CONF_W11_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W11_REG (DR_REG_SLCHOST_BASE + 0xa8)
/** SDIO_SLC_HOST_SLCHOST_CONF44 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF44    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF44_M  (SDIO_SLC_HOST_SLCHOST_CONF44_V << SDIO_SLC_HOST_SLCHOST_CONF44_S)
#define SDIO_SLC_HOST_SLCHOST_CONF44_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF44_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF45 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF45    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF45_M  (SDIO_SLC_HOST_SLCHOST_CONF45_V << SDIO_SLC_HOST_SLCHOST_CONF45_S)
#define SDIO_SLC_HOST_SLCHOST_CONF45_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF45_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF46 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF46    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF46_M  (SDIO_SLC_HOST_SLCHOST_CONF46_V << SDIO_SLC_HOST_SLCHOST_CONF46_S)
#define SDIO_SLC_HOST_SLCHOST_CONF46_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF46_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF47 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF47    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF47_M  (SDIO_SLC_HOST_SLCHOST_CONF47_V << SDIO_SLC_HOST_SLCHOST_CONF47_S)
#define SDIO_SLC_HOST_SLCHOST_CONF47_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF47_S  24

/** SDIO_SLC_HOST_CONF_W12_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W12_REG (DR_REG_SLCHOST_BASE + 0xac)
/** SDIO_SLC_HOST_SLCHOST_CONF48 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF48    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF48_M  (SDIO_SLC_HOST_SLCHOST_CONF48_V << SDIO_SLC_HOST_SLCHOST_CONF48_S)
#define SDIO_SLC_HOST_SLCHOST_CONF48_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF48_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF49 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF49    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF49_M  (SDIO_SLC_HOST_SLCHOST_CONF49_V << SDIO_SLC_HOST_SLCHOST_CONF49_S)
#define SDIO_SLC_HOST_SLCHOST_CONF49_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF49_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF50 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF50    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF50_M  (SDIO_SLC_HOST_SLCHOST_CONF50_V << SDIO_SLC_HOST_SLCHOST_CONF50_S)
#define SDIO_SLC_HOST_SLCHOST_CONF50_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF50_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF51 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF51    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF51_M  (SDIO_SLC_HOST_SLCHOST_CONF51_V << SDIO_SLC_HOST_SLCHOST_CONF51_S)
#define SDIO_SLC_HOST_SLCHOST_CONF51_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF51_S  24

/** SDIO_SLC_HOST_CONF_W13_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W13_REG (DR_REG_SLCHOST_BASE + 0xb0)
/** SDIO_SLC_HOST_SLCHOST_CONF52 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF52    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF52_M  (SDIO_SLC_HOST_SLCHOST_CONF52_V << SDIO_SLC_HOST_SLCHOST_CONF52_S)
#define SDIO_SLC_HOST_SLCHOST_CONF52_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF52_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF53 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF53    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF53_M  (SDIO_SLC_HOST_SLCHOST_CONF53_V << SDIO_SLC_HOST_SLCHOST_CONF53_S)
#define SDIO_SLC_HOST_SLCHOST_CONF53_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF53_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF54 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF54    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF54_M  (SDIO_SLC_HOST_SLCHOST_CONF54_V << SDIO_SLC_HOST_SLCHOST_CONF54_S)
#define SDIO_SLC_HOST_SLCHOST_CONF54_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF54_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF55 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF55    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF55_M  (SDIO_SLC_HOST_SLCHOST_CONF55_V << SDIO_SLC_HOST_SLCHOST_CONF55_S)
#define SDIO_SLC_HOST_SLCHOST_CONF55_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF55_S  24

/** SDIO_SLC_HOST_CONF_W14_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W14_REG (DR_REG_SLCHOST_BASE + 0xb4)
/** SDIO_SLC_HOST_SLCHOST_CONF56 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF56    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF56_M  (SDIO_SLC_HOST_SLCHOST_CONF56_V << SDIO_SLC_HOST_SLCHOST_CONF56_S)
#define SDIO_SLC_HOST_SLCHOST_CONF56_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF56_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF57 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF57    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF57_M  (SDIO_SLC_HOST_SLCHOST_CONF57_V << SDIO_SLC_HOST_SLCHOST_CONF57_S)
#define SDIO_SLC_HOST_SLCHOST_CONF57_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF57_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF58 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF58    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF58_M  (SDIO_SLC_HOST_SLCHOST_CONF58_V << SDIO_SLC_HOST_SLCHOST_CONF58_S)
#define SDIO_SLC_HOST_SLCHOST_CONF58_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF58_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF59 : R/W; bitpos: [31:24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF59    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF59_M  (SDIO_SLC_HOST_SLCHOST_CONF59_V << SDIO_SLC_HOST_SLCHOST_CONF59_S)
#define SDIO_SLC_HOST_SLCHOST_CONF59_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF59_S  24

/** SDIO_SLC_HOST_CONF_W15_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_W15_REG (DR_REG_SLCHOST_BASE + 0xb8)
/** SDIO_SLC_HOST_SLCHOST_CONF60 : R/W; bitpos: [7:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF60    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF60_M  (SDIO_SLC_HOST_SLCHOST_CONF60_V << SDIO_SLC_HOST_SLCHOST_CONF60_S)
#define SDIO_SLC_HOST_SLCHOST_CONF60_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF60_S  0
/** SDIO_SLC_HOST_SLCHOST_CONF61 : R/W; bitpos: [15:8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF61    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF61_M  (SDIO_SLC_HOST_SLCHOST_CONF61_V << SDIO_SLC_HOST_SLCHOST_CONF61_S)
#define SDIO_SLC_HOST_SLCHOST_CONF61_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF61_S  8
/** SDIO_SLC_HOST_SLCHOST_CONF62 : R/W; bitpos: [23:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CONF62    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF62_M  (SDIO_SLC_HOST_SLCHOST_CONF62_V << SDIO_SLC_HOST_SLCHOST_CONF62_S)
#define SDIO_SLC_HOST_SLCHOST_CONF62_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF62_S  16
/** SDIO_SLC_HOST_SLCHOST_CONF63 : R/W; bitpos: [31:24]; default: 0;
 *  Bit [27:24] used for reg_slc_apbwin_addr[31:28]
 */
#define SDIO_SLC_HOST_SLCHOST_CONF63    0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF63_M  (SDIO_SLC_HOST_SLCHOST_CONF63_V << SDIO_SLC_HOST_SLCHOST_CONF63_S)
#define SDIO_SLC_HOST_SLCHOST_CONF63_V  0x000000FFU
#define SDIO_SLC_HOST_SLCHOST_CONF63_S  24

/** SDIO_SLC_HOST_CHECK_SUM0_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CHECK_SUM0_REG (DR_REG_SLCHOST_BASE + 0xbc)
/** SDIO_SLC_HOST_SLCHOST_CHECK_SUM0 : RO; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CHECK_SUM0    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLCHOST_CHECK_SUM0_M  (SDIO_SLC_HOST_SLCHOST_CHECK_SUM0_V << SDIO_SLC_HOST_SLCHOST_CHECK_SUM0_S)
#define SDIO_SLC_HOST_SLCHOST_CHECK_SUM0_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLCHOST_CHECK_SUM0_S  0

/** SDIO_SLC_HOST_CHECK_SUM1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CHECK_SUM1_REG (DR_REG_SLCHOST_BASE + 0xc0)
/** SDIO_SLC_HOST_SLCHOST_CHECK_SUM1 : RO; bitpos: [31:0]; default: 319;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_CHECK_SUM1    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLCHOST_CHECK_SUM1_M  (SDIO_SLC_HOST_SLCHOST_CHECK_SUM1_V << SDIO_SLC_HOST_SLCHOST_CHECK_SUM1_S)
#define SDIO_SLC_HOST_SLCHOST_CHECK_SUM1_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLCHOST_CHECK_SUM1_S  0

/** SDIO_SLC_HOST_SLC1HOST_TOKEN_RDATA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TOKEN_RDATA_REG (DR_REG_SLCHOST_BASE + 0xc4)
/** SDIO_SLC_HOST_SLC1_TOKEN0 : RO; bitpos: [11:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0    0x00000FFFU
#define SDIO_SLC_HOST_SLC1_TOKEN0_M  (SDIO_SLC_HOST_SLC1_TOKEN0_V << SDIO_SLC_HOST_SLC1_TOKEN0_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_V  0x00000FFFU
#define SDIO_SLC_HOST_SLC1_TOKEN0_S  0
/** SDIO_SLC_HOST_SLC1_RX_PF_VALID : RO; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID    (BIT(12))
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_M  (SDIO_SLC_HOST_SLC1_RX_PF_VALID_V << SDIO_SLC_HOST_SLC1_RX_PF_VALID_S)
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_S  12
/** SDIO_SLC_HOST_HOSTSLCHOST_SLC1_TOKEN1 : RO; bitpos: [27:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC1_TOKEN1    0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC1_TOKEN1_M  (SDIO_SLC_HOST_HOSTSLCHOST_SLC1_TOKEN1_V << SDIO_SLC_HOST_HOSTSLCHOST_SLC1_TOKEN1_S)
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC1_TOKEN1_V  0x00000FFFU
#define SDIO_SLC_HOST_HOSTSLCHOST_SLC1_TOKEN1_S  16
/** SDIO_SLC_HOST_SLC1_RX_PF_EOF : RO; bitpos: [31:28]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_PF_EOF    0x0000000FU
#define SDIO_SLC_HOST_SLC1_RX_PF_EOF_M  (SDIO_SLC_HOST_SLC1_RX_PF_EOF_V << SDIO_SLC_HOST_SLC1_RX_PF_EOF_S)
#define SDIO_SLC_HOST_SLC1_RX_PF_EOF_V  0x0000000FU
#define SDIO_SLC_HOST_SLC1_RX_PF_EOF_S  28

/** SDIO_SLC_HOST_SLC0HOST_TOKEN_WDATA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TOKEN_WDATA_REG (DR_REG_SLCHOST_BASE + 0xc8)
/** SDIO_SLC_HOST_SLC0HOST_TOKEN0_WD : R/W; bitpos: [11:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_WD    0x00000FFFU
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_WD_M  (SDIO_SLC_HOST_SLC0HOST_TOKEN0_WD_V << SDIO_SLC_HOST_SLC0HOST_TOKEN0_WD_S)
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_WD_V  0x00000FFFU
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_WD_S  0
/** SDIO_SLC_HOST_SLC0HOST_TOKEN1_WD : R/W; bitpos: [27:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_WD    0x00000FFFU
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_WD_M  (SDIO_SLC_HOST_SLC0HOST_TOKEN1_WD_V << SDIO_SLC_HOST_SLC0HOST_TOKEN1_WD_S)
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_WD_V  0x00000FFFU
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_WD_S  16

/** SDIO_SLC_HOST_SLC1HOST_TOKEN_WDATA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TOKEN_WDATA_REG (DR_REG_SLCHOST_BASE + 0xcc)
/** SDIO_SLC_HOST_SLC1HOST_TOKEN0_WD : R/W; bitpos: [11:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_WD    0x00000FFFU
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_WD_M  (SDIO_SLC_HOST_SLC1HOST_TOKEN0_WD_V << SDIO_SLC_HOST_SLC1HOST_TOKEN0_WD_S)
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_WD_V  0x00000FFFU
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_WD_S  0
/** SDIO_SLC_HOST_SLC1HOST_TOKEN1_WD : R/W; bitpos: [27:16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_WD    0x00000FFFU
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_WD_M  (SDIO_SLC_HOST_SLC1HOST_TOKEN1_WD_V << SDIO_SLC_HOST_SLC1HOST_TOKEN1_WD_S)
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_WD_V  0x00000FFFU
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_WD_S  16

/** SDIO_SLC_HOST_TOKEN_CON_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_TOKEN_CON_REG (DR_REG_SLCHOST_BASE + 0xd0)
/** SDIO_SLC_HOST_SLC0HOST_TOKEN0_DEC : WT; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_DEC    (BIT(0))
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_DEC_M  (SDIO_SLC_HOST_SLC0HOST_TOKEN0_DEC_V << SDIO_SLC_HOST_SLC0HOST_TOKEN0_DEC_S)
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_DEC_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_DEC_S  0
/** SDIO_SLC_HOST_SLC0HOST_TOKEN1_DEC : WT; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_DEC    (BIT(1))
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_DEC_M  (SDIO_SLC_HOST_SLC0HOST_TOKEN1_DEC_V << SDIO_SLC_HOST_SLC0HOST_TOKEN1_DEC_S)
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_DEC_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_DEC_S  1
/** SDIO_SLC_HOST_SLC0HOST_TOKEN0_WR : WT; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_WR    (BIT(2))
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_WR_M  (SDIO_SLC_HOST_SLC0HOST_TOKEN0_WR_V << SDIO_SLC_HOST_SLC0HOST_TOKEN0_WR_S)
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_WR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TOKEN0_WR_S  2
/** SDIO_SLC_HOST_SLC0HOST_TOKEN1_WR : WT; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_WR    (BIT(3))
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_WR_M  (SDIO_SLC_HOST_SLC0HOST_TOKEN1_WR_V << SDIO_SLC_HOST_SLC0HOST_TOKEN1_WR_S)
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_WR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TOKEN1_WR_S  3
/** SDIO_SLC_HOST_SLC1HOST_TOKEN0_DEC : WT; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_DEC    (BIT(4))
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_DEC_M  (SDIO_SLC_HOST_SLC1HOST_TOKEN0_DEC_V << SDIO_SLC_HOST_SLC1HOST_TOKEN0_DEC_S)
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_DEC_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_DEC_S  4
/** SDIO_SLC_HOST_SLC1HOST_TOKEN1_DEC : WT; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_DEC    (BIT(5))
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_DEC_M  (SDIO_SLC_HOST_SLC1HOST_TOKEN1_DEC_V << SDIO_SLC_HOST_SLC1HOST_TOKEN1_DEC_S)
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_DEC_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_DEC_S  5
/** SDIO_SLC_HOST_SLC1HOST_TOKEN0_WR : WT; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_WR    (BIT(6))
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_WR_M  (SDIO_SLC_HOST_SLC1HOST_TOKEN0_WR_V << SDIO_SLC_HOST_SLC1HOST_TOKEN0_WR_S)
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_WR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TOKEN0_WR_S  6
/** SDIO_SLC_HOST_SLC1HOST_TOKEN1_WR : WT; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_WR    (BIT(7))
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_WR_M  (SDIO_SLC_HOST_SLC1HOST_TOKEN1_WR_V << SDIO_SLC_HOST_SLC1HOST_TOKEN1_WR_S)
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_WR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TOKEN1_WR_S  7
/** SDIO_SLC_HOST_SLC0HOST_LEN_WR : WT; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_LEN_WR    (BIT(8))
#define SDIO_SLC_HOST_SLC0HOST_LEN_WR_M  (SDIO_SLC_HOST_SLC0HOST_LEN_WR_V << SDIO_SLC_HOST_SLC0HOST_LEN_WR_S)
#define SDIO_SLC_HOST_SLC0HOST_LEN_WR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_LEN_WR_S  8

/** SDIO_SLC_HOST_SLC0HOST_INT_CLR_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_INT_CLR_REG (DR_REG_SLCHOST_BASE + 0xd4)
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_CLR : WT; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_CLR    (BIT(0))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_CLR_S  0
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_CLR : WT; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_CLR    (BIT(1))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_CLR_S  1
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_CLR : WT; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_CLR    (BIT(2))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_CLR_S  2
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_CLR : WT; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_CLR    (BIT(3))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_CLR_S  3
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_CLR : WT; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_CLR    (BIT(4))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_CLR_S  4
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_CLR : WT; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_CLR    (BIT(5))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_CLR_S  5
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_CLR : WT; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_CLR    (BIT(6))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_CLR_S  6
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_CLR : WT; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_CLR    (BIT(7))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_CLR_S  7
/** SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_CLR : WT; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_CLR    (BIT(8))
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_CLR_S  8
/** SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_CLR : WT; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_CLR    (BIT(9))
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_CLR_S  9
/** SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_CLR : WT; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_CLR    (BIT(10))
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_CLR_S  10
/** SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_CLR : WT; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_CLR    (BIT(11))
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_CLR_V << SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_CLR_S  11
/** SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_CLR : WT; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_CLR    (BIT(12))
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_CLR_M  (SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_CLR_V << SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_CLR_S  12
/** SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_CLR : WT; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_CLR    (BIT(13))
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_CLR_M  (SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_CLR_V << SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_CLR_S  13
/** SDIO_SLC_HOST_SLC0HOST_RX_START_INT_CLR : WT; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_CLR    (BIT(14))
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_CLR_M  (SDIO_SLC_HOST_SLC0HOST_RX_START_INT_CLR_V << SDIO_SLC_HOST_SLC0HOST_RX_START_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_CLR_S  14
/** SDIO_SLC_HOST_SLC0HOST_TX_START_INT_CLR : WT; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_CLR    (BIT(15))
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_CLR_M  (SDIO_SLC_HOST_SLC0HOST_TX_START_INT_CLR_V << SDIO_SLC_HOST_SLC0HOST_TX_START_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_CLR_S  15
/** SDIO_SLC_HOST_SLC0_RX_UDF_INT_CLR : WT; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_CLR    (BIT(16))
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_CLR_M  (SDIO_SLC_HOST_SLC0_RX_UDF_INT_CLR_V << SDIO_SLC_HOST_SLC0_RX_UDF_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_CLR_S  16
/** SDIO_SLC_HOST_SLC0_TX_OVF_INT_CLR : WT; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_CLR    (BIT(17))
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_CLR_M  (SDIO_SLC_HOST_SLC0_TX_OVF_INT_CLR_V << SDIO_SLC_HOST_SLC0_TX_OVF_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_CLR_S  17
/** SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_CLR : WT; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_CLR    (BIT(18))
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_CLR_M  (SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_CLR_V << SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_CLR_S  18
/** SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_CLR : WT; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_CLR    (BIT(19))
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_CLR_M  (SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_CLR_V << SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_CLR_S  19
/** SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_CLR : WT; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_CLR    (BIT(20))
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_CLR_M  (SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_CLR_V << SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_CLR_S  20
/** SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_CLR : WT; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_CLR    (BIT(21))
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_CLR_M  (SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_CLR_V << SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_CLR_S  21
/** SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_CLR : WT; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_CLR    (BIT(22))
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_CLR_M  (SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_CLR_V << SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_CLR_S  22
/** SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_CLR : WT; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_CLR    (BIT(23))
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_CLR_M  (SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_CLR_V << SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_CLR_S  23
/** SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_CLR : WT; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_CLR    (BIT(24))
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_CLR_M  (SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_CLR_V << SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_CLR_S)
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_CLR_S  24
/** SDIO_SLC_HOST_GPIO_SDIO_INT_CLR : WT; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_INT_CLR    (BIT(25))
#define SDIO_SLC_HOST_GPIO_SDIO_INT_CLR_M  (SDIO_SLC_HOST_GPIO_SDIO_INT_CLR_V << SDIO_SLC_HOST_GPIO_SDIO_INT_CLR_S)
#define SDIO_SLC_HOST_GPIO_SDIO_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_GPIO_SDIO_INT_CLR_S  25

/** SDIO_SLC_HOST_SLC1HOST_INT_CLR_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_INT_CLR_REG (DR_REG_SLCHOST_BASE + 0xd8)
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_CLR : WT; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_CLR    (BIT(0))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_CLR_S  0
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_CLR : WT; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_CLR    (BIT(1))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_CLR_S  1
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_CLR : WT; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_CLR    (BIT(2))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_CLR_S  2
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_CLR : WT; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_CLR    (BIT(3))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_CLR_S  3
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_CLR : WT; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_CLR    (BIT(4))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_CLR_S  4
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_CLR : WT; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_CLR    (BIT(5))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_CLR_S  5
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_CLR : WT; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_CLR    (BIT(6))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_CLR_S  6
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_CLR : WT; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_CLR    (BIT(7))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_CLR_S  7
/** SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_CLR : WT; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_CLR    (BIT(8))
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_CLR_S  8
/** SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_CLR : WT; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_CLR    (BIT(9))
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_CLR_S  9
/** SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_CLR : WT; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_CLR    (BIT(10))
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_CLR_S  10
/** SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_CLR : WT; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_CLR    (BIT(11))
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_CLR_V << SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_CLR_S  11
/** SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_CLR : WT; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_CLR    (BIT(12))
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_CLR_M  (SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_CLR_V << SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_CLR_S  12
/** SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_CLR : WT; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_CLR    (BIT(13))
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_CLR_M  (SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_CLR_V << SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_CLR_S  13
/** SDIO_SLC_HOST_SLC1HOST_RX_START_INT_CLR : WT; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_CLR    (BIT(14))
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_CLR_M  (SDIO_SLC_HOST_SLC1HOST_RX_START_INT_CLR_V << SDIO_SLC_HOST_SLC1HOST_RX_START_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_CLR_S  14
/** SDIO_SLC_HOST_SLC1HOST_TX_START_INT_CLR : WT; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_CLR    (BIT(15))
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_CLR_M  (SDIO_SLC_HOST_SLC1HOST_TX_START_INT_CLR_V << SDIO_SLC_HOST_SLC1HOST_TX_START_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_CLR_S  15
/** SDIO_SLC_HOST_SLC1_RX_UDF_INT_CLR : WT; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_CLR    (BIT(16))
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_CLR_M  (SDIO_SLC_HOST_SLC1_RX_UDF_INT_CLR_V << SDIO_SLC_HOST_SLC1_RX_UDF_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_CLR_S  16
/** SDIO_SLC_HOST_SLC1_TX_OVF_INT_CLR : WT; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_CLR    (BIT(17))
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_CLR_M  (SDIO_SLC_HOST_SLC1_TX_OVF_INT_CLR_V << SDIO_SLC_HOST_SLC1_TX_OVF_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_CLR_S  17
/** SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_CLR : WT; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_CLR    (BIT(18))
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_CLR_M  (SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_CLR_V << SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_CLR_S  18
/** SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_CLR : WT; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_CLR    (BIT(19))
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_CLR_M  (SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_CLR_V << SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_CLR_S  19
/** SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_CLR : WT; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_CLR    (BIT(20))
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_CLR_M  (SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_CLR_V << SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_CLR_S  20
/** SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_CLR : WT; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_CLR    (BIT(21))
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_CLR_M  (SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_CLR_V << SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_CLR_S  21
/** SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_CLR : WT; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_CLR    (BIT(22))
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_CLR_M  (SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_CLR_V << SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_CLR_S  22
/** SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_CLR : WT; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_CLR    (BIT(23))
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_CLR_M  (SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_CLR_V << SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_CLR_S  23
/** SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_CLR : WT; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_CLR    (BIT(24))
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_CLR_M  (SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_CLR_V << SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_CLR_S  24
/** SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_CLR : WT; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_CLR    (BIT(25))
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_CLR_M  (SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_CLR_V << SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_CLR_S)
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_CLR_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_CLR_S  25

/** SDIO_SLC_HOST_SLC0HOST_FUNC1_INT_ENA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_FUNC1_INT_ENA_REG (DR_REG_SLCHOST_BASE + 0xdc)
/** SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT0_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT0_INT_ENA    (BIT(0))
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT0_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT0_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT0_INT_ENA_S  0
/** SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT1_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT1_INT_ENA    (BIT(1))
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT1_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT1_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT1_INT_ENA_S  1
/** SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT2_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT2_INT_ENA    (BIT(2))
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT2_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT2_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT2_INT_ENA_S  2
/** SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT3_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT3_INT_ENA    (BIT(3))
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT3_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT3_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT3_INT_ENA_S  3
/** SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT4_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT4_INT_ENA    (BIT(4))
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT4_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT4_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT4_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT4_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT4_INT_ENA_S  4
/** SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT5_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT5_INT_ENA    (BIT(5))
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT5_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT5_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT5_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT5_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT5_INT_ENA_S  5
/** SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT6_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT6_INT_ENA    (BIT(6))
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT6_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT6_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT6_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT6_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT6_INT_ENA_S  6
/** SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT7_INT_ENA : R/W; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT7_INT_ENA    (BIT(7))
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT7_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT7_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT7_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT7_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOHOST_BIT7_INT_ENA_S  7
/** SDIO_SLC_HOST_FN1_SLC0_TOKEN0_1TO0_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN0_1TO0_INT_ENA    (BIT(8))
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN0_1TO0_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOKEN0_1TO0_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOKEN0_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN0_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN0_1TO0_INT_ENA_S  8
/** SDIO_SLC_HOST_FN1_SLC0_TOKEN1_1TO0_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN1_1TO0_INT_ENA    (BIT(9))
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN1_1TO0_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOKEN1_1TO0_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOKEN1_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN1_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN1_1TO0_INT_ENA_S  9
/** SDIO_SLC_HOST_FN1_SLC0_TOKEN0_0TO1_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN0_0TO1_INT_ENA    (BIT(10))
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN0_0TO1_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOKEN0_0TO1_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOKEN0_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN0_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN0_0TO1_INT_ENA_S  10
/** SDIO_SLC_HOST_FN1_SLC0_TOKEN1_0TO1_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN1_0TO1_INT_ENA    (BIT(11))
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN1_0TO1_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TOKEN1_0TO1_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TOKEN1_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN1_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TOKEN1_0TO1_INT_ENA_S  11
/** SDIO_SLC_HOST_FN1_SLC0HOST_RX_SOF_INT_ENA : R/W; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_SOF_INT_ENA    (BIT(12))
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_SOF_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0HOST_RX_SOF_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0HOST_RX_SOF_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_SOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_SOF_INT_ENA_S  12
/** SDIO_SLC_HOST_FN1_SLC0HOST_RX_EOF_INT_ENA : R/W; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_EOF_INT_ENA    (BIT(13))
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_EOF_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0HOST_RX_EOF_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0HOST_RX_EOF_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_EOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_EOF_INT_ENA_S  13
/** SDIO_SLC_HOST_FN1_SLC0HOST_RX_START_INT_ENA : R/W; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_START_INT_ENA    (BIT(14))
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_START_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0HOST_RX_START_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0HOST_RX_START_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0HOST_RX_START_INT_ENA_S  14
/** SDIO_SLC_HOST_FN1_SLC0HOST_TX_START_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0HOST_TX_START_INT_ENA    (BIT(15))
#define SDIO_SLC_HOST_FN1_SLC0HOST_TX_START_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0HOST_TX_START_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0HOST_TX_START_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0HOST_TX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0HOST_TX_START_INT_ENA_S  15
/** SDIO_SLC_HOST_FN1_SLC0_RX_UDF_INT_ENA : R/W; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_RX_UDF_INT_ENA    (BIT(16))
#define SDIO_SLC_HOST_FN1_SLC0_RX_UDF_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_RX_UDF_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_RX_UDF_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_RX_UDF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_RX_UDF_INT_ENA_S  16
/** SDIO_SLC_HOST_FN1_SLC0_TX_OVF_INT_ENA : R/W; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_TX_OVF_INT_ENA    (BIT(17))
#define SDIO_SLC_HOST_FN1_SLC0_TX_OVF_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_TX_OVF_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_TX_OVF_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_TX_OVF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_TX_OVF_INT_ENA_S  17
/** SDIO_SLC_HOST_FN1_SLC0_RX_PF_VALID_INT_ENA : R/W; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_RX_PF_VALID_INT_ENA    (BIT(18))
#define SDIO_SLC_HOST_FN1_SLC0_RX_PF_VALID_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_RX_PF_VALID_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_RX_PF_VALID_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_RX_PF_VALID_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_RX_PF_VALID_INT_ENA_S  18
/** SDIO_SLC_HOST_FN1_SLC0_EXT_BIT0_INT_ENA : R/W; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT0_INT_ENA    (BIT(19))
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT0_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_EXT_BIT0_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_EXT_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT0_INT_ENA_S  19
/** SDIO_SLC_HOST_FN1_SLC0_EXT_BIT1_INT_ENA : R/W; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT1_INT_ENA    (BIT(20))
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT1_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_EXT_BIT1_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_EXT_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT1_INT_ENA_S  20
/** SDIO_SLC_HOST_FN1_SLC0_EXT_BIT2_INT_ENA : R/W; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT2_INT_ENA    (BIT(21))
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT2_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_EXT_BIT2_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_EXT_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT2_INT_ENA_S  21
/** SDIO_SLC_HOST_FN1_SLC0_EXT_BIT3_INT_ENA : R/W; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT3_INT_ENA    (BIT(22))
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT3_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_EXT_BIT3_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_EXT_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_EXT_BIT3_INT_ENA_S  22
/** SDIO_SLC_HOST_FN1_SLC0_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_RX_NEW_PACKET_INT_ENA    (BIT(23))
#define SDIO_SLC_HOST_FN1_SLC0_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_RX_NEW_PACKET_INT_ENA_S  23
/** SDIO_SLC_HOST_FN1_SLC0_HOST_RD_RETRY_INT_ENA : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC0_HOST_RD_RETRY_INT_ENA    (BIT(24))
#define SDIO_SLC_HOST_FN1_SLC0_HOST_RD_RETRY_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC0_HOST_RD_RETRY_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC0_HOST_RD_RETRY_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC0_HOST_RD_RETRY_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC0_HOST_RD_RETRY_INT_ENA_S  24
/** SDIO_SLC_HOST_FN1_GPIO_SDIO_INT_ENA : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_GPIO_SDIO_INT_ENA    (BIT(25))
#define SDIO_SLC_HOST_FN1_GPIO_SDIO_INT_ENA_M  (SDIO_SLC_HOST_FN1_GPIO_SDIO_INT_ENA_V << SDIO_SLC_HOST_FN1_GPIO_SDIO_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_GPIO_SDIO_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_GPIO_SDIO_INT_ENA_S  25

/** SDIO_SLC_HOST_SLC1HOST_FUNC1_INT_ENA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_FUNC1_INT_ENA_REG (DR_REG_SLCHOST_BASE + 0xe0)
/** SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT0_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT0_INT_ENA    (BIT(0))
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT0_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT0_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT0_INT_ENA_S  0
/** SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT1_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT1_INT_ENA    (BIT(1))
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT1_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT1_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT1_INT_ENA_S  1
/** SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT2_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT2_INT_ENA    (BIT(2))
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT2_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT2_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT2_INT_ENA_S  2
/** SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT3_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT3_INT_ENA    (BIT(3))
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT3_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT3_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT3_INT_ENA_S  3
/** SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT4_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT4_INT_ENA    (BIT(4))
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT4_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT4_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT4_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT4_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT4_INT_ENA_S  4
/** SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT5_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT5_INT_ENA    (BIT(5))
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT5_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT5_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT5_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT5_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT5_INT_ENA_S  5
/** SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT6_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT6_INT_ENA    (BIT(6))
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT6_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT6_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT6_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT6_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT6_INT_ENA_S  6
/** SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT7_INT_ENA : R/W; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT7_INT_ENA    (BIT(7))
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT7_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT7_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT7_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT7_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOHOST_BIT7_INT_ENA_S  7
/** SDIO_SLC_HOST_FN1_SLC1_TOKEN0_1TO0_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN0_1TO0_INT_ENA    (BIT(8))
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN0_1TO0_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOKEN0_1TO0_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOKEN0_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN0_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN0_1TO0_INT_ENA_S  8
/** SDIO_SLC_HOST_FN1_SLC1_TOKEN1_1TO0_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN1_1TO0_INT_ENA    (BIT(9))
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN1_1TO0_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOKEN1_1TO0_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOKEN1_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN1_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN1_1TO0_INT_ENA_S  9
/** SDIO_SLC_HOST_FN1_SLC1_TOKEN0_0TO1_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN0_0TO1_INT_ENA    (BIT(10))
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN0_0TO1_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOKEN0_0TO1_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOKEN0_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN0_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN0_0TO1_INT_ENA_S  10
/** SDIO_SLC_HOST_FN1_SLC1_TOKEN1_0TO1_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN1_0TO1_INT_ENA    (BIT(11))
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN1_0TO1_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TOKEN1_0TO1_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TOKEN1_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN1_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TOKEN1_0TO1_INT_ENA_S  11
/** SDIO_SLC_HOST_FN1_SLC1HOST_RX_SOF_INT_ENA : R/W; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_SOF_INT_ENA    (BIT(12))
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_SOF_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1HOST_RX_SOF_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1HOST_RX_SOF_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_SOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_SOF_INT_ENA_S  12
/** SDIO_SLC_HOST_FN1_SLC1HOST_RX_EOF_INT_ENA : R/W; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_EOF_INT_ENA    (BIT(13))
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_EOF_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1HOST_RX_EOF_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1HOST_RX_EOF_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_EOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_EOF_INT_ENA_S  13
/** SDIO_SLC_HOST_FN1_SLC1HOST_RX_START_INT_ENA : R/W; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_START_INT_ENA    (BIT(14))
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_START_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1HOST_RX_START_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1HOST_RX_START_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1HOST_RX_START_INT_ENA_S  14
/** SDIO_SLC_HOST_FN1_SLC1HOST_TX_START_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1HOST_TX_START_INT_ENA    (BIT(15))
#define SDIO_SLC_HOST_FN1_SLC1HOST_TX_START_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1HOST_TX_START_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1HOST_TX_START_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1HOST_TX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1HOST_TX_START_INT_ENA_S  15
/** SDIO_SLC_HOST_FN1_SLC1_RX_UDF_INT_ENA : R/W; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_RX_UDF_INT_ENA    (BIT(16))
#define SDIO_SLC_HOST_FN1_SLC1_RX_UDF_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_RX_UDF_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_RX_UDF_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_RX_UDF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_RX_UDF_INT_ENA_S  16
/** SDIO_SLC_HOST_FN1_SLC1_TX_OVF_INT_ENA : R/W; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_TX_OVF_INT_ENA    (BIT(17))
#define SDIO_SLC_HOST_FN1_SLC1_TX_OVF_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_TX_OVF_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_TX_OVF_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_TX_OVF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_TX_OVF_INT_ENA_S  17
/** SDIO_SLC_HOST_FN1_SLC1_RX_PF_VALID_INT_ENA : R/W; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_RX_PF_VALID_INT_ENA    (BIT(18))
#define SDIO_SLC_HOST_FN1_SLC1_RX_PF_VALID_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_RX_PF_VALID_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_RX_PF_VALID_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_RX_PF_VALID_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_RX_PF_VALID_INT_ENA_S  18
/** SDIO_SLC_HOST_FN1_SLC1_EXT_BIT0_INT_ENA : R/W; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT0_INT_ENA    (BIT(19))
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT0_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_EXT_BIT0_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_EXT_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT0_INT_ENA_S  19
/** SDIO_SLC_HOST_FN1_SLC1_EXT_BIT1_INT_ENA : R/W; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT1_INT_ENA    (BIT(20))
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT1_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_EXT_BIT1_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_EXT_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT1_INT_ENA_S  20
/** SDIO_SLC_HOST_FN1_SLC1_EXT_BIT2_INT_ENA : R/W; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT2_INT_ENA    (BIT(21))
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT2_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_EXT_BIT2_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_EXT_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT2_INT_ENA_S  21
/** SDIO_SLC_HOST_FN1_SLC1_EXT_BIT3_INT_ENA : R/W; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT3_INT_ENA    (BIT(22))
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT3_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_EXT_BIT3_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_EXT_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_EXT_BIT3_INT_ENA_S  22
/** SDIO_SLC_HOST_FN1_SLC1_WIFI_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_WIFI_RX_NEW_PACKET_INT_ENA    (BIT(23))
#define SDIO_SLC_HOST_FN1_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_S  23
/** SDIO_SLC_HOST_FN1_SLC1_HOST_RD_RETRY_INT_ENA : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_HOST_RD_RETRY_INT_ENA    (BIT(24))
#define SDIO_SLC_HOST_FN1_SLC1_HOST_RD_RETRY_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_HOST_RD_RETRY_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_HOST_RD_RETRY_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_HOST_RD_RETRY_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_HOST_RD_RETRY_INT_ENA_S  24
/** SDIO_SLC_HOST_FN1_SLC1_BT_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN1_SLC1_BT_RX_NEW_PACKET_INT_ENA    (BIT(25))
#define SDIO_SLC_HOST_FN1_SLC1_BT_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_FN1_SLC1_BT_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_FN1_SLC1_BT_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_FN1_SLC1_BT_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN1_SLC1_BT_RX_NEW_PACKET_INT_ENA_S  25

/** SDIO_SLC_HOST_SLC0HOST_FUNC2_INT_ENA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_FUNC2_INT_ENA_REG (DR_REG_SLCHOST_BASE + 0xe4)
/** SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT0_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT0_INT_ENA    (BIT(0))
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT0_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT0_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT0_INT_ENA_S  0
/** SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT1_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT1_INT_ENA    (BIT(1))
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT1_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT1_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT1_INT_ENA_S  1
/** SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT2_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT2_INT_ENA    (BIT(2))
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT2_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT2_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT2_INT_ENA_S  2
/** SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT3_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT3_INT_ENA    (BIT(3))
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT3_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT3_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT3_INT_ENA_S  3
/** SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT4_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT4_INT_ENA    (BIT(4))
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT4_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT4_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT4_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT4_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT4_INT_ENA_S  4
/** SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT5_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT5_INT_ENA    (BIT(5))
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT5_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT5_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT5_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT5_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT5_INT_ENA_S  5
/** SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT6_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT6_INT_ENA    (BIT(6))
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT6_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT6_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT6_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT6_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT6_INT_ENA_S  6
/** SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT7_INT_ENA : R/W; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT7_INT_ENA    (BIT(7))
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT7_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT7_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT7_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT7_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOHOST_BIT7_INT_ENA_S  7
/** SDIO_SLC_HOST_FN2_SLC0_TOKEN0_1TO0_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN0_1TO0_INT_ENA    (BIT(8))
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN0_1TO0_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOKEN0_1TO0_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOKEN0_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN0_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN0_1TO0_INT_ENA_S  8
/** SDIO_SLC_HOST_FN2_SLC0_TOKEN1_1TO0_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN1_1TO0_INT_ENA    (BIT(9))
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN1_1TO0_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOKEN1_1TO0_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOKEN1_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN1_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN1_1TO0_INT_ENA_S  9
/** SDIO_SLC_HOST_FN2_SLC0_TOKEN0_0TO1_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN0_0TO1_INT_ENA    (BIT(10))
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN0_0TO1_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOKEN0_0TO1_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOKEN0_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN0_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN0_0TO1_INT_ENA_S  10
/** SDIO_SLC_HOST_FN2_SLC0_TOKEN1_0TO1_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN1_0TO1_INT_ENA    (BIT(11))
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN1_0TO1_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TOKEN1_0TO1_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TOKEN1_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN1_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TOKEN1_0TO1_INT_ENA_S  11
/** SDIO_SLC_HOST_FN2_SLC0HOST_RX_SOF_INT_ENA : R/W; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_SOF_INT_ENA    (BIT(12))
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_SOF_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0HOST_RX_SOF_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0HOST_RX_SOF_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_SOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_SOF_INT_ENA_S  12
/** SDIO_SLC_HOST_FN2_SLC0HOST_RX_EOF_INT_ENA : R/W; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_EOF_INT_ENA    (BIT(13))
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_EOF_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0HOST_RX_EOF_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0HOST_RX_EOF_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_EOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_EOF_INT_ENA_S  13
/** SDIO_SLC_HOST_FN2_SLC0HOST_RX_START_INT_ENA : R/W; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_START_INT_ENA    (BIT(14))
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_START_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0HOST_RX_START_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0HOST_RX_START_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0HOST_RX_START_INT_ENA_S  14
/** SDIO_SLC_HOST_FN2_SLC0HOST_TX_START_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0HOST_TX_START_INT_ENA    (BIT(15))
#define SDIO_SLC_HOST_FN2_SLC0HOST_TX_START_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0HOST_TX_START_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0HOST_TX_START_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0HOST_TX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0HOST_TX_START_INT_ENA_S  15
/** SDIO_SLC_HOST_FN2_SLC0_RX_UDF_INT_ENA : R/W; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_RX_UDF_INT_ENA    (BIT(16))
#define SDIO_SLC_HOST_FN2_SLC0_RX_UDF_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_RX_UDF_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_RX_UDF_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_RX_UDF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_RX_UDF_INT_ENA_S  16
/** SDIO_SLC_HOST_FN2_SLC0_TX_OVF_INT_ENA : R/W; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_TX_OVF_INT_ENA    (BIT(17))
#define SDIO_SLC_HOST_FN2_SLC0_TX_OVF_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_TX_OVF_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_TX_OVF_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_TX_OVF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_TX_OVF_INT_ENA_S  17
/** SDIO_SLC_HOST_FN2_SLC0_RX_PF_VALID_INT_ENA : R/W; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_RX_PF_VALID_INT_ENA    (BIT(18))
#define SDIO_SLC_HOST_FN2_SLC0_RX_PF_VALID_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_RX_PF_VALID_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_RX_PF_VALID_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_RX_PF_VALID_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_RX_PF_VALID_INT_ENA_S  18
/** SDIO_SLC_HOST_FN2_SLC0_EXT_BIT0_INT_ENA : R/W; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT0_INT_ENA    (BIT(19))
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT0_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_EXT_BIT0_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_EXT_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT0_INT_ENA_S  19
/** SDIO_SLC_HOST_FN2_SLC0_EXT_BIT1_INT_ENA : R/W; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT1_INT_ENA    (BIT(20))
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT1_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_EXT_BIT1_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_EXT_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT1_INT_ENA_S  20
/** SDIO_SLC_HOST_FN2_SLC0_EXT_BIT2_INT_ENA : R/W; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT2_INT_ENA    (BIT(21))
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT2_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_EXT_BIT2_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_EXT_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT2_INT_ENA_S  21
/** SDIO_SLC_HOST_FN2_SLC0_EXT_BIT3_INT_ENA : R/W; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT3_INT_ENA    (BIT(22))
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT3_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_EXT_BIT3_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_EXT_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_EXT_BIT3_INT_ENA_S  22
/** SDIO_SLC_HOST_FN2_SLC0_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_RX_NEW_PACKET_INT_ENA    (BIT(23))
#define SDIO_SLC_HOST_FN2_SLC0_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_RX_NEW_PACKET_INT_ENA_S  23
/** SDIO_SLC_HOST_FN2_SLC0_HOST_RD_RETRY_INT_ENA : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC0_HOST_RD_RETRY_INT_ENA    (BIT(24))
#define SDIO_SLC_HOST_FN2_SLC0_HOST_RD_RETRY_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC0_HOST_RD_RETRY_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC0_HOST_RD_RETRY_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC0_HOST_RD_RETRY_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC0_HOST_RD_RETRY_INT_ENA_S  24
/** SDIO_SLC_HOST_FN2_GPIO_SDIO_INT_ENA : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_GPIO_SDIO_INT_ENA    (BIT(25))
#define SDIO_SLC_HOST_FN2_GPIO_SDIO_INT_ENA_M  (SDIO_SLC_HOST_FN2_GPIO_SDIO_INT_ENA_V << SDIO_SLC_HOST_FN2_GPIO_SDIO_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_GPIO_SDIO_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_GPIO_SDIO_INT_ENA_S  25

/** SDIO_SLC_HOST_SLC1HOST_FUNC2_INT_ENA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_FUNC2_INT_ENA_REG (DR_REG_SLCHOST_BASE + 0xe8)
/** SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT0_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT0_INT_ENA    (BIT(0))
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT0_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT0_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT0_INT_ENA_S  0
/** SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT1_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT1_INT_ENA    (BIT(1))
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT1_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT1_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT1_INT_ENA_S  1
/** SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT2_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT2_INT_ENA    (BIT(2))
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT2_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT2_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT2_INT_ENA_S  2
/** SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT3_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT3_INT_ENA    (BIT(3))
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT3_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT3_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT3_INT_ENA_S  3
/** SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT4_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT4_INT_ENA    (BIT(4))
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT4_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT4_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT4_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT4_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT4_INT_ENA_S  4
/** SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT5_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT5_INT_ENA    (BIT(5))
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT5_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT5_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT5_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT5_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT5_INT_ENA_S  5
/** SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT6_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT6_INT_ENA    (BIT(6))
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT6_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT6_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT6_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT6_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT6_INT_ENA_S  6
/** SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT7_INT_ENA : R/W; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT7_INT_ENA    (BIT(7))
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT7_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT7_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT7_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT7_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOHOST_BIT7_INT_ENA_S  7
/** SDIO_SLC_HOST_FN2_SLC1_TOKEN0_1TO0_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN0_1TO0_INT_ENA    (BIT(8))
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN0_1TO0_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOKEN0_1TO0_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOKEN0_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN0_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN0_1TO0_INT_ENA_S  8
/** SDIO_SLC_HOST_FN2_SLC1_TOKEN1_1TO0_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN1_1TO0_INT_ENA    (BIT(9))
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN1_1TO0_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOKEN1_1TO0_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOKEN1_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN1_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN1_1TO0_INT_ENA_S  9
/** SDIO_SLC_HOST_FN2_SLC1_TOKEN0_0TO1_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN0_0TO1_INT_ENA    (BIT(10))
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN0_0TO1_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOKEN0_0TO1_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOKEN0_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN0_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN0_0TO1_INT_ENA_S  10
/** SDIO_SLC_HOST_FN2_SLC1_TOKEN1_0TO1_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN1_0TO1_INT_ENA    (BIT(11))
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN1_0TO1_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TOKEN1_0TO1_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TOKEN1_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN1_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TOKEN1_0TO1_INT_ENA_S  11
/** SDIO_SLC_HOST_FN2_SLC1HOST_RX_SOF_INT_ENA : R/W; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_SOF_INT_ENA    (BIT(12))
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_SOF_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1HOST_RX_SOF_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1HOST_RX_SOF_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_SOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_SOF_INT_ENA_S  12
/** SDIO_SLC_HOST_FN2_SLC1HOST_RX_EOF_INT_ENA : R/W; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_EOF_INT_ENA    (BIT(13))
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_EOF_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1HOST_RX_EOF_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1HOST_RX_EOF_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_EOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_EOF_INT_ENA_S  13
/** SDIO_SLC_HOST_FN2_SLC1HOST_RX_START_INT_ENA : R/W; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_START_INT_ENA    (BIT(14))
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_START_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1HOST_RX_START_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1HOST_RX_START_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1HOST_RX_START_INT_ENA_S  14
/** SDIO_SLC_HOST_FN2_SLC1HOST_TX_START_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1HOST_TX_START_INT_ENA    (BIT(15))
#define SDIO_SLC_HOST_FN2_SLC1HOST_TX_START_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1HOST_TX_START_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1HOST_TX_START_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1HOST_TX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1HOST_TX_START_INT_ENA_S  15
/** SDIO_SLC_HOST_FN2_SLC1_RX_UDF_INT_ENA : R/W; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_RX_UDF_INT_ENA    (BIT(16))
#define SDIO_SLC_HOST_FN2_SLC1_RX_UDF_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_RX_UDF_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_RX_UDF_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_RX_UDF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_RX_UDF_INT_ENA_S  16
/** SDIO_SLC_HOST_FN2_SLC1_TX_OVF_INT_ENA : R/W; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_TX_OVF_INT_ENA    (BIT(17))
#define SDIO_SLC_HOST_FN2_SLC1_TX_OVF_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_TX_OVF_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_TX_OVF_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_TX_OVF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_TX_OVF_INT_ENA_S  17
/** SDIO_SLC_HOST_FN2_SLC1_RX_PF_VALID_INT_ENA : R/W; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_RX_PF_VALID_INT_ENA    (BIT(18))
#define SDIO_SLC_HOST_FN2_SLC1_RX_PF_VALID_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_RX_PF_VALID_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_RX_PF_VALID_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_RX_PF_VALID_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_RX_PF_VALID_INT_ENA_S  18
/** SDIO_SLC_HOST_FN2_SLC1_EXT_BIT0_INT_ENA : R/W; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT0_INT_ENA    (BIT(19))
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT0_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_EXT_BIT0_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_EXT_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT0_INT_ENA_S  19
/** SDIO_SLC_HOST_FN2_SLC1_EXT_BIT1_INT_ENA : R/W; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT1_INT_ENA    (BIT(20))
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT1_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_EXT_BIT1_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_EXT_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT1_INT_ENA_S  20
/** SDIO_SLC_HOST_FN2_SLC1_EXT_BIT2_INT_ENA : R/W; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT2_INT_ENA    (BIT(21))
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT2_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_EXT_BIT2_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_EXT_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT2_INT_ENA_S  21
/** SDIO_SLC_HOST_FN2_SLC1_EXT_BIT3_INT_ENA : R/W; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT3_INT_ENA    (BIT(22))
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT3_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_EXT_BIT3_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_EXT_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_EXT_BIT3_INT_ENA_S  22
/** SDIO_SLC_HOST_FN2_SLC1_WIFI_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_WIFI_RX_NEW_PACKET_INT_ENA    (BIT(23))
#define SDIO_SLC_HOST_FN2_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_S  23
/** SDIO_SLC_HOST_FN2_SLC1_HOST_RD_RETRY_INT_ENA : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_HOST_RD_RETRY_INT_ENA    (BIT(24))
#define SDIO_SLC_HOST_FN2_SLC1_HOST_RD_RETRY_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_HOST_RD_RETRY_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_HOST_RD_RETRY_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_HOST_RD_RETRY_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_HOST_RD_RETRY_INT_ENA_S  24
/** SDIO_SLC_HOST_FN2_SLC1_BT_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FN2_SLC1_BT_RX_NEW_PACKET_INT_ENA    (BIT(25))
#define SDIO_SLC_HOST_FN2_SLC1_BT_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_FN2_SLC1_BT_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_FN2_SLC1_BT_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_FN2_SLC1_BT_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_FN2_SLC1_BT_RX_NEW_PACKET_INT_ENA_S  25

/** SDIO_SLC_HOST_SLC0HOST_INT_ENA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_INT_ENA_REG (DR_REG_SLCHOST_BASE + 0xec)
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA    (BIT(0))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA_S  0
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA    (BIT(1))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA_S  1
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA    (BIT(2))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA_S  2
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA    (BIT(3))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA_S  3
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA    (BIT(4))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA_S  4
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA    (BIT(5))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA_S  5
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA    (BIT(6))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA_S  6
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA : R/W; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA    (BIT(7))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA_S  7
/** SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA    (BIT(8))
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA_S  8
/** SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA    (BIT(9))
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA_S  9
/** SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA    (BIT(10))
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA_S  10
/** SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA    (BIT(11))
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA_V << SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA_S  11
/** SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA : R/W; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA    (BIT(12))
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA_M  (SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA_V << SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA_S  12
/** SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA : R/W; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA    (BIT(13))
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA_M  (SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA_V << SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA_S  13
/** SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA : R/W; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA    (BIT(14))
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA_M  (SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA_V << SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA_S  14
/** SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA    (BIT(15))
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA_M  (SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA_V << SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA_S  15
/** SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA : R/W; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA    (BIT(16))
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA_M  (SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA_V << SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA_S  16
/** SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA : R/W; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA    (BIT(17))
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA_M  (SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA_V << SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA_S  17
/** SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA : R/W; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA    (BIT(18))
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA_M  (SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA_V << SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA_S  18
/** SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA : R/W; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA    (BIT(19))
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA_M  (SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA_V << SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA_S  19
/** SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA : R/W; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA    (BIT(20))
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA_M  (SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA_V << SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA_S  20
/** SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA : R/W; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA    (BIT(21))
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA_M  (SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA_V << SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA_S  21
/** SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA : R/W; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA    (BIT(22))
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA_M  (SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA_V << SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA_S  22
/** SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA    (BIT(23))
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA_S  23
/** SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA    (BIT(24))
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA_M  (SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA_V << SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA_S)
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA_S  24
/** SDIO_SLC_HOST_GPIO_SDIO_INT_ENA : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ENA    (BIT(25))
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ENA_M  (SDIO_SLC_HOST_GPIO_SDIO_INT_ENA_V << SDIO_SLC_HOST_GPIO_SDIO_INT_ENA_S)
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ENA_S  25

/** SDIO_SLC_HOST_SLC1HOST_INT_ENA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_INT_ENA_REG (DR_REG_SLCHOST_BASE + 0xf0)
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA    (BIT(0))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA_S  0
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA    (BIT(1))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA_S  1
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA    (BIT(2))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA_S  2
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA    (BIT(3))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA_S  3
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA : R/W; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA    (BIT(4))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA_S  4
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA : R/W; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA    (BIT(5))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA_S  5
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA : R/W; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA    (BIT(6))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA_S  6
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA : R/W; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA    (BIT(7))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA_S  7
/** SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA : R/W; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA    (BIT(8))
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA_S  8
/** SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA    (BIT(9))
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA_S  9
/** SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA    (BIT(10))
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA_S  10
/** SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA : R/W; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA    (BIT(11))
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA_V << SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA_S  11
/** SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA : R/W; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA    (BIT(12))
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA_M  (SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA_V << SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA_S  12
/** SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA : R/W; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA    (BIT(13))
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA_M  (SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA_V << SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA_S  13
/** SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA : R/W; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA    (BIT(14))
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA_M  (SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA_V << SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA_S  14
/** SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA    (BIT(15))
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA_M  (SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA_V << SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA_S  15
/** SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA : R/W; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA    (BIT(16))
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA_M  (SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA_V << SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA_S  16
/** SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA : R/W; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA    (BIT(17))
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA_M  (SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA_V << SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA_S  17
/** SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA : R/W; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA    (BIT(18))
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA_M  (SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA_V << SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA_S  18
/** SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA : R/W; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA    (BIT(19))
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA_M  (SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA_V << SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA_S  19
/** SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA : R/W; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA    (BIT(20))
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA_M  (SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA_V << SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA_S  20
/** SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA : R/W; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA    (BIT(21))
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA_M  (SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA_V << SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA_S  21
/** SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA : R/W; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA    (BIT(22))
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA_M  (SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA_V << SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA_S  22
/** SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA    (BIT(23))
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA_S  23
/** SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA    (BIT(24))
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA_M  (SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA_V << SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA_S  24
/** SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA    (BIT(25))
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA_M  (SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA_V << SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA_S)
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA_S  25

/** SDIO_SLC_HOST_SLC0HOST_RX_INFOR_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_INFOR_REG (DR_REG_SLCHOST_BASE + 0xf4)
/** SDIO_SLC_HOST_SLC0HOST_RX_INFOR : R/W; bitpos: [19:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_INFOR    0x000FFFFFU
#define SDIO_SLC_HOST_SLC0HOST_RX_INFOR_M  (SDIO_SLC_HOST_SLC0HOST_RX_INFOR_V << SDIO_SLC_HOST_SLC0HOST_RX_INFOR_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_INFOR_V  0x000FFFFFU
#define SDIO_SLC_HOST_SLC0HOST_RX_INFOR_S  0

/** SDIO_SLC_HOST_SLC1HOST_RX_INFOR_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_INFOR_REG (DR_REG_SLCHOST_BASE + 0xf8)
/** SDIO_SLC_HOST_SLC1HOST_RX_INFOR : R/W; bitpos: [19:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_INFOR    0x000FFFFFU
#define SDIO_SLC_HOST_SLC1HOST_RX_INFOR_M  (SDIO_SLC_HOST_SLC1HOST_RX_INFOR_V << SDIO_SLC_HOST_SLC1HOST_RX_INFOR_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_INFOR_V  0x000FFFFFU
#define SDIO_SLC_HOST_SLC1HOST_RX_INFOR_S  0

/** SDIO_SLC_HOST_SLC0HOST_LEN_WD_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_LEN_WD_REG (DR_REG_SLCHOST_BASE + 0xfc)
/** SDIO_SLC_HOST_SLC0HOST_LEN_WD : R/W; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_LEN_WD    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC0HOST_LEN_WD_M  (SDIO_SLC_HOST_SLC0HOST_LEN_WD_V << SDIO_SLC_HOST_SLC0HOST_LEN_WD_S)
#define SDIO_SLC_HOST_SLC0HOST_LEN_WD_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC0HOST_LEN_WD_S  0

/** SDIO_SLC_HOST_SLC_APBWIN_WDATA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_APBWIN_WDATA_REG (DR_REG_SLCHOST_BASE + 0x100)
/** SDIO_SLC_HOST_SLC_APBWIN_WDATA : R/W; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_APBWIN_WDATA    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC_APBWIN_WDATA_M  (SDIO_SLC_HOST_SLC_APBWIN_WDATA_V << SDIO_SLC_HOST_SLC_APBWIN_WDATA_S)
#define SDIO_SLC_HOST_SLC_APBWIN_WDATA_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC_APBWIN_WDATA_S  0

/** SDIO_SLC_HOST_SLC_APBWIN_CONF_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_APBWIN_CONF_REG (DR_REG_SLCHOST_BASE + 0x104)
/** SDIO_SLC_HOST_SLC_APBWIN_ADDR : R/W; bitpos: [27:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_APBWIN_ADDR    0x0FFFFFFFU
#define SDIO_SLC_HOST_SLC_APBWIN_ADDR_M  (SDIO_SLC_HOST_SLC_APBWIN_ADDR_V << SDIO_SLC_HOST_SLC_APBWIN_ADDR_S)
#define SDIO_SLC_HOST_SLC_APBWIN_ADDR_V  0x0FFFFFFFU
#define SDIO_SLC_HOST_SLC_APBWIN_ADDR_S  0
/** SDIO_SLC_HOST_SLC_APBWIN_WR : R/W; bitpos: [28]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_APBWIN_WR    (BIT(28))
#define SDIO_SLC_HOST_SLC_APBWIN_WR_M  (SDIO_SLC_HOST_SLC_APBWIN_WR_V << SDIO_SLC_HOST_SLC_APBWIN_WR_S)
#define SDIO_SLC_HOST_SLC_APBWIN_WR_V  0x00000001U
#define SDIO_SLC_HOST_SLC_APBWIN_WR_S  28
/** SDIO_SLC_HOST_SLC_APBWIN_START : R/W/SC; bitpos: [29]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_APBWIN_START    (BIT(29))
#define SDIO_SLC_HOST_SLC_APBWIN_START_M  (SDIO_SLC_HOST_SLC_APBWIN_START_V << SDIO_SLC_HOST_SLC_APBWIN_START_S)
#define SDIO_SLC_HOST_SLC_APBWIN_START_V  0x00000001U
#define SDIO_SLC_HOST_SLC_APBWIN_START_S  29

/** SDIO_SLC_HOST_SLC_APBWIN_RDATA_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_APBWIN_RDATA_REG (DR_REG_SLCHOST_BASE + 0x108)
/** SDIO_SLC_HOST_SLC_APBWIN_RDATA : RO; bitpos: [31:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC_APBWIN_RDATA    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC_APBWIN_RDATA_M  (SDIO_SLC_HOST_SLC_APBWIN_RDATA_V << SDIO_SLC_HOST_SLC_APBWIN_RDATA_S)
#define SDIO_SLC_HOST_SLC_APBWIN_RDATA_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLC_APBWIN_RDATA_S  0

/** SDIO_SLC_HOST_RDCLR0_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_RDCLR0_REG (DR_REG_SLCHOST_BASE + 0x10c)
/** SDIO_SLC_HOST_SLCHOST_SLC0_BIT7_CLRADDR : R/W; bitpos: [8:0]; default: 68;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_SLC0_BIT7_CLRADDR    0x000001FFU
#define SDIO_SLC_HOST_SLCHOST_SLC0_BIT7_CLRADDR_M  (SDIO_SLC_HOST_SLCHOST_SLC0_BIT7_CLRADDR_V << SDIO_SLC_HOST_SLCHOST_SLC0_BIT7_CLRADDR_S)
#define SDIO_SLC_HOST_SLCHOST_SLC0_BIT7_CLRADDR_V  0x000001FFU
#define SDIO_SLC_HOST_SLCHOST_SLC0_BIT7_CLRADDR_S  0
/** SDIO_SLC_HOST_SLCHOST_SLC0_BIT6_CLRADDR : R/W; bitpos: [17:9]; default: 480;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_SLC0_BIT6_CLRADDR    0x000001FFU
#define SDIO_SLC_HOST_SLCHOST_SLC0_BIT6_CLRADDR_M  (SDIO_SLC_HOST_SLCHOST_SLC0_BIT6_CLRADDR_V << SDIO_SLC_HOST_SLCHOST_SLC0_BIT6_CLRADDR_S)
#define SDIO_SLC_HOST_SLCHOST_SLC0_BIT6_CLRADDR_V  0x000001FFU
#define SDIO_SLC_HOST_SLCHOST_SLC0_BIT6_CLRADDR_S  9

/** SDIO_SLC_HOST_RDCLR1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_RDCLR1_REG (DR_REG_SLCHOST_BASE + 0x110)
/** SDIO_SLC_HOST_SLCHOST_SLC1_BIT7_CLRADDR : R/W; bitpos: [8:0]; default: 480;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_SLC1_BIT7_CLRADDR    0x000001FFU
#define SDIO_SLC_HOST_SLCHOST_SLC1_BIT7_CLRADDR_M  (SDIO_SLC_HOST_SLCHOST_SLC1_BIT7_CLRADDR_V << SDIO_SLC_HOST_SLCHOST_SLC1_BIT7_CLRADDR_S)
#define SDIO_SLC_HOST_SLCHOST_SLC1_BIT7_CLRADDR_V  0x000001FFU
#define SDIO_SLC_HOST_SLCHOST_SLC1_BIT7_CLRADDR_S  0
/** SDIO_SLC_HOST_SLCHOST_SLC1_BIT6_CLRADDR : R/W; bitpos: [17:9]; default: 480;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_SLC1_BIT6_CLRADDR    0x000001FFU
#define SDIO_SLC_HOST_SLCHOST_SLC1_BIT6_CLRADDR_M  (SDIO_SLC_HOST_SLCHOST_SLC1_BIT6_CLRADDR_V << SDIO_SLC_HOST_SLCHOST_SLC1_BIT6_CLRADDR_S)
#define SDIO_SLC_HOST_SLCHOST_SLC1_BIT6_CLRADDR_V  0x000001FFU
#define SDIO_SLC_HOST_SLCHOST_SLC1_BIT6_CLRADDR_S  9

/** SDIO_SLC_HOST_SLC0HOST_INT_ENA1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_INT_ENA1_REG (DR_REG_SLCHOST_BASE + 0x114)
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA1 : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA1    (BIT(0))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT0_INT_ENA1_S  0
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA1 : R/W; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA1    (BIT(1))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT1_INT_ENA1_S  1
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA1 : R/W; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA1    (BIT(2))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT2_INT_ENA1_S  2
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA1 : R/W; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA1    (BIT(3))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT3_INT_ENA1_S  3
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA1 : R/W; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA1    (BIT(4))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT4_INT_ENA1_S  4
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA1 : R/W; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA1    (BIT(5))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT5_INT_ENA1_S  5
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA1 : R/W; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA1    (BIT(6))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT6_INT_ENA1_S  6
/** SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA1 : R/W; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA1    (BIT(7))
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOHOST_BIT7_INT_ENA1_S  7
/** SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA1 : R/W; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA1    (BIT(8))
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_1TO0_INT_ENA1_S  8
/** SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA1 : R/W; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA1    (BIT(9))
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_1TO0_INT_ENA1_S  9
/** SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA1 : R/W; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA1    (BIT(10))
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN0_0TO1_INT_ENA1_S  10
/** SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA1 : R/W; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA1    (BIT(11))
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TOKEN1_0TO1_INT_ENA1_S  11
/** SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA1 : R/W; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA1    (BIT(12))
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA1_M  (SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA1_V << SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_SOF_INT_ENA1_S  12
/** SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA1 : R/W; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA1    (BIT(13))
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA1_M  (SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA1_V << SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_EOF_INT_ENA1_S  13
/** SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA1 : R/W; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA1    (BIT(14))
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA1_M  (SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA1_V << SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_RX_START_INT_ENA1_S  14
/** SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA1 : R/W; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA1    (BIT(15))
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA1_M  (SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA1_V << SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0HOST_TX_START_INT_ENA1_S  15
/** SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA1 : R/W; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA1    (BIT(16))
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA1_V << SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_UDF_INT_ENA1_S  16
/** SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA1 : R/W; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA1    (BIT(17))
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA1_V << SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_TX_OVF_INT_ENA1_S  17
/** SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA1 : R/W; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA1    (BIT(18))
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA1_V << SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_PF_VALID_INT_ENA1_S  18
/** SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA1 : R/W; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA1    (BIT(19))
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA1_V << SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT0_INT_ENA1_S  19
/** SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA1 : R/W; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA1    (BIT(20))
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA1_V << SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT1_INT_ENA1_S  20
/** SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA1 : R/W; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA1    (BIT(21))
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA1_V << SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT2_INT_ENA1_S  21
/** SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA1 : R/W; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA1    (BIT(22))
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA1_V << SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_EXT_BIT3_INT_ENA1_S  22
/** SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA1 : R/W; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA1    (BIT(23))
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA1_V << SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_RX_NEW_PACKET_INT_ENA1_S  23
/** SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA1 : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA1    (BIT(24))
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA1_M  (SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA1_V << SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC0_HOST_RD_RETRY_INT_ENA1_S  24
/** SDIO_SLC_HOST_GPIO_SDIO_INT_ENA1 : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ENA1    (BIT(25))
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ENA1_M  (SDIO_SLC_HOST_GPIO_SDIO_INT_ENA1_V << SDIO_SLC_HOST_GPIO_SDIO_INT_ENA1_S)
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_GPIO_SDIO_INT_ENA1_S  25

/** SDIO_SLC_HOST_SLC1HOST_INT_ENA1_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_INT_ENA1_REG (DR_REG_SLCHOST_BASE + 0x118)
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA1 : R/W; bitpos: [0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA1    (BIT(0))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT0_INT_ENA1_S  0
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA1 : R/W; bitpos: [1]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA1    (BIT(1))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT1_INT_ENA1_S  1
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA1 : R/W; bitpos: [2]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA1    (BIT(2))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT2_INT_ENA1_S  2
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA1 : R/W; bitpos: [3]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA1    (BIT(3))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT3_INT_ENA1_S  3
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA1 : R/W; bitpos: [4]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA1    (BIT(4))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT4_INT_ENA1_S  4
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA1 : R/W; bitpos: [5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA1    (BIT(5))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT5_INT_ENA1_S  5
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA1 : R/W; bitpos: [6]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA1    (BIT(6))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT6_INT_ENA1_S  6
/** SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA1 : R/W; bitpos: [7]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA1    (BIT(7))
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOHOST_BIT7_INT_ENA1_S  7
/** SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA1 : R/W; bitpos: [8]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA1    (BIT(8))
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_1TO0_INT_ENA1_S  8
/** SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA1 : R/W; bitpos: [9]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA1    (BIT(9))
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_1TO0_INT_ENA1_S  9
/** SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA1 : R/W; bitpos: [10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA1    (BIT(10))
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN0_0TO1_INT_ENA1_S  10
/** SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA1 : R/W; bitpos: [11]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA1    (BIT(11))
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TOKEN1_0TO1_INT_ENA1_S  11
/** SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA1 : R/W; bitpos: [12]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA1    (BIT(12))
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA1_M  (SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA1_V << SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_SOF_INT_ENA1_S  12
/** SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA1 : R/W; bitpos: [13]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA1    (BIT(13))
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA1_M  (SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA1_V << SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_EOF_INT_ENA1_S  13
/** SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA1 : R/W; bitpos: [14]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA1    (BIT(14))
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA1_M  (SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA1_V << SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_RX_START_INT_ENA1_S  14
/** SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA1 : R/W; bitpos: [15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA1    (BIT(15))
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA1_M  (SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA1_V << SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1HOST_TX_START_INT_ENA1_S  15
/** SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA1 : R/W; bitpos: [16]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA1    (BIT(16))
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA1_V << SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_UDF_INT_ENA1_S  16
/** SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA1 : R/W; bitpos: [17]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA1    (BIT(17))
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA1_V << SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_TX_OVF_INT_ENA1_S  17
/** SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA1 : R/W; bitpos: [18]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA1    (BIT(18))
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA1_V << SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_RX_PF_VALID_INT_ENA1_S  18
/** SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA1 : R/W; bitpos: [19]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA1    (BIT(19))
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA1_V << SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT0_INT_ENA1_S  19
/** SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA1 : R/W; bitpos: [20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA1    (BIT(20))
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA1_V << SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT1_INT_ENA1_S  20
/** SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA1 : R/W; bitpos: [21]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA1    (BIT(21))
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA1_V << SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT2_INT_ENA1_S  21
/** SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA1 : R/W; bitpos: [22]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA1    (BIT(22))
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA1_V << SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_EXT_BIT3_INT_ENA1_S  22
/** SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA1 : R/W; bitpos: [23]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA1    (BIT(23))
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA1_V << SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_WIFI_RX_NEW_PACKET_INT_ENA1_S  23
/** SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA1 : R/W; bitpos: [24]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA1    (BIT(24))
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA1_V << SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_HOST_RD_RETRY_INT_ENA1_S  24
/** SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA1 : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA1    (BIT(25))
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA1_M  (SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA1_V << SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA1_S)
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA1_V  0x00000001U
#define SDIO_SLC_HOST_SLC1_BT_RX_NEW_PACKET_INT_ENA1_S  25

/** SDIO_SLC_HOST_DATE_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_DATE_REG (DR_REG_SLCHOST_BASE + 0x178)
/** SDIO_SLC_HOST_SLCHOST_DATE : R/W; bitpos: [31:0]; default: 554043136;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_DATE    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLCHOST_DATE_M  (SDIO_SLC_HOST_SLCHOST_DATE_V << SDIO_SLC_HOST_SLCHOST_DATE_S)
#define SDIO_SLC_HOST_SLCHOST_DATE_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLCHOST_DATE_S  0

/** SDIO_SLC_HOST_ID_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_ID_REG (DR_REG_SLCHOST_BASE + 0x17c)
/** SDIO_SLC_HOST_SLCHOST_ID : R/W; bitpos: [31:0]; default: 1536;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SLCHOST_ID    0xFFFFFFFFU
#define SDIO_SLC_HOST_SLCHOST_ID_M  (SDIO_SLC_HOST_SLCHOST_ID_V << SDIO_SLC_HOST_SLCHOST_ID_S)
#define SDIO_SLC_HOST_SLCHOST_ID_V  0xFFFFFFFFU
#define SDIO_SLC_HOST_SLCHOST_ID_S  0

/** SDIO_SLC_HOST_CONF_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_CONF_REG (DR_REG_SLCHOST_BASE + 0x1f0)
/** SDIO_SLC_HOST_FRC_SDIO11 : R/W; bitpos: [4:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FRC_SDIO11    0x0000001FU
#define SDIO_SLC_HOST_FRC_SDIO11_M  (SDIO_SLC_HOST_FRC_SDIO11_V << SDIO_SLC_HOST_FRC_SDIO11_S)
#define SDIO_SLC_HOST_FRC_SDIO11_V  0x0000001FU
#define SDIO_SLC_HOST_FRC_SDIO11_S  0
/** SDIO_SLC_HOST_FRC_SDIO20 : R/W; bitpos: [9:5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FRC_SDIO20    0x0000001FU
#define SDIO_SLC_HOST_FRC_SDIO20_M  (SDIO_SLC_HOST_FRC_SDIO20_V << SDIO_SLC_HOST_FRC_SDIO20_S)
#define SDIO_SLC_HOST_FRC_SDIO20_V  0x0000001FU
#define SDIO_SLC_HOST_FRC_SDIO20_S  5
/** SDIO_SLC_HOST_FRC_NEG_SAMP : R/W; bitpos: [14:10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FRC_NEG_SAMP    0x0000001FU
#define SDIO_SLC_HOST_FRC_NEG_SAMP_M  (SDIO_SLC_HOST_FRC_NEG_SAMP_V << SDIO_SLC_HOST_FRC_NEG_SAMP_S)
#define SDIO_SLC_HOST_FRC_NEG_SAMP_V  0x0000001FU
#define SDIO_SLC_HOST_FRC_NEG_SAMP_S  10
/** SDIO_SLC_HOST_FRC_POS_SAMP : R/W; bitpos: [19:15]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FRC_POS_SAMP    0x0000001FU
#define SDIO_SLC_HOST_FRC_POS_SAMP_M  (SDIO_SLC_HOST_FRC_POS_SAMP_V << SDIO_SLC_HOST_FRC_POS_SAMP_S)
#define SDIO_SLC_HOST_FRC_POS_SAMP_V  0x0000001FU
#define SDIO_SLC_HOST_FRC_POS_SAMP_S  15
/** SDIO_SLC_HOST_FRC_QUICK_IN : R/W; bitpos: [24:20]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_FRC_QUICK_IN    0x0000001FU
#define SDIO_SLC_HOST_FRC_QUICK_IN_M  (SDIO_SLC_HOST_FRC_QUICK_IN_V << SDIO_SLC_HOST_FRC_QUICK_IN_S)
#define SDIO_SLC_HOST_FRC_QUICK_IN_V  0x0000001FU
#define SDIO_SLC_HOST_FRC_QUICK_IN_S  20
/** SDIO_SLC_HOST_SDIO20_INT_DELAY : R/W; bitpos: [25]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SDIO20_INT_DELAY    (BIT(25))
#define SDIO_SLC_HOST_SDIO20_INT_DELAY_M  (SDIO_SLC_HOST_SDIO20_INT_DELAY_V << SDIO_SLC_HOST_SDIO20_INT_DELAY_S)
#define SDIO_SLC_HOST_SDIO20_INT_DELAY_V  0x00000001U
#define SDIO_SLC_HOST_SDIO20_INT_DELAY_S  25
/** SDIO_SLC_HOST_SDIO_PAD_PULLUP : R/W; bitpos: [26]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SDIO_PAD_PULLUP    (BIT(26))
#define SDIO_SLC_HOST_SDIO_PAD_PULLUP_M  (SDIO_SLC_HOST_SDIO_PAD_PULLUP_V << SDIO_SLC_HOST_SDIO_PAD_PULLUP_S)
#define SDIO_SLC_HOST_SDIO_PAD_PULLUP_V  0x00000001U
#define SDIO_SLC_HOST_SDIO_PAD_PULLUP_S  26
/** SDIO_SLC_HOST_HSPEED_CON_EN : R/W; bitpos: [27]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_HSPEED_CON_EN    (BIT(27))
#define SDIO_SLC_HOST_HSPEED_CON_EN_M  (SDIO_SLC_HOST_HSPEED_CON_EN_V << SDIO_SLC_HOST_HSPEED_CON_EN_S)
#define SDIO_SLC_HOST_HSPEED_CON_EN_V  0x00000001U
#define SDIO_SLC_HOST_HSPEED_CON_EN_S  27

/** SDIO_SLC_HOST_INF_ST_REG register
 *  *******Description***********
 */
#define SDIO_SLC_HOST_INF_ST_REG (DR_REG_SLCHOST_BASE + 0x1f4)
/** SDIO_SLC_HOST_SDIO20_MODE : RO; bitpos: [4:0]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SDIO20_MODE    0x0000001FU
#define SDIO_SLC_HOST_SDIO20_MODE_M  (SDIO_SLC_HOST_SDIO20_MODE_V << SDIO_SLC_HOST_SDIO20_MODE_S)
#define SDIO_SLC_HOST_SDIO20_MODE_V  0x0000001FU
#define SDIO_SLC_HOST_SDIO20_MODE_S  0
/** SDIO_SLC_HOST_SDIO_NEG_SAMP : RO; bitpos: [9:5]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SDIO_NEG_SAMP    0x0000001FU
#define SDIO_SLC_HOST_SDIO_NEG_SAMP_M  (SDIO_SLC_HOST_SDIO_NEG_SAMP_V << SDIO_SLC_HOST_SDIO_NEG_SAMP_S)
#define SDIO_SLC_HOST_SDIO_NEG_SAMP_V  0x0000001FU
#define SDIO_SLC_HOST_SDIO_NEG_SAMP_S  5
/** SDIO_SLC_HOST_SDIO_QUICK_IN : RO; bitpos: [14:10]; default: 0;
 *  *******Description***********
 */
#define SDIO_SLC_HOST_SDIO_QUICK_IN    0x0000001FU
#define SDIO_SLC_HOST_SDIO_QUICK_IN_M  (SDIO_SLC_HOST_SDIO_QUICK_IN_V << SDIO_SLC_HOST_SDIO_QUICK_IN_S)
#define SDIO_SLC_HOST_SDIO_QUICK_IN_V  0x0000001FU
#define SDIO_SLC_HOST_SDIO_QUICK_IN_S  10
/** SDIO_SLC_HOST_DLL_ON_SW : R/W; bitpos: [15]; default: 0;
 *  dll is controlled by software
 */
#define SDIO_SLC_HOST_DLL_ON_SW    (BIT(15))
#define SDIO_SLC_HOST_DLL_ON_SW_M  (SDIO_SLC_HOST_DLL_ON_SW_V << SDIO_SLC_HOST_DLL_ON_SW_S)
#define SDIO_SLC_HOST_DLL_ON_SW_V  0x00000001U
#define SDIO_SLC_HOST_DLL_ON_SW_S  15
/** SDIO_SLC_HOST_DLL_ON : R/W; bitpos: [16]; default: 0;
 *  Software dll on
 */
#define SDIO_SLC_HOST_DLL_ON    (BIT(16))
#define SDIO_SLC_HOST_DLL_ON_M  (SDIO_SLC_HOST_DLL_ON_V << SDIO_SLC_HOST_DLL_ON_S)
#define SDIO_SLC_HOST_DLL_ON_V  0x00000001U
#define SDIO_SLC_HOST_DLL_ON_S  16
/** SDIO_SLC_HOST_CLK_MODE_SW : R/W; bitpos: [17]; default: 0;
 *  dll clock mode is controlled by software
 */
#define SDIO_SLC_HOST_CLK_MODE_SW    (BIT(17))
#define SDIO_SLC_HOST_CLK_MODE_SW_M  (SDIO_SLC_HOST_CLK_MODE_SW_V << SDIO_SLC_HOST_CLK_MODE_SW_S)
#define SDIO_SLC_HOST_CLK_MODE_SW_V  0x00000001U
#define SDIO_SLC_HOST_CLK_MODE_SW_S  17
/** SDIO_SLC_HOST_CLK_MODE : R/W; bitpos: [19:18]; default: 0;
 *  Software set clock mode
 */
#define SDIO_SLC_HOST_CLK_MODE    0x00000003U
#define SDIO_SLC_HOST_CLK_MODE_M  (SDIO_SLC_HOST_CLK_MODE_V << SDIO_SLC_HOST_CLK_MODE_S)
#define SDIO_SLC_HOST_CLK_MODE_V  0x00000003U
#define SDIO_SLC_HOST_CLK_MODE_S  18

#ifdef __cplusplus
}
#endif
