/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.fusion;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerFusionKlystron;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIFusionKlystron;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.fusion.TileEntityFusionTorus;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.KlystronNetwork;
import com.hbm.uninos.networkproviders.KlystronNetworkProvider;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityFusionKlystron
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardReceiverMK2,
IControlReceiver,
IGUIProvider,
SimpleComponent,
CompatHandler.OCComponent {
    protected GenNode klystronNode;
    public static final long MAX_OUTPUT = 1000000L;
    public static final int AIR_CONSUMPTION = 2500;
    public long outputTarget;
    public long output;
    public long power;
    public long maxPower;
    public float fan;
    public float prevFan;
    public float fanSpeed;
    public static final float FAN_ACCELERATION = 0.125f;
    public FluidTank compair = new FluidTank(Fluids.AIR, 150000);
    private AudioWrapper audio;
    AxisAlignedBB bb = null;

    public TileEntityFusionKlystron() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.fusionKlystron";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.maxPower = Math.max(1000000L, this.outputTarget * 100L);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                this.trySubscribe(this.compair.getTankType(), this.field_145850_b, pos);
            }
            this.output = 0L;
            double powerFactor = TileEntityFusionTorus.getSpeedScaled(this.maxPower, this.power);
            double airFactor = TileEntityFusionTorus.getSpeedScaled(this.compair.getMaxFill(), this.compair.getFill());
            double factor = Math.min(powerFactor, airFactor);
            long powerReq = (long)Math.ceil((double)this.outputTarget * factor);
            int airReq = (int)Math.ceil(2500.0 * factor);
            if (this.outputTarget > 0L && this.power >= powerReq && this.compair.getFill() >= airReq) {
                this.output = powerReq;
                this.power -= powerReq;
                this.compair.setFill(this.compair.getFill() - airReq);
            }
            if (this.output < this.outputTarget / 50L) {
                this.output = 0L;
            }
            this.klystronNode = TileEntityFusionKlystron.handleKNode(this.klystronNode, this);
            TileEntityFusionKlystron.provideKyU(this.klystronNode, this.output);
            this.networkPackNT(100);
        } else {
            double mult = TileEntityFusionTorus.getSpeedScaled(this.outputTarget, this.output);
            this.fanSpeed = this.output > 0L ? (float)((double)this.fanSpeed + 0.125 * mult) : (this.fanSpeed -= 0.125f);
            this.fanSpeed = MathHelper.func_76131_a((float)this.fanSpeed, (float)0.0f, (float)(5.0f * (float)mult));
            this.prevFan = this.fan;
            this.fan += this.fanSpeed;
            if (this.fan >= 360.0f) {
                this.fan -= 360.0f;
                this.prevFan -= 360.0f;
            }
            if (this.fanSpeed > 0.0f && MainRegistry.proxy.me().func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 2.5, (double)this.field_145849_e + 0.5) < 900.0) {
                float speed = this.fanSpeed / 5.0f;
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.fel", (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 2.5f, (float)this.field_145849_e + 0.5f, this.getVolume(speed), 15.0f, speed, 20);
                    this.audio.startSound();
                } else {
                    this.audio.updateVolume(this.getVolume(speed));
                    this.audio.updatePitch(speed);
                    this.audio.keepAlive();
                }
            } else if (this.audio != null) {
                if (this.audio.isPlaying()) {
                    this.audio.stopSound();
                }
                this.audio = null;
            }
        }
    }

    public static GenNode handleKNode(GenNode klystronNode, TileEntity that) {
        World worldObj = that.func_145831_w();
        int xCoord = that.field_145851_c;
        int yCoord = that.field_145848_d;
        int zCoord = that.field_145849_e;
        if (klystronNode == null || klystronNode.expired) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(that.func_145832_p() - 10)).getOpposite();
            klystronNode = UniNodespace.getNode(worldObj, xCoord + dir.offsetX * 4, yCoord + 2, zCoord + dir.offsetZ * 4, KlystronNetworkProvider.THE_PROVIDER);
            if (klystronNode == null) {
                klystronNode = new GenNode<KlystronNetwork>(KlystronNetworkProvider.THE_PROVIDER, new BlockPos(xCoord + dir.offsetX * 4, yCoord + 2, zCoord + dir.offsetZ * 4)).setConnections(new DirPos(xCoord + dir.offsetX * 5, yCoord + 2, zCoord + dir.offsetZ * 5, dir));
                UniNodespace.createNode(worldObj, klystronNode);
            }
        }
        if (klystronNode.net != null) {
            ((NodeNet)klystronNode.net).addProvider((TileEntity)that);
        }
        return klystronNode;
    }

    public static boolean provideKyU(GenNode klystronNode, long output) {
        boolean connected = false;
        if (klystronNode != null && klystronNode.net != null) {
            KlystronNetwork net = (KlystronNetwork)klystronNode.net;
            for (Map.Entry o : net.receiverEntries.entrySet()) {
                TileEntityFusionTorus torus;
                Map.Entry e = o;
                if (!(e.getKey() instanceof TileEntityFusionTorus) || !(torus = (TileEntityFusionTorus)e.getKey()).isLoaded() || torus.func_145837_r()) continue;
                torus.klystronEnergy += output;
                connected = true;
                break;
            }
        }
        return connected;
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 4, dir), new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ * 3, rot.getOpposite())};
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        if (!this.field_145850_b.field_72995_K && this.klystronNode != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.klystronNode);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        buf.writeLong(this.outputTarget);
        buf.writeLong(this.output);
        this.compair.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        this.outputTarget = buf.readLong();
        this.output = buf.readLong();
        this.compair.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.outputTarget = nbt.func_74763_f("outputTarget");
        this.compair.readFromNBT(nbt, "t");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        nbt.func_74772_a("outputTarget", this.outputTarget);
        this.compair.writeToNBT(nbt, "t");
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.compair};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.compair};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFusionKlystron(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFusionKlystron(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)this.field_145848_d, (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 5));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 2.5, (double)this.field_145849_e + 0.5) < 400.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("amount")) {
            this.outputTarget = data.func_74763_f("amount");
            if (this.outputTarget < 0L) {
                this.outputTarget = 0L;
            }
            if (this.outputTarget > 1000000L) {
                this.outputTarget = 1000000L;
            }
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_fusion_klystron";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getAir(Context context, Arguments args) {
        return new Object[]{this.compair.getFill(), this.compair.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getOutput(Context context, Arguments args) {
        return new Object[]{this.output, this.outputTarget};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setOutput(Context context, Arguments args) {
        this.outputTarget = (long)MathHelper.func_151237_a((double)args.checkDouble(0), (double)0.0, (double)1000000.0);
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower(), this.compair.getFill(), this.compair.getMaxFill(), this.output, this.outputTarget};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getEnergyInfo", "getAir", "getOutput", "setOutput", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getEnergyInfo": {
                return this.getEnergyInfo(context, args);
            }
            case "getAir": {
                return this.getAir(context, args);
            }
            case "getOutput": {
                return this.getOutput(context, args);
            }
            case "setOutput": {
                return this.setOutput(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

