/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BufferUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineTeleporter
extends TileEntityLoadedBase
implements IEnergyReceiverMK2,
IFluidStandardReceiver,
IBufPacketReceiver {
    public long power = 0L;
    public int targetX = -1;
    public int targetY = -1;
    public int targetZ = -1;
    public int targetDim = 0;
    public static final int maxPower = 1500000;
    public static final int consumption = 1000000;
    public static final int flucu = 100;
    public FluidTank tank = new FluidTank(Fluids.NMASS, 16000);

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            List entities;
            this.subscribeToAllAround(this.tank.getTankType(), this);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            if (this.targetY != -1 && !(entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.25), (double)this.field_145848_d, (double)((double)this.field_145849_e + 0.25), (double)((double)this.field_145851_c + 0.75), (double)(this.field_145848_d + 2), (double)((double)this.field_145849_e + 0.75)))).isEmpty()) {
                for (Entity e : entities) {
                    this.teleport(e);
                }
            }
            this.networkPackNT(15);
        } else if (this.targetY != -1 && this.power >= 1000000L && this.tank.getFill() >= 100) {
            double x = (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
            double y = (double)(this.field_145848_d + 1) + this.field_145850_b.field_73012_v.nextDouble() * 2.0;
            double z = (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
            this.field_145850_b.func_72869_a("reddust", x, y, z, (double)0.4f, (double)0.8f, 1.0);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeLong(this.power);
        BufferUtil.writeIntArray(buf, new int[]{this.targetX, this.targetY, this.targetZ, this.targetDim});
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.power = buf.readLong();
        int[] target = BufferUtil.readIntArray(buf);
        this.targetX = target[0];
        this.targetY = target[1];
        this.targetZ = target[2];
        this.targetDim = target[3];
        this.tank.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.targetX = nbt.func_74762_e("x1");
        this.targetY = nbt.func_74762_e("y1");
        this.targetZ = nbt.func_74762_e("z1");
        this.targetDim = nbt.func_74762_e("dim");
        this.tank.readFromNBT(nbt, "tt");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("x1", this.targetX);
        nbt.func_74768_a("y1", this.targetY);
        nbt.func_74768_a("z1", this.targetZ);
        nbt.func_74768_a("dim", this.targetDim);
        this.tank.writeToNBT(nbt, "tt");
    }

    public void teleport(Entity entity) {
        if (this.power < 1000000L) {
            return;
        }
        if (entity.field_71093_bK != this.targetDim && this.tank.getFill() < 100) {
            return;
        }
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        if (entity.field_71093_bK != this.targetDim) {
            this.tank.setFill(this.tank.getFill() - 100);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (entity.field_71093_bK == this.targetDim) {
                player.func_70634_a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + entity.func_70033_W(), (double)this.targetZ + 0.5);
            } else {
                TileEntityMachineTeleporter.teleportPlayerInterdimensionally(player, (double)this.targetX + 0.5, (double)this.targetY + 1.5 + entity.func_70033_W(), (double)this.targetZ + 0.5, this.targetDim);
            }
        } else {
            EntityItem entityItem;
            if (entity.field_71093_bK == this.targetDim) {
                entity.func_70080_a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + entity.func_70033_W(), (double)this.targetZ + 0.5, entity.field_70177_z, entity.field_70125_A);
                try {
                    EntityTracker entitytracker = ((WorldServer)this.field_145850_b).func_73039_n();
                    IntHashMap map = (IntHashMap)ReflectionHelper.getPrivateValue(EntityTracker.class, (Object)entitytracker, (String[])new String[]{"trackedEntityIDs", "field_72794_c"});
                    EntityTrackerEntry entry = (EntityTrackerEntry)map.func_76041_a(entity.func_145782_y());
                    int yawByte = MathHelper.func_76141_d((float)(entity.field_70177_z * 256.0f / 360.0f));
                    int pitchByte = MathHelper.func_76141_d((float)(entity.field_70125_A * 256.0f / 360.0f));
                    int x32 = entity.field_70168_am.func_75630_a(entity.field_70165_t);
                    int y32 = MathHelper.func_76128_c((double)(entity.field_70163_u * 32.0));
                    int z32 = entity.field_70168_am.func_75630_a(entity.field_70161_v);
                    entry.func_151259_a((Packet)new S18PacketEntityTeleport(entity.func_145782_y(), x32, y32, z32, (byte)yawByte, (byte)pitchByte));
                }
                catch (Exception entitytracker) {}
            } else {
                TileEntityMachineTeleporter.teleportEntityInterdimensionally(entity, (double)this.targetX + 0.5, (double)this.targetY + 1.5 + entity.func_70033_W(), (double)this.targetZ + 0.5, this.targetDim);
            }
            if (entity instanceof EntityItem && (entityItem = (EntityItem)entity).func_92059_d().func_77973_b() == Items.field_151025_P) {
                WorldServer newWorld = MinecraftServer.func_71276_C().func_71218_a(this.targetDim);
                EntitySlime slime = new EntitySlime((World)newWorld);
                slime.func_70012_b((double)this.targetX + 0.5, (double)this.targetY + 1.5 + slime.func_70033_W(), (double)this.targetZ + 0.5, entity.field_70177_z, entity.field_70125_A);
                slime.func_110161_a(null);
                newWorld.func_72838_d((Entity)slime);
            }
        }
        this.field_145850_b.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
        this.power -= 1000000L;
        this.func_70296_d();
    }

    public static boolean teleportPlayerInterdimensionally(EntityPlayerMP player, double x, double y, double z, int dim) {
        int prevDim = player.field_71093_bK;
        WorldServer prevWorld = player.field_71133_b.func_71218_a(prevDim);
        WorldServer newWorld = player.field_71133_b.func_71218_a(dim);
        player.field_71093_bK = dim;
        if (newWorld == null) {
            return false;
        }
        ServerConfigurationManager man = player.field_71133_b.func_71203_ab();
        NetHandlerPlayServer net = player.field_71135_a;
        net.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        prevWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        if (player.func_70089_S()) {
            player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
            newWorld.func_72838_d((Entity)player);
            newWorld.func_72866_a((Entity)player, false);
        }
        player.func_70029_a((World)newWorld);
        man.func_72375_a(player, prevWorld);
        net.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(newWorld);
        man.func_72354_b(player, newWorld);
        man.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, prevDim, dim);
        return true;
    }

    public static boolean teleportEntityInterdimensionally(Entity oldEntity, double x, double y, double z, int dim) {
        MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
        WorldServer newWorld = minecraftserver.func_71218_a(dim);
        if (newWorld == null) {
            return false;
        }
        oldEntity.field_70170_p.func_72900_e(oldEntity);
        oldEntity.field_70128_L = false;
        Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)oldEntity), (World)newWorld);
        if (entity != null) {
            entity.func_82141_a(oldEntity, true);
            entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72866_a(entity, false);
            entity.func_70029_a((World)newWorld);
            IChunkProvider provider = newWorld.func_72863_F();
            provider.func_73158_c((int)Math.floor(x) >> 4, (int)Math.floor(z) >> 4);
            newWorld.func_72838_d(entity);
        }
        oldEntity.field_70128_L = true;
        newWorld.func_82742_i();
        return true;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1500000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }
}

