/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.recipes.ChemplantRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityMachineChemplantBase
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiverMK2,
IGUIProvider {
    public long power;
    public int[] progress;
    public int[] maxProgress;
    public boolean isProgressing;
    public FluidTank[] tanks;
    int consumption = 100;
    int speed = 100;
    public HashMap<ItemStack[], Boolean> cachedItems = new HashMap();

    public TileEntityMachineChemplantBase(int scount) {
        super(scount);
        int count = this.getRecipeCount();
        this.progress = new int[count];
        this.maxProgress = new int[count];
        this.tanks = new FluidTank[4 * count];
        for (int i = 0; i < 4 * count; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, this.getTankCapacity());
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            int count = this.getRecipeCount();
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            for (i = 0; i < count; ++i) {
                this.loadItems(i);
                this.unloadItems(i);
            }
            for (i = 0; i < count; ++i) {
                if (!this.canProcess(i)) {
                    this.progress[i] = 0;
                    continue;
                }
                this.isProgressing = true;
                this.process(i);
            }
        }
    }

    protected boolean canProcess(int index) {
        int template = this.getTemplateIndex(index);
        if (this.slots[template] == null || this.slots[template].func_77973_b() != ModItems.chemistry_template) {
            return false;
        }
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[template].func_77960_j());
        if (recipe == null) {
            return false;
        }
        this.setupTanks(recipe, index);
        if (this.power < (long)this.consumption) {
            return false;
        }
        if (!this.hasRequiredFluids(recipe, index)) {
            return false;
        }
        if (!this.hasSpaceForFluids(recipe, index)) {
            return false;
        }
        if (!this.hasRequiredItems(recipe, index)) {
            return false;
        }
        if (!this.hasSpaceForItems(recipe, index)) {
            return false;
        }
        if (recipe.oxygenConsumption > 0) {
            return this.breatheAir(recipe.oxygenConsumption);
        }
        return true;
    }

    private void setupTanks(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.inputFluids[0] != null) {
            this.tanks[index * 4].withPressure(recipe.inputFluids[0].pressure).setTankType(recipe.inputFluids[0].type);
        } else {
            this.tanks[index * 4].setTankType(Fluids.NONE);
        }
        if (recipe.inputFluids[1] != null) {
            this.tanks[index * 4 + 1].withPressure(recipe.inputFluids[1].pressure).setTankType(recipe.inputFluids[1].type);
        } else {
            this.tanks[index * 4 + 1].setTankType(Fluids.NONE);
        }
        if (recipe.outputFluids[0] != null) {
            this.tanks[index * 4 + 2].withPressure(recipe.outputFluids[0].pressure).setTankType(recipe.outputFluids[0].type);
        } else {
            this.tanks[index * 4 + 2].setTankType(Fluids.NONE);
        }
        if (recipe.outputFluids[1] != null) {
            this.tanks[index * 4 + 3].withPressure(recipe.outputFluids[1].pressure).setTankType(recipe.outputFluids[1].type);
        } else {
            this.tanks[index * 4 + 3].setTankType(Fluids.NONE);
        }
    }

    private boolean hasRequiredFluids(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.inputFluids[0] != null && this.tanks[index * 4].getFill() < recipe.inputFluids[0].fill) {
            return false;
        }
        return recipe.inputFluids[1] == null || this.tanks[index * 4 + 1].getFill() >= recipe.inputFluids[1].fill;
    }

    private boolean hasSpaceForFluids(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.outputFluids[0] != null && this.tanks[index * 4 + 2].getFill() + recipe.outputFluids[0].fill > this.tanks[index * 4 + 2].getMaxFill()) {
            return false;
        }
        return recipe.outputFluids[1] == null || this.tanks[index * 4 + 3].getFill() + recipe.outputFluids[1].fill <= this.tanks[index * 4 + 3].getMaxFill();
    }

    private boolean hasRequiredItems(ChemplantRecipes.ChemRecipe recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        ItemStack[] copy = ItemStackUtil.carefulCopyArrayTruncate(this.slots, indices[0], indices[1]);
        if (this.cachedItems.get(copy) != null) {
            return this.cachedItems.get(copy);
        }
        boolean hasItems = InventoryUtil.doesArrayHaveIngredients(this.slots, indices[0], indices[1], recipe.inputs);
        this.cachedItems.put(copy, hasItems);
        return hasItems;
    }

    private boolean hasSpaceForItems(ChemplantRecipes.ChemRecipe recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        return InventoryUtil.doesArrayHaveSpace(this.slots, indices[2], indices[3], recipe.outputs);
    }

    protected void process(int index) {
        this.power -= (long)this.consumption;
        int n = index;
        this.progress[n] = this.progress[n] + 1;
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.meteorite_sword_machined) {
            this.slots[0] = new ItemStack(ModItems.meteorite_sword_treated);
        }
        int template = this.getTemplateIndex(index);
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[template].func_77960_j());
        this.maxProgress[index] = recipe.getDuration() * this.speed / 100;
        if (this.maxProgress[index] <= 0) {
            this.maxProgress[index] = 1;
        }
        if (this.progress[index] >= this.maxProgress[index]) {
            this.consumeFluids(recipe, index);
            this.produceFluids(recipe, index);
            this.consumeItems(recipe, index);
            this.produceItems(recipe, index);
            this.progress[index] = 0;
            this.func_70296_d();
        }
    }

    private void consumeFluids(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.inputFluids[0] != null) {
            this.tanks[index * 4].setFill(this.tanks[index * 4].getFill() - recipe.inputFluids[0].fill);
        }
        if (recipe.inputFluids[1] != null) {
            this.tanks[index * 4 + 1].setFill(this.tanks[index * 4 + 1].getFill() - recipe.inputFluids[1].fill);
        }
    }

    private void produceFluids(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.outputFluids[0] != null) {
            this.tanks[index * 4 + 2].setFill(this.tanks[index * 4 + 2].getFill() + recipe.outputFluids[0].fill);
        }
        if (recipe.outputFluids[1] != null) {
            this.tanks[index * 4 + 3].setFill(this.tanks[index * 4 + 3].getFill() + recipe.outputFluids[1].fill);
        }
    }

    private void consumeItems(ChemplantRecipes.ChemRecipe recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (RecipesCommon.AStack in : recipe.inputs) {
            if (in == null) continue;
            InventoryUtil.tryConsumeAStack(this.slots, indices[0], indices[1], in);
        }
    }

    private void produceItems(ChemplantRecipes.ChemRecipe recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (ItemStack out : recipe.outputs) {
            if (out == null) continue;
            InventoryUtil.tryAddItemToInventory(this.slots, indices[2], indices[3], out.func_77946_l());
        }
    }

    private void loadItems(int index) {
        int template = this.getTemplateIndex(index);
        if (this.slots[template] == null || this.slots[template].func_77973_b() != ModItems.chemistry_template) {
            return;
        }
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[template].func_77960_j());
        if (recipe != null) {
            DirPos[] positions = this.getInputPositions();
            int[] indices = this.getSlotIndicesFromIndex(index);
            for (DirPos coord : positions) {
                TileEntity te = this.field_145850_b.func_147438_o(coord.getX(), coord.getY(), coord.getZ());
                if (!(te instanceof IInventory)) continue;
                IInventory inv = (IInventory)te;
                ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
                int[] access = sided != null ? sided.func_94128_d(coord.getDir().ordinal()) : null;
                block1: for (RecipesCommon.AStack ingredient : recipe.inputs) {
                    block2: while (!InventoryUtil.doesArrayHaveIngredients(this.slots, indices[0], indices[1], ingredient)) {
                        boolean found = false;
                        for (int i = 0; i < (access != null ? access.length : inv.func_70302_i_()); ++i) {
                            int j;
                            int slot = access != null ? access[i] : i;
                            ItemStack stack = inv.func_70301_a(slot);
                            if (!ingredient.matchesRecipe(stack, true) || sided != null && !sided.func_102008_b(slot, stack, 0)) continue;
                            for (j = indices[0]; j <= indices[1]; ++j) {
                                if (this.slots[j] == null || !(this.slots[j].field_77994_a < this.slots[j].func_77976_d() & InventoryUtil.doesStackDataMatch(this.slots[j], stack))) continue;
                                inv.func_70298_a(slot, 1);
                                ++this.slots[j].field_77994_a;
                                continue block2;
                            }
                            for (j = indices[0]; j <= indices[1]; ++j) {
                                if (this.slots[j] != null) continue;
                                this.slots[j] = stack.func_77946_l();
                                this.slots[j].field_77994_a = 1;
                                inv.func_70298_a(slot, 1);
                                continue block2;
                            }
                        }
                        if (found) continue;
                        continue block1;
                    }
                }
            }
        }
    }

    private void unloadItems(int index) {
        DirPos[] positions = this.getOutputPositions();
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (DirPos coord : positions) {
            TileEntity te = this.field_145850_b.func_147438_o(coord.getX(), coord.getY(), coord.getZ());
            if (!(te instanceof IInventory)) continue;
            IInventory inv = (IInventory)te;
            ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
            int[] access = sided != null ? sided.func_94128_d(coord.getDir().ordinal()) : null;
            boolean shouldOutput = true;
            block1: while (shouldOutput) {
                shouldOutput = false;
                for (int i = indices[2]; i <= indices[3]; ++i) {
                    int slot;
                    int j;
                    ItemStack out = this.slots[i];
                    if (out == null) continue;
                    for (j = 0; j < (access != null ? access.length : inv.func_70302_i_()); ++j) {
                        ItemStack target;
                        int n = slot = access != null ? access[j] : j;
                        if (!inv.func_94041_b(slot, out) || !InventoryUtil.doesStackDataMatch(out, target = inv.func_70301_a(slot)) || target.field_77994_a >= target.func_77976_d() || target.field_77994_a >= inv.func_70297_j_()) continue;
                        int toDec = Math.min(out.field_77994_a, Math.min(target.func_77976_d(), inv.func_70297_j_()) - target.field_77994_a);
                        this.func_70298_a(i, toDec);
                        target.field_77994_a += toDec;
                        shouldOutput = true;
                        continue block1;
                    }
                    for (j = 0; j < (access != null ? access.length : inv.func_70302_i_()); ++j) {
                        int n = slot = access != null ? access[j] : j;
                        if (!inv.func_94041_b(slot, out) || inv.func_70301_a(slot) != null || !(sided != null ? sided.func_102007_a(slot, out, coord.getDir().ordinal()) : inv.func_94041_b(slot, out))) continue;
                        ItemStack copy = out.func_77946_l();
                        copy.field_77994_a = 1;
                        inv.func_70299_a(slot, copy);
                        this.func_70298_a(i, 1);
                        shouldOutput = true;
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    protected List<FluidTank> inTanks() {
        ArrayList<FluidTank> inTanks = new ArrayList<FluidTank>();
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            if (i % 4 >= 2) continue;
            inTanks.add(tank);
        }
        return inTanks;
    }

    protected List<FluidTank> outTanks() {
        ArrayList<FluidTank> outTanks = new ArrayList<FluidTank>();
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            if (i % 4 <= 1) continue;
            outTanks.add(tank);
        }
        return outTanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.inTanks().toArray(new FluidTank[0]);
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.outTanks().toArray(new FluidTank[0]);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74759_k("progress");
        if (this.progress.length == 0) {
            this.progress = new int[this.getRecipeCount()];
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74783_a("progress", this.progress);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    public abstract int getRecipeCount();

    public abstract int getTankCapacity();

    public abstract int getTemplateIndex(int var1);

    public abstract int[] getSlotIndicesFromIndex(int var1);

    public abstract DirPos[] getInputPositions();

    public abstract DirPos[] getOutputPositions();
}

