/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IBatteryItem;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineAssembler;
import com.hbm.inventory.gui.GUIMachineAssembler;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.machine.TileEntityMachineAssemblerBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Deprecated
public class TileEntityMachineAssembler
extends TileEntityMachineAssemblerBase
implements IUpgradeInfoProvider {
    public int recipe = -1;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    Random rand = new Random();
    private AudioWrapper audio;

    public TileEntityMachineAssembler() {
        super(18);
    }

    @Override
    public String getName() {
        return "container.assembler";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && itemStack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        return i == 1;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.func_145832_p() < 12) {
                int meta = this.func_145832_p();
                if (meta == 2 || meta == 14) {
                    meta = 4;
                } else if (meta == 4 || meta == 13) {
                    meta = 3;
                } else if (meta == 3 || meta == 15) {
                    meta = 5;
                } else if (meta == 5 || meta == 12) {
                    meta = 2;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.machine_assembler, dir.ordinal() + 10, 3);
                MultiblockHandlerXR.fillSpace(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((BlockDummyable)ModBlocks.machine_assembler).getDimensions(), ModBlocks.machine_assembler, dir);
                NBTTagCompound data = new NBTTagCompound();
                this.func_145841_b(data);
                this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_145839_a(data);
                return;
            }
            this.updateConnections();
            this.consumption = 100;
            this.speed = 100;
            this.upgradeManager.checkSlots(this, this.slots, 1, 3);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.speed -= speedLevel * 25;
            this.consumption += speedLevel * 300;
            this.speed += powerLevel * 5;
            this.consumption -= powerLevel * 30;
            this.speed /= overLevel + 1;
            this.consumption *= overLevel + 1;
            this.networkPackNT(150);
        } else {
            float volume = this.getVolume(2.0f);
            if (this.isProgressing && volume > 0.0f) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.updateVolume(volume);
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                    this.audio.updateVolume(volume);
                }
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        for (int i = 0; i < this.getRecipeCount(); ++i) {
            buf.writeInt(this.progress[i]);
            buf.writeInt(this.maxProgress[i]);
        }
        buf.writeBoolean(this.isProgressing);
        buf.writeInt(this.recipe);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        for (int i = 0; i < this.getRecipeCount(); ++i) {
            this.progress[i] = buf.readInt();
            this.maxProgress[i] = buf.readInt();
        }
        this.isProgressing = buf.readBoolean();
        this.recipe = buf.readInt();
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.assemblerOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 3 + dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3 + dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX * 2 + dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2 + dir.offsetZ, rot.getOpposite())};
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public int getRecipeCount() {
        return 1;
    }

    @Override
    public int getTemplateIndex(int index) {
        return 4;
    }

    @Override
    public int[] getSlotIndicesFromIndex(int index) {
        return new int[]{6, 17, 5};
    }

    @Override
    public DirPos[] getInputPositions() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 3 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 3 + rot.offsetZ, dir.getOpposite())};
    }

    @Override
    public DirPos[] getOutputPositions() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, dir)};
    }

    @Override
    public int getPowerSlot() {
        return 0;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(2.0, 1.0, 2.0);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineAssembler(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineAssembler(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_assembler));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 300 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 30 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 5 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }
}

