/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.material.Mats;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.tileentity.machine.TileEntityCrucible;
import com.hbm.wiaj.WorldInAJar;
import com.hbm.wiaj.actors.ITileActorRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderCrucible
extends TileEntitySpecialRenderer
implements IItemRendererProvider,
ITileActorRenderer {
    public static final ResourceLocation lava = new ResourceLocation("hbm", "textures/models/machines/lava.png");

    public void func_147500_a(TileEntity tile, double x, double y, double z, float interp) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        switch (tile.func_145832_p() - 10) {
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        ITileActorRenderer.bindTexture(ResourceManager.crucible_tex);
        ResourceManager.crucible_heat.renderAll();
        TileEntityCrucible crucible = (TileEntityCrucible)tile;
        if (!crucible.recipeStack.isEmpty() || !crucible.wasteStack.isEmpty()) {
            int totalCap = TileEntityCrucible.recipeZCapacity + TileEntityCrucible.wasteZCapacity;
            int totalMass = 0;
            for (Mats.MaterialStack stack : crucible.recipeStack) {
                totalMass += stack.amount;
            }
            for (Mats.MaterialStack stack : crucible.wasteStack) {
                totalMass += stack.amount;
            }
            double level = (double)totalMass / (double)totalCap * 0.875;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)64);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            ITileActorRenderer.bindTexture(lava);
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            tess.func_78382_b();
            tess.func_78374_a(-1.0, 0.5 + level, -1.0, 0.0, 0.0);
            tess.func_78374_a(-1.0, 0.5 + level, 1.0, 0.0, 1.0);
            tess.func_78374_a(1.0, 0.5 + level, 1.0, 1.0, 1.0);
            tess.func_78374_a(1.0, 0.5 + level, -1.0, 1.0, 0.0);
            tess.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @Override
    public Item getItemForRenderer() {
        return Item.func_150898_a((Block)ModBlocks.machine_crucible);
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                GL11.glTranslated((double)0.0, (double)-1.5, (double)0.0);
                GL11.glScaled((double)3.25, (double)3.25, (double)3.25);
            }

            @Override
            public void renderCommon() {
                RenderCrucible.this.func_147499_a(ResourceManager.crucible_tex);
                ResourceManager.crucible_heat.renderAll();
            }
        };
    }

    @Override
    public void renderActor(WorldInAJar world, int ticks, float interp, NBTTagCompound data) {
        int x = data.func_74762_e("x");
        int y = data.func_74762_e("y");
        int z = data.func_74762_e("z");
        this.func_147500_a(world.func_147438_o(x, y, z), x, y, z, interp);
    }

    @Override
    public void updateActor(int ticks, NBTTagCompound data) {
    }
}

