/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderFlamer
extends ItemRenderWeaponBase {
    public ResourceLocation texture;

    public ItemRenderFlamer(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.5f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderFlamer.standardAimingTransform(stack, -1.5f * offset, -1.5f * offset, 2.75f * offset, 0.0, -0.578125, 0.25);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        double scale = 0.375;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] rotate = HbmAnimations.getRelevantTransformation("ROTATE");
        GL11.glTranslated((double)0.0, (double)2.0, (double)-6.0);
        GL11.glRotated((double)(-equip[0]), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-2.0, (double)6.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotate[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        HbmAnimations.applyRelevantTransformation("Gun");
        ResourceManager.flamethrower.renderPart("Gun");
        if (this.hasShield(stack)) {
            ResourceManager.flamethrower.renderPart("HeatShield");
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        HbmAnimations.applyRelevantTransformation("Tank");
        ResourceManager.flamethrower.renderPart("Tank");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        HbmAnimations.applyRelevantTransformation("Gauge");
        GL11.glTranslated((double)1.25, (double)1.25, (double)0.0);
        IMagazine mag = gun.getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        GL11.glRotated((double)(-135.0 + (double)mag.getAmount(stack, (IInventory)MainRegistry.proxy.me().field_71071_by) * 270.0 / (double)mag.getCapacity(stack)), (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)-1.25, (double)-1.25, (double)0.0);
        ResourceManager.flamethrower.renderPart("Gauge");
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        double scale = 1.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)0.0, (double)-3.0, (double)4.0);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 1.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-1.0, (double)1.0, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -7.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type, Object ... data) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        ResourceManager.flamethrower.renderPart("Gun");
        ResourceManager.flamethrower.renderPart("Tank");
        ResourceManager.flamethrower.renderPart("Gauge");
        if (this.hasShield(stack)) {
            ResourceManager.flamethrower.renderPart("HeatShield");
        }
        GL11.glShadeModel((int)7424);
    }

    public boolean hasShield(ItemStack stack) {
        return stack.func_77973_b() == ModItems.gun_flamer_daybreaker;
    }
}

