/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.anim;

import com.hbm.interfaces.NotableComments;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.util.Clock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

@NotableComments
public class HbmAnimations {
    public static final Animation[][] hotbar = new Animation[9][8];

    public static Animation getRelevantAnim() {
        return HbmAnimations.getRelevantAnim(0);
    }

    public static Animation getRelevantAnim(int index) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        int slot = player.field_71071_by.field_70461_c;
        ItemStack stack = player.func_70694_bm();
        if (stack == null) {
            return null;
        }
        if (slot < 0 || slot > 8) {
            slot = Math.abs(slot) % 9;
        }
        if (hotbar[slot][index] == null) {
            return null;
        }
        if (HbmAnimations.hotbar[slot][index].key.equals(stack.func_77973_b().func_77658_a())) {
            return hotbar[slot][index];
        }
        return null;
    }

    public static double[] getRelevantTransformation(String bus) {
        return HbmAnimations.getRelevantTransformation(bus, 0);
    }

    public static double[] getRelevantTransformation(String bus, int index) {
        Animation anim = HbmAnimations.getRelevantAnim(index);
        if (anim != null) {
            double[] trans;
            BusAnimation buses = anim.animation;
            int millis = (int)(Clock.get_ms() - anim.startMillis);
            BusAnimationSequence seq = buses.getBus(bus);
            if (seq != null && (trans = seq.getTransformation(millis)) != null) {
                return trans;
            }
        }
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0};
    }

    public static void applyRelevantTransformation(String bus) {
        HbmAnimations.applyRelevantTransformation(bus, 0);
    }

    public static void applyRelevantTransformation(String bus, int index) {
        double[] transform = HbmAnimations.getRelevantTransformation(bus, index);
        int[] rot = new int[]{(int)transform[12], (int)transform[13], (int)transform[14]};
        GL11.glTranslated((double)transform[0], (double)transform[1], (double)transform[2]);
        GL11.glRotated((double)transform[3 + rot[0]], (double)(rot[0] == 0 ? 1.0 : 0.0), (double)(rot[0] == 1 ? 1.0 : 0.0), (double)(rot[0] == 2 ? 1.0 : 0.0));
        GL11.glRotated((double)transform[3 + rot[1]], (double)(rot[1] == 0 ? 1.0 : 0.0), (double)(rot[1] == 1 ? 1.0 : 0.0), (double)(rot[1] == 2 ? 1.0 : 0.0));
        GL11.glRotated((double)transform[3 + rot[2]], (double)(rot[2] == 0 ? 1.0 : 0.0), (double)(rot[2] == 1 ? 1.0 : 0.0), (double)(rot[2] == 2 ? 1.0 : 0.0));
        GL11.glTranslated((double)(-transform[9]), (double)(-transform[10]), (double)(-transform[11]));
        GL11.glScaled((double)transform[6], (double)transform[7], (double)transform[8]);
    }

    public static class Animation {
        public String key;
        public long startMillis;
        public BusAnimation animation;
        public boolean holdLastFrame = false;

        public Animation(String key, long startMillis, BusAnimation animation) {
            this.key = key;
            this.startMillis = startMillis;
            this.animation = animation;
        }

        public Animation(String key, long startMillis, BusAnimation animation, boolean holdLastFrame) {
            this(key, startMillis, animation);
            this.holdLastFrame = holdLastFrame;
        }
    }
}

