/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.helper;

import com.hbm.particle.ParticleDebris;
import com.hbm.particle.ParticleMukeWave;
import com.hbm.particle.ParticleRocketFlame;
import com.hbm.particle.helper.IParticleCreator;
import com.hbm.wiaj.WorldInAJar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ExplosionCreator
implements IParticleCreator {
    public static final double speedOfSound = 8.575;

    public static void composeEffect(World world, double x, double y, double z, int cloudCount, float cloudScale, float cloudSpeedMult, float waveScale, int debrisCount, int debrisSize, int debrisRetry, float debrisVelocity, float debrisHorizontalDeviation, float debrisVerticalOffset, float soundRange) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "explosionLarge");
        data.func_74774_a("cloudCount", (byte)cloudCount);
        data.func_74776_a("cloudScale", cloudScale);
        data.func_74776_a("cloudSpeedMult", cloudSpeedMult);
        data.func_74776_a("waveScale", waveScale);
        data.func_74774_a("debrisCount", (byte)debrisCount);
        data.func_74774_a("debrisSize", (byte)debrisSize);
        data.func_74777_a("debrisRetry", (short)((byte)debrisRetry));
        data.func_74776_a("debrisVelocity", debrisVelocity);
        data.func_74776_a("debrisHorizontalDeviation", debrisHorizontalDeviation);
        data.func_74776_a("debrisVerticalOffset", debrisVerticalOffset);
        data.func_74776_a("soundRange", soundRange);
        IParticleCreator.sendPacket(world, x, y, z, Math.max(300, (int)soundRange), data);
    }

    public static void composeEffectSmall(World world, double x, double y, double z) {
        ExplosionCreator.composeEffect(world, x, y, z, 10, 2.0f, 0.5f, 25.0f, 5, 8, 20, 0.75f, 1.0f, -2.0f, 150.0f);
    }

    public static void composeEffectStandard(World world, double x, double y, double z) {
        ExplosionCreator.composeEffect(world, x, y, z, 15, 5.0f, 1.0f, 45.0f, 10, 16, 50, 1.0f, 3.0f, -2.0f, 200.0f);
    }

    public static void composeEffectLarge(World world, double x, double y, double z) {
        ExplosionCreator.composeEffect(world, x, y, z, 30, 6.5f, 2.0f, 65.0f, 25, 16, 50, 1.25f, 3.0f, -2.0f, 350.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void makeParticle(World world, EntityPlayer player, TextureManager man, Random rand, double x, double y, double z, NBTTagCompound data) {
        int cloudCount = data.func_74771_c("cloudCount");
        float cloudScale = data.func_74760_g("cloudScale");
        float cloudSpeedMult = data.func_74760_g("cloudSpeedMult");
        float waveScale = data.func_74760_g("waveScale");
        int debrisCount = data.func_74771_c("debrisCount");
        byte debrisSize = data.func_74771_c("debrisSize");
        int debrisRetry = data.func_74765_d("debrisRetry");
        float debrisVelocity = data.func_74760_g("debrisVelocity");
        float debrisHorizontalDeviation = data.func_74760_g("debrisHorizontalDeviation");
        float debrisVerticalOffset = data.func_74760_g("debrisVerticalOffset");
        float soundRange = data.func_74760_g("soundRange");
        float dist = (float)player.func_70011_f(x, y, z);
        if (dist <= soundRange) {
            String sound = (double)dist <= (double)soundRange * 0.4 ? "hbm:weapon.explosionLargeNear" : "hbm:weapon.explosionLargeFar";
            PositionedSoundRecord positionedsoundrecord = new PositionedSoundRecord(new ResourceLocation(sound), 1000.0f, 0.9f + rand.nextFloat() * 0.2f, (float)x, (float)y, (float)z);
            Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)positionedsoundrecord, (int)((double)dist / 8.575));
        }
        ParticleMukeWave wave = new ParticleMukeWave(man, world, x, y + 2.0, z);
        wave.setup(waveScale, (int)(25.0f * waveScale / 45.0f));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)wave);
        for (int i = 0; i < cloudCount; ++i) {
            ParticleRocketFlame fx = new ParticleRocketFlame(man, world, x, y, z).setScale(cloudScale);
            fx.field_70169_q = fx.field_70165_t;
            fx.field_70167_r = fx.field_70163_u;
            fx.field_70166_s = fx.field_70161_v;
            fx.field_70159_w = rand.nextGaussian() * 0.5 * (double)cloudSpeedMult;
            fx.field_70181_x = rand.nextDouble() * 3.0 * (double)cloudSpeedMult;
            fx.field_70179_y = rand.nextGaussian() * 0.5 * (double)cloudSpeedMult;
            fx.setMaxAge(70 + rand.nextInt(20));
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (int c = 0; c < debrisCount; ++c) {
            WorldInAJar wiaj;
            double oX = rand.nextGaussian() * (double)debrisHorizontalDeviation;
            double oY = debrisVerticalOffset;
            double oZ = rand.nextGaussian() * (double)debrisHorizontalDeviation;
            int cX = (int)Math.floor(x + oX + 0.5);
            int cY = (int)Math.floor(y + oY + 0.5);
            int cZ = (int)Math.floor(z + oZ + 0.5);
            Vec3 motion = Vec3.func_72443_a((double)debrisVelocity, (double)0.0, (double)0.0);
            motion.func_72446_c((float)(-Math.toRadians(45.0f + rand.nextFloat() * 25.0f)));
            motion.func_72442_b((float)(rand.nextDouble() * Math.PI * 2.0));
            ParticleDebris particle = new ParticleDebris(world, x, y, z, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
            particle.world = wiaj = new WorldInAJar(debrisSize, debrisSize, debrisSize);
            if (debrisSize > 0) {
                int middle = debrisSize / 2 - 1;
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        for (int k = 0; k < 2; ++k) {
                            wiaj.setBlock(middle + i, middle + j, middle + k, world.func_147439_a(cX + i, cY + j, cZ + k), world.func_72805_g(cX + i, cY + j, cZ + k));
                        }
                    }
                }
                for (int layer = 2; layer <= debrisSize / 2; ++layer) {
                    for (int i = 0; i < debrisRetry; ++i) {
                        int jz;
                        int jy;
                        int jx = -layer + rand.nextInt(layer * 2 + 1);
                        if (wiaj.func_147439_a(middle + jx + 1, middle + (jy = -layer + rand.nextInt(layer * 2 + 1)), middle + (jz = -layer + rand.nextInt(layer * 2 + 1))) == Blocks.field_150350_a && wiaj.func_147439_a(middle + jx - 1, middle + jy, middle + jz) == Blocks.field_150350_a && wiaj.func_147439_a(middle + jx, middle + jy + 1, middle + jz) == Blocks.field_150350_a && wiaj.func_147439_a(middle + jx, middle + jy - 1, middle + jz) == Blocks.field_150350_a && wiaj.func_147439_a(middle + jx, middle + jy, middle + jz + 1) == Blocks.field_150350_a && wiaj.func_147439_a(middle + jx, middle + jy, middle + jz - 1) == Blocks.field_150350_a) continue;
                        Block b = world.func_147439_a(cX + jx, cY + jy, cZ + jz);
                        int m = world.func_72805_g(cX + jx, cY + jy, cZ + jz);
                        wiaj.setBlock(middle + jx, middle + jy, middle + jz, b, m);
                    }
                }
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
    }
}

